/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.nio.ascii.MemcacheTextDecoder;
import com.hazelcast.internal.nio.ascii.RestApiTextDecoder;
import com.hazelcast.internal.server.tcp.SingleProtocolDecoder;
import com.hazelcast.internal.server.tcp.SingleProtocolEncoder;
import java.nio.ByteBuffer;

public class TextHandshakeDecoder
extends SingleProtocolDecoder {
    public TextHandshakeDecoder(ProtocolType supportedProtocol, InboundHandler next, SingleProtocolEncoder encoder) {
        super(supportedProtocol, next, encoder);
    }

    @Override
    protected void verifyProtocol(String incomingProtocol) {
        if (ProtocolType.REST.equals((Object)this.supportedProtocol)) {
            if (!RestApiTextDecoder.TEXT_PARSERS.isCommandPrefix(incomingProtocol)) {
                throw new IllegalStateException("Unsupported protocol exchange detected, expected protocol: REST");
            }
        } else if (!MemcacheTextDecoder.TEXT_PARSERS.isCommandPrefix(incomingProtocol)) {
            throw new IllegalStateException("Unsupported protocol exchange detected, expected protocol: MEMCACHED");
        }
    }

    @Override
    protected void setupNextDecoder() {
        super.setupNextDecoder();
        ByteBuffer src = (ByteBuffer)this.src;
        ByteBuffer dst = (ByteBuffer)this.inboundHandlers[0].src();
        src.flip();
        dst.put(src);
    }
}

