/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Comparator;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SchemaWriter
implements CompactWriter {
    private final TreeMap<String, FieldDescriptor> fieldDefinitionMap = new TreeMap(Comparator.naturalOrder());
    private final String className;

    public SchemaWriter(String className) {
        this.className = className;
    }

    public Schema build() {
        return new Schema(this.className, this.fieldDefinitionMap);
    }

    public void addField(FieldDescriptor fieldDefinition) {
        this.fieldDefinitionMap.put(fieldDefinition.getFieldName(), fieldDefinition);
    }

    @Override
    public void writeInt(@Nonnull String fieldName, int value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.INT));
    }

    @Override
    public void writeLong(@Nonnull String fieldName, long value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.LONG));
    }

    @Override
    public void writeString(@Nonnull String fieldName, String str) {
        this.addField(new FieldDescriptor(fieldName, FieldType.UTF));
    }

    @Override
    public void writeBoolean(@Nonnull String fieldName, boolean value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.BOOLEAN));
    }

    @Override
    public void writeByte(@Nonnull String fieldName, byte value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.BYTE));
    }

    @Override
    public void writeChar(@Nonnull String fieldName, char value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.CHAR));
    }

    @Override
    public void writeDouble(@Nonnull String fieldName, double value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.DOUBLE));
    }

    @Override
    public void writeFloat(@Nonnull String fieldName, float value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.FLOAT));
    }

    @Override
    public void writeShort(@Nonnull String fieldName, short value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.SHORT));
    }

    public void writeObject(@Nonnull String fieldName, @Nullable Object object) {
        this.addField(new FieldDescriptor(fieldName, FieldType.COMPOSED));
    }

    @Override
    public void writeDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.DECIMAL));
    }

    @Override
    public void writeTime(@Nonnull String fieldName, @Nonnull LocalTime value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.TIME));
    }

    @Override
    public void writeDate(@Nonnull String fieldName, @Nonnull LocalDate value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.DATE));
    }

    @Override
    public void writeTimestamp(@Nonnull String fieldName, @Nonnull LocalDateTime value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.TIMESTAMP));
    }

    @Override
    public void writeTimestampWithTimezone(@Nonnull String fieldName, @Nonnull OffsetDateTime value) {
        this.addField(new FieldDescriptor(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE));
    }

    @Override
    public void writeByteArray(@Nonnull String fieldName, @Nullable byte[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.BYTE_ARRAY));
    }

    @Override
    public void writeBooleanArray(@Nonnull String fieldName, @Nullable boolean[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.BOOLEAN_ARRAY));
    }

    @Override
    public void writeCharArray(@Nonnull String fieldName, @Nullable char[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.CHAR_ARRAY));
    }

    @Override
    public void writeIntArray(@Nonnull String fieldName, @Nullable int[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.INT_ARRAY));
    }

    @Override
    public void writeLongArray(@Nonnull String fieldName, @Nullable long[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.LONG_ARRAY));
    }

    @Override
    public void writeDoubleArray(@Nonnull String fieldName, @Nullable double[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.DOUBLE_ARRAY));
    }

    @Override
    public void writeFloatArray(@Nonnull String fieldName, @Nullable float[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.FLOAT_ARRAY));
    }

    @Override
    public void writeShortArray(@Nonnull String fieldName, @Nullable short[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.SHORT_ARRAY));
    }

    @Override
    public void writeStringArray(@Nonnull String fieldName, @Nullable String[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.UTF_ARRAY));
    }

    @Override
    public void writeDecimalArray(@Nonnull String fieldName, @Nullable BigDecimal[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.DECIMAL_ARRAY));
    }

    @Override
    public void writeTimeArray(@Nonnull String fieldName, @Nullable LocalTime[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.TIME_ARRAY));
    }

    @Override
    public void writeDateArray(@Nonnull String fieldName, @Nullable LocalDate[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.DATE_ARRAY));
    }

    @Override
    public void writeTimestampArray(@Nonnull String fieldName, @Nullable LocalDateTime[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.TIMESTAMP_ARRAY));
    }

    @Override
    public void writeTimestampWithTimezoneArray(@Nonnull String fieldName, @Nullable OffsetDateTime[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY));
    }

    public void writeObjectArray(@Nonnull String fieldName, @Nullable Object[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldType.COMPOSED_ARRAY));
    }
}

