/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.OffsetReader;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CompactInternalGenericRecord
extends CompactGenericRecord
implements InternalGenericRecord {
    private final OffsetReader offsetReader;
    private final Schema schema;
    private final BufferObjectDataInput in;
    private final int finalPosition;
    private final int dataStartPosition;
    private final int variableOffsetsPosition;
    private final CompactStreamSerializer serializer;
    private final boolean schemaIncludedInBinary;
    @Nullable
    private final Class associatedClass;

    public CompactInternalGenericRecord(CompactStreamSerializer serializer, BufferObjectDataInput in, Schema schema, @Nullable Class associatedClass, boolean schemaIncludedInBinary) {
        this.in = in;
        this.serializer = serializer;
        this.schema = schema;
        this.associatedClass = associatedClass;
        this.schemaIncludedInBinary = schemaIncludedInBinary;
        try {
            int numberOfVariableLengthFields = schema.getNumberOfVariableSizeFields();
            if (numberOfVariableLengthFields != 0) {
                int dataLength = in.readInt();
                this.dataStartPosition = in.position();
                this.variableOffsetsPosition = this.dataStartPosition + dataLength;
                if (dataLength < 255) {
                    this.offsetReader = OffsetReader.BYTE_OFFSET_READER;
                    this.finalPosition = this.variableOffsetsPosition + numberOfVariableLengthFields;
                } else if (dataLength < 65535) {
                    this.offsetReader = OffsetReader.SHORT_OFFSET_READER;
                    this.finalPosition = this.variableOffsetsPosition + numberOfVariableLengthFields * 2;
                } else {
                    this.offsetReader = OffsetReader.INT_OFFSET_READER;
                    this.finalPosition = this.variableOffsetsPosition + numberOfVariableLengthFields * 4;
                }
                in.position(this.finalPosition);
            } else {
                this.offsetReader = OffsetReader.INT_OFFSET_READER;
                this.variableOffsetsPosition = 0;
                this.dataStartPosition = in.position();
                this.finalPosition = this.dataStartPosition + schema.getFixedSizeFieldsLength();
            }
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Nullable
    public Class getAssociatedClass() {
        return this.associatedClass;
    }

    public BufferObjectDataInput getIn() {
        return this.in;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder newBuilder() {
        return this.serializer.createGenericRecordBuilder(this.schema);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder cloneWithBuilder() {
        return this.serializer.createGenericRecordCloner(this.schema, this);
    }

    @Override
    @Nonnull
    public FieldType getFieldType(@Nonnull String fieldName) {
        return this.schema.getField(fieldName).getType();
    }

    @Override
    public boolean hasField(@Nonnull String fieldName) {
        return this.schema.hasField(fieldName);
    }

    @Override
    @Nonnull
    public Set<String> getFieldNames() {
        return this.schema.getFieldNames();
    }

    @Override
    public byte getByte(@Nonnull String fieldName) {
        try {
            return this.in.readByte(this.readFixedSizePosition(fieldName, FieldType.BYTE));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    boolean isFieldExists(@Nonnull String fieldName, @Nonnull FieldType type) {
        FieldDescriptor field = this.schema.getField(fieldName);
        if (field == null) {
            return false;
        }
        return field.getType().equals((Object)type);
    }

    @Override
    public short getShort(@Nonnull String fieldName) {
        try {
            return this.in.readShort(this.readFixedSizePosition(fieldName, FieldType.SHORT));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public int getInt(@Nonnull String fieldName) {
        try {
            return this.in.readInt(this.readFixedSizePosition(fieldName, FieldType.INT));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public long getLong(@Nonnull String fieldName) {
        try {
            return this.in.readLong(this.readFixedSizePosition(fieldName, FieldType.LONG));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public float getFloat(@Nonnull String fieldName) {
        try {
            return this.in.readFloat(this.readFixedSizePosition(fieldName, FieldType.FLOAT));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public double getDouble(@Nonnull String fieldName) {
        try {
            return this.in.readDouble(this.readFixedSizePosition(fieldName, FieldType.DOUBLE));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public boolean getBoolean(@Nonnull String fieldName) {
        try {
            FieldDescriptor fd = this.getFieldDefinition(fieldName, FieldType.BOOLEAN);
            int booleanOffset = fd.getOffset();
            byte bitOffset = fd.getBitOffset();
            int getOffset = booleanOffset + this.dataStartPosition;
            byte lastByte = this.in.readByte(getOffset);
            return (lastByte >>> bitOffset & 1) != 0;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public char getChar(@Nonnull String fieldName) {
        try {
            return this.in.readChar(this.readFixedSizePosition(fieldName, FieldType.CHAR));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public String getString(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.UTF, ObjectDataInput::readString);
    }

    private <T> T getVariableLength(@Nonnull String fieldName, FieldType fieldType, Reader<T> reader) {
        int currentPos = this.in.position();
        try {
            int pos = this.readVariableSizeFieldPosition(fieldName, fieldType);
            if (pos == -1) {
                T t = null;
                return t;
            }
            this.in.position(pos);
            T t = reader.read(this.in);
            return t;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public BigDecimal getDecimal(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.DECIMAL, IOUtil::readBigDecimal);
    }

    @Override
    @Nonnull
    public LocalTime getTime(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            this.in.position(this.readFixedSizePosition(fieldName, FieldType.TIME));
            LocalTime localTime = IOUtil.readLocalTime(this.in);
            return localTime;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    @Nonnull
    public LocalDate getDate(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            this.in.position(this.readFixedSizePosition(fieldName, FieldType.DATE));
            LocalDate localDate = IOUtil.readLocalDate(this.in);
            return localDate;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    @Nonnull
    public LocalDateTime getTimestamp(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            this.in.position(this.readFixedSizePosition(fieldName, FieldType.TIMESTAMP));
            LocalDateTime localDateTime = IOUtil.readLocalDateTime(this.in);
            return localDateTime;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    @Nonnull
    public OffsetDateTime getTimestampWithTimezone(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            this.in.position(this.readFixedSizePosition(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE));
            OffsetDateTime offsetDateTime = IOUtil.readOffsetDateTime(this.in);
            return offsetDateTime;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public GenericRecord getGenericRecord(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.COMPOSED, in -> this.serializer.readGenericRecord(in, this.schemaIncludedInBinary));
    }

    @Override
    public <T> T getObject(@Nonnull String fieldName) {
        return (T)this.getVariableLength(fieldName, FieldType.COMPOSED, in -> this.serializer.read(in, this.schemaIncludedInBinary));
    }

    @Override
    public byte[] getByteArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.BYTE_ARRAY, ObjectDataInput::readByteArray);
    }

    @Override
    public boolean[] getBooleanArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.BOOLEAN_ARRAY, CompactInternalGenericRecord::readBooleanBits);
    }

    @Override
    public char[] getCharArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.CHAR_ARRAY, ObjectDataInput::readCharArray);
    }

    @Override
    public int[] getIntArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.INT_ARRAY, ObjectDataInput::readIntArray);
    }

    @Override
    public long[] getLongArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.LONG_ARRAY, ObjectDataInput::readLongArray);
    }

    @Override
    public double[] getDoubleArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.DOUBLE_ARRAY, ObjectDataInput::readDoubleArray);
    }

    @Override
    public float[] getFloatArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.FLOAT_ARRAY, ObjectDataInput::readFloatArray);
    }

    @Override
    public short[] getShortArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.SHORT_ARRAY, ObjectDataInput::readShortArray);
    }

    @Override
    public String[] getStringArray(@Nonnull String fieldName) {
        return this.getVariableSizeArray(fieldName, FieldType.UTF_ARRAY, String[]::new, ObjectDataInput::readString);
    }

    @Override
    public BigDecimal[] getDecimalArray(@Nonnull String fieldName) {
        return this.getVariableSizeArray(fieldName, FieldType.DECIMAL_ARRAY, BigDecimal[]::new, IOUtil::readBigDecimal);
    }

    @Override
    public LocalTime[] getTimeArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.TIME_ARRAY, CompactInternalGenericRecord::getTimeArray);
    }

    @Override
    public LocalDate[] getDateArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.DATE_ARRAY, CompactInternalGenericRecord::getDateArray);
    }

    @Override
    public LocalDateTime[] getTimestampArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.TIMESTAMP_ARRAY, CompactInternalGenericRecord::getTimestampArray);
    }

    @Override
    public OffsetDateTime[] getTimestampWithTimezoneArray(@Nonnull String fieldName) {
        return this.getVariableLength(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY, CompactInternalGenericRecord::getTimestampWithTimezoneArray);
    }

    @Override
    public GenericRecord[] getGenericRecordArray(@Nonnull String fieldName) {
        return this.getVariableSizeArray(fieldName, FieldType.COMPOSED_ARRAY, GenericRecord[]::new, in -> this.serializer.readGenericRecord(in, this.schemaIncludedInBinary));
    }

    @Override
    public <T> T[] getObjectArray(@Nonnull String fieldName, Class<T> componentType) {
        return this.getVariableSizeArray(fieldName, FieldType.COMPOSED_ARRAY, length -> (Object[])Array.newInstance(componentType, (int)length), in -> this.serializer.read(in, this.schemaIncludedInBinary));
    }

    private <T> T[] getVariableSizeArray(@Nonnull String fieldName, FieldType fieldType, Function<Integer, T[]> constructor, Reader<T> reader) {
        int currentPos = this.in.position();
        try {
            int position = this.readVariableSizeFieldPosition(fieldName, fieldType);
            if (position == -1) {
                T[] TArray = null;
                return TArray;
            }
            this.in.position(position);
            int itemCount = this.in.readInt();
            int dataLength = this.in.readInt();
            int dataStartPosition = this.in.position();
            T[] values = constructor.apply(itemCount);
            OffsetReader offsetReader = CompactInternalGenericRecord.getOffsetReader(dataLength);
            int offsetsPosition = dataStartPosition + dataLength;
            for (int i = 0; i < itemCount; ++i) {
                int offset = offsetReader.getOffset(this.in, offsetsPosition, i);
                if (offset == -1) continue;
                this.in.position(offset + dataStartPosition);
                values[i] = reader.read(this.in);
            }
            T[] TArray = values;
            return TArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private static OffsetReader getOffsetReader(int dataLength) {
        if (dataLength < 255) {
            return OffsetReader.BYTE_OFFSET_READER;
        }
        if (dataLength < 65535) {
            return OffsetReader.SHORT_OFFSET_READER;
        }
        return OffsetReader.INT_OFFSET_READER;
    }

    private int readFixedSizePosition(@Nonnull String fieldName, FieldType fieldType) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName, fieldType);
        int primitiveOffset = fd.getOffset();
        return primitiveOffset + this.dataStartPosition;
    }

    @Nonnull
    private FieldDescriptor getFieldDefinition(@Nonnull String fieldName, FieldType fieldType) {
        FieldDescriptor fd = this.schema.getField(fieldName);
        if (fd == null) {
            throw this.throwUnknownFieldException(fieldName);
        }
        if (fd.getType() != fieldType) {
            throw new HazelcastSerializationException("Not a '" + (Object)((Object)fieldType) + "' field: " + fieldName);
        }
        return fd;
    }

    private int readVariableSizeFieldPosition(@Nonnull String fieldName, FieldType fieldType) {
        try {
            FieldDescriptor fd = this.getFieldDefinition(fieldName, fieldType);
            int index = fd.getIndex();
            int offset = this.offsetReader.getOffset(this.in, this.variableOffsetsPosition, index);
            return offset == -1 ? -1 : offset + this.dataStartPosition;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    private HazelcastSerializationException throwUnknownFieldException(@Nonnull String fieldName) {
        return new HazelcastSerializationException("Unknown field name: '" + fieldName + "' for " + this.schema);
    }

    private int readLength(int beginPosition) {
        try {
            return this.in.readInt(beginPosition);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public Byte getByteFromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldType.BYTE_ARRAY, DataInput::readByte, index);
    }

    @Override
    public Boolean getBooleanFromArray(@Nonnull String fieldName, int index) {
        int position = this.readVariableSizeFieldPosition(fieldName, FieldType.BOOLEAN_ARRAY);
        if (position == -1) {
            return null;
        }
        if (this.readLength(position) <= index) {
            return null;
        }
        int currentPos = this.in.position();
        try {
            int booleanOffsetInBytes = index / 8;
            int booleanOffsetWithinLastByte = index % 8;
            byte b = this.in.readByte(4 + position + booleanOffsetInBytes);
            Boolean bl = (b >>> booleanOffsetWithinLastByte & 1) != 0;
            return bl;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public Character getCharFromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldType.CHAR_ARRAY, DataInput::readChar, index);
    }

    @Override
    public Integer getIntFromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldType.INT_ARRAY, DataInput::readInt, index);
    }

    @Override
    public Long getLongFromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldType.LONG_ARRAY, DataInput::readLong, index);
    }

    @Override
    public Double getDoubleFromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldType.DOUBLE_ARRAY, DataInput::readDouble, index);
    }

    @Override
    public Float getFloatFromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldType.FLOAT_ARRAY, DataInput::readFloat, index);
    }

    @Override
    public Short getShortFromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldType.SHORT_ARRAY, DataInput::readShort, index);
    }

    private <T> T getFixedSizeFieldFromArray(@Nonnull String fieldName, FieldType fieldType, Reader<T> reader, int index) {
        Preconditions.checkNotNegative(index, "Array indexes can not be negative");
        int position = this.readVariableSizeFieldPosition(fieldName, fieldType);
        if (position == -1) {
            return null;
        }
        if (this.readLength(position) <= index) {
            return null;
        }
        int currentPos = this.in.position();
        try {
            FieldType singleType = fieldType.getSingleType();
            int typeSize = FieldOperations.fieldOperations(singleType).typeSizeInBytes();
            this.in.position(4 + position + index * typeSize);
            T t = reader.read(this.in);
            return t;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public String getStringFromArray(@Nonnull String fieldName, int index) {
        return this.getVarSizeFromArray(fieldName, FieldType.UTF_ARRAY, ObjectDataInput::readString, index);
    }

    @Override
    public GenericRecord getGenericRecordFromArray(@Nonnull String fieldName, int index) {
        return this.getVarSizeFromArray(fieldName, FieldType.COMPOSED_ARRAY, in -> this.serializer.readGenericRecord(in, this.schemaIncludedInBinary), index);
    }

    @Override
    public BigDecimal getDecimalFromArray(@Nonnull String fieldName, int index) {
        return this.getVarSizeFromArray(fieldName, FieldType.DECIMAL_ARRAY, IOUtil::readBigDecimal, index);
    }

    @Override
    public LocalTime getTimeFromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldType.TIME_ARRAY, IOUtil::readLocalTime, index);
    }

    @Override
    public LocalDate getDateFromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldType.DATE_ARRAY, IOUtil::readLocalDate, index);
    }

    @Override
    public LocalDateTime getTimestampFromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldType.TIMESTAMP_ARRAY, IOUtil::readLocalDateTime, index);
    }

    @Override
    public OffsetDateTime getTimestampWithTimezoneFromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY, IOUtil::readOffsetDateTime, index);
    }

    @Override
    public Object getObjectFromArray(@Nonnull String fieldName, int index) {
        return this.getVarSizeFromArray(fieldName, FieldType.COMPOSED_ARRAY, in -> this.serializer.read(in, this.schemaIncludedInBinary), index);
    }

    private <T> T getVarSizeFromArray(@Nonnull String fieldName, FieldType fieldType, Reader<T> reader, int index) {
        int currentPos = this.in.position();
        try {
            int offsetsPosition;
            int pos = this.readVariableSizeFieldPosition(fieldName, fieldType);
            if (pos == -1) {
                T t = null;
                return t;
            }
            int itemCount = this.in.readInt(pos);
            Preconditions.checkNotNegative(index, "Array index can not be negative");
            if (itemCount <= index) {
                T t = null;
                return t;
            }
            int dataLength = this.in.readInt(pos + 4);
            int dataStartPosition = pos + 8;
            OffsetReader offsetReader = CompactInternalGenericRecord.getOffsetReader(dataLength);
            int indexedItemOffset = offsetReader.getOffset(this.in, offsetsPosition = dataStartPosition + dataLength, index);
            if (indexedItemOffset != -1) {
                this.in.position(indexedItemOffset + dataStartPosition);
                T t = reader.read(this.in);
                return t;
            }
            T t = null;
            return t;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    protected Object getClassIdentifier() {
        return this.schema.getTypeName();
    }

    protected IllegalStateException illegalStateException(IOException e) {
        return new IllegalStateException("IOException is not expected since we get from a well known format and position");
    }

    private static LocalDate[] getDateArray(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        LocalDate[] values = new LocalDate[len];
        for (int i = 0; i < len; ++i) {
            values[i] = IOUtil.readLocalDate(in);
        }
        return values;
    }

    private static LocalTime[] getTimeArray(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        LocalTime[] values = new LocalTime[len];
        for (int i = 0; i < len; ++i) {
            values[i] = IOUtil.readLocalTime(in);
        }
        return values;
    }

    private static LocalDateTime[] getTimestampArray(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        LocalDateTime[] values = new LocalDateTime[len];
        for (int i = 0; i < len; ++i) {
            values[i] = IOUtil.readLocalDateTime(in);
        }
        return values;
    }

    private static OffsetDateTime[] getTimestampWithTimezoneArray(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        OffsetDateTime[] values = new OffsetDateTime[len];
        for (int i = 0; i < len; ++i) {
            values[i] = IOUtil.readOffsetDateTime(in);
        }
        return values;
    }

    private static boolean[] readBooleanBits(BufferObjectDataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new boolean[0];
        }
        boolean[] values = new boolean[len];
        int index = 0;
        byte currentByte = input.readByte();
        for (int i = 0; i < len; ++i) {
            if (index == 8) {
                index = 0;
                currentByte = input.readByte();
            }
            boolean result = (currentByte >>> index & 1) != 0;
            ++index;
            values[i] = result;
        }
        return values;
    }

    protected static interface Reader<R> {
        public R read(BufferObjectDataInput var1) throws IOException;
    }
}

