/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.util.StringUtil;
import java.io.PrintWriter;

class SingleLineDiagnosticsLogWriter
extends DiagnosticsLogWriter {
    private boolean firstEntry = true;

    SingleLineDiagnosticsLogWriter() {
    }

    @Override
    public void startSection(String name) {
        if (this.sectionLevel == -1) {
            this.appendDateTime();
            this.write(' ');
        }
        this.appendComma();
        this.write(name).write('[');
        this.firstEntry = true;
        ++this.sectionLevel;
    }

    @Override
    public void endSection() {
        this.write(']');
        --this.sectionLevel;
        if (this.sectionLevel == -1) {
            this.write(StringUtil.LINE_SEPARATOR);
        }
    }

    @Override
    public void writeEntry(String s) {
        this.appendComma();
        this.write(s);
    }

    private void appendComma() {
        if (this.firstEntry) {
            this.firstEntry = false;
        } else {
            this.write(',');
        }
    }

    @Override
    public void writeKeyValueEntry(String key, String value) {
        this.appendComma();
        this.write(key).write('=').write(value);
    }

    @Override
    public void writeKeyValueEntry(String key, double value) {
        this.appendComma();
        this.write(key).write('=').write(value);
    }

    @Override
    public void writeKeyValueEntry(String key, long value) {
        this.appendComma();
        this.write(key).write('=').write(value);
    }

    @Override
    public void writeKeyValueEntry(String key, boolean value) {
        this.appendComma();
        this.write(key).write('=').write(value);
    }

    @Override
    protected void init(PrintWriter writer) {
        this.firstEntry = true;
        super.init(writer);
    }
}

