/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.operation;

import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.operation.QueryExecuteOperationFragmentMapping;
import com.hazelcast.sql.impl.plan.node.PlanNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;

public class QueryExecuteOperationFragment
implements IdentifiedDataSerializable {
    private PlanNode node;
    private QueryExecuteOperationFragmentMapping mapping;
    private Collection<UUID> memberIds;

    public QueryExecuteOperationFragment() {
    }

    public QueryExecuteOperationFragment(PlanNode node, QueryExecuteOperationFragmentMapping mapping, Collection<UUID> memberIds) {
        this.node = node;
        this.mapping = mapping;
        this.memberIds = memberIds;
    }

    public PlanNode getNode() {
        return this.node;
    }

    public QueryExecuteOperationFragmentMapping getMapping() {
        return this.mapping;
    }

    public Collection<UUID> getMemberIds() {
        return this.memberIds;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.node);
        out.writeInt(this.mapping.getId());
        if (this.memberIds != null) {
            out.writeInt(this.memberIds.size());
            for (UUID mappedMemberId : this.memberIds) {
                UUIDSerializationUtil.writeUUID(out, mappedMemberId);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.node = (PlanNode)in.readObject();
        this.mapping = QueryExecuteOperationFragmentMapping.getById(in.readInt());
        int mappedMemberIdsSize = in.readInt();
        if (mappedMemberIdsSize > 0) {
            this.memberIds = new ArrayList<UUID>(mappedMemberIdsSize);
            for (int i = 0; i < mappedMemberIdsSize; ++i) {
                this.memberIds.add(UUIDSerializationUtil.readUUID(in));
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.node, this.memberIds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryExecuteOperationFragment fragment = (QueryExecuteOperationFragment)o;
        return Objects.equals(this.node, fragment.node) && Objects.equals(this.memberIds, fragment.memberIds);
    }
}

