/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan.index;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.exec.scan.KeyValueIterator;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Iterator;
import java.util.List;

public class MapIndexScanExecIterator
implements KeyValueIterator {
    private final Iterator<QueryableEntry> iterator;
    private Data currentKey;
    private Object currentValue;
    private Data nextKey;
    private Object nextValue;

    public MapIndexScanExecIterator(String mapName, InternalIndex index, int expectedComponentCount, IndexFilter indexFilter, List<QueryDataType> expectedConverterTypes, ExpressionEvalContext evalContext) {
        this.iterator = this.getIndexEntries(mapName, index, indexFilter, evalContext, expectedComponentCount, expectedConverterTypes);
        this.advance0();
    }

    @Override
    public boolean tryAdvance() {
        if (!this.done()) {
            this.currentKey = this.nextKey;
            this.currentValue = this.nextValue;
            this.advance0();
            return true;
        }
        return false;
    }

    @Override
    public boolean done() {
        return this.nextKey == null;
    }

    @Override
    public Object getKey() {
        return this.currentKey;
    }

    @Override
    public Object getValue() {
        return this.currentValue;
    }

    private void advance0() {
        if (this.iterator.hasNext()) {
            QueryableEntry entry = this.iterator.next();
            this.nextKey = entry.getKeyData();
            this.nextValue = entry.getValue();
        } else {
            this.nextKey = null;
            this.nextValue = null;
        }
    }

    private Iterator<QueryableEntry> getIndexEntries(String mapName, InternalIndex index, IndexFilter indexFilter, ExpressionEvalContext evalContext, int expectedComponentCount, List<QueryDataType> expectedConverterTypes) {
        if (indexFilter == null) {
            return index.getSqlRecordIterator();
        }
        int actualComponentCount = index.getComponents().length;
        if (actualComponentCount != expectedComponentCount) {
            throw QueryException.error(1009, "Cannot use the index \"" + index.getName() + "\" of the IMap \"" + mapName + "\" because it has " + actualComponentCount + " component(s), but " + expectedComponentCount + " expected").markInvalidate();
        }
        List<QueryDataType> currentConverterTypes = MapTableUtils.indexConverterToSqlTypes(index.getConverter());
        this.validateConverterTypes(index, mapName, expectedConverterTypes, currentConverterTypes);
        return indexFilter.getEntries(index, evalContext);
    }

    private void validateConverterTypes(InternalIndex index, String mapName, List<QueryDataType> expectedConverterTypes, List<QueryDataType> actualConverterTypes) {
        for (int i = 0; i < Math.min(expectedConverterTypes.size(), actualConverterTypes.size()); ++i) {
            QueryDataType actual;
            QueryDataType expected = expectedConverterTypes.get(i);
            if (expected.equals(actual = actualConverterTypes.get(i))) continue;
            String component = index.getComponents()[i];
            throw QueryException.error(1009, "Cannot use the index \"" + index.getName() + "\" of the IMap \"" + mapName + "\" because it has component \"" + component + "\" of type " + (Object)((Object)actual.getTypeFamily()) + ", but " + (Object)((Object)expected.getTypeFamily()) + " was expected").markInvalidate();
        }
        if (expectedConverterTypes.size() > actualConverterTypes.size()) {
            QueryDataType expected = expectedConverterTypes.get(actualConverterTypes.size());
            String component = index.getComponents()[actualConverterTypes.size()];
            throw QueryException.error(1009, "Cannot use the index \"" + index.getName() + "\" of the IMap \"" + mapName + "\" because it does not have suitable converter for component \"" + component + "\" (expected " + (Object)((Object)expected.getTypeFamily()) + ")").markInvalidate();
        }
    }
}

