/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.pns.transport.fcm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/**
 * {@link DefaultFCMOptionsProvider}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class DefaultFCMOptionsProvider implements FCMOptionsProvider {

    private final Map<String, FCMOptions> options;

    /**
     * Initializes a new {@link DefaultFCMOptionsProvider}.
     */
    public DefaultFCMOptionsProvider(Map<String, FCMOptions> options) {
        super();
        this.options = options;
    }

    @Override
    public FCMOptions getOptions(String client) {
        return options.get(client);
    }

    @Override
    public Collection<FCMOptionsPerClient> getAvailableOptions() {
        Collection<FCMOptionsPerClient> col = new ArrayList<>(options.size());
        for (Map.Entry<String, FCMOptions> entry : options.entrySet()) {
            col.add(new FCMOptionsPerClient(entry.getKey(), entry.getValue()));
        }
        return col;
    }
}
