/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.LazyDeserializer;
import com.hazelcast.sql.impl.LazyTarget;
import com.hazelcast.sql.impl.row.Row;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SqlRowImpl
implements SqlRow {
    private final SqlRowMetadata rowMetadata;
    private final Row row;
    private final LazyDeserializer lazyDeserializer;

    public SqlRowImpl(SqlRowMetadata rowMetadata, Row row, LazyDeserializer lazyDeserializer) {
        this.rowMetadata = rowMetadata;
        this.row = row;
        this.lazyDeserializer = lazyDeserializer;
    }

    @Override
    @Nullable
    public <T> T getObject(int columnIndex) {
        this.checkIndex(columnIndex);
        return this.getObject0(columnIndex, true);
    }

    @Override
    @Nullable
    public <T> T getObject(@Nonnull String columnName) {
        int columnIndex = this.resolveIndex(columnName);
        return this.getObject0(columnIndex, true);
    }

    public <T> T getObjectRaw(int columnIndex) {
        this.checkIndex(columnIndex);
        return this.getObject0(columnIndex, false);
    }

    private <T> T getObject0(int columnIndex, boolean deserialize) {
        Object res = this.row.get(columnIndex);
        if (res instanceof LazyTarget) {
            LazyTarget res0 = (LazyTarget)res;
            if (deserialize) {
                res = this.lazyDeserializer.deserialize(res0);
            } else {
                res = res0.getSerialized();
                if (res == null) {
                    res = res0.getDeserialized();
                }
            }
        } else if (deserialize) {
            res = this.lazyDeserializer.deserialize(res);
        }
        return res;
    }

    private int resolveIndex(String columnName) {
        int index = this.rowMetadata.findColumn(columnName);
        if (index == -1) {
            throw new IllegalArgumentException("Column \"" + columnName + "\" doesn't exist");
        }
        return index;
    }

    @Override
    @Nonnull
    public SqlRowMetadata getMetadata() {
        return this.rowMetadata;
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.rowMetadata.getColumnCount()) {
            throw new IndexOutOfBoundsException("Column index is out of range: " + index);
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (int i = 0; i < this.rowMetadata.getColumnCount(); ++i) {
            SqlColumnMetadata columnMetadata = this.rowMetadata.getColumn(i);
            Object columnValue = this.row.get(i);
            joiner.add(columnMetadata.getName() + ' ' + (Object)((Object)columnMetadata.getType()) + '=' + columnValue);
        }
        return joiner.toString();
    }
}

