/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore.expiry;

import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.eviction.ClearExpiredRecordsTask;
import com.hazelcast.internal.eviction.ExpiredKey;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationQueue;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadataImpl;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryReason;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class ExpirySystem {
    private static final long DEFAULT_EXPIRED_KEY_SCAN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final String PROP_EXPIRED_KEY_SCAN_TIMEOUT_NANOS = "hazelcast.internal.map.expired.key.scan.timeout.nanos";
    private static final HazelcastProperty EXPIRED_KEY_SCAN_TIMEOUT_NANOS = new HazelcastProperty("hazelcast.internal.map.expired.key.scan.timeout.nanos", DEFAULT_EXPIRED_KEY_SCAN_TIMEOUT_NANOS, TimeUnit.NANOSECONDS);
    private static final int ONE_HUNDRED_PERCENT = 100;
    private static final int MIN_TOTAL_NUMBER_OF_KEYS_TO_SCAN = 100;
    private static final int MAX_SAMPLE_AT_A_TIME = 16;
    private static final ThreadLocal<List> BATCH_OF_EXPIRED = ThreadLocal.withInitial(() -> new ArrayList(32));
    private final long expiryDelayMillis;
    private final long expiredKeyScanTimeoutNanos;
    private final boolean canPrimaryDriveExpiration;
    private final ILogger logger;
    private final RecordStore recordStore;
    private final MapContainer mapContainer;
    private final MapServiceContext mapServiceContext;
    private final ClearExpiredRecordsTask clearExpiredRecordsTask;
    private final InvalidationQueue<ExpiredKey> expiredKeys = new InvalidationQueue();
    private Iterator<Map.Entry<Data, ExpiryMetadata>> cachedExpirationIterator;
    private volatile Map<Data, ExpiryMetadata> expireTimeByKey;

    public ExpirySystem(RecordStore recordStore, MapContainer mapContainer, MapServiceContext mapServiceContext) {
        this.recordStore = recordStore;
        this.clearExpiredRecordsTask = mapServiceContext.getExpirationManager().getTask();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.logger = nodeEngine.getLogger(this.getClass());
        HazelcastProperties hazelcastProperties = nodeEngine.getProperties();
        this.expiryDelayMillis = hazelcastProperties.getMillis(ClusterProperty.MAP_EXPIRY_DELAY_SECONDS);
        this.mapContainer = mapContainer;
        this.mapServiceContext = mapServiceContext;
        this.canPrimaryDriveExpiration = mapServiceContext.getClearExpiredRecordsTask().canPrimaryDriveExpiration();
        this.expiredKeyScanTimeoutNanos = nodeEngine.getProperties().getNanos(EXPIRED_KEY_SCAN_TIMEOUT_NANOS);
    }

    public final boolean isEmpty() {
        return MapUtil.isNullOrEmpty(this.expireTimeByKey);
    }

    protected Map<Data, ExpiryMetadata> createExpiryTimeByKeyMap() {
        return new ConcurrentHashMap<Data, ExpiryMetadata>();
    }

    public void clear() {
        Map<Data, ExpiryMetadata> map = this.getOrCreateExpireTimeByKeyMap(false);
        map.clear();
    }

    protected Map<Data, ExpiryMetadata> getOrCreateExpireTimeByKeyMap(boolean createIfAbsent) {
        if (this.expireTimeByKey != null) {
            return this.expireTimeByKey;
        }
        if (createIfAbsent) {
            this.expireTimeByKey = this.createExpiryTimeByKeyMap();
            return this.expireTimeByKey;
        }
        return Collections.emptyMap();
    }

    protected ExpiryMetadata createExpiryMetadata(long ttlMillis, long maxIdleMillis, long expirationTime, long lastUpdateTime) {
        return new ExpiryMetadataImpl(ttlMillis, maxIdleMillis, expirationTime, lastUpdateTime);
    }

    public final void add(Data key, long ttl, long maxIdle, long expiryTime, long now, long lastUpdateTime) {
        if (expiryTime <= 0L) {
            MapConfig mapConfig = this.mapContainer.getMapConfig();
            ttl = ExpirationTimeSetter.pickTTLMillis(mapConfig, ttl);
            maxIdle = ExpirationTimeSetter.pickMaxIdleMillis(mapConfig, maxIdle);
            expiryTime = ExpirationTimeSetter.nextExpirationTime(ttl, maxIdle, now, lastUpdateTime);
        }
        this.storeExpiryMetadata(key, ttl, maxIdle, expiryTime, lastUpdateTime);
    }

    private void storeExpiryMetadata(Data key, long ttlMillis, long maxIdleMillis, long expirationTime, long lastUpdateTime) {
        if (expirationTime == Long.MAX_VALUE) {
            this.removeKeyFromExpirySystem(key);
            return;
        }
        if (this.isClusterVersionLessThanV5()) {
            ExpirySystem.checkIfTtlGreaterThanMaxIdle(this.recordStore.getName(), lastUpdateTime, maxIdleMillis, ttlMillis);
        }
        this.createOrUpdateExpiryMetadata(key, ttlMillis, maxIdleMillis, expirationTime, lastUpdateTime);
        this.mapServiceContext.getExpirationManager().scheduleExpirationTask();
    }

    private void createOrUpdateExpiryMetadata(Data key, long ttlMillis, long maxIdleMillis, long expirationTime, long lastUpdateTime) {
        Map<Data, ExpiryMetadata> expireTimeByKey = this.getOrCreateExpireTimeByKeyMap(true);
        ExpiryMetadata expiryMetadata = expireTimeByKey.get(key);
        if (expiryMetadata == null) {
            expiryMetadata = this.createExpiryMetadata(ttlMillis, maxIdleMillis, expirationTime, lastUpdateTime);
            Data nativeKey = this.recordStore.getStorage().toBackingDataKeyFormat(key);
            expireTimeByKey.put(nativeKey, expiryMetadata);
            return;
        }
        expiryMetadata.setTtl(ttlMillis).setMaxIdle(maxIdleMillis).setExpirationTime(expirationTime).setLastUpdateTime(lastUpdateTime);
    }

    private boolean isClusterVersionLessThanV5() {
        return this.mapServiceContext.getNodeEngine().getClusterService().getClusterVersion().isLessThan(Versions.V5_0);
    }

    private static void checkIfTtlGreaterThanMaxIdle(String mapName, long lastUpdateTime, long maxIdleMillis, long ttlMillis) {
        if (lastUpdateTime == -1L && ExpirationTimeSetter.isTtlOrMaxIdleConfigured(ttlMillis) && ExpirationTimeSetter.isTtlOrMaxIdleConfigured(maxIdleMillis) && ttlMillis > maxIdleMillis) {
            String message = "Map `%s` has timeToLiveSeconds `%d` which is greater than maxIdleSeconds `%d`, for this configuration to work, please set `perEntryStatsEnabled` field of map-config to `true`.";
            throw new UnsupportedOperationException(String.format(message, mapName, TimeUnit.MILLISECONDS.toSeconds(ttlMillis), TimeUnit.MILLISECONDS.toSeconds(maxIdleMillis)));
        }
    }

    public final long calculateExpirationTime(long ttl, long maxIdle, long now, long lastUpdateTime) {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        long ttlMillis = ExpirationTimeSetter.pickTTLMillis(mapConfig, ttl);
        long maxIdleMillis = ExpirationTimeSetter.pickMaxIdleMillis(mapConfig, maxIdle);
        return ExpirationTimeSetter.nextExpirationTime(ttlMillis, maxIdleMillis, now, lastUpdateTime);
    }

    public final void removeKeyFromExpirySystem(Data key) {
        if (this.isEmpty()) {
            return;
        }
        this.callRemove(key, this.expireTimeByKey);
    }

    public final void extendExpiryTime(Data dataKey, long now, long lastUpdateTime) {
        if (this.isEmpty()) {
            return;
        }
        Map<Data, ExpiryMetadata> expireTimeByKey = this.getOrCreateExpireTimeByKeyMap(false);
        if (this.isEmpty()) {
            return;
        }
        ExpiryMetadata expiryMetadata = this.getExpiryMetadataForExpiryCheck(dataKey, expireTimeByKey);
        if (expiryMetadata == null) {
            return;
        }
        long maxIdle = expiryMetadata.getMaxIdle();
        if (maxIdle == Long.MAX_VALUE) {
            return;
        }
        long ttl = expiryMetadata.getTtl();
        if (ttl <= maxIdle) {
            return;
        }
        lastUpdateTime = this.isClusterVersionLessThanV5() ? lastUpdateTime : expiryMetadata.getLastUpdateTime();
        expiryMetadata.setExpirationTime(ExpirationTimeSetter.nextExpirationTime(ttl, maxIdle, now, lastUpdateTime));
    }

    public final ExpiryReason hasExpired(Data key, long now, boolean backup) {
        Map<Data, ExpiryMetadata> expireTimeByKey = this.getOrCreateExpireTimeByKeyMap(false);
        if (this.isEmpty()) {
            return ExpiryReason.NOT_EXPIRED;
        }
        ExpiryMetadata expiryMetadata = this.getExpiryMetadataForExpiryCheck(key, expireTimeByKey);
        return this.hasExpired(expiryMetadata, now, backup);
    }

    private ExpiryReason hasExpired(ExpiryMetadata expiryMetadata, long now, boolean backup) {
        ExpiryReason expiryReason;
        long nextExpirationTime;
        if (expiryMetadata == null) {
            return ExpiryReason.NOT_EXPIRED;
        }
        long l = nextExpirationTime = backup ? expiryMetadata.getExpirationTime() + this.expiryDelayMillis : expiryMetadata.getExpirationTime();
        if (nextExpirationTime > now) {
            return ExpiryReason.NOT_EXPIRED;
        }
        ExpiryReason expiryReason2 = expiryReason = expiryMetadata.getMaxIdle() <= expiryMetadata.getTtl() ? ExpiryReason.MAX_IDLE_SECONDS : ExpiryReason.TTL;
        if (backup && this.canPrimaryDriveExpiration && expiryReason == ExpiryReason.MAX_IDLE_SECONDS) {
            return ExpiryReason.NOT_EXPIRED;
        }
        return expiryReason;
    }

    public final InvalidationQueue<ExpiredKey> getExpiredKeys() {
        return this.expiredKeys;
    }

    @Nonnull
    public final ExpiryMetadata getExpiredMetadata(Data key) {
        ExpiryMetadata expiryMetadata = this.getOrCreateExpireTimeByKeyMap(false).get(key);
        return expiryMetadata != null ? expiryMetadata : ExpiryMetadata.NULL;
    }

    public final void evictExpiredEntries(int percentage, long now, boolean backup) {
        int maxScannableCount = this.findMaxScannableCount(percentage);
        if (maxScannableCount == 0) {
            return;
        }
        int scannedCount = 0;
        int expiredCount = 0;
        try {
            long scanLoopStartNanos = System.nanoTime();
            do {
                expiredCount += this.evictExpiredKeys(backup);
            } while ((scannedCount += this.findExpiredKeys(now, backup)) < maxScannableCount && this.getOrInitCachedIterator().hasNext() && System.nanoTime() - scanLoopStartNanos < this.expiredKeyScanTimeoutNanos);
        }
        catch (Exception e) {
            BATCH_OF_EXPIRED.get().clear();
            throw ExceptionUtil.rethrow(e);
        }
        this.tryToSendBackupExpiryOp();
        if (this.logger.isFinestEnabled()) {
            this.logProgress(maxScannableCount, scannedCount, expiredCount);
        }
    }

    private void logProgress(int maxScannableCount, int scannedCount, int expiredCount) {
        this.logger.finest(String.format("mapName: %s, partitionId: %d, partitionSize: %d, remainingKeyCountToExpire: %d, maxScannableKeyCount: %d, scannedKeyCount: %d, expiredKeyCount: %d", this.recordStore.getName(), this.recordStore.getPartitionId(), this.recordStore.size(), this.expireTimeByKey.size(), maxScannableCount, scannedCount, expiredCount));
    }

    private int findMaxScannableCount(int percentage) {
        Map<Data, ExpiryMetadata> expireTimeByKey = this.getOrCreateExpireTimeByKeyMap(false);
        if (this.isEmpty()) {
            return 0;
        }
        int numberOfExpirableKeys = expireTimeByKey.size();
        if (numberOfExpirableKeys <= 100) {
            return numberOfExpirableKeys;
        }
        int percentageOfExpirableKeys = (int)(1.0 * (double)numberOfExpirableKeys * (double)percentage / 100.0);
        return Math.max(100, percentageOfExpirableKeys);
    }

    private Iterator<Map.Entry<Data, ExpiryMetadata>> getOrInitCachedIterator() {
        if (this.cachedExpirationIterator == null || !this.cachedExpirationIterator.hasNext()) {
            this.cachedExpirationIterator = this.initIteratorOf(this.expireTimeByKey);
        }
        return this.cachedExpirationIterator;
    }

    private int findExpiredKeys(long now, boolean backup) {
        List batchOfExpired = BATCH_OF_EXPIRED.get();
        int scannedCount = 0;
        Iterator<Map.Entry<Data, ExpiryMetadata>> cachedIterator = this.getOrInitCachedIterator();
        while (scannedCount++ < 16 && cachedIterator.hasNext()) {
            Map.Entry<Data, ExpiryMetadata> entry = cachedIterator.next();
            Data key = entry.getKey();
            ExpiryMetadata expiryMetadata = entry.getValue();
            ExpiryReason expiryReason = this.hasExpired(expiryMetadata, now, backup);
            if (expiryReason == ExpiryReason.NOT_EXPIRED || this.recordStore.isLocked(key)) continue;
            batchOfExpired.add(key);
            batchOfExpired.add(expiryReason);
        }
        return scannedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int evictExpiredKeys(boolean backup) {
        int evictedCount = 0;
        List batchOfExpired = BATCH_OF_EXPIRED.get();
        try {
            for (int i = 0; i < batchOfExpired.size(); i += 2) {
                Data key = (Data)batchOfExpired.get(i);
                ExpiryReason expiryReason = (ExpiryReason)((Object)batchOfExpired.get(i + 1));
                this.recordStore.evictExpiredEntryAndPublishExpiryEvent(key, expiryReason, backup);
                this.callRemove(key, this.expireTimeByKey);
                ++evictedCount;
            }
        }
        finally {
            batchOfExpired.clear();
        }
        return evictedCount;
    }

    protected ExpiryMetadata getExpiryMetadataForExpiryCheck(Data key, Map<Data, ExpiryMetadata> expireTimeByKey) {
        return expireTimeByKey.get(key);
    }

    protected Iterator<Map.Entry<Data, ExpiryMetadata>> initIteratorOf(Map<Data, ExpiryMetadata> expireTimeByKey) {
        return expireTimeByKey.entrySet().iterator();
    }

    protected void callRemove(Data key, Map<Data, ExpiryMetadata> expireTimeByKey) {
        expireTimeByKey.remove(key);
    }

    public void destroy() {
        this.getOrCreateExpireTimeByKeyMap(false).clear();
    }

    public final void accumulateOrSendExpiredKey(Data dataKey, long valueHashCode) {
        if (this.mapContainer.getTotalBackupCount() == 0) {
            return;
        }
        if (dataKey != null) {
            this.expiredKeys.offer(new ExpiredKey(ToHeapDataConverter.toHeapData(dataKey), valueHashCode));
        }
        this.clearExpiredRecordsTask.tryToSendBackupExpiryOp(this.recordStore, true);
    }

    public final void tryToSendBackupExpiryOp() {
        if (this.mapContainer.getTotalBackupCount() == 0) {
            return;
        }
        this.clearExpiredRecordsTask.tryToSendBackupExpiryOp(this.recordStore, true);
    }
}

