/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadataImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PutAllBackupOperation
extends MapOperation
implements PartitionAwareOperation,
BackupOperation,
Versioned {
    private boolean disableWanReplicationEvent;
    private List keyValueRecordExpiry;
    private transient int lastIndex;
    private transient List keyRecordExpiry;

    public PutAllBackupOperation(String name, List keyValueRecordExpiry, boolean disableWanReplicationEvent) {
        super(name);
        this.keyValueRecordExpiry = keyValueRecordExpiry;
        this.disableWanReplicationEvent = disableWanReplicationEvent;
    }

    public PutAllBackupOperation() {
    }

    @Override
    protected void runInternal() {
        List keyRecordExpiry = this.keyRecordExpiry;
        if (keyRecordExpiry != null) {
            for (int i = this.lastIndex; i < keyRecordExpiry.size(); i += 3) {
                Data key = (Data)keyRecordExpiry.get(i);
                Record record = (Record)keyRecordExpiry.get(i + 1);
                ExpiryMetadata expiryMetadata = (ExpiryMetadata)keyRecordExpiry.get(i + 2);
                this.putBackup(key, record, expiryMetadata);
                this.lastIndex = i;
            }
        } else {
            List keyValueRecordExpiry = this.keyValueRecordExpiry;
            for (int i = this.lastIndex; i < keyValueRecordExpiry.size(); i += 4) {
                Data key = (Data)keyValueRecordExpiry.get(i);
                Record record = (Record)keyValueRecordExpiry.get(i + 2);
                ExpiryMetadata expiryMetadata = (ExpiryMetadata)keyValueRecordExpiry.get(i + 3);
                this.putBackup(key, record, expiryMetadata);
                this.lastIndex = i;
            }
        }
    }

    private void putBackup(Data key, Record record, ExpiryMetadata expiryMetadata) {
        Object currentRecord = this.recordStore.putBackup(key, record, expiryMetadata.getTtl(), expiryMetadata.getMaxIdle(), expiryMetadata.getExpirationTime(), this.getCallerProvenance());
        Records.copyMetadataFrom(record, currentRecord);
        this.publishWanUpdate(key, record.getValue());
        this.evict(key);
    }

    @Override
    protected boolean disableWanReplicationEvent() {
        return this.disableWanReplicationEvent;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.keyValueRecordExpiry.size() / 4);
        for (int i = 0; i < this.keyValueRecordExpiry.size(); i += 4) {
            Data dataKey = (Data)this.keyValueRecordExpiry.get(i);
            Data dataValue = (Data)this.keyValueRecordExpiry.get(i + 1);
            Record record = (Record)this.keyValueRecordExpiry.get(i + 2);
            ExpiryMetadata expiryMetadata = (ExpiryMetadata)this.keyValueRecordExpiry.get(i + 3);
            IOUtil.writeData(out, dataKey);
            Records.writeRecord(out, record, dataValue, expiryMetadata);
            Version version = out.getVersion();
            if (!version.isGreaterOrEqual(Versions.V5_0)) continue;
            Records.writeExpiry(out, expiryMetadata);
        }
        out.writeBoolean(this.disableWanReplicationEvent);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        ArrayList<Object> keyRecordExpiry = new ArrayList<Object>(size * 3);
        for (int i = 0; i < size; ++i) {
            Version version = in.getVersion();
            boolean isV5 = version.isGreaterOrEqual(Versions.V5_0);
            Data dataKey = IOUtil.readData(in);
            ExpiryMetadata expiryMetadata = null;
            if (!isV5) {
                expiryMetadata = new ExpiryMetadataImpl();
            }
            Record record = Records.readRecord(in, expiryMetadata);
            if (isV5) {
                expiryMetadata = Records.readExpiry(in);
            }
            keyRecordExpiry.add(dataKey);
            keyRecordExpiry.add(record);
            keyRecordExpiry.add(expiryMetadata);
        }
        this.keyRecordExpiry = keyRecordExpiry;
        this.disableWanReplicationEvent = in.readBoolean();
    }

    @Override
    public int getClassId() {
        return 22;
    }
}

