/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeserializedPortableGenericRecord
extends PortableGenericRecord {
    private final ClassDefinition classDefinition;
    private final Object[] objects;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public DeserializedPortableGenericRecord(ClassDefinition classDefinition, Object[] objects) {
        this.classDefinition = classDefinition;
        this.objects = objects;
    }

    @Override
    public ClassDefinition getClassDefinition() {
        return this.classDefinition;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder newBuilder() {
        return GenericRecordBuilder.portable(this.classDefinition);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder cloneWithBuilder() {
        return new PortableGenericRecordBuilder(this.classDefinition, Arrays.copyOf(this.objects, this.objects.length));
    }

    @Override
    @Nonnull
    public Set<String> getFieldNames() {
        return this.classDefinition.getFieldNames();
    }

    @Override
    public GenericRecord[] getGenericRecordArray(@Nonnull String fieldName) {
        return (GenericRecord[])this.get(fieldName, FieldType.PORTABLE_ARRAY);
    }

    @Override
    public GenericRecord getGenericRecord(@Nonnull String fieldName) {
        return (GenericRecord)this.get(fieldName, FieldType.PORTABLE);
    }

    @Override
    public boolean hasField(@Nonnull String fieldName) {
        return this.classDefinition.hasField(fieldName);
    }

    @Override
    @Nonnull
    public FieldType getFieldType(@Nonnull String fieldName) {
        return this.classDefinition.getFieldType(fieldName);
    }

    @Override
    public boolean getBoolean(@Nonnull String fieldName) {
        return (Boolean)this.get(fieldName, FieldType.BOOLEAN);
    }

    @Override
    public byte getByte(@Nonnull String fieldName) {
        return (Byte)this.get(fieldName, FieldType.BYTE);
    }

    @Override
    public char getChar(@Nonnull String fieldName) {
        return ((Character)this.get(fieldName, FieldType.CHAR)).charValue();
    }

    @Override
    public double getDouble(@Nonnull String fieldName) {
        return (Double)this.get(fieldName, FieldType.DOUBLE);
    }

    @Override
    public float getFloat(@Nonnull String fieldName) {
        return ((Float)this.get(fieldName, FieldType.FLOAT)).floatValue();
    }

    @Override
    public int getInt(@Nonnull String fieldName) {
        return (Integer)this.get(fieldName, FieldType.INT);
    }

    @Override
    public long getLong(@Nonnull String fieldName) {
        return (Long)this.get(fieldName, FieldType.LONG);
    }

    @Override
    public short getShort(@Nonnull String fieldName) {
        return (Short)this.get(fieldName, FieldType.SHORT);
    }

    @Override
    @Nullable
    public String getString(@Nonnull String fieldName) {
        return (String)this.get(fieldName, FieldType.UTF);
    }

    @Override
    @Nullable
    public BigDecimal getDecimal(@Nonnull String fieldName) {
        return (BigDecimal)this.get(fieldName, FieldType.DECIMAL);
    }

    @Override
    @Nullable
    public LocalTime getTime(@Nonnull String fieldName) {
        return (LocalTime)this.get(fieldName, FieldType.TIME);
    }

    @Override
    @Nullable
    public LocalDate getDate(@Nonnull String fieldName) {
        return (LocalDate)this.get(fieldName, FieldType.DATE);
    }

    @Override
    @Nullable
    public LocalDateTime getTimestamp(@Nonnull String fieldName) {
        return (LocalDateTime)this.get(fieldName, FieldType.TIMESTAMP);
    }

    @Override
    @Nullable
    public OffsetDateTime getTimestampWithTimezone(@Nonnull String fieldName) {
        return (OffsetDateTime)this.get(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE);
    }

    @Override
    @Nullable
    public boolean[] getBooleanArray(@Nonnull String fieldName) {
        return (boolean[])this.get(fieldName, FieldType.BOOLEAN_ARRAY);
    }

    @Override
    @Nullable
    public byte[] getByteArray(@Nonnull String fieldName) {
        return (byte[])this.get(fieldName, FieldType.BYTE_ARRAY);
    }

    @Override
    @Nullable
    public char[] getCharArray(@Nonnull String fieldName) {
        return (char[])this.get(fieldName, FieldType.CHAR_ARRAY);
    }

    @Override
    @Nullable
    public double[] getDoubleArray(@Nonnull String fieldName) {
        return (double[])this.get(fieldName, FieldType.DOUBLE_ARRAY);
    }

    @Override
    @Nullable
    public float[] getFloatArray(@Nonnull String fieldName) {
        return (float[])this.get(fieldName, FieldType.FLOAT_ARRAY);
    }

    @Override
    @Nullable
    public int[] getIntArray(@Nonnull String fieldName) {
        return (int[])this.get(fieldName, FieldType.INT_ARRAY);
    }

    @Override
    @Nullable
    public long[] getLongArray(@Nonnull String fieldName) {
        return (long[])this.get(fieldName, FieldType.LONG_ARRAY);
    }

    @Override
    @Nullable
    public short[] getShortArray(@Nonnull String fieldName) {
        return (short[])this.get(fieldName, FieldType.SHORT_ARRAY);
    }

    @Override
    @Nullable
    public String[] getStringArray(@Nonnull String fieldName) {
        return (String[])this.get(fieldName, FieldType.UTF_ARRAY);
    }

    @Override
    @Nullable
    public BigDecimal[] getDecimalArray(@Nonnull String fieldName) {
        return (BigDecimal[])this.get(fieldName, FieldType.DECIMAL_ARRAY);
    }

    @Override
    @Nullable
    public LocalTime[] getTimeArray(@Nonnull String fieldName) {
        return (LocalTime[])this.get(fieldName, FieldType.TIME_ARRAY);
    }

    @Override
    @Nullable
    public LocalDate[] getDateArray(@Nonnull String fieldName) {
        return (LocalDate[])this.get(fieldName, FieldType.DATE_ARRAY);
    }

    @Override
    @Nullable
    public LocalDateTime[] getTimestampArray(@Nonnull String fieldName) {
        return (LocalDateTime[])this.get(fieldName, FieldType.TIMESTAMP_ARRAY);
    }

    @Override
    @Nullable
    public OffsetDateTime[] getTimestampWithTimezoneArray(@Nonnull String fieldName) {
        return (OffsetDateTime[])this.get(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY);
    }

    @Override
    protected Object getClassIdentifier() {
        return this.classDefinition;
    }

    @Override
    @Nullable
    public Boolean getBooleanFromArray(@Nonnull String fieldName, int index) {
        boolean[] array = this.getBooleanArray(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Byte getByteFromArray(@Nonnull String fieldName, int index) {
        byte[] array = this.getByteArray(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Character getCharFromArray(@Nonnull String fieldName, int index) {
        char[] array = this.getCharArray(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return Character.valueOf(array[index]);
    }

    @Override
    @Nullable
    public Double getDoubleFromArray(@Nonnull String fieldName, int index) {
        double[] array = this.getDoubleArray(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Float getFloatFromArray(@Nonnull String fieldName, int index) {
        float[] array = this.getFloatArray(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return Float.valueOf(array[index]);
    }

    @Override
    @Nullable
    public Integer getIntFromArray(@Nonnull String fieldName, int index) {
        int[] array = this.getIntArray(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Long getLongFromArray(@Nonnull String fieldName, int index) {
        long[] array = this.getLongArray(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Short getShortFromArray(@Nonnull String fieldName, int index) {
        short[] array = this.getShortArray(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public String getStringFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getStringArray(fieldName), index);
    }

    @Override
    @Nullable
    public GenericRecord getGenericRecordFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getGenericRecordArray(fieldName), index);
    }

    @Override
    @Nullable
    public Object getObjectFromArray(@Nonnull String fieldName, int index) {
        return this.getGenericRecordFromArray(fieldName, index);
    }

    @Override
    @Nullable
    public <T> T[] getObjectArray(@Nonnull String fieldName, Class<T> componentType) {
        return this.getGenericRecordArray(fieldName);
    }

    @Nullable
    public Object getObject(@Nonnull String fieldName) {
        return this.getGenericRecord(fieldName);
    }

    @Override
    @Nullable
    public BigDecimal getDecimalFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getDecimalArray(fieldName), index);
    }

    @Override
    @Nullable
    public LocalTime getTimeFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getTimeArray(fieldName), index);
    }

    @Override
    @Nullable
    public LocalDate getDateFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getDateArray(fieldName), index);
    }

    @Override
    @Nullable
    public LocalDateTime getTimestampFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getTimestampArray(fieldName), index);
    }

    @Override
    @Nullable
    public OffsetDateTime getTimestampWithTimezoneFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getTimestampWithTimezoneArray(fieldName), index);
    }

    private <T> T get(@Nonnull String fieldName, FieldType fieldType) {
        FieldDefinition fd = this.check(fieldName, fieldType);
        return (T)this.objects[fd.getIndex()];
    }

    @Nonnull
    private FieldDefinition check(@Nonnull String fieldName, FieldType fieldType) {
        FieldDefinition fd = this.classDefinition.getField(fieldName);
        if (fd == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + "' for ClassDefinition {id: " + this.classDefinition.getClassId() + ", version: " + this.classDefinition.getVersion() + "}");
        }
        if (!fd.getType().equals((Object)fieldType)) {
            throw new HazelcastSerializationException("Invalid field type: '" + fieldName + "' for ClassDefinition {id: " + this.classDefinition.getClassId() + ", version: " + this.classDefinition.getVersion() + "}, expected : " + (Object)((Object)fd.getType()) + ", given : " + (Object)((Object)fieldType));
        }
        return fd;
    }

    private <T> T getFromArray(T[] array, int index) {
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }
}

