/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.internal.serialization.impl.compact.AbstractGenericRecordBuilder;
import com.hazelcast.internal.serialization.impl.compact.CompactInternalGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactWriter;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class SerializingGenericRecordCloner
implements GenericRecordBuilder {
    private final Schema schema;
    private final CompactInternalGenericRecord genericRecord;
    private final DefaultCompactWriter cw;
    private final CompactStreamSerializer serializer;
    private final Map<String, Writer> fields = new HashMap<String, Writer>();
    private final Function<byte[], BufferObjectDataInput> bufferObjectDataInputFunc;

    public SerializingGenericRecordCloner(CompactStreamSerializer serializer, Schema schema, CompactInternalGenericRecord record, Function<byte[], BufferObjectDataInput> bufferObjectDataInputFunc, Supplier<BufferObjectDataOutput> bufferObjectDataOutputSupplier) {
        this.serializer = serializer;
        this.schema = schema;
        this.genericRecord = record;
        this.cw = new DefaultCompactWriter(serializer, bufferObjectDataOutputSupplier.get(), schema, false);
        this.bufferObjectDataInputFunc = bufferObjectDataInputFunc;
    }

    @Override
    @Nonnull
    public GenericRecord build() {
        try {
            for (FieldDescriptor field : this.schema.getFields()) {
                String fieldName = field.getFieldName();
                Writer writer = this.fields.get(fieldName);
                if (writer != null) {
                    writer.write();
                    continue;
                }
                FieldType fieldType = field.getType();
                FieldOperations.fieldOperations(fieldType).writeFieldFromRecordToWriter(this.cw, this.genericRecord, fieldName);
            }
            this.cw.end();
            byte[] bytes = this.cw.toByteArray();
            Class associatedClass = this.genericRecord.getAssociatedClass();
            BufferObjectDataInput dataInput = this.bufferObjectDataInputFunc.apply(bytes);
            return new DefaultCompactReader(this.serializer, dataInput, this.schema, associatedClass, false);
        }
        catch (IOException e) {
            throw new HazelcastSerializationException(e);
        }
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt(@Nonnull String fieldName, int value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.INT);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeInt(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setLong(@Nonnull String fieldName, long value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.LONG);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeLong(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setString(@Nonnull String fieldName, String value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.UTF);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeString(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBoolean(@Nonnull String fieldName, boolean value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.BOOLEAN);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeBoolean(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setByte(@Nonnull String fieldName, byte value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.BYTE);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeByte(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setChar(@Nonnull String fieldName, char value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.CHAR);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeChar(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDouble(@Nonnull String fieldName, double value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.DOUBLE);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeDouble(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat(@Nonnull String fieldName, float value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.FLOAT);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeFloat(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setShort(@Nonnull String fieldName, short value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.SHORT);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeShort(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimal(@Nonnull String fieldName, BigDecimal value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.DECIMAL);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeDecimal(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTime(@Nonnull String fieldName, LocalTime value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.TIME);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeTime(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDate(@Nonnull String fieldName, LocalDate value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.DATE);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeDate(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestamp(@Nonnull String fieldName, LocalDateTime value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.TIMESTAMP);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeTimestamp(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezone(@Nonnull String fieldName, OffsetDateTime value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeTimestampWithTimezone(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecord(@Nonnull String fieldName, GenericRecord value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.COMPOSED);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeGenericRecord(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecordArray(@Nonnull String fieldName, GenericRecord[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.COMPOSED_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeGenericRecordArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setByteArray(@Nonnull String fieldName, byte[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.BYTE_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeByteArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBooleanArray(@Nonnull String fieldName, boolean[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.BOOLEAN_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeBooleanArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setCharArray(@Nonnull String fieldName, char[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.CHAR_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeCharArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setIntArray(@Nonnull String fieldName, int[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.INT_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeIntArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setLongArray(@Nonnull String fieldName, long[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.LONG_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeLongArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDoubleArray(@Nonnull String fieldName, double[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.DOUBLE_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeDoubleArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloatArray(@Nonnull String fieldName, float[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.FLOAT_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeFloatArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setShortArray(@Nonnull String fieldName, short[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.SHORT_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeShortArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setStringArray(@Nonnull String fieldName, String[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.UTF_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeStringArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimalArray(@Nonnull String fieldName, BigDecimal[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.DECIMAL_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeDecimalArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimeArray(@Nonnull String fieldName, LocalTime[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.TIME_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeTimeArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDateArray(@Nonnull String fieldName, LocalDate[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.DATE_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeDateArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampArray(@Nonnull String fieldName, LocalDateTime[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.TIMESTAMP_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeTimestampArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezoneArray(@Nonnull String fieldName, OffsetDateTime[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeTimestampWithTimezoneArray(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    static interface Writer {
        public void write() throws IOException;
    }
}

