/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.SchemaViolationConfigurationException;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlToJsonConverter;
import com.hazelcast.org.everit.json.schema.ObjectSchema;
import com.hazelcast.org.everit.json.schema.PrimitiveValidationStrategy;
import com.hazelcast.org.everit.json.schema.Schema;
import com.hazelcast.org.everit.json.schema.ValidationException;
import com.hazelcast.org.everit.json.schema.Validator;
import com.hazelcast.org.everit.json.schema.loader.SchemaLoader;
import com.hazelcast.org.json.JSONObject;
import com.hazelcast.org.json.JSONTokener;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class YamlConfigSchemaValidator {
    private static final HazelcastProperty ROOT_LEVEL_INDENTATION_CHECK_ENABLED = new HazelcastProperty("hazelcast.yaml.config.indentation.check.enabled", "true");
    private static final List<String> PERMITTED_ROOT_NODES = Collections.unmodifiableList(Arrays.asList("hazelcast", "hazelcast-client", "hazelcast-client-failover"));
    private static final Schema SCHEMA = SchemaLoader.builder().draftV6Support().schemaJson(YamlConfigSchemaValidator.readJSONObject("/hazelcast-config-" + Versions.CURRENT_CLUSTER_VERSION.getMajor() + "." + Versions.CURRENT_CLUSTER_VERSION.getMinor() + ".json")).build().load().build();

    SchemaViolationConfigurationException wrap(ValidationException e) {
        List<SchemaViolationConfigurationException> subErrors = e.getCausingExceptions().stream().map(this::wrap).collect(Collectors.toList());
        return new SchemaViolationConfigurationException(e.getErrorMessage(), e.getSchemaLocation(), e.getPointerToViolation(), subErrors);
    }

    private static JSONObject readJSONObject(String absPath) {
        return new JSONObject(new JSONTokener(YamlConfigSchemaValidator.class.getResourceAsStream(absPath)));
    }

    public void validate(YamlMapping rootNode) {
        try {
            List definedRootNodes = PERMITTED_ROOT_NODES.stream().filter(rootNodeName -> rootNode != null && rootNode.child((String)rootNodeName) != null).collect(Collectors.toList());
            if (definedRootNodes.size() != 1) {
                throw new SchemaViolationConfigurationException("exactly one of [hazelcast], [hazelcast-client] and [hazelcast-client-failover] should be present in the root schema document, " + definedRootNodes.size() + " are present", "#", "#", Collections.emptyList());
            }
            if (new HazelcastProperties(System.getProperties()).getBoolean(ROOT_LEVEL_INDENTATION_CHECK_ENABLED)) {
                this.validateAdditionalProperties(rootNode, (String)definedRootNodes.get(0));
            }
            Validator.builder().primitiveValidationStrategy(PrimitiveValidationStrategy.LENIENT).build().performValidation(SCHEMA, YamlToJsonConverter.convert(rootNode));
        }
        catch (ValidationException e) {
            throw this.wrap(e);
        }
    }

    private void validateAdditionalProperties(YamlMapping rootNode, String hzConfigRootNodeName) {
        if (!PERMITTED_ROOT_NODES.contains(hzConfigRootNodeName)) {
            throw new IllegalArgumentException(hzConfigRootNodeName);
        }
        ObjectSchema schema = (ObjectSchema)SCHEMA;
        Set<String> forbiddenRootPropNames = ((ObjectSchema)schema.getPropertySchemas().get(hzConfigRootNodeName)).getPropertySchemas().keySet();
        ArrayList misIndentedRootProps = new ArrayList();
        rootNode.children().forEach(yamlNode -> {
            if (forbiddenRootPropNames.contains(yamlNode.nodeName())) {
                misIndentedRootProps.add(yamlNode.nodeName());
            }
        });
        if (misIndentedRootProps.isEmpty()) {
            return;
        }
        if (misIndentedRootProps.size() == 1) {
            String propName = (String)misIndentedRootProps.get(0);
            throw this.createExceptionForMisIndentedConfigProp(propName, true);
        }
        List<SchemaViolationConfigurationException> causes = misIndentedRootProps.stream().map(prop -> this.createExceptionForMisIndentedConfigProp((String)prop, false)).collect(Collectors.toList());
        throw new SchemaViolationConfigurationException(YamlConfigSchemaValidator.withNote(causes.size() + " schema violations found"), "#", "#", causes);
    }

    private static String withNote(String originalMessage) {
        return originalMessage + System.getProperty("line.separator") + "Note: you can disable this validation by passing the -D" + ROOT_LEVEL_INDENTATION_CHECK_ENABLED.getName() + "=false system property";
    }

    private SchemaViolationConfigurationException createExceptionForMisIndentedConfigProp(String propName, boolean addNote) {
        String message = "Mis-indented hazelcast configuration property found: [" + propName + "]";
        if (addNote) {
            message = YamlConfigSchemaValidator.withNote(message);
        }
        return new SchemaViolationConfigurationException(message, "#", "#", Collections.emptyList());
    }
}

