/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.scripting.rhino;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;
import com.openexchange.scripting.rhino.libs.Underscore;

public class SharedScope {
	public static final ScriptableObject SHARED_SCOPE;
	static {
		Context cx;
		try {
			 cx = Context.enter();
			 SHARED_SCOPE = cx.initStandardObjects(null, true);

			// Force the LiveConnect stuff to be loaded.
			String loadMe = "RegExp; getClass; java; Packages; JavaAdapter;";
			cx.evaluateString(SHARED_SCOPE , loadMe, "lazyLoad", 0, null);
			Underscore.initialize(SHARED_SCOPE);
		} finally {
			Context.exit();
		}
	}
}
