/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.io;

import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.exec.io.AbstractMailbox;
import com.hazelcast.sql.impl.exec.io.InboundBatch;
import com.hazelcast.sql.impl.exec.io.InboundHandler;
import com.hazelcast.sql.impl.exec.io.flowcontrol.FlowControl;
import com.hazelcast.sql.impl.operation.QueryOperationHandler;
import java.util.UUID;

public abstract class AbstractInbox
extends AbstractMailbox
implements InboundHandler {
    protected int enqueuedBatches;
    private int remainingStreams;
    private final QueryOperationHandler operationHandler;
    private final FlowControl flowControl;

    protected AbstractInbox(QueryOperationHandler operationHandler, QueryId queryId, int edgeId, int rowWidth, UUID localMemberId, int remainingStreams, FlowControl flowControl) {
        super(queryId, edgeId, rowWidth, localMemberId);
        this.operationHandler = operationHandler;
        this.remainingStreams = remainingStreams;
        this.flowControl = flowControl;
    }

    public void setup() {
        this.flowControl.setup(this.queryId, this.edgeId, this.localMemberId, this.operationHandler);
    }

    @Override
    public final void onBatch(InboundBatch batch, long remainingMemory) {
        this.onBatch0(batch);
        ++this.enqueuedBatches;
        if (batch.isLast()) {
            --this.remainingStreams;
        }
        this.flowControl.onBatchAdded(batch.getSenderId(), this.getBatchSize(batch), batch.isLast(), remainingMemory);
    }

    protected abstract void onBatch0(InboundBatch var1);

    protected void onBatchPolled(InboundBatch batch) {
        if (batch == null) {
            return;
        }
        --this.enqueuedBatches;
        this.flowControl.onBatchRemoved(batch.getSenderId(), this.getBatchSize(batch), batch.isLast());
    }

    @Override
    public void onFragmentExecutionCompleted() {
        this.flowControl.onFragmentExecutionCompleted();
    }

    public boolean closed() {
        return this.enqueuedBatches == 0 && this.remainingStreams == 0;
    }

    public int getRemainingStreams() {
        return this.remainingStreams;
    }

    public FlowControl getFlowControl() {
        return this.flowControl;
    }

    private long getBatchSize(InboundBatch batch) {
        return (long)batch.getBatch().getRowCount() * (long)this.rowWidth;
    }
}

