/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.logical;

import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalProject;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.rex.RexVisitorImpl;
import com.hazelcast.org.apache.calcite.util.mapping.Mapping;
import com.hazelcast.org.apache.calcite.util.mapping.Mappings;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ProjectIntoScanLogicalRule
extends RelOptRule {
    public static final ProjectIntoScanLogicalRule INSTANCE = new ProjectIntoScanLogicalRule();

    private ProjectIntoScanLogicalRule() {
        super(ProjectIntoScanLogicalRule.operand(LogicalProject.class, ProjectIntoScanLogicalRule.operandJ(LogicalTableScan.class, null, OptUtils::isHazelcastTable, ProjectIntoScanLogicalRule.none()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, ProjectIntoScanLogicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        TableScan scan = (TableScan)call.rel(1);
        Mappings.TargetMapping mapping = project.getMapping();
        if (mapping != null) {
            ProjectIntoScanLogicalRule.processSimple(call, mapping, scan);
        } else {
            this.processComplex(call, project, scan);
        }
    }

    private static void processSimple(RelOptRuleCall call, Mappings.TargetMapping mapping, TableScan scan) {
        HazelcastTable originalTable = OptUtils.getHazelcastTable(scan);
        List<Integer> originalProjects = originalTable.getProjects();
        List<Integer> newProjects = Mappings.apply((Mapping)mapping, originalProjects);
        LogicalTableScan newScan = OptUtils.createLogicalScanWithNewTable(scan, originalTable.withProject(newProjects));
        call.transformTo(newScan);
    }

    private void processComplex(RelOptRuleCall call, Project project, TableScan scan) {
        HazelcastTable originalTable = OptUtils.getHazelcastTable(scan);
        ProjectFieldVisitor projectFieldVisitor = new ProjectFieldVisitor(originalTable.getProjects());
        for (RexNode projectExp : project.getProjects()) {
            projectExp.accept(projectFieldVisitor);
        }
        List newScanProjects = projectFieldVisitor.createNewScanProjects();
        if (newScanProjects.size() == originalTable.getProjects().size()) {
            return;
        }
        LogicalTableScan newScan = OptUtils.createLogicalScanWithNewTable(scan, originalTable.withProject(newScanProjects));
        ProjectConverter projectConverter = projectFieldVisitor.createProjectConverter();
        ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
        for (RexNode projectExp : project.getProjects()) {
            RexNode newProjectExp = projectExp.accept(projectConverter);
            newProjects.add(newProjectExp);
        }
        LogicalProject newProject = LogicalProject.create((RelNode)newScan, project.getHints(), newProjects, project.getRowType());
        call.transformTo(newProject);
    }

    public static final class ProjectConverter
    extends RexShuttle {
        private final Map<RexNode, Integer> projectExpToScanFieldMap;

        private ProjectConverter(Map<RexNode, Integer> projectExpToScanFieldMap) {
            this.projectExpToScanFieldMap = projectExpToScanFieldMap;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            Integer index = this.projectExpToScanFieldMap.get(inputRef);
            assert (index != null);
            return new RexInputRef(index, inputRef.getType());
        }
    }

    private static final class ProjectFieldVisitor
    extends RexVisitorImpl<Void> {
        private final List<Integer> originalScanFields;
        private final Map<Integer, List<RexInputRef>> scanFieldIndexToProjectInputs = new LinkedHashMap<Integer, List<RexInputRef>>();

        private ProjectFieldVisitor(List<Integer> originalScanFields) {
            super(true);
            this.originalScanFields = originalScanFields;
        }

        @Override
        public Void visitInputRef(RexInputRef projectInput) {
            Integer scanField = this.originalScanFields.get(projectInput.getIndex());
            assert (scanField != null);
            List projectInputs = this.scanFieldIndexToProjectInputs.computeIfAbsent(scanField, k -> new ArrayList(1));
            projectInputs.add(projectInput);
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            for (RexNode operand : call.operands) {
                operand.accept(this);
            }
            return null;
        }

        private List<Integer> createNewScanProjects() {
            return new ArrayList<Integer>(this.scanFieldIndexToProjectInputs.keySet());
        }

        private ProjectConverter createProjectConverter() {
            HashMap<RexNode, Integer> projectExpToScanFieldMap = new HashMap<RexNode, Integer>();
            int index = 0;
            for (List<RexInputRef> projectInputs : this.scanFieldIndexToProjectInputs.values()) {
                for (RexNode rexNode : projectInputs) {
                    projectExpToScanFieldMap.put(rexNode, index);
                }
                ++index;
            }
            return new ProjectConverter(projectExpToScanFieldMap);
        }
    }
}

