/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.version.MemberVersion;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class MemberInfo
implements IdentifiedDataSerializable {
    private Address address;
    private UUID uuid;
    private boolean liteMember;
    private MemberVersion version;
    private Map<String, String> attributes;
    private int memberListJoinVersion = -1;
    private Map<EndpointQualifier, Address> addressMap;

    public MemberInfo() {
    }

    public MemberInfo(Address address, UUID uuid, Map<String, String> attributes, boolean liteMember, MemberVersion version) {
        this(address, uuid, attributes, liteMember, version, -1, Collections.emptyMap());
    }

    public MemberInfo(Address address, UUID uuid, Map<String, String> attributes, boolean liteMember, MemberVersion version, Map<EndpointQualifier, Address> addressMap) {
        this(address, uuid, attributes, liteMember, version, -1, addressMap);
    }

    public MemberInfo(Address address, UUID uuid, Map<String, String> attributes, boolean liteMember, MemberVersion version, boolean isAddressMapExists, Map<EndpointQualifier, Address> addressMap) {
        this(address, uuid, attributes, liteMember, version, -1, addressMap);
    }

    public MemberInfo(Address address, UUID uuid, Map<String, String> attributes, boolean liteMember, MemberVersion version, int memberListJoinVersion, Map<EndpointQualifier, Address> addressMap) {
        this.address = address;
        this.uuid = uuid;
        this.attributes = attributes == null || attributes.isEmpty() ? Collections.emptyMap() : new HashMap<String, String>(attributes);
        this.liteMember = liteMember;
        this.version = version;
        this.memberListJoinVersion = memberListJoinVersion;
        this.addressMap = addressMap;
    }

    public MemberInfo(MemberImpl member) {
        this(member.getAddress(), member.getUuid(), member.getAttributes(), member.isLiteMember(), member.getVersion(), member.getMemberListJoinVersion(), member.getAddressMap());
    }

    public Address getAddress() {
        return this.address;
    }

    public MemberVersion getVersion() {
        return this.version;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isLiteMember() {
        return this.liteMember;
    }

    public int getMemberListJoinVersion() {
        return this.memberListJoinVersion;
    }

    public Map<EndpointQualifier, Address> getAddressMap() {
        return this.addressMap;
    }

    public MemberImpl toMember() {
        return new MemberImpl.Builder(Collections.singletonMap(EndpointQualifier.MEMBER, this.address)).version(this.version).uuid(this.uuid).attributes(this.attributes).liteMember(this.liteMember).memberListJoinVersion(this.memberListJoinVersion).build();
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.address = (Address)in.readObject();
        this.uuid = UUIDSerializationUtil.readUUID(in);
        this.liteMember = in.readBoolean();
        int size = in.readInt();
        if (size > 0) {
            this.attributes = MapUtil.createHashMap(size);
        }
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            this.attributes.put(key, value);
        }
        this.version = (MemberVersion)in.readObject();
        this.memberListJoinVersion = in.readInt();
        this.addressMap = SerializationUtil.readMap(in);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.address);
        UUIDSerializationUtil.writeUUID(out, this.uuid);
        out.writeBoolean(this.liteMember);
        out.writeInt(this.attributes == null ? 0 : this.attributes.size());
        if (this.attributes != null) {
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
        }
        out.writeObject(this.version);
        out.writeInt(this.memberListJoinVersion);
        SerializationUtil.writeMap(this.addressMap, out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberInfo that = (MemberInfo)o;
        if (!this.address.equals(that.address)) {
            return false;
        }
        return this.uuid != null ? this.uuid.equals(that.uuid) : that.uuid == null;
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + (this.uuid != null ? this.uuid.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MemberInfo{address=" + this.address + ", uuid=" + this.uuid + ", liteMember=" + this.liteMember + ", memberListJoinVersion=" + this.memberListJoinVersion + '}';
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getClassId() {
        return 25;
    }
}

