/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.Preconditions;

public class SqlConfig {
    public static final int DEFAULT_EXECUTOR_POOL_SIZE = -1;
    public static final int DEFAULT_OPERATION_POOL_SIZE = -1;
    public static final int DEFAULT_STATEMENT_TIMEOUT_MILLIS = 0;
    private int executorPoolSize = -1;
    private int operationPoolSize = -1;
    private long statementTimeoutMillis = 0L;

    public int getExecutorPoolSize() {
        return this.executorPoolSize;
    }

    public SqlConfig setExecutorPoolSize(int executorPoolSize) {
        if (executorPoolSize < -1 || executorPoolSize == 0) {
            Preconditions.checkPositive(executorPoolSize, "Executor pool size should be positive or -1: " + executorPoolSize);
        }
        this.executorPoolSize = executorPoolSize;
        return this;
    }

    public int getOperationPoolSize() {
        return this.operationPoolSize;
    }

    public SqlConfig setOperationPoolSize(int operationPoolSize) {
        if (operationPoolSize < -1 || operationPoolSize == 0) {
            Preconditions.checkPositive(operationPoolSize, "Operation pool size should be positive or -1: " + operationPoolSize);
        }
        this.operationPoolSize = operationPoolSize;
        return this;
    }

    public long getStatementTimeoutMillis() {
        return this.statementTimeoutMillis;
    }

    public SqlConfig setStatementTimeoutMillis(long statementTimeoutMillis) {
        Preconditions.checkNotNegative(statementTimeoutMillis, "Timeout cannot be negative");
        this.statementTimeoutMillis = statementTimeoutMillis;
        return this;
    }

    public String toString() {
        return "SqlConfig{executorPoolSize=" + this.executorPoolSize + ", operationPoolSize=" + this.operationPoolSize + ", statementTimeoutMillis=" + this.statementTimeoutMillis + '}';
    }
}

