/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.monitor.LocalWanPublisherStats;
import com.hazelcast.util.JsonUtil;
import com.hazelcast.wan.impl.WanEventCounter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalWanPublisherStatsImpl
implements LocalWanPublisherStats {
    private static final AtomicLongFieldUpdater<LocalWanPublisherStatsImpl> TOTAL_PUBLISH_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalWanPublisherStatsImpl.class, "totalPublishLatency");
    private static final AtomicLongFieldUpdater<LocalWanPublisherStatsImpl> TOTAL_PUBLISHED_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(LocalWanPublisherStatsImpl.class, "totalPublishedEventCount");
    private volatile boolean connected;
    private volatile boolean paused;
    private volatile int outboundQueueSize;
    private volatile long totalPublishLatency;
    private volatile long totalPublishedEventCount;
    private volatile Map<String, WanEventCounter.EventCounter> sentMapEventCounter;
    private volatile Map<String, WanEventCounter.EventCounter> sentCacheEventCounter;

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public int getOutboundQueueSize() {
        return this.outboundQueueSize;
    }

    public void setOutboundQueueSize(int outboundQueueSize) {
        this.outboundQueueSize = outboundQueueSize;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Override
    public long getTotalPublishLatency() {
        return this.totalPublishLatency;
    }

    @Override
    public long getTotalPublishedEventCount() {
        return this.totalPublishedEventCount;
    }

    @Override
    public Map<String, WanEventCounter.EventCounter> getSentMapEventCounter() {
        return this.sentMapEventCounter;
    }

    @Override
    public Map<String, WanEventCounter.EventCounter> getSentCacheEventCounter() {
        return this.sentCacheEventCounter;
    }

    public void setSentMapEventCounter(Map<String, WanEventCounter.EventCounter> sentMapEventCounter) {
        this.sentMapEventCounter = sentMapEventCounter;
    }

    public void setSentCacheEventCounter(Map<String, WanEventCounter.EventCounter> sentCacheEventCounter) {
        this.sentCacheEventCounter = sentCacheEventCounter;
    }

    public void incrementPublishedEventCount(long latency) {
        TOTAL_PUBLISHED_EVENT_COUNT.incrementAndGet(this);
        TOTAL_PUBLISH_LATENCY.addAndGet(this, latency);
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("isConnected", this.connected);
        root.add("totalPublishLatencies", this.totalPublishLatency);
        root.add("totalPublishedEventCount", this.totalPublishedEventCount);
        root.add("outboundQueueSize", this.outboundQueueSize);
        root.add("paused", this.paused);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.connected = JsonUtil.getBoolean(json, "isConnected", false);
        this.totalPublishLatency = JsonUtil.getLong(json, "totalPublishLatencies", -1L);
        this.totalPublishedEventCount = JsonUtil.getLong(json, "totalPublishedEventCount", -1L);
        this.outboundQueueSize = JsonUtil.getInt(json, "outboundQueueSize", -1);
        this.paused = JsonUtil.getBoolean(json, "paused");
    }

    public String toString() {
        return "LocalPublisherStatsImpl{connected=" + this.connected + ", totalPublishLatency=" + this.totalPublishLatency + ", totalPublishedEventCount=" + this.totalPublishedEventCount + ", outboundQueueSize=" + this.outboundQueueSize + ", paused=" + this.paused + '}';
    }
}

