/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.eviction;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationQueue;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.ClearExpiredOperation;
import com.hazelcast.map.impl.operation.EvictBatchBackupOperation;
import com.hazelcast.map.impl.recordstore.ExpiredKey;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.TaskScheduler;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.partition.IPartition;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.util.Clock;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ExpirationManager
implements OperationResponseHandler,
LifecycleListener {
    public static final String PROP_PRIMARY_DRIVES_BACKUP = "hazelcast.internal.map.expiration.primary.drives_backup";
    public static final String PROP_TASK_PERIOD_SECONDS = "hazelcast.internal.map.expiration.task.period.seconds";
    public static final String PROP_CLEANUP_PERCENTAGE = "hazelcast.internal.map.expiration.cleanup.percentage";
    public static final String PROP_CLEANUP_OPERATION_COUNT = "hazelcast.internal.map.expiration.cleanup.operation.count";
    public static final boolean DEFAULT_PRIMARY_DRIVES_BACKUP = true;
    public static final int DEFAULT_TASK_PERIOD_SECONDS = 5;
    public static final int DEFAULT_CLEANUP_PERCENTAGE = 10;
    public static final int MAX_EXPIRED_KEY_COUNT_IN_BATCH = 100;
    public static final int DIFFERENCE_BETWEEN_TWO_SUBSEQUENT_PARTITION_CLEANUP_MILLIS = 1000;
    public static final HazelcastProperty PRIMARY_DRIVES_BACKUP = new HazelcastProperty("hazelcast.internal.map.expiration.primary.drives_backup", true);
    public static final HazelcastProperty TASK_PERIOD_SECONDS = new HazelcastProperty("hazelcast.internal.map.expiration.task.period.seconds", 5, TimeUnit.SECONDS);
    public static final HazelcastProperty CLEANUP_PERCENTAGE = new HazelcastProperty("hazelcast.internal.map.expiration.cleanup.percentage", 10);
    public static final HazelcastProperty CLEANUP_OPERATION_COUNT = new HazelcastProperty("hazelcast.internal.map.expiration.cleanup.operation.count");
    private final boolean primaryDrivesEviction;
    private final int taskPeriodSeconds;
    private final int partitionCount;
    private final int cleanupPercentage;
    private final int cleanupOperationCount;
    private final Address thisAddress;
    private final NodeEngine nodeEngine;
    private final HazelcastProperties properties;
    private final TaskScheduler globalTaskScheduler;
    private final IPartitionService partitionService;
    private final PartitionContainer[] partitionContainers;
    private final InternalOperationService operationService;
    private final AtomicBoolean scheduledOneTime = new AtomicBoolean(false);
    private final AtomicBoolean singleRunPermit = new AtomicBoolean(false);
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    private final ClearExpiredRecordsTask task = new ClearExpiredRecordsTask();
    private volatile ScheduledFuture<?> expirationTask;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ExpirationManager(PartitionContainer[] partitionContainers, NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.partitionContainers = partitionContainers;
        this.thisAddress = nodeEngine.getThisAddress();
        this.partitionService = nodeEngine.getPartitionService();
        this.globalTaskScheduler = nodeEngine.getExecutionService().getGlobalTaskScheduler();
        this.operationService = (InternalOperationService)nodeEngine.getOperationService();
        this.partitionCount = this.partitionService.getPartitionCount();
        this.properties = nodeEngine.getProperties();
        this.taskPeriodSeconds = this.properties.getSeconds(TASK_PERIOD_SECONDS);
        Preconditions.checkPositive(this.taskPeriodSeconds, "taskPeriodSeconds should be a positive number");
        this.cleanupPercentage = this.properties.getInteger(CLEANUP_PERCENTAGE);
        Preconditions.checkTrue(this.cleanupPercentage > 0 && this.cleanupPercentage <= 100, "cleanupPercentage should be in range (0,100]");
        this.cleanupOperationCount = ExpirationManager.calculateCleanupOperationCount(this.properties, this.partitionCount, this.operationService.getPartitionThreadCount());
        Preconditions.checkPositive(this.cleanupOperationCount, "cleanupOperationCount should be a positive number");
        this.primaryDrivesEviction = this.properties.getBoolean(PRIMARY_DRIVES_BACKUP);
        this.nodeEngine.getHazelcastInstance().getLifecycleService().addLifecycleListener(this);
    }

    public void scheduleExpirationTask() {
        if (this.scheduled.get() || !this.scheduled.compareAndSet(false, true)) {
            return;
        }
        this.expirationTask = this.globalTaskScheduler.scheduleWithRepetition(this.task, this.taskPeriodSeconds, this.taskPeriodSeconds, TimeUnit.SECONDS);
        this.scheduledOneTime.set(true);
    }

    void unscheduleExpirationTask() {
        this.scheduled.set(false);
        ScheduledFuture<?> scheduledFuture = this.expirationTask;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
    }

    @Override
    public void stateChanged(LifecycleEvent event) {
        switch (event.getState()) {
            case SHUTTING_DOWN: 
            case MERGING: {
                this.unscheduleExpirationTask();
                break;
            }
            case MERGED: {
                this.rescheduleIfScheduledBefore();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void onClusterStateChange(ClusterState newState) {
        if (newState == ClusterState.PASSIVE) {
            this.unscheduleExpirationTask();
        } else {
            this.rescheduleIfScheduledBefore();
        }
    }

    private void rescheduleIfScheduledBefore() {
        if (!this.scheduledOneTime.get()) {
            return;
        }
        this.scheduleExpirationTask();
    }

    private static int calculateCleanupOperationCount(HazelcastProperties properties, int partitionCount, int partitionThreadCount) {
        String stringValue = properties.getString(CLEANUP_OPERATION_COUNT);
        if (stringValue != null) {
            return Integer.parseInt(stringValue);
        }
        double scanPercentage = 0.1;
        int opCountFromPartitionCount = (int)((double)partitionCount * 0.1);
        int inflationFactor = 3;
        int opCountFromThreadCount = partitionThreadCount * 3;
        if (opCountFromPartitionCount == 0) {
            return opCountFromThreadCount;
        }
        return Math.min(opCountFromPartitionCount, opCountFromThreadCount);
    }

    private void updateLastCleanupTimesBeforeSorting(List<PartitionContainer> partitionContainers) {
        for (PartitionContainer partitionContainer : partitionContainers) {
            partitionContainer.setLastCleanupTimeCopy(partitionContainer.getLastCleanupTime());
        }
    }

    private Operation createExpirationOperation(int expirationPercentage, int partitionId) {
        return new ClearExpiredOperation(expirationPercentage).setNodeEngine(this.nodeEngine).setCallerUuid(this.nodeEngine.getLocalMember().getUuid()).setPartitionId(partitionId).setValidateTarget(false).setServiceName("hz:impl:mapService").setOperationResponseHandler(this);
    }

    public void sendResponse(Operation op, Object response) {
        if (this.canPrimaryDriveExpiration()) {
            PartitionContainer partitionContainer = this.partitionContainers[op.getPartitionId()];
            this.doBackupExpiration(partitionContainer);
        }
    }

    public boolean canPrimaryDriveExpiration() {
        return this.primaryDrivesEviction;
    }

    private void doBackupExpiration(PartitionContainer container) {
        ConcurrentMap<String, RecordStore> maps = container.getMaps();
        for (RecordStore recordStore : maps.values()) {
            this.sendExpiredKeysToBackups(recordStore, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendExpiredKeysToBackups(RecordStore recordStore, boolean checkIfReachedBatch) {
        Collection<ExpiredKey> expiredKeys;
        InvalidationQueue<ExpiredKey> invalidationQueue = recordStore.getExpiredKeys();
        int size = invalidationQueue.size();
        if (size == 0 || checkIfReachedBatch && size < 100) {
            return;
        }
        if (!invalidationQueue.tryAcquire()) {
            return;
        }
        try {
            expiredKeys = ExpirationManager.pollExpiredKeys(invalidationQueue);
        }
        finally {
            invalidationQueue.release();
        }
        if (expiredKeys.size() == 0) {
            return;
        }
        OperationService operationService = this.nodeEngine.getOperationService();
        int backupReplicaCount = recordStore.getMapContainer().getTotalBackupCount();
        for (int replicaIndex = 1; replicaIndex < backupReplicaCount + 1; ++replicaIndex) {
            if (!this.hasReplicaAddress(recordStore.getPartitionId(), replicaIndex)) continue;
            EvictBatchBackupOperation operation = new EvictBatchBackupOperation(recordStore.getName(), expiredKeys, recordStore.size());
            operationService.createInvocationBuilder("hz:impl:mapService", (Operation)operation, recordStore.getPartitionId()).setReplicaIndex(replicaIndex).invoke();
        }
    }

    private boolean hasReplicaAddress(int partitionId, int replicaIndex) {
        return this.partitionService.getPartition(partitionId).getReplicaAddress(replicaIndex) != null;
    }

    private static Collection<ExpiredKey> pollExpiredKeys(Queue<ExpiredKey> expiredKeys) {
        ExpiredKey expiredKey;
        ArrayList<ExpiredKey> polledKeys = new ArrayList<ExpiredKey>(expiredKeys.size());
        while ((expiredKey = expiredKeys.poll()) != null) {
            polledKeys.add(expiredKey);
        }
        return polledKeys;
    }

    int getTaskPeriodSeconds() {
        return this.taskPeriodSeconds;
    }

    boolean getPrimaryDrivesEviction() {
        return this.primaryDrivesEviction;
    }

    int getCleanupPercentage() {
        return this.cleanupPercentage;
    }

    int getCleanupOperationCount() {
        return this.cleanupOperationCount;
    }

    boolean isScheduled() {
        return this.scheduled.get();
    }

    ClearExpiredRecordsTask getTask() {
        return this.task;
    }

    class ClearExpiredRecordsTask
    implements Runnable {
        volatile long lastStartMillis;
        volatile long lastEndMillis;
        private final Comparator<PartitionContainer> partitionContainerComparator = new Comparator<PartitionContainer>(){

            @Override
            public int compare(PartitionContainer o1, PartitionContainer o2) {
                long s2;
                long s1 = o1.getLastCleanupTimeCopy();
                return s1 < (s2 = o2.getLastCleanupTimeCopy()) ? -1 : (s1 == s2 ? 0 : 1);
            }
        };

        ClearExpiredRecordsTask() {
        }

        @Override
        public void run() {
            try {
                if (!ExpirationManager.this.singleRunPermit.compareAndSet(false, true)) {
                    return;
                }
                this.lastStartMillis = System.currentTimeMillis();
                this.runInternal();
                this.lastEndMillis = System.currentTimeMillis();
            }
            finally {
                ExpirationManager.this.singleRunPermit.set(false);
            }
        }

        private void runInternal() {
            long now = Clock.currentTimeMillis();
            int inFlightCleanupOperationsCount = 0;
            List<PartitionContainer> containersToProcess = null;
            for (int partitionId = 0; partitionId < ExpirationManager.this.partitionCount; ++partitionId) {
                IPartition partition = ExpirationManager.this.partitionService.getPartition(partitionId, false);
                PartitionContainer container = ExpirationManager.this.partitionContainers[partitionId];
                if (!partition.isOwnerOrBackup(ExpirationManager.this.thisAddress) || this.isContainerEmpty(container) && !this.hasExpiredKeyToSendBackup(container)) continue;
                if (container.hasRunningCleanup()) {
                    ++inFlightCleanupOperationsCount;
                    continue;
                }
                if (inFlightCleanupOperationsCount > ExpirationManager.this.cleanupOperationCount || this.notInProcessableTimeWindow(container, now) || this.notHaveAnyExpirableRecord(container)) continue;
                containersToProcess = this.addContainerTo(container, containersToProcess);
                if (partition.isLocal()) continue;
                this.clearLeftoverExpiredKeyQueues(container);
            }
            if (CollectionUtil.isEmpty(containersToProcess)) {
                return;
            }
            this.sortPartitionContainers(containersToProcess);
            this.sendCleanupOperations(containersToProcess);
        }

        private List<PartitionContainer> addContainerTo(PartitionContainer container, List<PartitionContainer> containersToProcess) {
            if (containersToProcess == null) {
                containersToProcess = new ArrayList<PartitionContainer>();
            }
            containersToProcess.add(container);
            return containersToProcess;
        }

        private void sortPartitionContainers(List<PartitionContainer> partitionContainers) {
            ExpirationManager.this.updateLastCleanupTimesBeforeSorting(partitionContainers);
            Collections.sort(partitionContainers, this.partitionContainerComparator);
        }

        private void sendCleanupOperations(List<PartitionContainer> partitionContainers) {
            boolean start = false;
            int end = ExpirationManager.this.cleanupOperationCount;
            if (end > partitionContainers.size()) {
                end = partitionContainers.size();
            }
            List<PartitionContainer> partitionIds = partitionContainers.subList(0, end);
            for (PartitionContainer container : partitionIds) {
                container.setHasRunningCleanup(true);
                Operation operation = ExpirationManager.this.createExpirationOperation(ExpirationManager.this.cleanupPercentage, container.getPartitionId());
                ExpirationManager.this.operationService.execute(operation);
            }
        }

        private boolean notInProcessableTimeWindow(PartitionContainer partitionContainer, long now) {
            return now - partitionContainer.getLastCleanupTime() < 1000L;
        }

        private boolean isContainerEmpty(PartitionContainer container) {
            long size = 0L;
            ConcurrentMap<String, RecordStore> maps = container.getMaps();
            for (RecordStore store : maps.values()) {
                if ((size += (long)store.size()) <= 0L) continue;
                return false;
            }
            return true;
        }

        private boolean hasExpiredKeyToSendBackup(PartitionContainer container) {
            long size = 0L;
            ConcurrentMap<String, RecordStore> maps = container.getMaps();
            for (RecordStore store : maps.values()) {
                if ((size += (long)store.getExpiredKeys().size()) <= 0L) continue;
                return true;
            }
            return false;
        }

        private void clearLeftoverExpiredKeyQueues(PartitionContainer container) {
            ConcurrentMap<String, RecordStore> maps = container.getMaps();
            for (RecordStore store : maps.values()) {
                InvalidationQueue<ExpiredKey> expiredKeys = store.getExpiredKeys();
                while (expiredKeys.poll() != null) {
                }
            }
        }

        private boolean notHaveAnyExpirableRecord(PartitionContainer partitionContainer) {
            boolean notExist = true;
            ConcurrentMap<String, RecordStore> maps = partitionContainer.getMaps();
            for (RecordStore store : maps.values()) {
                if (!store.isExpirable()) continue;
                notExist = false;
                break;
            }
            return notExist;
        }

        public String toString() {
            return ClearExpiredRecordsTask.class.getName();
        }
    }
}

