/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.admin.plugins;


/**
 * This class is used to return how the list query are expanded by a plugin. Therefore this class
 * contains two attributes: a table name which will be added, and a query part which will be added
 *
 * @author <a href="mailto:dennis.sieben@open-xchange.com">Dennis Sieben</a>
 *
 */
public class SQLQueryExtension {

    private final String tablename;

    private final String querypart;

    /**
     * Initializes a new {@link SQLQueryExtension}.
     * @param tablename
     * @param querypart
     */
    public SQLQueryExtension(final String tablename, final String querypart) {
        super();
        this.tablename = tablename;
        this.querypart = querypart;
    }


    public final String getTablename() {
        return tablename;
    }


    public final String getQuerypart() {
        return querypart;
    }

}
