/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.worker;

import com.openexchange.build.ProjectType;
import com.openexchange.build.projecttype.scanner.ProjectTypeExtension;
import com.openexchange.osgi.OSGiPlugin;
import com.openexchange.osgi.data.AbstractModule;
import com.openexchange.osgi.data.Classpath;
import com.openexchange.osgi.worker.WorkerParameters;
import com.openexchange.osgi.worker.handler.ProjectHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.workers.WorkAction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J0\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/openexchange/osgi/worker/ProjectDependenciesResolver;", "Lorg/gradle/workers/WorkAction;", "Lcom/openexchange/osgi/worker/WorkerParameters;", "()V", "execute", "", "resolveBinaryDependencies", "project", "Lorg/gradle/api/Project;", "implementationConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "binaryArtifactPaths", "", "", "resolveProjectDependencies", "testImplementationConfiguration", "projectDependencies", "osgi"})
public abstract class ProjectDependenciesResolver
implements WorkAction<WorkerParameters> {
    public void execute() {
        String projectName = (String)((WorkerParameters)this.getParameters()).getProjectName().get();
        Project project = (Project)OSGiPlugin.Companion.getProjectsPool().get(projectName);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Classpath classPath = ProjectHandler.Companion.getClasspath(project2);
        SourceSetContainer sourceSets = (SourceSetContainer)project2.getExtensions().getByType(SourceSetContainer.class);
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        SourceSet testSourceSet = (SourceSet)sourceSets.getByName("test");
        Configuration implementationConfiguration = project2.getConfigurations().getByName(mainSourceSet.getImplementationConfigurationName());
        Configuration testImplementationConfiguration = project2.getConfigurations().getByName(testSourceSet.getImplementationConfigurationName());
        Intrinsics.checkNotNullExpressionValue((Object)implementationConfiguration, (String)"implementationConfiguration");
        Intrinsics.checkNotNullExpressionValue((Object)testImplementationConfiguration, (String)"testImplementationConfiguration");
        Classpath classpath = classPath;
        this.resolveProjectDependencies(project2, implementationConfiguration, testImplementationConfiguration, classpath != null ? classpath.getProjectDependencies() : null);
        Object object = classPath;
        if (object == null || (object = ((Classpath)object).getLibs()) == null) {
            object = SetsKt.emptySet();
        }
        this.resolveBinaryDependencies(project2, implementationConfiguration, (Set<String>)object);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"compileClasspath", (Object)mainSourceSet.getCompileClasspath()), TuplesKt.to((Object)"runtimeClasspath", (Object)mainSourceSet.getRuntimeClasspath()), TuplesKt.to((Object)"testCompileClasspath", (Object)testSourceSet.getCompileClasspath()), TuplesKt.to((Object)"testRuntimeClasspath", (Object)testSourceSet.getRuntimeClasspath())};
        OSGiPlugin.Companion.registerTasks(project2, MapsKt.mapOf((Pair[])pairArray));
    }

    private final void resolveProjectDependencies(Project project, Configuration implementationConfiguration, Configuration testImplementationConfiguration, Set<String> projectDependencies) {
        block3: {
            Set<String> set = projectDependencies;
            if (set == null) break block3;
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                AbstractModule targetPlatformProject = OSGiPlugin.Companion.getModuleDatabase().searchBinariesForProject$osgi(it);
                if (targetPlatformProject != null) {
                    Object[] objectArray = new Object[]{targetPlatformProject.getExportedClasspath()};
                    implementationConfiguration.getDependencies().add((Object)project.getDependencies().create((Object)project.files(objectArray)));
                    continue;
                }
                Project depProject = project.getRootProject().findProject(it);
                if (depProject != null) {
                    ProjectType projectType;
                    ProjectType projectType2 = projectType = (ProjectType)((ProjectTypeExtension)depProject.getExtensions().getByType(ProjectTypeExtension.class)).getType().get();
                    ((projectType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[projectType2.ordinal()]) == 1 ? testImplementationConfiguration : implementationConfiguration).getDependencies().add((Object)project.getDependencies().create((Object)depProject));
                    continue;
                }
                throw new GradleException("Unable to resolve dependency to project " + it + " of " + project.getName() + '.');
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void resolveBinaryDependencies(Project project, Configuration implementationConfiguration, Set<String> binaryArtifactPaths) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = binaryArtifactPaths;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file;
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null)) {
                String pathWithoutPrefix = StringsKt.removePrefix((String)it, (CharSequence)"/");
                String depProjectName = StringsKt.substringBefore$default((String)pathWithoutPrefix, (String)"/", null, (int)2, null);
                String filename = StringsKt.substringAfterLast$default((String)pathWithoutPrefix, (String)"/", null, (int)2, null);
                AbstractModule targetPlatformProject = OSGiPlugin.Companion.getModuleDatabase().searchBinariesForFilename(filename);
                Project depProject = project.getRootProject().findProject(depProjectName);
                AbstractModule abstractModule = targetPlatformProject;
                if (abstractModule != null) {
                    file = abstractModule.getFile();
                } else {
                    Project project2 = depProject;
                    if (project2 == null) throw new GradleException("Unable to resolve library dependency " + (String)it + " of " + project.getName() + '.');
                    File file2 = project2.getProjectDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"depProject.projectDir");
                    file = FilesKt.resolve((File)file2, (String)StringsKt.substringAfter$default((String)pathWithoutPrefix, (String)"/", null, (int)2, null));
                }
            } else {
                file = new File((String)it);
            }
            collection.add(file);
        }
        List binaryArtifacts = (List)destination$iv$iv;
        Object[] $i$f$map22 = new Object[]{binaryArtifacts};
        ConfigurableFileCollection binaryArtifactsFileCollection = project.files($i$f$map22);
        Dependency binaryArtifactsDependency = project.getDependencies().create((Object)binaryArtifactsFileCollection);
        implementationConfiguration.getDependencies().add((Object)binaryArtifactsDependency);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectType.values().length];
            try {
                nArray[ProjectType.TEST_BUNDLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

