/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.util.activator.impl;

import static com.openexchange.util.custom.base.NullUtil.build;
import static com.openexchange.util.custom.base.NullUtil.className;
import static com.openexchange.util.custom.base.NullUtil.emptySet;
import java.util.Dictionary;
import javax.servlet.http.HttpServlet;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import com.google.common.collect.ImmutableSet;
import com.openexchange.annotation.Nullable;
import com.openexchange.config.ConfigurationService;
import com.openexchange.util.activator.DependencyProvider;
import com.openexchange.util.activator.ServiceDependencyResolver;
import com.openexchange.util.activator.ServiceRegistrationHandler;


/**
 * {@link ServletInstanceServiceWithDependencies}
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v1.0.0
 */
public class ServletInstanceServiceWithDependencies<T extends HttpServlet> extends ServiceInstanceServiceWithDependencies<HttpServlet, T> {

    private static final ImmutableSet<MandatoryServiceDependency<?>> deps(final String path) {
        final ImmutableSet.Builder<MandatoryServiceDependency<?>> b = ImmutableSet.builder();
        b.add(new MandatoryServiceDependency<>(HttpService.class));
        if (path.contains("${")) {
            b.add(new MandatoryServiceDependency<>(ConfigurationService.class));
        }
        return build(b);
    }
    
    private final String path;
    
    public ServletInstanceServiceWithDependencies(final T serviceInstance, final String path) {
        super(serviceInstance, HttpServlet.class, deps(path), null);
        this.path = path;
    }

    @Override
    protected ServiceTrackerCustomizer<HttpServlet, T> createRegisterer(final BundleContext bundleContext,
        final ActivatorRegistry registry,
        final ImmutableSet<Class<?>> serviceClasses,
        final Dictionary<String, ?> properties,
        final @Nullable ServiceRegistrationHandler<T> serviceRegistrationHandler) {
        return new ServletServiceRegistererTemplate<T>(path,
            bundleContext,
            serviceClasses,
            className(serviceInstance),
            properties,
            mandatoryDependencies,
            optionalDependencies,
            RegistrationTools.serviceSets(bundleContext, registry, emptySet()),
            RegistrationTools.serviceListings(bundleContext, registry, emptySet()),
            RegistrationTools.collectPropertiesOfInterest(mandatoryDependencies, optionalDependencies)) {
            @Override
            protected T createInstance(final ServiceDependencyResolver resolver)
                throws Exception {
                if (serviceInstance instanceof DependencyProvider) {
                    ((DependencyProvider) serviceInstance).onDependenciesAvailable(resolver);
                }
                if (serviceRegistrationHandler != null) {
                    serviceRegistrationHandler.onServiceRegistered(serviceInstance);
                }
                return serviceInstance;
            }
        };
    }

}
