/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.connector.sync;

import java.util.Comparator;
import com.openexchange.usm.api.contenttypes.common.ContentType;
import com.openexchange.usm.api.contenttypes.common.ContentTypeField;
import com.openexchange.usm.api.datatypes.DataTypes;
import com.openexchange.usm.api.session.DataObject;

public abstract class DataObjectSorter implements Comparator<DataObject> {

    protected DataObjectSorter() {
        super();
    }

    protected final int getFieldIndex(ContentType c, String field) {
        ContentTypeField[] fields = c.getFields();
        for (int i = 0; i < fields.length; i++) {
            if (fields[i].getFieldName().equals(field))
                return i;
        }
        throw new IllegalStateException("ContentType " + c.getID() + " has no field named " + field);
    }

    protected int compareTimestamp(DataObject o1, DataObject o2, int index) {
        long l1 = getTimestamp(o1, index);
        long l2 = getTimestamp(o2, index);
        return (l1 > l2) ? -1 : (l1 < l2) ? 1 : 0;
    }

    protected int compareString(DataObject o1, DataObject o2, int index) {
        Object v1 = o1.getFieldContent(index);
        Object v2 = o2.getFieldContent(index);
        if (v1 == null)
            return (v2 == null) ? 0 : -1;
        return (v2 == null) ? 1 : v1.toString().compareTo(v2.toString());
    }

    protected long getTimestamp(DataObject o1, int index) {
        Object o = o1.getFieldContent(index);
        return (o instanceof Number) ? ((Number) o).longValue() : 0L;
    }

    protected int compareBoolean(DataObject o1, DataObject o2, int index) {
        Object v1 = o1.getFieldContent(index);
        Object v2 = o2.getFieldContent(index);
        if (v1 == null)
            return (v2 == null) ? 0 : -1;
        if (v2 == null)
            return 1;
        Boolean b1 = DataTypes.BOOLEAN.checkValue(v1);
        Boolean b2 = DataTypes.BOOLEAN.checkValue(v2);
        if (b1.equals(b2))
            return 0;
        if (Boolean.TRUE.equals(b1))
            return 1;
        return -1;
    }
}
