/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.session;

/**
 * This object is returned on waitForChanges and provided to the SessionChangeListener.
 * It provides two different types of changes:<br><ul>
 * <li>Changes to the folder structure (e.g. new folder) or folder fields like title
 * <li>Changes to elements in folders (e.g. addition of a new contact, changes to fields of an element)
 * </ul>
 * In both cases the ID of the parent folder containing the modifications is returned.
 * <br>TODO Based on the OX events we might be able to additionally/instead provide the exact list of changed object IDs
 * 
 * @author afe
 *
 */
public interface ObjectChanges {
	/**
	 * Returns true if the folder structure itself has been change, i.e. at least one folder
	 * has changed a field, has been added oder removed.
	 * 
	 * @return true if the folder structure changed
	 */
	boolean hasFolderStructureChanged();

	/**
	 * Returns list of folder IDs in which changes to content elements occurred.
	 * These changes can be new elements, deleted elements, changed or moved (source parent folder is reported) elements.
	 * 
	 * @return ID of parent folders for changes to elements in folders
	 */
	String[] getContentChangeParentIDs();
}
