/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */



package com.openexchange.office.tools.database;


/**
 * {@link ConnectionPoolData}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 * @since v7.10.1
 */
public interface ConnectionPoolData {

    /**
     * DEFAULT_POOL_MAXSIZE
     */
    final public static int DEFAULT_POOL_MAXSIZE = 3;

    /**
     * DEFAULT_POOL_CONNECTTIMEOUTMILLIS
     */
    final public static int DEFAULT_POOL_CONNECTTIMEOUTMILLIS = 120000;

    /**
     * DEFAULT_POOL_IDLETIMEOUTMILLIS
     */
    final public static int DEFAULT_POOL_IDLETIMEOUTMILLIS = 300000;

    /**
     * @return The number of open connections within the database connection pool.
     */
    public default int getConnectionPoolSize() {
        return DEFAULT_POOL_MAXSIZE;
    }

    /**
     * @return The connection timeout of a pooled connection.
     *  Given in milliseconds.
     */
    public default long getConnectionPoolConnectTimeoutMillis() {
        return DEFAULT_POOL_CONNECTTIMEOUTMILLIS;
    }

    /**
     * @return The idle timeout of a pooled connection, after which an idling
     *  connection is closed and removed from the pool. Given in milliseconds.
     */
    public default long getConnectionPoolIdleTimeoutMillis() {
        return DEFAULT_POOL_IDLETIMEOUTMILLIS;
    }
}
