/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */


package com.openexchange.office.spellcheck.impl.hunspell;

import com.sun.jna.Library;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;

/**
 * Functions from $hunspell/src/hunspell/hunspell.h
 *
 * The Hunspell java bindings are licensed under LGPL, see the file COPYING.txt
 * in the root of the distribution for the exact terms.
 *
 * @author Flemming Frandsen (flfr at stibo dot com)
 */

public interface HunspellLibrary extends Library {

	/**
	 * Create the hunspell instance
	 *
	 * @param affpath
	 *            The affix file
	 * @param dpath
	 *            The dictionary file
	 * @return The hunspell object
	 */
	public Pointer Hunspell_create(String affpath, String dpath);

	/**
	 * Destroy him my robots...
	 *
	 * @param pHunspell
	 *            The Hunspell object returned by Hunspell_create
	 */
	public void Hunspell_destroy(Pointer pHunspell);

	/**
	 * Get the dictionary encoding
	 *
	 * @param pHunspell
	 *            : The Hunspell object returned by Hunspell_create
	 * @return The encoding name
	 */
	public String Hunspell_get_dic_encoding(Pointer pHunspell);

	/**
	 * spell(word) - spellcheck word
	 *
	 * @param pHunspell
	 *            The Hunspell object returned by Hunspell_create
	 * @param word
	 *            The word to spellcheck.
	 * @return 0 = bad word, not 0 = good word
	 */
	public int Hunspell_spell(Pointer pHunspell, byte[] word);

	/**
	 * Get stems of a word
	 *
	 * @param pHunspell
	 *            The Hunspell object returned by Hunspell_create
	 * @param slst
	 * @param word
	 *            The word to get the stems for.
	 */
	public int Hunspell_stem(Pointer pHunspell, PointerByReference slst,
			byte[] word);

	/**
	 * Search suggestions
	 *
	 * @param pHunspell
	 *            The Hunspell object returned by Hunspell_create
	 * @param slst
	 *            input: pointer to an array of strings pointer and the (bad)
	 *            word array of strings pointer (here *slst) may not be
	 *            initialized output: number of suggestions in string array, and
	 *            suggestions in a newly allocated array of strings (*slts will
	 *            be NULL when number of suggestion equals 0.)
	 * @param word
	 *            The word to offer suggestions for.
	 */
	public int Hunspell_suggest(Pointer pHunspell, PointerByReference slst,
			byte[] word);
}
