/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.office.rt2.protocol.internal;

import org.apache.commons.lang3.StringUtils;

public enum Cause {

    SESSION_INVALID,
    GARBAGE_COLLECTING;

    //-------------------------------------------------------------------------
    public static String toString (final Cause cause)
    {
        if (cause == Cause.SESSION_INVALID)
            return SESSION_INVALID.toString();

        if (cause == Cause.GARBAGE_COLLECTING)
            return GARBAGE_COLLECTING.toString();

        throw new UnsupportedOperationException ("Unknown '"+cause+"' detected.");
    }

    //-------------------------------------------------------------------------
    public static Cause fromString (final String cause)
    {
        if (StringUtils.equalsIgnoreCase(cause, SESSION_INVALID.toString()))
            return Cause.SESSION_INVALID;

        if (StringUtils.equalsIgnoreCase(cause, GARBAGE_COLLECTING.toString()))
            return Cause.GARBAGE_COLLECTING;

        throw new UnsupportedOperationException ("Unknown '"+cause+"' detected.");
    }
}
