/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/*
 *
 *  Copyright (C) 2016 OX Software GmbH All rights reserved.
 *
 *  This program is proprietary software and licensed to you under
 *  OX Software GmbH's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks.
 *
 */

package com.openexchange.office.monitoring;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Service;
import com.openexchange.office.monitoring.api.IMonitoring;
import com.openexchange.office.tools.doc.DocumentType;
import com.openexchange.office.tools.monitoring.CloseType;
import com.openexchange.office.tools.monitoring.OpenType;
import com.openexchange.office.tools.monitoring.OperationsType;
import com.openexchange.office.tools.monitoring.SaveType;
import com.openexchange.office.tools.monitoring.Statistics;
import com.udojava.jmx.wrapper.JMXBean;
import com.udojava.jmx.wrapper.JMXBeanAttribute;

/**
 * {@link OfficeMonitoring}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
@JMXBean
@ManagedResource(objectName="com.openexchange.office:name=OfficeMonitoring")
@Service
public class OfficeMonitoring implements IMonitoring {

    public static final String DOMAIN = "com.openexchange.office";

    @Autowired
    private Statistics m_statistics;

//    /**
//     * Initializes a new {@link OfficeMonitoring}.
//     * @param statistics
//     * @throws NotCompliantMBeanException
//     */
//    public OfficeMonitoring() throws NotCompliantMBeanException {
//        super(IMonitoring.class);
//    }

    // - IMonitoringCommon

    /* (non-Javadoc)
     * @see com.openexchange.office.IInformation#getDocumentsCreated_Total()
     */
    @JMXBeanAttribute(name="AdvisoryLockInfo_Mode")
    @Override
    public String getAdvisoryLockInfo_Mode() {
        return m_statistics.getAdvisoryLockInfoMode();
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.IInformation#getDocumentsCreated_Total()
     */
    @JMXBeanAttribute(name="DocumentsCreated_Total")
    @Override
    public long getDocumentsCreated_Total() {
        return m_statistics.getDocumentsCreated(null);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentsCreated_Text()
     */
    @JMXBeanAttribute(name="DocumentsCreated_Text")
    @Override
    public long getDocumentsCreated_Text() {
        return m_statistics.getDocumentsCreated(DocumentType.TEXT);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.IInformation#getDocumentsCreated_Spreadsheet()
     */
    @JMXBeanAttribute(name="DocumentsCreated_Spreadsheet")
    @Override
    public long getDocumentsCreated_Spreadsheet() {
        return m_statistics.getDocumentsCreated(DocumentType.SPREADSHEET);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.IInformation#getDocumentsCreated_Presentation()
     */
    @JMXBeanAttribute(name="DocumentsCreated_Presentation")
    @Override
    public long getDocumentsCreated_Presentation() {
        return m_statistics.getDocumentsCreated(DocumentType.PRESENTATION);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.IMonitoring#getMedianDocumentsSize_Total()
     */
    @JMXBeanAttribute(name="DocumentsSizeMedian_Total")
    @Override
    public long getDocumentsSizeMedian_Total() {
        return m_statistics.getDocumentsSizeMedian(null);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getMedianDocumentsSize_Text_KB()
     */
    @JMXBeanAttribute(name="DocumentsSizeMedian_Text")
    @Override
    public long getDocumentsSizeMedian_Text() {
        return m_statistics.getDocumentsSizeMedian(DocumentType.TEXT);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.IInformation#getMedianDocumentsSize_Spreadsheet()
     */
    @JMXBeanAttribute(name="DocumentsSizeMedian_Spreadsheet")
    @Override
    public long getDocumentsSizeMedian_Spreadsheet() {
        return m_statistics.getDocumentsSizeMedian(DocumentType.SPREADSHEET);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.IInformation#getMedianDocumentsSize_Presentation()
     */
    @JMXBeanAttribute(name="DocumentsSizeMedian_Presentation")
    @Override
    public long getDocumentsSizeMedian_Presentation() {
        return m_statistics.getDocumentsSizeMedian(DocumentType.PRESENTATION);
    }

    @JMXBeanAttribute(name="RestoreDocsCreated_Total")
    @Override
    public long getRestoreDocsCreated_Total() {
        return m_statistics.getRestoreDocCreated();
    }

    @JMXBeanAttribute(name="RestoreDocsRemoved_Total")
    @Override
    public long getRestoreDocsRemoved_Total() {
        return m_statistics.getRestoreDocRemoved();
    }

    @JMXBeanAttribute(name="RestoreDocs_Current")
    @Override
    public long getRestoreDocs_Current() {
        return m_statistics.getRestoreDocCurrent();
    }

    @JMXBeanAttribute(name="RestoreDocsRestored_Success")
    @Override
    public long getRestoreDocsRestored_Success() {
        return m_statistics.getRestoreDocRestoredSuccess();
    }

    @JMXBeanAttribute(name="RestoreDocsRestored_Failure")
    @Override
    public long getRestoreDocsRestored_Failure() {
        return m_statistics.getRestoreDocRestoredFailure();
    }

    // - IMonitoringText

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentsOpened_Text_Total()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Text_Total")
    @Override
    public long getDocumentsOpened_Text_Total() {
        return m_statistics.getDocumentsOpened(DocumentType.TEXT, null);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentsOpened_Text_Msx()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Text_OOXML")
    @Override
    public long getDocumentsOpened_Text_OOXML() {
        return m_statistics.getDocumentsOpened(DocumentType.TEXT, OpenType.MSX);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentsOpened_Text_Binary()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Text_Binary")
    @Override
    public long getDocumentsOpened_Text_Binary() {
        return m_statistics.getDocumentsOpened(DocumentType.TEXT, OpenType.BINARY);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentsOpened_Text_Odf()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Text_ODF")
    @Override
    public long getDocumentsOpened_Text_ODF() {
        return m_statistics.getDocumentsOpened(DocumentType.TEXT, OpenType.ODF);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentsClosed_Text_Total()
     */
    @JMXBeanAttribute(name="DocumentsClosed_Text_Total")
    @Override
    public long getDocumentsClosed_Text_Total() {
        return m_statistics.getDocumentsClosed(DocumentType.TEXT, CloseType.CLOSE);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentsClosed_Text_Timeout()
     */
    @JMXBeanAttribute(name="DocumentsClosed_Text_Timeout")
    @Override
    public long getDocumentsClosed_Text_Timeout() {
        return m_statistics.getDocumentsClosed(DocumentType.TEXT, CloseType.TIMEOUT);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.IInformation#getDocumentsSaved_Text_Total()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Text_Total")
    @Override
    public long getDocumentsSaved_Text_Total() {
        return m_statistics.getDocumentsSaved(DocumentType.TEXT, null);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentsSaved_Text_Close()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Text_Close")
    @Override
    public long getDocumentsSaved_Text_Close() {
        return m_statistics.getDocumentsSaved(DocumentType.TEXT, SaveType.CLOSE);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentsSaved_Text_100ops()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Text_100ops")
    @Override
    public long getDocumentsSaved_Text_100ops() {
        return m_statistics.getDocumentsSaved(DocumentType.TEXT, SaveType.OPS_100);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentsSaved_Text_15min()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Text_15mins")
    @Override
    public long getDocumentsSaved_Text_15mins() {
        return m_statistics.getDocumentsSaved(DocumentType.TEXT, SaveType.OPS_15MINS);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentOperations_Text_Incoming()
     */
    @JMXBeanAttribute(name="DocumentsOperations_Text_Incoming")
    @Override
    public long getDocumentsOperations_Text_Incoming() {
        return m_statistics.getDocumentsOperations(DocumentType.TEXT, OperationsType.INCOMING);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Text_Outgoing_Distributeted#getDocumentOperations_Text_Outgoing_Distributeted()
     */
    @JMXBeanAttribute(name="DocumentsOperations_Text_Distributed")
    @Override
    public long getDocumentsOperations_Text_Distributed() {
        return m_statistics.getDocumentsOperations(DocumentType.TEXT, OperationsType.DISTRIBUTED);
    }

    // - IMonitoringSpreadsheet

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Spreadsheet_Outgoing_Distributeted#getDocumentsOpened_Spreadsheet_Total()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Spreadsheet_Total")
    @Override
    public long getDocumentsOpened_Spreadsheet_Total() {
        return m_statistics.getDocumentsOpened(DocumentType.SPREADSHEET, null);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Spreadsheet_Outgoing_Distributeted#getDocumentsOpened_Spreadsheet_Msx()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Spreadsheet_OOXML")
    @Override
    public long getDocumentsOpened_Spreadsheet_OOXML() {
        return m_statistics.getDocumentsOpened(DocumentType.SPREADSHEET, OpenType.MSX);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Spreadsheet_Outgoing_Distributeted#getDocumentsOpened_Spreadsheet_Binary()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Spreadsheet_Binary")
    @Override
    public long getDocumentsOpened_Spreadsheet_Binary() {
        return m_statistics.getDocumentsOpened(DocumentType.SPREADSHEET, OpenType.BINARY);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Spreadsheet_Outgoing_Distributeted#getDocumentsOpened_Spreadsheet_Odf()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Spreadsheet_ODF")
    @Override
    public long getDocumentsOpened_Spreadsheet_ODF() {
        return m_statistics.getDocumentsOpened(DocumentType.SPREADSHEET, OpenType.ODF);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Spreadsheet_Outgoing_Distributeted#getDocumentsClosed_Spreadsheet_Total()
     */
    @JMXBeanAttribute(name="DocumentsClosed_Spreadsheet_Total")
    @Override
    public long getDocumentsClosed_Spreadsheet_Total() {
        return m_statistics.getDocumentsClosed(DocumentType.SPREADSHEET, CloseType.CLOSE);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Spreadsheet_Outgoing_Distributeted#getDocumentsClosed_Spreadsheet_Timeout()
     */
    @JMXBeanAttribute(name="DocumentsClosed_Spreadsheet_Timeout")
    @Override
    public long getDocumentsClosed_Spreadsheet_Timeout() {
        return m_statistics.getDocumentsClosed(DocumentType.SPREADSHEET, CloseType.TIMEOUT);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.IInformation#getDocumentsSaved_Spreadsheet_Total()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Spreadsheet_Total")
    @Override
    public long getDocumentsSaved_Spreadsheet_Total() {
        return m_statistics.getDocumentsSaved(DocumentType.SPREADSHEET, null);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Spreadsheet_Outgoing_Distributeted#getDocumentsSaved_Spreadsheet_Close()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Spreadsheet_Close")
    @Override
    public long getDocumentsSaved_Spreadsheet_Close() {
        return m_statistics.getDocumentsSaved(DocumentType.SPREADSHEET, SaveType.CLOSE);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Spreadsheet_Outgoing_Distributeted#getDocumentsSaved_Spreadsheet_100ops()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Spreadsheet_100ops")
    @Override
    public long getDocumentsSaved_Spreadsheet_100ops() {
        return m_statistics.getDocumentsSaved(DocumentType.SPREADSHEET, SaveType.OPS_100);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Spreadsheet_Outgoing_Distributeted#getDocumentsSaved_Spreadsheet_15min()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Spreadsheet_15mins")
    @Override
    public long getDocumentsSaved_Spreadsheet_15mins() {
        return m_statistics.getDocumentsSaved(DocumentType.SPREADSHEET, SaveType.OPS_15MINS);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Spreadsheet_Outgoing_Distributeted#getDocumentOperations_Spreadsheet_Incoming()
     */
    @JMXBeanAttribute(name="DocumentsOperations_Spreadsheet_Incoming")
    @Override
    public long getDocumentsOperations_Spreadsheet_Incoming() {
        return m_statistics.getDocumentsOperations(DocumentType.SPREADSHEET, OperationsType.INCOMING);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Spreadsheet_Outgoing_Distributeted#getDocumentOperations_Spreadsheet_Outgoing_Distributeted()
     */
    @JMXBeanAttribute(name="DocumentsOperations_Spreadsheet_Distributed")
    @Override
    public long getDocumentsOperations_Spreadsheet_Distributed() {
        return m_statistics.getDocumentsOperations(DocumentType.SPREADSHEET, OperationsType.DISTRIBUTED);
    }

    // - IMonitoring Presentation ----------------------------------------------

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Presentation_Outgoing_Distributeted#getDocumentsOpened_Presentation_Total()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Presentation_Total")
    @Override
    public long getDocumentsOpened_Presentation_Total() {
        return m_statistics.getDocumentsOpened(DocumentType.PRESENTATION, null);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Presentation_Outgoing_Distributeted#getDocumentsOpened_Presentation_Msx()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Presentation_OOXML")
    @Override
    public long getDocumentsOpened_Presentation_OOXML() {
        return m_statistics.getDocumentsOpened(DocumentType.PRESENTATION, OpenType.MSX);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Presentation_Outgoing_Distributeted#getDocumentsOpened_Presentation_Binary()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Presentation_Binary")
    @Override
    public long getDocumentsOpened_Presentation_Binary() {
        return m_statistics.getDocumentsOpened(DocumentType.PRESENTATION, OpenType.BINARY);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Presentation_Outgoing_Distributeted#getDocumentsOpened_Presentation_Odf()
     */
    @JMXBeanAttribute(name="DocumentsOpened_Presentation_ODF")
    @Override
    public long getDocumentsOpened_Presentation_ODF() {
        return m_statistics.getDocumentsOpened(DocumentType.PRESENTATION, OpenType.ODF);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Presentation_Outgoing_Distributeted#getDocumentsClosed_Presentation_Total()
     */
    @JMXBeanAttribute(name="DocumentsClosed_Presentation_Total")
    @Override
    public long getDocumentsClosed_Presentation_Total() {
        return m_statistics.getDocumentsClosed(DocumentType.PRESENTATION, CloseType.CLOSE);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Presentation_Outgoing_Distributeted#getDocumentsClosed_Presentation_Timeout()
     */
    @JMXBeanAttribute(name="DocumentsClosed_Presentation_Timeout")
    @Override
    public long getDocumentsClosed_Presentation_Timeout() {
        return m_statistics.getDocumentsClosed(DocumentType.PRESENTATION, CloseType.TIMEOUT);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.IInformation#getDocumentsSaved_Presentation_Total()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Presentation_Total")
    @Override
    public long getDocumentsSaved_Presentation_Total() {
        return m_statistics.getDocumentsSaved(DocumentType.PRESENTATION, null);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Presentation_Outgoing_Distributeted#getDocumentsSaved_Presentation_Close()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Presentation_Close")
    @Override
    public long getDocumentsSaved_Presentation_Close() {
        return m_statistics.getDocumentsSaved(DocumentType.PRESENTATION, SaveType.CLOSE);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Presentation_Outgoing_Distributeted#getDocumentsSaved_Presentation_100ops()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Presentation_100ops")
    @Override
    public long getDocumentsSaved_Presentation_100ops() {
        return m_statistics.getDocumentsSaved(DocumentType.PRESENTATION, SaveType.OPS_100);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Presentation_Outgoing_Distributeted#getDocumentsSaved_Presentation_15min()
     */
    @JMXBeanAttribute(name="DocumentsSaved_Presentation_15mins")
    @Override
    public long getDocumentsSaved_Presentation_15mins() {
        return m_statistics.getDocumentsSaved(DocumentType.PRESENTATION, SaveType.OPS_15MINS);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Presentation_Outgoing_Distributeted#getDocumentOperations_Presentation_Incoming()
     */
    @JMXBeanAttribute(name="DocumentsOperations_Presentation_Incoming")
    @Override
    public long getDocumentsOperations_Presentation_Incoming() {
        return m_statistics.getDocumentsOperations(DocumentType.PRESENTATION, OperationsType.INCOMING);
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.getDocumentsOperations_Presentation_Outgoing_Distributeted#getDocumentOperations_Presentation_Outgoing_Distributeted()
     */
    @JMXBeanAttribute(name="DocumentsOperations_Presentation_Distributed")
    @Override
    public long getDocumentsOperations_Presentation_Distributed() {
        return m_statistics.getDocumentsOperations(DocumentType.PRESENTATION, OperationsType.DISTRIBUTED);
    }

    @JMXBeanAttribute(name="DocumentsStarted_RemotePresenter_Total")
	@Override
	public long getDocumentsStarted_RemotePresenter_Total() {
		return m_statistics.getDocumentsStarted_RemotePresenterTotal();
	}

    @JMXBeanAttribute(name="DocumentsOpened_Presenter_Total")
	@Override
	public long getDocumentsOpened_Presenter_Total() {
		return m_statistics.getDocumentsOpenedPresenterTotal();
	}

    @JMXBeanAttribute(name="DocumentsClosed_Presenter_Total")
	@Override
	public long getDocumentsClosed_Presenter_Total() {
		return m_statistics.getDocumentsClosedPresenterTotal();
	}

    @JMXBeanAttribute(name="DocumentsClosed_Presenter_Timeout")
	@Override
	public long getDocumentsClosed_Presenter_Timeout() {
		return m_statistics.getDocumentsClosedPresenterTimeout();
	}

    @JMXBeanAttribute(name="DocumentsOperations_Presenter_Incoming")
	@Override
	public long getDocumentsOperations_Presenter_Incoming() {
		return m_statistics.getDocumentsOperationsPresenterIncoming();
	}

    @JMXBeanAttribute(name="DocumentsOperations_Presenter_Distributed")
	@Override
	public long getDocumentsOperations_Presenter_Distributed() {
		return m_statistics.getDocumentsOperationsPresenterDistributed();
	}

    @JMXBeanAttribute(name="RestoreDocsOpsMsgs_StoredLastCycle")
	@Override
	public long getRestoreDocsOpsMsgs_StoredLastCycle() {
		return m_statistics.getRestoreDocOpsMsgStored();
	}

    @JMXBeanAttribute(name="RestoreDocsOpsMsgs_StoreTimeNeededLastCycle")
	@Override
	public long getRestoreDocsOpsMsgs_StoreTimeNeededLastCycle() {
		return m_statistics.getRestoreDocOpsMsgStoredTime();
	}

    @JMXBeanAttribute(name="BackgroundSave_SavedLastCycle")
	@Override
	public long getBackgroundSave_SavedLastCycle() {
		return m_statistics.getBackgroundSaveLastCycleDocCount();
	}

    @JMXBeanAttribute(name="BackgroundSave_TimeNeededLastCycle")
	@Override
	public long getBackgroundSave_TimeNeededLastCycle() {
		return m_statistics.getBackgroundSaveLastCycleTime();
	}

    @JMXBeanAttribute(name="BackgroundSave_AverageTimePerDoc")
	@Override
	public long getBackgroundSave_AverageTimePerDoc() {
		return m_statistics.getBackgroundSaveAverageTimePerDoc();
	}

    @JMXBeanAttribute(name="BackgroundSave_Setting_MaxTimeForSave")
	@Override
	public long getBackgroundSave_Setting_MaxTimeForSave() {
		return m_statistics.getBackgroundSaveMaxTimeForSave();
	}

    @JMXBeanAttribute(name="BackgroundSave_Setting_MinTimeForFasterSave")
	@Override
	public long getBackgroundSave_Setting_MinTimeForFasterSave() {
		return m_statistics.getBackgroundSaveMinTimeFasterSave();
	}

    @JMXBeanAttribute(name="BackgroundSave_Setting_MinNumOfMessagesForSave_Text")
	@Override
	public long getBackgroundSave_Setting_MinNumOfMessagesForSave_Text() {
		return m_statistics.getBackgroundSaveMinNumOfMsgForFasterSaveText();
	}

    @JMXBeanAttribute(name="BackgroundSave_Setting_MinNumOfMessagesForSave_Spreadsheet")
	@Override
	public long getBackgroundSave_Setting_MinNumOfMessagesForSave_Spreadsheet() {
		return m_statistics.getBackgroundSaveMinNumOfMsgForFasterSaveSpreadsheet();
	}

    @JMXBeanAttribute(name="BackgroundSave_Setting_MinNumOfMessagesForSave_Presentation")
	@Override
	public long getBackgroundSave_Setting_MinNumOfMessagesForSave_Presentation() {
		return m_statistics.getBackgroundSaveMinNumOfMsgForFasterSavePresentation();
	}

    @JMXBeanAttribute(name="RestoreDocsManagedFiles_RemovedLastCycle")
	@Override
	public long getRestoreDocsManagedFiles_RemovedLastCycle() {
		return m_statistics.getRestoreDocManagedFilesRemovedLastCycle();
	}

    @JMXBeanAttribute(name="RestoreDocsManagedFiles_InRemoveQueue")
	@Override
	public long getRestoreDocsManagedFiles_InRemoveQueue() {
		return m_statistics.getRestoreDocManagedFilesInRemoveQueue();
	}

    @JMXBeanAttribute(name="RestoreDocsManagedFiles_RuntimeLastCycle")
	@Override
	public long getRestoreDocsManagedFiles_RuntimeLastCycle() {
		return m_statistics.getRestoreDocManagedFilesRuntimeLastCycle();
	}

    @JMXBeanAttribute(name="RestoreDocsManagedFiles_Current")
	@Override
	public long getRestoreDocsManagedFiles_Current() {
		return m_statistics.getRestoreDocManagedFilesCurrent();
	}

	// - IMonitoringOT ---------------------------------------------------------

    @JMXBeanAttribute(name="DocumentsOperations_Total_ServerTransformed")
    @Override
    public long getDocumentsOperations_Total_ServerTransformed() {
        return m_statistics.getTransformationCount(null);
    }

    @JMXBeanAttribute(name="DocumentsOperations_Text_ServerTransformed")
    @Override
    public long getDocumentsOperations_Text_ServerTransformed() {
        return m_statistics.getTransformationCount(DocumentType.TEXT);
    }

    @JMXBeanAttribute(name="DocumentsOperations_Spreadsheet_ServerTransformed")
    @Override
    public long getDocumentsOperations_Spreadsheet_ServerTransformed() {
        return m_statistics.getTransformationCount(DocumentType.SPREADSHEET);
    }

    @JMXBeanAttribute(name="DocumentsOperations_Presentation_ServerTransformed")
    @Override
    public long getDocumentsOperations_Presentation_ServerTransformed() {
        return m_statistics.getTransformationCount(DocumentType.PRESENTATION);
    }

    @JMXBeanAttribute(name="DocumentsOperations_Total_UnresolvableTransformations")
	@Override
	public long getDocumentsOperations_Total_UnresolvableTransformations() {
		return m_statistics.getUnresolvableTransformations(null);
	}

    @JMXBeanAttribute(name="DocumentsOperations_Text_UnresolvableTransformations")
	@Override
	public long getDocumentsOperations_Text_UnresolvableTransformations() {
		return m_statistics.getUnresolvableTransformations(DocumentType.TEXT);
	}

    @JMXBeanAttribute(name="DocumentsOperations_Spreadsheet_UnresolvableTransformations")
	@Override
	public long getDocumentsOperations_Spreadsheet_UnresolvableTransformations() {
		return m_statistics.getUnresolvableTransformations(DocumentType.SPREADSHEET);
	}

    @JMXBeanAttribute(name="DocumentsOperations_Presentation_UnresolvableTransformations")
	@Override
	public long getDocumentsOperations_Presentation_UnresolvableTransformations() {
		return m_statistics.getUnresolvableTransformations(DocumentType.PRESENTATION);
	}

    @JMXBeanAttribute(name="DocumentsOperations_Total_UnresolvableTransformationReloads")
    @Override
    public long getDocumentsOperations_Total_UnresolvableTransformationReloads() {
        return m_statistics.getUnresolvableTransformationReloads(null);
    }

    @JMXBeanAttribute(name="DocumentsOperations_Text_UnresolvableTransformationReloads")
    @Override
    public long getDocumentsOperations_Text_UnresolvableTransformationReloads() {
        return m_statistics.getUnresolvableTransformationReloads(DocumentType.TEXT);
    }

    @JMXBeanAttribute(name="DocumentsOperations_Spreadsheet_UnresolvableTransformationReloads")
    @Override
    public long getDocumentsOperations_Spreadsheet_UnresolvableTransformationReloads() {
        return m_statistics.getUnresolvableTransformationReloads(DocumentType.SPREADSHEET);
    }

    @JMXBeanAttribute(name="DocumentsOperations_Presentation_UnresolvableTransformationReloads")
    @Override
    public long getDocumentsOperations_Presentation_UnresolvableTransformationReloads() {
        return m_statistics.getUnresolvableTransformationReloads(DocumentType.PRESENTATION);
    }

}

