/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */



/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.styles;

import org.apache.xml.serializer.SerializationHandler;
import org.json.JSONObject;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.OpAttrs;
import com.openexchange.office.filter.odf.SaxContextHandler;
import com.openexchange.office.filter.odf.properties.RubyProperties;

final public class StyleRuby extends StyleBase {

	private RubyProperties rubyProperties = new RubyProperties(new AttributesImpl());

	public StyleRuby(String name, boolean automaticStyle, boolean contentStyle) {
		super(StyleFamily.RUBY, name, automaticStyle, contentStyle);
	}

	public StyleRuby(String name, AttributesImpl attributesImpl, boolean defaultStyle, boolean automaticStyle, boolean contentStyle) {
		super(name, attributesImpl, defaultStyle, automaticStyle, contentStyle);
	}

	@Override
    public StyleFamily getFamily() {
		return StyleFamily.RUBY;
	}

	public RubyProperties getRubyProperties() {
		return rubyProperties;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		SaxContextHandler.startElement(output, getNamespace(), getLocalName(), getQName());
		writeAttributes(output);
		rubyProperties.writeObject(output);
		writeMapStyleList(output);
		SaxContextHandler.endElement(output, getNamespace(), getLocalName(), getQName());
	}

	@Override
	public void mergeAttrs(StyleBase styleBase) {
		if(styleBase instanceof StyleRuby) {
			getRubyProperties().mergeAttrs(((StyleRuby)styleBase).getRubyProperties());
		}
	}

	@Override
	public void applyAttrs(StyleManager styleManager, JSONObject attrs) {
		rubyProperties.applyAttrs(styleManager, attrs);
	}

	@Override
	public void createAttrs(StyleManager styleManager, OpAttrs attrs) {
		rubyProperties.createAttrs(styleManager, isContentStyle(), attrs);
	}

	@Override
	protected int _hashCode() {
		return rubyProperties!=null ? rubyProperties.hashCode() : 0;
	}

	@Override
	protected boolean _equals(StyleBase e) {
		final StyleRuby other = (StyleRuby)e;
		if(!rubyProperties.equals(other.rubyProperties)) {
			return false;
		}
		return true;
	}

	@Override
	public StyleRuby clone() {
		final StyleRuby clone = (StyleRuby)_clone();
		clone.rubyProperties = rubyProperties.clone();
		return clone;
	}
}
