/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */



package com.openexchange.office.filter.odf.ods.dom;

import java.util.ArrayList;
import java.util.List;

/**
 * Small helper for importing grouping information of columns and rows.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */
public class GroupStack {

    private int level = 0;
    private List<Boolean> collapse = new ArrayList<>();

    /**
     * Opens a new grouping level. Pushes the collapsed state onto the internal stack of all
     * new open groups.
     */
    public void pushLevel(boolean collapsed) {
        ++level;
        collapse.add(collapsed);
    }

    /**
     * Closes the top-most grouping level.
     */
    public void popLevel() {
        --level;
    }

    /**
     * Returns the current grouping level (the number of open groups).
     */
    public int getLevel() {
        return level;
    }

    /**
     * Returns the collapsed states of all new groups.
     */
    public List<Boolean> pullCollapse() {
        List<Boolean> retValue = collapse.isEmpty() ? null : new ArrayList<>(collapse);
        collapse.clear();
        return retValue;
    }
}
