/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */



package com.openexchange.office.filter.odf;

import java.util.ArrayList;
import java.util.List;

import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.xml.sax.SAXException;

public class OfficeSettings extends ElementNSImpl implements IElementWriter {

	private static final long serialVersionUID = 1L;

	final List<ConfigItemSet> items = new ArrayList<ConfigItemSet>();

	public OfficeSettings(OdfFileDom ownerDocument) {
		super(ownerDocument, Namespaces.OFFICE, "office:settings");
	}

	public List<ConfigItemSet> getItems() {
		return items;
	}

	public ConfigItemSet getConfigItem(String name, boolean forceCreate) {
		if(name==null) {
			return null;
		}
		for(ConfigItemSet configItemSet:items) {
			if(name.equals(configItemSet.getName())) {
				return configItemSet;
			}
		}
		if(!forceCreate) {
			return null;
		}
		final ConfigItemSet configItemSet = new ConfigItemSet(name);
		items.add(configItemSet);
		return configItemSet;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		SaxContextHandler.startElement(output, Namespaces.OFFICE, "settings", "office:settings");
		for(ConfigItemSet configItemSet:items) {
			configItemSet.writeObject(output);
		}
		SaxContextHandler.endElement(output, Namespaces.OFFICE, "settings", "office:settings");
	}
}
