/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.function.client;

import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.codec.CodecsAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ClientHttpConnectorAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientCodecCustomizer;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.boot.web.reactive.function.client.WebClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebClient.class})
@AutoConfigureAfter(value={CodecsAutoConfiguration.class, ClientHttpConnectorAutoConfiguration.class})
public class WebClientAutoConfiguration {
    private final WebClient.Builder webClientBuilder = WebClient.builder();

    public WebClientAutoConfiguration(ObjectProvider<WebClientCustomizer> customizerProvider) {
        customizerProvider.orderedStream().forEach(customizer2 -> customizer2.customize(this.webClientBuilder));
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    public WebClient.Builder webClientBuilder() {
        return this.webClientBuilder.clone();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={CodecCustomizer.class})
    protected static class WebClientCodecsConfiguration {
        protected WebClientCodecsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Order(value=0)
        public WebClientCodecCustomizer exchangeStrategiesCustomizer(List<CodecCustomizer> codecCustomizers) {
            return new WebClientCodecCustomizer(codecCustomizers);
        }
    }
}

