/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import java.time.Duration;
import javax.jms.ConnectionFactory;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.Assert;

public final class DefaultJmsListenerContainerFactoryConfigurer {
    private DestinationResolver destinationResolver;
    private MessageConverter messageConverter;
    private JtaTransactionManager transactionManager;
    private JmsProperties jmsProperties;

    void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    void setTransactionManager(JtaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    void setJmsProperties(JmsProperties jmsProperties) {
        this.jmsProperties = jmsProperties;
    }

    public void configure(DefaultJmsListenerContainerFactory factory, ConnectionFactory connectionFactory) {
        Duration receiveTimeout;
        String concurrency;
        Assert.notNull((Object)factory, "Factory must not be null");
        Assert.notNull((Object)connectionFactory, "ConnectionFactory must not be null");
        factory.setConnectionFactory(connectionFactory);
        factory.setPubSubDomain(this.jmsProperties.isPubSubDomain());
        if (this.transactionManager != null) {
            factory.setTransactionManager(this.transactionManager);
        } else {
            factory.setSessionTransacted(true);
        }
        if (this.destinationResolver != null) {
            factory.setDestinationResolver(this.destinationResolver);
        }
        if (this.messageConverter != null) {
            factory.setMessageConverter(this.messageConverter);
        }
        JmsProperties.Listener listener = this.jmsProperties.getListener();
        factory.setAutoStartup(listener.isAutoStartup());
        if (listener.getAcknowledgeMode() != null) {
            factory.setSessionAcknowledgeMode(listener.getAcknowledgeMode().getMode());
        }
        if ((concurrency = listener.formatConcurrency()) != null) {
            factory.setConcurrency(concurrency);
        }
        if ((receiveTimeout = listener.getReceiveTimeout()) != null) {
            factory.setReceiveTimeout(receiveTimeout.toMillis());
        }
    }
}

