/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.diff;

import org.apache.commons.text.diff.DeleteCommand;
import org.apache.commons.text.diff.EditScript;
import org.apache.commons.text.diff.InsertCommand;
import org.apache.commons.text.diff.KeepCommand;

public class StringsComparator {
    private final String left;
    private final String right;
    private final int[] vDown;
    private final int[] vUp;

    public StringsComparator(String left, String right) {
        this.left = left;
        this.right = right;
        int size = left.length() + right.length() + 2;
        this.vDown = new int[size];
        this.vUp = new int[size];
    }

    private void buildScript(int start1, int end1, int start2, int end2, EditScript<Character> script) {
        Snake middle = this.getMiddleSnake(start1, end1, start2, end2);
        if (middle == null || middle.getStart() == end1 && middle.getDiag() == end1 - end2 || middle.getEnd() == start1 && middle.getDiag() == start1 - start2) {
            int i2 = start1;
            int j = start2;
            while (i2 < end1 || j < end2) {
                if (i2 < end1 && j < end2 && this.left.charAt(i2) == this.right.charAt(j)) {
                    script.append(new KeepCommand<Character>(Character.valueOf(this.left.charAt(i2))));
                    ++i2;
                    ++j;
                    continue;
                }
                if (end1 - start1 > end2 - start2) {
                    script.append(new DeleteCommand<Character>(Character.valueOf(this.left.charAt(i2))));
                    ++i2;
                    continue;
                }
                script.append(new InsertCommand<Character>(Character.valueOf(this.right.charAt(j))));
                ++j;
            }
        } else {
            this.buildScript(start1, middle.getStart(), start2, middle.getStart() - middle.getDiag(), script);
            for (int i3 = middle.getStart(); i3 < middle.getEnd(); ++i3) {
                script.append(new KeepCommand<Character>(Character.valueOf(this.left.charAt(i3))));
            }
            this.buildScript(middle.getEnd(), end1, middle.getEnd() - middle.getDiag(), end2, script);
        }
    }

    private Snake buildSnake(int start, int diag, int end1, int end2) {
        int end;
        for (end = start; end - diag < end2 && end < end1 && this.left.charAt(end) == this.right.charAt(end - diag); ++end) {
        }
        return new Snake(start, end, diag);
    }

    private Snake getMiddleSnake(int start1, int end1, int start2, int end2) {
        int m3 = end1 - start1;
        int n = end2 - start2;
        if (m3 == 0 || n == 0) {
            return null;
        }
        int delta = m3 - n;
        int sum = n + m3;
        int offset = (sum % 2 == 0 ? sum : sum + 1) / 2;
        this.vDown[1 + offset] = start1;
        this.vUp[1 + offset] = end1 + 1;
        for (int d = 0; d <= offset; ++d) {
            int y;
            int x;
            int i2;
            int k;
            for (k = -d; k <= d; k += 2) {
                i2 = k + offset;
                this.vDown[i2] = k == -d || k != d && this.vDown[i2 - 1] < this.vDown[i2 + 1] ? this.vDown[i2 + 1] : this.vDown[i2 - 1] + 1;
                x = this.vDown[i2];
                for (y = x - start1 + start2 - k; x < end1 && y < end2 && this.left.charAt(x) == this.right.charAt(y); ++y) {
                    this.vDown[i2] = ++x;
                }
                if (delta % 2 == 0 || delta - d > k || k > delta + d || this.vUp[i2 - delta] > this.vDown[i2]) continue;
                return this.buildSnake(this.vUp[i2 - delta], k + start1 - start2, end1, end2);
            }
            for (k = delta - d; k <= delta + d; k += 2) {
                i2 = k + offset - delta;
                this.vUp[i2] = k == delta - d || k != delta + d && this.vUp[i2 + 1] <= this.vUp[i2 - 1] ? this.vUp[i2 + 1] - 1 : this.vUp[i2 - 1];
                x = this.vUp[i2] - 1;
                for (y = x - start1 + start2 - k; x >= start1 && y >= start2 && this.left.charAt(x) == this.right.charAt(y); --y) {
                    this.vUp[i2] = x--;
                }
                if (delta % 2 != 0 || -d > k || k > d || this.vUp[i2] > this.vDown[i2 + delta]) continue;
                return this.buildSnake(this.vUp[i2], k + start1 - start2, end1, end2);
            }
        }
        throw new IllegalStateException("Internal Error");
    }

    public EditScript<Character> getScript() {
        EditScript<Character> script = new EditScript<Character>();
        this.buildScript(0, this.left.length(), 0, this.right.length(), script);
        return script;
    }

    private static class Snake {
        private final int start;
        private final int end;
        private final int diag;

        Snake(int start, int end, int diag) {
            this.start = start;
            this.end = end;
            this.diag = diag;
        }

        public int getDiag() {
            return this.diag;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }
    }
}

