/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.office.tools.service.logging;

import java.util.Map;

import org.slf4j.Marker;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;

public class LoggingEventProxy implements ILoggingEvent {
	
	private final ILoggingEvent orig;
	private final StackTraceElement stackTraceElement;

	public LoggingEventProxy(ILoggingEvent orig, StackTraceElement stackTraceElement) {
		this.orig = orig;
		this.stackTraceElement = stackTraceElement;
	}

	public String getThreadName() {
		return orig.getThreadName();
	}

	public Level getLevel() {
		return orig.getLevel();
	}

	public String getMessage() {
		return orig.getMessage();
	}

	public Object[] getArgumentArray() {
		return orig.getArgumentArray();
	}

	public String getFormattedMessage() {
		return orig.getFormattedMessage();
	}

	public String getLoggerName() {
		return stackTraceElement.getClassName();
	}

	public LoggerContextVO getLoggerContextVO() {
		return orig.getLoggerContextVO();
	}

	public IThrowableProxy getThrowableProxy() {
		return orig.getThrowableProxy();
	}

	public StackTraceElement[] getCallerData() {
		StackTraceElement [] callerData = new StackTraceElement[1];
		callerData[0] = stackTraceElement;		
		return callerData;
	}

	public boolean hasCallerData() {
		return orig.hasCallerData();
	}

	public Marker getMarker() {
		return orig.getMarker();
	}

	public Map<String, String> getMDCPropertyMap() {
		return orig.getMDCPropertyMap();
	}

	public Map<String, String> getMdc() {
		return orig.getMdc();
	}

	public long getTimeStamp() {
		return orig.getTimeStamp();
	}

	public void prepareForDeferredProcessing() {
		orig.prepareForDeferredProcessing();
	}
}
