/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.office.rt2.core.exception;

import java.text.MessageFormat;

public class ValueNotFoundException extends RuntimeException {

	public static final MessageFormat ERROR_MSG_FMT = new MessageFormat("Value with name {0} not found in configuration!");
	
	private static final long serialVersionUID = -8539676770295578107L;

	public ValueNotFoundException(String valueName) {
		super(ERROR_MSG_FMT.format(new Object [] {valueName}));
	}
}
