/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */



package com.openexchange.office.rest;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.openexchange.office.document.api.TemplateFilesScannerFactory;
import com.openexchange.office.tools.service.http.BaseAjaxActionServiceFactory;

/**
 * {@link DocumentRESTActionFactory}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
@Service
public class DocumentRESTActionFactory extends BaseAjaxActionServiceFactory<DocumentRESTAction<?, ?>> implements InitializingBean {

	private static final String AJAX_MODULE_ID = "oxodocumentfilter";
	
    @Autowired
    private TemplateFilesScannerFactory templateFilesScannerFactory;
    
    @Override
	public void afterPropertiesSet() throws Exception {
    	templateFilesScannerFactory.create(TemplateFilesScannerFactory.TemplateFilterType.ALL_DOCUMENTS);    	
	}

	@Override
	protected String getAjaxModuleId() {
		return AJAX_MODULE_ID;
	}
}
