/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */



package com.openexchange.office.filter.odf.draw;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.openexchange.office.filter.core.STShapeType;

public enum EnhancedGeometryType {

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="mso-spt50" draw:modifiers="-8300 24500 -1800 4000" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M ?f0 ?f1 L ?f2 ?f3 N M ?f2 0 L ?f2 21600 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/></draw:enhanced-geometry>
    oo_mso_spt50("mso-spt50", "H4sIAAAAAAAA/43S3W7CIBQH8Fc5Ib1t5KOtxogmu54+wO7ICkoipZaq8+0Hbe22sIxdcGjJ+fEngU3diftaNifRvMs6P0prZN89wN2O65uW9xf7wREGDJRUeKoIBtQ/WsmRcTZ3bV8+V42ttdKycxzlKxZIUfqak5WvBZ71HNmK/sTRHkLI6xTzI27+e4MD7GGnsB/E9+4U9YNNq3TwYR67D2i7GZMuV9Fr24y5jTD+1Op5DGU7cz0LjjIMaPGXIJEgCUEjQROCRYIlRBGJIiHKSJQJUUWiSohlJJZfwt97fZbw7TtvrdNhk+EaMvLPVgoZC62L39/w9hN163JN3AIAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="mso-spt51" draw:modifiers="-10000 24500 -3600 4000 -1800 4000" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M ?f0 ?f1 L ?f2 ?f3 N M ?f2 ?f3 L ?f4 ?f5 N M ?f4 0 L ?f4 21600 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/><draw:handle draw:handle-position="$4 $5"/></draw:enhanced-geometry>
    oo_mso_spt51("mso-spt51", "H4sIAAAAAAAA/42T327CIBTGX+WE9JbI37oY0WTX0wfYHVmpNpHStVXn2w9a5rawDC8OHL6c3/kgwLrq9XVl2qNu30yFD8ZZM/Y3GC6H1aUx12f3oRABAoyWJI4IJmi8dUYhOzg8dKOkUbWuaurG9INCmBISGCH9iHngRRAwfYppZO72nR6PCu0gGL5Ey1/W99Ur7GEH25r4oL52WzMfPKpzHlThQ0ZVTF3DPPfYo8169n8/67Fx7bybVlt/rvprc7Xr7fmkFSoIoMV/BE0ImiFYQrAMwROCZwiRECJDyISQGaJMiDJDLBNi+U3411CdDPzIceeGJjSZrqGgD5YyKPiDpQIKGUoXf3+IzScHmGZfKQMAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="mso-spt52" draw:modifiers="-1800 24500 -3600 21600 -3600 4000 -1800 4000" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M ?f6 ?f7 F L ?f4 ?f5 ?f2 ?f3 ?f0 ?f1 N M ?f6 0 L ?f6 21600 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/><draw:handle draw:handle-position="$4 $5"/><draw:handle draw:handle-position="$6 $7"/></draw:enhanced-geometry>
    oo_mso_spt52("mso_spt52", "H4sIAAAAAAAA/43T0W6DIBQG4Fc5Id6aAgIuTW2TXexq7QP0jkxsSapYte369gXL3BaW4cUhR/N/cIy6Kjt5W6rmKJsPVaYHZWo1dHfor4flVavbq/ksEAYMlAjsVwQjGu6tKlDdm7RvB0793dqUutKq6wuUkhdHGLdrmk3c9wy7doy41vNpklYOxwJtwZ397uGvKaarPexgC5tK2MrhzaY3FbPFbVFbmS1si0w5PGaE9zu0Xj3PPl/koE3znKSRtX286muwynT15SQLlGBAi/8ECQSJCBoIGhFZILKIYIFgEcEDwSNCBEJERB6I/FvYL6E8KfjRp63ptdtkfA0JmRmlkGQzowwSPjMqIMlddPH3L7R+AE6Xh8hbAwAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="mso-spt44" draw:modifiers="-8300 24500 -1800 4000" draw:enhanced-path="M 0 0 S L 21600 0 21600 21600 0 21600 Z N M ?f0 ?f1 L ?f2 ?f3 N M ?f2 0 L ?f2 21600 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/></draw:enhanced-geometry>
    oo_mso_spt44("mso-spt44", "H4sIAAAAAAAA/43Sy27DIBAF0F8ZIW9ReNmJojiRum6y6a47VENiKRjHkNffB8eu24qqdMEIj+b4IsGq6uR1qZqDbD5UhffKGuW7O7jLfnmp1fXF3kpEgACjBRkrgify91aVyDiLXeuFGLvGVrWuVedKhBe8JyIPFdNFqIJMeopspT+UaAt9yBu8jkE/Aqevd9jBFjaahEXD7EazsPjYZWFu6A3TO7ReDVmns/S1bYbkRppwbv15EG07cz7KEmUE0OwvQSNBE4JFgiUEjwRPCBEJkRB5JPKEKCJRJMQ8EvMvEW6+Oir4tsetdXX/k+c1ZPSfowwy3o/Ofn/F6wd1OdLq3gIAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="mso-spt45" draw:modifiers="-10000 24500 -3600 4000 -1800 4000" draw:enhanced-path="M 0 0 S L 21600 0 21600 21600 0 21600 Z N M ?f0 ?f1 L ?f2 ?f3 N M ?f2 ?f3 L ?f4 ?f5 N M ?f4 0 L ?f4 21600 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/><draw:handle draw:handle-position="$4 $5"/></draw:enhanced-geometry>
    oo_mso_spt45("mso-spt45", "H4sIAAAAAAAA/43TQW/CIBQA4L/yQnolQgt1MVaTnaeX3XYjKyiJlFqqzn8/sMxtYRkeHoGX9/Fe03bZDuKykN1edO+yxTtpjRyHK7jzbnHW8vJsPxpEgEBJaxJXBDc0XnvZIOMsdv3IeMwa22ql5eAahCkhwTDuV1wFz0IC06e4jebevhfjvkEbCA1f4SU2/dX8fnqDLWxgrYgP6mvXqvRRxey0D1nmg8cs83rKTXds0Wo5TXA8iVHbbpqnE8Y/mfoaT9nBnA6iQQUBNPtP0ETQjCgTUWZElYgqI1giWEbwRPCMqBNRZ8Q8EfNv4b+H9iDhxx731ulwye01FPTB0hKK6sFSBgUPpbO/f4nVJ0QUajgrAwAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="mso-spt46" draw:modifiers="-1800 24500 -3600 21600 -3600 4000 -1800 4000" draw:enhanced-path="M 0 0 S L 21600 0 21600 21600 0 21600 Z N M ?f6 ?f7 F L ?f4 ?f5 ?f2 ?f3 ?f0 ?f1 N M ?f6 0 L ?f6 21600 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/><draw:handle draw:handle-position="$4 $5"/><draw:handle draw:handle-position="$6 $7"/></draw:enhanced-geometry>
    oo_mso_spt46("mso-spt46", "H4sIAAAAAAAA/43Tz2+DIBQH8H/lhXg1BUFcmtImO+y09rLbbmRia1LFif313xcsc1tYhodHnub7gWfUVdnLy1K1B9l+qDLdK92oob+BOe+X51pdnvVVIAwYMsKxXxGMaLh1SqDG6NR0A+P+bqPLuqpVbwRKyZMjLLdrSifue4ZdO0Zc6/k0SSeHg0BbcGe/waunv+aYrt5hB1vYVNxWAS82vamYrdxWZovawrbIlMNjhnu/Q+vV4/TPkxxq3T5maWVjH7D6Gq3SfXM6SoESDGjxnyCBIBGRBSKLCBoIGhEsECwi8kDkEcEDwSOiCETxLey3UB4V/OjTTpvabTK+hoTMjGaQ0JlRBkk+M8ohKVx08fdPtL4DS+8/2l0DAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt194" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f3 ?f2 ?f1 ?f2 Z N M 21600 0 L 21600 21600 ?f3 ?f4 ?f3 ?f2 Z N M 21600 21600 L 0 21600 ?f1 ?f4 ?f3 ?f4 Z N M 0 21600 L 0 0 ?f1 ?f2 ?f1 ?f4 Z N M ?f10 ?f8 L ?f14 ?f12 ?f14 ?f16 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="left+$0 "/><draw:equation draw:name="f2" draw:formula="top+$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="bottom-$0 "/><draw:equation draw:name="f5" draw:formula="10800-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 /10800"/><draw:equation draw:name="f7" draw:formula="right/2"/><draw:equation draw:name="f8" draw:formula="bottom/2"/><draw:equation draw:name="f9" draw:formula="-8050*?f6 "/><draw:equation draw:name="f10" draw:formula="?f9 +?f7 "/><draw:equation draw:name="f11" draw:formula="-8050*?f6 "/><draw:equation draw:name="f12" draw:formula="?f11 +?f8 "/><draw:equation draw:name="f13" draw:formula="8050*?f6 "/><draw:equation draw:name="f14" draw:formula="?f13 +?f7 "/><draw:equation draw:name="f15" draw:formula="8050*?f6 "/><draw:equation draw:name="f16" draw:formula="?f15 +?f8 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt194("mso-spt194", "H4sIAAAAAAAA/42V0ZKCIBSGX4Vh9mobJjEtazJn9rrdB9g7NqGYCXERy95+McoS2+hCBz3/xzkHf3CZK3Jc0GJHig3N0ZZKQbU6geqwXRw4PX7IJoUBCECIp8HlDsEZKoneoUorqje7UvJCIyPFQfJEcOoLNG00IoqSKoUZwyBjobkm5oquilNJUygqiapS4/n1tZA5Z5wqw+Gom67rok2cwk/Q1r2+VN7roHv6Bl/A1dkK2kpsRVZzja5781yq7Zh7rb2vwU2L77RRl/umC8BtFfCdxjy1ocSIzLCdAYfdaNqK4Gppl+C3JprLwi5IQYRZPXZdHyaVqPckhW8BgONnBHaJPWV65MVCF9Oy9FMTl1J8u9PIy0Uu9yO1lsIPxi549qSfm7pcxmIwtoZ+Cs4edjgOn1PJ4/582NzFUBLEwXvGpr6PPvBJxuZglLGZDxzY5eWUA8cYQ+M2Z+IjB655NeXANibl5KU2B755NeUD4+DY6dIcXfmegrsxKmXF28nOG9ZsJdiLVkduzlWam12matqPKVJsKWqQ4AUXtTAn+D9x0th4HFkPjx//DlZ//2ZkfycGAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt196" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f3 ?f2 ?f1 ?f2 Z N M 21600 0 L 21600 21600 ?f3 ?f4 ?f3 ?f2 Z N M 21600 21600 L 0 21600 ?f1 ?f4 ?f3 ?f4 Z N M 0 21600 L 0 0 ?f1 ?f2 ?f1 ?f4 Z N M ?f10 ?f8 L ?f14 ?f12 ?f14 ?f16 Z N M ?f18 ?f12 L ?f20 ?f12 ?f20 ?f16 ?f18 ?f16 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="left+$0 "/><draw:equation draw:name="f2" draw:formula="top+$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="bottom-$0 "/><draw:equation draw:name="f5" draw:formula="10800-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 /10800"/><draw:equation draw:name="f7" draw:formula="right/2"/><draw:equation draw:name="f8" draw:formula="bottom/2"/><draw:equation draw:name="f9" draw:formula="-4020*?f6 "/><draw:equation draw:name="f10" draw:formula="?f9 +?f7 "/><draw:equation draw:name="f11" draw:formula="-8050*?f6 "/><draw:equation draw:name="f12" draw:formula="?f11 +?f8 "/><draw:equation draw:name="f13" draw:formula="8050*?f6 "/><draw:equation draw:name="f14" draw:formula="?f13 +?f7 "/><draw:equation draw:name="f15" draw:formula="8050*?f6 "/><draw:equation draw:name="f16" draw:formula="?f15 +?f8 "/><draw:equation draw:name="f17" draw:formula="-8050*?f6 "/><draw:equation draw:name="f18" draw:formula="?f17 +?f7 "/><draw:equation draw:name="f19" draw:formula="-6140*?f6 "/><draw:equation draw:name="f20" draw:formula="?f19 +?f7 "/><draw:equation draw:name="f21" draw:formula="4020*?f6 "/><draw:equation draw:name="f22" draw:formula="?f21 +?f7 "/><draw:equation draw:name="f23" draw:formula="6140*?f6 "/><draw:equation draw:name="f24" draw:formula="?f23 +?f7 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt196("mso-spt196", "H4sIAAAAAAAA/42W3Y7iIBiGb4WQPdoJEbCtdTKdJnPs7gXsGTsFJbGlQ3HUu18qWm3pCgdtqN/78P34Sn2rNDu+8mbHmk9eoS1XNTf6DLrv7eu35McPdSogBhhQkuHrHYIL1DKzQ53R3HzuWiUbg6yU4PyJ4DwWGH4yiGnOugKWgoBSUHst7ZXcFOeWF7DuFOpaQ9bZ9eNaVVJIri1HkmG7oYs+cQF/gb7uzbXyUQfD0x/wG0x1roK+EleR09yim9E+12oH5lHr7htw15IHbTLkvuswuE+BPGjsUx/Krcgu+x0IHVbZXZS7SK+i+KZyq2yIX/Tw/c2N7OvAjFSNG2DDajttcZunULo+7FkBf2AAF88IMiX2XJiXIEanmFFtmFpOKS23O4OCXDLl/ipjVB0G0yl48XCYy6ZcKVKwcD+Ap+BqtsMFfU7l8/2FsPUUQwmm+GcpstCX7vmkFGvwUopVCPTsgnKcRqX0HGMNTfqceYj0XBOb0rONTbmMatPzTWzKGeOQNKpLzznRk/XcY3Ouotr0DZTZQzkiJ50xEIlyEPUcFOlZOmMgSqJSegaK7XLGQHRqIPviqvYcPKxRqzrZb3Y5fu3BCEfR7ijtW5VX9szUBz6OadZsOTqhWjayPtT2/f2fODu5eJq4E2kx/2fg/R8J+fGDJQgAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f0 ?f0 ?f1 ?f2" draw:type="mso-spt189" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f1 ?f0 ?f0 ?f0 Z N M 21600 0 L 21600 21600 ?f1 ?f2 ?f1 ?f0 Z N M 21600 21600 L 0 21600 ?f0 ?f2 ?f1 ?f2 Z N M 0 21600 L 0 0 ?f0 ?f0 ?f0 ?f2 Z N"><draw:equation draw:name="f0" draw:formula="$0 *21599/21600"/><draw:equation draw:name="f1" draw:formula="right-?f0 "/><draw:equation draw:name="f2" draw:formula="bottom-?f0 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt189("mso-spt189", "H4sIAAAAAAAA/32SwW7CMAyGXyWKdpoUkVQwAaJM2pntAXbLqNtGIklJXChvv5SU0qCNg6O2/n7bf+NN4eR5DaaWZg8Fq8BqQHch/lStTwrOH7bLKSecZOKNDyclV1EjsWYeHeC+bqwyyAIq+PIJcEkBhA6ZdCB9Tt9LTmKIENmNuDSQU+0t8w2K5Wr4rG2hSgUu6MR8LDe66Bvn9JP0c++GyRMH49s3+SKPXJyAjxGZW3aX1BmmHTVTNp47cmf5hM3G3neOJ30Hhm430d2xlaisiV6N1OHHlDfrpXW6PcicvnDymonFajWLVzV7phaPaqeqGlnf/LkwexT+WESrU2W4jOIAZPLMGutVX+w6J9qGJll/VmFToMgpuhbSnJOmAtYxrYzSrQ47+U9edjG/mEf3s78XfPsLw4xhm/kCAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt198" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f3 ?f2 ?f1 ?f2 Z N M 21600 0 L 21600 21600 ?f3 ?f4 ?f3 ?f2 Z N M 21600 21600 L 0 21600 ?f1 ?f4 ?f3 ?f4 Z N M 0 21600 L 0 0 ?f1 ?f2 ?f1 ?f4 Z N M ?f10 ?f12 L ?f14 ?f12 ?f16 ?f18 ?f16 ?f20 ?f10 ?f20 Z N M ?f14 ?f12 L ?f16 ?f18 ?f14 ?f18 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="left+$0 "/><draw:equation draw:name="f2" draw:formula="top+$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="bottom-$0 "/><draw:equation draw:name="f5" draw:formula="10800-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 /10800"/><draw:equation draw:name="f7" draw:formula="right/2"/><draw:equation draw:name="f8" draw:formula="bottom/2"/><draw:equation draw:name="f9" draw:formula="-6350*?f6 "/><draw:equation draw:name="f10" draw:formula="?f9 +?f7 "/><draw:equation draw:name="f11" draw:formula="-7830*?f6 "/><draw:equation draw:name="f12" draw:formula="?f11 +?f8 "/><draw:equation draw:name="f13" draw:formula="1690*?f6 "/><draw:equation draw:name="f14" draw:formula="?f13 +?f7 "/><draw:equation draw:name="f15" draw:formula="6350*?f6 "/><draw:equation draw:name="f16" draw:formula="?f15 +?f7 "/><draw:equation draw:name="f17" draw:formula="-3810*?f6 "/><draw:equation draw:name="f18" draw:formula="?f17 +?f8 "/><draw:equation draw:name="f19" draw:formula="7830*?f6 "/><draw:equation draw:name="f20" draw:formula="?f19 +?f8 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt198("mso-spt198", "H4sIAAAAAAAA/42V23KrIBSGX4VxerU7TMRTtFPrTK/T/QD7jlZImAlikTTJ2xdDPKE7eCHBrP9zLZa/8FpKfH4h1QFXX6SEeyI4UfIKmp/9yw8j53dxyT0f+CBAiX8fPXCDaqwOsFGSqK9DLViloJYiP30guE4FilwUxJLgJvcKikBBA32F+oo6xbUmuccbAZtaoSy9/81FySgjUnMo6h/Xr6JNnHsfoK17d698soL+7h/4C2ydqaCtxFRkNF10N3nOvdqeGWvNuAODFo20UZ970Plg6AIaafTdLRRolf6JzFwPSTuk3SzwO2XgD2Q0Igd9ZGZa5b29mu59n7BiojK9rDDXjadda6mQ/HTEuffkA2/ziEA2cSRUPTuxwMaUqN1UaFOS7Q8KOrnI5j6FUoK7wdgGb3Z2c4nNFTQGG/MtPAS3iyvcBI+pdHl9LiyzMZiEsf+noInrpc98UtAMPBd06wJndoHbNFyVcuYYbWjU5kxd5Mw1KMlWpZzZRqcMVy1z5pu1jV0wDopXpZw5B4YpWpVz5h6dc7uqszMDrXyZwYJ/UGal1Jt7eSRgNIe1aFj7sNu+pHcMbxJtzkyfPKTUm4k8kWlM4mpP4AVyVjF+4vqM+08cX0w8jsynulk+MN9+ASVdkKxJBwAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt195" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f3 ?f2 ?f1 ?f2 Z N M 21600 0 L 21600 21600 ?f3 ?f4 ?f3 ?f2 Z N M 21600 21600 L 0 21600 ?f1 ?f4 ?f3 ?f4 Z N M 0 21600 L 0 0 ?f1 ?f2 ?f1 ?f4 Z N M ?f22 ?f8 L ?f18 ?f16 ?f18 ?f12 Z N M ?f24 ?f12 L ?f24 ?f16 ?f14 ?f16 ?f14 ?f12 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="left+$0 "/><draw:equation draw:name="f2" draw:formula="top+$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="bottom-$0 "/><draw:equation draw:name="f5" draw:formula="10800-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 /10800"/><draw:equation draw:name="f7" draw:formula="right/2"/><draw:equation draw:name="f8" draw:formula="bottom/2"/><draw:equation draw:name="f9" draw:formula="-4020*?f6 "/><draw:equation draw:name="f10" draw:formula="?f9 +?f7 "/><draw:equation draw:name="f11" draw:formula="-8050*?f6 "/><draw:equation draw:name="f12" draw:formula="?f11 +?f8 "/><draw:equation draw:name="f13" draw:formula="8050*?f6 "/><draw:equation draw:name="f14" draw:formula="?f13 +?f7 "/><draw:equation draw:name="f15" draw:formula="8050*?f6 "/><draw:equation draw:name="f16" draw:formula="?f15 +?f8 "/><draw:equation draw:name="f17" draw:formula="-8050*?f6 "/><draw:equation draw:name="f18" draw:formula="?f17 +?f7 "/><draw:equation draw:name="f19" draw:formula="-6140*?f6 "/><draw:equation draw:name="f20" draw:formula="?f19 +?f7 "/><draw:equation draw:name="f21" draw:formula="4020*?f6 "/><draw:equation draw:name="f22" draw:formula="?f21 +?f7 "/><draw:equation draw:name="f23" draw:formula="6140*?f6 "/><draw:equation draw:name="f24" draw:formula="?f23 +?f7 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt195("mso-spt195", "H4sIAAAAAAAA/41W0XKjIBT9Fcbp03aYAFFjOrXO9DndD9g3WiFhJopF0iR/X5TERHAjDzLIPYdz780R8loqenxh9Y7WX6yEWyYrptUZtD/blx/Bju/ylEcIIEBwii5jBHpSQ/UOtlox/bVrpKg1NFCMsgeA8xig2UlDqhht86jgGBScmGdpnviKODcsj6pWwrbReJ1clitZCi6YMjwcD9sNVXTCefQBurw3l8xHFQxv/8Bf4OJsBl0mNiOLuUY3o30u2Q6ce6wdN+CGxXfYeNC+4RC4dQHfYcxKt5QZkAlk3ZAOM3IDxfZ9M8x7lDPr8dHbq23Z94FqIWvbwJpWptv82k8uVXXY0zx6QiBaPGJgl7FnXD/P0ohL07KZZy1dlhLbnYazvNjlfUqtZTVPTFxi7+F5XuryCp6Ahf0AHhJXkxUuyGNWNl3fHG3t0mCMCPpT8HTuR/d8UvA1eC74ao7o2QVmKAmS9BxjDI07zWyO6bkmVNKzjZFcBpXp+SZUcsI4OAmq0nNOcGc99xjNVVCZvoFScygHaJIJA+EgBxHPQYGeJRMGIjhI0jNQaJUTBiKugczFVe4ZuJvDRrai26w/fs3BGI2i7VGYW5WV5sxUBzaOKVpvGTzBStSiOlTm/v5PnJ5sPIntibSY/jPw9gtOkR1jJQgAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt193" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f3 ?f2 ?f1 ?f2 Z N M 21600 0 L 21600 21600 ?f3 ?f4 ?f3 ?f2 Z N M 21600 21600 L 0 21600 ?f1 ?f4 ?f3 ?f4 Z N M 0 21600 L 0 0 ?f1 ?f2 ?f1 ?f4 Z N M ?f10 ?f12 L ?f14 ?f8 ?f10 ?f16 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="left+$0 "/><draw:equation draw:name="f2" draw:formula="top+$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="bottom-$0 "/><draw:equation draw:name="f5" draw:formula="10800-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 /10800"/><draw:equation draw:name="f7" draw:formula="right/2"/><draw:equation draw:name="f8" draw:formula="bottom/2"/><draw:equation draw:name="f9" draw:formula="-8050*?f6 "/><draw:equation draw:name="f10" draw:formula="?f9 +?f7 "/><draw:equation draw:name="f11" draw:formula="-8050*?f6 "/><draw:equation draw:name="f12" draw:formula="?f11 +?f8 "/><draw:equation draw:name="f13" draw:formula="8050*?f6 "/><draw:equation draw:name="f14" draw:formula="?f13 +?f7 "/><draw:equation draw:name="f15" draw:formula="8050*?f6 "/><draw:equation draw:name="f16" draw:formula="?f15 +?f8 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt193("mso-spt193", "H4sIAAAAAAAA/42Vy3LCIBSGX4VhuqrDGHLR6Bgz07XtA3RHDSgzElJCvLx9iWg0xIqLRJPzf5yLP7goFDnMabkl5ZoWaEOloFqdQL3fzPecHj7kMYMBCECIJ8HlDsEZqojeolorqtfbSvJSIyPFQfpEcOoLND1qRBQldQZzhkHOQnNF5oqvilNFMyhqiepK41l0eS1kwRmnynA47pbrumgTZ/ATtHWvLpX3OuievsEXcHW2grYSW5HVXKOr3jqXajvmXmvvK3DT4jtt3OW+6QJwmwK+05incyg0KvPRLpF2LyetCC4XdgS/DdFclnYgJRFmeuw6HyaVaHYkg28BgONnBHaJHWV65MVCF9Oy8lORSym+2Wrk5WKX+5FaS+EHExc8e9LPTVwuZwkYW0M/BacPOxyHz6n0cX8+bOZiKA2S4D1nE9+PPvBJzmZglLOpDxzY5eWUA8cYQ+M2Z+ojB655NeXANiZl9FKbA9+8mvKBcXDidGmOrmJHwd13VMmat4udN6zZSrAXrQ/cnKu0MLtMNbQfU6TcUHREgpdcNMKc4P/EydHGk9h6ePz472D5B2DLGJcnBgAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt191" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f3 ?f2 ?f1 ?f2 Z N M 21600 0 L 21600 21600 ?f3 ?f4 ?f3 ?f2 Z N M 21600 21600 L 0 21600 ?f1 ?f4 ?f3 ?f4 Z N M 0 21600 L 0 0 ?f1 ?f2 ?f1 ?f4 Z N M ?f7 ?f12 X ?f10 ?f62 ?f7 ?f16 ?f14 ?f62 ?f7 ?f12 Z N M ?f18 ?f20 L ?f18 ?f22 C ?f18 ?f24 ?f26 ?f8 ?f28 ?f8 ?f30 ?f8 ?f32 ?f34 ?f32 ?f36 ?f32 ?f38 ?f40 ?f42 ?f7 ?f42 ?f44 ?f42 ?f46 ?f38 ?f46 ?f36 L ?f48 ?f36 C ?f48 ?f50 ?f52 ?f54 ?f7 ?f54 ?f18 ?f54 ?f28 ?f50 ?f28 ?f36 ?f28 ?f56 ?f58 ?f60 ?f18 ?f60 ?f7 ?f60 ?f52 ?f8 ?f52 ?f22 L ?f52 ?f20 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="left+$0 "/><draw:equation draw:name="f2" draw:formula="top+$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="bottom-$0 "/><draw:equation draw:name="f5" draw:formula="10800-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 /10800"/><draw:equation draw:name="f7" draw:formula="right/2"/><draw:equation draw:name="f8" draw:formula="bottom/2"/><draw:equation draw:name="f9" draw:formula="-1690*?f6 "/><draw:equation draw:name="f10" draw:formula="?f9 +?f7 "/><draw:equation draw:name="f11" draw:formula="4600*?f6 "/><draw:equation draw:name="f12" draw:formula="?f11 +?f8 "/><draw:equation draw:name="f13" draw:formula="1690*?f6 "/><draw:equation draw:name="f14" draw:formula="?f13 +?f7 "/><draw:equation draw:name="f15" draw:formula="7980*?f6 "/><draw:equation draw:name="f16" draw:formula="?f15 +?f8 "/><draw:equation draw:name="f17" draw:formula="1270*?f6 "/><draw:equation draw:name="f18" draw:formula="?f17 +?f7 "/><draw:equation draw:name="f19" draw:formula="4000*?f6 "/><draw:equation draw:name="f20" draw:formula="?f19 +?f8 "/><draw:equation draw:name="f21" draw:formula="1750*?f6 "/><draw:equation draw:name="f22" draw:formula="?f21 +?f8 "/><draw:equation draw:name="f23" draw:formula="800*?f6 "/><draw:equation draw:name="f24" draw:formula="?f23 +?f8 "/><draw:equation draw:name="f25" draw:formula="1650*?f6 "/><draw:equation draw:name="f26" draw:formula="?f25 +?f7 "/><draw:equation draw:name="f27" draw:formula="2340*?f6 "/><draw:equation draw:name="f28" draw:formula="?f27 +?f7 "/><draw:equation draw:name="f29" draw:formula="3640*?f6 "/><draw:equation draw:name="f30" draw:formula="?f29 +?f7 "/><draw:equation draw:name="f31" draw:formula="4670*?f6 "/><draw:equation draw:name="f32" draw:formula="?f31 +?f7 "/><draw:equation draw:name="f33" draw:formula="-1570*?f6 "/><draw:equation draw:name="f34" draw:formula="?f33 +?f8 "/><draw:equation draw:name="f35" draw:formula="-3390*?f6 "/><draw:equation draw:name="f36" draw:formula="?f35 +?f8 "/><draw:equation draw:name="f37" draw:formula="-6050*?f6 "/><draw:equation draw:name="f38" draw:formula="?f37 +?f8 "/><draw:equation draw:name="f39" draw:formula="2540*?f6 "/><draw:equation draw:name="f40" draw:formula="?f39 +?f7 "/><draw:equation draw:name="f41" draw:formula="-8050*?f6 "/><draw:equation draw:name="f42" draw:formula="?f41 +?f8 "/><draw:equation draw:name="f43" draw:formula="-2540*?f6 "/><draw:equation draw:name="f44" draw:formula="?f43 +?f7 "/><draw:equation draw:name="f45" draw:formula="-4460*?f6 "/><draw:equation draw:name="f46" draw:formula="?f45 +?f7 "/><draw:equation draw:name="f47" draw:formula="-2330*?f6 "/><draw:equation draw:name="f48" draw:formula="?f47 +?f7 "/><draw:equation draw:name="f49" draw:formula="-4700*?f6 "/><draw:equation draw:name="f50" draw:formula="?f49 +?f8 "/><draw:equation draw:name="f51" draw:formula="-1270*?f6 "/><draw:equation draw:name="f52" draw:formula="?f51 +?f7 "/><draw:equation draw:name="f53" draw:formula="-5720*?f6 "/><draw:equation draw:name="f54" draw:formula="?f53 +?f8 "/><draw:equation draw:name="f55" draw:formula="-2540*?f6 "/><draw:equation draw:name="f56" draw:formula="?f55 +?f8 "/><draw:equation draw:name="f57" draw:formula="1800*?f6 "/><draw:equation draw:name="f58" draw:formula="?f57 +?f7 "/><draw:equation draw:name="f59" draw:formula="-1700*?f6 "/><draw:equation draw:name="f60" draw:formula="?f59 +?f8 "/><draw:equation draw:name="f61" draw:formula="6290*?f6 "/><draw:equation draw:name="f62" draw:formula="?f61 +?f8 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt191("mso-spt191", "H4sIAAAAAAAA/42YUZOaMBDHv0qG6VNvGEmyCXhznjPtq+1zp2/0DMrMARbjnfftm4BwyqayD+JK9p9/Vn5uwKdtm78/mnqf1y9mG+9MUxnbfrDj2+7xrTTv35rzKkpYwgTXyeUYsU50yO0+PtrW2Jf9oSlrG7tUnmR3Ej5uE6w52zhvTX5cReuCs3Uh3Eu6FwwZHweziqpjEx8Pli/55XTVbMuiNK3TcRinG6vwxqvoB/Pr3lxWflPB+Ok3+8mmef0K/Er6FfU5w+jmZp7LakfNdW5/3LDPXH6VC6P3Z17CPr8FfpWzLlJ/RrBf/s1naTGc1P4AN6fEKOOZn81PPsSCfR9jrxJe333KLoFMhqC7GDBGeoz8KPg0GDy7AGCM9Jime6lfAWR9/H2IlZ9DeYGCy0Rd0C2vi8SYJrJhDf05Hykf6WRQdFE6BN282RC4wjdj3F336Pmpp+bvKbdlU/cM1XnlgCsGpIqmrU6v+Sr6krBocU/Bp4pXU9iHWZmYymxzmFfJqaotd3sbz+pgqvvTWNtU80I1FXY/43mdnurcJWCLvgfcFabBChfivioL1zcnW05lMdfL5KsDae6iI07WxZI9eApnhAgXcE2A4oiAcfBzb5nNKRE01CIRNc5SkqpE2KTLjGQZ4IYrUpUIHC5SkiVix1mmpCoRPm5LoliKAD18SalSIHx4qkiWAXwECR+B8MloRQboEZLkiJuOphUZoEcoyqUUiB4hgWQZoEeQ6BGIHqlJljJAjyA1HxloPqTfiAzQIznJEtETc0XzDPAjSfxIxE8sJanjyQBAktR+JAIo1gkJWhkgSKYkT0SQUCSCIECQJBEEiKA4o5UJAYSA1IAAI0StM4AQkDYwwAiB26gpngGEgNSDACMkpCR5BhACUhMCfAcEKam9qwBDQNrDFGaIuFWrAEOK1IYUZkilguQZYEiR2pDCDBG5VaG7Z1IbUvguiLZbqwBCioSQCtxE0xDSAYQUCSGNENKC1OB1gCA97UL7vN6+GnYVx4fmWPrJuudB96QW3Ywe30v7sjdb9xDXnsztWJvXOxOf46qsy+pUraLkP+P5uR9X0D8iLfoqpn/QPP8DY+823LkRAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt190" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f3 ?f2 ?f1 ?f2 Z N M 21600 0 L 21600 21600 ?f3 ?f4 ?f3 ?f2 Z N M 21600 21600 L 0 21600 ?f1 ?f4 ?f3 ?f4 Z N M 0 21600 L 0 0 ?f1 ?f2 ?f1 ?f4 Z N M ?f7 ?f10 L ?f12 ?f14 ?f12 ?f16 ?f18 ?f16 ?f18 ?f20 ?f22 ?f8 ?f24 ?f8 ?f24 ?f26 ?f28 ?f26 ?f28 ?f8 ?f30 ?f8 Z N M ?f12 ?f14 L ?f12 ?f16 ?f18 ?f16 ?f18 ?f20 Z N M ?f32 ?f36 L ?f34 ?f36 ?f34 ?f26 ?f24 ?f26 ?f24 ?f8 ?f28 ?f8 ?f28 ?f26 ?f32 ?f26 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="left+$0 "/><draw:equation draw:name="f2" draw:formula="top+$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="bottom-$0 "/><draw:equation draw:name="f5" draw:formula="10800-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 /10800"/><draw:equation draw:name="f7" draw:formula="right/2"/><draw:equation draw:name="f8" draw:formula="bottom/2"/><draw:equation draw:name="f9" draw:formula="-8000*?f6 "/><draw:equation draw:name="f10" draw:formula="?f9 +?f8 "/><draw:equation draw:name="f11" draw:formula="2960*?f6 "/><draw:equation draw:name="f12" draw:formula="?f11 +?f7 "/><draw:equation draw:name="f13" draw:formula="-5000*?f6 "/><draw:equation draw:name="f14" draw:formula="?f13 +?f8 "/><draw:equation draw:name="f15" draw:formula="-7000*?f6 "/><draw:equation draw:name="f16" draw:formula="?f15 +?f8 "/><draw:equation draw:name="f17" draw:formula="5000*?f6 "/><draw:equation draw:name="f18" draw:formula="?f17 +?f7 "/><draw:equation draw:name="f19" draw:formula="-2960*?f6 "/><draw:equation draw:name="f20" draw:formula="?f19 +?f8 "/><draw:equation draw:name="f21" draw:formula="8000*?f6 "/><draw:equation draw:name="f22" draw:formula="?f21 +?f7 "/><draw:equation draw:name="f23" draw:formula="6100*?f6 "/><draw:equation draw:name="f24" draw:formula="?f23 +?f7 "/><draw:equation draw:name="f25" draw:formula="8260*?f6 "/><draw:equation draw:name="f26" draw:formula="?f25 +?f8 "/><draw:equation draw:name="f27" draw:formula="-6100*?f6 "/><draw:equation draw:name="f28" draw:formula="?f27 +?f7 "/><draw:equation draw:name="f29" draw:formula="-8000*?f6 "/><draw:equation draw:name="f30" draw:formula="?f29 +?f7 "/><draw:equation draw:name="f31" draw:formula="-1060*?f6 "/><draw:equation draw:name="f32" draw:formula="?f31 +?f7 "/><draw:equation draw:name="f33" draw:formula="1060*?f6 "/><draw:equation draw:name="f34" draw:formula="?f33 +?f7 "/><draw:equation draw:name="f35" draw:formula="4020*?f6 "/><draw:equation draw:name="f36" draw:formula="?f35 +?f8 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt190("mso-spt190", "H4sIAAAAAAAA/52WwY6bMBCGX8VCPXVlBY8JIatlkXpO+wC90Y1JkAKm4GySt68NgQD2hlEPkEk8v/8Z+yP4bV+nl1dRHtPyQ+zpQchCqPpGms/D62cuLj/kNfZ84hNgoX+/e6QVVak60kbVQn0cK5mXiupU5kdPEm7TBCWuiqa1SJvYSzJGkgz0xfUV9Bm3SsRe0UjaVIpte2Eh93mWi1rrWDBMN3RhjGPvJzF17+6VTzoYvv0mv8g8r6vAVNJV1OX0o7vJPPdqB804t7vvyCOXjXKDwfuR55PHKrBRTpJtzC8mSX+0o8EQheYWTSIwE4EZbb8F4wBMFkSTyFzcb4PesHfZLfj0+bzdubDN50EX36POZxpFY+tHNe0sOtKzeu9v3ab+Pacql2W3xWVaaB6yfsczWRfnUxp733zirZ4p2FxxEpl6WZTBXKZktazic1WdH46KLuqCue6PVEoWy8L1XNg+Zcu6cK5LsjVZdY/oU+HG2eEKnqsid39Lsu1cRnV9/vckC5c23eIkybbkxVC3ILRwgW2IcrSA0Y8KM5abJaUFDV0ju7Sw0Z4c1abFDd0gPR3ksDXK00IH26ZFj7bcoJbWBgi5neAAiKEIAosgJLPgIAhQBIFFUMhwlg6AgKMsLYAiwC2sgx9A8QMWPxTbpgMgQAEE//0PxB0AwRbjyS2AKPNRa8sdBHEUQdwiCGvpIIijCOIWQYEPKEsHQXxOkD4P7k+CjGJaySY3k7VnBv029yajzSXXh1Wx1y/6+iymY3VaHgS90iIv8+Jc6GPxF+PptRtfB91rdOU+Y7//A4815kZ8CwAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt192" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f3 ?f2 ?f1 ?f2 Z N M 21600 0 L 21600 21600 ?f3 ?f4 ?f3 ?f2 Z N M 21600 21600 L 0 21600 ?f1 ?f4 ?f3 ?f4 Z N M 0 21600 L 0 0 ?f1 ?f2 ?f1 ?f4 Z N M ?f7 ?f12 X ?f10 ?f8 ?f7 ?f16 ?f14 ?f8 ?f7 ?f12 Z N M ?f7 ?f20 X ?f18 ?f42 ?f7 ?f24 ?f22 ?f42 ?f7 ?f20 Z N M ?f26 ?f28 L ?f30 ?f28 ?f30 ?f32 ?f34 ?f32 ?f34 ?f36 ?f26 ?f36 ?f26 ?f32 ?f38 ?f32 ?f38 ?f40 ?f26 ?f40 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="left+$0 "/><draw:equation draw:name="f2" draw:formula="top+$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="bottom-$0 "/><draw:equation draw:name="f5" draw:formula="10800-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 /10800"/><draw:equation draw:name="f7" draw:formula="right/2"/><draw:equation draw:name="f8" draw:formula="bottom/2"/><draw:equation draw:name="f9" draw:formula="-8050*?f6 "/><draw:equation draw:name="f10" draw:formula="?f9 +?f7 "/><draw:equation draw:name="f11" draw:formula="-8050*?f6 "/><draw:equation draw:name="f12" draw:formula="?f11 +?f8 "/><draw:equation draw:name="f13" draw:formula="8050*?f6 "/><draw:equation draw:name="f14" draw:formula="?f13 +?f7 "/><draw:equation draw:name="f15" draw:formula="8050*?f6 "/><draw:equation draw:name="f16" draw:formula="?f15 +?f8 "/><draw:equation draw:name="f17" draw:formula="-2060*?f6 "/><draw:equation draw:name="f18" draw:formula="?f17 +?f7 "/><draw:equation draw:name="f19" draw:formula="-7620*?f6 "/><draw:equation draw:name="f20" draw:formula="?f19 +?f8 "/><draw:equation draw:name="f21" draw:formula="2060*?f6 "/><draw:equation draw:name="f22" draw:formula="?f21 +?f7 "/><draw:equation draw:name="f23" draw:formula="-3500*?f6 "/><draw:equation draw:name="f24" draw:formula="?f23 +?f8 "/><draw:equation draw:name="f25" draw:formula="-2960*?f6 "/><draw:equation draw:name="f26" draw:formula="?f25 +?f7 "/><draw:equation draw:name="f27" draw:formula="-2960*?f6 "/><draw:equation draw:name="f28" draw:formula="?f27 +?f8 "/><draw:equation draw:name="f29" draw:formula="1480*?f6 "/><draw:equation draw:name="f30" draw:formula="?f29 +?f7 "/><draw:equation draw:name="f31" draw:formula="5080*?f6 "/><draw:equation draw:name="f32" draw:formula="?f31 +?f8 "/><draw:equation draw:name="f33" draw:formula="2960*?f6 "/><draw:equation draw:name="f34" draw:formula="?f33 +?f7 "/><draw:equation draw:name="f35" draw:formula="6140*?f6 "/><draw:equation draw:name="f36" draw:formula="?f35 +?f8 "/><draw:equation draw:name="f37" draw:formula="-1480*?f6 "/><draw:equation draw:name="f38" draw:formula="?f37 +?f7 "/><draw:equation draw:name="f39" draw:formula="-1920*?f6 "/><draw:equation draw:name="f40" draw:formula="?f39 +?f8 "/><draw:equation draw:name="f41" draw:formula="-5560*?f6 "/><draw:equation draw:name="f42" draw:formula="?f41 +?f8 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt192("mso-spt192", "H4sIAAAAAAAA/42XTZOiMBCG/0qK2tNOpUw6AXFqHKr27O55a2/sGJQq+ViIo/77TUQUSEb6IMZ0v3nT5CGGt22Tnl5VuU/LD7WlO1UVSjcX0n7uXj9zdfpRndcBI4wAj9jtGpCrqE71nra6UfpjX1d5qalJ5Sx+knAZJ2h11jRtVNqugyTjJMnAfIT5yD7jUqt1ULQVbWvNV3DrLqptnuWqMTou78Pdq7DG6+AnsfPe3GY+quD+6w/5RaZ53QzsTLoZdTl9dDMa5zbbu2aY21035JHLB7ny7v3IY+RxF/ggJ8mWtgfIb/tls+K+L7IXOeyBkQhYJ7JhCX2nFQCMuthdBnZMiM2MzExZ1761xHV95LgV9ZpB6xqNRy3J+qi8egXvb92q/TumOq/Kbg3LtDALnvVLmlVNcTyk6+AbI8HimYJPFQeV6ZdZGUxluqrnVWKqavLdXtNZnZzq/lZaV8W8MJwKr4/RvC6a6pIsJIvuGXwqXHorXMBzVeyvb062mspozEL2PcmiuUV3OEmyFXmxSM8IHVzQlg4x5uni1jOeUzrUYC0dbIylQJXpcIO19IDDQ1SVDjkUWITydOgxnktUmS5AywgwnuABiK8wdYJDELJM8AAEHFMmOABRETKUp4cgEKgyHYIorHB1ehCCEFWnByGkpwchWKLqdBDiMsZYCg9BgNqDhENQyHCWHoIEagsSDkHIGys8AAnUFiQcgCJzZMNYevgRqC1IuPxgF9PDj0BtQcLdgsxxFeMpPQAJ1BYk3T+xMEQtp/QQJKcEmcP09qDIoE3rqs3tYNfzmDkpBaNoe8rNSV9tzSGqOapxrEnLnaJnWuRlXhwL807xRTw9d/FQdkeURVfF9AXl/T/TnGDeuQwAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt200" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f3 ?f2 ?f1 ?f2 Z N M 21600 0 L 21600 21600 ?f3 ?f4 ?f3 ?f2 Z N M 21600 21600 L 0 21600 ?f1 ?f4 ?f3 ?f4 Z N M 0 21600 L 0 0 ?f1 ?f2 ?f1 ?f4 Z N M ?f10 ?f12 L ?f14 ?f12 ?f16 ?f18 ?f20 ?f18 ?f22 ?f24 ?f22 ?f26 ?f28 ?f26 ?f30 ?f24 ?f32 ?f24 ?f32 ?f34 ?f30 ?f34 ?f28 ?f36 ?f22 ?f36 ?f22 ?f38 ?f42 ?f38 ?f42 ?f40 ?f16 ?f40 ?f14 ?f44 ?f10 ?f44 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="left+$0 "/><draw:equation draw:name="f2" draw:formula="top+$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="bottom-$0 "/><draw:equation draw:name="f5" draw:formula="10800-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 /10800"/><draw:equation draw:name="f7" draw:formula="right/2"/><draw:equation draw:name="f8" draw:formula="bottom/2"/><draw:equation draw:name="f9" draw:formula="-8050*?f6 "/><draw:equation draw:name="f10" draw:formula="?f9 +?f7 "/><draw:equation draw:name="f11" draw:formula="-4020*?f6 "/><draw:equation draw:name="f12" draw:formula="?f11 +?f8 "/><draw:equation draw:name="f13" draw:formula="-7000*?f6 "/><draw:equation draw:name="f14" draw:formula="?f13 +?f7 "/><draw:equation draw:name="f15" draw:formula="-6560*?f6 "/><draw:equation draw:name="f16" draw:formula="?f15 +?f7 "/><draw:equation draw:name="f17" draw:formula="-3600*?f6 "/><draw:equation draw:name="f18" draw:formula="?f17 +?f8 "/><draw:equation draw:name="f19" draw:formula="4020*?f6 "/><draw:equation draw:name="f20" draw:formula="?f19 +?f7 "/><draw:equation draw:name="f21" draw:formula="4660*?f6 "/><draw:equation draw:name="f22" draw:formula="?f21 +?f7 "/><draw:equation draw:name="f23" draw:formula="-2960*?f6 "/><draw:equation draw:name="f24" draw:formula="?f23 +?f8 "/><draw:equation draw:name="f25" draw:formula="-2330*?f6 "/><draw:equation draw:name="f26" draw:formula="?f25 +?f8 "/><draw:equation draw:name="f27" draw:formula="6780*?f6 "/><draw:equation draw:name="f28" draw:formula="?f27 +?f7 "/><draw:equation draw:name="f29" draw:formula="7200*?f6 "/><draw:equation draw:name="f30" draw:formula="?f29 +?f7 "/><draw:equation draw:name="f31" draw:formula="8050*?f6 "/><draw:equation draw:name="f32" draw:formula="?f31 +?f7 "/><draw:equation draw:name="f33" draw:formula="2960*?f6 "/><draw:equation draw:name="f34" draw:formula="?f33 +?f8 "/><draw:equation draw:name="f35" draw:formula="2330*?f6 "/><draw:equation draw:name="f36" draw:formula="?f35 +?f8 "/><draw:equation draw:name="f37" draw:formula="3800*?f6 "/><draw:equation draw:name="f38" draw:formula="?f37 +?f8 "/><draw:equation draw:name="f39" draw:formula="-1060*?f6 "/><draw:equation draw:name="f40" draw:formula="?f39 +?f8 "/><draw:equation draw:name="f41" draw:formula="-6350*?f6 "/><draw:equation draw:name="f42" draw:formula="?f41 +?f7 "/><draw:equation draw:name="f43" draw:formula="-640*?f6 "/><draw:equation draw:name="f44" draw:formula="?f43 +?f8 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt200("mso-spt200", "H4sIAAAAAAAA/42XzY6bMBDHX8VCPXVlxXiMIavNRuo57QP0RjcmQQofBWeTvH0NDmzAbpgDzpCZPzNj/wDztm/Sy6sqj2n5ofb0oKpC6eZG2s/D62euLj+q6yZghBEeSnYfA9KL6lQfaasbpT+OdZWXmprQkCVPAm7TAK2umqaNSttNsM1Css24OcAcYoi41WoTFG1F21rzUVhU+zzLVWN0oRj/HbvoEm+Cn6Sre3evfNLBePab/CLzOFtBV4mtyMYM3t3kOvdqR81jrB135Cs2fIgVY+6vOEa+ZiF8iDFnvYubKPMjrG0G2Q1Jp2Cj1Tm4GK0uhCeDBWzwAp9YIAZvb/UKkMNVHqzOIaaWYEMt1uouIMRQtei7CN7f7Br9Pac6r0q7YmVamOXNhgXMqqY4n9JN8I2RYPVMEc4VJ5Xpl0UZn8t0VS+rYK5q8sNR00WdmOv+VFpXxbIwmgv7m2ZZJ+e6bRaRlb3jngpjb4cr/lyV+Ptbkq3nMpqwiH3fZnJp0R1OttmavGyzeEno4EIF46iUDjGG6rDLmSwpHWpozBgqp8ONyQmoPh1wqIwkKqcHnTBC5XTYoSBxfTr8mJwxam4dhJDLyT0EhSiEuIOQkKiZ5R6CeIhK6RLE17icHoI4YGaWuwRxAFROD0E8QuV0CJJxgkrpAYjHqKl1AIo5ilnwAMRRAIEDEPKpBx6AAAUQOAAh+QEPP4DiBxx+kPiABx9A4QMOPpDg1tKDD6CeP+C+wkKGmlnh4QfWmJzCfYdJQAEkPAAJFEDCfQJJgUrpAUjMATKb9f1JkQeb1lWbdxfrd4BmbxZMvO0lN18Sam+2bc1ZTX1NWh4UvdIiL/PiXJhvlv/406v1R8Juila2i/kH0Ps/1TEFkhkNAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt197" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f3 ?f2 ?f1 ?f2 Z N M 21600 0 L 21600 21600 ?f3 ?f4 ?f3 ?f2 Z N M 21600 21600 L 0 21600 ?f1 ?f4 ?f3 ?f4 Z N M 0 21600 L 0 0 ?f1 ?f2 ?f1 ?f4 Z N M ?f10 ?f12 L ?f14 ?f12 ?f14 ?f16 C ?f14 ?f18 ?f20 ?f22 ?f24 ?f22 L ?f7 ?f22 C ?f26 ?f22 ?f28 ?f18 ?f28 ?f16 L ?f28 ?f12 ?f7 ?f12 ?f30 ?f32 ?f34 ?f12 ?f36 ?f12 ?f36 ?f16 C ?f36 ?f38 ?f40 ?f42 ?f7 ?f42 L ?f24 ?f42 C ?f44 ?f42 ?f10 ?f38 ?f10 ?f16 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="left+$0 "/><draw:equation draw:name="f2" draw:formula="top+$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="bottom-$0 "/><draw:equation draw:name="f5" draw:formula="10800-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 /10800"/><draw:equation draw:name="f7" draw:formula="right/2"/><draw:equation draw:name="f8" draw:formula="bottom/2"/><draw:equation draw:name="f9" draw:formula="-8050*?f6 "/><draw:equation draw:name="f10" draw:formula="?f9 +?f7 "/><draw:equation draw:name="f11" draw:formula="-3800*?f6 "/><draw:equation draw:name="f12" draw:formula="?f11 +?f8 "/><draw:equation draw:name="f13" draw:formula="-4020*?f6 "/><draw:equation draw:name="f14" draw:formula="?f13 +?f7 "/><draw:equation draw:name="f15" draw:formula="2330*?f6 "/><draw:equation draw:name="f16" draw:formula="?f15 +?f8 "/><draw:equation draw:name="f17" draw:formula="3390*?f6 "/><draw:equation draw:name="f18" draw:formula="?f17 +?f8 "/><draw:equation draw:name="f19" draw:formula="-3100*?f6 "/><draw:equation draw:name="f20" draw:formula="?f19 +?f7 "/><draw:equation draw:name="f21" draw:formula="4230*?f6 "/><draw:equation draw:name="f22" draw:formula="?f21 +?f8 "/><draw:equation draw:name="f23" draw:formula="-1910*?f6 "/><draw:equation draw:name="f24" draw:formula="?f23 +?f7 "/><draw:equation draw:name="f25" draw:formula="1190*?f6 "/><draw:equation draw:name="f26" draw:formula="?f25 +?f7 "/><draw:equation draw:name="f27" draw:formula="2110*?f6 "/><draw:equation draw:name="f28" draw:formula="?f27 +?f7 "/><draw:equation draw:name="f29" draw:formula="4030*?f6 "/><draw:equation draw:name="f30" draw:formula="?f29 +?f7 "/><draw:equation draw:name="f31" draw:formula="-7830*?f6 "/><draw:equation draw:name="f32" draw:formula="?f31 +?f8 "/><draw:equation draw:name="f33" draw:formula="8250*?f6 "/><draw:equation draw:name="f34" draw:formula="?f33 +?f7 "/><draw:equation draw:name="f35" draw:formula="6140*?f6 "/><draw:equation draw:name="f36" draw:formula="?f35 +?f7 "/><draw:equation draw:name="f37" draw:formula="5510*?f6 "/><draw:equation draw:name="f38" draw:formula="?f37 +?f8 "/><draw:equation draw:name="f39" draw:formula="3180*?f6 "/><draw:equation draw:name="f40" draw:formula="?f39 +?f7 "/><draw:equation draw:name="f41" draw:formula="8450*?f6 "/><draw:equation draw:name="f42" draw:formula="?f41 +?f8 "/><draw:equation draw:name="f43" draw:formula="-5090*?f6 "/><draw:equation draw:name="f44" draw:formula="?f43 +?f7 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt197("mso-spt197", "H4sIAAAAAAAA/42XwZKiMBCGXyVF7WmnKEl3QJwax6rdq7sPsDd2DEqVgAtx1LffhCgKyUgfwNb0n7+bfKbC26bJTq+y2mXVh9yEW1mXUjUX1n5uXz8LefpRn5dBxCIGPImu94B1okOmdmGrGqk+doe6qFSoU3mUPkm4DBOUPKswa2TWLoNVztkqB32hvsQt43KQy6Bs67A9KL6YX38u602RF7LROi766foujPEy+MVM3etr5YMO+m9/2G82zrMVmEpsRTbnNroezHOtttc85tr7mt1z+UOu6L3veRG7PwX+kKO/dUOgs/SHsPEtStjPPk6N2uSCGQdhI6Oa29CkQtInpL0otVOt+xiuoi7ArtUu6t0xGUa2ji5GM4MwGnGbRtgyupKErUOIW0LXXieyjSam8eD9zS7rv2Omirqyi1xlpSYiv615XjflcZ8tg28RC2bPFHys2MtcvUzKYCxT9WFahWNVU2x3KpzUibHub61UXU4L47Gw+59N65KxbpXHbGb/pE+Fc2+HM3iuSv39TckWY1mYRnH0fZUnU4vucLLKF+zFIDkhdHAJUT8TiqVDjAaaG890SulQE4oISJ4ON9oTSX064AAiydJDDo9JbTroIC5Ilg492nJOsnQBQk5aTfAAxEkEgUOQANKTBQ9AQAIIXID4gpM8PQABCSBwdx5OWk3wAAQxydIBCDitSw9AMCdZOgCJiLSY6OEHSPyguwPNU5qnByAkAYQOQCmQ9ln08IMkftDhJ9FHOoqlhx8k8YMOP3FM4gc9/CBpA0KHH+QpxVJ4+EESP8LhJxWktRQefAQJH+HuP3FE2gyEhx8x5kef7jd7yR7i8FC3hZmsO//pk1kwGG1PhX71kBt9aGuOcjjWZNVWhuewLKqiPJb6JeeL8exsx2Nhj0Qz28X4jen9PxbOF2pKDQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt199" draw:modifiers="1400" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f3 ?f2 ?f1 ?f2 Z N M 21600 0 L 21600 21600 ?f3 ?f4 ?f3 ?f2 Z N M 21600 21600 L 0 21600 ?f1 ?f4 ?f3 ?f4 Z N M 0 21600 L 0 0 ?f1 ?f2 ?f1 ?f4 Z N M ?f10 ?f12 L ?f14 ?f12 ?f16 ?f18 ?f16 ?f20 ?f14 ?f22 ?f10 ?f22 Z N M ?f24 ?f8 L ?f26 ?f8 N M ?f24 ?f12 L ?f26 ?f28 N M ?f24 ?f22 L ?f26 ?f30 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="left+$0 "/><draw:equation draw:name="f2" draw:formula="top+$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="bottom-$0 "/><draw:equation draw:name="f5" draw:formula="10800-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 /10800"/><draw:equation draw:name="f7" draw:formula="right/2"/><draw:equation draw:name="f8" draw:formula="bottom/2"/><draw:equation draw:name="f9" draw:formula="-8050*?f6 "/><draw:equation draw:name="f10" draw:formula="?f9 +?f7 "/><draw:equation draw:name="f11" draw:formula="-2750*?f6 "/><draw:equation draw:name="f12" draw:formula="?f11 +?f8 "/><draw:equation draw:name="f13" draw:formula="-2960*?f6 "/><draw:equation draw:name="f14" draw:formula="?f13 +?f7 "/><draw:equation draw:name="f15" draw:formula="2120*?f6 "/><draw:equation draw:name="f16" draw:formula="?f15 +?f7 "/><draw:equation draw:name="f17" draw:formula="-8050*?f6 "/><draw:equation draw:name="f18" draw:formula="?f17 +?f8 "/><draw:equation draw:name="f19" draw:formula="8050*?f6 "/><draw:equation draw:name="f20" draw:formula="?f19 +?f8 "/><draw:equation draw:name="f21" draw:formula="2750*?f6 "/><draw:equation draw:name="f22" draw:formula="?f21 +?f8 "/><draw:equation draw:name="f23" draw:formula="4020*?f6 "/><draw:equation draw:name="f24" draw:formula="?f23 +?f7 "/><draw:equation draw:name="f25" draw:formula="8050*?f6 "/><draw:equation draw:name="f26" draw:formula="?f25 +?f7 "/><draw:equation draw:name="f27" draw:formula="-5930*?f6 "/><draw:equation draw:name="f28" draw:formula="?f27 +?f8 "/><draw:equation draw:name="f29" draw:formula="5930*?f6 "/><draw:equation draw:name="f30" draw:formula="?f29 +?f8 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_mso_spt199("mso-spt199", "H4sIAAAAAAAA/42W25KjIBCGX4Wy9mqnqEB7iE6NY9VeZ+cB9s4dMaEqiqtkkrz94jEqTORCgnb//A18Rt6yOr2+svKUlp8sw0cmCibrO2q+jq9fnF1/iVvsEEQQ0IAMrYM6UZXKE25kzeTnqRK8lFilUhI+SbgvEyS7SZzWLG1iJ8kpSnJQl6sub8y4Vyx2ikbgppI0iobHhch4zlmtdNSbhptm0RrHzm/U1n0YKl/MYLr7gz7QOq+voK2kr6jPGaOHxThDtZNmntu3B/TIpbNcb/J+5BH0WAU6y1F3XQhUlvrx+r5qgrYJxx6QMQowagCmMaCNhN0QEHTd2fNh7C4AiwjMIi5BH877W7/a/y6p5KLs175MC7VR+bgVuaiLyzmNnR8EObtnCrpWnFkuXzZlsJZJUW2r3LWq5seTxJs6b637K6QUxbbQXws7/Ld1wVqX5D7a9e/OU+HeOMMdPFeF5vltyaK1DIfEJz+TPNjadI2TJI/QS5Lvt4QaLhj2dpYaMQp62nqGW0qNGgxRYOWpcaM8Xat5auAABStLAznUt7LU0LHeTQ0f5bm3WlqNIEtLMABEIxtL0AiyBAgMAIEVQKAB5BGrzQQDP2DFD2j82C6sgR+w4gd0fvzItfI08ANW/IDGj6Wla+AH1vyo00R2ZmjWx5VoeDtY92FTnxxnEW2uXB11WKa+RvWFLWN1Wh4ZvuGCl7y4FOpQ9U08vfVx3+v/63fmE9r7f9LNid+6CQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f0 ?f0 ?f1 ?f2" draw:type="quad-bevel" draw:modifiers="2700" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 0 0 L 21600 0 ?f1 ?f0 ?f0 ?f0 Z N M 21600 0 L 21600 21600 ?f1 ?f2 ?f1 ?f0 Z N M 21600 21600 L 0 21600 ?f0 ?f2 ?f1 ?f2 Z N M 0 21600 L 0 0 ?f0 ?f0 ?f0 ?f2 Z N"><draw:equation draw:name="f0" draw:formula="$0 *21599/21600"/><draw:equation draw:name="f1" draw:formula="right-?f0 "/><draw:equation draw:name="f2" draw:formula="bottom-?f0 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_quad_bevel("quad-bevel", "H4sIAAAAAAAA/32Sy27DIBBFfwWhriohY0t9JIpTqWu3H9Adicc2UgAHj19/XxxsJ0RtFiDjOXfmDswut6Lfgq6EPkLOSjAK0I6k6cptJ6H/NENKOeEkiV/5vFNyEdUCK9agBTxWtZEamUNj/v4AGEMAYUAmLIgmpR8FJ37FbiULMdaQ0nMrcnaADk7zb2VyWUiwTpe8renWLqbCKf0ik+9sdh50sJ5+yDe557wDvi7PLNEsyDO7XTW3rN8zcmX5DZusta8cD+rODN3vfHfuFlAa7XvVQrmLKZbWC2NVexIpfeLkOYlfNpvIP1X0SB3fq60sK2RT8cfC5F54MIhGhUr3GPkJyM03q00jp2QXn2hqGkSbXrpJgTylaFsIY1boEtjAlNRStcrN5D9xMfi4nzPnJfp7wve/hPFyePoCAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="line-callout-1" draw:modifiers="-8300 24500 -1800 4000" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M ?f0 ?f1 L ?f2 ?f3 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/></draw:enhanced-geometry>
    oo_line_callout_1("line-callout-1", "H4sIAAAAAAAA/43S3W7CIBQH8Fc5Ib0l8tFWY0STXU8fYHfEgpK0UFuq8+1Hteu2sIxdcALp+Z1/E9hUnbytlT1Le1QVPinXKN/dob+e1lejbi/uXSACBBgtyVQRPJC/t0qg2liFj7Ku3eAxnT41rjLaqK4XCK/46PIiVExXoeZkHjHnttKfBdrDmPQ6Zf3InE9vcIA97DQJi4benWZhcTig7eY58zJIb5x9JljZhJ/Un4Hadc1QS4EyAmjxl6CRoAnBIsESgkeCJ0QeiTwhikgUCVFGokyIZSSWXyLccFUr+LbHrevNOORxDRn9ZyuDjI+ti9+f7PYDrPDDM8sCAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="line-callout-2" draw:modifiers="-10000 24500 -3600 4000 -1800 4000" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M ?f0 ?f1 L ?f2 ?f3 N M ?f2 ?f3 L ?f4 ?f5 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/><draw:handle draw:handle-position="$4 $5"/></draw:enhanced-geometry>
    oo_line_callout_2("line-callout-2", "H4sIAAAAAAAA/43S3W7CIBQA4Fc5Ib0l8te6GKvJrqcPsDtiqZK0UPuj8+0HlrktLMOLQ05Pz8ehoeuql9eVMidpDqrCR2VbNfY3GC7H1UWr66v9KBEBAowWJKwI7mi8dapEjTYKH2TT2GnELLxqbaVrrfqhRJgS4qHI3Yq530T4AqYvIQ3mcYZOjqcS7cBPfQtzf81/PL3DHnawrYkL6nq3NXPBQ3XOfVW4yGGPNut50nmSo7Zmnmtk6z6j/jpGbft2amSJMgJo8Z+gkaAJwSLBEoJHgieEiIRIiDwSeUIUkSgSYhmJ5bdw9141Cn7kuLOD9pvcryGjT7YyyPiTrQKy3Lcu/v7/N59EoBCuGAMAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="mso-spt49" draw:modifiers="-1800 24500 -3600 21600 -3600 4000 -1800 4000" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M ?f6 ?f7 F L ?f4 ?f5 ?f2 ?f3 ?f0 ?f1 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/><draw:handle draw:handle-position="$4 $5"/><draw:handle draw:handle-position="$6 $7"/></draw:enhanced-geometry>
    oo_mso_spt49("mso-spt49", "H4sIAAAAAAAA/43T0W6DIBQG4Fc5Id6aAoJuTW2TXeyq7QPsjkxsTYo4pe369gXL3BaW4cVPjuZ8HAxxVfXiupTtUbTvskoPUitp+hsMl8Py0sjri/4sEQYMlOTYrwhGZG6dLJEadDp0hj37t0pXTd3IfihRSp4cYdyuaTZxXzPsyrHFlZ5PJ+mEOZZoB2721sNfp5ie3mAPO9jUuU0Br7Z7UzMbbkNtMhtsQ2CP1qvHlI+zMI1uHzNboeyH1F9HqHWvzidRogQDWvwnSCBIRNBA0IjIApFFBAsEiwgeCB4ReSDyiCgCUXwLe+fVScKPOu300LhNxmtIyMxWCkk2s5VBwme25pAUrnXx98+yvgMdXimORQMAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:path-stretchpoint-x="10800" draw:text-areas="?f11 ?f12 ?f13 ?f14" draw:type="brace-pair" draw:modifiers="1800" draw:enhanced-path="M ?f4 0 X ?f0 ?f1 L ?f0 ?f6 Y 0 10800 X ?f0 ?f7 L ?f0 ?f2 Y ?f4 21600 F N M ?f8 21600 X ?f3 ?f2 L ?f3 ?f7 Y 21600 10800 X ?f3 ?f6 L ?f3 ?f1 Y ?f8 0 F N M ?f4 0 X ?f0 ?f1 L ?f0 ?f6 Y 0 10800 X ?f0 ?f7 L ?f0 ?f2 Y ?f4 21600 L ?f8 21600 X ?f3 ?f2 L ?f3 ?f7 Y 21600 10800 X ?f3 ?f6 L ?f3 ?f1 Y ?f8 0 Z S N"><draw:equation draw:name="f0" draw:formula="left+$0 "/><draw:equation draw:name="f1" draw:formula="top+$0 "/><draw:equation draw:name="f2" draw:formula="bottom-$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="?f0 *2"/><draw:equation draw:name="f5" draw:formula="$0 *2"/><draw:equation draw:name="f6" draw:formula="10800-$0 "/><draw:equation draw:name="f7" draw:formula="21600-?f6 "/><draw:equation draw:name="f8" draw:formula="right-?f5 "/><draw:equation draw:name="f9" draw:formula="$0 /3"/><draw:equation draw:name="f10" draw:formula="?f9 +$0 "/><draw:equation draw:name="f11" draw:formula="left+?f10 "/><draw:equation draw:name="f12" draw:formula="top+?f9 "/><draw:equation draw:name="f13" draw:formula="right-?f10 "/><draw:equation draw:name="f14" draw:formula="bottom-?f9 "/><draw:handle draw:handle-position="left $0" draw:handle-switched="true" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="5400"/></draw:enhanced-geometry>
    oo_brace_pair("brace-pair", "H4sIAAAAAAAA/62US2/CMAzHv4pVcdoU0ZZXQRSkHXZiXHbZdgs0LZFow9KUx7ef04YOyiNI28WE2r9/bMfyOJJ0N2LZimZLFpGEiZQpeYB8m4y2nO1exD50XHDB9/qusQ6UULIuGNkInqk8dDw3cHWYC9WpsidQ9cWgG6pWJFeSqeWqVCB7I2ECFNsrQiWjKD2NPQ/Q+Np0tOkeow4bFjoLSZeYCOXSfE5FxGPOpE7rV7KuUV8eOm8o1MV0P/DX1aIwM6c+fNZlHL2D2uujV5NVUa8wB60UmP86vlNGzcxpgPEnDagj+nWEVyoG8Kv297xm/5bTF7zD3JmMqx5+F1RxkVUdzWiK7Y+PDY6FTIs1DZ01i9VzywWnfQ/zmpgSGzvlN6mFUEqkxAp2mqDkyUrZuW6T0+1+8u9DvSbUsjP9JlO+jT3BQZMrX5bo17wPBtc7Mo17FnB4pbp2x/LaF1MyjYfwwJRcjEk5XTihVvJiVPSA6Vst3I1JeeTKi2Ex03l2K66haM3g5IxbNOdaraoOWsdmGXe+47goWYQlyIKd+yTNEkYOJOUZT4sUl/UNP91X/l4XVyLm0r6++Sc/HUzLVhIGAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:path-stretchpoint-x="10800" draw:text-areas="?f8 ?f9 ?f10 ?f11" draw:type="bracket-pair" draw:modifiers="3700" draw:enhanced-path="M ?f0 0 X 0 ?f1 L 0 ?f2 Y ?f0 21600 F N M ?f3 21600 X 21600 ?f2 L 21600 ?f1 Y ?f3 0 F N M ?f0 0 X 0 ?f1 L 0 ?f2 Y ?f0 21600 L ?f3 21600 X 21600 ?f2 L 21600 ?f1 Y ?f3 0 Z S N"><draw:equation draw:name="f0" draw:formula="left+$0 "/><draw:equation draw:name="f1" draw:formula="top+$0 "/><draw:equation draw:name="f2" draw:formula="bottom-$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="-(sin(45*(pi/180))*($0 -10800)-cos(45*(pi/180))*(0-10800))+10800"/><draw:equation draw:name="f5" draw:formula="?f4 -10800"/><draw:equation draw:name="f6" draw:formula="-$0 "/><draw:equation draw:name="f7" draw:formula="?f6 -?f5 "/><draw:equation draw:name="f8" draw:formula="left-?f7 "/><draw:equation draw:name="f9" draw:formula="top-?f7 "/><draw:equation draw:name="f10" draw:formula="right+?f7 "/><draw:equation draw:name="f11" draw:formula="bottom+?f7 "/><draw:equation draw:name="f12" draw:formula="left-?f5 "/><draw:equation draw:name="f13" draw:formula="top-?f5 "/><draw:equation draw:name="f14" draw:formula="right+?f5 "/><draw:equation draw:name="f15" draw:formula="bottom+?f5 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_bracket_pair("bracket-pair", "H4sIAAAAAAAA/5WUzVLDIBSFX4VhXLR2mEL/dYydceGqunGj7rC5SRmbEAmx8e0lgcaa1FIXJTT3fgdOOMNNqPjuGtINT9cQkhhkAlp9ofwzvv4UsLuTZYApomjEZtSNGNVQvC2AZFKkOg8wowtatVFkZ3Y8gOwbh2Zcb0iuFej1plYgpZNwDRpKTbgCbqSX0QItoyvzY7Qa2L7nK4MAvym+fgdNMi6UKyQyFJEAZdjxvJFsPFaLB/jBSFXbfUa1KFrVzxF6qd/bLd+jR1T1jd3/Z/es+lbNnNXMGP30+3RX/9B8RU/oEd/eWA8fBddCptZRyhPzAaK9wUiqpNjyAG8h0oMLivDwFMbamJaZnxq1qTeptUyIFxy3QSXijfZzkzZHerlIe5PpZS8TQ7ag/f5lz6iQOj59spZ5q0hdqT+wCTu53LS93DKaOO3T4KyzT6+1eXetGSLLaOrhFscO3HBzD3d15MTPwFgnYPXRDc4gOxmzaTkH7QTNmfR9HNYJmnXp5TpB27v0kp3MNC4PUHP5hFtAB3Nzd+aiUguwiYrZJf5VzXfC3I4QGgOqgN81xdMYSEkSkYqkSMwN/Uedl7beBHh4/L6//QZBvE3tCAYAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="mso-spt41" draw:modifiers="-8300 24500 -1800 4000" draw:enhanced-path="M 0 0 S L 21600 0 21600 21600 0 21600 Z N M ?f0 ?f1 L ?f2 ?f3 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/></draw:enhanced-geometry>
    oo_mso_spt41("mso-spt41", "H4sIAAAAAAAA/43STW/CIBgH8K/yhPRK5K3VGNFk5+llt93ICkoipZaq89uPatdtYRk78ATI8+NPAqu6U9elbg6qedM13mvvdN/dIFz2y4vV1yf/LhEBAoxWZKwI7qi/tVoiFzwObS/ouOt8bY3VXZAIL/hARBkrpotYBZn0FNmq/iDRFoaQF3geg34ETqtX2MEWNobEQWPvxrA4OOzQevU49XRWvfXNI6NRLt7QfEYa37nzUUlUEECzvwRNBM0IlgiWETwRPCNEIkRGlIkoM6JKRJUR80TMv0R84/qo4dsctz7Y4ZD7MxT0n60MCj60zn7/r+sPiVA1T8gCAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="mso-spt42" draw:modifiers="-10000 24500 -3600 4000 -1800 4000" draw:enhanced-path="M 0 0 S L 21600 0 21600 21600 0 21600 Z N M ?f0 ?f1 L ?f2 ?f3 N M ?f2 ?f3 L ?f4 ?f5 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/><draw:handle draw:handle-position="$4 $5"/></draw:enhanced-geometry>
    oo_mso_spt42("mso-spt42", "H4sIAAAAAAAA/43Sz2/CIBQH8H/lhfRK5GddjNVk5+llt93ICtpESm2rzv9+YJnbwjI8QF5f3odvG7qse3VZ6Hav2ndd4512Vo/9FYbzbnFu9OXZfVSIAAFGSxJ3BDc0XjtdITs4PHSjYLFrXd2YRvdDhTAlJBgh/Y558CI0MH2KZTT3+E6N+wptIAS+wksM/RV+f3qDLWxgbYhf1M+uDfOLx+5Uh67wS8IWrZZT1vGkxsa1U3KrrP8G8/UixvX2dFAVKgig2X+CJoJmBEsEywieCJ4RIhEiI2QiZEaUiSgzYp6I+bfwN18fNPyoceeGJhxyu4aCPjjKoOAPjgooZBid/f3zrz4BzUizyhUDAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="mso-spt43" draw:modifiers="-1800 24500 -3600 21600 -3600 4000 -1800 4000" draw:enhanced-path="M 0 0 S L 21600 0 21600 21600 0 21600 Z N M ?f6 ?f7 F L ?f4 ?f5 ?f2 ?f3 ?f0 ?f1 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="$4 "/><draw:equation draw:name="f5" draw:formula="$5 "/><draw:equation draw:name="f6" draw:formula="$6 "/><draw:equation draw:name="f7" draw:formula="$7 "/><draw:handle draw:handle-position="$0 $1"/><draw:handle draw:handle-position="$2 $3"/><draw:handle draw:handle-position="$4 $5"/><draw:handle draw:handle-position="$6 $7"/></draw:enhanced-geometry>
    oo_mso_spt43("mso-spt43", "H4sIAAAAAAAA/43Tu26DMBQG4Fc5slhRfAOqKE6kDp2aLN26WcUklgKmQG5vH5u4tJWrmuG3Duh8PkYWq7KTl6VqDrL5UGW6V6ZWQ3eD/rxfnrW6PJurQBgwUJJjvyIY0XBrlUB1b9K+HTjzb2tT6kqrrhcoJU+O8MyuKZu4rzl25djiSs+nk7RyOAi0BTf7DV49/XWO6ekddrCFTZXbFPBiuzcVt8lsqA2zwTYEdmi9esz5PMlBm+YxtZG1/ZTq6xCV6erTUQqUYECL/wQJBIkIGggaESwQLCJ4IHhEZIHIIiIPRB4RRSCKb2FvvTwq+FGnrem122S8hoTMbKWQsJmtHJJsZmsOSeFaF3//Lus7N5CSAkcDAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 88 21600" draw:glue-points="44 ?f6 44 0 0 10800 44 21600 88 10800" draw:text-areas="0 ?f6 88 ?f3" draw:type="can" draw:modifiers="5400" draw:enhanced-path="M 44 0 C 20 0 0 ?f2 0 ?f0 L 0 ?f3 C 0 ?f4 20 21600 44 21600 68 21600 88 ?f4 88 ?f3 L 88 ?f0 C 88 ?f2 68 0 44 0 Z N M 44 0 C 20 0 0 ?f2 0 ?f0 0 ?f5 20 ?f6 44 ?f6 68 ?f6 88 ?f5 88 ?f0 88 ?f2 68 0 44 0 Z N"><draw:equation draw:name="f0" draw:formula="$0 *2/4"/><draw:equation draw:name="f1" draw:formula="?f0 *6/11"/><draw:equation draw:name="f2" draw:formula="?f0 -?f1 "/><draw:equation draw:name="f3" draw:formula="21600-?f0 "/><draw:equation draw:name="f4" draw:formula="?f3 +?f1 "/><draw:equation draw:name="f5" draw:formula="?f0 +?f1 "/><draw:equation draw:name="f6" draw:formula="$0 *2/2"/><draw:equation draw:name="f7" draw:formula="44"/><draw:handle draw:handle-position="?f7 $0" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/></draw:enhanced-geometry>
    oo_can("can", "H4sIAAAAAAAA/42T226DMAyGX8WKetUJESBQVJUibbfbHmB3UUlopBI6Dj28/eIE2qljbDdxEvuz/xi8KRp+Xgu953onCq8UdSW65grtqVyflDg/15eMUKCQphAGCaUELFEeeuEda6W7NiOMQS4TMAYjA5pSigcbj6C9GcBOXDqPN4K3mBcxE5DLaHRfjyIjO66Hc1UXSirRmOiY3ZLc9B55t8/Imyv9AiG1CnIZ2pXCq7WRcaFlGOBU3eQl6V0nRjg1BrQbTGo3IQZSV+cD3uH3krjGeD20BE2S3l8aj5mn8pLtxj3ws+edqrV7ruaVaYocXy/rpuoPPCMLCsvQZ8Sfo4JHCmsvEz8I5rlwivNyGcA8Fz1ytr0e0vMg+1kwgqe/C8ZTQv/BJdPtDOep1SPF7v03P2VxEPBtb0akVZgDVa1gMX7CwdtwXQrv6lVKq6qvzET84ucX53eTZOr503O7/QKSpwKv0AMAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="0 0 21600 21600" draw:type="chevron" draw:modifiers="10800" draw:enhanced-path="M 0 0 L ?f0 0 21600 10800 ?f0 21600 0 21600 ?f1 10800 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="21600-?f0 "/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="21600"/></draw:enhanced-geometry>
    oo_chevron("chevron", "H4sIAAAAAAAA/31RzY7CIBB+lQnZK5F6MMZYTTyrD+BtYoeWRKBSWuvbS6HWXaN7AWa++X4yrAuHtxWZCs2ZCl6S1eTdHZquXHWKbjvb50yAgHm2EOPJIJI89Z6jI2y+Ttxrytm5os5ZM/a0LZRU5AIpE8tpdEpQo69ydoBBcQ9b+VKO47GT6ue9ldmIneDINuukd23RK2uSukEdgsinmbROtxfM2Y8ANvuPkb0zoiUfQkzEELy4EPx689o2atCKDt7W7A/q0JTEe66VUbrVYXtfcOwTnnYa/Gaff2vzAKgOoVLGAQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="3000 3320 17110 17330" draw:type="cloud-callout" draw:modifiers="6300 24300" draw:enhanced-path="M 1930 7160 C 1530 4490 3400 1970 5270 1970 5860 1950 6470 2210 6970 2600 7450 1390 8340 650 9340 650 10004 690 10710 1050 11210 1700 11570 630 12330 0 13150 0 13840 0 14470 460 14870 1160 15330 440 16020 0 16740 0 17910 0 18900 1130 19110 2710 20240 3150 21060 4580 21060 6220 21060 6720 21000 7200 20830 7660 21310 8460 21600 9450 21600 10460 21600 12750 20310 14680 18650 15010 18650 17200 17370 18920 15770 18920 15220 18920 14700 18710 14240 18310 13820 20240 12490 21600 11000 21600 9890 21600 8840 20790 8210 19510 7620 20000 7930 20290 6240 20290 4850 20290 3570 19280 2900 17640 1300 17600 480 16300 480 14660 480 13900 690 13210 1070 12640 380 12160 0 11210 0 10120 0 8590 840 7330 1930 7160 Z N M 1930 7160 C 1950 7410 2040 7690 2090 7920 F N M 6970 2600 C 7200 2790 7480 3050 7670 3310 F N M 11210 1700 C 11130 1910 11080 2160 11030 2400 F N M 14870 1160 C 14720 1400 14640 1720 14540 2010 F N M 19110 2710 C 19130 2890 19230 3290 19190 3380 F N M 20830 7660 C 20660 8170 20430 8620 20110 8990 F N M 18660 15010 C 18740 14200 18280 12200 17000 11450 F N M 14240 18310 C 14320 17980 14350 17680 14370 17360 F N M 8220 19510 C 8060 19250 7960 18950 7860 18640 F N M 2900 17640 C 3090 17600 3280 17540 3460 17450 F N M 1070 12640 C 1400 12900 1780 13130 2330 13040 F N U ?f17 ?f18 1800 1800 0 360 Z N U ?f19 ?f20 1200 1200 0 360 Z N U ?f13 ?f14 700 700 0 360 Z N"><draw:equation draw:name="f0" draw:formula="$0 -10800"/><draw:equation draw:name="f1" draw:formula="$1 -10800"/><draw:equation draw:name="f2" draw:formula="atan2(?f1 ,?f0 )/(pi/180)"/><draw:equation draw:name="f3" draw:formula="10800*cos(?f2 *(pi/180))"/><draw:equation draw:name="f4" draw:formula="10800*sin(?f2 *(pi/180))"/><draw:equation draw:name="f5" draw:formula="?f3 +10800"/><draw:equation draw:name="f6" draw:formula="?f4 +10800"/><draw:equation draw:name="f7" draw:formula="$0 -?f5 "/><draw:equation draw:name="f8" draw:formula="$1 -?f6 "/><draw:equation draw:name="f9" draw:formula="?f7 /3"/><draw:equation draw:name="f10" draw:formula="?f8 /3"/><draw:equation draw:name="f11" draw:formula="?f7 *2/3"/><draw:equation draw:name="f12" draw:formula="?f8 *2/3"/><draw:equation draw:name="f13" draw:formula="$0 "/><draw:equation draw:name="f14" draw:formula="$1 "/><draw:equation draw:name="f15" draw:formula="?f3 /12"/><draw:equation draw:name="f16" draw:formula="?f4 /12"/><draw:equation draw:name="f17" draw:formula="?f9 +?f5 -?f15 "/><draw:equation draw:name="f18" draw:formula="?f10 +?f6 -?f16 "/><draw:equation draw:name="f19" draw:formula="?f11 +?f5 "/><draw:equation draw:name="f20" draw:formula="?f12 +?f6 "/><draw:handle draw:handle-position="$0 $1"/></draw:enhanced-geometry>
    oo_cloud_callout("cloud-callout", "H4sIAAAAAAAA/5VWTW/iMBD9KxbqoR+L8NiOP6pSpEXa2+5tL3uLStIiUegC/fr3O28SAyKIdC/JxPZ7M/PmYXE3W5fvt9XyqVw+VLPhY7V6rrbrT7V5e7x9m1fv31cf44FWWhnyun0OlIC21cd2WK6rcjMeWM2b1hqtKBDhae3u3OdLNR48LFavs+FDueD3tt15Xs3m9bxaM4G3YHd2x74r6aXcPo0HPxUlq1Xg/GqqqODYucQ5HeMoBa0KE3IUPaJCK+/40xguyGPDoIXgeIMsYyODleevlAPiNhyfRRTQhsYiGekIiahgGq5VkeEGFYioaN7RydshpUMBLqIgFMzlSr0ceW3kmA/N8ZBI3jEJPZgTBDRIb7ThU5KBS2AiV8QcemN2YWhCNGcgo46QynusWuaJzucBJlfkkPR+mUzAusZpcj6iIhGk0LSLhZwnG6RezLoIBzEKamMnYkWR0KEHisJso8ldkcH42uxSe1tg3C1HSGp0wKhkBKkg9CUc0i0swXQJcrgculjk0BbiCQPVRODgkdo2ocZZzMLmyEEziSyOixGspNYgMkBbbKNAla2BbZKxxgK18iHY/8Cxf9QvdeRg2DM4GTLOI5XRCT0x0w85v/fstB0spAioz8KYwQf86CifPzAqJ8hmEnljoylCSIYfTYvZu3SKucn0tEjhmpFzWIi2+zx7h6IR5DGYGgvNoTUSEuSHVg3mwJNT/sA7UpDueT02MwVtTGmXJ3qfLTiFnZzYSaxlZAqNIbVYCMbOPe0th6aaaynJgK0Y2TdxEDv7jIviYDHZVEUtl4iBzsmLsxHK1RKhTdvX3lZTnkrKxrJSYIByVm6DcFDf3kzTVu2WRpwneop/rG7z/FaTmgIekbOLABp+s623ZD/xAw2IKKa7b/FwCvYIh7uD+7vmxv37Wm7nq2Vz/y7LZ76163wd16v18+uiHA8utBrCT3owOoejDo6+hDPHuHJbLs0lV66+TWqtrkaXL/MRt391nsce80ju64fVhrmMus4sPTTuNM1mvvwvmuKYZlJbdfMFOXwX6L4EDKfmNqkLdR4WT41tUvseWOqWGdTI9lik461JHftRHWch17XpxXWchWxfwHWcxEr2QDquYRV7ICcdMuKiz8NO+qMf1nHHpE7qBvbgYVOfSajjEgZp4L3g+9xCJ+xC1OTvuR1OWIZMk3mH5P+Ns0WlDuLhy2ozB5kM74JwdHT6j+/9P9ikYEURCwAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="?f7 0 ?f6 ?f1 0 ?f10 ?f6 21600 ?f4 ?f10 21600 ?f9" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="0 ?f1 ?f4 ?f12" draw:type="cube" draw:modifiers="5400" draw:enhanced-path="M 0 ?f12 L 0 ?f1 ?f2 0 ?f11 0 ?f11 ?f3 ?f4 ?f12 Z N M 0 ?f1 L ?f2 0 ?f11 0 ?f4 ?f1 Z N M ?f4 ?f12 L ?f4 ?f1 ?f11 0 ?f11 ?f3 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="top+?f0 "/><draw:equation draw:name="f2" draw:formula="left+?f0 "/><draw:equation draw:name="f3" draw:formula="bottom-?f0 "/><draw:equation draw:name="f4" draw:formula="right-?f0 "/><draw:equation draw:name="f5" draw:formula="right-?f2 "/><draw:equation draw:name="f6" draw:formula="?f5 /2"/><draw:equation draw:name="f7" draw:formula="?f2 +?f6 "/><draw:equation draw:name="f8" draw:formula="bottom-?f1 "/><draw:equation draw:name="f9" draw:formula="?f8 /2"/><draw:equation draw:name="f10" draw:formula="?f1 +?f9 "/><draw:equation draw:name="f11" draw:formula="right"/><draw:equation draw:name="f12" draw:formula="bottom"/><draw:handle draw:handle-position="left $0" draw:handle-switched="true" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="21600"/></draw:enhanced-geometry>
    oo_cube("cube", "H4sIAAAAAAAA/42U246DIBCGX4WY3jWkQs9Nrcled/cB9o7WQUlEXMQe3n5R1Gx1W3uhgvN/Mz9kYB9pdt1BlrDsDBGOQUkw+o6KS7y7CLh+qFvg+chHlKz85u2hGorTEnCuRGaKwAv52opCvrIPqUfETR0X8oX71U63TZKcmQQXRoM5J3UubOsRf9NVGQrujwIDN4OZBlZURqvqTTHaCu45BN65PEHzQ6pIcAHaAstFl6fbg6pi4H26RVB0RG1W6kak/YR83tVC3+gLNYxFeuJa00g64tgF+kmt0DvsnaufkhmhMucxY9IuhbeWudKyTFngTXzkzV4RpE8YlU9DPobRPpYCN29w8z53UsYoicfJRZ/UIk7MG+DyGUhHwFUfDPkSzehraD2EKJpW/f6a2zzdGDJCbocVN6M2yaBTqkLW53asXwYNU2/nCDRoF7e6jrIHLEoB/Rnb+6MQVSLXWmjSGm7CxVXYcw+RbVhdwmNMsywGfMdSZEKW0p7+J3F2c3F3eVkzs/8vvcMvl3vFfA0FAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="?f17 0 ?f16 ?f22 ?f12 ?f2 ?f8 ?f22 ?f14 ?f2" draw:text-areas="?f45 ?f47 ?f46 ?f48" draw:type="mso-spt105" draw:modifiers="10800 18900 16200" draw:enhanced-path="V 0 0 ?f3 ?f23 0 ?f22 ?f4 0 ?f15 0 ?f1 ?f23 ?f7 0 ?f13 ?f2 L ?f14 ?f2 ?f8 ?f22 ?f12 ?f2 A 0 0 ?f3 ?f23 ?f11 ?f2 ?f17 ?f26 ?f15 0 ?f1 ?f23 ?f17 ?f26 ?f15 ?f22 Z N V 0 0 ?f3 ?f23 0 ?f22 ?f4 0 W 0 0 ?f3 ?f23 ?f4 0 ?f17 ?f26 A ?f15 0 ?f1 ?f23 ?f17 ?f26 ?f15 ?f22 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$0 +21600-$1 "/><draw:equation draw:name="f4" draw:formula="?f3 /2"/><draw:equation draw:name="f5" draw:formula="$1 +$1 -21600"/><draw:equation draw:name="f6" draw:formula="?f5 +$1 -$0 "/><draw:equation draw:name="f7" draw:formula="?f6 /2"/><draw:equation draw:name="f8" draw:formula="(21600+$0 )/2"/><draw:equation draw:name="f9" draw:formula="21600-$2 "/><draw:equation draw:name="f10" draw:formula="?f4 *sqrt(1-(?f9 /21600)*(?f9 /21600))"/><draw:equation draw:name="f11" draw:formula="?f4 +?f10 "/><draw:equation draw:name="f12" draw:formula="?f11 +$1 -21600"/><draw:equation draw:name="f13" draw:formula="?f7 +?f10 "/><draw:equation draw:name="f14" draw:formula="?f12 +21600-$0 "/><draw:equation draw:name="f15" draw:formula="?f5 -$0 "/><draw:equation draw:name="f16" draw:formula="?f15 /2"/><draw:equation draw:name="f17" draw:formula="(?f4 +?f7 )/2"/><draw:equation draw:name="f18" draw:formula="$0 +$1 -21600"/><draw:equation draw:name="f19" draw:formula="?f18 /2"/><draw:equation draw:name="f20" draw:formula="?f17 -?f19 "/><draw:equation draw:name="f21" draw:formula="21600"/><draw:equation draw:name="f22" draw:formula="21600"/><draw:equation draw:name="f23" draw:formula="21600*2"/><draw:equation draw:name="f24" draw:formula="?f17 -?f4 "/><draw:equation draw:name="f25" draw:formula="21600*sqrt(1-(?f24 /?f4 )*(?f24 /?f4 ))"/><draw:equation draw:name="f26" draw:formula="21600-?f25 "/><draw:equation draw:name="f27" draw:formula="?f8 +128"/><draw:equation draw:name="f28" draw:formula="?f5 /2"/><draw:equation draw:name="f29" draw:formula="?f5 -128"/><draw:equation draw:name="f30" draw:formula="$0 +?f17 -?f12 "/><draw:equation draw:name="f31" draw:formula="21600*sqrt(1-(?f20 /?f4 )*(?f20 /?f4 ))"/><draw:equation draw:name="f32" draw:formula="21600-$0 "/><draw:equation draw:name="f33" draw:formula="?f32 /2"/><draw:equation draw:name="f34" draw:formula="21600*21600"/><draw:equation draw:name="f35" draw:formula="?f9 *?f9 "/><draw:equation draw:name="f36" draw:formula="?f34 -?f35 "/><draw:equation draw:name="f37" draw:formula="sqrt(?f36 )"/><draw:equation draw:name="f38" draw:formula="?f37 +21600"/><draw:equation draw:name="f39" draw:formula="21600*21600/?f38 "/><draw:equation draw:name="f40" draw:formula="?f39 +64"/><draw:equation draw:name="f41" draw:formula="$0 /2"/><draw:equation draw:name="f42" draw:formula="21600*sqrt(1-(?f33 /?f41 )*(?f33 /?f41 ))"/><draw:equation draw:name="f43" draw:formula="21600-?f42 "/><draw:equation draw:name="f44" draw:formula="?f43 +64"/><draw:equation draw:name="f45" draw:formula="?f4 /2"/><draw:equation draw:name="f46" draw:formula="$1 -?f45 "/><draw:equation draw:name="f47" draw:formula="21600*2195/16384"/><draw:equation draw:name="f48" draw:formula="21600*14189/16384"/><draw:handle draw:handle-position="$0 21600" draw:handle-range-x-minimum="?f40" draw:handle-range-x-maximum="?f29" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/><draw:handle draw:handle-position="$1 21600" draw:handle-range-x-minimum="?f27" draw:handle-range-x-maximum="?f21" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/><draw:handle draw:handle-position="21600 $2" draw:handle-range-x-minimum="3375" draw:handle-range-x-maximum="21600" draw:handle-range-y-minimum="?f44" draw:handle-range-y-maximum="?f22"/></draw:enhanced-geometry>
    oo_mso_spt105("mso-spt105", "H4sIAAAAAAAA/72XTW+jMBCG/4qFekiCUPAHX1XTqnte7XFX2htqIEUKkAJpk3+/HpsQgt0Mpz3EgeB3/Hr8eIiftk369ZhV72n1lm29XVaXWdecSfu5e/wssq8f9Wnj+MQnjIZ+3zpEiXb7Y+Yd6qLq2o3zktNI9pJfoWwYgyto4BMPvwi46uVdduq8tMlSpRaBfCQiaCCAiC+9zods45Rt7bWHjvpB/3NZb4u8yBqppX4sjdE4gTZkg71hToe0e984v4mv/HGwwNWl8iS060B/6YcveT8X1Zn8HKzfTEZP7/U2rvyd9j0pzIaFlug3T1S4v+QXuefwz3SU3nYf6HXuIM7zk07OxzHtirrSqarSUiY5v2Qur5vyuE83zoNPnPU9BTUUFFEwQ8EQBbe4chWHHjqamGohg2t2XxRYJuXKj6fhv6sNzQEDLUZzGZnSEPUaT0ULZdKVoy0xbTLV9knFFoQanACOq/aj6RbUW7zkibQNoZar8c0SiWqwBFFdSS8KocGU2oRzl4wagMH2nzWwBS9ZFS5wonIDNIBlhs4Cmdzi2HJTA7BFn+EIZ4UaoMEunJthgzRpOEYNMwtnsqh5sk2wKmPANMMmMziaIzLoUaIVNjcbOmpuApuaQY0e8Lr9mCBriKO233CDbD9mQKUplhECzJGlcsXEpSxGdAZTwD9KhQUmuWvQ0bjt7eYORKFvITtR47T747T789LO7czhRYBbqhZnaPa4wV2PK046t5SrhKygQYSWesUFZJ1jaHEDLZVvqQwJllkLXTzqizMitb8ZdZLksvIY+9thqVw8IW4oEJ35f8pHl1TYERqRybmCkWo0r3dIBoW9tEGNwnaLsJQ3wWckwMKYwDNgAAYvJnWmQIQGXpeFToI1DXmM2TUY03oq5HFkEkAeRrb7jIyu5dmpLSCmWubxyap/3qTVLvNOXllURXksVTK+65KeLl2GAnnT5XyNYg1xvoZQB6qZvulM38M74o5v+v9868PsA0N8cx4FiO9vp3++WTaBeIfzGVhfa9imx/Hnf2iKPB6nDwAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="0 ?f15 ?f2 ?f11 0 ?f8 ?f2 ?f13 ?f21 ?f16" draw:text-areas="?f43 ?f41 ?f44 ?f42" draw:type="mso-spt103" draw:modifiers="10800 18900 5400" draw:enhanced-path="V ?f22 0 ?f21 ?f3 0 0 ?f21 ?f4 ?f22 ?f14 ?f21 ?f1 ?f21 ?f7 ?f2 ?f12 L ?f2 ?f13 0 ?f8 ?f2 ?f11 A ?f22 0 ?f21 ?f3 ?f2 ?f10 ?f24 ?f16 ?f22 ?f14 ?f21 ?f1 ?f24 ?f16 0 ?f14 Z N V ?f22 0 ?f21 ?f3 0 0 ?f21 ?f4 A ?f22 ?f14 ?f21 ?f1 ?f21 ?f7 ?f24 ?f16 ?f22 ?f14 ?f21 ?f1 ?f24 ?f16 0 ?f14 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$0 +21600-$1 "/><draw:equation draw:name="f4" draw:formula="?f3 /2"/><draw:equation draw:name="f5" draw:formula="$1 +$1 -21600"/><draw:equation draw:name="f6" draw:formula="?f5 +$1 -$0 "/><draw:equation draw:name="f7" draw:formula="?f6 /2"/><draw:equation draw:name="f8" draw:formula="(21600+$0 )/2"/><draw:equation draw:name="f9" draw:formula="?f4 *sqrt(1-($2 /21600)*($2 /21600))"/><draw:equation draw:name="f10" draw:formula="?f4 +?f9 "/><draw:equation draw:name="f11" draw:formula="?f10 +$1 -21600"/><draw:equation draw:name="f12" draw:formula="?f7 +?f9 "/><draw:equation draw:name="f13" draw:formula="?f11 +21600-$0 "/><draw:equation draw:name="f14" draw:formula="?f5 -$0 "/><draw:equation draw:name="f15" draw:formula="?f14 /2"/><draw:equation draw:name="f16" draw:formula="(?f4 +?f7 )/2"/><draw:equation draw:name="f17" draw:formula="$0 +$1 -21600"/><draw:equation draw:name="f18" draw:formula="?f17 /2"/><draw:equation draw:name="f19" draw:formula="?f16 -?f18 "/><draw:equation draw:name="f20" draw:formula="21600"/><draw:equation draw:name="f21" draw:formula="21600"/><draw:equation draw:name="f22" draw:formula="-21600"/><draw:equation draw:name="f23" draw:formula="?f16 -?f4 "/><draw:equation draw:name="f24" draw:formula="21600*sqrt(1-(?f23 /?f4 )*(?f23 /?f4 ))"/><draw:equation draw:name="f25" draw:formula="?f8 +128"/><draw:equation draw:name="f26" draw:formula="?f5 /2"/><draw:equation draw:name="f27" draw:formula="?f5 -128"/><draw:equation draw:name="f28" draw:formula="$0 +?f16 -?f11 "/><draw:equation draw:name="f29" draw:formula="21600-$0 "/><draw:equation draw:name="f30" draw:formula="?f29 /2"/><draw:equation draw:name="f31" draw:formula="21600*21600"/><draw:equation draw:name="f32" draw:formula="$2 *$2 "/><draw:equation draw:name="f33" draw:formula="?f31 -?f32 "/><draw:equation draw:name="f34" draw:formula="sqrt(?f33 )"/><draw:equation draw:name="f35" draw:formula="?f34 +21600"/><draw:equation draw:name="f36" draw:formula="21600*21600/?f35 "/><draw:equation draw:name="f37" draw:formula="?f36 +64"/><draw:equation draw:name="f38" draw:formula="$0 /2"/><draw:equation draw:name="f39" draw:formula="21600*sqrt(1-(?f30 /?f38 )*(?f30 /?f38 ))"/><draw:equation draw:name="f40" draw:formula="?f39 -64"/><draw:equation draw:name="f41" draw:formula="?f4 /2"/><draw:equation draw:name="f42" draw:formula="$1 -?f41 "/><draw:equation draw:name="f43" draw:formula="21600*2195/16384"/><draw:equation draw:name="f44" draw:formula="21600*14189/16384"/><draw:handle draw:handle-position="left $0" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800" draw:handle-range-y-minimum="?f37" draw:handle-range-y-maximum="?f27"/><draw:handle draw:handle-position="left $1" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800" draw:handle-range-y-minimum="?f25" draw:handle-range-y-maximum="?f20"/><draw:handle draw:handle-position="$2 21600" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="?f40" draw:handle-range-y-minimum="3375" draw:handle-range-y-maximum="21600"/></draw:enhanced-geometry>
    oo_mso_spt103("mso-spt103", "H4sIAAAAAAAA/72Xy46bMBSGX8VCs8hFKPgCgdFk0HRdddlFd6gxGaQAGSAzydvXNrc0x8khXXQRZGL/9u/j7xzgZVslX8+yeE+K33Lr7mSZy6Y6k/pz9/yZya9v5WnjeMQjjAZed3WIEe32R+keyqxoaj0kTqmvLkw3KNH3YX/LdYPqVtBpG3lq3KSSiZLGqdADhB4ghL6wftT5IDdOXpdufWiox7u/83KbpZmslJZ6oXJFw0hdfTFYG/ZzSJr3jfNTr8+MJ2ODE2+8EW2nMicGm31j3e+Ake/jZv7aGyVvYPauy/wjzLZvrNF1em3PL/KDIFbfMLOPLee8vrTx+jgmTVYWbfSKJFdhT/tgpmWVH/fJxnnyiLO6p6BAQREFAwqGKLjF1dJg6aKriWutju+K3Rf5lk0t1c9tc+GuNoAL+q0YjeUaSgPUa3gtmhmTS7XaHNNGcEFBFvVH1cyoO1PnsjJzzRcX7TnCA0BIz7mM0wgDCZBk0mlq2CnASmfHlHUBXSbDe75Q/i2A+RPOmgLGTIJiJ0YBXrMuvmv8uCkA7OmBAAPQlOE1btjCmKpHrrqGWKEAKE2wyQBGU0QAnikRYTZyzNYEtjMAjVluyDxVt1WR0vOo1Lu4QXKPWZgKyZKyENFZaxZ2ssxSrhT5+GoAJE3hQAX6+ABATcxUbqlMLEK3ye1ALSYAwm2PugX+uLNwxakODkelACyDlFJygsDDLfBw0dVBRAr4uQiRIpf7mG0LSjwgy0AgOhtK6IHaAbpIPu7pfONhm33jHRJBYQGMR8TFdiEsTz78SSAgXIYRgb4RAbz604r8FQ14iNm9UbyoUO/kVxOoV/LtXpKLtvp6qDM958bZy7QhT33Quu4qKXbSPbl5VmT5MVdfGTf6k1Pbbz4HbGPO4xzxSNj1kH6aWNezB2zT/2J7qOh3bHvTbKuyc/kl96++4xHzW7Y5X2O2h6Kyajm7/hZ9/QPCG2qUpA4AAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="0 ?f17 ?f2 ?f14 ?f22 ?f8 ?f2 ?f12 ?f22 ?f16" draw:text-areas="?f47 ?f45 ?f48 ?f46" draw:type="mso-spt102" draw:modifiers="10800 18900 16200" draw:enhanced-path="B 0 0 ?f23 ?f3 ?f22 0 0 ?f4 0 ?f15 ?f23 ?f1 0 ?f7 ?f2 ?f13 L ?f2 ?f14 ?f22 ?f8 ?f2 ?f12 W 0 0 ?f23 ?f3 ?f2 ?f11 ?f26 ?f17 0 ?f15 ?f23 ?f1 ?f26 ?f17 ?f22 ?f15 Z N B 0 0 ?f23 ?f3 ?f22 0 0 ?f4 A 0 0 ?f23 ?f3 0 ?f4 ?f26 ?f17 W 0 ?f15 ?f23 ?f1 ?f26 ?f17 ?f22 ?f15 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$0 +21600-$1 "/><draw:equation draw:name="f4" draw:formula="?f3 /2"/><draw:equation draw:name="f5" draw:formula="$1 +$1 -21600"/><draw:equation draw:name="f6" draw:formula="?f5 +$1 -$0 "/><draw:equation draw:name="f7" draw:formula="?f6 /2"/><draw:equation draw:name="f8" draw:formula="(21600+$0 )/2"/><draw:equation draw:name="f9" draw:formula="21600-$2 "/><draw:equation draw:name="f10" draw:formula="?f4 *sqrt(1-(?f9 /21600)*(?f9 /21600))"/><draw:equation draw:name="f11" draw:formula="?f4 +?f10 "/><draw:equation draw:name="f12" draw:formula="?f11 +$1 -21600"/><draw:equation draw:name="f13" draw:formula="?f7 +?f10 "/><draw:equation draw:name="f14" draw:formula="?f12 +21600-$0 "/><draw:equation draw:name="f15" draw:formula="?f5 -$0 "/><draw:equation draw:name="f16" draw:formula="?f15 /2"/><draw:equation draw:name="f17" draw:formula="(?f4 +?f7 )/2"/><draw:equation draw:name="f18" draw:formula="$0 +$1 -21600"/><draw:equation draw:name="f19" draw:formula="?f18 /2"/><draw:equation draw:name="f20" draw:formula="?f17 -?f19 "/><draw:equation draw:name="f21" draw:formula="21600"/><draw:equation draw:name="f22" draw:formula="21600"/><draw:equation draw:name="f23" draw:formula="21600*2"/><draw:equation draw:name="f24" draw:formula="?f17 -?f4 "/><draw:equation draw:name="f25" draw:formula="21600*sqrt(1-(?f24 /?f4 )*(?f24 /?f4 ))"/><draw:equation draw:name="f26" draw:formula="21600-?f25 "/><draw:equation draw:name="f27" draw:formula="?f8 +128"/><draw:equation draw:name="f28" draw:formula="?f5 /2"/><draw:equation draw:name="f29" draw:formula="?f5 -128"/><draw:equation draw:name="f30" draw:formula="$0 +?f17 -?f12 "/><draw:equation draw:name="f31" draw:formula="21600*sqrt(1-(?f20 /?f4 )*(?f20 /?f4 ))"/><draw:equation draw:name="f32" draw:formula="21600-$0 "/><draw:equation draw:name="f33" draw:formula="?f32 /2"/><draw:equation draw:name="f34" draw:formula="21600*21600"/><draw:equation draw:name="f35" draw:formula="?f9 *?f9 "/><draw:equation draw:name="f36" draw:formula="?f34 -?f35 "/><draw:equation draw:name="f37" draw:formula="sqrt(?f36 )"/><draw:equation draw:name="f38" draw:formula="?f37 +21600"/><draw:equation draw:name="f39" draw:formula="21600*21600/?f38 "/><draw:equation draw:name="f40" draw:formula="?f39 +64"/><draw:equation draw:name="f41" draw:formula="$0 /2"/><draw:equation draw:name="f42" draw:formula="21600*sqrt(1-(?f33 /?f41 )*(?f33 /?f41 ))"/><draw:equation draw:name="f43" draw:formula="21600-?f42 "/><draw:equation draw:name="f44" draw:formula="?f43 +64"/><draw:equation draw:name="f45" draw:formula="?f4 /2"/><draw:equation draw:name="f46" draw:formula="$1 -?f45 "/><draw:equation draw:name="f47" draw:formula="21600*2195/16384"/><draw:equation draw:name="f48" draw:formula="21600*14189/16384"/><draw:handle draw:handle-position="21600 $0" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800" draw:handle-range-y-minimum="?f40" draw:handle-range-y-maximum="?f29"/><draw:handle draw:handle-position="21600 $1" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800" draw:handle-range-y-minimum="?f27" draw:handle-range-y-maximum="?f21"/><draw:handle draw:handle-position="$2 21600" draw:handle-range-x-minimum="?f44" draw:handle-range-x-maximum="?f22" draw:handle-range-y-minimum="3375" draw:handle-range-y-maximum="21600"/></draw:enhanced-geometry>
    oo_mso_spt102("mso-spt102", "H4sIAAAAAAAA/72XTW+jMBCG/4qFekiCUPAHBKqmaHte7bXS3lBDUqQAKSFt+u/XY/ORxQ7DXvYQC+y849fD4wE/7er06zEr39PyLdt5h6wqsqb+JufPw+Nnnn29VNet4xOfMBr6besQJTocL5l3qvKyOcNfkj3dyIbBhYALuIq6Htb10LCVN9m18dI6S6U62QvQigAa0Ij+X9+nbOsU58o7nxrqs7a7qHb5Ps9qqaV+JI3RKIY2ZL29fk2ntHnfOi8EViFNcNlw7Ub3CNXSoBuk6r5fCyc/p5b1asSFfgoXoc7JOPow0qUkIL/JLzLl8MffY7pzCPQ6dxLn+Ukn5+OSNnlV6lSVaSGTvO8yt6/q4nJMt86DT5z1lIIaCooomKFgiIJbXLmKQw+dTYy1kLw1mxYFlkW58udp+Ce1oTlhoMVoLjemNES9RmPRQpl05WxLTBuPtW1SsQdCDU4AxtX5o24W1Fsk+1jahlDL1e3NEolqsARRXQkuCqHBlNqAcx8ZNQCDzT9rYgtesiJ0cKJyAzSAZYbOApnc3djjpgZgizbDG5wVaoAGu3Buhg3SpOEINcwsnMl65sk2xqqMAdMMm8zgaI7IoEeJVtjabOiotQlsaQY1esJh+zFB1hBHbb/+Btl+zIBKUywjBJgjS+WKiEtZhOgMpoB/lAoLTHLXoLNx29vN7YlC30J2om7T7t+m3Z+Xdm5nDi8C3FK1OEOzxw3uWlxx0rmlXMVkBQ0itNQrLiDrHEOLG2ipfEtlSLDMWujim7Y4I1L7m1EnST5WHmGfHZbKxWPihgLRmd9TPvpIhR2hGzI5VzBSjeZwh2RQ2Esb1ChstwhLeRN8RgIsjAk8AwZg8GJSxwlEaODVPeg4WNOQR5hdgzGtp0IeR0YB5GFkd8zIzbU8O51ziNnKyEOHTTtep+Uh865ekZd5cSnkIevOeHrV4+ooZPvP9xAjGegc/6ULk0CR/Rff9L/47t8zE77pPN/yG/f2JHvPdzKAfM96Mnw23HPO+SZAnPdFaa1hGx/Hn/8A2s88PKcPAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="?f8 0 ?f11 ?f2 ?f15 0 ?f16 ?f21 ?f13 ?f2" draw:text-areas="?f41 ?f43 ?f42 ?f44" draw:type="mso-spt104" draw:modifiers="10800 18900 5400" draw:enhanced-path="B 0 ?f22 ?f3 ?f21 0 0 ?f4 ?f21 ?f14 ?f22 ?f1 ?f21 ?f7 ?f21 ?f12 ?f2 L ?f13 ?f2 ?f8 0 ?f11 ?f2 W 0 ?f22 ?f3 ?f21 ?f10 ?f2 ?f16 ?f24 ?f14 ?f22 ?f1 ?f21 ?f16 ?f24 ?f14 0 Z N B 0 ?f22 ?f3 ?f21 0 0 ?f4 ?f21 W ?f14 ?f22 ?f1 ?f21 ?f7 ?f21 ?f16 ?f24 ?f14 ?f22 ?f1 ?f21 ?f16 ?f24 ?f14 0"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$0 +21600-$1 "/><draw:equation draw:name="f4" draw:formula="?f3 /2"/><draw:equation draw:name="f5" draw:formula="$1 +$1 -21600"/><draw:equation draw:name="f6" draw:formula="?f5 +$1 -$0 "/><draw:equation draw:name="f7" draw:formula="?f6 /2"/><draw:equation draw:name="f8" draw:formula="(21600+$0 )/2"/><draw:equation draw:name="f9" draw:formula="?f4 *sqrt(1-($2 /21600)*($2 /21600))"/><draw:equation draw:name="f10" draw:formula="?f4 +?f9 "/><draw:equation draw:name="f11" draw:formula="?f10 +$1 -21600"/><draw:equation draw:name="f12" draw:formula="?f7 +?f9 "/><draw:equation draw:name="f13" draw:formula="?f11 +21600-$0 "/><draw:equation draw:name="f14" draw:formula="?f5 -$0 "/><draw:equation draw:name="f15" draw:formula="?f14 /2"/><draw:equation draw:name="f16" draw:formula="(?f4 +?f7 )/2"/><draw:equation draw:name="f17" draw:formula="$0 +$1 -21600"/><draw:equation draw:name="f18" draw:formula="?f17 /2"/><draw:equation draw:name="f19" draw:formula="?f16 -?f18 "/><draw:equation draw:name="f20" draw:formula="21600"/><draw:equation draw:name="f21" draw:formula="21600"/><draw:equation draw:name="f22" draw:formula="-21600"/><draw:equation draw:name="f23" draw:formula="?f16 -?f4 "/><draw:equation draw:name="f24" draw:formula="21600*sqrt(1-(?f23 /?f4 )*(?f23 /?f4 ))"/><draw:equation draw:name="f25" draw:formula="?f8 +128"/><draw:equation draw:name="f26" draw:formula="?f5 /2"/><draw:equation draw:name="f27" draw:formula="?f5 -128"/><draw:equation draw:name="f28" draw:formula="$0 +?f16 -?f11 "/><draw:equation draw:name="f29" draw:formula="21600-$0 "/><draw:equation draw:name="f30" draw:formula="?f29 /2"/><draw:equation draw:name="f31" draw:formula="21600*21600"/><draw:equation draw:name="f32" draw:formula="$2 *$2 "/><draw:equation draw:name="f33" draw:formula="?f31 -?f32 "/><draw:equation draw:name="f34" draw:formula="sqrt(?f33 )"/><draw:equation draw:name="f35" draw:formula="?f34 +21600"/><draw:equation draw:name="f36" draw:formula="21600*21600/?f35 "/><draw:equation draw:name="f37" draw:formula="?f36 +64"/><draw:equation draw:name="f38" draw:formula="$0 /2"/><draw:equation draw:name="f39" draw:formula="21600*sqrt(1-(?f30 /?f38 )*(?f30 /?f38 ))"/><draw:equation draw:name="f40" draw:formula="?f39 -64"/><draw:equation draw:name="f41" draw:formula="?f4 /2"/><draw:equation draw:name="f42" draw:formula="$1 -?f41 "/><draw:equation draw:name="f43" draw:formula="21600*2195/16384"/><draw:equation draw:name="f44" draw:formula="21600*14189/16384"/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="?f37" draw:handle-range-x-maximum="?f27" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/><draw:handle draw:handle-position="$1 top" draw:handle-range-x-minimum="?f25" draw:handle-range-x-maximum="?f20" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/><draw:handle draw:handle-position="21600 $2" draw:handle-range-x-minimum="3375" draw:handle-range-x-maximum="21600" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="?f40"/></draw:enhanced-geometry>
    oo_mso_spt104("mso-spt104", "H4sIAAAAAAAA/7WXTW+jMBCG/4qFckiCUPAHX1XTSD2v9lppb2hjUqQAKZA2+fe1TaA042TYlXoIAsxrvx4/M44ft3X68SDL17T8K7feTlaFbOszad53D++5/HiuTmvHJz5hNPQvV4cY0W5/lN6hysu2WTubLFYfbTJK1YXpm6B7DvWzfkm5vrtoW3lqvbSWqZEK3S50u9BSIfqvzge5doqm8ppDS/3+dVFt8yyXtdJSP1auaJyoayAGa8N8Dmn7unaejRWm++adHd+8EYM30bfT/lU0tDEzo1/DFMjVXF9A76rJ78Ng5i/sY3xr9Mkf8psgVl8ws9OHc54eu1i9HdM2r8oucmVaqJBnfSCzqi6O+3TtzHzirO4pKFBQRMGAgiEKbnHlGiQ9dDRxrdUBXrH7osAyKVf9vC4P7mpDOGDQidFYRlAaol7ja9HcmHTVaAtMm8ABBVk2b3U7p95crcvK9LVYju4XCA8AId2nu8kSDCRAkkmnqWGnACudHlPGBXSZDO/5Qvm3ABZMWGsKGDPpia0YBXjNL/GN8OWmALDZPwQYgKYMR7hhC2OqIHnqGmOFAqA0wSYDGE0RAXimRITZyDFTE9jMADRmuCHzVLlWRUr3o1Jv9IDkHrMwFROXshjRWWsWtrLMUq4U+fhoACRN4UAFun0AoCZmKrdUJpag0+R2oJYTAOG2rW6Jb3cWrjjVweGoFIBlkFJKThB4uAUeLi51EJECfkYhUuTyALNtQYmHxA0ForOhhC6oHaBR8nFf5xuPu+z7ekIiKCyA8YR42CyEZefDdwIB4TKMCPQfEcCrX60kWNGQx5jdG8WLCvV//KoD9Xd8u5dkdK9ODk2u+zRr1VYH51trnZY76Z28Ii/z4liYEEY3PklP/SfM+sn5qxf/RnvfhTlPTHRNJ7keavEd17dc/YDr7hg3Y4hvziPM9/go+L/GNzpXlO9VR9n1KfTpE6UGpSSeDgAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="5400 5400 16200 16200" draw:type="diamond" draw:enhanced-path="M 10800 0 L 21600 10800 10800 21600 0 10800 10800 0 Z N"/>
    oo_diamond("diamond", "H4sIAAAAAAAA/1WOzQrCMBCEX2XJvbgtWqQYDz2rD+AtmCUt2CSksT9vb20SaS8fy+wMMxfpxFiRboR+kcwUmY68m6EfVDW0NNZm4gwBochLjGSwhtT7Q5k1rfY9Zzme8WdDCFfgJhSUGPU0+Uw4EkvydFyeK/KySEy+2RJnshWd0TJq/61W+IazO6Tq27ZoN2CvITzhwQ7XL2I/tb/7AAAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="?f18 ?f0 ?f20 10800 ?f19 ?f1 ?f21 10800" draw:text-areas="?f5 ?f22 ?f11 ?f23" draw:type="mso-spt188" draw:modifiers="1350 10800" draw:enhanced-path="M ?f7 ?f0 C ?f15 ?f9 ?f30 ?f10 ?f18 ?f0 ?f31 ?f9 ?f16 ?f10 ?f12 ?f0 L ?f24 ?f1 C ?f25 ?f26 ?f33 ?f28 ?f19 ?f1 ?f32 ?f26 ?f27 ?f28 ?f29 ?f1 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="21600-?f0 "/><draw:equation draw:name="f2" draw:formula="$1 "/><draw:equation draw:name="f3" draw:formula="?f2 -10800"/><draw:equation draw:name="f4" draw:formula="?f3 *2"/><draw:equation draw:name="f5" draw:formula="abs(?f4 )"/><draw:equation draw:name="f6" draw:formula="4320-?f5 "/><draw:equation draw:name="f7" draw:formula="if(?f3 ,0,?f5 )"/><draw:equation draw:name="f8" draw:formula="7900*?f0 /2230"/><draw:equation draw:name="f9" draw:formula="?f0 -?f8 "/><draw:equation draw:name="f10" draw:formula="?f0 +?f8 "/><draw:equation draw:name="f11" draw:formula="21600-?f4 "/><draw:equation draw:name="f12" draw:formula="if(?f3 ,?f11 ,21600)"/><draw:equation draw:name="f13" draw:formula="?f12 -?f7 "/><draw:equation draw:name="f14" draw:formula="?f5 /2"/><draw:equation draw:name="f15" draw:formula="?f7 +3600-?f14 "/><draw:equation draw:name="f16" draw:formula="?f12 +?f14 -3600"/><draw:equation draw:name="f17" draw:formula="?f13 /2"/><draw:equation draw:name="f18" draw:formula="?f7 +?f17 "/><draw:equation draw:name="f19" draw:formula="21600-?f18 "/><draw:equation draw:name="f20" draw:formula="?f5 /2"/><draw:equation draw:name="f21" draw:formula="21600-?f20 "/><draw:equation draw:name="f22" draw:formula="?f0 *2"/><draw:equation draw:name="f23" draw:formula="21600-?f22 "/><draw:equation draw:name="f24" draw:formula="21600-?f7 "/><draw:equation draw:name="f25" draw:formula="21600-?f15 "/><draw:equation draw:name="f26" draw:formula="?f1 +?f8 "/><draw:equation draw:name="f27" draw:formula="21600-?f16 "/><draw:equation draw:name="f28" draw:formula="?f1 -?f8 "/><draw:equation draw:name="f29" draw:formula="21600-?f12 "/><draw:equation draw:name="f30" draw:formula="?f18 -?f14 "/><draw:equation draw:name="f31" draw:formula="?f18 +?f14 "/><draw:equation draw:name="f32" draw:formula="?f19 -?f14 "/><draw:equation draw:name="f33" draw:formula="?f19 +?f14 "/><draw:handle draw:handle-position="left $0" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="2230"/><draw:handle draw:handle-position="$1 21600" draw:handle-range-x-minimum="8640" draw:handle-range-x-maximum="12960"/></draw:enhanced-geometry>
    oo_mso_spt188("mso-spt188", "H4sIAAAAAAAA/42W3W6bMBTHX8VCvWiboNjHQEhVGmm73fYAu/MWkyIFSIG0ydvPx4QswYTDBQhx/Dtf/vvjdVOprxddvKvir974W13muqlOrP7cvnxm+utbeUw8zjgDEfHz22MW2u4O2t+XWdHUibdORczWKTcPcCZ4zPFTrPCF/0T774w2+tj4qtLKkiEOABxph8pu0GmvEy+vS7/eNyKOz7/zcpOlma4MKmTIb/xe6tir5j3xfhp3S5vVd/SOcTAhaVOzry5nKc42EV1sYG0/MKXAloFOwCaLg6TEr/i6SgmdEZadEVrjb/bLe3ttk/w4qCYrizblQuWmyrSrIC2r/LBTiffAmbcYI0SfsHPjY87jIDihBEHIPmHKYn7b+FEwcEHJnmEcCvuQ+lM/rtOAPY1zUZ8LJGA/QqK6ZZ/L0kfMc87nCBNR4z69XHH+jLOwAJBEf1ZufzgzKcfU3DtyQXA2AbyrmoAiHdl0bbLrdm79EL0SA0Iyy8zHVUqQA0oKTYcJypESRprJtmJBluwoyqY7s6iPXgjeUZYhJZ21IymbtWHJLjl66mZXUMKAAUXRDYa7cgJyF3L0hBKm9gZwFHQJCFRAR0IdSrUVHBld2krtLTAkoSkLFRztXGJGFDqgHzFlV4H78qGaKwfkYzQ3ZZVJR0MWnU1BBzRkDuNJUYe2olU/qrlNbHaaXX2bC0+dobfE2+m0YQ9d4WdzpYqt9k9+nhVZfsjN3emOXR1b+80hMRrPHNPX168bh8f/AeMouDekiylgFdmgi+Hb39s/F3peMhYKAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f0 0 ?f2 ?f5" draw:type="down-arrow" draw:modifiers="10800 5400" draw:enhanced-path="M ?f0 0 L ?f0 ?f1 0 ?f1 10800 21600 21600 ?f1 ?f2 ?f1 ?f2 0 Z N"><draw:equation draw:name="f0" draw:formula="$1 "/><draw:equation draw:name="f1" draw:formula="$0 "/><draw:equation draw:name="f2" draw:formula="21600-$1 "/><draw:equation draw:name="f3" draw:formula="21600-?f1 "/><draw:equation draw:name="f4" draw:formula="?f3 *?f0 /10800"/><draw:equation draw:name="f5" draw:formula="?f1 +?f4 "/><draw:equation draw:name="f6" draw:formula="?f1 *?f0 /10800"/><draw:equation draw:name="f7" draw:formula="?f1 -?f6 "/><draw:handle draw:handle-position="$1 $0" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="21600"/></draw:enhanced-geometry>
    oo_down_arrow("down-arrow", "H4sIAAAAAAAA/42T3W6DIBzFX4WQXm0hglW3NLUmu972ALsjEyxJAYda9e2HoG3TOt2FYPjzO+fwtc8NbXdMHan6ZjkqmJasNj2ozsXuLFj7prsUYoBBSBI8thA4qGZdjahhtEphxoc5GQ/tF0/1vmQpzHWr7Cyj23FY6lxwwYylCH61mnF0kbzkKGl9TOEH8Lrvrs84Ab713E0iN+rdfY/BF/iEh71X/WloLbTyHopKG4tPllwb2ZxoCjcEwGCJIA8EXiHCe8KFRatO23luWNwyGN2DGd+Cp2HzArdny3T8SBPwnPFoxTWZ4/7t+jJH27UmV1d7KfITAzf/qNSVGKTcuW2mwxyLhqqCoQ5JoYRspL3Af9Rp5+s+5sycfkWjv2r4p2EjB/NP6vALYSN8hGsDAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="0 0 21600 ?f0" draw:type="down-arrow-callout" draw:modifiers="14035 5400 16200 8100" draw:enhanced-path="M 0 ?f0 L 0 0 21600 0 21600 ?f0 ?f5 ?f0 ?f5 ?f2 ?f4 ?f2 10800 21600 ?f1 ?f2 ?f3 ?f2 ?f3 ?f0 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="21600-?f1 "/><draw:equation draw:name="f5" draw:formula="21600-?f3 "/><draw:handle draw:handle-position="left $0" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="$2"/><draw:handle draw:handle-position="$3 $2" draw:handle-range-x-minimum="$1" draw:handle-range-x-maximum="10800" draw:handle-range-y-minimum="$0" draw:handle-range-y-maximum="21600"/><draw:handle draw:handle-position="$1 bottom" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="$3"/></draw:enhanced-geometry>
    oo_down_arrow_callout("down-arrow-callout", "H4sIAAAAAAAA/42TwY6DIBCGX2VCvJICatM0tZvseXcfYG9sxZZEwKVY7dsvVWvJttYeAJOZb/5/RtjkljdroQ9c70SO98Io4ewZjqf9+iRF827aDBEgwOiSDDuCDnKidZhbwY9hxlsxxs+VyFBuGu2zrGnwjpelqd0QViaXhRTW0zQhcQpp4nG6ZH5f0VFltFZxd8jQJ3QS8AE3yUDarzQ4mV9Jd1KyIrc8OsTi4CTwDV9ou+lVf2vupNG9B82V72RsrDBW1SXPUEQALZ4R9I6gMwS7I9gMEd8R8QyR/Ce6seDLWJ6D6RQYKPq/lZcCgm9cmaO81MpQKQoH0XWOQ9hyvRf4jJXUUtXKX6aJOG/7eMReU/ODiNijWu1NK6ITCVex7uLMGJ7s6FqkfzavmabwY5wzasb4Q8nAdxRf9BaPn/f2DycF0oz3AwAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 3163 3163 0 10800 3163 18437 10800 21600 18437 18437 21600 10800 18437 3163" draw:text-areas="3163 3163 18437 18437" draw:type="ellipse" draw:enhanced-path="U 10800 10800 10800 10800 0 360 Z N"/>
    oo_ellipse("ellipse", "H4sIAAAAAAAA/2WPPQ7CMAyFr2Jlj3AoKlVFGDgAGwtbRK20UkmiNvTn9rRJCkgsT/JnPz/7VHVqLMnUyjyo4prsk3w3Qz/ocmhovNhJMgSEvcgxKYNg0u2LuLON8b1kAgtcxzKRZ1EQIguFKA7ZMYG4KZGgiYRuJKspxXiaPFcdqSXlu/3Hvs3NjiSjtm1cT4l9/nLK15Ldtow/Xc7MEe5wZbvzGzbON20TAQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f0 ?f1 ?f22 ?f25" draw:type="mso-spt107" draw:modifiers="5400 5400 18900" draw:enhanced-path="A ?f9 ?f38 ?f8 ?f37 0 ?f27 ?f0 ?f26 ?f9 ?f13 ?f8 ?f4 ?f0 ?f25 ?f22 ?f25 ?f9 ?f38 ?f8 ?f37 ?f22 ?f26 ?f3 ?f27 L ?f7 ?f40 ?f3 0 W ?f9 ?f35 ?f8 ?f10 ?f3 0 ?f21 ?f33 ?f9 ?f36 ?f8 ?f1 ?f21 ?f31 ?f20 ?f31 ?f9 ?f35 ?f8 ?f10 ?f20 ?f33 0 0 L ?f5 ?f40 Z N W ?f9 ?f36 ?f8 ?f1 ?f20 ?f31 ?f0 ?f32 F L ?f20 ?f33 N A ?f9 ?f36 ?f8 ?f1 ?f21 ?f31 ?f22 ?f32 F L ?f21 ?f33 N M ?f0 ?f26 F L ?f0 ?f32 N M ?f22 ?f26 F L ?f22 ?f32 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="right"/><draw:equation draw:name="f4" draw:formula="bottom"/><draw:equation draw:name="f5" draw:formula="right/8"/><draw:equation draw:name="f6" draw:formula="right/2"/><draw:equation draw:name="f7" draw:formula="right*7/8"/><draw:equation draw:name="f8" draw:formula="right*3/2"/><draw:equation draw:name="f9" draw:formula="-?f6 "/><draw:equation draw:name="f10" draw:formula="bottom-$2 "/><draw:equation draw:name="f11" draw:formula="?f10 *30573/4096"/><draw:equation draw:name="f12" draw:formula="?f11 *2"/><draw:equation draw:name="f13" draw:formula="bottom-?f12 "/><draw:equation draw:name="f14" draw:formula="?f11 +$2 "/><draw:equation draw:name="f15" draw:formula="?f11 +bottom-$1 "/><draw:equation draw:name="f16" draw:formula="bottom-$1 "/><draw:equation draw:name="f17" draw:formula="?f16 /2"/><draw:equation draw:name="f18" draw:formula="?f11 +?f17 "/><draw:equation draw:name="f19" draw:formula="?f14 +$1 -bottom"/><draw:equation draw:name="f20" draw:formula="$0 +?f5 "/><draw:equation draw:name="f21" draw:formula="right-?f20 "/><draw:equation draw:name="f22" draw:formula="right-$0 "/><draw:equation draw:name="f23" draw:formula="?f6 -$0 "/><draw:equation draw:name="f24" draw:formula="?f11 *sqrt(1-(?f23 /right)*(?f23 /right))"/><draw:equation draw:name="f25" draw:formula="?f24 +bottom-?f11 "/><draw:equation draw:name="f26" draw:formula="?f25 +?f11 -?f19 "/><draw:equation draw:name="f27" draw:formula="$2 +?f11 -?f19 "/><draw:equation draw:name="f28" draw:formula="?f11 *2391/32768"/><draw:equation draw:name="f29" draw:formula="?f6 -?f20 "/><draw:equation draw:name="f30" draw:formula="?f11 *sqrt(1-(?f29 /right)*(?f29 /right))"/><draw:equation draw:name="f31" draw:formula="$1 +?f30 -?f11 "/><draw:equation draw:name="f32" draw:formula="?f25 +$1 -bottom"/><draw:equation draw:name="f33" draw:formula="bottom+?f30 -?f14 "/><draw:equation draw:name="f34" draw:formula="?f11 +?f14 "/><draw:equation draw:name="f35" draw:formula="bottom-?f34 "/><draw:equation draw:name="f36" draw:formula="?f35 +?f19 -?f11 "/><draw:equation draw:name="f37" draw:formula="?f10 +?f15 -?f11 "/><draw:equation draw:name="f38" draw:formula="?f35 +?f15 -?f11 "/><draw:equation draw:name="f39" draw:formula="?f28 +?f14 -?f18 "/><draw:equation draw:name="f40" draw:formula="bottom-?f39 "/><draw:equation draw:name="f41" draw:formula="?f19 -?f18 "/><draw:equation draw:name="f42" draw:formula="?f41 *2/3"/><draw:equation draw:name="f43" draw:formula="$1 -?f42 "/><draw:equation draw:name="f44" draw:formula="$2 -?f42 "/><draw:equation draw:name="f45" draw:formula="min(?f44 ,20925)"/><draw:equation draw:name="f46" draw:formula="right*3/8"/><draw:equation draw:name="f47" draw:formula="?f46 -4"/><draw:handle draw:handle-position="$0 21600" draw:handle-range-x-minimum="?f5" draw:handle-range-x-maximum="?f47"/><draw:handle draw:handle-position="10800 $1" draw:handle-range-y-minimum="?f10" draw:handle-range-y-maximum="?f43"/><draw:handle draw:handle-position="left $2" draw:handle-range-y-minimum="?f27" draw:handle-range-y-maximum="?f45"/></draw:enhanced-geometry>
    oo_mso_spt107("mso-spt107", "H4sIAAAAAAAA/5VXTXObMBD9KxrGh8Qpg774ysTJpIee2lwz0xutwWEmGAeTxP73XQmEY0v2qgdkbOm9t2jfrszdsis+b8v1S7H+Wy7DVdk2Zd/tyfZjdftRl5/f290ioIQSzhI6jgHRoL7c9WHRlcV2ETxUlDxUDC7O1RCbNftNuQiabRtuNz2j6fhz0y7rqi47QMYSaPXAsnzingLaFP3LIngEzhwukcGgLpESJchTMijzZFzBxLhCmpn4EJSDxcwpvBgYf8KHmpBU/0bJs8HFI46ZGVivnlkIsyIxK6YpfUfNnU0zzCkyqpXjQfk3eTroHrFOXPqGkx8aZmieyCMSCz+CMQP7ddjJYWqkH2bMJo2okeMpuL8b0vX2XvR1ux6Sty4aSHplclm1XfP+WiyCGSVBdAnBLARDENxCcAQhThFdvXrpL2PkKeZP2/dtcxkUO4Wi7DIqcaP4ZVTqRM1TTC1z4wSml5/iwocqwZJr+WHYxRBNGbN8oWtnLmicikjSPEHwlksAz8gceUhmWWUMGNBoyJZltOQN/qyWbQag2SusIJhlIG+kZSJQTghmBWZ5aAgYxhRTtGwEIAmbxEjoU2Hc1WFuVAtFcJaftO1D3UURqGWlAYq2Nm6ZSVWMB85tpPn2reuvWHgFMQsS6SCu50ffrhFih9G4nIymVRAGy2r6jL3RUEWQYwSW46A8/gPudt6ci5xFgqcJ0vy4w34J8XGBsIxnJSU/SkrumRThOgFhRwQlPhkRjkanMuJbUOJMxztEILEIzvQ9H6hlyMmKAsU6rCgGK+Z+O+dqfrqZsNiPwGHGMQJPAocbeTbunCLIEAJ57nyFQLBSkq4TNveTdXhOqiqMBAK0zDbTdS+xI1JaHoO24QW0HNbUayhPKck3TnMeI9Up3X/O4O8S0mmkw10SWo2cYPC2s3wtyZf7cNNua8WkT7Wv713jfFesV2W4C+EZ6ua9UZzxmRXFzqyASLwkGc3gjWzGXIT7r5LMGdX+SFP4ab6WVU9mHJWcjo0LkrGSjIaMnL7b3v8DFM6NjfQOAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f0 ?f22 ?f19 ?f1" draw:type="mso-spt108" draw:modifiers="5400 16200 2700" draw:enhanced-path="W ?f9 ?f34 ?f8 ?f35 0 ?f24 ?f0 ?f23 ?f9 0 ?f8 ?f11 ?f0 ?f22 ?f19 ?f22 ?f9 ?f34 ?f8 ?f35 ?f19 ?f23 ?f3 ?f24 L ?f7 ?f36 ?f3 ?f4 A ?f9 ?f31 ?f8 ?f32 ?f3 ?f4 ?f18 ?f30 ?f9 ?f1 ?f8 ?f33 ?f18 ?f28 ?f17 ?f28 ?f9 ?f31 ?f8 ?f32 ?f17 ?f30 0 ?f4 L ?f5 ?f36 Z N A ?f9 ?f1 ?f8 ?f33 ?f17 ?f28 ?f0 ?f29 F L ?f17 ?f30 N W ?f9 ?f1 ?f8 ?f33 ?f18 ?f28 ?f19 ?f29 F L ?f18 ?f30 N M ?f0 ?f23 F L ?f0 ?f29 N M ?f19 ?f23 F L ?f19 ?f29 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="right"/><draw:equation draw:name="f4" draw:formula="bottom"/><draw:equation draw:name="f5" draw:formula="right/8"/><draw:equation draw:name="f6" draw:formula="right/2"/><draw:equation draw:name="f7" draw:formula="right*7/8"/><draw:equation draw:name="f8" draw:formula="right*3/2"/><draw:equation draw:name="f9" draw:formula="-?f6 "/><draw:equation draw:name="f10" draw:formula="$2 *30573/4096"/><draw:equation draw:name="f11" draw:formula="?f10 *2"/><draw:equation draw:name="f12" draw:formula="?f10 +bottom-$2 "/><draw:equation draw:name="f13" draw:formula="?f10 +$1 "/><draw:equation draw:name="f14" draw:formula="$1 /2"/><draw:equation draw:name="f15" draw:formula="?f10 +?f14 "/><draw:equation draw:name="f16" draw:formula="?f12 -$1 "/><draw:equation draw:name="f17" draw:formula="$0 +?f5 "/><draw:equation draw:name="f18" draw:formula="right-?f17 "/><draw:equation draw:name="f19" draw:formula="right-$0 "/><draw:equation draw:name="f20" draw:formula="?f6 -$0 "/><draw:equation draw:name="f21" draw:formula="?f10 *sqrt(1-(?f20 /right)*(?f20 /right))"/><draw:equation draw:name="f22" draw:formula="?f10 -?f21 "/><draw:equation draw:name="f23" draw:formula="?f22 +?f16 -?f10 "/><draw:equation draw:name="f24" draw:formula="$2 +?f16 -?f10 "/><draw:equation draw:name="f25" draw:formula="?f10 *2391/32768"/><draw:equation draw:name="f26" draw:formula="?f6 -?f17 "/><draw:equation draw:name="f27" draw:formula="?f10 *sqrt(1-(?f26 /right)*(?f26 /right))"/><draw:equation draw:name="f28" draw:formula="?f10 +$1 -?f27 "/><draw:equation draw:name="f29" draw:formula="?f22 +$1 "/><draw:equation draw:name="f30" draw:formula="?f12 -?f27 "/><draw:equation draw:name="f31" draw:formula="bottom-$2 "/><draw:equation draw:name="f32" draw:formula="?f10 +?f12 "/><draw:equation draw:name="f33" draw:formula="?f32 +?f10 -?f16 "/><draw:equation draw:name="f34" draw:formula="?f31 +?f10 -?f13 "/><draw:equation draw:name="f35" draw:formula="?f32 +?f10 -?f13 "/><draw:equation draw:name="f36" draw:formula="?f25 +?f12 -?f15 "/><draw:equation draw:name="f37" draw:formula="?f16 -?f15 "/><draw:equation draw:name="f38" draw:formula="?f37 *2/3"/><draw:equation draw:name="f39" draw:formula="?f1 +?f38 "/><draw:equation draw:name="f40" draw:formula="$2 +?f38 "/><draw:equation draw:name="f41" draw:formula="max(?f40 ,675)"/><draw:equation draw:name="f42" draw:formula="right*3/8"/><draw:equation draw:name="f43" draw:formula="?f42 -4"/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="?f5" draw:handle-range-x-maximum="?f43"/><draw:handle draw:handle-position="10800 $1" draw:handle-range-y-minimum="?f39" draw:handle-range-y-maximum="?f31"/><draw:handle draw:handle-position="left $2" draw:handle-range-y-minimum="?f41" draw:handle-range-y-maximum="?f24"/></draw:enhanced-geometry>
    oo_mso_spt108("mso-spt108", "H4sIAAAAAAAA/5WXy3KbMBSGX0XDeJG4ZdCNWyaOp1101Xqbme5oDTYzBhzAif321QVwQLIP3cgC6fvPsc4vAc/bOvl4Sst9Uv5Nt+4urYq0rS+oed89vefpx/fqvHIwwoiSAHetgxTUpufWTeo0aVbOOsNonVEqGhLLpp9zOaYrp2gqtzm2BEfd7aLa5lme1oL0uZAlAZXi4aA9JHRM2v3KeRWSUpZx0USy4yMVUF6rDlMzcDdMCJpmpHpTjX5M0kzr/RQ/obwMunscfetJ0pN0GBMK6g7u5gxTWD9EVUJh3zOF1BjDKnkd39fxf6PNEHusO6ip/xijHwrrhTboFcgmHmFRj/26rqYe6uT1SL9UHdVpbJyXZ12yt1PS5lWpC1gmhSh81tczq+ridEhWzgIjx7tHEIMgAEENggIEmxJ1vtu39xk+Zf5UbVsV9yHfGsiL7lOBnaL3qdBKLUMoWmTnGBQvnnLuOgug4pp+oGjJsB8yj+M4AGjDG8KGGC2BRIlhEIV90QV0QbcQwy6aB41JDM8IBFpWYnhGRxMth+IZxhEQRS6cqOGdhYroQ5zdO646igDUsI9GwfOBGhaStpvB3TBP81a3D8R9EIcZRp5K4nE5unoEhO32EotAwZPL4izxnJK1DqQAAf+U6bD/wu1eW1IWE4/RMACODmoxnI4MlZ8ajjOqEYyqEcythmHJYbPKioB5GbbUFQG3ELPYUu69GTGZ4cy5JxO7cbKp0ABqsR7T3lHeJdBRzgzrqfeaqwCDBCzmG2UACljcR/3u30sB6PhiNhMG81CLzVgodo7HANBiMLVqLAJCctuzcxZo+KtIzmJPcYy+BqEPbChueKx/PwAOB25xGBeF4QMmXvG3hxR96rvHqsmlknoCtdXRGY3WSblL3bNb5GVenAqp6N+YkZz7GZzNCyi+TsQ3yILYBC+fQw4lnE65xhRbelbMQ5q1aEHBkPxWVteQVK2rp+sx/Zx7+Qcaw0eo5w0AAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="?f4 ?f6 ?f5 ?f7" draw:type="flowchart-alternate-process" draw:enhanced-path="M 0 ?f2 Y ?f0 0 L ?f1 0 X 21600 ?f2 L 21600 ?f3 Y ?f1 21600 L ?f0 21600 X 0 ?f3 Z N"><draw:equation draw:name="f0" draw:formula="left+2540"/><draw:equation draw:name="f1" draw:formula="right-2540"/><draw:equation draw:name="f2" draw:formula="top+2540"/><draw:equation draw:name="f3" draw:formula="bottom-2540"/><draw:equation draw:name="f4" draw:formula="left+800"/><draw:equation draw:name="f5" draw:formula="right-800"/><draw:equation draw:name="f6" draw:formula="top+800"/><draw:equation draw:name="f7" draw:formula="bottom-800"/></draw:enhanced-geometry>
    oo_flowchart_alternate_process("flowchart-alternate-process", "H4sIAAAAAAAA/42SwW6DMBBEf8XytUIxBEgVhSD1THtOe3PJGpDApmYJyd/XYCeqEE1y8HqN52lmZXZHzYctyJLLHI5eAaoB1BfSnYrtqYLhTZ0TyggjgR8zVymZoKLuwWtVJbFLqM9e2ShjxHa2/oHsF4cinNHjGrghUxGSVMRmRWZtropLCwkVtRrykmsjrhG05Ggctcqh65zulrzlWCb03QRIRUA+TR3DZGb3zX5wIca77NavJ53vztnE2P5A7P0X+aD7nXX66TlWSlpfyZsx33UgoXTT1zyhNQh8CaKQ0dU9zp9zuipK9B6DwRxE1T7ht55j3wpRNU8YhosTjk95F4uWB3zIxUvzPaQ2/4znwNXyT77/Bal6NBX9AgAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 10800 10800 10800 21600" draw:text-areas="5400 5400 16200 16200" draw:type="flowchart-collate" draw:enhanced-path="M 0 0 L 21600 21600 0 21600 21600 0 0 0 Z N"/>
    oo_flowchart_collate("flowchart-collate", "H4sIAAAAAAAA/1WOzQrCMBCEX2XJPZgWLVKMh57VB/C2tGtSiE1J1/68vf2VysK3h5lh5lIE7FKqLFY5FdKQfxOHAZrWpG1JXeZ7LRQoiKNErRQwh4z7kKx9WXGjRaTOarItf899hKlniYFwTJyOozgjSuKNm2+oSYuX811uMbDMvXPItKq/tTWy1eIOU/Ftv/B/Lyz3hIc4XL+vX80O8QAAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 3163 3163 0 10800 3163 18437 10800 21600 18437 18437 21600 10800 18437 3163" draw:text-areas="3180 3180 18420 18420" draw:type="flowchart-connector" draw:enhanced-path="U 10800 10800 10800 10800 0 360 Z N"/>
    oo_flowchart_connector("flowchart-connector", "H4sIAAAAAAAA/2WPyw7CIBBFf4WwJw5iKmnEhR/gzo07Qse2SYWGYh9/bwvUjZuTcObO3HCpvJ5KtI22BitWo3tj8AsZxrocW5xublYUCJAjLyCTkrhUdx9kvWttGBTlIGGLCV6IBCDJxQeXJ3HOIl3KJjKbOE1mW8o1AefAtEe9tggut4Myxo6Ze27pUdFX5ybTaB+YcdaiCc7n+e+PvQ6Noo+9749rQwHkSe70cP0CQG8Q5R8BAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="5400 5400 16200 16200" draw:type="flowchart-decision" draw:enhanced-path="M 0 10800 L 10800 0 21600 10800 10800 21600 0 10800 Z N"/>
    oo_flowchart_decision("flowchart-decision", "H4sIAAAAAAAA/1WOwQ6CMBBEf2XTe2MhSgyxHjirH+CtaVdogi0plcLfi9ASvEx2d/Zl5qKcCCWaRhiJitZo3+jdBP1Ql4PGUNmREwYM8qxgUQksUN1+kHZWG99zkrEz+70xWKdVd9B6iajH0VPhUMzk6Tibi2RFnjT9TR1y8mptkI1wniqUutfWRHur3QnfcHLf0m+Q+uyy/zql7QkPcrh+AXpLQDcGAQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="0 3100 18500 18500" draw:type="flowchart-delay" draw:enhanced-path="M 10800 0 X 21600 10800 10800 21600 L 0 21600 0 0 Z N"/>
    oo_flowchart_delay("flowchart-delay", "H4sIAAAAAAAA/1VPTQvCMAz9K6H3YqcoY1gPO6tn8Ra2uA5mW9q6j38vdeuYBB4h773k5Vw7HArSCnVFNW/IvCm4CXzfFH1LQ2lGyQQI2GcnsSCDn6npPsStaXXwkmUiF1EmYO5m3JjmyWINNAaOjtDH5Ycs0vkxYRJNliR7dWaoFLrAa+pwWrg1sMWgJLtBuv/YXvtLcV2fiPWEO9tdvvZPYBX+AAAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="3600 0 17800 21600" draw:type="flowchart-display" draw:enhanced-path="M 3600 0 L 17800 0 X 21600 10800 17800 21600 L 3600 21600 0 10800 Z N"/>
    oo_flowchart_display("flowchart-display", "H4sIAAAAAAAA/12OzQ6CMBCEX2XTe+MiCRJiPXhWz8bbBlYgwbYplZ+3F6Eq8TLZ7M43O/vCUZ+xrkjnXMiSzYO9G6HtyqyruT+aQQkEhG2UYFABM1Q2T5bW1Nq3SkSY4tuGsEyLrqBlE1DPg5fkmCYyTmYw2qV/+X60rMS9MX1ekfOyqFvb0Biu38qWfKXEGULOKSQhXNeP1/mTJ/71+hhucBGbwwtlaa2SEAEAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 20320 21600 10800" draw:text-areas="0 0 21600 17360" draw:type="flowchart-document" draw:enhanced-path="M 0 0 L 21600 0 21600 17360 C 13050 17220 13340 20770 5620 21600 2860 21100 1850 20700 0 20120 Z N"/>
    oo_flowchart_document("flowchart-document", "H4sIAAAAAAAA/1VOyw6CMBD8lU3vxG0rjxDrQa/qB3hrYAUToATK6++lgEQvk9ndmdk5pY0eYqpyXSWUehmZkmwzQdtncf+m4WJGxRAQBA9wQwaLKSs68mrzrmyrGMcInQxhZSsKlOJrXTab1dJoPd2Qbn/DeSiDXTHVpNirMEOS68Z6qUm6kiq7nffCtba5Yvfl823L+cuDK3CJvpvE3IVLeXS9whDBD/ZyIgoc5c4V+YtgDUI+a57wYIfzB4VukWcrAQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 5400 10800 10800 21600 16200 10800" draw:text-areas="5400 10800 16200 21600" draw:type="flowchart-extract" draw:enhanced-path="M 10800 0 L 21600 21600 0 21600 10800 0 Z N"/>
    oo_flowchart_extract("flowchart-extract", "H4sIAAAAAAAA/02OwQ6CMBBEf6XpvbEQJYZYD57VD/C2gRVIkJKyUvh7K21JL7PZnXnZudQGbIlDC0OFtWhQf5DMyqa5KecO7U0viksmWZ4VMihnG9T0XxSj7gaaFM/kWf5jp6MbfvHquazI4yXQhAsJMAgOTqEtmL6hdUTF3722VQuGhOMMVBTcvfkI1Cr+YLHIPW2894/uiz354foDV2ldzf0AAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="12960 0 10800 0 2160 10800 8600 21600 10800 21600 19400 10800" draw:text-areas="4230 0 17370 21600" draw:type="flowchart-data" draw:enhanced-path="M 4230 0 L 21600 0 17370 21600 0 21600 4230 0 Z N"/>
    oo_flowchart_data("flowchart-data", "H4sIAAAAAAAA/1WPSQ6DMAxFrxJlHzUMYlLTRddtD9CdBS4g0QQFl+H2bZFBYmN5+P9Z/1x5mAq0DdgSK1WjeyP5RQxjXYwtTlc3G6mFFmGQaK5SrKa6+6DqXWtpMDII8+QvC3SmNzkP2W7kBfd5vG0YSDiTAo/w48VhtOLSKD1+paVHI1+dm8oGPKkKCPi0p+iBGiPvgiE3/njA7ZFY9BQPebp8AazY7E8PAQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="4230 4230 21600 21600" draw:type="flowchart-internal-storage" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 4230 0 L 4230 21600 N M 0 4230 L 21600 4230 N"/>
    oo_flowchart_internal_storage("flowchart-internal-storage", "H4sIAAAAAAAA/22OwQrCMBBEf2XJPRireCjGg2fbD/C2tGtaqElJl6b9e0mMRcHLwCyz8+bcegwl2Q5tQ6005J7EfoVpNuXcU7i6RQsFCor9SWUVkJ6YFpboCSctjsVBQZI/uXUkLR6DC02HnmVvmbzFQU7sPBrKsW3DiNxpUUGk3nLfT+/m7lBD9cbG6Bc/3vOgT0UytdhdXoiae5bzAAAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 6800 10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="0 6800 21600 18200" draw:type="flowchart-magnetic-disk" draw:enhanced-path="M 0 3400 Y 10800 0 21600 3400 L 21600 18200 Y 10800 21600 0 18200 Z N M 0 3400 Y 10800 6800 21600 3400 N"/>
    oo_flowchart_magnetic_disk("flowchart-magnetic-disk", "H4sIAAAAAAAA/2VPyw6CMBD8lab3xoKGEGI9eFbuemtgLY3QNm3l8fcCRSAxm0w2s7Mzu+fS8i4DVXFVQEkE6Aa8HZBrRdZK6K66Z5giiuIooQtiNC+J+gPEaKm8Yzii6ThOJgjtVKELuNsPzOLiofeEW+Buykk2aZTGm2gwwPCr1l1RcetJw4UCLwtSSvdeNOsPhvuK4fuYfzyNPo/1oOA7k7d9yCoJ3I99ohz9uewOnPkcHy5fPgyqi0QBAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 14800 10800 21600 10800" draw:text-areas="3400 0 14800 21600" draw:type="flowchart-direct-access-storage" draw:enhanced-path="M 18200 0 X 21600 10800 18200 21600 L 3400 21600 X 0 10800 3400 0 Z N M 18200 0 X 14800 10800 18200 21600 N"/>
    oo_flowchart_direct_access_storage("flowchart-direct-access-storage", "H4sIAAAAAAAA/2WPzQqDMBCEX2XJPTRaKSJNDz23nqW3ELdRsEaS1J+3r5oggV6WzbDzTeZaGzEV2Deil1hThfqDzixgR1WMLU53PXPCgEGaXFiYBHaT6r5IB932znKSsJxtZwz85qc3Jdmfsu0B43B2VBgUK+Wc7RBviLPcMiAn705PshHG0bo1KFeblGgttU4boTDcHmUG4RpOnpDk6Y6t4vSgeuUBe7J/VEeJ8J0XlBBT4j4xpSSn2w82mg+bUAEAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="3100 3100 18500 18500" draw:type="flowchart-sequential-access" draw:enhanced-path="M 20980 18150 L 20980 21600 10670 21600 C 4770 21540 0 16720 0 10800 0 4840 4840 0 10800 0 16740 0 21600 4840 21600 10800 21600 13520 20550 16160 18670 18170 Z N"/>
    oo_flowchart_sequential_access("flowchart-sequential-access", "H4sIAAAAAAAA/01QQXKDMAz8isZ3T2WwgWRCD+k16QN68xAFmKFAsBOS39cYu+Sys5J25ZUPl0nPe+ob3Vd04TUNv2SnF5hHvX+0NB+HZ8kQEBKRYUAG3lR3d+Lj0PbWlExggYsMYWUrvpnWTrBaelquJ9LOmQo39CAKFTHqXiOV7NoNc9XoyXJDtzv1ttUd11VFxgTdf/5R26ZkZ0hwVyyrhEI4hSrGyPLIv0DmvlDSJ8/yZLsAQRYywNZzGrl9hx++nRd5qtyiBJVaDK7lkiyvujwOf+CbfXz+AWOxDLZ5AQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 2150 0 10800 10800 19890 21600 10800" draw:text-areas="0 4300 21600 21600" draw:type="flowchart-manual-input" draw:enhanced-path="M 0 4300 L 21600 0 21600 21600 0 21600 0 4300 Z N"/>
    oo_flowchart_manual_input("flowchart-manual-input", "H4sIAAAAAAAA/22OSw7CMAxEr2JlH5HyU4sIC9bAAdhZrWkrtUmUur/bo4YAQmIzlu2ZZx8Lj+OBTIUmp0KWZFtiP0M3lIehpvFsJy0UKFgnexVVQAiVTU/S2dpwp0Wi0rDeLd5XEzVLs3c6TGKaaWKJnrBb+NuN+neCZ0daPBo75hV6li2aHhtZG9dztHxed8iVFleIsEvE/WDhW4PpDjexOj0BHUDmEwQBAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 2160 10800 10800 21600 19440 10800" draw:text-areas="4350 0 17250 21600" draw:type="flowchart-manual-operation" draw:enhanced-path="M 0 0 L 21600 0 17250 21600 4350 21600 0 0 Z N"/>
    oo_flowchart_manual_operation("flowchart-manual-operation", "H4sIAAAAAAAA/1WOzQ6CMBCEX2XTe2OL4F+sB8/qA3jbwAok0Dal/L29AsWEyyS7O9/MXjOH/YV0gTqljOdkavJuhKbLL11J/d0MigkQEMmDCMpghvKqJW5NqX2jmBQnsdpgGRZdOHmO47AJtKfBc3SEPzjeJxMrj1GyrfCjJcU+lenTAp3nNeoWK24sOfSl0cH2f9+iLxR7wpT2CNWbXJir1oOAN7zY7vYFOiJEvwUBAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 5400 10800 10800 21600 16200 10800" draw:text-areas="5400 0 16200 10800" draw:type="flowchart-merge" draw:enhanced-path="M 0 0 L 21600 0 10800 21600 0 0 Z N"/>
    oo_flowchart_merge("flowchart-merge", "H4sIAAAAAAAA/22OTQrCMBCFrxKyDyZFixTjwrV6AHehHZNC24R0bNrb2zRREGTgDfPzzZtT41WoYDBqqKFhGmwP6BcyTrqaWggXO0vKCSeFKHlWSjZIdy9gzrYDjpIKfuRx7bBfUyqSJk6UxaeTaYQZmfKgVniD/i4tDiR9djbURnlkPXgNefb92Sk0kt5IPHHNfr/uMR7kTnfnN8PnkHrvAAAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 19890 21600 10800" draw:text-areas="0 3600 18600 18009" draw:type="flowchart-multidocument" draw:enhanced-path="M 0 3600 L 1500 3600 1500 1800 3000 1800 3000 0 21600 0 21600 14409 20100 14409 20100 16209 18600 16209 18600 18009 C 11610 17893 11472 20839 4833 21528 2450 21113 1591 20781 0 20300 Z N M 1500 3600 F L 18600 3600 18600 16209 N M 3000 1800 F L 20100 1800 20100 14409 N"/>
    oo_flowchart_multidocument("flowchart-multidocument", "H4sIAAAAAAAA/12Qy26DMBBFf2XkPeqMzcOOQhet1FWTD+jOAjcg8RKYkPx9bWJS2s3ojn3nzrGP5aiXg+kq3RWmjC6mb40d7zBdL4drbZa3/pYzBAROKYbKYB26NLOJhr7u7JQzQonehvBQoSqpttH1JIxac7ORHo2efLhYr+WjIqrNdB9Mzr6bfikqPdqonRtbl30xt6azwfMEH7StcnaCkPYJlOCWnIRgEPhHbWRPwjhGBRzpv0650wFwrz0svANRSq7LpBJOxxl3c1IoiKUQLjrhEnic+C1EzpEocoZMkl+MjgS+4AynHfGH519X7L9m3eyNv8/wxsDo2z36mb28/gBn0Pcw3QEAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="0 0 21600 17150" draw:type="flowchart-off-page-connector" draw:enhanced-path="M 0 0 L 21600 0 21600 17150 10800 21600 0 17150 0 0 Z N"/>
    oo_flowchart_off_page_connector("flowchart-off-page-connector", "H4sIAAAAAAAA/1WOzQqDMBCEXyXkHpoU+oM0PXhu+wC9LXGNgs2GmPrz9kVNRVkYlmHmY25FgD5DV4EzWAiL9MEYRtZ2Nutq7HMaNJdMsqM6y6SczSXbfFF4ql1sNVfyKqeYZMu36Ka0OKkacYgCAkK7hauLOq2J0aPmZUO9qSBEQWUpPFgUhpxDEymk4DrdQ6w0f84bHom4I+82/b3p3uzFD/cf3EE3/woBAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 18000 10800" draw:text-areas="3600 0 18000 21600" draw:type="flowchart-stored-data" draw:enhanced-path="M 3600 21600 X 0 10800 3600 0 L 21600 0 X 18000 10800 21600 21600 Z N"/>
    oo_flowchart_stored_data("flowchart-stored-data", "H4sIAAAAAAAA/02PTQuDMAyG/0rovaxOkCHrDju7ncduwWYqOCs18+PfT22RXkJI3id9ejUOp5y6GruSjKzIfondAsNY5WND093OWihQcE4yFaqAHaraH8neNh0PWiTqoraYAt/56qFkbcMkoEwzS3SEK5lmO+hD8X1eetLi09qprNGxHNi6VdEgY0gc2j1yrcUD0sMRXodKeKAIi20VGcUfgzc8xen2B0aOHkMUAQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 3163 3163 0 10800 3163 18437 10800 21600 18437 18437 21600 10800 18437 3163" draw:text-areas="3100 3100 18500 18500" draw:type="flowchart-or" draw:enhanced-path="U 10800 10800 10800 10800 0 360 Z N M 0 10800 L 21600 10800 N M 10800 0 L 10800 21600 N"/>
    oo_flowchart_or("flowchart-or", "H4sIAAAAAAAA/2VPyw6CMBD8lab3xtYqEmI9eEZuXrw1sAIJUlIqj78X+iAhXibZmdmZ3Wuh5ZhAW8k2h4KUoD5g9Iz6oUyGGsa7mgSmiKIji6hHjOxS2XyBdKpuTS8wozFdbZxF3AFFjrMDi0/84gmX5BmLnrGqY9YlX2NgMkRqkEsLZzbQ2s4Bg2/uQOB3o8a8ktoQpb2wPddJUwn8DEV/uERHFL1Qhh7b9enuuFUJ3nT3ToYPtx/U+NvhTAEAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="2540 0 19060 21600" draw:type="flowchart-predefined-process" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 Z N M 2540 0 L 2540 21600 N M 19060 0 L 19060 21600 N"/>
    oo_flowchart_predefined_process("flowchart-predefined-process", "H4sIAAAAAAAA/12O3Q6CMAyFX6XZPXEQJZE4L7wGHsC7ZZSfRNnSLQzeXucWot40bc9pv3PpSPoK51HOCrtsQP1ERxvYZaiWCf1Nr4Jx4FDkJU+VwefI4eoySSitYMXpGEz5mZd/ps2gYP1DezVKcpkh7LCf5jfLkFZobTLuEYx0o2ANhH91wv7g9+kOLTSQ0HVsohL2MUsQvlJByw7XF6bYLpr0AAAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="4350 0 17250 21600" draw:type="flowchart-preparation" draw:enhanced-path="M 4350 0 L 17250 0 21600 10800 17250 21600 4350 21600 0 10800 4350 0 Z N"/>
    oo_flowchart_preperation("flowchart-preperation", "H4sIAAAAAAAA/1WOzQ6CMBCEX2XTe2NRUUOsB8/qA3jbwAok2DZl5eftVVoNXDaT3flm9lh47DMyFZqcClmSfRL7EdquzLqa+rMdtFCgYJ3sVJwCJqhsXiSdrQ23WiTqoL42BUGFOYPCJqJMA0v0hB9yu0knbL9Ol/k8OtLi0dg+r9CzdJ4ceuTamuj4v+2QKy2uELMuMW1RPW8IxiB/58je4SZWpzeIpiMyFwEAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:type="flowchart-process" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 0 0 Z N"/>
    oo_flowchart_process("flowchart-process", "H4sIAAAAAAAA/1WOzw7CIAyHX6Xpndh5MGYRD56dD+CNsApLJhDAzb29cRD/XH5t2n5feuijmlt2VjnNvTDs75zjAmky7TTwfPJPiQQE22ZHNRFWyIwPFsEPLieJDe3pfUZQupI/UJlUNC+BJd5GP2urYhYhes0p1e3nm6Cyldit2nPV/Eu/leAKF9wcXzaTYJPRAAAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="0 4300 21600 21600" draw:type="flowchart-card" draw:enhanced-path="M 4300 0 L 21600 0 21600 21600 0 21600 0 4300 4300 0 Z N"/>
    oo_flowchart_card("flowchart-card", "H4sIAAAAAAAA/22O3QrCMAyFXyX0vpipiAzrhdfqA3gX2rgN5jq6uJ+3l63FH/DmJCTnfMnBBRpybkpqLDtdsH+whAm6vsj7ioeTH41CQFhnO0yqYAkV9ZN166tGOqMy3ONsQ4hd1K9QnKSo8CiaAlM3w7cb/MeXqWWj7rUfbElBtKXg0ur9b0tSGnWJCIRzwvxe/tTFlrw3uKrV8QX3cs/SAAEAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 2020 0 10800 10800 19320 21600 10800" draw:text-areas="0 4360 21600 17240" draw:type="flowchart-punched-tape" draw:enhanced-path="M 0 2230 C 820 3990 3410 3980 5370 4360 7430 4030 10110 3890 10690 2270 11440 300 14200 160 16150 0 18670 170 20690 390 21600 2230 L 21600 19420 C 20640 17510 18320 17490 16140 17240 14710 17370 11310 17510 10770 19430 10150 21150 7380 21290 5290 21600 3220 21250 610 21130 0 19420 Z N"/>
    oo_flowchart_punched_tape("flowchart-punched-tape", "H4sIAAAAAAAA/z2QTW7DIBCFr4LYWwUG8xPVXbTbtgfoDjnUjpTalk3i5PadIYSFRxi+N+/NvB7XsB/iNIapj8dmiPNfTOudbdfhcD3F/X2+dVwwwZQ0olTOsmg4X2KzzKcpbR2XwtGzUMQ+fkr1oJ7qfFPUKd5SE9YYNuqvwVTIKl2h+xI7/nue934Ma2qWy9SPGDOFJRakRl9CGjv+RVEVCPbBHPqC91i0pJMTrAVbvKxGRgugUJKenaej8SRHSEqt8ZbyaEXV0CfbPJ4zRFialwTg63rI+fM5iEcl5kBIE95KktI2pNU+t9NlXDSx9GohW4OsvLA2d3oEbcmIqgVHR4VtWlXtQeVVKwSMzCjkvDnID/vmL2//hAOF7fABAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="5400 5400 16200 16200" draw:type="flowchart-sort" draw:enhanced-path="M 0 10800 L 10800 0 21600 10800 10800 21600 Z N M 0 10800 L 21600 10800 N"/>
    oo_flowchart_sort("flowchart-sort", "H4sIAAAAAAAA/02NTQrCMBCFrzJkH0yKFinGhWvtAdwN7dgI2pQkNO3tDU0i3XzDvB/epbcYGho1jh31fCDzJW9XcPPQzG8KN7MoJkBAJWuRyWAreVo8R0voFDsdo7lB1lVhya0TKfb6mNBptJ47Y322/rsTeq3YI+5IcY79e75lN32JSXlCC/v8Pteyw/UHGRlzwtkAAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 3163 3163 0 10800 3163 18437 10800 21600 18437 18437 21600 10800 18437 3163" draw:text-areas="3100 3100 18500 18500" draw:type="flowchart-summing-junction" draw:enhanced-path="U 10800 10800 10800 10800 0 360 Z N M 3100 3100 L 18500 18500 N M 3100 18500 L 18500 3100 N"/>
    oo_flowchart_summon_junction("flowchart-summon-junction", "H4sIAAAAAAAA/2WPzQ6CMBCEX2XTe2MrioSIB8/KzYu3BlbAQEug/L290BYx8TLJzszulz2njRhClLmQCaY0Q1WhbiZo+yzsCxyuaowIAwZ77jOnBMxSVnZIa1VI3UaEs4AtNY/7nhUG1jMDDw7eyRn2knOMOsek1lmWHEbjqKloUMwUj5uDpnZcde1NNUbkVaohyUWjadtVVSEz+u5kogslXe37ai10HpHHiv3TGeQzeEIMd9i4t1/yltlxDY0Vk93lAwBWNV5eAQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="1060 3180 20540 18420" draw:type="flowchart-terminator" draw:enhanced-path="M 3470 21600 X 0 10800 3470 0 L 18130 0 X 21600 10800 18130 21600 Z N"/>
    oo_flowchart_terminator("flowchart-terminator", "H4sIAAAAAAAA/02OyQ6CQBBEf6Uzd2KziIQ4HjyrZ+JtAi2QAEOGluXvZRkJl0ql8qq7rplRQ0xNoZqUMicnXRObCbo+j/uShrsepUBA8NwQrQpYS3n1JafVZcOdFC5GuGAIm9v0UNoSW2Ua2VGG1NoMEXw3mjk8BzMXBd7OTS1J8an0kBbKsMNk6rJRrI0F9uGt4kKKJ/jB5f8w2cesIcJjvu36i0uOm2y6JW94idPtBxnt/bIWAQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="0 0 21600 ?f11" draw:type="paper" draw:modifiers="18000" draw:enhanced-path="M 0 0 L 21600 0 21600 ?f0 ?f0 21600 0 21600 Z N M ?f0 21600 L ?f3 ?f0 C ?f8 ?f9 ?f10 ?f11 21600 ?f0 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="21600-?f0 "/><draw:equation draw:name="f2" draw:formula="?f1 *8000/10800"/><draw:equation draw:name="f3" draw:formula="21600-?f2 "/><draw:equation draw:name="f4" draw:formula="?f1 /2"/><draw:equation draw:name="f5" draw:formula="?f1 /4"/><draw:equation draw:name="f6" draw:formula="?f1 /7"/><draw:equation draw:name="f7" draw:formula="?f1 /16"/><draw:equation draw:name="f8" draw:formula="?f3 +?f5 "/><draw:equation draw:name="f9" draw:formula="?f0 +?f6 "/><draw:equation draw:name="f10" draw:formula="21600-?f4 "/><draw:equation draw:name="f11" draw:formula="?f0 +?f7 "/><draw:handle draw:handle-position="$0 bottom" draw:handle-range-x-minimum="10800" draw:handle-range-x-maximum="21600"/></draw:enhanced-geometry>
    oo_paper("paper", "H4sIAAAAAAAA/4WU0W6CMBSGX6VpdrWFUFARjWiy3eoeYHfdKNjEtqwUxbdfS2GiYLnoSTk53/n/HNpuUokva8KPmP+Q1MuJYETJKyjP+fpMyeVd1AlEAIEwiFAbIWig/FQRrxCUqzKBAYqRKUPA7mzsQTbToorUysOS4LLffJcFQVdwLUgCC1wQ2WaYSGlGiTRaulHX6d95gdUxgYfGwr5teGts1332C3yCQy+/1/tZ8/2hY6zXyliyvnqdNAe3G6v+W2FFBbdeOGbadNZZy4Rk1Qkn8AUB6LuI4JFoxDwj5gbDR1BbBa9mPL4dt5OePZMNJ2TnY7J+6IYWo9DcDUWj0NINLUehIHJT8ZCagbddtpgYxmrIIcNFUz99cE668c+nyMF5aSWXN1DfivREQG+vr2pJTa/mQH4LpQSDdwUS85x4tccop6xi7aV+UoNrW2NfBC3rj78k2z8WqgQ8YgQAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="?f3 ?f3 ?f4 ?f4" draw:type="hexagon" draw:modifiers="5400" draw:enhanced-path="M ?f0 0 L ?f1 0 21600 10800 ?f1 21600 ?f0 21600 0 10800 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="21600-$0 "/><draw:equation draw:name="f2" draw:formula="$0 *100/234"/><draw:equation draw:name="f3" draw:formula="?f2 +1700"/><draw:equation draw:name="f4" draw:formula="21600-?f3 "/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_hexagon("hexagon", "H4sIAAAAAAAA/4WSUW+DIBDHvwohe9pCBHVb09Q26XO3D7A3Mk8lEXCIrf32A1HTNs49AMfd/e5/gdvlhl+2oCquviEnJWgJ1lxRey63ZwGXo+4zTBFFMXuj447RAJV1B6TRQtk2w4xuqE+jKFhhv4GCZ0Qt9JZwA9yRhyJBYaV+TRnXBjJcQc9LrUaf1LkoBBgHvaZzrbn3htsqwx+uiG/j5E6G7sQHT7j7nGBNsS/0ife7UPGn41ZoFeorLl0nxSRXaCO7mmf4iSIcrRHskRgEyb9cvKD0zCiN4iRdJ5NH8lDE6IW9u7da5dLlTv2vzKB75LwGdGO7v2+FrzV0aHWD76KGqxJIT6RQQnbSTdEfcd6HeBgQpxctz+T+F4LSZr2sAgAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="0 0 21600 21600" draw:type="pentagon-right" draw:modifiers="10800" draw:enhanced-path="M 0 0 L ?f0 0 21600 10800 ?f0 21600 0 21600 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="21600"/></draw:enhanced-geometry>
    oo_pentagon_right("pentagon-right", "H4sIAAAAAAAA/3VQSw7CIBC9yoS4JUUXxjRWE9fqAdxN7JSSyEdKtb29tNRfohtgeL/JW5ce7zmZGs2ZSi7Jagq+h+Ym85ui+852BRMgYDFfiulkMIoCdYGjJ2z+MnpHBXNkAkpruFeyDhOkbakqRT5q52L1UrwWcRjqgh1gMN7DtnoHjPTxJ83P+wRHtlknl2uLQVmTPA3quEX1jKis1+0FCzYTwLJJEVPLC8HHmzvbqMFkJAbr2Bfq0UjiHdfKKN3q2MAfHLuEp15iXva78c0Do7arTooBAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="11000" draw:text-areas="?f0 ?f0 ?f3 ?f12" draw:type="horizontal-scroll" draw:modifiers="2700" draw:enhanced-path="M 0 ?f4 Y ?f1 ?f0 L ?f3 ?f0 ?f3 ?f1 Y ?f2 0 21600 ?f1 L 21600 ?f13 Y ?f2 ?f12 L ?f0 ?f12 ?f0 ?f11 Y ?f1 21600 0 ?f11 Z N M ?f1 ?f4 Y ?f9 ?f8 ?f0 ?f4 ?f1 ?f6 Z N M ?f2 ?f1 Y ?f3 ?f9 ?f3 ?f1 ?f2 0 X 21600 ?f1 ?f2 ?f0 Z N M ?f1 ?f6 X 0 ?f4 N M ?f2 ?f0 L ?f3 ?f0 N M ?f0 ?f4 L ?f0 ?f11 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="?f0 /2"/><draw:equation draw:name="f2" draw:formula="right-?f1 "/><draw:equation draw:name="f3" draw:formula="right-?f0 "/><draw:equation draw:name="f4" draw:formula="?f0 +?f1 "/><draw:equation draw:name="f5" draw:formula="right-?f4 "/><draw:equation draw:name="f6" draw:formula="?f0 *2"/><draw:equation draw:name="f7" draw:formula="?f1 /2"/><draw:equation draw:name="f8" draw:formula="?f0 +?f7 "/><draw:equation draw:name="f9" draw:formula="?f1 +?f7 "/><draw:equation draw:name="f10" draw:formula="bottom-?f9 "/><draw:equation draw:name="f11" draw:formula="bottom-?f1 "/><draw:equation draw:name="f12" draw:formula="bottom-?f0 "/><draw:equation draw:name="f13" draw:formula="bottom-?f4 "/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="5400"/></draw:enhanced-geometry>
    oo_horizontal_scroll("horizontal-scroll", "H4sIAAAAAAAA/41Uy27DIBD8FYR6aoUCtvNUnEo9Jzm3vdGYxEi2cTF59esLhpKHk9ADFmJndmaXNdNM0v2EVTmtVixDGyZKpuQRNLvNZMfZ/k0cUogBBhEZYPeFoCXVVOWoUZKpVV4LXimkoQSPHgCOGkCwByh2UIhKRpsUvq4xsCvWi0R/kGPNUpgLyX9EpWiBmpUUReGipcj4mjOp+dHQp/XVGAMpXACTNQEfJm+rMXcqXq2NRb5KczI/7WMXNrZaLrZbtyEus8W7o0+wBAsnaKXHeo0cJ3GRgcdF3kbssLHDGFvvZ8YsFl8oDDTC5j1lOy/TnlrE/OR7CWdT27HvLVVcVLZ/FS11z9d/7VwLWW4LmsInDGDvEYNcM4xSL3pMiq5Jkm9yhUxhj4nxPWLIZnLL5ktYsH9PMAkQB7cEnwN9GXZJJNjM0Z3ShgGH41ti/+CRzpB8CaVEicwMB6idafHU0EWQzsx4anBEO1PjqWe3qN+PrGDgbI9q0XCTrf0NlKjhRVTSasPQAZW84uW21E/mnTg92Hg/0c+Vluvdfn9nv7885dGYBQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="14623 106 106 8718 8590 21600 21600 13393" draw:text-areas="4680 6570 16140 13280" draw:type="mso-spt71" draw:enhanced-path="M 10901 5905 L 8458 2399 7417 6425 476 2399 4732 7722 106 8718 3828 11880 243 14689 5772 14041 4868 17719 7819 15730 8590 21600 10637 15038 13349 19840 14125 14561 18248 18195 16938 13044 21600 13393 17710 10579 21198 8242 16806 7417 18482 4560 14257 5429 14623 106 10901 5905 Z N"/>
    oo_mso_spt71("mso-spt71", "H4sIAAAAAAAA/1VQy27DMAz7FSH3YJYsW3LR7LDztg/YLViNtsDaBI3Xx99PSbMuO9gwaJIitd6c2ssqH3ft8TNv6m3uDrmcbjCct6vzPl9eumtTOXBAGN18VzCJtl/fue67/bEMTYUcyQO6OB0VVNCQ/skAvU9+Fpd8LXV7yq1pOaqDGMQYEXnkkf4OKbc+N9Vh6OqhL4Iz+sjbt2XXVG82NDkEGxjgFZSDAvmUQBgFIlMAlniHWDyBCNFfUK+kgKiWgthKWJ4EwTj2dIzAGu1fBM1Q7cIg3i3rmZMXg53XsSQbJelYhNFGI4eIgEpsv6Y3JKaJ6ZiXq5lmjG5BkuHmASayFLafeO+CykpghqM5BYHAlGC5/McePuC9enr+AUhSEALgAQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="9722 1887 0 12875 11614 18844 21600 6646" draw:text-areas="5400 6570 14160 15290" draw:type="bang" draw:enhanced-path="M 11464 4340 L 9722 1887 8548 6383 4503 3626 5373 7816 1174 8270 3934 11592 0 12875 3329 15372 1283 17824 4804 18239 4918 21600 7525 18125 8698 19712 9871 17371 11614 18844 12178 15937 14943 17371 14640 14348 18878 15632 16382 12311 18270 11292 16986 9404 21600 6646 16382 6533 18005 3172 14524 5778 14789 0 11464 4340 Z N"/>
    oo_bang("bang", "H4sIAAAAAAAA/02QyU4DQQxEf8Wae0R76W4bEQ6cgQ/gNpBWEgkmUTJk+XtsNFkufXBXuV75abHrj49tWPXDV1vMlm3z08bdGfaH5eNh3Y4vm9O8S5CAsKTp7eDftPz+bbPtZj2M+3lnlQhQtboUSWsGxIISI5HJXIqUyTu20zjrd613a5b4y9WN4jrATHbJGM/bNu8++2E5Da6k235czbs3j5EiICwJXuFGoVkUCiuD5MTAhQpkrgxVsbipCih5JBs7JGajKzgzmUNwpRgwYFXyBE3RhthADHWqVDN5U0V/tZgCWkUC04pu43jvroDkq3yzcfWqJnzReIMoz44c8KEp7OnOHwyMGMlxICSLuWkBk3R/2EldMvtaTcl7YDSQ7PC5xlKpatHydrEPeO8env8A19r+pwQCAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f7 ?f0 21600 ?f2" draw:type="left-arrow" draw:modifiers="10800 5400" draw:enhanced-path="M 21600 ?f0 L ?f1 ?f0 ?f1 0 0 10800 ?f1 21600 ?f1 ?f2 21600 ?f2 Z N"><draw:equation draw:name="f0" draw:formula="$1 "/><draw:equation draw:name="f1" draw:formula="$0 "/><draw:equation draw:name="f2" draw:formula="21600-$1 "/><draw:equation draw:name="f3" draw:formula="21600-?f1 "/><draw:equation draw:name="f4" draw:formula="?f3 *?f0 /10800"/><draw:equation draw:name="f5" draw:formula="?f1 +?f4 "/><draw:equation draw:name="f6" draw:formula="?f1 *?f0 /10800"/><draw:equation draw:name="f7" draw:formula="?f1 -?f6 "/><draw:handle draw:handle-position="$0 $1" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="21600" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/></draw:enhanced-geometry>
    oo_left_arrow("left-arrow", "H4sIAAAAAAAA/42T326DIBTGX4WQXm0hBWvt0tSa7HrbA+yOTLAkAg616tsP/Nu1TneD6Dm/7zsHjqfY0OrI1IWqLxajhGnJCtOA/Jocr4JVr7oOIQYYeCTA/QpBCxWsLhA1jOYhjPgBRHzIirg35DQZC2HKuMs0uuo/Sx0LLpixJMEvltj7o+xYS0aLSwjfR00M3uxK2p17uqo62r0NWS7uTXWAT/ABz6dO+bukhdCq81FU2tL4YMu1kWVKQ7ghAG6XCPJA4BXCuyfa8tCq026ec00ug/49GPEdeHIHt21PbJneP9IEPEfcX3EN5rh/ux7maNtrMLnawYhTBm72KNO5cFLtLWyGq+mDhqqEoRpJoYQspR3kP+K07uK34/0rp1nRaCaNsdXt/K91/gG0P1bKcwMAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f0 0 21600 21600" draw:type="left-arrow-callout" draw:modifiers="7565 5400 5400 8100" draw:enhanced-path="M ?f0 0 L 21600 0 21600 21600 ?f0 21600 ?f0 ?f5 ?f2 ?f5 ?f2 ?f4 0 10800 ?f2 ?f1 ?f2 ?f3 ?f0 ?f3 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="21600-?f1 "/><draw:equation draw:name="f5" draw:formula="21600-?f3 "/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="$2" draw:handle-range-x-maximum="21600"/><draw:handle draw:handle-position="$2 $3" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="$0" draw:handle-range-y-minimum="$1" draw:handle-range-y-maximum="10800"/><draw:handle draw:handle-position="left $1" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="$3"/></draw:enhanced-geometry>
    oo_left_arrow_callout("left-arrow_callout", "H4sIAAAAAAAA/42TXW+DIBSG/woh3pKKH13T1DbZ9bYfsDtS0ZIIOMSq/36AtrOzai/kI+d9znsOwiFVpNlTcSHiTFOUU8mpVh2orvn+ymjzLtsE+sAHAd76wwiBgzRtNSKKkiqBp2xG05U0gQXNrFLJBp1JUchaD2EuU5YxqkyGt3gbgzgyvBt2+J7jXlxJ9CWBn6A3+xjsHmxd7G91ymLzBaM5Mnrs71zc7vEwh4M+BN/gCx4PvfNPTTSToq9DEG56yW5lZVLxuiAJ9HwAN0sEnhB4hQgmRLBChBMiXCGi/4Q7NmSPZBmM58CRo/ljaUHBaI1KWTGbyx2YliV8iCoicopaxJlgvOa24xkBaXtBf81eMwyAF674+St23lNBNyoYzwhuGdy1e61g+2DAbMLFkkeGpmfjtnn+wo+/WB8qZPoDAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="21600 0 0 10800 21600 21600" draw:text-areas="13800 ?f9 21600 ?f10" draw:type="left-brace" draw:modifiers="1800 10800" draw:enhanced-path="M 21600 0 C 16200 0 10800 ?f0 10800 ?f1 L 10800 ?f2 C 10800 ?f3 5400 ?f4 0 ?f4 5400 ?f4 10800 ?f5 10800 ?f6 L 10800 ?f7 C 10800 ?f8 16200 21600 21600 21600 N"><draw:equation draw:name="f0" draw:formula="$0 /2"/><draw:equation draw:name="f1" draw:formula="$0 "/><draw:equation draw:name="f2" draw:formula="?f4 -$0 "/><draw:equation draw:name="f3" draw:formula="?f4 -?f0 "/><draw:equation draw:name="f4" draw:formula="$1 "/><draw:equation draw:name="f5" draw:formula="?f4 +?f0 "/><draw:equation draw:name="f6" draw:formula="?f4 +$0 "/><draw:equation draw:name="f7" draw:formula="21600-$0 "/><draw:equation draw:name="f8" draw:formula="21600-?f0 "/><draw:equation draw:name="f9" draw:formula="$0 *10000/31953"/><draw:equation draw:name="f10" draw:formula="21600-?f9 "/><draw:handle draw:handle-position="10800 $0" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="5400"/><draw:handle draw:handle-position="left $1" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="21600"/></draw:enhanced-geometry>
    oo_left_brace("left-brace", "H4sIAAAAAAAA/6VU226DMAz9lSjq0yZEAoWVqrTS9rrtH7JiaCQSOhp6+fslEChqszJpIFkGn+NjJ3FWWc1OS5A7JreQeQVUAlR9QYdjsTxyOL1W5xQTRFBAY2ItRi2pKBvw9hWX6pDiLmxeShbEBVdwVh6rgWk0DQ1mkycWt8npALvsIcUl5Mr7qtkW7G9RZTznUBuy4bYqNjZUv2dql+IP1BfzhmgckGtRm/zqUfQ++IFBWj9E0bx15qizw2ePiAYvHuV4GeVYWN3RIlj7iderrubvhileya4DyYRuOu8byqtaNCVL8YwgP8D+Iw51cB4zgluGac6bpIVOmlnSx7z5XYF0ghG5lJ6nlWInb7Kxl1tau1XTC7Jw86brTBxb9kSJfvyQJlE4seF3p6TXTa66eiCyEtDI15N64CaZHqD2mM76PDZeM1mAd/EEl1w0Qk/9L3F27uJmMP4maKYZzeg/9brLRAv67jtr/QNweANwzAQAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="21600 0 0 10800 21600 21600" draw:text-areas="6350 ?f3 21600 ?f4" draw:type="left-bracket" draw:modifiers="1800" draw:enhanced-path="M 21600 0 C 10800 0 0 ?f3 0 ?f1 L 0 ?f2 C 0 ?f4 10800 21600 21600 21600 N"><draw:equation draw:name="f0" draw:formula="$0 /2"/><draw:equation draw:name="f1" draw:formula="top+$0 "/><draw:equation draw:name="f2" draw:formula="bottom-$0 "/><draw:equation draw:name="f3" draw:formula="top+?f0 "/><draw:equation draw:name="f4" draw:formula="bottom-?f0 "/><draw:handle draw:handle-position="left $0" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/></draw:enhanced-geometry>
    oo_left_bracket("left-bracket", "H4sIAAAAAAAA/4WS4W6DIBSFX4WQ/luIqF3TNLUm299t70DrxZIKOMRW336g2GydbUNyNTn3u+cE7rYw7LIBdWTqAAUpQUuwpkfNudycBVzedJdhiihK4hUNFaMBKqsWSK2Fsk2GR9mfmK7pXLuFzhJmgLnuVfpKUc7T0Jbz5dTU15DhCrgle8MOJ7BBkLoQXIBxcLy+zrzmrpk9ZvgTTTHeQwx/vI+vMfoYvolTB8//UUP9wrvtOP+7ZVZoNbopJl04PplzbWRbsQwvKIoSHD1i4lvG6vrFcY+p5Jbaa2u1JE/BdM4u58+w5R2/P6S78aIC9OvfLUEj/LDx5dBiuqEgG6ZKID2RQgnZSrdPd3TWjfrwLt4wmt/O3Q+3KhjLtgIAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f5 ?f1 ?f6 ?f3" draw:type="left-right-arrow" draw:modifiers="10800 5400" draw:enhanced-path="M 0 10800 L ?f0 0 ?f0 ?f1 ?f2 ?f1 ?f2 0 21600 10800 ?f2 21600 ?f2 ?f3 ?f0 ?f3 ?f0 21600 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="21600-$0 "/><draw:equation draw:name="f3" draw:formula="21600-$1 "/><draw:equation draw:name="f4" draw:formula="10800-$1 "/><draw:equation draw:name="f5" draw:formula="$0 *?f4 /10800"/><draw:equation draw:name="f6" draw:formula="21600-?f5 "/><draw:equation draw:name="f7" draw:formula="10800-$0 "/><draw:equation draw:name="f8" draw:formula="$1 *?f7 /10800"/><draw:equation draw:name="f9" draw:formula="21600-?f8 "/><draw:handle draw:handle-position="$0 $1" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/></draw:enhanced-geometry>
    oo_left_right_arrow("left-right-arrow", "H4sIAAAAAAAA/41Ty26EIBT9FUJm1YT4duxkHJOu235Ad6SCkghY1FH/vihqG6tjF4B6zyvXyzVVuL0QkWPxSVKUEclJrXpQ3bPLnZH2RXYxtIENXCe0px2CkVSTrkZYEVzFMKEBSKijV6iXNyP6ksSwILRGimX5gFaynYpcpowyojTbsSOtHfiL9JKnxHUewzftbzCvWn1IM+zGz13OOaNBDl/Mu8F4E8ecpvIB3uHtahy/GlwzKYy/wFwHp3McKhVvChzDkw2g9Yjh/GE4Bwx3zRijoUMnb4d35OeveWO7jnnBRi+eEuoDaxR4TA63ww5T85h43kl71J1o4z/otOd/pX3eSxv9uOr5TAsCfj2jUlZs0Bpbc5onYSoqLDKCOsSZYLzh+k7t1HFn6ibnBqY/0OjXGjqytX3Lb9+yj334/gMAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f0 0 ?f4 21600" draw:type="left-right-arrow-callout" draw:modifiers="5603 5500 5400 8100" draw:enhanced-path="M ?f0 0 L ?f4 0 ?f4 ?f3 ?f6 ?f3 ?f6 ?f1 21600 10800 ?f6 ?f5 ?f6 ?f7 ?f4 ?f7 ?f4 21600 ?f0 21600 ?f0 ?f7 ?f2 ?f7 ?f2 ?f5 0 10800 ?f2 ?f1 ?f2 ?f3 ?f0 ?f3 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="21600-?f0 "/><draw:equation draw:name="f5" draw:formula="21600-?f1 "/><draw:equation draw:name="f6" draw:formula="21600-?f2 "/><draw:equation draw:name="f7" draw:formula="21600-?f3 "/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="$2" draw:handle-range-x-maximum="10800"/><draw:handle draw:handle-position="$2 $3" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="$0" draw:handle-range-y-minimum="$1" draw:handle-range-y-maximum="10800"/><draw:handle draw:handle-position="left $1" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="$3"/></draw:enhanced-geometry>
    oo_left_right_arrow_callout("left-right-arrow-callout", "H4sIAAAAAAAA/51U3W7CIBR+FUK8JUIr1SxWk11ve4DdEQuVpJQOqda3Hy1M67Sy7KIcUr6/c/qzLgw7vfB6z+odL1DJteLWnMHhWL4cJT+96i6HGGCQkAyHFYKBZHlnETOcHXK4FT1mKxa3iHPDc1hxYZGR5b5HG31CO1ZVurUBpHQhheTGqdAMp4BS50MXblmRi9IlYMPsPofvwBu+DZbeeCtSd2WjSkJoglcYh3s01GXgLK+hB83rzp8lo0rBVSsZ9H1NAz4Fn+ADbtY+8VfLrNS1z18z5SYhftoR2qi2YjmcYQDnzxjkjkEijOSOkUQY6R0jjTAWvxnD2FA/hudEOkWMdZVNEWPNLaeIox7du1VUHIz2qNEH2WsNj8jqBt6cGlaXHHVIyVqqVvUzngCwzgOG9+aPhgmYpRE/HLGbPQScR4HJBOAfgfsPHEwKPo08MnQ9O7f54//R5hs/tdGlqAQAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="8458 0 0 3923 4993 9720 9987 14934 21600 21600 16558 12016 12831 6120" draw:text-areas="8680 7410 13970 14190" draw:type="lightning" draw:enhanced-path="M 8458 0 L 0 3923 7564 8416 4993 9720 12197 13904 9987 14934 21600 21600 14768 12911 16558 12016 11030 6840 12831 6120 8458 0 Z N"/>
    oo_lightning("lightning", "H4sIAAAAAAAA/3WPvW7DMAyEX4XQboSUaEkM6g6Z2z5AN6ERZAOpbDhqft6+cuGk6dDlABLHu49P+zmctzH3IX/EfZPi+BnLfIXjKW1PQzzvxkunEBA0WVxVwc9ROnzFZhqHXI6d8tx6WHxGtAEWMSBOI4h4B8Ri+DEByLbVTxrJVvWGwNZhDS7xUpowx7DkWo/gmOqJEVeVSe6+6xQ7dRhSX/KQ07q9/zKF0nfqFVa0lxucay3XZW3+xSRN4pYK5H+R2dkFWYj+4hMaBOsZHz65lb7Dm9o8fwPxza3JZQEAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="21600 0 0 10800 21600 21600 ?f0 10800" draw:text-areas="?f9 ?f8 ?f0 ?f10" draw:type="moon" draw:modifiers="10800" draw:enhanced-path="M 21600 0 C ?f3 ?f4 ?f0 5080 ?f0 10800 ?f0 16520 ?f3 ?f5 21600 21600 9740 21600 0 16730 0 10800 0 4870 9740 0 21600 0 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="21600-$0 "/><draw:equation draw:name="f2" draw:formula="?f1 /2"/><draw:equation draw:name="f3" draw:formula="?f2 +$0 "/><draw:equation draw:name="f4" draw:formula="$0 *1794/10000"/><draw:equation draw:name="f5" draw:formula="21600-?f4 "/><draw:equation draw:name="f6" draw:formula="$0 *400/18900"/><draw:equation draw:name="f7" draw:formula="(cos(?f6 *(pi/180))*(0-10800)+sin(?f6 *(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f8" draw:formula="-(sin(?f6 *(pi/180))*(0-10800)-cos(?f6 *(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f9" draw:formula="?f7 +?f7 "/><draw:equation draw:name="f10" draw:formula="21600-?f8 "/><draw:handle draw:handle-position="$0 10800" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="18900"/></draw:enhanced-geometry>
    oo_moon("moon", "H4sIAAAAAAAA/5VU2W6DMBD8FQv1AYIsDOGMQpDa5/YD+mYFQywFm3Ik5O9r7gQoqCAsy7MzO8vaPoYZvh8Iu2B2JiGMCU9IkT1AfosPN0ru77zyJQQQMHQbdaMEGlJ8LQlMOWVF7kstXL86ctFLOAiibrUjFqQqIM4IFrwg8gTuNjFBpA8hj5T4UsI56xYSHtKIkkxQnqUG4ykuLr70CXofH0JtLz6zUbYEZbTRzmzLQF2Q9WLXc0w06Oi2sx+rQsB0nS5ijPkGX9Lp2Pr5KXFBOWvdMZyIKqLebMSzpLxiX3pDQNLWGPqU0aSCmzxjyhO/FGjGOmk/JxlA3cxlLlS10x3P1HQknnWytVxg3a91or2U1URI011vK6kz5cpnnstBZIOdnFKhgBRlJyPY9FpRc8pmYAN1AYra7sTVnO40J5SXdHtNuOTo30m9eUcdoNbDxrab7dS+Le7IFAcuvBLwNBeXQE5rsaYbz8ezwzPMYgIrmFBGkzIRF8ofOK5afGimtnw9nX4B5k9VPbcEAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f5 ?f1 ?f6 ?f2" draw:type="notched-right-arrow" draw:modifiers="10800 5400" draw:enhanced-path="M 0 ?f1 L ?f0 ?f1 ?f0 0 21600 10800 ?f0 21600 ?f0 ?f2 0 ?f2 ?f5 10800 0 ?f1 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="21600-$1 "/><draw:equation draw:name="f3" draw:formula="21600-$0 "/><draw:equation draw:name="f4" draw:formula="10800-$1 "/><draw:equation draw:name="f5" draw:formula="?f3 *?f4 /10800"/><draw:equation draw:name="f6" draw:formula="21600-?f5 "/><draw:handle draw:handle-position="$0 $1" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="21600" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/></draw:enhanced-geometry>
    oo_notched_right_arrow("notched-right-arrow", "H4sIAAAAAAAA/4WT0W6DIBSGX4WQXi0holWzNLUmu972ALsjFZSkgEWs+vYDUdt1bb3gRD3n+8/vAfaFJt2OyorIIy1QSZWgRg+guZS7C6fdh+oziAEGUZjiKUIwQob2BhFNSZPBnCUgZ6FdqV3RXDHUNINSmWNltTUvKwdo1U15oQrOONVWIMTvVj6JF/XFUk1MlcEva8E1+LQRT62utjztvvh3XxMBH505X+HJH/AND3vf5dwSw5X0PSUR1i+bLTClRXsiGdxgAINXRPiPCFeI6J4YjaNVbvuEW3MY33PjQNb7JfdczrbgLWcxCEaF13T62K3bkAW021ycKLh5RrVquNMaJ7+ZhzslNZElRT0SXHLRCns6n+RJ7/O3Z/ZPzbCiMVw1ln8NHt+Xwy8AXofjSAMAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f5 ?f6 ?f7 ?f8" draw:type="octagon" draw:modifiers="6326" draw:enhanced-path="M ?f0 0 L ?f2 0 21600 ?f1 21600 ?f3 ?f2 21600 ?f0 21600 0 ?f3 0 ?f1 Z N"><draw:equation draw:name="f0" draw:formula="left+$0 "/><draw:equation draw:name="f1" draw:formula="top+$0 "/><draw:equation draw:name="f2" draw:formula="right-$0 "/><draw:equation draw:name="f3" draw:formula="bottom-$0 "/><draw:equation draw:name="f4" draw:formula="$0 /2"/><draw:equation draw:name="f5" draw:formula="left+?f4 "/><draw:equation draw:name="f6" draw:formula="top+?f4 "/><draw:equation draw:name="f7" draw:formula="right-?f4 "/><draw:equation draw:name="f8" draw:formula="bottom-?f4 "/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_octagon("octagon", "H4sIAAAAAAAA/4WTUW+DIBDHvwohe1tIUVvbNLUme972AfbG6qEkAg6xtd9+KNq0xtYH8OD+vzvu4h0ywy57UAVTJ8hIDlqCNVdUn/P9WcDlQ7cJpoiiMIjpsGPUQ3nZAKm0ULZOcEB3tJNR5C2/30H+ZkArZgtSWwP2VPQRSDuEeCq4PgostJYwA8zlTvkGpTx2a+vWblRcK0iwPlmWazXcSZ0JLsA4KI7CeLi9Vd9lTfCXC9IV8um+4a3ylAc3K+o942lUeI9X/qBvfDz46H8Ns0Irn0sx6V7FxzK4NrIpWYJL4Pb9jSK8eoUFU8zqapkKp5QReWHJIhdNuV9trZbL4HoKOmIVvmY2sx1J+XohVzzXkmVsO9+TZXD3pCkPpPufshLQne0GpRZdsL4Z7o34wWuYyoG0RAolZCPdyD3xs9b7/Sy4fKv5AT7+A1w8XjLZAwAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="?f6 0 10800 ?f8 ?f11 10800 ?f9 21600 10800 ?f10 ?f5 10800" draw:text-areas="?f3 ?f3 ?f4 ?f4" draw:type="parallelogram" draw:modifiers="5400" draw:enhanced-path="M ?f0 0 L 21600 0 ?f1 21600 0 21600 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="21600-$0 "/><draw:equation draw:name="f2" draw:formula="$0 *10/24"/><draw:equation draw:name="f3" draw:formula="?f2 +1750"/><draw:equation draw:name="f4" draw:formula="21600-?f3 "/><draw:equation draw:name="f5" draw:formula="?f0 /2"/><draw:equation draw:name="f6" draw:formula="10800+?f5 "/><draw:equation draw:name="f7" draw:formula="?f0 -10800"/><draw:equation draw:name="f8" draw:formula="if(?f7 ,?f13 ,0)"/><draw:equation draw:name="f9" draw:formula="10800-?f5 "/><draw:equation draw:name="f10" draw:formula="if(?f7 ,?f12 ,21600)"/><draw:equation draw:name="f11" draw:formula="21600-?f5 "/><draw:equation draw:name="f12" draw:formula="21600*10800/?f0 "/><draw:equation draw:name="f13" draw:formula="21600-?f12 "/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="21600"/></draw:enhanced-geometry>
    oo_parallelogram("parallelogram", "H4sIAAAAAAAA/42UXW+DIBSG/wohu9i6EsFqv1JrsuttP2B3ZIIlEXFWW/vvh/iRTi3uAoQcnvMe9PUcopxe9yw90fSbRShmSrIiv4HzJd5fBLu+qSqAGGDgkjVuZwgMFCclQ5kSaXEOYMjX+hDBW30o5Fs9COm3u5bu9qSe/GbbJitYVSCaM2pyrUAzvHp0J24ZC2BGc5okLFFxTmUbkSoSXLBco77XZ+zvlNHiFMAPnaq+x3tbi6mjXzfPL/AJj4eG/ilpIVTa5Eqp1Nq8S81VLsuEBvAJA+jYCDIkjBCa5dwJpQXBjuvZudWQC7kLXsnGx3bOm66z/gp20B8LYuC4dmg9hIwTXmtP2MHNlBpqfGQFt0NQ8OeQb8BSm2AFlvjFju8mC0bzBZORZe6EXbA0r3lGnDww0T/URzYy5MJU79TvboYf2alT1rX3qP7NooSBu7XuCmdRZzO+LVQG/0RzmsYMVUiKVMhS6v7yIE6rJt50Ha3nTHer4y+RtpKCxgQAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 8260 4230 21600 10800 21600 17370 21600 21600 8260" draw:text-areas="4230 5080 17370 21600" draw:type="pentagon" draw:enhanced-path="M 10800 0 L 0 8260 4230 21600 17370 21600 21600 8260 10800 0 Z N"/>
    oo_pentagon("pentagon", "H4sIAAAAAAAA/22PzQ6CMBCEX2XTe+MCCoRYDp7VB/DWyKaQaNtA5eftRWyJJlw2m535JrPHqpVDQbqW+k4VV2Se5NoJul4VfUPDyYyCISDEUYp+Mlgg9XgRt6bRrhMswhw/NoQ8ThH2cRKQr+L3LMn+oha3z3M0Oi5bknPcwh9m8hcJvsmSYJa0k8pof1w/sNLVgl0gFDpvVdqssSI3uLJd+QYJN7RbGgEAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f12 ?f13 ?f14 ?f15" draw:type="mso-spt21" draw:modifiers="3600" draw:enhanced-path="M ?f0 0 Y 0 ?f1 L 0 ?f2 X ?f0 21600 L ?f3 21600 Y 21600 ?f2 L 21600 ?f1 X ?f3 0 Z N"><draw:equation draw:name="f0" draw:formula="left+$0 "/><draw:equation draw:name="f1" draw:formula="top+$0 "/><draw:equation draw:name="f2" draw:formula="bottom-$0 "/><draw:equation draw:name="f3" draw:formula="right-$0 "/><draw:equation draw:name="f4" draw:formula="-(sin(45*(pi/180))*($0 -10800)-cos(45*(pi/180))*(0-10800))+10800"/><draw:equation draw:name="f5" draw:formula="?f4 -10800"/><draw:equation draw:name="f6" draw:formula="-$0 "/><draw:equation draw:name="f7" draw:formula="?f6 -?f5 "/><draw:equation draw:name="f8" draw:formula="left-?f7 "/><draw:equation draw:name="f9" draw:formula="top-?f7 "/><draw:equation draw:name="f10" draw:formula="right+?f7 "/><draw:equation draw:name="f11" draw:formula="bottom+?f7 "/><draw:equation draw:name="f12" draw:formula="left-?f5 "/><draw:equation draw:name="f13" draw:formula="top-?f5 "/><draw:equation draw:name="f14" draw:formula="right+?f5 "/><draw:equation draw:name="f15" draw:formula="bottom+?f5 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_mso_spt21("mso-spt21", "H4sIAAAAAAAA/42UwW7iMBCGX8Wy9gBFFnYClK2aIu2Z9tzuzSVOsITjrO2U8PY7iQOFhGIOcUae+WY89q95Tg3fP4liy4uNSEkutBLOHJD9yp++pNj/0XWCKaIoYgvarRi1UL6rBCm1LJxNMKNL2oRR5C2/nkF+p0NL7rbEOiPcZttmIHWX4seAw2WAE7Uj3AgOtVcZixAscbPMmmV+jDqUIsHKamJLF7FuV+lUZlIYQOPvdk530NRO8Cvkadr5gA8yonX7j9B7u+9bWoMdd/ZH929i1iebtfExsH/RG3559pX+VdxJXfi6BVdwxux4jEwbVe14gncic5NfFOHpLYz1MafLMBX1qU/tnFYkCMZ90Mh868LcrM+RkZXFaDZ/GJVyypZ0PH4YQRbSvvGYbLTtOWnnGk+8DG6Wm/fLrbJZl/s2uBicM9ja47DWApFVNg9wy2sPDtxjgPt95cXvwNhAYO3TTe4gBxrzarkHHQitazJ0OWwgNN9lkBsI7dhlkBxo5tTlGQojIt0JdGbDBLSyyZZgkAqcEl947V7CCBMpNGAqcekzvMgFqYmShVSVgjn7g5/X3n8S8PT61H75D7r4HUTOBQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f1 ?f1 ?f2 ?f3" draw:type="cross" draw:modifiers="5400" draw:enhanced-path="M ?f1 0 L ?f2 0 ?f2 ?f1 21600 ?f1 21600 ?f3 ?f2 ?f3 ?f2 21600 ?f1 21600 ?f1 ?f3 0 ?f3 0 ?f1 ?f1 ?f1 ?f1 0 Z N"><draw:equation draw:name="f0" draw:formula="$0 *10799/10800"/><draw:equation draw:name="f1" draw:formula="?f0 "/><draw:equation draw:name="f2" draw:formula="right-?f0 "/><draw:equation draw:name="f3" draw:formula="bottom-?f0 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_cross("cross", "H4sIAAAAAAAA/4VS227CMAz9lSja06QIp90NREHa87YP2FtG3TYSSbokhfL3C0mpKBvswa6V43N8qZelFfsF6kboDZasRqPQ2wNxu3qxk7h/NX1BgQDJ+BMMnpJIqrcdstZI7V1BObzAMQ1IipI/I6WXgdoK3zDnLfpNExVYP0hcTThMEzz2ngmLItReV5wky4Llp4xDiwXdWOPc8KJMKSuJNlAeH0alcfZjzYK+Rykgb1EOBlE+DHEe5aeC8fsb5xGD0fOJAfkkH3S1TD18d8JLo1NHWqjQeXVqsDJWdVtR0Dsg9xye5/NZ2sTsFptfstcVkNuU7JJiZd149j8xvyR+Ge+NmjLDlsstkrM4HI+TR7E4mjctnaBuL8Pfx7Kg3nY4xazQNbKeKaml6lQ40Su46BM+bmz298GvfgBBi60ICQMAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:type="rectangle" draw:enhanced-path="M 0 0 L 21600 0 21600 21600 0 21600 0 0 Z N"/>
    oo_rectangle("rectangle", "H4sIAAAAAAAA/7NJKUost0rNy0jMS05N0U1Pzc9NLSmqVCguS7cqy0wtd8qvsFUyUDBQMDI0M4CSSgpgTSWVBam2SkWpySWJeek5qVBRuFEFiSUZtkq+CiDNPlDtKMYoIGgDhSgFPyV9OwCBA2vKjgAAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="?f17 ?f10 2700 ?f14 ?f17 21600 ?f18 ?f14" draw:text-areas="?f0 ?f10 ?f9 21600" draw:type="mso-spt53" draw:modifiers="5400 3600" draw:enhanced-path="M 0 0 L ?f3 0 X ?f4 ?f11 L ?f4 ?f10 ?f5 ?f10 ?f5 ?f11 Y ?f6 0 L 21600 0 ?f18 ?f14 21600 ?f15 ?f9 ?f15 ?f9 ?f16 Y ?f8 21600 L ?f1 21600 X ?f0 ?f16 L ?f0 ?f15 0 ?f15 2700 ?f14 Z N M ?f4 ?f11 F Y ?f3 ?f12 L ?f1 ?f12 X ?f0 ?f13 ?f1 ?f10 L ?f4 ?f10 N M ?f5 ?f11 F Y ?f6 ?f12 L ?f8 ?f12 X ?f9 ?f13 ?f8 ?f10 L ?f5 ?f10 N M ?f0 ?f13 F L ?f0 ?f15 N M ?f9 ?f13 F L ?f9 ?f15 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="?f0 +675"/><draw:equation draw:name="f2" draw:formula="?f1 +675"/><draw:equation draw:name="f3" draw:formula="?f2 +675"/><draw:equation draw:name="f4" draw:formula="?f3 +675"/><draw:equation draw:name="f5" draw:formula="21600-?f4 "/><draw:equation draw:name="f6" draw:formula="21600-?f3 "/><draw:equation draw:name="f7" draw:formula="21600-?f2 "/><draw:equation draw:name="f8" draw:formula="21600-?f1 "/><draw:equation draw:name="f9" draw:formula="21600-?f0 "/><draw:equation draw:name="f10" draw:formula="$1 "/><draw:equation draw:name="f11" draw:formula="?f10 /4"/><draw:equation draw:name="f12" draw:formula="?f11 *2"/><draw:equation draw:name="f13" draw:formula="?f11 *3"/><draw:equation draw:name="f14" draw:formula="10800-?f12 "/><draw:equation draw:name="f15" draw:formula="21600-?f10 "/><draw:equation draw:name="f16" draw:formula="21600-?f11 "/><draw:equation draw:name="f17" draw:formula="21600/2"/><draw:equation draw:name="f18" draw:formula="21600-2700"/><draw:equation draw:name="f19" draw:formula="?f17 -2700"/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="2700" draw:handle-range-x-maximum="8100"/><draw:handle draw:handle-position="10800 $1" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="7200"/></draw:enhanced-geometry>
    oo_mso_spt53("mso-spt53", "H4sIAAAAAAAA/42VTXODIBCG/wrD9NSOExFRk4nJTA89tT23vTENJs7Ejyppk39fvgwmashFVuB5d9ndgeWmoX8LVu5o+c023pZVBePNCbS/28Vvzv6eq2MKfeCDAEW++UKgoO3+wLy6ykvepnCdoRiIj9gSi33CCoGa05wwEzVpWM6O3KMNowr1NbnO5hcO+KlmKSzaymtrTrCZLapNnuWsESQJhTS2wPkYNeW7FL4BGfir0MVi/BCjigmpqbDzSS4MBD7FEClOh94L3h6GqGD7RqTAxGyRHpCxpWNfb3ntTALMYLP1Bd7Bm43xRelh+RMYOWWe1XA35/fPozVIXyOyGonVmHcaidUgfQ3j5KUftF6Z91dMFt7haqlr8HOgPK9KXZGSFqKEWVegrGqKw56m8MEHcHaLQNeEjOEpisltLBhi6A4MD7HgDiwcYvgOjFxjqk88WcPbYDQFYgcYT4GBA0ymQOQA51Ogs/DDXnH5QiPNItp4FjqwsWZB4DFwYCPNIjHswAbNgvxEp9JVBDTZMMiZzcmWQc6sjjfNzJWeiZaRF52DHPSMekAuSXHBb/YM9GzxBLW5FFO3Cq9qeLHa0HLLvKNX5GVeHAoRTnx+L6630KPekqB7Paoaggc0JniyPkcdnqzDONAOZ+Ov8eofkWdrx6YHAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f0 0 ?f19 ?f1" draw:type="mso-spt54" draw:modifiers="5400 18000" draw:enhanced-path="M ?f12 ?f1 L ?f12 ?f13 C ?f12 ?f14 ?f15 21600 ?f16 21600 L 0 21600 2750 ?f7 0 ?f2 ?f0 ?f2 ?f0 ?f4 C ?f0 ?f5 ?f10 0 ?f11 0 L ?f17 0 C ?f18 0 ?f19 ?f5 ?f19 ?f4 L ?f19 ?f2 21600 ?f2 18850 ?f7 21600 21600 ?f20 21600 C ?f21 21600 ?f22 ?f14 ?f22 ?f13 L ?f22 ?f1 Z N M ?f12 ?f1 L ?f12 ?f13 C ?f12 ?f23 ?f15 ?f24 ?f16 ?f24 L ?f11 ?f24 C ?f10 ?f24 ?f0 ?f26 ?f0 ?f25 ?f0 ?f27 ?f10 ?f1 ?f11 ?f1 Z N M ?f22 ?f1 L ?f22 ?f13 C ?f22 ?f23 ?f21 ?f24 ?f20 ?f24 L ?f17 ?f24 C ?f18 ?f24 ?f19 ?f26 ?f19 ?f25 ?f19 ?f27 ?f18 ?f1 ?f17 ?f1 Z N M ?f0 ?f25 L ?f0 ?f2 N M ?f19 ?f25 L ?f19 ?f2 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="21600-?f1 "/><draw:equation draw:name="f3" draw:formula="?f2 /2"/><draw:equation draw:name="f4" draw:formula="?f3 /2"/><draw:equation draw:name="f5" draw:formula="?f4 /2"/><draw:equation draw:name="f6" draw:formula="?f1 /2"/><draw:equation draw:name="f7" draw:formula="21600-?f6 "/><draw:equation draw:name="f8" draw:formula="420"/><draw:equation draw:name="f9" draw:formula="?f8 *2"/><draw:equation draw:name="f10" draw:formula="?f0 +?f8 "/><draw:equation draw:name="f11" draw:formula="?f0 +?f9 "/><draw:equation draw:name="f12" draw:formula="?f0 +2700"/><draw:equation draw:name="f13" draw:formula="21600-?f4 "/><draw:equation draw:name="f14" draw:formula="21600-?f5 "/><draw:equation draw:name="f15" draw:formula="?f12 -?f8 "/><draw:equation draw:name="f16" draw:formula="?f12 -?f9 "/><draw:equation draw:name="f17" draw:formula="21600-?f11 "/><draw:equation draw:name="f18" draw:formula="21600-?f10 "/><draw:equation draw:name="f19" draw:formula="21600-?f0 "/><draw:equation draw:name="f20" draw:formula="21600-?f16 "/><draw:equation draw:name="f21" draw:formula="21600-?f15 "/><draw:equation draw:name="f22" draw:formula="21600-?f12 "/><draw:equation draw:name="f23" draw:formula="?f13 -?f5 "/><draw:equation draw:name="f24" draw:formula="?f1 +?f3 "/><draw:equation draw:name="f25" draw:formula="?f1 +?f4 "/><draw:equation draw:name="f26" draw:formula="?f25 +?f5 "/><draw:equation draw:name="f27" draw:formula="?f25 -?f5 "/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="2700" draw:handle-range-x-maximum="8100"/><draw:handle draw:handle-position="10800 $1" draw:handle-range-y-minimum="14400" draw:handle-range-y-maximum="21600"/></draw:enhanced-geometry>
    oo_mso_spt54("mso-spt54", "H4sIAAAAAAAA/42W226jMBCGX8VCvWqFgicmQFVaaXub7QPsHdqYFKkclpA2efv1GRITJjdkBP7mnxl+HL/s+uLnmTefRfOX78I9b2s+9Gdy+N4/f1f851d7yoOIRAToJjLXgCho4KchLHpeHPLgrZRr3kqayYtdcO54HtSHNjx0Q8zM3brdVWXFe0HFTKSkaeRSujq6YvjMg98yGcgL2bpwTd5dzOQlNrWJcGPC7VhwEssniapOMtNfplLJKJa0aYGSSMtJSGmlY2+xDZhek6l0tgAQ3aRGcDIw+cSGMiHQ8b7rA0x3WxeTP+SDYDOAtZ6BiJgegYq2uhMVv+vmzAoVbGwQ2yCxi6glR30Y9WGiD04fqM0O0UQ/meinrsLMFqAjN1FdQmpLSC5KMMVu3Rs0k8nG++ZdfASvL9pM/47FULWNtlZT1MKMpXVa2fb18avIg4eIBKslgnoERQi4JtTLDmU7y+D6GpT9rGAZYj60RqHYhxgKbXyIolByaxgbZBjpNcggWiYyv76UPCL1Uc8R0mFPEkVAzxgGzDDQ84cCIYmQ/qjnDztLhkl6JrFkjJEzThH7TnjHfObsokh0QDc9Q7EviHqucSj6nXv2sShGgmchJ4qZHDwTORR7M3B7mwEMndloxJ5+hx1gZreh0vRrDJzzkQQx68KMjcSG/3RHrZ6NFHnZpThv7L44mcRh1x4qmUz9NwxtF1w87Ytmz8NTWFdNVR9rMfXEHV+ulxQnvSSlk097UZFG4jREHuhcwvOoSRmbFz2PovqoJlRX80e81//1h4nt+wkAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="0 ?f0 ?f5 ?f2" draw:type="right-arrow" draw:modifiers="10800 5400" draw:enhanced-path="M 0 ?f0 L ?f1 ?f0 ?f1 0 21600 10800 ?f1 21600 ?f1 ?f2 0 ?f2 Z N"><draw:equation draw:name="f0" draw:formula="$1 "/><draw:equation draw:name="f1" draw:formula="$0 "/><draw:equation draw:name="f2" draw:formula="21600-$1 "/><draw:equation draw:name="f3" draw:formula="21600-?f1 "/><draw:equation draw:name="f4" draw:formula="?f3 *?f0 /10800"/><draw:equation draw:name="f5" draw:formula="?f1 +?f4 "/><draw:equation draw:name="f6" draw:formula="?f1 *?f0 /10800"/><draw:equation draw:name="f7" draw:formula="?f1 -?f6 "/><draw:handle draw:handle-position="$0 $1" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="21600" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/></draw:enhanced-geometry>
    oo_right_arrow("right-arrow", "H4sIAAAAAAAA/42T326DIBTGX4WQXm0hFatuaWpNdr3tAXZHJihJAYda9e0HorZrnfYCopzz+75z+HNINWn2VOZEftMUZVQJWukOlOdsf+a0eVNtDD3gAR9H3jBD0EMVbStENCWlzUiYHaEZ/hjvChpDzbPcpmnVDOtCpZxxqg2GvVcjGgaT5lRIQao8hh/ACb+bGQ8WeCrG0XbF/bscv2d88AU+4fHgVH9qUnElnYckwtTFRkumtKhPJIYbDOB2icB3hLdC+LdEXyhaddrNc7bBZTC4BRO2A09247b9bi3T4T2NwXPCghXXaI572PVljja9RhdXcynSEwVX36hQJbdS/SlsxqMZgprIjKIWCS65qIW5n//ESevi1/f6T063otFdNKZWt/Nv6vgLSs3LLmwDAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="0 0 ?f0 21600" draw:type="right-arrow-callout" draw:modifiers="14035 5400 16200 8100" draw:enhanced-path="M 0 0 L ?f0 0 ?f0 ?f3 ?f2 ?f3 ?f2 ?f1 21600 10800 ?f2 ?f4 ?f2 ?f5 ?f0 ?f5 ?f0 21600 0 21600 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="21600-?f1 "/><draw:equation draw:name="f5" draw:formula="21600-?f3 "/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="$2"/><draw:handle draw:handle-position="$2 $3" draw:handle-range-x-minimum="$0" draw:handle-range-x-maximum="21600" draw:handle-range-y-minimum="$1" draw:handle-range-y-maximum="10800"/><draw:handle draw:handle-position="right $1" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="$3"/></draw:enhanced-geometry>
    oo_right_arrow_callout("right-arrow-callout", "H4sIAAAAAAAA/42T3Y6DIBCFX4UQb0kBtWma2iZ7vbsPsHekopKIWMSqb7/4U9fWVXshGGe+OWdGOIWaVUeeJSy78hDFXEludAOKe3y8C159qDqAGGBAyR4PKwQdZHhtENOcFX3GJXqJNzkPoBZx0qZpVaErS1NVmiEuVSgiwbXFiYddH/ieVSB7atcDGcuM3nJmkgB+gVbrs1PrNS+Rax862cngluADxsM3b9j9gfH//I7d/YBveD71qreSGaGy3kPGpG0leliKlJZlygLoYAB3awSZEWSDoDOCbhDujHA3CO+V6NpH7eDWQX8JnCjavxWmHEzeUa4K0dbqBmZUDp+immUxRzWSIhOylPYwLcRZ3ccd+qYYBY67oeVsiU1P9FNOMylCFhIeRbqD+J7p7r6AxYqrM5oo2sat3O7/233+BdpQSjr2AwAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="0 0 0 21600 21600 10800" draw:text-areas="0 ?f9 7800 ?f10" draw:type="right-brace" draw:modifiers="1800 10800" draw:enhanced-path="M 0 0 C 5400 0 10800 ?f0 10800 ?f1 L 10800 ?f2 C 10800 ?f3 16200 ?f4 21600 ?f4 16200 ?f4 10800 ?f5 10800 ?f6 L 10800 ?f7 C 10800 ?f8 5400 21600 0 21600 N"><draw:equation draw:name="f0" draw:formula="$0 /2"/><draw:equation draw:name="f1" draw:formula="$0 "/><draw:equation draw:name="f2" draw:formula="?f4 -$0 "/><draw:equation draw:name="f3" draw:formula="?f4 -?f0 "/><draw:equation draw:name="f4" draw:formula="$1 "/><draw:equation draw:name="f5" draw:formula="?f4 +?f0 "/><draw:equation draw:name="f6" draw:formula="?f4 +$0 "/><draw:equation draw:name="f7" draw:formula="21600-$0 "/><draw:equation draw:name="f8" draw:formula="21600-?f0 "/><draw:equation draw:name="f9" draw:formula="$0 *10000/31953"/><draw:equation draw:name="f10" draw:formula="21600-?f9 "/><draw:handle draw:handle-position="10800 $0" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="5400"/><draw:handle draw:handle-position="right $1" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="21600"/></draw:enhanced-geometry>
    oo_right_brace("right-brace", "H4sIAAAAAAAA/6VUXW+DIBT9K4T0aQsRtFptapdsr9v+A6toSQp2FPvx74f40a6lZcl80BPuOffcK1wWhaKHOZNrKlesQBWrBdPqBHb7ar7n7PBaH3OIAQYhSXD/hsCKqk3D0LbmUu86yi8SIDgdqZodNaKKUct8KTMwM0EDyMg4bVkOFa/WGn0pumL9uqgLXnKmjJCkV1nHqrdUr3P4YUt4A/EUt8AyjcUZEfA+4tAQBxwBkoQWTfvaW3ReG3jxiJKLTLOLTGln3iUZvp9wuejq/W6o5rXsqpdUmI7LoZmyVqLZ0BxOMAhCGDzSEIfmsSK8VrR9Ia8scsraf/pYN70pkHgUscvp2e+UOHXexmbXMrtV/h+SunX+OjPHlj0RbJ4gIlkceTb85pQMvtnZ1wxDsWHgApvp3PE2mRkee0InQ54+rqisGDohwSUXjTDDeSdOj128Pd5/M7SjDCbkn4bdhWMcA/dFtfwBNDIwSMEEAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="0 0 0 21600 21600 10800" draw:text-areas="0 ?f3 15150 ?f4" draw:type="right-bracket" draw:modifiers="1800" draw:enhanced-path="M 0 0 C 10800 0 21600 ?f3 21600 ?f1 L 21600 ?f2 C 21600 ?f4 10800 21600 0 21600 N"><draw:equation draw:name="f0" draw:formula="$0 /2"/><draw:equation draw:name="f1" draw:formula="top+$0 "/><draw:equation draw:name="f2" draw:formula="bottom-$0 "/><draw:equation draw:name="f3" draw:formula="top+?f0 "/><draw:equation draw:name="f4" draw:formula="bottom-?f0 "/><draw:handle draw:handle-position="right $0" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/></draw:enhanced-geometry>
    oo_right_bracket("right-bracket", "H4sIAAAAAAAA/4WS326DIBTGX4WQ3i1EsXZZmtom2+22d6D1oKQCDrHVtx+KuLXpnxv4yPl+fCdwNrlh5zWokqkD5KQALcGaHjWnYn0ScH7XXYZjFKOEvsbTitEIFVULpNZC2cZbLkyIxm+z1UJnCTPARueOLxFd0dWg0uDoa8iwEUVpyd6wwxHsVJE6F1yAcSj9u3HuuGa2zPDXGP/hQ+dGhqCgKPqcdeKcQacT489h/8bbjc/5aZkVWvlUxaTrkocmuDayrViGFzGKEhw9Yug1Y3X94rjHVHJN7bW1WpKn4PJW3I4/w9I7eReke/m8AvRPuzFoxHDZ9IVoEZ5oqhumCiA9kUIJ2Uo3BXfqrPN1Pz0uMbo9oNtfd93iFbkCAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="10800" draw:path-stretchpoint-y="10800" draw:text-areas="?f3 ?f4 ?f5 ?f6" draw:type="round-rectangle" draw:modifiers="3600" draw:enhanced-path="M ?f7 0 X 0 ?f8 L 0 ?f9 Y ?f7 21600 L ?f10 21600 X 21600 ?f9 L 21600 ?f8 Y ?f10 0 Z N"><draw:equation draw:name="f0" draw:formula="45"/><draw:equation draw:name="f1" draw:formula="$0 *sin(?f0 *(pi/180))"/><draw:equation draw:name="f2" draw:formula="?f1 *3163/7636"/><draw:equation draw:name="f3" draw:formula="left+?f2 "/><draw:equation draw:name="f4" draw:formula="top+?f2 "/><draw:equation draw:name="f5" draw:formula="right-?f2 "/><draw:equation draw:name="f6" draw:formula="bottom-?f2 "/><draw:equation draw:name="f7" draw:formula="left+$0 "/><draw:equation draw:name="f8" draw:formula="top+$0 "/><draw:equation draw:name="f9" draw:formula="bottom-$0 "/><draw:equation draw:name="f10" draw:formula="right-$0 "/><draw:handle draw:handle-position="$0 top" draw:handle-switched="true" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_round_rectangle("round-rectangle", "H4sIAAAAAAAA/42U32+CMBDH/5Wm2YO6NIAoohFJ9uz27PbWyVWbQMtK8cd/vxPUKVP0ofTC3efue02v08Tw7QTUmqslJGwFOgNr9qTYrCYbCds3vYuoS1zS9wL3+KWkgnJu16ywBuxynWupLMNQzw1bAvbXARZ2lnEDvIhoLHwSiwGuIa7gFLHPIaJGlyphBpaWq1UKR1+mEykkGIT9P1XnVg7VI/qOyUYof4ErFiGZV/uYfFb/66bmaHunDhfH/RA0P9thBXiHg/giH3Q2rWv9lNxKrerKimeoVZyECG2yMuURHQyp0wZ4TeDFJb1Cqk4s0Ojk0vFCt9ttT9JvJkG1pOd7ge+MAj9oh/0mnIKwr7Hok3Zu0OSszp/Ahk3MyNXassdg0AS/tbU6e4Ic3ewQD7odC281+JAa35H5EPT+3Z36ZC5BvN1JCuTCZrku5CFXdXNQIb3yFluJ8wcJijclXPsMzhOwHcukklmZ4aTf8fNd7a+nF7U4t9+N2S/6YAtPUAQAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="0 0 0 10800 0 21600 10800 21600 21600 21600 10800 10800" draw:text-areas="1900 12700 12700 19700" draw:type="right-triangle" draw:enhanced-path="M 0 0 L 21600 21600 0 21600 0 0 Z N"/>
    oo_right_triangle("right-triangle", "H4sIAAAAAAAA/1VPzQ6CMAx+lWb3xY6DCBEPntUH8LZIsy3BsYzKz9urQJxcvqb9ftoe66iHkrzV/kG1NNQ+ieMEXW/K3tFwbsdKICBkao8rCphNpnmRDK3z3C0SBIUHTOKl+zNu5jOuUUwjSx1Jf5JU8SWzPGGRJ+EUqBLRGcuSo9PeNLRSvx+CZluJ63zQZbM4VYQ73MTu9AaDil0d/wAAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 3163 3163 0 10800 3163 18437 10800 21600 18437 18437 21600 10800 18437 3163" draw:text-areas="3163 3163 18437 18437" draw:type="smiley" draw:modifiers="18520" draw:enhanced-path="U 10800 10800 10800 10800 0 360 Z N U 7305 7515 1000 1865 0 360 Z N U 14295 7515 1000 1865 0 360 Z N M 4870 ?f1 C 8680 ?f2 12920 ?f2 16730 ?f1 F N"><draw:equation draw:name="f0" draw:formula="$0 -14510"/><draw:equation draw:name="f1" draw:formula="18520-?f0 "/><draw:equation draw:name="f2" draw:formula="14510+?f0 "/><draw:handle draw:handle-position="10800 $0" draw:handle-range-y-minimum="14510" draw:handle-range-y-maximum="18520"/></draw:enhanced-geometry>
    oo_smiley("smiley", "H4sIAAAAAAAA/31Sy26DMBD8lZWVW2XFNs9EIZFaqbfmlktvVjHEEjaURwJ/X2NMmzQtl9Uyu7Mza3aX1vy6FfrM9YdIcS5KJdp6gOaSby9SXJ/LPkEECDAaEhcRWFJedAJXpdRtkyBKYjK2eTT0pkBgwuwHjX0vcsA0ySE2OsRWJ2QkOZlW9C3mteBG5Wf6DX3uGyqRoEbJQgwOUmUqMynq0V8csNn497YVb88JOs3KD9GYDwm8wxFOEHkkgCiggalZm2FwV6c+2yw0vIEfRwQOGYUXiMN4TBlQtmEuC42ALb/CEe13k9HPjrey1JNtzZVZMJu3yMpadQVP0IoApn5ACVov8ehvnn0SfMgILBPZA3EUe7ojmgdNCwE3ubmMRo6z5ttYzcZdveY6F3jASmqpOuXG/tPDe9djf6NRXf99t/sveoW5m9ACAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt59" draw:modifiers="2500" draw:enhanced-path="M ?f5 ?f6 L ?f7 ?f8 ?f9 ?f10 ?f11 ?f12 ?f13 ?f14 ?f15 ?f16 ?f17 ?f18 ?f19 ?f20 ?f21 ?f22 ?f23 ?f24 ?f25 ?f26 ?f27 ?f28 ?f29 ?f30 ?f31 ?f32 ?f33 ?f34 ?f35 ?f36 ?f37 ?f38 ?f39 ?f40 ?f41 ?f42 ?f43 ?f44 ?f45 ?f46 ?f47 ?f48 ?f49 ?f50 ?f51 ?f52 ?f53 ?f54 ?f55 ?f56 ?f57 ?f58 ?f59 ?f60 ?f61 ?f62 ?f63 ?f64 ?f65 ?f66 ?f67 ?f68 ?f5 ?f6 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="(cos(315*(pi/180))*(?f0 -10800)+sin(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f2" draw:formula="-(sin(315*(pi/180))*(?f0 -10800)-cos(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f3" draw:formula="(cos(135*(pi/180))*(?f0 -10800)+sin(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f4" draw:formula="-(sin(135*(pi/180))*(?f0 -10800)-cos(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f5" draw:formula="(cos(0*(pi/180))*(0-10800)+sin(0*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f6" draw:formula="-(sin(0*(pi/180))*(0-10800)-cos(0*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f7" draw:formula="(cos(11*(pi/180))*(?f0 -10800)+sin(11*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f8" draw:formula="-(sin(11*(pi/180))*(?f0 -10800)-cos(11*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f9" draw:formula="(cos(22*(pi/180))*(0-10800)+sin(22*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f10" draw:formula="-(sin(22*(pi/180))*(0-10800)-cos(22*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f11" draw:formula="(cos(33*(pi/180))*(?f0 -10800)+sin(33*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f12" draw:formula="-(sin(33*(pi/180))*(?f0 -10800)-cos(33*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f13" draw:formula="(cos(45*(pi/180))*(0-10800)+sin(45*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f14" draw:formula="-(sin(45*(pi/180))*(0-10800)-cos(45*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f15" draw:formula="(cos(56*(pi/180))*(?f0 -10800)+sin(56*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f16" draw:formula="-(sin(56*(pi/180))*(?f0 -10800)-cos(56*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f17" draw:formula="(cos(67*(pi/180))*(0-10800)+sin(67*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f18" draw:formula="-(sin(67*(pi/180))*(0-10800)-cos(67*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f19" draw:formula="(cos(78*(pi/180))*(?f0 -10800)+sin(78*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f20" draw:formula="-(sin(78*(pi/180))*(?f0 -10800)-cos(78*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f21" draw:formula="(cos(90*(pi/180))*(0-10800)+sin(90*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f22" draw:formula="-(sin(90*(pi/180))*(0-10800)-cos(90*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f23" draw:formula="(cos(101*(pi/180))*(?f0 -10800)+sin(101*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f24" draw:formula="-(sin(101*(pi/180))*(?f0 -10800)-cos(101*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f25" draw:formula="(cos(112*(pi/180))*(0-10800)+sin(112*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f26" draw:formula="-(sin(112*(pi/180))*(0-10800)-cos(112*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f27" draw:formula="(cos(123*(pi/180))*(?f0 -10800)+sin(123*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f28" draw:formula="-(sin(123*(pi/180))*(?f0 -10800)-cos(123*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f29" draw:formula="(cos(135*(pi/180))*(0-10800)+sin(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f30" draw:formula="-(sin(135*(pi/180))*(0-10800)-cos(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f31" draw:formula="(cos(146*(pi/180))*(?f0 -10800)+sin(146*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f32" draw:formula="-(sin(146*(pi/180))*(?f0 -10800)-cos(146*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f33" draw:formula="(cos(157*(pi/180))*(0-10800)+sin(157*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f34" draw:formula="-(sin(157*(pi/180))*(0-10800)-cos(157*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f35" draw:formula="(cos(168*(pi/180))*(?f0 -10800)+sin(168*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f36" draw:formula="-(sin(168*(pi/180))*(?f0 -10800)-cos(168*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f37" draw:formula="(cos(180*(pi/180))*(0-10800)+sin(180*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f38" draw:formula="-(sin(180*(pi/180))*(0-10800)-cos(180*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f39" draw:formula="(cos(191*(pi/180))*(?f0 -10800)+sin(191*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f40" draw:formula="-(sin(191*(pi/180))*(?f0 -10800)-cos(191*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f41" draw:formula="(cos(202*(pi/180))*(0-10800)+sin(202*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f42" draw:formula="-(sin(202*(pi/180))*(0-10800)-cos(202*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f43" draw:formula="(cos(213*(pi/180))*(?f0 -10800)+sin(213*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f44" draw:formula="-(sin(213*(pi/180))*(?f0 -10800)-cos(213*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f45" draw:formula="(cos(225*(pi/180))*(0-10800)+sin(225*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f46" draw:formula="-(sin(225*(pi/180))*(0-10800)-cos(225*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f47" draw:formula="(cos(236*(pi/180))*(?f0 -10800)+sin(236*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f48" draw:formula="-(sin(236*(pi/180))*(?f0 -10800)-cos(236*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f49" draw:formula="(cos(247*(pi/180))*(0-10800)+sin(247*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f50" draw:formula="-(sin(247*(pi/180))*(0-10800)-cos(247*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f51" draw:formula="(cos(258*(pi/180))*(?f0 -10800)+sin(258*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f52" draw:formula="-(sin(258*(pi/180))*(?f0 -10800)-cos(258*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f53" draw:formula="(cos(270*(pi/180))*(0-10800)+sin(270*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f54" draw:formula="-(sin(270*(pi/180))*(0-10800)-cos(270*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f55" draw:formula="(cos(281*(pi/180))*(?f0 -10800)+sin(281*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f56" draw:formula="-(sin(281*(pi/180))*(?f0 -10800)-cos(281*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f57" draw:formula="(cos(292*(pi/180))*(0-10800)+sin(292*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f58" draw:formula="-(sin(292*(pi/180))*(0-10800)-cos(292*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f59" draw:formula="(cos(303*(pi/180))*(?f0 -10800)+sin(303*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f60" draw:formula="-(sin(303*(pi/180))*(?f0 -10800)-cos(303*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f61" draw:formula="(cos(315*(pi/180))*(0-10800)+sin(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f62" draw:formula="-(sin(315*(pi/180))*(0-10800)-cos(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f63" draw:formula="(cos(326*(pi/180))*(?f0 -10800)+sin(326*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f64" draw:formula="-(sin(326*(pi/180))*(?f0 -10800)-cos(326*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f65" draw:formula="(cos(337*(pi/180))*(0-10800)+sin(337*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f66" draw:formula="-(sin(337*(pi/180))*(0-10800)-cos(337*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f67" draw:formula="(cos(348*(pi/180))*(?f0 -10800)+sin(348*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f68" draw:formula="-(sin(348*(pi/180))*(?f0 -10800)-cos(348*(pi/180))*(10800-10800))+10800"/><draw:handle draw:handle-position="$0 10800" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_mso_spt59("mso-spt59", "H4sIAAAAAAAA/62a3W7TQBCFX8WyuEhBo+5/YkSoxDXwANxZ1GktkR+SFMrb40lK1aznrDoyF+tWHR9/Z3fVM9u4H2737e/33ea+3Xzvbumu26674/5Pdfh19/5X3/3+tH1c1qYylbPJPF3r6iQ6do9Havdde1jWNytb3azcMPwwwr87/uy6Zb0+bOmwO8bm6afr7W2/6rv9IHPx+WnPFnbt8X5ZfxkeE4eRqs/DdT6MxTCaYVjDF8ZZ5lkG2sAXvt8mvvD9lgWWFY4V7mSQFY4VjhWOFY4VjhWOFY4VnhWeFf40J1Z4VnhWeFZ4VnhWeFYEVgRWBFaE0zKwIrAisCKwIrAisCKyIrIisiKyIrIisiKyIrIisiKyIrEisSKxIrEisSKdVooViRVp8bx436qv9ccP5wX++dAe++3mvNybdj1szerf6q+2+/XDj3ZZvzFVfV1S2Fwx+749zLyNb2e7/touzNXV29nNylRkzcKYq3eHfpOXT5Wn+tW709cy1OVQmgmPfUElwZSa6sWpWl+calZWQ4M8VUwlwZSaGsWpmpfPNC9naSbRkjxHEUcjI2rcXN5HW9xGOwm5ALuImDR2pGY24jSdg5t4WVLz7Cg8zpOUiTQ2oyeC8PHF7PHTmCh7EJTGlvRQOXpChHsZpv3+WxA7MpHGZvREOXJiKu3lZVXPBMEDoTS2pIfK8ZPmcC8vS3ogCB+ZSGMzeqIcPfNFaS8vq/ojAUgfCKWxJT1UDqAGN8pmWutyIH1kIo3N6Ing1GPK7dJM610OHXsglgRXeqwcQtbippnV9EiQQYBJgh89E5yAXLFxZmU9FR2CIJYEV3qsHEbZCflyTyeenj3IIsD8Lyd2L0eRDcUGmpX1VJBHGEuCKz0WhFLETTSr6ZEokWQmCX70TBBHqdhIs7KeihIJYklwpceCUFrgZprV9EiUSDKTBD96JoijptxPm2mNLaBEglgSXOmxcig5U/gj1EzrbQEkEmCS4EfPlOPI2WI/zcp6KkgkjCXBlR4rh5JzuJ9mNT0SJBJgkuBHz5TjyPliP83KeipIJIwlwZUeCz4rCrifZjU1MqJPi2QmCX70TBBHsdhPs7KeihIJYklwpceCUJrjfprV9EiUSDKTBD96JoijRbGfZmU9FSUSxJLgSo8FodQU+mkzrbdFlEgykwQ/eqYcR96UP9g10xpbAomEsSS40mNf9QbtYk+nvshKr3t/drGnk5lyHHlX7KdZWU8FiYSxJLjSY+VQ8h7306ymR4JEAkwS/OiZchz5UOynWVlPBYmEsSS4KmHv283tj6568T3ttoeenZzeiJ/vvqjv281dR4+07jf9+mG9rFG9fTzXn4nX55nm/3Hx8S/KfC/BiiEAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="star24" draw:modifiers="2500" draw:enhanced-path="M ?f5 ?f6 L ?f7 ?f8 ?f9 ?f10 ?f11 ?f12 ?f13 ?f14 ?f15 ?f16 ?f17 ?f18 ?f19 ?f20 ?f21 ?f22 ?f23 ?f24 ?f25 ?f26 ?f27 ?f28 ?f29 ?f30 ?f31 ?f32 ?f33 ?f34 ?f35 ?f36 ?f37 ?f38 ?f39 ?f40 ?f41 ?f42 ?f43 ?f44 ?f45 ?f46 ?f47 ?f48 ?f49 ?f50 ?f51 ?f52 ?f53 ?f54 ?f55 ?f56 ?f57 ?f58 ?f59 ?f60 ?f61 ?f62 ?f63 ?f64 ?f65 ?f66 ?f67 ?f68 ?f69 ?f70 ?f71 ?f72 ?f73 ?f74 ?f75 ?f76 ?f77 ?f78 ?f79 ?f80 ?f81 ?f82 ?f83 ?f84 ?f85 ?f86 ?f87 ?f88 ?f89 ?f90 ?f91 ?f92 ?f93 ?f94 ?f95 ?f96 ?f97 ?f98 ?f99 ?f100 ?f5 ?f6 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="(cos(315*(pi/180))*(?f0 -10800)+sin(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f2" draw:formula="-(sin(315*(pi/180))*(?f0 -10800)-cos(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f3" draw:formula="(cos(135*(pi/180))*(?f0 -10800)+sin(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f4" draw:formula="-(sin(135*(pi/180))*(?f0 -10800)-cos(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f5" draw:formula="(cos(0*(pi/180))*(0-10800)+sin(0*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f6" draw:formula="-(sin(0*(pi/180))*(0-10800)-cos(0*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f7" draw:formula="(cos(7*(pi/180))*(?f0 -10800)+sin(7*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f8" draw:formula="-(sin(7*(pi/180))*(?f0 -10800)-cos(7*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f9" draw:formula="(cos(15*(pi/180))*(0-10800)+sin(15*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f10" draw:formula="-(sin(15*(pi/180))*(0-10800)-cos(15*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f11" draw:formula="(cos(22*(pi/180))*(?f0 -10800)+sin(22*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f12" draw:formula="-(sin(22*(pi/180))*(?f0 -10800)-cos(22*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f13" draw:formula="(cos(30*(pi/180))*(0-10800)+sin(30*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f14" draw:formula="-(sin(30*(pi/180))*(0-10800)-cos(30*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f15" draw:formula="(cos(37*(pi/180))*(?f0 -10800)+sin(37*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f16" draw:formula="-(sin(37*(pi/180))*(?f0 -10800)-cos(37*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f17" draw:formula="(cos(45*(pi/180))*(0-10800)+sin(45*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f18" draw:formula="-(sin(45*(pi/180))*(0-10800)-cos(45*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f19" draw:formula="(cos(52*(pi/180))*(?f0 -10800)+sin(52*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f20" draw:formula="-(sin(52*(pi/180))*(?f0 -10800)-cos(52*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f21" draw:formula="(cos(60*(pi/180))*(0-10800)+sin(60*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f22" draw:formula="-(sin(60*(pi/180))*(0-10800)-cos(60*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f23" draw:formula="(cos(67*(pi/180))*(?f0 -10800)+sin(67*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f24" draw:formula="-(sin(67*(pi/180))*(?f0 -10800)-cos(67*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f25" draw:formula="(cos(75*(pi/180))*(0-10800)+sin(75*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f26" draw:formula="-(sin(75*(pi/180))*(0-10800)-cos(75*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f27" draw:formula="(cos(82*(pi/180))*(?f0 -10800)+sin(82*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f28" draw:formula="-(sin(82*(pi/180))*(?f0 -10800)-cos(82*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f29" draw:formula="(cos(90*(pi/180))*(0-10800)+sin(90*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f30" draw:formula="-(sin(90*(pi/180))*(0-10800)-cos(90*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f31" draw:formula="(cos(97*(pi/180))*(?f0 -10800)+sin(97*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f32" draw:formula="-(sin(97*(pi/180))*(?f0 -10800)-cos(97*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f33" draw:formula="(cos(105*(pi/180))*(0-10800)+sin(105*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f34" draw:formula="-(sin(105*(pi/180))*(0-10800)-cos(105*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f35" draw:formula="(cos(112*(pi/180))*(?f0 -10800)+sin(112*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f36" draw:formula="-(sin(112*(pi/180))*(?f0 -10800)-cos(112*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f37" draw:formula="(cos(120*(pi/180))*(0-10800)+sin(120*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f38" draw:formula="-(sin(120*(pi/180))*(0-10800)-cos(120*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f39" draw:formula="(cos(127*(pi/180))*(?f0 -10800)+sin(127*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f40" draw:formula="-(sin(127*(pi/180))*(?f0 -10800)-cos(127*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f41" draw:formula="(cos(135*(pi/180))*(0-10800)+sin(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f42" draw:formula="-(sin(135*(pi/180))*(0-10800)-cos(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f43" draw:formula="(cos(142*(pi/180))*(?f0 -10800)+sin(142*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f44" draw:formula="-(sin(142*(pi/180))*(?f0 -10800)-cos(142*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f45" draw:formula="(cos(150*(pi/180))*(0-10800)+sin(150*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f46" draw:formula="-(sin(150*(pi/180))*(0-10800)-cos(150*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f47" draw:formula="(cos(157*(pi/180))*(?f0 -10800)+sin(157*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f48" draw:formula="-(sin(157*(pi/180))*(?f0 -10800)-cos(157*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f49" draw:formula="(cos(165*(pi/180))*(0-10800)+sin(165*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f50" draw:formula="-(sin(165*(pi/180))*(0-10800)-cos(165*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f51" draw:formula="(cos(172*(pi/180))*(?f0 -10800)+sin(172*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f52" draw:formula="-(sin(172*(pi/180))*(?f0 -10800)-cos(172*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f53" draw:formula="(cos(180*(pi/180))*(0-10800)+sin(180*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f54" draw:formula="-(sin(180*(pi/180))*(0-10800)-cos(180*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f55" draw:formula="(cos(187*(pi/180))*(?f0 -10800)+sin(187*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f56" draw:formula="-(sin(187*(pi/180))*(?f0 -10800)-cos(187*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f57" draw:formula="(cos(195*(pi/180))*(0-10800)+sin(195*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f58" draw:formula="-(sin(195*(pi/180))*(0-10800)-cos(195*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f59" draw:formula="(cos(202*(pi/180))*(?f0 -10800)+sin(202*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f60" draw:formula="-(sin(202*(pi/180))*(?f0 -10800)-cos(202*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f61" draw:formula="(cos(210*(pi/180))*(0-10800)+sin(210*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f62" draw:formula="-(sin(210*(pi/180))*(0-10800)-cos(210*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f63" draw:formula="(cos(217*(pi/180))*(?f0 -10800)+sin(217*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f64" draw:formula="-(sin(217*(pi/180))*(?f0 -10800)-cos(217*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f65" draw:formula="(cos(225*(pi/180))*(0-10800)+sin(225*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f66" draw:formula="-(sin(225*(pi/180))*(0-10800)-cos(225*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f67" draw:formula="(cos(232*(pi/180))*(?f0 -10800)+sin(232*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f68" draw:formula="-(sin(232*(pi/180))*(?f0 -10800)-cos(232*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f69" draw:formula="(cos(240*(pi/180))*(0-10800)+sin(240*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f70" draw:formula="-(sin(240*(pi/180))*(0-10800)-cos(240*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f71" draw:formula="(cos(247*(pi/180))*(?f0 -10800)+sin(247*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f72" draw:formula="-(sin(247*(pi/180))*(?f0 -10800)-cos(247*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f73" draw:formula="(cos(255*(pi/180))*(0-10800)+sin(255*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f74" draw:formula="-(sin(255*(pi/180))*(0-10800)-cos(255*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f75" draw:formula="(cos(262*(pi/180))*(?f0 -10800)+sin(262*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f76" draw:formula="-(sin(262*(pi/180))*(?f0 -10800)-cos(262*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f77" draw:formula="(cos(270*(pi/180))*(0-10800)+sin(270*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f78" draw:formula="-(sin(270*(pi/180))*(0-10800)-cos(270*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f79" draw:formula="(cos(277*(pi/180))*(?f0 -10800)+sin(277*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f80" draw:formula="-(sin(277*(pi/180))*(?f0 -10800)-cos(277*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f81" draw:formula="(cos(285*(pi/180))*(0-10800)+sin(285*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f82" draw:formula="-(sin(285*(pi/180))*(0-10800)-cos(285*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f83" draw:formula="(cos(292*(pi/180))*(?f0 -10800)+sin(292*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f84" draw:formula="-(sin(292*(pi/180))*(?f0 -10800)-cos(292*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f85" draw:formula="(cos(300*(pi/180))*(0-10800)+sin(300*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f86" draw:formula="-(sin(300*(pi/180))*(0-10800)-cos(300*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f87" draw:formula="(cos(307*(pi/180))*(?f0 -10800)+sin(307*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f88" draw:formula="-(sin(307*(pi/180))*(?f0 -10800)-cos(307*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f89" draw:formula="(cos(315*(pi/180))*(0-10800)+sin(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f90" draw:formula="-(sin(315*(pi/180))*(0-10800)-cos(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f91" draw:formula="(cos(322*(pi/180))*(?f0 -10800)+sin(322*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f92" draw:formula="-(sin(322*(pi/180))*(?f0 -10800)-cos(322*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f93" draw:formula="(cos(330*(pi/180))*(0-10800)+sin(330*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f94" draw:formula="-(sin(330*(pi/180))*(0-10800)-cos(330*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f95" draw:formula="(cos(337*(pi/180))*(?f0 -10800)+sin(337*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f96" draw:formula="-(sin(337*(pi/180))*(?f0 -10800)-cos(337*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f97" draw:formula="(cos(345*(pi/180))*(0-10800)+sin(345*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f98" draw:formula="-(sin(345*(pi/180))*(0-10800)-cos(345*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f99" draw:formula="(cos(352*(pi/180))*(?f0 -10800)+sin(352*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f100" draw:formula="-(sin(352*(pi/180))*(?f0 -10800)-cos(352*(pi/180))*(10800-10800))+10800"/><draw:handle draw:handle-position="$0 10800" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_star24("star24", "H4sIAAAAAAAA/62bzW7bSBCEX0UQ9mAnaJjzx5kJohjY8+4+wN6IWLIFRJJXkhPn7Vct/8AmuyZodA5UgoxKX43JKphU5/PNfvjxabm9G7Zflzd0u9xtlsf9z9nh++2n7+vljz93j4t5N+tm3vXd8+t8dhYdl49HGvbL4bCYX6/c7HrlT0c4HfHlHT/vl4v54Tjs/cs/bXY369V6uT9pfHr9qFf+/XC8W8z/Pn1GOh397K/Taz4d5XTU0+E6fmGWY5hjmov8wu93Pb/w+x0LHCs8K/zZHSs8KzwrPCs8KzwrPCs8KwIrAivCeUOsCKwIrAisCKwIrAisiKyIrIisiOefASsiKyIrIisiKyIrEisSKxIrEisSKxIrEisSKxIrEit6VvSs6FnRs6JnRX/+SbGiZ0XPip4VmRWZFZkVmRWZFZkVmRWZFZkVmRWFFYUVhRWFFYUVhRWFFeV8NlhRWFFZUVlRWVFZUVlRWVFZUVlRzyfw6Qx2r2f339k/8y+fn66A/x6G43q3fboetsPmdOGsXi6P1W6/efg2LOZ/dLP5VUvhxoqLr7vDRXDpw8X9+sqV7vLyw8X1qpuR60rXXX48rLfj5fPK8/rlx/OfbagfQ+lC+Ng3VBJMqalB3KoLza2OltXQKG8VU0kwpaYmcavd28/s3u6yM9F6eY8ijiZG1Lgsbi63zmI2AYu8P0SkiR01scqXaoIn0BgNNymO58tUJNLUjJ4oF4/3rdP4flXPBL0DoTS1pIfKtRNwGIMtHg5UjkykqRk9Ua6b0IxksCXEgdKBUJpa0kPl6ok4l9GYElA9MpGmZvREuXpSM5fJFhEP2gdCaWpJD5ULqMe57G0p8aB9ZCJNzeiJcvX0zVz2toh40D4QSlNLeqhcQBnnMht/gQXtIxNpakZPlKunNHNZjBEB7QOhNLWkh8oFVHEuqy0lAbSPTKSpGT1Rrp7azGW1RSSA9oFQmlrSQ8EtV9f4RbYz3uShGy6ZSYIfPVOuH+ea4Rwt66mggzCWBFd6rFxEzuOAjtb0SNBDgEmCHz0T3IL5ZkhHy2pqRPdhEEuCKz1WLqTRU4j359T6XAT0EWD+lqciEdRRbOc02gITUSNBLAmu9FhQSqmR02TLTESNJDNJ8KNngjpK7ZwmY2BQI0EsCa70WFBKfSOnvfFJImokmUmCHz0T1FFu5zTbApNQI0EsCa70WFBKpZHTYstMQo0kM0nwo2eCOirtnBZbYBJqJIglwZUeC0qpNnJajZlBjSQzSfCjZ8p15Lv2Q9zOFpgeNBLGkuBKjwUPrB3O6WhNj0TPq2UmCX70TLmOvGvmdLSsp4JGwlgSXOmxcil5j3M6WtMjQSMBJgl+9Ey5jnxo5zQYAwMaCWNJcKXHglKKjZxG4xeSqJFkJgl+9ExQR7Gd02gLTEaNBLEkuNJjQSmlRk6TLTMZNZLMJMGPngnqqG/ntLcFJqNGglgSXOmxoJRyI6fZmBnUSDKTBD96Jqij3M5ptgWmoEaCWBJc6bGglEojp8WWmYIaSWaS4EfPBHVU2zmttsAU1EgQS4IrPRZ8ud+1BhhsmSnou32ZSYIfPVOuo9C1hxg6Y2BAI2EsCa70WLmUQmPAyDp8V0EjAeZvGfirYLixPWQUjAM/FU03tseMzFgwZ9QaNDLO/VQ0adQaNbIyQR39YtjIOPhTUSP9YtzIigWl1Bg4Csb5n4oaqTFyZGaCOmoPHQXjAJDrUCW1544U3Lthe/NtOXvzd7rfHdZs5Tya/fTud+v7YXu7pEfarLfrzcNmMUfrw+PT+ivx6mmr4/+Y8OV/mArUvbEwAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="mso-spt60" draw:modifiers="2500" draw:enhanced-path="M ?f5 ?f6 L ?f7 ?f8 ?f9 ?f10 ?f11 ?f12 ?f13 ?f14 ?f15 ?f16 ?f17 ?f18 ?f19 ?f20 ?f21 ?f22 ?f23 ?f24 ?f25 ?f26 ?f27 ?f28 ?f29 ?f30 ?f31 ?f32 ?f33 ?f34 ?f35 ?f36 ?f37 ?f38 ?f39 ?f40 ?f41 ?f42 ?f43 ?f44 ?f45 ?f46 ?f47 ?f48 ?f49 ?f50 ?f51 ?f52 ?f53 ?f54 ?f55 ?f56 ?f57 ?f58 ?f59 ?f60 ?f61 ?f62 ?f63 ?f64 ?f65 ?f66 ?f67 ?f68 ?f69 ?f70 ?f71 ?f72 ?f73 ?f74 ?f75 ?f76 ?f77 ?f78 ?f79 ?f80 ?f81 ?f82 ?f83 ?f84 ?f85 ?f86 ?f87 ?f88 ?f89 ?f90 ?f91 ?f92 ?f93 ?f94 ?f95 ?f96 ?f97 ?f98 ?f99 ?f100 ?f101 ?f102 ?f103 ?f104 ?f105 ?f106 ?f107 ?f108 ?f109 ?f110 ?f111 ?f112 ?f113 ?f114 ?f115 ?f116 ?f117 ?f118 ?f119 ?f120 ?f121 ?f122 ?f123 ?f124 ?f125 ?f126 ?f127 ?f128 ?f129 ?f130 ?f131 ?f132 ?f5 ?f6 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="(cos(315*(pi/180))*(?f0 -10800)+sin(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f2" draw:formula="-(sin(315*(pi/180))*(?f0 -10800)-cos(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f3" draw:formula="(cos(135*(pi/180))*(?f0 -10800)+sin(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f4" draw:formula="-(sin(135*(pi/180))*(?f0 -10800)-cos(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f5" draw:formula="(cos(0*(pi/180))*(0-10800)+sin(0*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f6" draw:formula="-(sin(0*(pi/180))*(0-10800)-cos(0*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f7" draw:formula="(cos(5*(pi/180))*(?f0 -10800)+sin(5*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f8" draw:formula="-(sin(5*(pi/180))*(?f0 -10800)-cos(5*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f9" draw:formula="(cos(11*(pi/180))*(0-10800)+sin(11*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f10" draw:formula="-(sin(11*(pi/180))*(0-10800)-cos(11*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f11" draw:formula="(cos(16*(pi/180))*(?f0 -10800)+sin(16*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f12" draw:formula="-(sin(16*(pi/180))*(?f0 -10800)-cos(16*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f13" draw:formula="(cos(22*(pi/180))*(0-10800)+sin(22*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f14" draw:formula="-(sin(22*(pi/180))*(0-10800)-cos(22*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f15" draw:formula="(cos(28*(pi/180))*(?f0 -10800)+sin(28*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f16" draw:formula="-(sin(28*(pi/180))*(?f0 -10800)-cos(28*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f17" draw:formula="(cos(33*(pi/180))*(0-10800)+sin(33*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f18" draw:formula="-(sin(33*(pi/180))*(0-10800)-cos(33*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f19" draw:formula="(cos(39*(pi/180))*(?f0 -10800)+sin(39*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f20" draw:formula="-(sin(39*(pi/180))*(?f0 -10800)-cos(39*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f21" draw:formula="(cos(45*(pi/180))*(0-10800)+sin(45*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f22" draw:formula="-(sin(45*(pi/180))*(0-10800)-cos(45*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f23" draw:formula="(cos(50*(pi/180))*(?f0 -10800)+sin(50*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f24" draw:formula="-(sin(50*(pi/180))*(?f0 -10800)-cos(50*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f25" draw:formula="(cos(56*(pi/180))*(0-10800)+sin(56*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f26" draw:formula="-(sin(56*(pi/180))*(0-10800)-cos(56*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f27" draw:formula="(cos(61*(pi/180))*(?f0 -10800)+sin(61*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f28" draw:formula="-(sin(61*(pi/180))*(?f0 -10800)-cos(61*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f29" draw:formula="(cos(67*(pi/180))*(0-10800)+sin(67*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f30" draw:formula="-(sin(67*(pi/180))*(0-10800)-cos(67*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f31" draw:formula="(cos(73*(pi/180))*(?f0 -10800)+sin(73*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f32" draw:formula="-(sin(73*(pi/180))*(?f0 -10800)-cos(73*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f33" draw:formula="(cos(78*(pi/180))*(0-10800)+sin(78*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f34" draw:formula="-(sin(78*(pi/180))*(0-10800)-cos(78*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f35" draw:formula="(cos(84*(pi/180))*(?f0 -10800)+sin(84*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f36" draw:formula="-(sin(84*(pi/180))*(?f0 -10800)-cos(84*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f37" draw:formula="(cos(90*(pi/180))*(0-10800)+sin(90*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f38" draw:formula="-(sin(90*(pi/180))*(0-10800)-cos(90*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f39" draw:formula="(cos(95*(pi/180))*(?f0 -10800)+sin(95*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f40" draw:formula="-(sin(95*(pi/180))*(?f0 -10800)-cos(95*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f41" draw:formula="(cos(101*(pi/180))*(0-10800)+sin(101*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f42" draw:formula="-(sin(101*(pi/180))*(0-10800)-cos(101*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f43" draw:formula="(cos(106*(pi/180))*(?f0 -10800)+sin(106*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f44" draw:formula="-(sin(106*(pi/180))*(?f0 -10800)-cos(106*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f45" draw:formula="(cos(112*(pi/180))*(0-10800)+sin(112*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f46" draw:formula="-(sin(112*(pi/180))*(0-10800)-cos(112*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f47" draw:formula="(cos(118*(pi/180))*(?f0 -10800)+sin(118*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f48" draw:formula="-(sin(118*(pi/180))*(?f0 -10800)-cos(118*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f49" draw:formula="(cos(123*(pi/180))*(0-10800)+sin(123*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f50" draw:formula="-(sin(123*(pi/180))*(0-10800)-cos(123*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f51" draw:formula="(cos(129*(pi/180))*(?f0 -10800)+sin(129*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f52" draw:formula="-(sin(129*(pi/180))*(?f0 -10800)-cos(129*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f53" draw:formula="(cos(135*(pi/180))*(0-10800)+sin(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f54" draw:formula="-(sin(135*(pi/180))*(0-10800)-cos(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f55" draw:formula="(cos(140*(pi/180))*(?f0 -10800)+sin(140*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f56" draw:formula="-(sin(140*(pi/180))*(?f0 -10800)-cos(140*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f57" draw:formula="(cos(146*(pi/180))*(0-10800)+sin(146*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f58" draw:formula="-(sin(146*(pi/180))*(0-10800)-cos(146*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f59" draw:formula="(cos(151*(pi/180))*(?f0 -10800)+sin(151*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f60" draw:formula="-(sin(151*(pi/180))*(?f0 -10800)-cos(151*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f61" draw:formula="(cos(157*(pi/180))*(0-10800)+sin(157*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f62" draw:formula="-(sin(157*(pi/180))*(0-10800)-cos(157*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f63" draw:formula="(cos(163*(pi/180))*(?f0 -10800)+sin(163*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f64" draw:formula="-(sin(163*(pi/180))*(?f0 -10800)-cos(163*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f65" draw:formula="(cos(168*(pi/180))*(0-10800)+sin(168*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f66" draw:formula="-(sin(168*(pi/180))*(0-10800)-cos(168*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f67" draw:formula="(cos(174*(pi/180))*(?f0 -10800)+sin(174*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f68" draw:formula="-(sin(174*(pi/180))*(?f0 -10800)-cos(174*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f69" draw:formula="(cos(180*(pi/180))*(0-10800)+sin(180*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f70" draw:formula="-(sin(180*(pi/180))*(0-10800)-cos(180*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f71" draw:formula="(cos(185*(pi/180))*(?f0 -10800)+sin(185*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f72" draw:formula="-(sin(185*(pi/180))*(?f0 -10800)-cos(185*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f73" draw:formula="(cos(191*(pi/180))*(0-10800)+sin(191*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f74" draw:formula="-(sin(191*(pi/180))*(0-10800)-cos(191*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f75" draw:formula="(cos(196*(pi/180))*(?f0 -10800)+sin(196*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f76" draw:formula="-(sin(196*(pi/180))*(?f0 -10800)-cos(196*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f77" draw:formula="(cos(202*(pi/180))*(0-10800)+sin(202*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f78" draw:formula="-(sin(202*(pi/180))*(0-10800)-cos(202*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f79" draw:formula="(cos(208*(pi/180))*(?f0 -10800)+sin(208*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f80" draw:formula="-(sin(208*(pi/180))*(?f0 -10800)-cos(208*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f81" draw:formula="(cos(213*(pi/180))*(0-10800)+sin(213*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f82" draw:formula="-(sin(213*(pi/180))*(0-10800)-cos(213*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f83" draw:formula="(cos(219*(pi/180))*(?f0 -10800)+sin(219*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f84" draw:formula="-(sin(219*(pi/180))*(?f0 -10800)-cos(219*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f85" draw:formula="(cos(225*(pi/180))*(0-10800)+sin(225*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f86" draw:formula="-(sin(225*(pi/180))*(0-10800)-cos(225*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f87" draw:formula="(cos(230*(pi/180))*(?f0 -10800)+sin(230*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f88" draw:formula="-(sin(230*(pi/180))*(?f0 -10800)-cos(230*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f89" draw:formula="(cos(236*(pi/180))*(0-10800)+sin(236*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f90" draw:formula="-(sin(236*(pi/180))*(0-10800)-cos(236*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f91" draw:formula="(cos(241*(pi/180))*(?f0 -10800)+sin(241*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f92" draw:formula="-(sin(241*(pi/180))*(?f0 -10800)-cos(241*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f93" draw:formula="(cos(247*(pi/180))*(0-10800)+sin(247*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f94" draw:formula="-(sin(247*(pi/180))*(0-10800)-cos(247*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f95" draw:formula="(cos(253*(pi/180))*(?f0 -10800)+sin(253*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f96" draw:formula="-(sin(253*(pi/180))*(?f0 -10800)-cos(253*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f97" draw:formula="(cos(258*(pi/180))*(0-10800)+sin(258*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f98" draw:formula="-(sin(258*(pi/180))*(0-10800)-cos(258*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f99" draw:formula="(cos(264*(pi/180))*(?f0 -10800)+sin(264*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f100" draw:formula="-(sin(264*(pi/180))*(?f0 -10800)-cos(264*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f101" draw:formula="(cos(270*(pi/180))*(0-10800)+sin(270*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f102" draw:formula="-(sin(270*(pi/180))*(0-10800)-cos(270*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f103" draw:formula="(cos(275*(pi/180))*(?f0 -10800)+sin(275*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f104" draw:formula="-(sin(275*(pi/180))*(?f0 -10800)-cos(275*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f105" draw:formula="(cos(281*(pi/180))*(0-10800)+sin(281*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f106" draw:formula="-(sin(281*(pi/180))*(0-10800)-cos(281*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f107" draw:formula="(cos(286*(pi/180))*(?f0 -10800)+sin(286*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f108" draw:formula="-(sin(286*(pi/180))*(?f0 -10800)-cos(286*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f109" draw:formula="(cos(292*(pi/180))*(0-10800)+sin(292*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f110" draw:formula="-(sin(292*(pi/180))*(0-10800)-cos(292*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f111" draw:formula="(cos(298*(pi/180))*(?f0 -10800)+sin(298*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f112" draw:formula="-(sin(298*(pi/180))*(?f0 -10800)-cos(298*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f113" draw:formula="(cos(303*(pi/180))*(0-10800)+sin(303*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f114" draw:formula="-(sin(303*(pi/180))*(0-10800)-cos(303*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f115" draw:formula="(cos(309*(pi/180))*(?f0 -10800)+sin(309*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f116" draw:formula="-(sin(309*(pi/180))*(?f0 -10800)-cos(309*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f117" draw:formula="(cos(315*(pi/180))*(0-10800)+sin(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f118" draw:formula="-(sin(315*(pi/180))*(0-10800)-cos(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f119" draw:formula="(cos(320*(pi/180))*(?f0 -10800)+sin(320*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f120" draw:formula="-(sin(320*(pi/180))*(?f0 -10800)-cos(320*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f121" draw:formula="(cos(326*(pi/180))*(0-10800)+sin(326*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f122" draw:formula="-(sin(326*(pi/180))*(0-10800)-cos(326*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f123" draw:formula="(cos(331*(pi/180))*(?f0 -10800)+sin(331*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f124" draw:formula="-(sin(331*(pi/180))*(?f0 -10800)-cos(331*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f125" draw:formula="(cos(337*(pi/180))*(0-10800)+sin(337*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f126" draw:formula="-(sin(337*(pi/180))*(0-10800)-cos(337*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f127" draw:formula="(cos(343*(pi/180))*(?f0 -10800)+sin(343*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f128" draw:formula="-(sin(343*(pi/180))*(?f0 -10800)-cos(343*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f129" draw:formula="(cos(348*(pi/180))*(0-10800)+sin(348*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f130" draw:formula="-(sin(348*(pi/180))*(0-10800)-cos(348*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f131" draw:formula="(cos(354*(pi/180))*(?f0 -10800)+sin(354*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f132" draw:formula="-(sin(354*(pi/180))*(?f0 -10800)-cos(354*(pi/180))*(10800-10800))+10800"/><draw:handle draw:handle-position="$0 10800" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_mso_spt60("mso-spt60", "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"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f4 ?f4 ?f3 ?f3" draw:type="star4" draw:modifiers="8100" draw:enhanced-path="M 0 10800 L ?f4 ?f4 10800 0 ?f3 ?f4 21600 10800 ?f3 ?f3 10800 21600 ?f4 ?f3 0 10800 Z N"><draw:equation draw:name="f0" draw:formula="7600"/><draw:equation draw:name="f1" draw:formula="?f0 *$0 /10800"/><draw:equation draw:name="f2" draw:formula="?f0 -?f1 "/><draw:equation draw:name="f3" draw:formula="10800+?f2 "/><draw:equation draw:name="f4" draw:formula="10800-?f2 "/><draw:handle draw:handle-position="$0 10800" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_star4("star4", "H4sIAAAAAAAA/4WS3W6DIBSAX+WE9GoLEa3ZmqbUZNftHmB3ZIIlKWARW/v2Q0GzNs5dQIDDd77Dz6607Lbl+sT0Ny9xxY3izt6huVbbq+S3D9NRRIBAlr6R2CMYIMc7h5nlrKGoEDmEtu7buONec4oax2weV5QppZDcemSTTpkmfc3ciaKj16Vk43UHGBOHOYmCPJYTVqM0zkJkLGbc8wWfaL8LtkvLnDQ6uDVTvkYxliKMVe2ZUfTeHzRZQtJnpBAEXlYEkkG5DGdzMC5ECsvc+pkbXK+FyP4B81kQP4D+Fcozh19jXJtG9rkoWsWrRA9xy3TFcYeV1FK1yv+VP+KsC/HpbpL5n7f/AbV/6YySAgAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f1 ?f2 ?f3 ?f4" draw:type="star8" draw:modifiers="2700" draw:enhanced-path="M ?f5 ?f6 L ?f11 ?f12 ?f17 ?f18 ?f23 ?f24 ?f29 ?f30 ?f35 ?f36 ?f41 ?f42 ?f47 ?f48 ?f53 ?f54 ?f59 ?f60 ?f65 ?f66 ?f71 ?f72 ?f77 ?f78 ?f83 ?f84 ?f89 ?f90 ?f95 ?f96 ?f5 ?f6 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="(cos(315*(pi/180))*(?f0 -10800)+sin(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f2" draw:formula="-(sin(315*(pi/180))*(?f0 -10800)-cos(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f3" draw:formula="(cos(135*(pi/180))*(?f0 -10800)+sin(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f4" draw:formula="-(sin(135*(pi/180))*(?f0 -10800)-cos(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f5" draw:formula="(cos(0*(pi/180))*(0-10800)+sin(0*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f6" draw:formula="-(sin(0*(pi/180))*(0-10800)-cos(0*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f7" draw:formula="(cos(7*(pi/180))*(?f0 -10800)+sin(7*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f8" draw:formula="-(sin(7*(pi/180))*(?f0 -10800)-cos(7*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f9" draw:formula="(cos(15*(pi/180))*(0-10800)+sin(15*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f10" draw:formula="-(sin(15*(pi/180))*(0-10800)-cos(15*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f11" draw:formula="(cos(22*(pi/180))*(?f0 -10800)+sin(22*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f12" draw:formula="-(sin(22*(pi/180))*(?f0 -10800)-cos(22*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f13" draw:formula="(cos(30*(pi/180))*(0-10800)+sin(30*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f14" draw:formula="-(sin(30*(pi/180))*(0-10800)-cos(30*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f15" draw:formula="(cos(37*(pi/180))*(?f0 -10800)+sin(37*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f16" draw:formula="-(sin(37*(pi/180))*(?f0 -10800)-cos(37*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f17" draw:formula="(cos(45*(pi/180))*(0-10800)+sin(45*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f18" draw:formula="-(sin(45*(pi/180))*(0-10800)-cos(45*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f19" draw:formula="(cos(52*(pi/180))*(?f0 -10800)+sin(52*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f20" draw:formula="-(sin(52*(pi/180))*(?f0 -10800)-cos(52*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f21" draw:formula="(cos(60*(pi/180))*(0-10800)+sin(60*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f22" draw:formula="-(sin(60*(pi/180))*(0-10800)-cos(60*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f23" draw:formula="(cos(67*(pi/180))*(?f0 -10800)+sin(67*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f24" draw:formula="-(sin(67*(pi/180))*(?f0 -10800)-cos(67*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f25" draw:formula="(cos(75*(pi/180))*(0-10800)+sin(75*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f26" draw:formula="-(sin(75*(pi/180))*(0-10800)-cos(75*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f27" draw:formula="(cos(82*(pi/180))*(?f0 -10800)+sin(82*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f28" draw:formula="-(sin(82*(pi/180))*(?f0 -10800)-cos(82*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f29" draw:formula="(cos(90*(pi/180))*(0-10800)+sin(90*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f30" draw:formula="-(sin(90*(pi/180))*(0-10800)-cos(90*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f31" draw:formula="(cos(97*(pi/180))*(?f0 -10800)+sin(97*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f32" draw:formula="-(sin(97*(pi/180))*(?f0 -10800)-cos(97*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f33" draw:formula="(cos(105*(pi/180))*(0-10800)+sin(105*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f34" draw:formula="-(sin(105*(pi/180))*(0-10800)-cos(105*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f35" draw:formula="(cos(112*(pi/180))*(?f0 -10800)+sin(112*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f36" draw:formula="-(sin(112*(pi/180))*(?f0 -10800)-cos(112*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f37" draw:formula="(cos(120*(pi/180))*(0-10800)+sin(120*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f38" draw:formula="-(sin(120*(pi/180))*(0-10800)-cos(120*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f39" draw:formula="(cos(127*(pi/180))*(?f0 -10800)+sin(127*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f40" draw:formula="-(sin(127*(pi/180))*(?f0 -10800)-cos(127*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f41" draw:formula="(cos(135*(pi/180))*(0-10800)+sin(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f42" draw:formula="-(sin(135*(pi/180))*(0-10800)-cos(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f43" draw:formula="(cos(142*(pi/180))*(?f0 -10800)+sin(142*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f44" draw:formula="-(sin(142*(pi/180))*(?f0 -10800)-cos(142*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f45" draw:formula="(cos(150*(pi/180))*(0-10800)+sin(150*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f46" draw:formula="-(sin(150*(pi/180))*(0-10800)-cos(150*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f47" draw:formula="(cos(157*(pi/180))*(?f0 -10800)+sin(157*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f48" draw:formula="-(sin(157*(pi/180))*(?f0 -10800)-cos(157*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f49" draw:formula="(cos(165*(pi/180))*(0-10800)+sin(165*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f50" draw:formula="-(sin(165*(pi/180))*(0-10800)-cos(165*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f51" draw:formula="(cos(172*(pi/180))*(?f0 -10800)+sin(172*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f52" draw:formula="-(sin(172*(pi/180))*(?f0 -10800)-cos(172*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f53" draw:formula="(cos(180*(pi/180))*(0-10800)+sin(180*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f54" draw:formula="-(sin(180*(pi/180))*(0-10800)-cos(180*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f55" draw:formula="(cos(187*(pi/180))*(?f0 -10800)+sin(187*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f56" draw:formula="-(sin(187*(pi/180))*(?f0 -10800)-cos(187*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f57" draw:formula="(cos(195*(pi/180))*(0-10800)+sin(195*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f58" draw:formula="-(sin(195*(pi/180))*(0-10800)-cos(195*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f59" draw:formula="(cos(202*(pi/180))*(?f0 -10800)+sin(202*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f60" draw:formula="-(sin(202*(pi/180))*(?f0 -10800)-cos(202*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f61" draw:formula="(cos(210*(pi/180))*(0-10800)+sin(210*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f62" draw:formula="-(sin(210*(pi/180))*(0-10800)-cos(210*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f63" draw:formula="(cos(217*(pi/180))*(?f0 -10800)+sin(217*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f64" draw:formula="-(sin(217*(pi/180))*(?f0 -10800)-cos(217*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f65" draw:formula="(cos(225*(pi/180))*(0-10800)+sin(225*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f66" draw:formula="-(sin(225*(pi/180))*(0-10800)-cos(225*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f67" draw:formula="(cos(232*(pi/180))*(?f0 -10800)+sin(232*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f68" draw:formula="-(sin(232*(pi/180))*(?f0 -10800)-cos(232*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f69" draw:formula="(cos(240*(pi/180))*(0-10800)+sin(240*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f70" draw:formula="-(sin(240*(pi/180))*(0-10800)-cos(240*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f71" draw:formula="(cos(247*(pi/180))*(?f0 -10800)+sin(247*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f72" draw:formula="-(sin(247*(pi/180))*(?f0 -10800)-cos(247*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f73" draw:formula="(cos(255*(pi/180))*(0-10800)+sin(255*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f74" draw:formula="-(sin(255*(pi/180))*(0-10800)-cos(255*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f75" draw:formula="(cos(262*(pi/180))*(?f0 -10800)+sin(262*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f76" draw:formula="-(sin(262*(pi/180))*(?f0 -10800)-cos(262*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f77" draw:formula="(cos(270*(pi/180))*(0-10800)+sin(270*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f78" draw:formula="-(sin(270*(pi/180))*(0-10800)-cos(270*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f79" draw:formula="(cos(277*(pi/180))*(?f0 -10800)+sin(277*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f80" draw:formula="-(sin(277*(pi/180))*(?f0 -10800)-cos(277*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f81" draw:formula="(cos(285*(pi/180))*(0-10800)+sin(285*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f82" draw:formula="-(sin(285*(pi/180))*(0-10800)-cos(285*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f83" draw:formula="(cos(292*(pi/180))*(?f0 -10800)+sin(292*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f84" draw:formula="-(sin(292*(pi/180))*(?f0 -10800)-cos(292*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f85" draw:formula="(cos(300*(pi/180))*(0-10800)+sin(300*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f86" draw:formula="-(sin(300*(pi/180))*(0-10800)-cos(300*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f87" draw:formula="(cos(307*(pi/180))*(?f0 -10800)+sin(307*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f88" draw:formula="-(sin(307*(pi/180))*(?f0 -10800)-cos(307*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f89" draw:formula="(cos(315*(pi/180))*(0-10800)+sin(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f90" draw:formula="-(sin(315*(pi/180))*(0-10800)-cos(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f91" draw:formula="(cos(322*(pi/180))*(?f0 -10800)+sin(322*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f92" draw:formula="-(sin(322*(pi/180))*(?f0 -10800)-cos(322*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f93" draw:formula="(cos(330*(pi/180))*(0-10800)+sin(330*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f94" draw:formula="-(sin(330*(pi/180))*(0-10800)-cos(330*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f95" draw:formula="(cos(337*(pi/180))*(?f0 -10800)+sin(337*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f96" draw:formula="-(sin(337*(pi/180))*(?f0 -10800)-cos(337*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f97" draw:formula="(cos(345*(pi/180))*(0-10800)+sin(345*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f98" draw:formula="-(sin(345*(pi/180))*(0-10800)-cos(345*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f99" draw:formula="(cos(352*(pi/180))*(?f0 -10800)+sin(352*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f100" draw:formula="-(sin(352*(pi/180))*(?f0 -10800)-cos(352*(pi/180))*(10800-10800))+10800"/><draw:handle draw:handle-position="$0 10800" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800"/></draw:enhanced-geometry>
    oo_star8("star8", "H4sIAAAAAAAA/62a0W7bOBBFf0Uw9sFpMQgpiSJZ1A2wz9t+wL4JjZwIqO2s7bTp369pp0EizZ1iMH2wE4ShziWcexDL8/F23//4MGzv++3X4Zbuht1mOO5/Vofvdx++j8OPv3dPq4WrXFX7zj0/L6rzpuPwdKR+P/SH1eJm7aubdX16NKdH++s3fj4Mq8Xh2O/T8082u9txPQ7705Y6vlzpBf/QH+9Xi8+nS4TTo6v+OT37cmVfLu1jeUoFVCh1W55yYbryVLY0XcGXHW3Z0ZYdbdkRyo5QdoSyoys7ujOk7IhlRyw7YtkRy45UdqSyI5UduezIZUfuXvL9W31ZfPp4OcN/j/1x3G0vJ9r2m9PJ178OuN7tN4/f+tXiL1ctrqUdfrpj+XV3WDY+vFs+jNc+uaurd8ubtavIu+Tc1fvDuJ0un1ee16/en7/K0HoKpSVz2VdUYkKpqQ17VN+IR50sq6Etf1RMJSaUmhrYo7rX13SvT+lMtI4/I4ujWRA1LrKHi9KrGE3AxJ8PEWkWR03M/J9qgC+gsRp+Jo7nP1OWSPMweiIvnrqWXsa3q3om8A6E0jySHsprp8FlbGz18EA5PJHmYfREXjeNWMnG1hAPpAOhNI+kh/LqaXEvW2NLgHp4Is3D6Im8eoLYy2CrSA3sA6E0j6SH8gLqcC87W0tqYB+eSPMweiKvnk7sZWerSA3sA6E0j6SH8gKKuJfR+A8ssA9PpHkYPZFXTxJ7mYwVAfaBUJpH0kN5AWXcy2xrSQPswxNpHkZP5NWTxV5mW0UaYB8IpXkkPRS85XLCP7LO+CYPveHimcTk0TN5/XgvlnOyrKcCB2EsMan0WF5EvsYFnazpkcBDgElMHj0TvAWrxZJOltXUFr0Pg1hiUumxvJAmdyHevqbW+yLAR4D5R+6KtEBHrdzT1laYFhkJYolJpccCKQWhp8HWmRYZiWcSk0fPBDoKck+DsTDISBBLTCo9FkipE3raGe8kIiPxTGLy6JlAR1HuabQVJiAjQSwxqfRYIKUk9DTZOhOQkXgmMXn0TKCjJPc02QoTkJEglphUeiyQUhZ6mo2dQUbimcTk0TN5HdVOvonrbIXpgJEwlphUeiy4Ye1xTydreiS6X80zicmjZ/I6qr3Y08myngqMhLHEpNJjeSnVNe7pZE2PBEYCTGLy6Jm8jupG7mljLAwwEsYSk0qPBVJqhZ62xg8kkZF4JjF59Eygo1buaWsrTERGglhiUumxQEpB6GmwdSYiI/FMYvLomUBHndzTzlaYiIwEscSk0mOBlKLQ02jsDDISzyQmj54JdBTlnkZbYRIyEsQSk0qPBVJKQk+TrTMJGYlnEpNHzwQ6ynJPs60wCRkJYolJpceCD/edNMBg60xCn+3zTGLy6Jm8jhonDzE4Y2GAkTCWmFR6LC+lRhgwsg7fZWAkwPwjA38ZDDfKQ0aNceAno+lGeczIjAVzRtKgkXHuJ6NJI2nUyMoEOvrNsJFx8CcjI/1m3MiKBVISBo4a4/xPRkYSRo7MTKAjeeioMQ4AeYeUJM8dKbj3/fb221C9+p4edoexRDmPZl9++836vt/eDfREm3E7bh43qwVa758u6y/E68tRp5P1n/4HG63aqnIvAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800" draw:text-areas="?f52 ?f52 ?f53 ?f53" draw:type="sun" draw:modifiers="5400" draw:enhanced-path="M 0 10800 L ?f4 ?f8 ?f4 ?f9 Z N M ?f10 ?f11 L ?f12 ?f13 ?f14 ?f15 Z N M ?f16 ?f17 L ?f18 ?f19 ?f20 ?f21 Z N M ?f22 ?f23 L ?f24 ?f25 ?f26 ?f27 Z N M ?f28 ?f29 L ?f30 ?f31 ?f32 ?f33 Z N M ?f34 ?f35 L ?f36 ?f37 ?f38 ?f39 Z N M ?f40 ?f41 L ?f42 ?f43 ?f44 ?f45 Z N M ?f46 ?f47 L ?f48 ?f49 ?f50 ?f51 Z N U 10800 10800 ?f54 ?f54 0 360 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="21600-$0 "/><draw:equation draw:name="f2" draw:formula="$0 -2700"/><draw:equation draw:name="f3" draw:formula="?f2 *5080/7425"/><draw:equation draw:name="f4" draw:formula="?f3 +2540"/><draw:equation draw:name="f5" draw:formula="10125-$0 "/><draw:equation draw:name="f6" draw:formula="?f5 *2120/7425"/><draw:equation draw:name="f7" draw:formula="?f6 +210"/><draw:equation draw:name="f8" draw:formula="10800+?f7 "/><draw:equation draw:name="f9" draw:formula="10800-?f7 "/><draw:equation draw:name="f10" draw:formula="(cos(45*(pi/180))*(0-10800)+sin(45*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f11" draw:formula="-(sin(45*(pi/180))*(0-10800)-cos(45*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f12" draw:formula="(cos(45*(pi/180))*(?f4 -10800)+sin(45*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f13" draw:formula="-(sin(45*(pi/180))*(?f4 -10800)-cos(45*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f14" draw:formula="(cos(45*(pi/180))*(?f4 -10800)+sin(45*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f15" draw:formula="-(sin(45*(pi/180))*(?f4 -10800)-cos(45*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f16" draw:formula="(cos(90*(pi/180))*(0-10800)+sin(90*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f17" draw:formula="-(sin(90*(pi/180))*(0-10800)-cos(90*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f18" draw:formula="(cos(90*(pi/180))*(?f4 -10800)+sin(90*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f19" draw:formula="-(sin(90*(pi/180))*(?f4 -10800)-cos(90*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f20" draw:formula="(cos(90*(pi/180))*(?f4 -10800)+sin(90*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f21" draw:formula="-(sin(90*(pi/180))*(?f4 -10800)-cos(90*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f22" draw:formula="(cos(135*(pi/180))*(0-10800)+sin(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f23" draw:formula="-(sin(135*(pi/180))*(0-10800)-cos(135*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f24" draw:formula="(cos(135*(pi/180))*(?f4 -10800)+sin(135*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f25" draw:formula="-(sin(135*(pi/180))*(?f4 -10800)-cos(135*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f26" draw:formula="(cos(135*(pi/180))*(?f4 -10800)+sin(135*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f27" draw:formula="-(sin(135*(pi/180))*(?f4 -10800)-cos(135*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f28" draw:formula="(cos(180*(pi/180))*(0-10800)+sin(180*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f29" draw:formula="-(sin(180*(pi/180))*(0-10800)-cos(180*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f30" draw:formula="(cos(180*(pi/180))*(?f4 -10800)+sin(180*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f31" draw:formula="-(sin(180*(pi/180))*(?f4 -10800)-cos(180*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f32" draw:formula="(cos(180*(pi/180))*(?f4 -10800)+sin(180*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f33" draw:formula="-(sin(180*(pi/180))*(?f4 -10800)-cos(180*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f34" draw:formula="(cos(225*(pi/180))*(0-10800)+sin(225*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f35" draw:formula="-(sin(225*(pi/180))*(0-10800)-cos(225*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f36" draw:formula="(cos(225*(pi/180))*(?f4 -10800)+sin(225*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f37" draw:formula="-(sin(225*(pi/180))*(?f4 -10800)-cos(225*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f38" draw:formula="(cos(225*(pi/180))*(?f4 -10800)+sin(225*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f39" draw:formula="-(sin(225*(pi/180))*(?f4 -10800)-cos(225*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f40" draw:formula="(cos(270*(pi/180))*(0-10800)+sin(270*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f41" draw:formula="-(sin(270*(pi/180))*(0-10800)-cos(270*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f42" draw:formula="(cos(270*(pi/180))*(?f4 -10800)+sin(270*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f43" draw:formula="-(sin(270*(pi/180))*(?f4 -10800)-cos(270*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f44" draw:formula="(cos(270*(pi/180))*(?f4 -10800)+sin(270*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f45" draw:formula="-(sin(270*(pi/180))*(?f4 -10800)-cos(270*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f46" draw:formula="(cos(315*(pi/180))*(0-10800)+sin(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f47" draw:formula="-(sin(315*(pi/180))*(0-10800)-cos(315*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f48" draw:formula="(cos(315*(pi/180))*(?f4 -10800)+sin(315*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f49" draw:formula="-(sin(315*(pi/180))*(?f4 -10800)-cos(315*(pi/180))*(?f8 -10800))+10800"/><draw:equation draw:name="f50" draw:formula="(cos(315*(pi/180))*(?f4 -10800)+sin(315*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f51" draw:formula="-(sin(315*(pi/180))*(?f4 -10800)-cos(315*(pi/180))*(?f9 -10800))+10800"/><draw:equation draw:name="f52" draw:formula="(cos(45*(pi/180))*($0 -10800)+sin(45*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f53" draw:formula="(cos(225*(pi/180))*($0 -10800)+sin(225*(pi/180))*(10800-10800))+10800"/><draw:equation draw:name="f54" draw:formula="10800-$0 "/><draw:handle draw:handle-position="$0 10800" draw:handle-range-x-minimum="2700" draw:handle-range-x-maximum="10125"/></draw:enhanced-geometry>
    oo_sun("sun", "H4sIAAAAAAAA/6VZy27iQBD8FcvaAw+N8LwwRCGR9rzZ2172ZgVDLAWb5ZGQv99pD6/MdEM6HDIhTFdXl6dcJM79dFW835X1S1E/l1MxL5tFuVl9JOu3+d1bVb7/bHaTNEuyRMlhtl/TpAXNX7elWDZVvVlPUpmNMijLEv/Kr2cg/84euil3G1GsysIhH2dWJYdFt8uh6mNZTtL1tt7/vGim1awqVw5kzbHXcfZlsXmZpE/HEX65XsZ9jfbfx8nf5Hfy5F7JDBbZVkjglcAroUjaU9UQltxXQRM5dosCrJLHKgV4pdsqBR2UhQWwKj9VAV6N2yoNHbSEBbBaH6s04LX1VdBB57AAVp+mN4A3fnoDHQxMbwBrTtMbwBs/vWkvAUxvAWv99H8+HZV72/glS/Qwg4r04d5f4X/bYlM1tb/edbFwpzI7XP5Zs1psX4tJ+iNL0sElhAwRrS/EVZxCmITKnQEuwnQIcweQ9KwTO8iNspfBJgbrpK+c7S7jbIiTmVT2usZhzGeTnpLqK8PmMXjohpVXZh3Fszoj9B9n+ZVhxyhQXAfKyDSd52bdMbbXWVYDOcq63V4nE227bn9d1cGW5/Hb3b4PlMuEkedEJ257aCniYfiMkVsRiZBHtEpILBZl5HRM5BknopPNGd0g35A55lFG99Z3ZDI5o/uylTnOSMN+3uLbJ7qXvUicUcTD8BmjGEAkhicZ7jLNEwUIJjI8yds4FR49PJk88ygifHgymZx4/EhNR2ywxzaQIuKH4BTIPHxOPH6CtuFxRttMCxEBRLNiWtmseARxpTJtRMQQVyqTFY8i14027+i29FNEFBGcApmHzanxKAraRicabvNspIkwolkxrWxWIo6YUnk20lQgMaUyWfFIUopO3mCPbyQikAhOgczD58TjKGgbnmi0zbQREUc0K6aVzYrHEVcq00ZEIHGl8lgNHknuj2zavPltKWiIQCI4BTIPnxOPo6BtdKLhNs9GhogjmhXTymYl4ogplWkjKpCYUpmseCRpSSdvsMc3EhFIBKdA5uFz4nEUtA1PNNpm2oiII5oV08pltXgccaXybGSJQOJKZbJ+5XkRPPAkn6OwjWSjQMI+1wLOW39vsFEe+RbnT0Zfinr6WiZnr8WyWVfQq33o62k+7a+Kel6KnVhUdbXYLiZp+1wYLyl2vqR9JAukAz9u+L+Ph/85SF9YFBkAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="?f0 0 ?f1 10800 0 21600 10800 21600 21600 21600 ?f7 10800" draw:text-areas="?f1 10800 ?f2 18000 ?f3 7200 ?f4 21600" draw:type="isosceles-triangle" draw:modifiers="10800" draw:enhanced-path="M ?f0 0 L 21600 21600 0 21600 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$0 /2"/><draw:equation draw:name="f2" draw:formula="?f1 +10800"/><draw:equation draw:name="f3" draw:formula="$0 *2/3"/><draw:equation draw:name="f4" draw:formula="?f3 +7200"/><draw:equation draw:name="f5" draw:formula="21600-?f0 "/><draw:equation draw:name="f6" draw:formula="?f5 /2"/><draw:equation draw:name="f7" draw:formula="21600-?f6 "/><draw:handle draw:handle-position="$0 top" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="21600"/></draw:enhanced-geometry>
    oo_isosceles_triangle("isosceles-triangle", "H4sIAAAAAAAA/4WT326DIBTGX4WQXa0h/mvt0tSa7HrbA+yO1IMlEXCIrX37oeiqrXU3eMzh932Hw2GfaXrZgTxReYSM5KAEGH1F1TnfnTlc3lWTYB/5KAxiv18x6qC8qIGUiktTJThl7aaUBSjw3/wb4P5GcL+mbOtyvZiBxhCqgXZag0rKQhTYoI0itA27YD2pwlxLSDCvVHWEAipiNKcyL6BPC5VxxkFb2bHd34FLak4J/kSu/o9JjcP3G33hw95xPzU1XEmnIqmw3mwQZUqLuqAJfvER9paIYIbwwmUmvGfaNq3coRbBaMbsNfSiZWr9aBehVXsFy9zmnut6SNr+LoPxo+Hm36Zsn7nFNzd701kBaBTbqa14q9X1wqgST7LaDhCQhgguuaiFnf8nedq4vJtH6+fNv6bDL8Hlx2RmAwAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="0 ?f0 21600 21600" draw:type="up-arrow-callout" draw:modifiers="7565 5400 5400 8100" draw:enhanced-path="M 21600 ?f0 L 21600 21600 0 21600 0 ?f0 ?f3 ?f0 ?f3 ?f2 ?f1 ?f2 10800 0 ?f4 ?f2 ?f5 ?f2 ?f5 ?f0 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="21600-?f1 "/><draw:equation draw:name="f5" draw:formula="21600-?f3 "/><draw:handle draw:handle-position="left $0" draw:handle-range-y-minimum="$2" draw:handle-range-y-maximum="21600"/><draw:handle draw:handle-position="$3 $2" draw:handle-range-x-minimum="$1" draw:handle-range-x-maximum="10800" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="$0"/><draw:handle draw:handle-position="$1 top" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="$3"/></draw:enhanced-geometry>
    oo_up_arrow_callout("up-arrow-callout", "H4sIAAAAAAAA/42T246DIBCGX4UQb0nFQ7dpapvs9e4+wN6RipZEwEWs+vYLHrpk1doLGeP83/zDCKdUkeZIxY2IK01RTiWnWnWguufHO6PNu2wT6AMfBHjvjysEPaRpqxFRlFRWcckWNV1JE1iXRqdkg66kKGStxySXKcsYVYZ/i/cxiCND98sBPyo8WiuJviXwczSxdh+uIfiLNnfJQicG5sF9xP5h1ETj99iJPvgGX/B8Gpx/aqKZFEMfgnCzk2xqK5OK1wVJoOcDuHtG4BmBN4hgRgQbRDgjwg0i+k/0w0N2TM/BeA10HM0fSwsKnHdUyorZWgksaKaBN81xTCsicoo6xJlgvOZ2yysC0g6C4ZS95GiGsVyudfzwimDy6w/ORtNr+amG92rDGGhZbnS8aOY07IXWbLd8v8+/YaLCwPgDAAA="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="?f0 ?f8 ?f2 ?f9" draw:type="up-down-arrow" draw:modifiers="5400 10800" draw:enhanced-path="M 0 ?f1 L 10800 0 21600 ?f1 ?f2 ?f1 ?f2 ?f3 21600 ?f3 10800 21600 0 ?f3 ?f0 ?f3 ?f0 ?f1 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="21600-$0 "/><draw:equation draw:name="f3" draw:formula="21600-$1 "/><draw:equation draw:name="f4" draw:formula="10800-$1 "/><draw:equation draw:name="f5" draw:formula="$0 *?f4 /10800"/><draw:equation draw:name="f6" draw:formula="21600-?f5 "/><draw:equation draw:name="f7" draw:formula="10800-$0 "/><draw:equation draw:name="f8" draw:formula="$1 *?f7 /10800"/><draw:equation draw:name="f9" draw:formula="21600-?f8 "/><draw:handle draw:handle-position="$0 $1" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="10800" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="10800"/></draw:enhanced-geometry>
    oo_up_down_arrow("up-down-arrow", "H4sIAAAAAAAA/42T326DIBTGX4WQXi0h/m9tU2uy620PsDsywZIUcKhV334o6rpOSy8Q5JzvfL8c4Jgp3ByIOGPxRTKUE8lJpTpQXvPDlZHmVbYJdIELfG/rjl8IBlFF2gphRXCZwJS6IKWxHr4e+ymjK0gC6wJlshE6VclmjHCZMcqI0tIo1HU9N57rzjAFrs4JfAd9aQ+8maQZpd8zdtMczJFgzDX/ZscgTrMHPsEHPB2N43eNKyaF8ReYa2o64VCpeH3BCdy4ADqPFN4/hWdR+PeKARhZnYIVnc0vvNcNbbLrooVevKQ0BI45uIfi7TJsSiOL626F1tadeOEcNO3uKdr9Gm3866rvZ3Yh4GaNClmyvtbQms10E8agwiInqEWcCcZrrh/UShy3Jn77HP7kdJYa3X0NjewsP/HTD6dZHgP7AwAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="0 ?f0 21600 ?f4" draw:type="up-down-arrow-callout" draw:modifiers="5603 5500 5400 8100" draw:enhanced-path="M 0 ?f0 L 0 ?f4 ?f3 ?f4 ?f3 ?f6 ?f1 ?f6 10800 21600 ?f5 ?f6 ?f7 ?f6 ?f7 ?f4 21600 ?f4 21600 ?f0 ?f7 ?f0 ?f7 ?f2 ?f5 ?f2 10800 0 ?f1 ?f2 ?f3 ?f2 ?f3 ?f0 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="$1 "/><draw:equation draw:name="f2" draw:formula="$2 "/><draw:equation draw:name="f3" draw:formula="$3 "/><draw:equation draw:name="f4" draw:formula="21600-?f0 "/><draw:equation draw:name="f5" draw:formula="21600-?f1 "/><draw:equation draw:name="f6" draw:formula="21600-?f2 "/><draw:equation draw:name="f7" draw:formula="21600-?f3 "/><draw:handle draw:handle-position="left $0" draw:handle-range-y-minimum="$2" draw:handle-range-y-maximum="10800"/><draw:handle draw:handle-position="$3 $2" draw:handle-range-x-minimum="$1" draw:handle-range-x-maximum="10800" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="$0"/><draw:handle draw:handle-position="$1 top" draw:handle-range-x-minimum="0" draw:handle-range-x-maximum="$3"/></draw:enhanced-geometry>
    oo_up_down_arrow_callout("up-down-arrow-callout", "H4sIAAAAAAAA/41U3W7CIBR+FUJ6S4T+aYzVZNfbHmB3xFIlKVCR2vr2oy1oN631Ag4J3985Jd3kmjZrJo9U7lmODkwJZvQVnC+H9YWz5kO1GcQAg5Ck2O0Q9CTDWoOoZvTcIXaFx+yK2COuFctgXaFcNdJCtWrQnpalqo1DCJXzgjNtJZIURyBJrEAS221Fbka3dBU1xwx+gcHts6+xXdGopnaRvhK8wvdMibtbjmp8T3w7YXfna+i4odPDTj90fr5i8AO+4XYzJD7V1HAlh/ySCjuGwrdTKC3qkmYwwAAuXjHIA4PMMMIHRjjDiB4Y0Qwj/s/oR4e6EbwmJlPEua7SKeJcc8sp4qhH+7bykoHRGVXqzDutDJasMCDwX85dayoPDF2R4JKLWnRDngDQdgD0T+c9Rzv+53LtyI9MAP76vQ49de81gncDE2BUNZP4qdkocBB1ZovnP6PtLx4WkLSlBAAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:path-stretchpoint-x="11000" draw:path-stretchpoint-y="10800" draw:text-areas="?f0 ?f0 ?f3 ?f12" draw:type="vertical-scroll" draw:modifiers="2700" draw:enhanced-path="M ?f1 21600 X 0 ?f11 ?f1 ?f12 L ?f0 ?f12 ?f0 ?f1 Y ?f4 0 L ?f2 0 X 21600 ?f1 ?f2 ?f0 L ?f3 ?f0 ?f3 ?f11 Y ?f5 21600 Z N M ?f6 ?f1 Y ?f4 ?f0 X ?f8 ?f9 ?f4 ?f1 Z N M ?f0 ?f11 Y ?f1 21600 0 ?f11 ?f1 ?f12 X ?f9 ?f10 ?f1 ?f11 Z N M ?f4 0 X ?f6 ?f1 N M ?f0 ?f12 L ?f0 ?f11 N M ?f4 ?f0 L ?f2 ?f0 N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="?f0 /2"/><draw:equation draw:name="f2" draw:formula="right-?f1 "/><draw:equation draw:name="f3" draw:formula="right-?f0 "/><draw:equation draw:name="f4" draw:formula="?f0 +?f1 "/><draw:equation draw:name="f5" draw:formula="right-?f4 "/><draw:equation draw:name="f6" draw:formula="?f0 *2"/><draw:equation draw:name="f7" draw:formula="?f1 /2"/><draw:equation draw:name="f8" draw:formula="?f0 +?f7 "/><draw:equation draw:name="f9" draw:formula="?f1 +?f7 "/><draw:equation draw:name="f10" draw:formula="bottom-?f9 "/><draw:equation draw:name="f11" draw:formula="bottom-?f1 "/><draw:equation draw:name="f12" draw:formula="bottom-?f0 "/><draw:equation draw:name="f13" draw:formula="bottom-?f4 "/><draw:handle draw:handle-position="left $0" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="5400"/></draw:enhanced-geometry>
    oo_vertical_scroll("vertical-scroll", "H4sIAAAAAAAA/42UXW+DIBSG/wohvdpCKtZ+pnbJrrted7tjFlsSFYf0w38/KMhMrbILCJH3Oe85xxPWB0GuK1qcSJHQAzpSnlMpalBdjqsLo9d3fothAAIQ4llgdwjuUEnkCVVSUJmcSs4KiZQU42BAUCtBsHACSW8SEUFJFcO3NABmTdTCYSOpSxrDCxWSJSRDVSJ4ltm7nB9YyqhQdDh3QV0t2j6GHzqazX4PdHyM75+0CdhaT3W0B/Cp9kgJ9VUINGRgwxjd1qbp0jXY1Eq/wA5o31kroBbv1b5Qa2m/YKcM/oI0yT6murcgblLBf3gETHBj2ArZqhA7bVOBqWUHN2vTuJ8zkYwXpo0FyVXj06arKRf5OSMxHAUAjocI/Ehok3E4DIWPkGDHk0S6mmFw0gf60oyepfnqN5z2GUYecPbM8MXTl3kXwt5mLnpKm3syXD4z+weHO0PyzaXkOdID60E70+JQ34/AnZlxqHdEO1Pj0NZfVM/IIaOgdUYlr5iOFsOMphKMmsLttSDFkaIa5axg+TlXD2fPPbmZ+2mkni3lN37+Cm9+Af/8VGKeBQAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="?f18 ?f0 ?f20 10800 ?f19 ?f1 ?f21 10800" draw:text-areas="?f5 ?f22 ?f11 ?f23" draw:type="mso-spt64" draw:modifiers="2700 10800" draw:enhanced-path="M ?f7 ?f0 C ?f15 ?f9 ?f16 ?f10 ?f12 ?f0 L ?f24 ?f1 C ?f25 ?f26 ?f27 ?f28 ?f29 ?f1 Z N"><draw:equation draw:name="f0" draw:formula="$0 "/><draw:equation draw:name="f1" draw:formula="21600-?f0 "/><draw:equation draw:name="f2" draw:formula="$1 "/><draw:equation draw:name="f3" draw:formula="?f2 -10800"/><draw:equation draw:name="f4" draw:formula="?f3 *2"/><draw:equation draw:name="f5" draw:formula="abs(?f4 )"/><draw:equation draw:name="f6" draw:formula="4320-?f5 "/><draw:equation draw:name="f7" draw:formula="if(?f3 ,0,?f5 )"/><draw:equation draw:name="f8" draw:formula="15800*?f0 /4460"/><draw:equation draw:name="f9" draw:formula="?f0 -?f8 "/><draw:equation draw:name="f10" draw:formula="?f0 +?f8 "/><draw:equation draw:name="f11" draw:formula="21600-?f4 "/><draw:equation draw:name="f12" draw:formula="if(?f3 ,?f11 ,21600)"/><draw:equation draw:name="f13" draw:formula="?f12 -?f7 "/><draw:equation draw:name="f14" draw:formula="?f5 /2"/><draw:equation draw:name="f15" draw:formula="?f7 +7200-?f14 "/><draw:equation draw:name="f16" draw:formula="?f12 +?f14 -7200"/><draw:equation draw:name="f17" draw:formula="?f13 /2"/><draw:equation draw:name="f18" draw:formula="?f7 +?f17 "/><draw:equation draw:name="f19" draw:formula="21600-?f18 "/><draw:equation draw:name="f20" draw:formula="?f5 /2"/><draw:equation draw:name="f21" draw:formula="21600-?f20 "/><draw:equation draw:name="f22" draw:formula="?f0 *2"/><draw:equation draw:name="f23" draw:formula="21600-?f22 "/><draw:equation draw:name="f24" draw:formula="21600-?f7 "/><draw:equation draw:name="f25" draw:formula="21600-?f15 "/><draw:equation draw:name="f26" draw:formula="?f1 +?f8 "/><draw:equation draw:name="f27" draw:formula="21600-?f16 "/><draw:equation draw:name="f28" draw:formula="?f1 -?f8 "/><draw:equation draw:name="f29" draw:formula="21600-?f12 "/><draw:handle draw:handle-position="left $0" draw:handle-range-y-minimum="0" draw:handle-range-y-maximum="4460"/><draw:handle draw:handle-position="$1 21600" draw:handle-range-x-minimum="8640" draw:handle-range-x-maximum="12960"/></draw:enhanced-geometry>
    oo_mso_spt64("mso-spt64", "H4sIAAAAAAAA/42W3XKbMBCFX0XD5CKJrbG0/BhnQjzT3rZ9gN6ptXCYMeAATuy3r1YY10bA+sKMB+23Z3c5ErxuKvX1oot3VfzVG77VZa6b6sTqz+3LZ6a/vpXHxBNMMJCROF89ZqHt7qD5vsyKpk68dSpjtk6F+YFgUsQC/8oVXvCebO+d0UYfG64qrSwZYgBgpA31u6DTXideXpe83jdRcL6bl5sszXRlSFgKcZP20sZeNe+J99NkW9qivmNylLH1RHix5YFd/YGqga0UA8HWg0GANGBf0Dbym/3y3l5brY+DarKyaJULlZta066QtKzyw04l3oNg3mKKkH3CTphjWdMgOFKSIPw+YdpivJ3fJBi4oM+eYRoK+5D6Uz+u04A9TXNRnwt8wHmERHfLPpelj1jnXMwRJlTjPi1DM5ZnfAyLIIiIAa3cAQlmao6ph+/4BcHZHeCobQKKdHzTzcluv7nNQwxLDjjJbCWOu40gB6wUsgVhJel4CZVmS7AdS7Jlx1K23JlFOWYheMdahvTpqh1P2aoNS07J8VP3dCVlDBhwFD1gGLUTkMeQ4ye0MHU4gOOgiyBQgo6FOpQaKzg2uoyVOlxgyEL3bFRwvHPRjCh0wD/ynlMFxu1zNVzzptzsNLv6b97ldYbZEm+n04Y9dF46L1eq2Gp+4nlWZPkhN58FI+vq2K7fHJyTeubddf1lcZPw+F8wjoKxkE5TwqoVXQx/2Lz9A6kbzm3xCAAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 3160 3160 0 10800 3160 18440 10800 21600 18440 18440 21600 10800 18440 3160 ?f14 ?f15" draw:text-areas="3200 3200 18400 18400" draw:type="round-callout" draw:modifiers="6300 24300" draw:enhanced-path="W 0 0 21600 21600 ?f22 ?f23 ?f18 ?f19 L ?f14 ?f15 Z N"><draw:equation draw:name="f0" draw:formula="$0 -10800"/><draw:equation draw:name="f1" draw:formula="$1 -10800"/><draw:equation draw:name="f2" draw:formula="?f0 *?f0 "/><draw:equation draw:name="f3" draw:formula="?f1 *?f1 "/><draw:equation draw:name="f4" draw:formula="?f2 +?f3 "/><draw:equation draw:name="f5" draw:formula="sqrt(?f4 )"/><draw:equation draw:name="f6" draw:formula="?f5 -10800"/><draw:equation draw:name="f7" draw:formula="atan2(?f1 ,?f0 )/(pi/180)"/><draw:equation draw:name="f8" draw:formula="?f7 -10"/><draw:equation draw:name="f9" draw:formula="?f7 +10"/><draw:equation draw:name="f10" draw:formula="10800*cos(?f7 *(pi/180))"/><draw:equation draw:name="f11" draw:formula="10800*sin(?f7 *(pi/180))"/><draw:equation draw:name="f12" draw:formula="?f10 +10800"/><draw:equation draw:name="f13" draw:formula="?f11 +10800"/><draw:equation draw:name="f14" draw:formula="if(?f6 ,$0 ,?f12 )"/><draw:equation draw:name="f15" draw:formula="if(?f6 ,$1 ,?f13 )"/><draw:equation draw:name="f16" draw:formula="10800*cos(?f8 *(pi/180))"/><draw:equation draw:name="f17" draw:formula="10800*sin(?f8 *(pi/180))"/><draw:equation draw:name="f18" draw:formula="?f16 +10800"/><draw:equation draw:name="f19" draw:formula="?f17 +10800"/><draw:equation draw:name="f20" draw:formula="10800*cos(?f9 *(pi/180))"/><draw:equation draw:name="f21" draw:formula="10800*sin(?f9 *(pi/180))"/><draw:equation draw:name="f22" draw:formula="?f20 +10800"/><draw:equation draw:name="f23" draw:formula="?f21 +10800"/><draw:handle draw:handle-position="$0 $1"/></draw:enhanced-geometry>
    oo_round_callout("round-callout", "H4sIAAAAAAAA/5WVS4+CMBSF/0pDZuFjiL0FEY1oMuvJbCeZXSPFaYJUofj499MWcIwlgJsbKf1Oz20Pdh3n9LJi2S/Ndix290wcmMxvqDjvV2fOLh/iGjkYYUQgwHV1kIH2acnco+CZLCIHcIj1NE9NqApG1Zh5gND3m4FKqR4xtR4xb6sRA20T8HWZ1wtKdpUuzRlV63lES5MKaGoz73ZkkZOLMovdHU1TUcr6zUHEPOEsVwKBp6343p2678GRyt/I+UZPXSsnhOjiaU+hLkv0+W8S/aAvZ7OutE4llVxklXJGD8pP0iyUiPxQpjRy3jByTdPOrIsDi4NBHHnmtglGE126Oc/mQHPQw/k2R9B0m3g93PyZK065HG0TH427wcBecD5oZxbPIJU0IyPd4rven/FsdOQzCHGPgdA2sNAGuqllGzXto8CKj2l0shPFSAtMGss9nsGKU6VT8Ow1nZZ4AdZ99Ae6LWEwDLVCxhNlO0Dv6mNSZwekLzRgxe2uYE4fvF4FK3ePJxEO30Erho8n8YJOSwwhGLadLVmExSCUdOZxOdg96czjCzoteSTD8kha8kisPKrbIU4ZevitLr+CazXzV/4Geuqs/T7d/AEeLWjbaAcAAA=="),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:glue-points="10800 0 0 10800 10800 21600 21600 10800 ?f40 ?f41" draw:text-areas="0 0 21600 21600" draw:type="rectangular-callout" draw:modifiers="6300 24300" draw:enhanced-path="M 0 0 L 0 3590 ?f2 ?f3 0 8970 0 12630 ?f4 ?f5 0 18010 0 21600 3590 21600 ?f6 ?f7 8970 21600 12630 21600 ?f8 ?f9 18010 21600 21600 21600 21600 18010 ?f10 ?f11 21600 12630 21600 8970 ?f12 ?f13 21600 3590 21600 0 18010 0 ?f14 ?f15 12630 0 8970 0 ?f16 ?f17 3590 0 0 0 Z N"><draw:equation draw:name="f0" draw:formula="$0 -10800"/><draw:equation draw:name="f1" draw:formula="$1 -10800"/><draw:equation draw:name="f2" draw:formula="if(?f18 ,$0 ,0)"/><draw:equation draw:name="f3" draw:formula="if(?f18 ,$1 ,6280)"/><draw:equation draw:name="f4" draw:formula="if(?f23 ,$0 ,0)"/><draw:equation draw:name="f5" draw:formula="if(?f23 ,$1 ,15320)"/><draw:equation draw:name="f6" draw:formula="if(?f26 ,$0 ,6280)"/><draw:equation draw:name="f7" draw:formula="if(?f26 ,$1 ,21600)"/><draw:equation draw:name="f8" draw:formula="if(?f29 ,$0 ,15320)"/><draw:equation draw:name="f9" draw:formula="if(?f29 ,$1 ,21600)"/><draw:equation draw:name="f10" draw:formula="if(?f32 ,$0 ,21600)"/><draw:equation draw:name="f11" draw:formula="if(?f32 ,$1 ,15320)"/><draw:equation draw:name="f12" draw:formula="if(?f34 ,$0 ,21600)"/><draw:equation draw:name="f13" draw:formula="if(?f34 ,$1 ,6280)"/><draw:equation draw:name="f14" draw:formula="if(?f36 ,$0 ,15320)"/><draw:equation draw:name="f15" draw:formula="if(?f36 ,$1 ,0)"/><draw:equation draw:name="f16" draw:formula="if(?f38 ,$0 ,6280)"/><draw:equation draw:name="f17" draw:formula="if(?f38 ,$1 ,0)"/><draw:equation draw:name="f18" draw:formula="if($0 ,-1,?f19 )"/><draw:equation draw:name="f19" draw:formula="if(?f1 ,-1,?f22 )"/><draw:equation draw:name="f20" draw:formula="abs(?f0 )"/><draw:equation draw:name="f21" draw:formula="abs(?f1 )"/><draw:equation draw:name="f22" draw:formula="?f20 -?f21 "/><draw:equation draw:name="f23" draw:formula="if($0 ,-1,?f24 )"/><draw:equation draw:name="f24" draw:formula="if(?f1 ,?f22 ,-1)"/><draw:equation draw:name="f25" draw:formula="$1 -21600"/><draw:equation draw:name="f26" draw:formula="if(?f25 ,?f27 ,-1)"/><draw:equation draw:name="f27" draw:formula="if(?f0 ,-1,?f28 )"/><draw:equation draw:name="f28" draw:formula="?f21 -?f20 "/><draw:equation draw:name="f29" draw:formula="if(?f25 ,?f30 ,-1)"/><draw:equation draw:name="f30" draw:formula="if(?f0 ,?f28 ,-1)"/><draw:equation draw:name="f31" draw:formula="$0 -21600"/><draw:equation draw:name="f32" draw:formula="if(?f31 ,?f33 ,-1)"/><draw:equation draw:name="f33" draw:formula="if(?f1 ,?f22 ,-1)"/><draw:equation draw:name="f34" draw:formula="if(?f31 ,?f35 ,-1)"/><draw:equation draw:name="f35" draw:formula="if(?f1 ,-1,?f22 )"/><draw:equation draw:name="f36" draw:formula="if($1 ,-1,?f37 )"/><draw:equation draw:name="f37" draw:formula="if(?f0 ,?f28 ,-1)"/><draw:equation draw:name="f38" draw:formula="if($1 ,-1,?f39 )"/><draw:equation draw:name="f39" draw:formula="if(?f0 ,-1,?f28 )"/><draw:equation draw:name="f40" draw:formula="$0 "/><draw:equation draw:name="f41" draw:formula="$1 "/><draw:handle draw:handle-position="$0 $1"/></draw:enhanced-geometry>
    oo_rectangular_callout("rectangular-callout", "H4sIAAAAAAAA/5VX246bMBD9FQvloZWC1vZwXW02Up/bfkDfaGKySAmkhOzl7zu2CUmXcewqsgUx58yZ8WGAp21fvT2q9qVqN2ob71R3UEP/wU6vu8fXRr19695XEWecSZHxcY6YAe32ZxUfu6YdTqtI8ILryzizR3a+AY3/rOvETGIkGdT7EFe9qk6uMMPHUa2iXm2Gqt2d91Ufb6r9vjsP4/qh2zZ1o3okyEBjE5iwU17HanhZRT+MwO84IC21DIkD8LQocyNdIoNWhyPV5wUXV1EGYw/XdYYjt7gxPYO9LBc4yhF/W4R/CmJW17WdBMFj6HFNyxQwl3FViOtatEhH/JQS/qelitzi7O8X+xk9P9kK/TlXQ9O1tl5tdcBa15fy1V1/wIqvogVnsdm/6OEeTsxwIggnP+Oa+gtqLtgSAy/51/tocKMFW2ay8BEkJIGEsPCpG43hRQrSx5DRDJmNH5BA7iZACcYrHoaCZiithJAkSjdDoAYxs52hAGlFBFHMHHilCNwMQZsRkv9QQTvSUIQ5UtCWhCx8PwTtSxhN4YXTpoQi2JSCdiUUgQIoS+rQsVji3V0yH542pBgJpPQRyJkdq98nZOBe4MyEFii8wJn1UCd2XpwF80Apy03Vkok3NG04rJYpFdL4CGZ2073fPsfvAx3dLzWh85DQtNGm5Atv8jOrmYrHpvoeqKPtGfXAA9QD3fU4s9IDCOZPXR5UeXB0OrPpACGhHY/eYNeAo89ZCWkIA93mwm9zoPy3uOAh9+Kd7gvdP7LRTQK8jQ5oC4bbP6Fe9zwQ6k1vguA793av2M0xfiacGs1iuBdCX/pg6T9/eTz/BV6TJzWSDAAA"),

    // <draw:enhanced-geometry svg:viewBox="0 0 21600 21600" draw:text-areas="800 800 20800 20800" draw:type="round-rectangular-callout" draw:modifiers="6300 24300" draw:enhanced-path="M 3590 0 X 0 3590 L ?f2 ?f3 0 8970 0 12630 ?f4 ?f5 0 18010 Y 3590 21600 L ?f6 ?f7 8970 21600 12630 21600 ?f8 ?f9 18010 21600 X 21600 18010 L ?f10 ?f11 21600 12630 21600 8970 ?f12 ?f13 21600 3590 Y 18010 0 L ?f14 ?f15 12630 0 8970 0 ?f16 ?f17 Z N"><draw:equation draw:name="f0" draw:formula="$0 -10800"/><draw:equation draw:name="f1" draw:formula="$1 -10800"/><draw:equation draw:name="f2" draw:formula="if(?f18 ,$0 ,0)"/><draw:equation draw:name="f3" draw:formula="if(?f18 ,$1 ,6280)"/><draw:equation draw:name="f4" draw:formula="if(?f23 ,$0 ,0)"/><draw:equation draw:name="f5" draw:formula="if(?f23 ,$1 ,15320)"/><draw:equation draw:name="f6" draw:formula="if(?f26 ,$0 ,6280)"/><draw:equation draw:name="f7" draw:formula="if(?f26 ,$1 ,21600)"/><draw:equation draw:name="f8" draw:formula="if(?f29 ,$0 ,15320)"/><draw:equation draw:name="f9" draw:formula="if(?f29 ,$1 ,21600)"/><draw:equation draw:name="f10" draw:formula="if(?f32 ,$0 ,21600)"/><draw:equation draw:name="f11" draw:formula="if(?f32 ,$1 ,15320)"/><draw:equation draw:name="f12" draw:formula="if(?f34 ,$0 ,21600)"/><draw:equation draw:name="f13" draw:formula="if(?f34 ,$1 ,6280)"/><draw:equation draw:name="f14" draw:formula="if(?f36 ,$0 ,15320)"/><draw:equation draw:name="f15" draw:formula="if(?f36 ,$1 ,0)"/><draw:equation draw:name="f16" draw:formula="if(?f38 ,$0 ,6280)"/><draw:equation draw:name="f17" draw:formula="if(?f38 ,$1 ,0)"/><draw:equation draw:name="f18" draw:formula="if($0 ,-1,?f19 )"/><draw:equation draw:name="f19" draw:formula="if(?f1 ,-1,?f22 )"/><draw:equation draw:name="f20" draw:formula="abs(?f0 )"/><draw:equation draw:name="f21" draw:formula="abs(?f1 )"/><draw:equation draw:name="f22" draw:formula="?f20 -?f21 "/><draw:equation draw:name="f23" draw:formula="if($0 ,-1,?f24 )"/><draw:equation draw:name="f24" draw:formula="if(?f1 ,?f22 ,-1)"/><draw:equation draw:name="f25" draw:formula="$1 -21600"/><draw:equation draw:name="f26" draw:formula="if(?f25 ,?f27 ,-1)"/><draw:equation draw:name="f27" draw:formula="if(?f0 ,-1,?f28 )"/><draw:equation draw:name="f28" draw:formula="?f21 -?f20 "/><draw:equation draw:name="f29" draw:formula="if(?f25 ,?f30 ,-1)"/><draw:equation draw:name="f30" draw:formula="if(?f0 ,?f28 ,-1)"/><draw:equation draw:name="f31" draw:formula="$0 -21600"/><draw:equation draw:name="f32" draw:formula="if(?f31 ,?f33 ,-1)"/><draw:equation draw:name="f33" draw:formula="if(?f1 ,?f22 ,-1)"/><draw:equation draw:name="f34" draw:formula="if(?f31 ,?f35 ,-1)"/><draw:equation draw:name="f35" draw:formula="if(?f1 ,-1,?f22 )"/><draw:equation draw:name="f36" draw:formula="if($1 ,-1,?f37 )"/><draw:equation draw:name="f37" draw:formula="if(?f0 ,?f28 ,-1)"/><draw:equation draw:name="f38" draw:formula="if($1 ,-1,?f39 )"/><draw:equation draw:name="f39" draw:formula="if(?f0 ,-1,?f28 )"/><draw:equation draw:name="f40" draw:formula="$0 "/><draw:equation draw:name="f41" draw:formula="$1 "/><draw:handle draw:handle-position="$0 $1"/></draw:enhanced-geometry>
    oo_round_rectangular_callout("round-rectangular-callout", "H4sIAAAAAAAA/5VXy27bMBD8FULwoQUshMvVM4gSoOe256Q3xqYcAbbkynIef98lKatFRJnsgYK84swOl6OlfLft5dutal9ku1HbeKe6gxr6D3Z63d2+NurtW/deRZxxJiDj4zViBjSo9yGWvZKnKiromR6CT9fLrI+jqqK+O7fbuFebQba781728Ubu9915GGcdum1TN6onqgw1Q4ITwyTuKIeXKvrBMC21okca5vY7e6gFDaRAUeb6GQiioVBCI9W/Cw6cPdn5dikaldHILcYGLc7eP9QFjXLE2tjjZZ6JaQrQEwEceENLz7Q0wDFoBDyN+JFBi4R0xE5LoJiWBzn7xX5G93e2Fr/Pcmi61lamlQeqbX0pVN31B6ptFa04i8Hswc01HMxwEIQTn3FN/YWEFmxNidf863U0LqOBrTNR+AgSJ4HAsPTpMprSQ4rCx5C5GTKbP2AB+TIBSTA+8TAUbobSSghZRLnMEKgBZrYzFCisiCCKmQP/UgRuBrjNiMl/qHA70lCEORLclsQsfD/A7UscTeGFu02JRbApwe1KLAIFuCypU8ewpre7ZD6825AwEgjhIxAzO8rnEzFwL3BmQgsEL3BmPdJJnZeuwDxQl+WmaonEm9ptOKqWKRXR+AhmdtO9357u14EL3S81qfOQ1G6jTYsvvIufWc1UPDbV90AX2p5RjzxAPbq7HmdWegDB/NTlQZXHhU5nNh0xJPXC0RvsGlzoc1ZCGsLgbnPhrzm6/Le64DH34hfdF7p/zkY3CfA2OnRbMNz+ietzzwNxfelNEPq63u4V++c+PnanRrMY7hXoqTeW/vMfhfs/Eu5Nu0EMAAA="),

    // ---------------------------------------------------------------------------

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" svg:viewBox="0 0 21600 21600" draw:type="mso-spt32" draw:enhanced-path="M 0 0 L 21600 21600 N"></draw:enhanced-geometry>
    ooxml_straightConnector1("ooxml-straightConnector1", "H4sIAAAAAAAAAG2OQQrCMBBFrxKyD8YKLkrThWvrHUI7NoEmEyZDaj29KEEquPmL93jwu4ns2kJ0No4wqRkwANMmPjh4IiTlkPwTI9vFyLtdMsgfXYDYjzuZy9wWD+sFH0ZqoUVzPOu6NeUtgZEho8qJT02l3xvJsjNyEO/4us/FTfbd4f/n/gW6CTL0zAAAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f2 ?f3" svg:viewBox="0 0 0 0" draw:type="ooxml-bentConnector3" draw:modifiers="50000" draw:enhanced-path="M 0 0 L ?f0 0 ?f0 ?f3 ?f2 ?f3 F N"><draw:equation draw:name="f0" draw:formula="logwidth*$0 /100000"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f0 ?f1" draw:handle-range-x-maximum="2147483647" draw:handle-range-x-minimum="-2147483647"></draw:handle></draw:enhanced-geometry>
    ooxml_bentConnector3("ooxml-bentConnector3", "H4sIAAAAAAAAAJWS7WrDIBSGb0VkvwaSz62jxAw22K9t9+CSk0SInsyYj+7qZ2tT2rIMqgjiec/zvopZacS0Bd0IXUDJakAF1uzI4VhJY9CwBo38QW1Fy2kl2h7oRXkEY2VxXbQwWyYMiJ7TkITkuYrdSijpx3o7SphecPYVN5eeXQecIs6qZV+g7StqDYVFkyyOWMpKgnHMh9CN4/Epfidsw+nHAfru7LzxfiVLAPJGPmme+b7vQViJ2lO0UM69WqAVGjW0gtMW60mWtrm/C0kQhQffPAsuCP8Boz+ADci6sUF8EyheS3YTJVmNs4Zxj1u2QM72rMNe7hWc+udd7ngsG6FrYDNTYpZqUJzGUbpJn5LHdLMilNoL2ZlyieO1p3DXfzX/BViEYrDEAgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f5 ?f6" svg:viewBox="0 0 0 0" draw:type="ooxml-curvedConnector3" draw:modifiers="50000" draw:enhanced-path="M 0 0 C ?f1 0 ?f0 ?f7 ?f0 ?f4 ?f0 ?f3 ?f2 ?f6 ?f5 ?f6 F N"><draw:equation draw:name="f0" draw:formula="logwidth*$0 /100000"></draw:equation><draw:equation draw:name="f1" draw:formula="(0+?f0 )/2"></draw:equation><draw:equation draw:name="f2" draw:formula="(logwidth+?f0 )/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight*3/4"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/4"></draw:equation><draw:handle draw:handle-position="?f0 ?f4" draw:handle-range-x-maximum="2147483647" draw:handle-range-x-minimum="-2147483647"></draw:handle></draw:enhanced-geometry>
    ooxml_curvedConnector3("ooxml-curvedConnector3", "H4sIAAAAAAAAAJ2T7UrDMBSGbyUEf+gk9HOrjHWCA//pPYT2tA00OTNNu86rN/0ablqhJhxSct4+5z0h2aWan7agCq4SSFkOKMHoM+m3pdAaNStQi09UhpcxzXhZAb1KN6CNSG6TBlrDuAZexdQlLnnO1jY2lFRNvm0EnF6wHTJ2Tv+cjxBTxFaWLKl1A+kBlYLEoA6mmpiKTIC21LVrx7h9aeDITRHTtx57sAW9vnQX0biG4xrY8DtLkzXySt7pfjfwPmpuBKqBrri0vrKpWIZa1iWPaYn5SaSmWN25xPHc3s9+51wR/gJ6t8B797Ez9+D4izj+D87k7F+44Jc+CxB5YVaBEy5ChbOohZ7Wc2e/iLKZtbMIE813NXs89n6mJZBv3+yIlegUMR1vJr1Ka65yYC2TvBWyljH1vTAKn4JNGM0IhRqE7JtysjNoL+ZuH/z+C2qlF3sJBAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f5 ?f8 ?f6 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-ellipse" draw:enhanced-path="M 0 ?f7 Z N" drawooo:enhanced-path="M 0 ?f7 G ?f0 ?f2 ?f12 ?f13 ?f0 ?f2 ?f14 ?f15 ?f0 ?f2 ?f16 ?f17 ?f0 ?f2 ?f18 ?f19 Z N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 +0-?f1 "></draw:equation><draw:equation draw:name="f6" draw:formula="?f4 +?f1 -0"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f3 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f3 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f12" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(5400000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_ellipse("ooxml-ellipse", "H4sIAAAAAAAAAK2VXW+DIBSG/wrhynVxivWjbWqb7GZX2w/YHWlRSdTjkH7t1w80bdrhljGrAcmB8/geeYnLraCHBasLWm/Y1s0ZVEyKE+rCFRcChFuA4J9QS1qmOKNly/DN9J4JyTffJyU7SpcKRtsUr7MIrbOZarFqc4zafb7Yc3Z4hmOKfdTd57xTw1IMcKxKl5Ulby7Ei8iGyiLFryppnSXoHb31CwDgpzUvqtejQDXSddPrSKi76DqidZLkOqLVk3n3ttWy1/Oxo5JD3auraaV0Z+cyMhDVrqQpLiE/8K0svEDleTeJv3HId46WMtlA6zR84gSJr68Hj/izfmQFDwZEFoznhbRUOTVVBmjS8voeKsM7fcrIFBmiR99V+4msQPEgSGNc3wqU3Ov7z0xFSV/a1K60+SBIYyxLI0MHoK/NjmMcgPPu22EMqzsXM3qxfjxZ1mdY3onCMTzD5Q6JgzFAw+4jBRqud/5LMmw/Upnh/pE84xD8hecN/0BXX7yVBJdZBwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f1 ?f5 ?f4 ?f6" svg:viewBox="0 0 0 0" draw:type="ooxml-triangle" draw:modifiers="50000" draw:enhanced-path="M 0 ?f6 L ?f2 0 ?f7 ?f6 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*?f0 /200000"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth*?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f1 +?f3 -0"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f2 0" draw:handle-range-x-maximum="100000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_triangle("ooxml-triangle", "H4sIAAAAAAAAAJWTX2+CQAzAv8rlsoe5eRFQNDEiyZ63fYC9XaQHTe6PO07FffodoGwSMQFS0l7bX5vS22SWn9agC653kLEcjAJnz6Q5VmitsawwFn+MdlwmVHBZAr1xH8E63PWdDirHuAVeJjQVIUlF7GXhZUlJeczXR4TTm6kSGpDmvead95BQYyolmbPIdS67eiZDgWA9MQ78cznumt9zVyT0w8N8EfLuv1Gjrxr7i3zS7abN+D5wh0a3+ZorX1FcccJYdZA8oSieA/YUkGkw9WpYV2ztWlpzMvHI2Q3zUYmwX0Ka/ISZK15SEZBZ1DBHEaPHxHA8cT5EnEWjOIs+p16C11TMCRvXUHynoQIwL9zIjpaDoFGY1dCAhih+OzMJ5J/O9qbEOqKeStSt/sVp/c4Dq5jiFaqDSujlL94PQt0G/Q21jeia6V/t7S+hx+3Y8wMAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f7 ?f0 ?f1 ?f2" svg:viewBox="0 0 0 0" draw:type="ooxml-rtTriangle" draw:enhanced-path="M 0 ?f4 L 0 0 ?f6 ?f4 Z N"><draw:equation draw:name="f0" draw:formula="logheight*7/12"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*7/12"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight*11/12"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth/12"></draw:equation></draw:enhanced-geometry>
    ooxml_rtTriangle("ooxml-rtTriangle", "H4sIAAAAAAAAAJXTzWrDMAwA4FcxPg5CmqxroNQN7LzttNNuopFjg386xU3SPf2ylAw64oExOtiyPguBDw3BsEenwJ2wyVr0FgNd2XxsNZGnTHnSX94FMIJLMB3yu3SPFPTpbzLgGDIghE7wWlaslpspiilKzrq+3fcah2c/Cr5h81rqrmcU3PvRmozCO2lwrVnQ3z7PEJTgr+zH3LKXWajlbt59sDd+PNzuf14gaO9u1Q7sRMvlJenJXgwIbnyrULcqPFR5UU61+V3xf1axYg26CSqdKuNtFUUq9hjF8jRoG4WSmKfYnBLb2cWcJKWKdrM65nz9jxy/AdGOaoA8AwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f13 ?f14 ?f15 ?f16" svg:viewBox="0 0 0 0" draw:type="ooxml-parallelogram" draw:modifiers="25000" draw:enhanced-path="M 0 ?f22 L ?f4 0 ?f23 0 ?f6 ?f22 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="100000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="?f0 *?f2 /200000"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth+0-?f3 "></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f4 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 *1/2"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth+0-?f7 "></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 *?f2 /?f1 "></draw:equation><draw:equation draw:name="f11" draw:formula="5*?f2 /?f1 "></draw:equation><draw:equation draw:name="f12" draw:formula="(1+?f11 )/12"></draw:equation><draw:equation draw:name="f13" draw:formula="?f12 *logwidth/1"></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 *logheight/1"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth+0-?f13 "></draw:equation><draw:equation draw:name="f16" draw:formula="logheight+0-?f14 "></draw:equation><draw:equation draw:name="f17" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f18" draw:formula="logheight*?f17 /?f4 "></draw:equation><draw:equation draw:name="f19" draw:formula="if(0-?f18 ,0,if(logheight-?f18 ,?f18 ,logheight))"></draw:equation><draw:equation draw:name="f20" draw:formula="logheight+0-?f19 "></draw:equation><draw:equation draw:name="f21" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f22" draw:formula="logheight"></draw:equation><draw:equation draw:name="f23" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f4 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_parallelogram("ooxml-parallelogram", "H4sIAAAAAAAAAJ2WbW+qMBTHv0pD7gvnJLSIOpcxkvt62wfYu2a00IRSV1HZPv1tKeAdVZMziaWPv54e/ufAU67p6ZHVJa0/WB4WTEnW6C/UdUuhtdJhqbT4VnVDqzTgtNqz4MfwkelGfEwHG9Y2IdWM7tMg42SJTJHYYmWLdYD2x+LxKNjpr2rTAKPuGtZ+7VgaKNXKKtxRTauKVarQVA4bq1xwwbRBxyuMh2XjKXa0KdPg1RAzHsfoxdwS11h2t7Xrf0dvwfOTW/p5oI1QtQPVVJr9+cDlSstDRdNAinpmDDmJvCkXplIyUZTNnYFEPyi3oGQKJdj+5gM3yjhGIGI8JQo+w+EfjBZ4YarG26hr2b9t3MEMXk7x1sC5cSCK4s50EC25TiNw2mpKG7x4j8OML2F+XN+EJTDYxj/nGs1JFIMoDzdN2sBM2l6DAY0iXlxkfNs/Q6svGMyLh9VvSV4czMi9oRjBRwR4wguaJzE6xyiB4S6Ivse5DALl3ZY9AeqeXBK+M8zxgNInnvZ/K7RL8neGGY2QjRUJ1DYvCLpkaWgPfboct+g7XXlO9rDkGXuxMvHtFpjrvXA5iwjm3NgLl5EE43ixMjztaxjzks4rhv6rhzu1F3aGjYxk/AzoBzWtCxa2oaStkAfZRc+VGaJ2M85vETdjtGT6nfP8D5rj/acACQAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f8 ?f10 ?f11 ?f14" svg:viewBox="0 0 0 0" draw:type="ooxml-trapezoid" draw:modifiers="25000" draw:enhanced-path="M 0 ?f14 L ?f4 0 ?f5 0 ?f15 ?f14 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="50000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="?f0 *?f2 /200000"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth+0-?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f3 "></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth/3"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 *?f2 /?f1 "></draw:equation><draw:equation draw:name="f9" draw:formula="logheight/3"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 *?f2 /?f1 "></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth+0-?f8 "></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f14" draw:formula="logheight"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f4 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_trapezoid("ooxml-trapezoid", "H4sIAAAAAAAAAJ2V3W6DIBTHX4WQXbRdiWh1/Uitya63PcDuSAUlEXGUtrZPP9HqVp1NWIzIx+HHn8M5uI0VOW9onpJ8T2OUUCmoVhdQdwuulFQolYpfZa5JFkJGsgOFd8MnqjTf9wc1LTUiipJDCCO2AhFzsSlcU/gQHE7J5sTp+VWWIcSgftqpl4KGUMpSZEgrUtCr5HG7pow541RVVC/AuJ3SbaAgOg3hO6jX8sFb9fHrRtB0BU3/J/iAu20z9etINJd5A8qJqNZmLZdJJY4ZCaHg+SSTyZnHOp1XlZTyJNXTCuLcUR5B3T7UbADPWqwTMQysgF4fyNkEoycM5nheVaudgrplXtOY2uld9PFG4CxiHnA8oxxb0fxxmmtPC/q01ovPGJkjt4K9PIQt7GDLMZizsOKshv5a3vxlztKKtf5DUxPBlqLcQWJEbP1fVe4gIe78vrKkDbKhc7xnBxrE/Y+3LEmDmO9IdpzRaB/DVLdhnFHwq44KeeDGwhyZ3921t0FF8oSiEglScnEUxsYdseB5Y/GTr41Fp6T/L9l9A3ua0GJkBgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f6 ?f7 ?f0 ?f1" svg:viewBox="0 0 0 0" draw:type="ooxml-diamond" draw:enhanced-path="M 0 ?f3 L ?f2 0 ?f5 ?f3 ?f2 ?f4 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*3/4"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight*3/4"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth/4"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/4"></draw:equation></draw:enhanced-geometry>
    ooxml_diamond("ooxml-diamond", "H4sIAAAAAAAAAJWTYWvCMBCG/0rIx0GptlVBjIV9nv6AfTvspQk0OU1jW/frV+scOJpBCBdyOd7n3hxkVznot2gV2BNWSY1k0Lsbm66Ndo5cosjpL7IeGsElNC3yl3KHzuvT36LHwSfgEFrBS7lmpdyMsRhjyVnb1dtOY/9Og+ALNq2n7nZGwYkG0ySVBkO2+qn8mjyDV4If2B2Ws49xz6bzasrvWSkL9smOfL97KC9X8Jrsg2PBjB3ks6EkZ64NCN5Q3evKq7c8LUZl+iL9j7ScISnUtfLRqCxkKs2iOHnQUiSoCIKiMKvQu6Io6+B04qa8CU9nDpTO/5H9N1HcNUg8AwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f12 ?f17 ?f13 ?f16" svg:viewBox="0 0 0 0" draw:type="ooxml-pentagon" draw:modifiers="105146 110557" draw:enhanced-path="M ?f11 ?f15 L ?f10 0 ?f14 ?f15 ?f13 ?f16 ?f12 ?f16 Z N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *$0 /100000"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *$1 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 *$1 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="?f1 *cos(pi*(1080000)/10800000)"></draw:equation><draw:equation draw:name="f7" draw:formula="?f1 *cos(pi*(18360000)/10800000)"></draw:equation><draw:equation draw:name="f8" draw:formula="?f3 *sin(pi*(1080000)/10800000)"></draw:equation><draw:equation draw:name="f9" draw:formula="?f3 *sin(pi*(18360000)/10800000)"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f10 +0-?f6 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f10 +0-?f7 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f10 +?f7 -0"></draw:equation><draw:equation draw:name="f14" draw:formula="?f10 +?f6 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="?f5 +0-?f8 "></draw:equation><draw:equation draw:name="f16" draw:formula="?f5 +0-?f9 "></draw:equation><draw:equation draw:name="f17" draw:formula="?f15 *?f7 /?f6 "></draw:equation><draw:equation draw:name="f18" draw:formula="logheight"></draw:equation></draw:enhanced-geometry>
    ooxml_pentagon("ooxml-pentagon", "H4sIAAAAAAAAAK2V3W6DIBiGb4WQHbQuRvC/TW2THW+7gJ2Rikqi4pD+7eoHbe3SSZrQVpMPA+HhQX11kQuym9O2Iu2a5m5JeUOlOIBjd8OE4MKtuGA/vJWkzmBB6p7Cq+EtFZKt/w9KupcuEZT0GVwV2AeqJLoEusQQ9NtyvmV098b3GUTgeA5zDx3NIOf7pnY7qhYueTusyXNWMCoUFaMIhzHAqo2S8/BlIx2RVQY/9FpYlwi860avoprw1HWxAYNhDL7AJ1wuTrDvDZGMtyd0SxolVQyOBRfNpiYZrHm5Y7msPF/N864m3uLg/5xVgYDzgoCHkT6sYL5BqqKsrKSlVTC28pUVvssqfJZVNLYK77aKxzAMnDXvJx1zJhilmjj1zhdoagVPbsPTIH6Eno7pAXB61j5DfXYb/qA6flpuDMFRsX5F7qqIgR1qFJs/VGKJMgRHozTItXs/8Sg2Ayq2RhmCE532l1ruz5CaM2lmSTJFJAKOvlOe/SMcReLyjTFwPPPPbvkL72B+zgUHAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f19 ?f20 ?f21 ?f22" svg:viewBox="0 0 0 0" draw:type="ooxml-hexagon" draw:modifiers="25000 115470" draw:enhanced-path="M 0 ?f8 L ?f5 ?f9 ?f6 ?f9 ?f23 ?f8 ?f6 ?f10 ?f5 ?f10 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="50000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 *$1 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f4 *sin(pi*(3600000)/10800000)"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 +0-?f7 "></draw:equation><draw:equation draw:name="f10" draw:formula="?f8 +?f7 -0"></draw:equation><draw:equation draw:name="f11" draw:formula="?f1 *-1/2"></draw:equation><draw:equation draw:name="f12" draw:formula="?f2 +?f11 -0"></draw:equation><draw:equation draw:name="f13" draw:formula="if(?f12 ,4,2)"></draw:equation><draw:equation draw:name="f14" draw:formula="if(?f12 ,3,2)"></draw:equation><draw:equation draw:name="f15" draw:formula="if(?f12 ,?f11 ,0)"></draw:equation><draw:equation draw:name="f16" draw:formula="(?f2 +?f15 )/?f11 "></draw:equation><draw:equation draw:name="f17" draw:formula="?f16 *?f14 /-1"></draw:equation><draw:equation draw:name="f18" draw:formula="?f13 +?f17 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="logwidth*?f18 /24"></draw:equation><draw:equation draw:name="f20" draw:formula="logheight*?f18 /24"></draw:equation><draw:equation draw:name="f21" draw:formula="logwidth+0-?f19 "></draw:equation><draw:equation draw:name="f22" draw:formula="logheight+0-?f20 "></draw:equation><draw:equation draw:name="f23" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f5 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_hexagon("ooxml-hexagon", "H4sIAAAAAAAAAK2W326bMBTGX+UI9SJhWNj8SWhVGmnX2x5gd1YxYAlwZkhC9/SzTWALTiu5miIcg83P3+GcD/NcSHp5Yl1Nu1dWoIqJlg3yDczllkspJKqF5L9FN9Am90ra9My7GT4zOfDX9eDAxgFRyWife4eSPMKhjLBuiG4iD/pz9XTm7PJVjLmHwfzme9+OLPeEGNsG1WyklejmJUXBS86kgkYpxhgISZP9fN8SxpEOde59B71gBt9Um6pDa9hd/6PYDE0XCL7OUJ2f8MN7eZ5wv0504KKb4B1tlahyXqsUsj01NPda3m0aUV14MdSB6tSMV/WwVZDwhvIRlKyhOjbsz9jwUGJwAkZrIC83GD1gCHCguipSMGf60CdbN73xGr/EHUZOoGQNOpQx+A8EQqKfAHaCpTYMg69y/Sna7k6MJhtfMNLV4gTb29IS8HtVOkfub+KdkbdVMrOp5wTP/lc2Hm2VGZhw927hEsslhqQ5yC0LxLKGLlcfEcfQiOUIXRdKESHOkqzqnxwVQZAEkaPxLQMsrNiZZdX/wjJhBo5lRSwHbOZnlsI2NEw34B0XkJ12KEkgRMQNZlW9wsRGnXuRWYU/e11ryyCMEre3r1X+iyM/CbRccPMyUrurG84yw6LP8CLX3ebefmDkvYdR+3TRMPinj46i53qGTmS6fApcByXtKoZG1NKRt6fWJPudGbybZvwtgWnGomT9rfPyBy82HzIECQAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f14 ?f19 ?f17 ?f22" svg:viewBox="0 0 0 0" draw:type="ooxml-heptagon" draw:modifiers="102572 105210" draw:enhanced-path="M ?f13 ?f20 L ?f14 ?f19 ?f12 0 ?f17 ?f19 ?f18 ?f20 ?f16 ?f21 ?f15 ?f21 Z N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *$0 /100000"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *$1 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 *$1 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="?f1 *97493/100000"></draw:equation><draw:equation draw:name="f7" draw:formula="?f1 *78183/100000"></draw:equation><draw:equation draw:name="f8" draw:formula="?f1 *43388/100000"></draw:equation><draw:equation draw:name="f9" draw:formula="?f3 *62349/100000"></draw:equation><draw:equation draw:name="f10" draw:formula="?f3 *22252/100000"></draw:equation><draw:equation draw:name="f11" draw:formula="?f3 *90097/100000"></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f13" draw:formula="?f12 +0-?f6 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 +0-?f7 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f12 +0-?f8 "></draw:equation><draw:equation draw:name="f16" draw:formula="?f12 +?f8 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="?f12 +?f7 -0"></draw:equation><draw:equation draw:name="f18" draw:formula="?f12 +?f6 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="?f5 +0-?f9 "></draw:equation><draw:equation draw:name="f20" draw:formula="?f5 +?f10 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="?f5 +?f11 -0"></draw:equation><draw:equation draw:name="f22" draw:formula="logheight+0-?f19 "></draw:equation></draw:enhanced-geometry>
    ooxml_heptagon("ooxml-heptagon", "H4sIAAAAAAAAAK2WXWvDIBSG/4rIrjpC1XxamhZ2ve0H7E4akwhJ7Kz92q+fSZaNNm6gLAE5aM5zXuW8knWh2HnFu5p1O14EFZct1+oKhulWKCVVUEslPmSnWZPDkjUHDm+WT1xpsbtf1PyiA6Y4O+RwW+IImIH2Q2oGQiA4nKrVSfDzk7zkEIHhnXKve55DKS9tE9R8r1klu6mmLEQpuDJUjEicEoBRTPCU+b2RPdN1Dl/6gmFfEIFncCODmHpfasaJbPzMREkf4T6Kx+gNvMLNeizwfmRayG4s17HWCC2n6qVU7bFhOWxkdRaFrpfE5C1vEv/i4HvOtkRg8YDAEqP+cYIRi6iai6rWjqrCuSpiVGEvVdF/qYrnqiJvVckchsGCphENfXCpFZdmOPPCZVZcFIZZ5oOjc1wIFgkJI+qDw7PuH3iEkJh48SwuMDyKEE29eDYjeLnTYgRzjTyiYFsmwA01s8EPKnVEWYwwoTJHlM0GBtWDAsdDt1lgQKXOKFv7D6jEGWVp/Xg8Kup2VMTS9HGvCSNXUcTS7yMKO6N+v/OHTWLrLpf2X4DNJ0kUFDgbCAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f5 ?f5 ?f6 ?f7" svg:viewBox="0 0 0 0" draw:type="ooxml-octagon" draw:modifiers="29289" draw:enhanced-path="M 0 ?f2 L ?f2 0 ?f3 0 ?f8 ?f2 ?f8 ?f4 ?f3 ?f9 ?f2 ?f9 0 ?f4 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 *1/2"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="logheight+0-?f5 "></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f2 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_octagon("ooxml-octagon", "H4sIAAAAAAAAAJ2UUW+CMBDHv0rT7EGdjQVFxYgke972AfbWSAtNaOtKVdynX2llm2yYMEjL9Xr87n8NxzbT5LyhsiByTzOUUyWo0Rfg3IJrrTQqlOYfShpSJpCRsqLwZvtEteH77qahtUFEU1IlMGUR8GNpxwqC6pRvTpyen1SdQAzc3b53OdAEKlWLEqm9IbmSbTqVccaptsAwDtfx1f2l/UBMkcAXy0pZCJ7d3NhzN6/d2j8Xzpuy+OqLXcQCvIFXuNt66vuRGK6kzyGJsKJYq5EpLY4lSSBnI4weMJjiqTUjbC+3bIZbjccWOLsh3ksQdBMILkelys88M8XUGgXleWGGQcMuNGUBmKQMg1nQaMSDaPMurZX3iFFzmoNgiz9gvsT/0KLfhYZgEszCQZTl3QKjYZJW9wscSFv3SRtEiXs19WFsg2UlBT9sdFAVbyL8IbeNcd3UROYU1UiQmoujSKDrhZ4YLn3M92foI760dP9Nu09h2KsutAQAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f6 ?f14 ?f9 ?f15" svg:viewBox="0 0 0 0" draw:type="ooxml-decagon" draw:modifiers="105146" draw:enhanced-path="M 0 ?f12 L ?f6 ?f14 ?f7 ?f13 ?f8 ?f13 ?f9 ?f14 ?f17 ?f12 ?f9 ?f15 ?f8 ?f16 ?f7 ?f16 ?f6 ?f15 Z N"><draw:equation draw:name="f0" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *$0 /100000"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *cos(pi*(2160000)/10800000)"></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 *cos(pi*(4320000)/10800000)"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 +0-?f3 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f5 +0-?f4 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f5 +?f4 -0"></draw:equation><draw:equation draw:name="f9" draw:formula="?f5 +?f3 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="?f1 *sin(pi*(4320000)/10800000)"></draw:equation><draw:equation draw:name="f11" draw:formula="?f1 *sin(pi*(2160000)/10800000)"></draw:equation><draw:equation draw:name="f12" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f13" draw:formula="?f12 +0-?f10 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 +0-?f11 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f12 +?f11 -0"></draw:equation><draw:equation draw:name="f16" draw:formula="?f12 +?f10 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="logwidth"></draw:equation></draw:enhanced-geometry>
    ooxml_decagon("ooxml-decagon", "H4sIAAAAAAAAAK2Va2+DIBSG/woh+9C6GMVbL6k12edtP2DfiKKSqHRIb/v1Qy1NO2kT1mpCToDznFcPr64yjvdL0pS4SUlmF4TVRPAj6Kdryjnjdsk4/WGNwFUMc1y1BF4t7wgXNP27KMhB2JgT3MYwySOQ5CiQw6ILQgjaXbHcUbJ/Y4cYuqC/VeZxQ2LI2KGu7IykuGCNKsgymlPCJRK5IQqi0/xZ/gaLMoYfEiareOAdXFSedYEvh7kKFmoJzYb9Sp7aFKm0SIFC8AU+4Xo1lP3eYkFZM4hocC1l5+opcsbrbYVjWLGiJLQohePJROcq8x4I/QUluQusFxc4yO0uI5inUbWnmSgNRfljUR6wUtZONtSaeCjqlE2lwnmvcWoED+7CA997BB4+6Q1EY5EheHXtJPeBEWh2ExSYgeZaUIexzQ7J4gbINwWhkQmkdYDV0uYZnUQaZ1zQHzyESGeV/xlYYxb5kelbjFyzHiONN84sZMgaWWFg9STTTmvscGK5xqyRI5RFNRhH/99a/wLrXIi70AYAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f0 ?f4 ?f3 ?f7" svg:viewBox="0 0 0 0" draw:type="ooxml-dodecagon" draw:enhanced-path="M 0 ?f5 L ?f0 ?f4 ?f1 0 ?f2 0 ?f3 ?f4 ?f8 ?f5 ?f8 ?f6 ?f3 ?f7 ?f2 ?f9 ?f1 ?f9 ?f0 ?f7 0 ?f6 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*2894/21600"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*7906/21600"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth*13694/21600"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth*18706/21600"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight*2894/21600"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight*7906/21600"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight*13694/21600"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight*18706/21600"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight"></draw:equation></draw:enhanced-geometry>
    ooxml_dodecagon("ooxml-dodecagon", "H4sIAAAAAAAAAJ2UW2vDIBTHv4r4OAgxl+ZSagN73vYB9iaJRiHRztgk3adfZpqNjlqYyPHAufzOnyN4aDSZ9lRyImvaBC1VPTX6Amy4F1orHXClxaeShnQYMtINFN6kR6qNqP8mDZ1NQDQlA4YVQ6Bi6WLJYjkEw9juR0GnZzVjiIA9W9/lRDFUau67oFENrUmr5DX3I/NEDMfwFXxjd+AF/A6IbCy2d3KNFbZq9dkmwlZVrLQ9q0c2jmzVO3iDx8M69eNMjFBy1SBJv+hjm1ymdH/uCIadaifRGP4UF2UaxlGG0AIIbwiPgJETmJco8wDGTmCUZF4SEzexyL00pneInIqWG9817txEzz1mbqLvIvMHSM9NFq63+ReldAq7gwnvfx3HL916OzxTBAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f23 ?f24 ?f25 ?f26" svg:viewBox="0 0 0 0" draw:type="ooxml-pie" draw:modifiers="0 16200000" draw:enhanced-path="M ?f12 ?f14 L ?f11 ?f13 Z N" drawooo:enhanced-path="M ?f12 ?f14 G ?f5 ?f7 ?f29 ?f30 L ?f11 ?f13 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(21599999-$0 ,$0 ,21599999))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(0-$1 ,0,if(21599999-$1 ,$1 ,21599999))"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 +0-?f0 "></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 +21600000-0"></draw:equation><draw:equation draw:name="f4" draw:formula="if(?f2 ,?f2 ,?f3 )"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 *sin(pi*(?f0 )/10800000)"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 *cos(pi*(?f0 )/10800000)"></draw:equation><draw:equation draw:name="f9" draw:formula="?f5 *(cos(atan2(?f6 ,?f8 )))"></draw:equation><draw:equation draw:name="f10" draw:formula="?f7 *(sin(atan2(?f6 ,?f8 )))"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f12" draw:formula="?f11 +?f9 -0"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f14" draw:formula="?f13 +?f10 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="?f5 *sin(pi*(?f1 )/10800000)"></draw:equation><draw:equation draw:name="f16" draw:formula="?f7 *cos(pi*(?f1 )/10800000)"></draw:equation><draw:equation draw:name="f17" draw:formula="?f5 *(cos(atan2(?f15 ,?f16 )))"></draw:equation><draw:equation draw:name="f18" draw:formula="?f7 *(sin(atan2(?f15 ,?f16 )))"></draw:equation><draw:equation draw:name="f19" draw:formula="?f11 +?f17 -0"></draw:equation><draw:equation draw:name="f20" draw:formula="?f13 +?f18 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="?f5 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f22" draw:formula="?f7 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f23" draw:formula="?f11 +0-?f21 "></draw:equation><draw:equation draw:name="f24" draw:formula="?f11 +?f21 -0"></draw:equation><draw:equation draw:name="f25" draw:formula="?f13 +0-?f22 "></draw:equation><draw:equation draw:name="f26" draw:formula="?f13 +?f22 -0"></draw:equation><draw:equation draw:name="f27" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f28" draw:formula="logheight"></draw:equation><draw:equation draw:name="f29" draw:formula="(?f0 )/60000.0"></draw:equation><draw:equation draw:name="f30" draw:formula="(?f4 )/60000.0"></draw:equation><draw:handle draw:handle-position="?f12 ?f14"></draw:handle><draw:handle draw:handle-position="?f19 ?f20"></draw:handle></draw:enhanced-geometry>
    ooxml_pie("ooxml-pie", "H4sIAAAAAAAAAKVWwY6bMBD9FQv1QLJhY5sAyWrZSL300vYDerOCCZYAs8Am2X59PYZkm9ja1gTEgGz85o1nnu3nrGXHJ14XrN7xLNhzWfG+fUe6uRJtK9ugkK34LeuelamXs7Lj3lX3gbe92N129vzUB6zlrEu9bU5DpMwKTAQm9lB32D8dBD9+lafUw0jf57HvDU89KU9VGTTi4k5mIhe87eB3ElMM19h3CaBhfZF6P5QPQsGs0Hd4ETAh+oV+DgOklJ+N+aZewDMBrhtlQmzgvDwPnl/fWC9kPfCoWaWY52dauWyrt5Klnsh9HHzBaIEX6pOSaAOXboHn3DCbKdjlFe5nbojdDTHcqBZ4Jrqht27UHKAHHGxzjJyAQhOIogdKYp3KADuBrSzBA95iNCFyizK6xSvl/iiyvlhSJ5zYDDJC807UfiPmPszZbEnwWofsxjCxMCy42Be9I8W1STFB853s7qa4sQbvAzTrWU0VeAzJWaOZa60bmtKkfZjYe6ENHU1MPbEpRUllm2+QY3UTQytTk00MoeglTJEi2JmVIZKb4iaTK4dYdHNVlHdAG8Ixq5JEUDskdi8eu5iu6nI6uEVPQ0GRxDV31CKgsQ7WzliGYvSMnpNFkyFLE/NFLTJKPqrsXnTLLkTG/YwStw2N2rSl86OQXOfUoi3Ij+ZFHXlZxDTkWiG58rJtO3p1dIMxdHJZ0NxwDEmMG5Y+RDy6xRYamlBgq3+DqYNjVnL013fQyE7AH3qqh2PkZfTwy3+OheMmxcbYkcftQf3lDwEQBXHBCwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f27 ?f29 ?f28 ?f30" svg:viewBox="0 0 0 0" draw:type="ooxml-chord" draw:modifiers="2700000 16200000" draw:enhanced-path="M ?f16 ?f18 Z N" drawooo:enhanced-path="M ?f16 ?f18 G ?f5 ?f7 ?f31 ?f32 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(21599999-$0 ,$0 ,21599999))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(0-$1 ,0,if(21599999-$1 ,$1 ,21599999))"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 +0-?f0 "></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 +21600000-0"></draw:equation><draw:equation draw:name="f4" draw:formula="if(?f2 ,?f2 ,?f3 )"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 *sin(pi*(?f0 )/10800000)"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 *cos(pi*(?f0 )/10800000)"></draw:equation><draw:equation draw:name="f9" draw:formula="?f5 *(cos(atan2(?f6 ,?f8 )))"></draw:equation><draw:equation draw:name="f10" draw:formula="?f7 *(sin(atan2(?f6 ,?f8 )))"></draw:equation><draw:equation draw:name="f11" draw:formula="?f5 *sin(pi*(?f1 )/10800000)"></draw:equation><draw:equation draw:name="f12" draw:formula="?f7 *cos(pi*(?f1 )/10800000)"></draw:equation><draw:equation draw:name="f13" draw:formula="?f5 *(cos(atan2(?f11 ,?f12 )))"></draw:equation><draw:equation draw:name="f14" draw:formula="?f7 *(sin(atan2(?f11 ,?f12 )))"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f16" draw:formula="?f15 +?f9 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f18" draw:formula="?f17 +?f10 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="?f15 +?f13 -0"></draw:equation><draw:equation draw:name="f20" draw:formula="?f17 +?f14 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="(?f16 +?f19 )/2"></draw:equation><draw:equation draw:name="f22" draw:formula="(?f18 +?f20 )/2"></draw:equation><draw:equation draw:name="f23" draw:formula="?f4 *1/2"></draw:equation><draw:equation draw:name="f24" draw:formula="?f0 +?f23 -10800000"></draw:equation><draw:equation draw:name="f25" draw:formula="?f5 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f26" draw:formula="?f7 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f27" draw:formula="?f15 +0-?f25 "></draw:equation><draw:equation draw:name="f28" draw:formula="?f15 +?f25 -0"></draw:equation><draw:equation draw:name="f29" draw:formula="?f17 +0-?f26 "></draw:equation><draw:equation draw:name="f30" draw:formula="?f17 +?f26 -0"></draw:equation><draw:equation draw:name="f31" draw:formula="(?f0 )/60000.0"></draw:equation><draw:equation draw:name="f32" draw:formula="(?f4 )/60000.0"></draw:equation><draw:handle draw:handle-position="?f16 ?f18"></draw:handle><draw:handle draw:handle-position="?f19 ?f20"></draw:handle></draw:enhanced-geometry>
    ooxml_chord("ooxml-chord", "H4sIAAAAAAAAAK1X246bMBD9FQv1gVxobBMgWS0bqS99aj+gb1YwwRLgFNgk26+vbWC7we62kywRjmXsM2fGc8zwmDXs/MDrgtV7ngUHLiveNS/IDFeiaWQTFLIRv2TdsTL1cla23Lt6fOJNJ/bThx2/dAFrOGtTb5fTBKlmq5uNakLsofZ0eDgJfv4iL6mHkfmNa1+OPPWkvFRlsFfWs9GgzEQueKMgaYL1hUhMTWeY8erIkXVF6n1Ttkismw36gb73k6SU7837qv4idWvGIdENNWufHnsLP59ZJ2Td26tZpZjmo/lcNtVzyVJP5D4OPmG0xEvVpSTa6suM6HscmM0U7OoK9z0zxG2GWGbUiL5vNEOnZlRc0AIHuxwjEFBoA1G0oCQ2WxZgENja4bzGWw5NiGBeRlO8Uh7OIuuKFQXhxLaTEZq3ovaPYu7rmM1WBG+MyzCGiYNhwcWh6IAUNzbFBM33sr2b4tbpvK+hWcdqqsBjvTkbNIPmuqUpQ9rXgb0X2tLRZMvIzfEgDu1chfoOaIeaprEmREeEUHhILHXZ0b4d/KOkRhxaIxFa7PItAp4m5MPERRzqIokmRTCYlUNPvYMkhGJRh4AGXmswlqUY37wwNdhWZTQsYtQSiW/evAqNYjiaQxdrNCdQGIcCsKGkIj8qFoZopb0R7HgWDBXMrccBdWgh+XOI3YtuyaNPRF0E0AhWBVCXQExSKyRoIroEkgy8YmB18leBKCQgr9AlEJ3LptT5DARz6WP9bzBV0mYlR2/6wVG2Qs8wvvUF7uvqfsp/rjWlO7bWDjymnw9PvwHCSqmtVwwAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f18 ?f20 ?f19 ?f21" svg:viewBox="0 0 0 0" draw:type="ooxml-teardrop" draw:modifiers="100000" draw:enhanced-path="M 0 ?f12 Q ?f14 0 ?f11 ?f13 ?f22 ?f15 ?f22 ?f12 Z N" drawooo:enhanced-path="M 0 ?f12 G ?f2 ?f4 ?f24 ?f25 Q ?f14 0 ?f11 ?f13 ?f22 ?f15 ?f22 ?f12 G ?f2 ?f4 ?f26 ?f27 ?f2 ?f4 ?f28 ?f29 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(200000-$0 ,$0 ,200000))"></draw:equation><draw:equation draw:name="f1" draw:formula="sqrt(2)"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *?f1 /1"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 *?f1 /1"></draw:equation><draw:equation draw:name="f6" draw:formula="?f3 *?f0 /100000"></draw:equation><draw:equation draw:name="f7" draw:formula="?f5 *?f0 /100000"></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f10 +?f8 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f13" draw:formula="?f12 +0-?f9 "></draw:equation><draw:equation draw:name="f14" draw:formula="(?f10 +?f11 )/2"></draw:equation><draw:equation draw:name="f15" draw:formula="(?f12 +?f13 )/2"></draw:equation><draw:equation draw:name="f16" draw:formula="?f2 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f17" draw:formula="?f4 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f18" draw:formula="?f10 +0-?f16 "></draw:equation><draw:equation draw:name="f19" draw:formula="?f10 +?f16 -0"></draw:equation><draw:equation draw:name="f20" draw:formula="?f12 +0-?f17 "></draw:equation><draw:equation draw:name="f21" draw:formula="?f12 +?f17 -0"></draw:equation><draw:equation draw:name="f22" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f23" draw:formula="logheight"></draw:equation><draw:equation draw:name="f24" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f11 0" draw:handle-range-x-maximum="200000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_teardrop("ooxml-teardrop", "H4sIAAAAAAAAAK2WXY+jIBSG/woxe2E741ao1XYyTpO92avdZG/njlRUEhUHaevsr1+Q1mnF2Qy2bQTk4+FwOC/ynHB8fCJVjqsdSbyMsJII/g666pJyzriXM07/skrgInZSXDTEuWo+EC7obtgoSCs8zAluYmebwjXYpsiXCdyoEnRAc8ieDpQcf7A2dnzQ/c9j32sSO4y1ZeEJgnnCWX2ekyU0pYRLKvTV71Tfr6DGIo+dX6CbC4E/Kgv0G1TJUk2PVGnVlxB4Bb81iDH2KeunGiCfQOVdsvoq/2poqJLosqbzzqaz4uVZr+dtjwVllV5dhUvpkPS82JTxcl/g2KGp63vffPDoP8oi6hzSvatHv85mErm4Yv5vCjiconnjwkV2EDSEFCw70kTkC2TFWQ45ymVz6VCwgFagYMSgnNAsF5YWrUyLgkkWhSZoqUC+BOm4tqFFJm01nbY2aSGY71jj1nTuokjHlSSvdckKvjHhEZg3tLoHHBoKmRh50NCB3GMfPGzTNfDsvAnH1DAp+OCIHuTZ8uB723QD7FCGItzzAuUxNrM1zJCFqy3rzkNr2og20N3iD45oJbhfAI5oR7lVbREMLfdoRCqnLQptgxAZwvgIHRjZ2YXGtKE3O7K269NPhR3GUEavMTuOKYs+Dhahyr5brs9Uxiq4hWdow51KMnRwo2VG5N/IM6L/yzx5e0sKAi7KXs0aqnp0sQr7i+apleMqI17rlbil5b6MHXR5tRx2opXu9DG/7tFbM7xMv/wDXDnH2mULAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f2 ?f2 ?f3 ?f4" svg:viewBox="0 0 0 0" draw:type="ooxml-frame" draw:modifiers="12500" draw:enhanced-path="M 0 0 L ?f8 0 ?f8 ?f7 0 ?f7 Z M ?f2 ?f2 L ?f2 ?f4 ?f3 ?f4 ?f3 ?f2 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f2 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_frame("ooxml-frame", "H4sIAAAAAAAAAJ2UUW+CMBDHv0rT7EE3GwvqNEYk2bPuA+ytkSs0oa0rVXGffoVat5GxhIUcvXLH7/5Hrmwywy5rUAVTB8hIDlqCNVfUPpbCGG1IoY340MqyMsGclRXgH+EzGCsO3aCF2hJmgFUJTnmMvM2czTGqzvn6LODyousEU9Re4b3rERKsdS1Lwg2T92I6E1yAcbgoXtCQfld+ZLZI8L5l7VyVlVube8qXrbdEb2iPgpLdzZsHTbc1dlmveLvx7PcTs0IrX0k5La7FUJhrI08lS7DgI0oeKJrQiXOdMuq3jbW78dgBpz+IfxWIugWkUKNS5xeR2WLinAJEXthh0LgLTXmEHlNO0TRqNNJBtFmXFuQ9UdJ8w0Gw+S8w3+J/aIs+adN4EOe5V9VA0LIXNAiz6uurj+KORVYC+uaTo65Ek+EPZBjkW9AwlQOpiWS1kCeZ4HZ2e3KE8jlfY+Mz7lq6/5PtJ5PwJXhoBAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f19 ?f20" svg:viewBox="0 0 0 0" draw:type="ooxml-halfFrame" draw:modifiers="33333 33333" draw:enhanced-path="M 0 0 L ?f19 0 ?f10 ?f8 ?f3 ?f8 ?f3 ?f12 0 ?f20 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="100000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight*?f3 /logwidth"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight+0-?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="100000*?f5 /?f0 "></draw:equation><draw:equation draw:name="f7" draw:formula="if(0-$0 ,0,if(?f6 -$0 ,$0 ,?f6 ))"></draw:equation><draw:equation draw:name="f8" draw:formula="?f0 *?f7 /100000"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 *logwidth/logheight"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth+0-?f9 "></draw:equation><draw:equation draw:name="f11" draw:formula="?f3 *logheight/logwidth"></draw:equation><draw:equation draw:name="f12" draw:formula="logheight+0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f3 *1/2"></draw:equation><draw:equation draw:name="f14" draw:formula="(?f12 +logheight)/2"></draw:equation><draw:equation draw:name="f15" draw:formula="(?f10 +logwidth)/2"></draw:equation><draw:equation draw:name="f16" draw:formula="?f8 *1/2"></draw:equation><draw:equation draw:name="f17" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f18" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f19" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f20" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="0 ?f8" draw:handle-range-y-maximum="?f6" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f3 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_halfFrame("ooxml-halfFrame", "H4sIAAAAAAAAAJ2W0XLiIBSGX4XJ7IVVmUBsrXaaZmYv9mp3H2DvmAYSZkJwETXu0y+QJmpIOsU4QQj4ncM55ye+5oqcXmhdkvqd5rCgUlCtzsA9FlwpqWApFf8na02qNGKk2tPoZvpIlebvw0lNGw2JomSfRgggkDG8NU2CIrA/Fi9HTk/fZdPOmU/3q/OOppGUjahgSSr2QxHRm5M5Z5wqA1zZC7j2Y7LfwY7oMo1+OerP1qozbpuNuVdX3zhxcwkCf8Dv6O21Jf09EM1l3XJrY99srPOPSSUOFUkjwetZJYsTz3W5NJ2S8qLUDwYS31A+g+IhFCN7zTtunDEEgojJkMjZDMFvGCzR0nTNjoEb2dsOHsIcXg3x1sG5CSCIW9eDaI9DWh/GuU1P3IUhCPo0CV0gmLHHsHiuJzKUsScQnp3n8eygPjtr4Eb2toPA7GwmsvN8V3a2Pm0DLqXZhzWs4j0ddUCXnW1YPLEnIFs38961+yoIeyK6LSGMA70cUY3xEsdJGMaTy8wdYIvL4RNK9LQyc+fkogtbMNCTi6uZ4J16OrlkNJDkSaKv30CQp4a7SisZK//PZWTeanlFwVUf7uSe2xX23Zn1qv+YVKQuKDxDQRouDsKmYD2xgtftisu50K74imVbwmiM21xbxhMrpi3H439H3v4DKMW0m6cIAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 ?f11 ?f12 ?f15" svg:viewBox="0 0 0 0" draw:type="ooxml-corner" draw:modifiers="50000 50000" draw:enhanced-path="M 0 0 L ?f5 0 ?f5 ?f7 ?f13 ?f7 ?f13 ?f15 0 ?f15 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="100000*logheight/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="100000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="if(0-$1 ,0,if(?f2 -$1 ,$1 ,?f2 ))"></draw:equation><draw:equation draw:name="f5" draw:formula="?f0 *?f4 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight+0-?f6 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f5 *1/2"></draw:equation><draw:equation draw:name="f9" draw:formula="(?f7 +logheight)/2"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth+0-logheight"></draw:equation><draw:equation draw:name="f11" draw:formula="if(?f10 ,?f7 ,0)"></draw:equation><draw:equation draw:name="f12" draw:formula="if(?f10 ,logwidth,?f5 )"></draw:equation><draw:equation draw:name="f13" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f15" draw:formula="logheight"></draw:equation><draw:equation draw:name="f16" draw:formula="logheight/2"></draw:equation><draw:handle draw:handle-position="0 ?f7" draw:handle-range-y-maximum="?f1" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f5 0" draw:handle-range-x-maximum="?f2" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_corner("ooxml-corner", "H4sIAAAAAAAAAJ2V0XKjIBSGX4VxepGmYQRTm20m1pm93t0H6B0TQZkRSAlJzD79AlaTaOws1ZGA5+Q7cDi/bApNTmsqKyK3tIAlVYIafQb+teBaKw0rpflfJQ2ps4iRek+jG/ORasO3Q6OhjYFEU7LPIgRyhrFrEtekEdgfy/WR09NP1Tizv7s/nnc0i5RqRA23Skuqu3Cq4IxTbYEpshfw7aexX8GOmCqLfnvkLxstBci3OVu52MvrDm6N9ucd/IneNi3p40AMV7LlSiLsbFgXhiktDjXJIsHlrFbliRemWthORXlZmUcLiW8oX0HxEIrdgtC8x8U5QyAImUwj/VTDicshkbMZgg8ILNDCdm32gB+5xw0ew3LwfB+Pe3wC/Mg9bhCIT4d4t/55zp5B3GYmiPYyQVt+i7Ya0vp9f0IwZy9h+/RjPLcUzHGcBFFeh5SZk8vTpcADeXgknK4S7Rp7ahhyJJu2DH39rWzdBIpwJJke1+vbpTKQOpJNBwvDjOTRCzlwH0ZC+GbyRxK4fKwmZ2S/zEVNwVUf7tSeO4/2bOiU8GnURJYUnqEgDRcH4UoZT3hw2XpclNd6/E9kfzbc4zbXkZMJj+nI8f0j9e0fHbH5qmsHAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f3 ?f6" svg:viewBox="0 0 0 0" draw:type="ooxml-diagStripe" draw:modifiers="50000" draw:enhanced-path="M 0 ?f4 L ?f1 0 ?f9 0 0 ?f10 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*?f0 /100000"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *1/2"></draw:equation><draw:equation draw:name="f3" draw:formula="(?f1 +logwidth)/2"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 *1/2"></draw:equation><draw:equation draw:name="f6" draw:formula="(?f4 +logheight)/2"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="0 ?f4" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_diagStripe("ooxml-diagStripe", "H4sIAAAAAAAAAJ2UUW+CMBDHv0rT7EGdjcWhm0Y02fO2l73trZEWLqGUlaq4T79ClU2UJR2kpO1df3d/uGMVa3ZY8jxl+ZbHJOFKcqOPqNmWoLXSJFUavlRuWBZhwbKS4wvznmsD267R8MoQpjkrI0wRRRvxYMcco3KfLPfAD8+qchZ7n88cCx5hpSqZkRhY8m40FG00FYMAri1vRu112m5TL5hJI/zahArRi30GzXyBXPiAog/0htcrd+xzxwyo3EFyJm1gcWYKpeUuYxEGMaDkjqIxHdtpUId163q45XBokZML5l8hgm6ITCUHiE062giKJo7pRZx2ibXwUTCZelEeupRBjbk/Zzf0xIU3ZKYcktT8W+fsWmfor3N+Q2fY6HTp+Qp97Puenpyn3hfmCVr0JeRXplet0ObTx7FtGGcc/ZqTQpVQe9R9vmlr4mTULE84ORLJKpA7GeFTTdx2gtw5/dSM82iT6f7B1t/wVebW2gQAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f6 ?f8 ?f7 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-plus" draw:modifiers="25000" draw:enhanced-path="M 0 ?f2 L ?f2 ?f2 ?f2 0 ?f3 0 ?f3 ?f2 ?f13 ?f2 ?f13 ?f4 ?f3 ?f4 ?f3 ?f12 ?f2 ?f12 ?f2 ?f4 0 ?f4 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth+0-logheight"></draw:equation><draw:equation draw:name="f6" draw:formula="if(?f5 ,0,?f2 )"></draw:equation><draw:equation draw:name="f7" draw:formula="if(?f5 ,logwidth,?f3 )"></draw:equation><draw:equation draw:name="f8" draw:formula="if(?f5 ,?f2 ,0)"></draw:equation><draw:equation draw:name="f9" draw:formula="if(?f5 ,?f4 ,logheight)"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f11" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f12" draw:formula="logheight"></draw:equation><draw:equation draw:name="f13" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f2 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_plus("ooxml-plus", "H4sIAAAAAAAAAJ2V3W6DIBTHX4WQXXRbSdHZz8yZ7HrbA+yOVFASEYfYuj39QItb7VxCYw4e4PDjj3DwMVXkuKNlTso9TVFGpaBafYKuWXClpEK5VPxLlpoUMWSkqCk86z5Qpfl+3KlpqxFRlNQxTNgKJGxjbG1sC0F9yHYHTo/Pso0hBt3jxn1WNIZStqJAVdHUbi6ZcsapMrRwibGLHoRXROcxfDWghIXgpSud2baHU9m3BWdOdOpx78ANHZyoGx2Bd/AGnx77mT8aorksex0lEUY1c7KYVKIpSAw5m2F0g8Ecz41rhfdVa13t9tYAF2fE/yYIxhMIXs4KmR15qvO5cXLKs1z7QcMx1Kwc3CUMg0VgNWIv2sOY5uTdY2S/phcs+gPWL/Ea2vIfaQPYi7j6Y8MTtrT7bdX57cN6CjZssD2ffszNFNPKm2M/2HYaFoFrT19wkTRuuYvQD3SRHIMiX9JFRlx3OoLJXJjCmNssLSj45aNK1txG2LQMh2vy1KlImVHUIkFaLhoRw+5SmYjhZR/zk899xKBl/Bd4+gazB5mPHgYAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f5 ?f5 ?f6 ?f7" svg:viewBox="0 0 0 0" draw:type="ooxml-plaque" draw:modifiers="16667" draw:enhanced-path="M 0 ?f2 L ?f3 0 L ?f11 ?f4 L ?f2 ?f10 Z N" drawooo:enhanced-path="M 0 ?f2 G ?f2 ?f2 ?f12 ?f13 L ?f3 0 G ?f2 ?f2 ?f14 ?f15 L ?f11 ?f4 G ?f2 ?f2 ?f16 ?f17 L ?f2 ?f10 G ?f2 ?f2 ?f18 ?f19 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 *70711/100000"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="logheight+0-?f5 "></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f12" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(-5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f2 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_plaque("ooxml-plaque", "H4sIAAAAAAAAAKWW0XKjIBSGX4Vx9sJ0QwMmatqpzcze7M3uPkDvmIrKjEhKTGL79AsYbZQmU6IOCB74zn+Yc2KeUkmOj7QqSPVKU5hTwWkt34F5zZmUQsJCSPYhqpqUiZeRcke9gflAZc1ex8aaNjUkkpJd4m2yELQtUi32wO6QPx4YPf4STeIhYO5u3/uWJp4QDS/htiRv+96bSFnGqFQ8HEVRfHrdS9+Suki8vwq1yQLwR/VLNdZPjFW3MsNATxF4Af/a7UKIS4Tfp+Vmi+mWPXVgW+kuPPc0MOuQcXzufWBe6+7BKHp+aiN625OaiaqNryJcnUfWHU8mJN+XJPFY5iP4A4E5mqthiNRlprqZ2WymgIsB8ZoDPHbAWeWXIj+ytC7malBQlhe1GzQYQ1Ws4G6TIbDAWiNyoi3HtE7eTwT1aTrBVl/A2hBvoYV2oAG4i1GM8S2RRlcjDd20xdcjdaStL0lbBE6ch4uqHEHYKo2e5MaxKqCLzA1j5bwfrkwGzBaRfty7pQK2st6H04BW5vsYracAreSfqtBKfx9HwRSgVQJTFVpV4N9Ksurg+9LUZystKTgbw63YMb2i/QHqKuNklKTKKWwgJw3je5545jtxYQ2r2jWf3tsVvZbxX4bn/9isKPVLCAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 ?f4 ?f9 ?f5" svg:viewBox="0 0 0 0" draw:type="ooxml-can" draw:modifiers="25000" draw:enhanced-path="M 0 ?f3 L ?f9 ?f5 Z S N M 0 ?f3 Z  S N M ?f10 ?f3 L ?f10 ?f3 L ?f21 ?f22 F N" drawooo:enhanced-path="M 0 ?f3 G ?f10 ?f3 ?f11 ?f12 L ?f9 ?f5 G ?f10 ?f3 ?f13 ?f14 Z S N M 0 ?f3 G ?f10 ?f3 ?f15 ?f16 ?f10 ?f3 ?f17 ?f18 Z J S N M ?f9 ?f3 G ?f10 ?f3 ?f19 ?f20 ?f10 ?f3 ?f21 ?f22 L ?f9 ?f5 G ?f10 ?f3 ?f23 ?f24 L 0 ?f3 F N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="50000*logheight/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="?f0 *?f2 /200000"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 +?f3 -0"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight+0-?f3 "></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f11" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f12" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(10800000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f6 ?f4" draw:handle-range-y-maximum="?f1" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_can("ooxml-can", "H4sIAAAAAAAAAK2WS2+jMBCA/4qFeiBtvBjn0aQqjbSHXWnV9rK33qxgwBLgrENe/fX1QCEBl5UcqsiO7Rl/Mx7PCD+Gih0eeJ6wfM1DHHOZ8UKdULmcCaWkwolU4l3mBUsDJ2Lpljst8Z6rQqy7woIfC8wUZ9vAIWgVTXVb6jZz0HYfP+wFP/yUR5CVv3rXacMDR8pjluI1y2tDMhSR4Eqj6IyQWrnxesOKJHBeENiZoOfaEnpDf9Erqtff0Od0FflnzYsh9aGj6Bd6rSxIKfuM/D5v1QPY6NMLy21x2U077rRVZtDNW0v30C30rj+N38svdsIaJZdL9Tl63KFlN9XiagWO+/RYRfTfjhVC5lV8c5bpy4jqcEdSZbuUBU4mcjeV8UGERTLWg4SLOClGGuK1KP+D+l0o3Cu5bWjeKiLIiki7RBG5BN8QNCZjPdQBQOUMGkxGdg5Punhw8FYHEnkUXCdWtKlJm6A76LAdaNYFNRG8Ixh4VrT5F7Tymj1qxbnv9coStOgFWWGWfeeyy1mjEq4Mj29kv+uTRZlFI28Ofz/sssA3kt/FA4lGvrvXkoxcH3pYI+eHAo20Hwo08v/q4BkFMNQ1oxSudY0a1TDQNfrdVUHNqhgI/LaioAOKQr9HwpSjizHeyK0ADfiOwCOipn+KFctjjk84Y0eR7TLQ8ns0RF5pnK1XGo0v3Zfi0wdPITr9QgoAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 ?f2 ?f6 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-cube" draw:modifiers="25000" draw:enhanced-path="M 0 ?f2 L ?f6 ?f2 ?f6 ?f9 0 ?f9 Z S N M ?f6 ?f2 L ?f10 0 ?f10 ?f3 ?f6 ?f9 Z  S N M 0 ?f2 L ?f2 0 ?f10 0 ?f6 ?f2 Z  S N M 0 ?f2 L ?f2 0 ?f10 0 ?f10 ?f3 ?f6 ?f9 0 ?f9 Z M 0 ?f2 L ?f6 ?f2 ?f10 0 M ?f6 ?f2 L ?f6 ?f9 F N" drawooo:enhanced-path="M 0 ?f2 L ?f6 ?f2 ?f6 ?f9 0 ?f9 Z S N M ?f6 ?f2 L ?f10 0 ?f10 ?f3 ?f6 ?f9 Z I S N M 0 ?f2 L ?f2 0 ?f10 0 ?f6 ?f2 Z K S N M 0 ?f2 L ?f2 0 ?f10 0 ?f10 ?f3 ?f6 ?f9 0 ?f9 Z M 0 ?f2 L ?f6 ?f2 ?f10 0 M ?f6 ?f2 L ?f6 ?f9 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 *1/2"></draw:equation><draw:equation draw:name="f5" draw:formula="(?f2 +logheight)/2"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 *1/2"></draw:equation><draw:equation draw:name="f8" draw:formula="(?f2 +logwidth)/2"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="0 ?f2" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_cube("ooxml-cube", "H4sIAAAAAAAAAL1VXU+DMBT9K03jw76aFeamW8aW+GBi1L34trc6CjShdJayMX+9hQITtqmYKKSk5Z6ee05vKXNXkv2MRgGJNtRFPhWcKnkA+WvOpBQSBUKydxEpEjrQI2FMYS28o1KxTTOoaKoQkZTEDsRg6dm6TXSbQhDv/NmO0f2dSLNYfpezDlvqQCFSHqJN8lplEi7zGJWayx5jXKIr2VuiAgc+A5PoqUhVpczfT8EavIAVeK6iGc7CedDKHqMKvwYF9Eholzhczf8O1SAtRZyTmc+oKzOT7sHKmBVC/KXfh58Zfvwfx4u5qe9bQhQTkal2RLjeG15ZfE9InoTEgczrYHSFwQAPdNfC2ZWPs2aG3a6mHNY4v0phNVNwFnVC4e+Zq4KB7gSU+YFqR2o3SfUagN7Sw2BoRLZiGzXZKlV9jLIFbcV2faptBHrW0G7FMm6ydDIh/eN6teSbnPGYl+A3Fm9OLU7aW7y9aDEX1tbh9GIV2+3Xk2+iFHSJRp8jbkjBpz7aiphliOK4hrWgJJFP0QFxkjKecAcWW/Y8iEUGdNzSBlGJaf5uFh/U9bMnhwYAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f35 ?f36" svg:viewBox="0 0 0 0" draw:type="ooxml-funnel" draw:enhanced-path="M ?f22 ?f23 L ?f30 ?f32 Z M ?f33 ?f4 Z N" drawooo:enhanced-path="M ?f22 ?f23 G ?f2 ?f4 ?f37 ?f38 L ?f30 ?f32 G ?f13 ?f14 ?f39 ?f40 Z M ?f33 ?f4 G ?f3 ?f5 ?f41 ?f42 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *1/20"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 +0-?f1 "></draw:equation><draw:equation draw:name="f4" draw:formula="logheight/4"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 +0-?f1 "></draw:equation><draw:equation draw:name="f6" draw:formula="?f2 *cos(pi*(480000)/10800000)"></draw:equation><draw:equation draw:name="f7" draw:formula="?f4 *sin(pi*(480000)/10800000)"></draw:equation><draw:equation draw:name="f8" draw:formula="(10800000*atan2(?f7 ,?f6 ))/pi"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 *2/1"></draw:equation><draw:equation draw:name="f10" draw:formula="10800000+0-?f8 "></draw:equation><draw:equation draw:name="f11" draw:formula="10800000+2-0"></draw:equation><draw:equation draw:name="f12" draw:formula="10800000+0-2"></draw:equation><draw:equation draw:name="f13" draw:formula="?f2 *1/4"></draw:equation><draw:equation draw:name="f14" draw:formula="?f4 *1/4"></draw:equation><draw:equation draw:name="f15" draw:formula="?f4 *cos(pi*(?f10 )/10800000)"></draw:equation><draw:equation draw:name="f16" draw:formula="?f2 *sin(pi*(?f10 )/10800000)"></draw:equation><draw:equation draw:name="f17" draw:formula="sqrt(?f15 *?f15 +?f16 *?f16 +0*0)"></draw:equation><draw:equation draw:name="f18" draw:formula="?f2 *?f4 /?f17 "></draw:equation><draw:equation draw:name="f19" draw:formula="?f18 *cos(pi*(?f10 )/10800000)"></draw:equation><draw:equation draw:name="f20" draw:formula="?f18 *sin(pi*(?f10 )/10800000)"></draw:equation><draw:equation draw:name="f21" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f22" draw:formula="?f21 +?f19 -0"></draw:equation><draw:equation draw:name="f23" draw:formula="?f4 +?f20 -0"></draw:equation><draw:equation draw:name="f24" draw:formula="?f14 *cos(pi*(?f8 )/10800000)"></draw:equation><draw:equation draw:name="f25" draw:formula="?f13 *sin(pi*(?f8 )/10800000)"></draw:equation><draw:equation draw:name="f26" draw:formula="sqrt(?f24 *?f24 +?f25 *?f25 +0*0)"></draw:equation><draw:equation draw:name="f27" draw:formula="?f13 *?f14 /?f26 "></draw:equation><draw:equation draw:name="f28" draw:formula="?f27 *cos(pi*(?f8 )/10800000)"></draw:equation><draw:equation draw:name="f29" draw:formula="?f27 *sin(pi*(?f8 )/10800000)"></draw:equation><draw:equation draw:name="f30" draw:formula="?f21 +?f28 -0"></draw:equation><draw:equation draw:name="f31" draw:formula="logheight+0-?f14 "></draw:equation><draw:equation draw:name="f32" draw:formula="?f31 +?f29 -0"></draw:equation><draw:equation draw:name="f33" draw:formula="?f2 +0-?f3 "></draw:equation><draw:equation draw:name="f34" draw:formula="10800000*2/1"></draw:equation><draw:equation draw:name="f35" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f36" draw:formula="logheight"></draw:equation><draw:equation draw:name="f37" draw:formula="(?f10 )/60000.0"></draw:equation><draw:equation draw:name="f38" draw:formula="(?f11 )/60000.0"></draw:equation><draw:equation draw:name="f39" draw:formula="(?f8 )/60000.0"></draw:equation><draw:equation draw:name="f40" draw:formula="(?f12 )/60000.0"></draw:equation><draw:equation draw:name="f41" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f42" draw:formula="(-21600000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_funnel("ooxml-funnel", "H4sIAAAAAAAAAK2X0Y6iMBRAf6XhCZlhobeIOBnHZF/2ZXc/YN+IFiEB6gDqzH79tkXIaDuzuagmtVo43N7eA/V526SnJ17nab3hW3/HRcW75p3on6uiaUTj56Ip/oq6S8uVk6Vly52L4SNvumJzPdjxt85PG562KyckIVlnbK6a2CHtcfd0LPjpu3jrx+R7OOt9z1eOEG9V6WeHuubleWCMcJ92+cr5JVEAqmHkp8LqCwD5Q9QIY7KJ5Jff/dlCiK8AP9SHPkOeulBNcgFV41QhqT5iqQ4NLy+lDlE9NcWIqgb05V+e++hfD2lXiLqfS51WcpLZMOdMNNWhTFdOVdRuKXanYtvlj7KT82KXdzMJCS4oX0HpNXSdhcSjAYQoDFxjhrgCQHGYGQ6Qh9CXuSQoUGQJqM9PEKFAczOiaFJEsW1q3ka07r7w3CgJ5WsW0FB3QtwqLmxBeq2sj9vZyTXbHThe2qU1uOtsQR7XWUxms2BfoNhLM+6EeBBQXA0bZgwR6nVKcOtEDSVGGvg4K6ihxYfAcGJQqxlSVFw1U8MLXSlojNWKsZilGyGZWm/ULspQzLexDVHa16ZTzDnxdPsg21j3Y2m5h+UbsujYVXICiVwgK9GiB03ulGYwpOnhd8kzGA5NfB6AYZBMKNWrtCRIG8GiUKRQEKJRFo3ohQDJ9NxZ3JK7iQ8LcwPbcOtc/xCpKoU+HdoF2eLrHywPIhW7zo40AGKcAWDzaXGnPFvsUux75JlZ5OrLFhJsrTGbS/1Wpt+GRLicMotSrI8NrRT7fL/GkFEZRo27DOx2gBkCDTcfHMZwZcw7jmM4MdxbYzW9b8iMm9sxSaNTaYYD57KfAouMolehwVSaUfbjvnMi0Kh71wca/5d4/n79j/flH2poxSMKDwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f2 ?f2 ?f3 ?f4" svg:viewBox="0 0 0 0" draw:type="ooxml-bevel" draw:modifiers="12500" draw:enhanced-path="M ?f2 ?f2 L ?f3 ?f2 ?f3 ?f4 ?f2 ?f4 Z S N M 0 0 L ?f5 0 ?f3 ?f2 ?f2 ?f2 Z  S N M 0 ?f8 L ?f2 ?f4 ?f3 ?f4 ?f5 ?f8 Z  S N M 0 0 L ?f2 ?f2 ?f2 ?f4 0 ?f8 Z  S N M ?f5 0 L ?f5 ?f8 ?f3 ?f4 ?f3 ?f2 Z  S N M 0 0 L ?f5 0 ?f5 ?f8 0 ?f8 Z M ?f2 ?f2 L ?f3 ?f2 ?f3 ?f4 ?f2 ?f4 Z M 0 0 L ?f2 ?f2 M 0 ?f8 L ?f2 ?f4 M ?f5 0 L ?f3 ?f2 M ?f5 ?f8 L ?f3 ?f4 F N" drawooo:enhanced-path="M ?f2 ?f2 L ?f3 ?f2 ?f3 ?f4 ?f2 ?f4 Z S N M 0 0 L ?f5 0 ?f3 ?f2 ?f2 ?f2 Z K S N M 0 ?f8 L ?f2 ?f4 ?f3 ?f4 ?f5 ?f8 Z I S N M 0 0 L ?f2 ?f2 ?f2 ?f4 0 ?f8 Z J S N M ?f5 0 L ?f5 ?f8 ?f3 ?f4 ?f3 ?f2 Z H S N M 0 0 L ?f5 0 ?f5 ?f8 0 ?f8 Z M ?f2 ?f2 L ?f3 ?f2 ?f3 ?f4 ?f2 ?f4 Z M 0 0 L ?f2 ?f2 M 0 ?f8 L ?f2 ?f4 M ?f5 0 L ?f3 ?f2 M ?f5 ?f8 L ?f3 ?f4 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f2 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_bevel("ooxml-bevel", "H4sIAAAAAAAAAM2VXU+DMBiF/0rTeDF1zTq26bKIS7wwfmzeeOddHS00oXSWjqG/3kIp21DMMDExpKHQw3NO37zAVaDIdkaTiCQrGqCQSkG1egflbcGVkgpFUvEPmWgS+5CROKXwYDmjSvNVc1HTXCOiKEl9OGcesGNkxhiCNAtnGafbG5n7EIPycM+9r6kPpcxFjF5pRmNnJgPOOFUGN/Qm2Mnr5GuiIx8ugfNaVG61azUfgxfwDJ7AsnQtVBNz3mnteAG1aM6mpcyrIA42KVf2hLiWebUcH4qs2aJ+ekcbNW33s1mxYx23x2air1vZjzOqNM5rURNvwZMttZTy76r9eHS574+q98PRBb/7lxW/vrLd/bYhmsvE9npChHk1mGt9JpXYxMSHnPUwOsGgj/tmat4NbC+LUV6dnhrg4ID4k8GwaSB40otluOWBjvpmElEeRrob1GtC52wIzuYMg8GwyIg70UZNmot3jlFR106w8Tcwu8Xf0CZt0TpRLlozDbxOoMu2OB0509ZAbRjzqQhiCvbmaC1TXijsL8E1crWoSBJSlCNBci42wodl77ZoeGI1u7axijpL8492/QmtgZBE6gYAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f10 ?f13 ?f11 ?f14" svg:viewBox="0 0 0 0" draw:type="ooxml-donut" draw:modifiers="25000" draw:enhanced-path="M 0 ?f12 Z M ?f3 ?f5 Z N" drawooo:enhanced-path="M 0 ?f12 G ?f3 ?f5 ?f17 ?f18 ?f3 ?f5 ?f19 ?f20 ?f3 ?f5 ?f21 ?f22 ?f3 ?f5 ?f23 ?f24 Z M ?f2 ?f12 G ?f4 ?f6 ?f25 ?f26 ?f4 ?f6 ?f27 ?f28 ?f4 ?f6 ?f29 ?f30 ?f4 ?f6 ?f31 ?f32 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 +0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 +0-?f2 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f3 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f8" draw:formula="?f5 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 +0-?f7 "></draw:equation><draw:equation draw:name="f11" draw:formula="?f9 +?f7 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f13" draw:formula="?f12 +0-?f8 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 +?f8 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="logheight"></draw:equation><draw:equation draw:name="f16" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f17" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f30" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f31" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f32" draw:formula="(-5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f2 ?f12" draw:handle-radius-range-maximum="50000" draw:handle-radius-range-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_donut("ooxml-donut", "H4sIAAAAAAAAAK1X226jMBD9FQvtA8mGjTGQkKo00r7sU/cD9s0KJlgCnBpyab9+bbOkJJNW67iKMMN4OHNmmIPIYy7p8YE1JW02LA+2TNSsk6/IuGsupZBBKSR/E01Hq8wraNUy72L7wGTHN9ebHTt1AZWMtpm3LkKM1BLpJdRL7KH2sH04cHb8KU6Zh5H5Dfe+7ljmCXGqqyAXzb4bEoqcF5xJBUkSjIfwM/sd7crMe0YmGUF/0LMydNJE2b/7aCHEhzf8Ooery6Ve0rFnpRaCRx6iayFk7NEGif+lJu+wsToW2mWiFmOPTkTSsUcnivDIE+lEETFVPD32Rb/sacdF07egobXqWDF0pBCy3lc083jh4+AbRjM8U6buWX+pD3M1mSjA+QXiZwnC6wQ1b/xKbI8878qZMkrGt2VnB0quQVXX0HRdYDQPNUdshRZdow305sQKJ4asIvQdB/qxWgElNwj1bbJktICMkrsYLW+VNt2I1t/xqU+WpukT1fy0t6zA01ssp62aky8AX33Rww2BUtbFqu/l0q6XIZCEQdI4gd3ghkAH9w5KCDRg3kOmvNSyvBsy0FAayLa+j4VghwN0MAyBHQxQgX+eyflCn35Y1gcm309iFzww7H64IA6ABAy9G0ECRt+/FwmMviMzIABHPKACRzwgBcfZI0ATfuDGEKrDDQ+Kw5EgVMedSBGUhRu1COrCTbgRlMd/M1RfunnF0MgOdqLlOkK/y/tPVO9iX9Kc71t1arYsqOmJ1/s688zn4meBvOkD36n0YWdi138ynv4CKyGOon0MAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f33 ?f35 ?f34 ?f36" svg:viewBox="0 0 0 0" draw:type="ooxml-noSmoking" draw:modifiers="18750" draw:enhanced-path="M 0 ?f27 Z M ?f3 ?f5 Z M ?f43 ?f44 Z N" drawooo:enhanced-path="M 0 ?f27 G ?f3 ?f5 ?f39 ?f40 ?f3 ?f5 ?f41 ?f42 ?f3 ?f5 ?f43 ?f44 ?f3 ?f5 ?f45 ?f46 Z M ?f26 ?f28 G ?f4 ?f6 ?f47 ?f48 Z M ?f29 ?f30 G ?f4 ?f6 ?f49 ?f50 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 +0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 +0-?f2 "></draw:equation><draw:equation draw:name="f7" draw:formula="(10800000*atan2(logheight,logwidth))/pi"></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 *cos(pi*(?f7 )/10800000)"></draw:equation><draw:equation draw:name="f9" draw:formula="?f4 *sin(pi*(?f7 )/10800000)"></draw:equation><draw:equation draw:name="f10" draw:formula="sqrt(?f8 *?f8 +?f9 *?f9 +0*0)"></draw:equation><draw:equation draw:name="f11" draw:formula="?f4 *?f6 /?f10 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f2 *1/2"></draw:equation><draw:equation draw:name="f13" draw:formula="(10800000*atan2(?f12 ,?f11 ))/pi"></draw:equation><draw:equation draw:name="f14" draw:formula="?f13 *2/1"></draw:equation><draw:equation draw:name="f15" draw:formula="-10800000+2-0"></draw:equation><draw:equation draw:name="f16" draw:formula="(10800000*atan2(logheight,logwidth))/pi"></draw:equation><draw:equation draw:name="f17" draw:formula="?f16 +0-?f13 "></draw:equation><draw:equation draw:name="f18" draw:formula="?f17 +0-10800000"></draw:equation><draw:equation draw:name="f19" draw:formula="?f6 *cos(pi*(?f17 )/10800000)"></draw:equation><draw:equation draw:name="f20" draw:formula="?f4 *sin(pi*(?f17 )/10800000)"></draw:equation><draw:equation draw:name="f21" draw:formula="sqrt(?f19 *?f19 +?f20 *?f20 +0*0)"></draw:equation><draw:equation draw:name="f22" draw:formula="?f4 *?f6 /?f21 "></draw:equation><draw:equation draw:name="f23" draw:formula="?f22 *cos(pi*(?f17 )/10800000)"></draw:equation><draw:equation draw:name="f24" draw:formula="?f22 *sin(pi*(?f17 )/10800000)"></draw:equation><draw:equation draw:name="f25" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f26" draw:formula="?f25 +?f23 -0"></draw:equation><draw:equation draw:name="f27" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f28" draw:formula="?f27 +?f24 -0"></draw:equation><draw:equation draw:name="f29" draw:formula="?f25 +0-?f23 "></draw:equation><draw:equation draw:name="f30" draw:formula="?f27 +0-?f24 "></draw:equation><draw:equation draw:name="f31" draw:formula="?f3 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f32" draw:formula="?f5 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f33" draw:formula="?f25 +0-?f31 "></draw:equation><draw:equation draw:name="f34" draw:formula="?f25 +?f31 -0"></draw:equation><draw:equation draw:name="f35" draw:formula="?f27 +0-?f32 "></draw:equation><draw:equation draw:name="f36" draw:formula="?f27 +?f32 -0"></draw:equation><draw:equation draw:name="f37" draw:formula="logheight"></draw:equation><draw:equation draw:name="f38" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f39" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f40" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f41" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f42" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f43" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f44" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f45" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f46" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f47" draw:formula="(?f17 )/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(?f15 )/60000.0"></draw:equation><draw:equation draw:name="f49" draw:formula="(?f18 )/60000.0"></draw:equation><draw:equation draw:name="f50" draw:formula="(?f15 )/60000.0"></draw:equation><draw:handle draw:handle-position="?f2 ?f27" draw:handle-radius-range-maximum="50000" draw:handle-radius-range-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_noSmoking("ooxml-noSmoking", "H4sIAAAAAAAAALWYy3KbMBSGX0XDdIGJKUji5kwcz3TTVbrprjuNDbamBjmAE6dP3yMuviAlU0Fqj4UQ0q+fo/NZ2A+bkr3ep8WOFet0425Tkad1+Yaa5pyXpSjdnSj5H1HUbL+0MravUuvm8kta1nw9vFinp9plZcqqpbXKKEVQhLIIZBFZqHrZ3r/w9PWbOC0tHzXvfuzbIV1aQpzyvVuIn7n4zYttP6nY8IynJcjiJA77Iec7OLB6t7SeQG2VkRj9Qk9yPviEXT2QJ0EAZz/asUKId4d/Pw+G40IO9K9aAiwLct3SiV+1NEXUTU4iWSSNruwlT4NYFknfQ85C/dsesi30G8uPD+39Ph9ZzUXR3n3BcghY1gcjE2V+3LOlxTPbd7/4aO7PoRr68GpO5ac5m81A0LtR/GgCPJwg54W9F9tXvql3c6jsUr7d1WaiZCi6yjByVpmPPCw9+kZqdKjW2/OIkU6guqLozndhhZCRUKgx1IbJ0FGkOgpHOYqHQjb2kybSDqtZQeyzw3kfvNnMO3CjSRLVbYSctajsA3fsVRajmddPa5YvC1U5QE4FmThVGSsAVc9lDZKJzMcE3a2yhawtIOyOqbbCTmNbRsWDhPfNlhBroCHIwYYphRVahqkA1giaQ4mReQ5gDUSYIod42ExHYcjtbd4R1+z7ASsY/Y/sxwpjcOdRSytEwExLgxKOpVZv3ExOw88NmXg8QEQBaMDmFG0FoA5O3DAJJeBJfFmH0hxQokHqAijBZotGFLJAg3xWmDVcSfHPibNuwxqzgxLNhkXCZpUoMqSWKDyN3UWJhiZ40JOuAmNXGpRIvycbUk416JC40woMtTR7Db3kHonbtBiZIFQDSnhJvqnqOnC6mFJDCKmOkyYDQclwramCxWV9qOEDGNWR0eQgKJn6ep8MMx2Fix57MxkFifP2OvMiefhqdn+BwoUdBlP0FDZsHJEpggoOEw2qz2RjlZT0n+hMQWCinvooNk1P/WHT7YSj1BQgpFo4Vk3lAtSSkWqhCsW/eduxYrNP0VXdPYiKyx7tT4jVZavtrpdsw48VHIpt6ubsxPNjvrSafw8+6siLtuPFStvtbGz4l9PjX5PVfiWLEgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f60 ?f68 ?f44 ?f52" svg:viewBox="0 0 0 0" draw:type="ooxml-blockArc" draw:modifiers="10800000 0 25000" draw:enhanced-path="M ?f18 ?f20 L ?f35 ?f36 Z N" drawooo:enhanced-path="M ?f18 ?f20 G ?f7 ?f9 ?f76 ?f77 L ?f35 ?f36 G ?f25 ?f26 ?f78 ?f79 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(21599999-$0 ,$0 ,21599999))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(0-$1 ,0,if(21599999-$1 ,$1 ,21599999))"></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$2 ,0,if(50000-$2 ,$2 ,50000))"></draw:equation><draw:equation draw:name="f3" draw:formula="?f1 +0-?f0 "></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 +21600000-0"></draw:equation><draw:equation draw:name="f5" draw:formula="if(?f3 ,?f3 ,?f4 )"></draw:equation><draw:equation draw:name="f6" draw:formula="0+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 *sin(pi*(?f0 )/10800000)"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 *cos(pi*(?f0 )/10800000)"></draw:equation><draw:equation draw:name="f11" draw:formula="?f7 *sin(pi*(?f1 )/10800000)"></draw:equation><draw:equation draw:name="f12" draw:formula="?f9 *cos(pi*(?f1 )/10800000)"></draw:equation><draw:equation draw:name="f13" draw:formula="?f7 *(cos(atan2(?f8 ,?f10 )))"></draw:equation><draw:equation draw:name="f14" draw:formula="?f9 *(sin(atan2(?f8 ,?f10 )))"></draw:equation><draw:equation draw:name="f15" draw:formula="?f7 *(cos(atan2(?f11 ,?f12 )))"></draw:equation><draw:equation draw:name="f16" draw:formula="?f9 *(sin(atan2(?f11 ,?f12 )))"></draw:equation><draw:equation draw:name="f17" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f18" draw:formula="?f17 +?f13 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f20" draw:formula="?f19 +?f14 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="?f17 +?f15 -0"></draw:equation><draw:equation draw:name="f22" draw:formula="?f19 +?f16 -0"></draw:equation><draw:equation draw:name="f23" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f24" draw:formula="?f23 *?f2 /100000"></draw:equation><draw:equation draw:name="f25" draw:formula="?f7 +0-?f24 "></draw:equation><draw:equation draw:name="f26" draw:formula="?f9 +0-?f24 "></draw:equation><draw:equation draw:name="f27" draw:formula="?f25 *sin(pi*(?f1 )/10800000)"></draw:equation><draw:equation draw:name="f28" draw:formula="?f26 *cos(pi*(?f1 )/10800000)"></draw:equation><draw:equation draw:name="f29" draw:formula="?f25 *sin(pi*(?f0 )/10800000)"></draw:equation><draw:equation draw:name="f30" draw:formula="?f26 *cos(pi*(?f0 )/10800000)"></draw:equation><draw:equation draw:name="f31" draw:formula="?f25 *(cos(atan2(?f27 ,?f28 )))"></draw:equation><draw:equation draw:name="f32" draw:formula="?f26 *(sin(atan2(?f27 ,?f28 )))"></draw:equation><draw:equation draw:name="f33" draw:formula="?f25 *(cos(atan2(?f29 ,?f30 )))"></draw:equation><draw:equation draw:name="f34" draw:formula="?f26 *(sin(atan2(?f29 ,?f30 )))"></draw:equation><draw:equation draw:name="f35" draw:formula="?f17 +?f31 -0"></draw:equation><draw:equation draw:name="f36" draw:formula="?f19 +?f32 -0"></draw:equation><draw:equation draw:name="f37" draw:formula="?f17 +?f33 -0"></draw:equation><draw:equation draw:name="f38" draw:formula="?f19 +?f34 -0"></draw:equation><draw:equation draw:name="f39" draw:formula="21600000+0-?f0 "></draw:equation><draw:equation draw:name="f40" draw:formula="?f5 +0-?f39 "></draw:equation><draw:equation draw:name="f41" draw:formula="max(?f18 ,?f35 )"></draw:equation><draw:equation draw:name="f42" draw:formula="max(?f21 ,?f37 )"></draw:equation><draw:equation draw:name="f43" draw:formula="max(?f41 ,?f42 )"></draw:equation><draw:equation draw:name="f44" draw:formula="if(?f40 ,logwidth,?f43 )"></draw:equation><draw:equation draw:name="f45" draw:formula="5400000+0-?f0 "></draw:equation><draw:equation draw:name="f46" draw:formula="27000000+0-?f0 "></draw:equation><draw:equation draw:name="f47" draw:formula="if(?f45 ,?f45 ,?f46 )"></draw:equation><draw:equation draw:name="f48" draw:formula="?f5 +0-?f47 "></draw:equation><draw:equation draw:name="f49" draw:formula="max(?f20 ,?f36 )"></draw:equation><draw:equation draw:name="f50" draw:formula="max(?f22 ,?f38 )"></draw:equation><draw:equation draw:name="f51" draw:formula="max(?f49 ,?f50 )"></draw:equation><draw:equation draw:name="f52" draw:formula="if(?f48 ,logheight,?f51 )"></draw:equation><draw:equation draw:name="f53" draw:formula="10800000+0-?f0 "></draw:equation><draw:equation draw:name="f54" draw:formula="32400000+0-?f0 "></draw:equation><draw:equation draw:name="f55" draw:formula="if(?f53 ,?f53 ,?f54 )"></draw:equation><draw:equation draw:name="f56" draw:formula="?f5 +0-?f55 "></draw:equation><draw:equation draw:name="f57" draw:formula="min(?f18 ,?f35 )"></draw:equation><draw:equation draw:name="f58" draw:formula="min(?f21 ,?f37 )"></draw:equation><draw:equation draw:name="f59" draw:formula="min(?f57 ,?f58 )"></draw:equation><draw:equation draw:name="f60" draw:formula="if(?f56 ,0,?f59 )"></draw:equation><draw:equation draw:name="f61" draw:formula="16200000+0-?f0 "></draw:equation><draw:equation draw:name="f62" draw:formula="37800000+0-?f0 "></draw:equation><draw:equation draw:name="f63" draw:formula="if(?f61 ,?f61 ,?f62 )"></draw:equation><draw:equation draw:name="f64" draw:formula="?f5 +0-?f63 "></draw:equation><draw:equation draw:name="f65" draw:formula="min(?f20 ,?f36 )"></draw:equation><draw:equation draw:name="f66" draw:formula="min(?f22 ,?f38 )"></draw:equation><draw:equation draw:name="f67" draw:formula="min(?f65 ,?f66 )"></draw:equation><draw:equation draw:name="f68" draw:formula="if(?f64 ,0,?f67 )"></draw:equation><draw:equation draw:name="f69" draw:formula="(?f18 +?f37 )/2"></draw:equation><draw:equation draw:name="f70" draw:formula="(?f20 +?f38 )/2"></draw:equation><draw:equation draw:name="f71" draw:formula="(?f21 +?f35 )/2"></draw:equation><draw:equation draw:name="f72" draw:formula="(?f22 +?f36 )/2"></draw:equation><draw:equation draw:name="f73" draw:formula="?f0 +0-5400000"></draw:equation><draw:equation draw:name="f74" draw:formula="?f1 +5400000-0"></draw:equation><draw:equation draw:name="f75" draw:formula="(?f73 +?f74 )/2"></draw:equation><draw:equation draw:name="f76" draw:formula="(?f0 )/60000.0"></draw:equation><draw:equation draw:name="f77" draw:formula="(?f5 )/60000.0"></draw:equation><draw:equation draw:name="f78" draw:formula="(?f1 )/60000.0"></draw:equation><draw:equation draw:name="f79" draw:formula="(?f6 )/60000.0"></draw:equation><draw:handle draw:handle-position="?f18 ?f20"></draw:handle><draw:handle draw:handle-position="?f35 ?f36" draw:handle-radius-range-maximum="50000" draw:handle-radius-range-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_blockArc("ooxml-blockArc", "H4sIAAAAAAAAAK2Z25LiNhCGX0XlygUz4IwOlgxby24lN7lJ9gFy54AB12JrYjyHzdNHJ2YD3bvZ1gyUZfDhV7fUX0uy32/H5uldOxyaYdNuy31r+3Yav7BwuO/G0Y7lwY7dP3aYmuO62DXHU1tcnH5sx6nbXJ+c2uepbMa2Oa2LjzvDmSuWrqgqV2hZsNPj/t1j1z79ap/XBWfhe773y327Lqx97o/lX0e7+fzLuDnXabfdrmtHpyr4kvuPu1Fqt09XvPhy30yHdfGHq074iiVnv7ud0r4w7E/2Kd5grf3ePb+5Xe22ld8bX9QXOv689L9lOOnvqldB/cP7aM/fD83U2SFaNzS9c213NnZnx/7h2KyLbjfj5U+cLfjC/ZRCr/wnHPHb+cDNjZO9u9D9XjUCr0aAatwRv2VWI/FqZKrGd07867fwj1iBuq7A9Q+b8/LjjjOSUAWFFJtLYUIklZwkphG3vd4iFRWjeWmu9XhwUdNcrK9Vjnb/1G2nw50k6SxhU9Xs9tQNs/vuduZb/ubujCDNzxVi4aHt9oeJaKIAGHlObzf29GobBUDnyn2RLw1wubL6FdIIKM7qmddupmaQTn3pQ1O4lqHmEoQdZ/bMN8mrtQFK0G4hgrikiwOuoOH54m+Fm0B4EzWbu1IxYmISb0aYRAgTq2BVRbVKIkglDzVZC2Eo2WXIWgCa3kXGuRsXL01HHBMRXKRit65kjm7/oemhiIQBQla0EUKiQORJgfAPs6E3yZMSIcJNst4kUUpAyLXd+UOHQpi5tPsV2ghD3u6LTClrn8zkkpzMFEKVt/wiVearI4MTtH0Vpk/0IURhvAHbs9UR+mLuUoKabxSCX8xdSpK1EP6SXeRRQ2EjULSLnOsV4Os8x86atSNE6Ziw1IooBQDqm+dZWO4twqKOFhcVICbKyTCfUDVVDg5FQa4KcpWkygEmwgqlcgvKl+HN/VVUWQCDrvL7FtAga56vBniIHuvQfrE0VHcRLlL0VTXRPIBFChcewoVqmQZcJDkZ5JZUuW+wUYWsqTlVDnss4NSW7OucyusKqi6A5DyW5kSMBowomR/NGn8moMPzgFRSHwtoZLxI8aeJzwY0wMNPdbOznwZkRLnM7KchHUFOhxmHpoazwR6yOR3jH0u5/YqqB/AQRmZHigF0qDo/ig1gIvhqQkekkjp6GGRGleLOKKJ5AIsUKHl5zwAiklxe3jPfoMKE8cKQrQNUxL6oYtwZKhYGYBGJnUfEiCv6GlAR+2EeG46qBpiI+M9jNqGqASZip85jjFDVkPUG9/GbZis0MQQG52aSIs6Oa4CD87NW3s+6ovsJaEhLzDDh/ploGmDBp8xcMUBCWrRniWEYmP8XOzTD9tiy//wu7+2p81eETozveV7ujpf82L3pHVBxccHYbLuHk9sN+7Z0E6iuf+jdDJl/fUOFXtgN8UJoSfLq+hXdh38BTulV+LsbAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f11 ?f6" svg:viewBox="0 0 0 0" draw:type="ooxml-foldedCorner" draw:modifiers="16667" draw:enhanced-path="M 0 0 L ?f11 0 ?f11 ?f6 ?f4 ?f8 0 ?f8 Z S N M ?f4 ?f8 L ?f5 ?f7 ?f11 ?f6 Z  S N M ?f4 ?f8 L ?f5 ?f7 ?f11 ?f6 ?f4 ?f8 0 ?f8 0 0 ?f11 0 ?f11 ?f6 F N" drawooo:enhanced-path="M 0 0 L ?f11 0 ?f11 ?f6 ?f4 ?f8 0 ?f8 Z S N M ?f4 ?f8 L ?f5 ?f7 ?f11 ?f6 Z I S N M ?f4 ?f8 L ?f5 ?f7 ?f11 ?f6 ?f4 ?f8 0 ?f8 0 0 ?f11 0 ?f11 ?f6 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *1/5"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 +?f3 -0"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 +?f3 -0"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f4 ?f8" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_foldedCorner("ooxml-foldedCorner", "H4sIAAAAAAAAALWV30+DMBDH/5UL8cEfa1bmxqYRl2hiYqK++OZbIy00ob3ZdRv611uoMAdOg1HIkdJeP/e9awsXiWGbc64zpp95QlKOilvzClW3ksagIRka+YbasjwOBMuXPNgZXnNj5XN70PLCEmY4W8YBBQpzEYbuEQWwXKfna8k3V1j4IXfXk14XPA4QC5UTgXnCk2s0mps6ICZSSG4cMoyiaPrR3ahfMJvFwX2FvPMRt4GdjZ3Nqq4ZPMEjPMB901v6T5xNtxOe4GefXWiT6KewN/DgdSLiP0q9/Sutlxe+qC8rZiVqX2LNlFsYUa+TQKNWOYsDKQ4pOaAwoAPXnFB3Va+lVW9HRw443CF+FyBsB1BSH+aYbmRis4FrZFymme0HHbWhLl84ngsKw7DUSHvRTru0ERyHw0kvyrhNqZM8oaQE9oJNupLGcDIXp0D65RZ9ocpX/Deypl1Z0a9kzfbK6oU521fz4ajfJu0cg0ZPX1Jnv9eS9mHc5yPJOXxqkwUuZenhl33eVOtj2DCdclIQxQqpVioOqnO5x0dq77NdH+/RqGn/KC7fAS/bqldBBgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f17 ?f20 ?f18 ?f21" svg:viewBox="0 0 0 0" draw:type="ooxml-smileyFace" draw:modifiers="4653" draw:enhanced-path="M 0 ?f19 Z S N M ?f2 ?f5 M ?f3 ?f5  N M ?f1 ?f8 Q ?f16 ?f11 ?f4 ?f8 F N M 0 ?f19 Z F N" drawooo:enhanced-path="M 0 ?f19 G ?f12 ?f14 ?f26 ?f27 Z S N M ?f2 ?f5 G ?f22 ?f23 ?f28 ?f29 M ?f3 ?f5 G ?f22 ?f23 ?f30 ?f31 I N M ?f1 ?f8 Q ?f16 ?f11 ?f4 ?f8 F N M 0 ?f19 G ?f12 ?f14 ?f32 ?f33 Z F N"><draw:equation draw:name="f0" draw:formula="if(-4653-$0 ,-4653,if(4653-$0 ,$0 ,4653))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*4969/21699"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth*6215/21600"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth*13135/21600"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth*16640/21600"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight*7570/21600"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight*16515/21600"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 +0-?f7 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f6 +?f7 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight*?f0 /50000"></draw:equation><draw:equation draw:name="f11" draw:formula="?f9 +?f10 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f13" draw:formula="?f12 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f14" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f15" draw:formula="?f14 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f16" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f17" draw:formula="?f16 +0-?f13 "></draw:equation><draw:equation draw:name="f18" draw:formula="?f16 +?f13 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f20" draw:formula="?f19 +0-?f15 "></draw:equation><draw:equation draw:name="f21" draw:formula="?f19 +?f15 -0"></draw:equation><draw:equation draw:name="f22" draw:formula="logwidth*1125/21600"></draw:equation><draw:equation draw:name="f23" draw:formula="logheight*1125/21600"></draw:equation><draw:equation draw:name="f24" draw:formula="logheight"></draw:equation><draw:equation draw:name="f25" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f26" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(21600000)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(21600000)/60000.0"></draw:equation><draw:equation draw:name="f30" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f31" draw:formula="(21600000)/60000.0"></draw:equation><draw:equation draw:name="f32" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f33" draw:formula="(21600000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f16 ?f9" draw:handle-range-y-maximum="4653" draw:handle-range-y-minimum="-4653"></draw:handle></draw:enhanced-geometry>
    ooxml_smileyFace("ooxml-smileyFace", "H4sIAAAAAAAAAK2XUa+aMBTHv0pD9qDuMmkrRW4ul2QPd9nDXbLsbW+NFmkC1AF6dZ9+nKLkSmFZcRrwUOqv/3Pov9WnbcnfHkWR8mIjtu5OqFzU5Rnp5lyWpSrdVJXytypqnkVOwrNKODe3j6Ks5aZ/sxan2uWl4FXkxAkOUJwQrznhNUTYQdVx93iU4u2zOkWOh/T7+t3zXkSOUqc8c6tcZuL8wjfdqGorEynKhrtiPr20dhnseZ1GzivSY4XoJ/qBvqFXGLM5fB1RHV2acXOs0XeIGJzgeqXbXnSPjtNctmMppUaH+wIfMBIGBgEiCQwR0ItASEAK0RUJ30m7vU+BTTH6aqf4VgqFiNJLHs9PbdF+HXgtVdGWsOB5U/Xk+hASVeaHjEeOTGYuVNr94KEHHT00TV0LHHAxnzfY5Q33b8Pg/jCZ2r3JbZ0uViELlwSzMLQCklEgI9gHoOdZAekoEFNMpxBX40TGVt4Eoj9ATIXcpfUi8IMpRDZOxMyfVMhgHBknHlpiD15WyHUfGScMffTcOAmQFSgcBAHGtVOEDd/0svStk8SGR+IkBHHYs1Y36o4lsQMZrtCrzGKjqtleLmYk0A9z3jzUdRvZ4Ycs0lbRVqhhDb0SLipZ/BehQz6ZVFDDHXpd13MZU7vJjAdsgfV0bki2M8ZwxtQnQQxn6P2pzdC3y5AMWAK3nvBtMyTjOwbGZMpCR4a2jOviORE5bgg7ztBOoZO1wxjTftb5Z8ng45Nlfsb0n+kiTQcaHrhXoWGEOxVSww93KqSGKe5VaDjjXoWGMf5dYfNDe5sJ9C5296qS0OOyvsXdLn65X/JiJ9yzm/OTzA/5zR+FfhdZtF30D9tOQ9urU9T/e/T8Bzrj0yY3DQAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f9 ?f12 ?f10 ?f11" svg:viewBox="0 0 0 0" draw:type="ooxml-heart" draw:enhanced-path="M ?f2 ?f12 C ?f5 ?f8 ?f6 ?f12 ?f2 ?f13 ?f3 ?f12 ?f4 ?f8 ?f2 ?f12 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*49/48"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*10/48"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 +0-?f0 "></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 +0-?f1 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 +?f1 -0"></draw:equation><draw:equation draw:name="f6" draw:formula="?f2 +?f0 -0"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/3"></draw:equation><draw:equation draw:name="f8" draw:formula="0+0-?f7 "></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth*1/6"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth*5/6"></draw:equation><draw:equation draw:name="f11" draw:formula="logheight*2/3"></draw:equation><draw:equation draw:name="f12" draw:formula="logheight/4"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight"></draw:equation></draw:enhanced-geometry>
    ooxml_heart("ooxml-heart", "H4sIAAAAAAAAAJXU3WqDMBgG4FuRHLYEE/9aS62wHW8XsLNQowmo6WKqdle/+FeoM4MgiZD4PQkvH54zSboTrRmprzSDBRUVVfLhjMsVl1JIyITkP6JWpExATsqGgpftlkrFr+tNRXsFiaSkSUCax06aY2+Y0DBh4DRtcWo57d5EnwDkjM9S+rjRBAjRVyVklEg1rz9veSOKJeBDS97kvutXqMdRj2g5atzz9eQvK8H8yVz15XyCy3miv+9EcVFPB9Wk0hfIl/vkQlb3kiSgFEXHM8V2QewGR13rvhT/Z2GjhZGt5Zks17Ny/LUzJLNHMM2RYwUFRgjbQeEmNDAQWUGRAUK20GEja0Z5wZTrW0HHNYTGgA52AcXmNnIju4Y0d3doS2019xTSzrOMCW819xx4YCf9ae+ntOG42//Byy/XmZsDIAUAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="21600 21600" draw:text-areas="?f2 ?f9 ?f5 ?f12" svg:viewBox="0 0 0 0" draw:type="ooxml-lightningBolt" draw:enhanced-path="M 8472 0 L 12860 6080 11050 6797 16577 12007 14767 12877 21600 21600 10012 14915 12222 13987 5022 9705 7602 8382 0 3890 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*5022/21600"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*8472/21600"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth*8757/21600"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth*10012/21600"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth*12860/21600"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth*13917/21600"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth*16577/21600"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight*3890/21600"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight*6080/21600"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight*7437/21600"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight*9705/21600"></draw:equation><draw:equation draw:name="f11" draw:formula="logheight*12007/21600"></draw:equation><draw:equation draw:name="f12" draw:formula="logheight*14277/21600"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight*14915/21600"></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f15" draw:formula="logheight"></draw:equation></draw:enhanced-geometry>
    ooxml_lightningBolt("ooxml-lightningBolt", "H4sIAAAAAAAAAJ2V227DIAyGX8XiclJUIAdI1bTSrrc9wO5YSxKkJHSEHranH6TttE5h0kiEZWH5iw38ZLUz4rSUQyuGrdwljdS9tOYDpuleGaNN0mqjPvVgRVehWnSjRHfhozRWbX8FtdbL8fCWHJU8JaP6lBWipMAYJnsFWHm2iTBSjBXa1BQ2delG7gahCMZjs/Tpj/pcIQzTe0v82Dug1ue+SzrVtHZQQ/OoO3uNf/ezF7at0DPwjFGX/wSE8gJDgTkGQnDuXFYyIEXOnKUYO5uxwvvczfwoGQjGhLpoSXIXdQ+QtOQMcuzckuEcWIEp8JT7L6W8xPAKL2i9ulT0fhBW6eFS3yB6V399a6fWpj90okKdbk5qZ9sHD11clmq9WtwR/gKSINAvQASQhoEsZxHANAic1jeCmIWJfq8jiHmYmJYkpusiTPQnL4LIZoit9FJ48EcvgsjDRC+XCGIZJrIsjemazCnmivQSjEHOaeaKnC6EGOacbG7MjEZtOJlTzjfTXUoxzKB2/oeZE8yltBnOYv6Ps/4C1QwCYIoGAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f25 ?f38 ?f24 ?f37" svg:viewBox="0 0 0 0" draw:type="ooxml-sun" draw:modifiers="25000" draw:enhanced-path="M ?f50 ?f47 L ?f30 ?f46 ?f30 ?f42 Z M ?f20 ?f21 L ?f31 ?f41 ?f32 ?f40 Z M ?f48 0 L ?f33 ?f39 ?f29 ?f39 Z M ?f22 ?f21 L ?f28 ?f40 ?f27 ?f41 Z M 0 ?f47 L ?f26 ?f42 ?f26 ?f46 Z M ?f22 ?f23 L ?f27 ?f45 ?f28 ?f44 Z M ?f48 ?f49 L ?f29 ?f43 ?f33 ?f43 Z M ?f20 ?f23 L ?f32 ?f44 ?f31 ?f45 Z M ?f34 ?f47 Z N" drawooo:enhanced-path="M ?f50 ?f47 L ?f30 ?f46 ?f30 ?f42 Z M ?f20 ?f21 L ?f31 ?f41 ?f32 ?f40 Z M ?f48 0 L ?f33 ?f39 ?f29 ?f39 Z M ?f22 ?f21 L ?f28 ?f40 ?f27 ?f41 Z M 0 ?f47 L ?f26 ?f42 ?f26 ?f46 Z M ?f22 ?f23 L ?f27 ?f45 ?f28 ?f44 Z M ?f48 ?f49 L ?f29 ?f43 ?f33 ?f43 Z M ?f20 ?f23 L ?f32 ?f44 ?f31 ?f45 Z M ?f34 ?f47 G ?f35 ?f36 ?f51 ?f52 Z N"><draw:equation draw:name="f0" draw:formula="if(12500-$0 ,12500,if(46875-$0 ,$0 ,46875))"></draw:equation><draw:equation draw:name="f1" draw:formula="50000+0-?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *30274/32768"></draw:equation><draw:equation draw:name="f3" draw:formula="?f1 *12540/32768"></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 +50000-0"></draw:equation><draw:equation draw:name="f5" draw:formula="?f3 +50000-0"></draw:equation><draw:equation draw:name="f6" draw:formula="50000+0-?f2 "></draw:equation><draw:equation draw:name="f7" draw:formula="50000+0-?f3 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f1 *23170/32768"></draw:equation><draw:equation draw:name="f9" draw:formula="50000+?f8 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="50000+0-?f8 "></draw:equation><draw:equation draw:name="f11" draw:formula="?f6 *3/4"></draw:equation><draw:equation draw:name="f12" draw:formula="?f7 *3/4"></draw:equation><draw:equation draw:name="f13" draw:formula="?f11 +3662-0"></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 +3662-0"></draw:equation><draw:equation draw:name="f15" draw:formula="?f12 +12500-0"></draw:equation><draw:equation draw:name="f16" draw:formula="100000+0-?f11 "></draw:equation><draw:equation draw:name="f17" draw:formula="100000+0-?f13 "></draw:equation><draw:equation draw:name="f18" draw:formula="100000+0-?f14 "></draw:equation><draw:equation draw:name="f19" draw:formula="100000+0-?f15 "></draw:equation><draw:equation draw:name="f20" draw:formula="logwidth*18436/21600"></draw:equation><draw:equation draw:name="f21" draw:formula="logheight*3163/21600"></draw:equation><draw:equation draw:name="f22" draw:formula="logwidth*3163/21600"></draw:equation><draw:equation draw:name="f23" draw:formula="logheight*18436/21600"></draw:equation><draw:equation draw:name="f24" draw:formula="logwidth*?f9 /100000"></draw:equation><draw:equation draw:name="f25" draw:formula="logwidth*?f10 /100000"></draw:equation><draw:equation draw:name="f26" draw:formula="logwidth*?f11 /100000"></draw:equation><draw:equation draw:name="f27" draw:formula="logwidth*?f13 /100000"></draw:equation><draw:equation draw:name="f28" draw:formula="logwidth*?f14 /100000"></draw:equation><draw:equation draw:name="f29" draw:formula="logwidth*?f15 /100000"></draw:equation><draw:equation draw:name="f30" draw:formula="logwidth*?f16 /100000"></draw:equation><draw:equation draw:name="f31" draw:formula="logwidth*?f17 /100000"></draw:equation><draw:equation draw:name="f32" draw:formula="logwidth*?f18 /100000"></draw:equation><draw:equation draw:name="f33" draw:formula="logwidth*?f19 /100000"></draw:equation><draw:equation draw:name="f34" draw:formula="logwidth*?f0 /100000"></draw:equation><draw:equation draw:name="f35" draw:formula="logwidth*?f1 /100000"></draw:equation><draw:equation draw:name="f36" draw:formula="logheight*?f1 /100000"></draw:equation><draw:equation draw:name="f37" draw:formula="logheight*?f9 /100000"></draw:equation><draw:equation draw:name="f38" draw:formula="logheight*?f10 /100000"></draw:equation><draw:equation draw:name="f39" draw:formula="logheight*?f11 /100000"></draw:equation><draw:equation draw:name="f40" draw:formula="logheight*?f13 /100000"></draw:equation><draw:equation draw:name="f41" draw:formula="logheight*?f14 /100000"></draw:equation><draw:equation draw:name="f42" draw:formula="logheight*?f15 /100000"></draw:equation><draw:equation draw:name="f43" draw:formula="logheight*?f16 /100000"></draw:equation><draw:equation draw:name="f44" draw:formula="logheight*?f17 /100000"></draw:equation><draw:equation draw:name="f45" draw:formula="logheight*?f18 /100000"></draw:equation><draw:equation draw:name="f46" draw:formula="logheight*?f19 /100000"></draw:equation><draw:equation draw:name="f47" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f48" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f49" draw:formula="logheight"></draw:equation><draw:equation draw:name="f50" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f51" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f52" draw:formula="(21600000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f34 ?f47" draw:handle-range-x-maximum="46875" draw:handle-range-x-minimum="12500"></draw:handle></draw:enhanced-geometry>
    ooxml_sun("ooxml-sun", "H4sIAAAAAAAAAO2Y226bQBCGX2WFepET9Z44OApB6k1v2j5A7lAMNpJhU4wTp0/fPdiAvYvVnevKMhnD8O3s8P9L4GnVFR+PZbsp2tdyFa5L0ZR994n07qbuOtGFG9HVf0TbF9ssqIrtrgzODr+XXV+/Xh7sy0MfFl1Z7LIgr2iE8oqlckO5ipIA7d7Xj+91+fFNHLIAI/05nfv5VmaBEIdmG+727Wk4saqruuwkkEYYn5KH2t+KfpMFPyU+wnLDE/RDDaXjeIgoekEqh6pflJgcoo6oDaMqwsccnsqidAJTm6U6Y2miI4SOEJqaU2WUGJzKmVRCYzP+KYrPIMzk6FOjAcfHSuRmaXJUCZydypLRdEaGY+bBh7lFxxzGTT0v6JdpnxDifwchHfyuYq1qVUqkciKq+/r8ZHT5e1/0tWiNStuikZKuTqKtRNfst0UW1NUNUWoOv2D0oKMHuYvHaRLpXeqrf93eSvDijHxtIHI5kHIMvsdhXmHkRaKXpLwi6I5hmvAFo0mcetGYkyYnzjGAxm0aRfd6qiH2IkU2icFI8XznqV/nk3kS8yOlzq5TRhJI15fuuvIqRZ69IpYfximmflMkluLzKpY6XXA/jEPuCQDj0jlB9yyOqW+PHCInFIZyqFyhzArkybJ0TvBw7eRU/WCW1KcwT7ETS+1TGPeEWWKfwiLPpdSS+1asP+pVv7kjKWfxgpIY+10GasleIjdlvd70d4zEDIK0LDBUCSVabhiLBE/cssVQZV4t0cJcJj+kZY8JkmAY07LJlElgTMstUyaDMS3TTJkcxrS8M2VGICabt5BkxjCmy0MDM4Ex500kmSmM6bLRwIRpnl2zEUzy7KqNYEiXi44LCJjpctHABHbT5aKxTmA/XTYaobDZc5ePRihsEeFXbkbgVYS7nDRCYcsIv3JHAq8j3OWlEQpbSLjLTSMUtpLw636CiZ/PG2pB/UizNyNf0Lx1/J4OZ+86fhjLHzcEp7rTt4tY/fnq+dRqeeNG/yf1L8BN0a62JZrE4ZvY1SpDP/2a9xzBWUJXtOsyPIRNcaibfZMF+tXETE7dmhz9dDFUYbKGmi5fPD7/BdnjxLiRFAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f19 ?f26 ?f3 ?f27" svg:viewBox="0 0 0 0" draw:type="ooxml-moon" draw:modifiers="50000" draw:enhanced-path="M ?f37 ?f38 Z N" drawooo:enhanced-path="M ?f37 ?f38 G ?f39 ?f13 ?f40 ?f41 ?f29 ?f14 ?f42 ?f43 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(87500-$0 ,$0 ,87500))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *logwidth/?f1 "></draw:equation><draw:equation draw:name="f4" draw:formula="?f1 +0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 *?f2 /?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="?f1 *?f1 /?f4 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 *2/1"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f5 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 +0-?f2 "></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 *logwidth/?f1 "></draw:equation><draw:equation draw:name="f11" draw:formula="?f8 *1/2"></draw:equation><draw:equation draw:name="f12" draw:formula="?f11 +0-?f2 "></draw:equation><draw:equation draw:name="f13" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 *?f13 /?f1 "></draw:equation><draw:equation draw:name="f15" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f16" draw:formula="?f15 +0-?f14 "></draw:equation><draw:equation draw:name="f17" draw:formula="?f15 +?f14 -0"></draw:equation><draw:equation draw:name="f18" draw:formula="?f2 *9598/32768"></draw:equation><draw:equation draw:name="f19" draw:formula="?f18 *logwidth/?f1 "></draw:equation><draw:equation draw:name="f20" draw:formula="?f1 +0-?f18 "></draw:equation><draw:equation draw:name="f21" draw:formula="?f1 *?f1 /1"></draw:equation><draw:equation draw:name="f22" draw:formula="?f20 *?f20 /1"></draw:equation><draw:equation draw:name="f23" draw:formula="?f21 +0-?f22 "></draw:equation><draw:equation draw:name="f24" draw:formula="sqrt(?f23 )"></draw:equation><draw:equation draw:name="f25" draw:formula="?f24 *?f13 /?f1 "></draw:equation><draw:equation draw:name="f26" draw:formula="?f15 +0-?f25 "></draw:equation><draw:equation draw:name="f27" draw:formula="?f15 +?f25 -0"></draw:equation><draw:equation draw:name="f28" draw:formula="?f10 +0-?f3 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f28 *1/2"></draw:equation><draw:equation draw:name="f30" draw:formula="?f3 +?f29 -logwidth"></draw:equation><draw:equation draw:name="f31" draw:formula="?f30 *-1/1"></draw:equation><draw:equation draw:name="f32" draw:formula="?f13 *-1/1"></draw:equation><draw:equation draw:name="f33" draw:formula="(10800000*atan2(?f32 ,?f31 ))/pi"></draw:equation><draw:equation draw:name="f34" draw:formula="(10800000*atan2(?f13 ,?f31 ))/pi"></draw:equation><draw:equation draw:name="f35" draw:formula="?f34 +0-21600000"></draw:equation><draw:equation draw:name="f36" draw:formula="?f35 +0-?f33 "></draw:equation><draw:equation draw:name="f37" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f38" draw:formula="logheight"></draw:equation><draw:equation draw:name="f39" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f40" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f41" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f42" draw:formula="(?f33 )/60000.0"></draw:equation><draw:equation draw:name="f43" draw:formula="(?f36 )/60000.0"></draw:equation><draw:handle draw:handle-position="?f3 ?f15" draw:handle-range-x-maximum="87500" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_moon("ooxml-moon", "H4sIAAAAAAAAAKWXzXLaMBSFX0Xj6QIorvVjY5OJw0w3XbUP0J0myFgz2CLGENKnryRj0iBB5yowCP+IT4fLORf7cd3x1wfR1rx9Fut4I1Qj+u4N2cON7DrVxbXq5B/V9nxbRhXf7kX04fRRdL18vj7Zi1Mf807wfRmtKrJEq4ou9MDMRh6h/XHzcJTi9bs6lRFG9jl+9G0nykipU7ONG6XacTm1lpUUnQZmWD/Ohy/ad7yvy+inWSM3Q4F+o1/DJKXUvXk/zJtRSIy6FJuBGJ32WGp2qRmYJT49Duu+HHgvVTuoaHmjNVejqEp1zWHLy0hWExx/wWiO53qzyLVyu2tedm861cDkA/HeAuR6gUa2k63avMp1X8/1Ri3kpu5hUHoN1d8azVYVRgnBttQQGnNpFM1GjYlhg3ipT91XHBssCJR5hZlBi0phrMWNkpEAVu6yFmhGEwKiFC4lH8qUweQsXVARVG/ipGFVLT/jBOK430ibkYTCMD6/h1mKOGa/RBAqymdza0/dlAJK5Zg9WJjP6tlQLQJ0OvFY3bAsKYa1GeIxvK7XMlsWCaP5ooDRPK4nxWfMSj3uP5tMg2Eoj+/HbgNrEtRjfYptE8Rglq/RjzEC5og67t+/dP1EgxgC/pf5unwanCN6x/0U2FjpTfdrEtD91ON+ggddDCjLY30a0FaZx/DMfrslisccwYge3zPt1pgArcp8HZ+FgBzPTwgu7DXSjPe8pdqyjKK5HgmaTpOdhOGdGLh4rTsY78kGS41pKFkEXOh5ssHO2WBAEzInG2GOcWJx+duDcZxMBMlJnUhMstQWeprYgn+DVTx1AnHxRyDQCcbE/naBNDcdmrb4P03fma23Av2zHe/UXpoZQxdZvV/QnM93vN2I+BQ3/CSbQ1NG9m7qxhzZDnPeBQwzLnKu73+f/gINE3XRGA8AAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="43200 43200 43200 43200" draw:text-areas="?f0 ?f1 ?f2 ?f3" svg:viewBox="0 0 0 0" draw:type="ooxml-cloud" draw:enhanced-path="M 3900 14370 Z N M 5333 7267 M ?f14 ?f15 M 5333 7273 M ?f20 ?f21 M 6752 9215 M ?f26 ?f27 M 4345 5945 M 4345 5945 M 4360 5918 M 6752 9215 M 6752 9215 F N" drawooo:enhanced-path="M 3900 14370 G 6753 9190 ?f10 ?f11 5333 7267 ?f12 ?f13 4365 5945 ?f14 ?f15 4857 6595 ?f16 ?f17 5333 7273 ?f18 ?f19 6775 9220 ?f20 ?f21 5785 7867 ?f22 ?f23 6752 9215 ?f24 ?f25 7720 10543 ?f26 ?f27 4360 5918 ?f28 ?f29 4345 5945 ?f30 ?f31 Z N M 4693 26177 G 4345 5945 ?f32 ?f33 M 6928 34899 G 4360 5918 ?f34 ?f35 M 16478 39090 G 6752 9215 ?f36 ?f37 M 28827 34751 G 6752 9215 ?f38 ?f39 M 34129 22954 G 5785 7867 ?f40 ?f41 M 41798 15354 G 5333 7273 ?f42 ?f43 M 38324 5426 G 4857 6595 ?f44 ?f45 M 29078 3952 G 4857 6595 ?f46 ?f47 M 22141 4720 G 4365 5945 ?f48 ?f49 M 14000 5192 G 6753 9190 ?f50 ?f51 M 4127 15789 G 6753 9190 ?f52 ?f53 F N"><draw:equation draw:name="f0" draw:formula="logwidth*2977/21600"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight*3262/21600"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth*17087/21600"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight*17337/21600"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth*67/21600"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight*21577/21600"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth*21582/21600"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight*1235/21600"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f10" draw:formula="(-11429249)/60000.0"></draw:equation><draw:equation draw:name="f11" draw:formula="(7426832)/60000.0"></draw:equation><draw:equation draw:name="f12" draw:formula="(-8646143)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(5396714)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(-8748475)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(5983381)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(-7859164)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(7034504)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(-4722533)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(6541615)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(-2776035)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(7816140)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(37501)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(6842000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(1347096)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(6910353)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(3974558)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(4542661)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(-16496525)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(8804134)/60000.0"></draw:equation><draw:equation draw:name="f30" draw:formula="(-14809710)/60000.0"></draw:equation><draw:equation draw:name="f31" draw:formula="(9151131)/60000.0"></draw:equation><draw:equation draw:name="f32" draw:formula="(5204520)/60000.0"></draw:equation><draw:equation draw:name="f33" draw:formula="(1585770)/60000.0"></draw:equation><draw:equation draw:name="f34" draw:formula="(4416628)/60000.0"></draw:equation><draw:equation draw:name="f35" draw:formula="(686848)/60000.0"></draw:equation><draw:equation draw:name="f36" draw:formula="(8257449)/60000.0"></draw:equation><draw:equation draw:name="f37" draw:formula="(844866)/60000.0"></draw:equation><draw:equation draw:name="f38" draw:formula="(387196)/60000.0"></draw:equation><draw:equation draw:name="f39" draw:formula="(959901)/60000.0"></draw:equation><draw:equation draw:name="f40" draw:formula="(-4217541)/60000.0"></draw:equation><draw:equation draw:name="f41" draw:formula="(4255042)/60000.0"></draw:equation><draw:equation draw:name="f42" draw:formula="(1819082)/60000.0"></draw:equation><draw:equation draw:name="f43" draw:formula="(1665090)/60000.0"></draw:equation><draw:equation draw:name="f44" draw:formula="(-824660)/60000.0"></draw:equation><draw:equation draw:name="f45" draw:formula="(891534)/60000.0"></draw:equation><draw:equation draw:name="f46" draw:formula="(-8950887)/60000.0"></draw:equation><draw:equation draw:name="f47" draw:formula="(1091722)/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(-9809656)/60000.0"></draw:equation><draw:equation draw:name="f49" draw:formula="(1061181)/60000.0"></draw:equation><draw:equation draw:name="f50" draw:formula="(-4002417)/60000.0"></draw:equation><draw:equation draw:name="f51" draw:formula="(739161)/60000.0"></draw:equation><draw:equation draw:name="f52" draw:formula="(9459261)/60000.0"></draw:equation><draw:equation draw:name="f53" draw:formula="(711490)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_cloud("ooxml-cloud", "H4sIAAAAAAAAAJ2Y2W7bOhCGX0XwlU8BNZyFywRxCvSiuWofoHdqIscGbKvHdpb26TuU3XqhHCCDwIQkUz9/zvAjx7l5WDcv1+1q1qzu24f6se2W7Xb9q+ofL+frdbeuZ916/rtbbZvFZDRtFpt2dPL1c7vezu/Pvuy67nrz9KN+nrcv9Wb+u52MmNC5qmj3Ytv2dVs367bZTEafpq76NAX9oH5oVG2eH6+z0ufudTJyVf/3971fP1W7616Xi/p+0T097J//m9LPZjubjL5WJDoiMEVXfa++VV8rT0RVxBD1Wkfj3PjD80j9c8xWEPQ6RI+VYN9HH4Xc5HeZ2Fde2BfXwek1pLN3D9dfqm+HaL1l+C6/RJWA9IHpGziagN7mSAHlQfcGDlPi5GMVvPTPsm2IR5PU25Qb0TGiV2O7Ge+n7WPyVUz9GJjHQDqagN7mMVC7RH0DnGc6is0hAnrbN3IUIc1sHoRgnw8OQhUGiFHne9KtXwU5HUFUhjiJ9F0O6pRtUI4uBI4px072YftnlbIryhnDlNQdcfRw3qcXE+1DDOoWUTxrn+MwcHbNeUUwREkVeNr1OQopZ8ucLVMijZFnjcndSSY4W+4XCorrLauNsy7ZMfeOEXREzkG+O8kxZ8OcDQM7XS8eBM+Wi++bnV+dNuhc5LxLtqu3eUHe3uz4+f+p2c671Y6mVbNUyqZ/oZt26+XTopmMFt3jy/xhO/uAEuMVQlCeb2+uThTeEoQBwVk7f5xtPxAGNCjiRYsQXbJ4pMseIRJZJPmiyWCR85cd6rI2JSZczjT4ZElMfCOMSN6gmC4qXuG7hOTSZN+pAwUf4xqAUZDlvyudnnMf38lHAcg46laie4pRr8BjXKfAQY8Zo2BBx9iThAhs1CvQUIORk+7VRsECjrGXRJTAqFeQMa71cBA9d4yCBRjj6PT0c1a9AotxrQcH6vFkFCzwGAfPEMCYERygBGMMjqyCA5Ak9cfOqFdCQtE744LBkpCQWAtfq7uSENBSxkkw6pWABAFNhnG5YAkISWTvk1Gv5INzORWs+RjgQ+GV4NG6/kpAUnKsWbHp0dAxwslJBOOaoZIQAQ9AxhhSSYhHx/ox6pWMaJWhlYtVr2SEdccKaFyDNMBIUoqtciUiCX1ka5VAJSKJOQXjjkAlIZQiWDcYKvEQL2LdT3mADkaIeiQZBUs4GL2ev8Yai0s4IOnvrGTVG4AjBK8/cI16QyUWcghWvRKOpLuLdffjgQIriXcpRaNgSQc4AS2JjHoDB4jo7hy8ERAuAQEXAKwlqh8ixDlkMEbQDxRYpBWv1V8JiLAXNOuVgET92fU2H/v783983v4B+HOPqxEVAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f36 ?f42 ?f24 ?f30" svg:viewBox="0 0 0 0" draw:type="ooxml-arc" draw:modifiers="16200000 0" draw:enhanced-path="M ?f16 ?f18 L ?f15 ?f17 Z S N M ?f16 ?f18 F N" drawooo:enhanced-path="M ?f16 ?f18 G ?f5 ?f7 ?f46 ?f47 L ?f15 ?f17 Z S N M ?f16 ?f18 G ?f5 ?f7 ?f48 ?f49 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(21599999-$0 ,$0 ,21599999))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(0-$1 ,0,if(21599999-$1 ,$1 ,21599999))"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 +0-?f0 "></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 +21600000-0"></draw:equation><draw:equation draw:name="f4" draw:formula="if(?f2 ,?f2 ,?f3 )"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 *sin(pi*(?f0 )/10800000)"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 *cos(pi*(?f0 )/10800000)"></draw:equation><draw:equation draw:name="f9" draw:formula="?f5 *(cos(atan2(?f6 ,?f8 )))"></draw:equation><draw:equation draw:name="f10" draw:formula="?f7 *(sin(atan2(?f6 ,?f8 )))"></draw:equation><draw:equation draw:name="f11" draw:formula="?f5 *sin(pi*(?f1 )/10800000)"></draw:equation><draw:equation draw:name="f12" draw:formula="?f7 *cos(pi*(?f1 )/10800000)"></draw:equation><draw:equation draw:name="f13" draw:formula="?f5 *(cos(atan2(?f11 ,?f12 )))"></draw:equation><draw:equation draw:name="f14" draw:formula="?f7 *(sin(atan2(?f11 ,?f12 )))"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f16" draw:formula="?f15 +?f9 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f18" draw:formula="?f17 +?f10 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="?f15 +?f13 -0"></draw:equation><draw:equation draw:name="f20" draw:formula="?f17 +?f14 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="21600000+0-?f0 "></draw:equation><draw:equation draw:name="f22" draw:formula="?f4 +0-?f21 "></draw:equation><draw:equation draw:name="f23" draw:formula="max(?f16 ,?f19 )"></draw:equation><draw:equation draw:name="f24" draw:formula="if(?f22 ,logwidth,?f23 )"></draw:equation><draw:equation draw:name="f25" draw:formula="5400000+0-?f0 "></draw:equation><draw:equation draw:name="f26" draw:formula="27000000+0-?f0 "></draw:equation><draw:equation draw:name="f27" draw:formula="if(?f25 ,?f25 ,?f26 )"></draw:equation><draw:equation draw:name="f28" draw:formula="?f4 +0-?f27 "></draw:equation><draw:equation draw:name="f29" draw:formula="max(?f18 ,?f20 )"></draw:equation><draw:equation draw:name="f30" draw:formula="if(?f28 ,logheight,?f29 )"></draw:equation><draw:equation draw:name="f31" draw:formula="10800000+0-?f0 "></draw:equation><draw:equation draw:name="f32" draw:formula="32400000+0-?f0 "></draw:equation><draw:equation draw:name="f33" draw:formula="if(?f31 ,?f31 ,?f32 )"></draw:equation><draw:equation draw:name="f34" draw:formula="?f4 +0-?f33 "></draw:equation><draw:equation draw:name="f35" draw:formula="min(?f16 ,?f19 )"></draw:equation><draw:equation draw:name="f36" draw:formula="if(?f34 ,0,?f35 )"></draw:equation><draw:equation draw:name="f37" draw:formula="16200000+0-?f0 "></draw:equation><draw:equation draw:name="f38" draw:formula="37800000+0-?f0 "></draw:equation><draw:equation draw:name="f39" draw:formula="if(?f37 ,?f37 ,?f38 )"></draw:equation><draw:equation draw:name="f40" draw:formula="?f4 +0-?f39 "></draw:equation><draw:equation draw:name="f41" draw:formula="min(?f18 ,?f20 )"></draw:equation><draw:equation draw:name="f42" draw:formula="if(?f40 ,0,?f41 )"></draw:equation><draw:equation draw:name="f43" draw:formula="?f0 +0-5400000"></draw:equation><draw:equation draw:name="f44" draw:formula="?f1 +5400000-0"></draw:equation><draw:equation draw:name="f45" draw:formula="(?f43 +?f44 )/2"></draw:equation><draw:equation draw:name="f46" draw:formula="(?f0 )/60000.0"></draw:equation><draw:equation draw:name="f47" draw:formula="(?f4 )/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(?f0 )/60000.0"></draw:equation><draw:equation draw:name="f49" draw:formula="(?f4 )/60000.0"></draw:equation><draw:handle draw:handle-position="?f16 ?f18"></draw:handle><draw:handle draw:handle-position="?f19 ?f20"></draw:handle></draw:enhanced-geometry>
    ooxml_arc("ooxml-arc", "H4sIAAAAAAAAAK1YTXObMBD9KxqmBzuJG31hIBPHMz20lzaX3nrT2GCYMcjFJHH666sPyMReNc3i2GPhAfT03q6eVnC7btXTTd6Uqlnl69km13Xetc/Ena6rttXtrNRt9Uc3ndouokJt93l0dPkxb7tqdXqxyw/dTLW52i+iZSHmZFlIbhouTSNoRPaPm5vHKn/6og+LiBL3Hfo+7/JFpPWh3hqI1TCcXldFlbcGkM05tZ+XHi8CdqorF9EPMwazQ7KUfLeH2DYJ+UV+knvy+upXcu8htNZvoXwzBwuSWB1OTPIf5KMeqW0yN9rdrWf8+0F1lW48/0bVRnExyCl0Wz9s1SKqigmdfaLkil6Zv5zFmf24M/Y3nJhODez1Ee5bw7DwMAwMY87Y38hh+OkwJi7kks6WBSUoIAGBOLnkbO4mwYyiwGRAvMW76htBcCrjU7yt3jxV66685iicORQZk4t91Ux21cXExmx6zWjqJOMYJgGGZV5tyg5JMYUUE3Kx0vuzKWZB8RMLrTrVcAM+t8lJyRQ714GnHOmJDey50MBHJyljo+PBAt45CvUZ0AE3ncaaMRsRxvEhAe6C0R4P/lFWYwGvmYX8cllkBLmasA8zFwu4yxQWQ4pRNKuAn7xAJrBYPGCgnpdEYwHHDIv4mLLAAyaRvsBwhoQCpqjVYeKKuZ2rGbIm8H8UGVNghilryw221HBggFiOjx4wAU/oeDTgA684dnXVt3Os3IAjhvwmSHrAEH1+U8eMIpmJ0EbN4KQuv97+Fhc7bwTwx7DGj9o2AX8IPn6+CGARp1m41bxvOVZvoFz0GRYCSQ94ozY1Z7SDBXCHVyvtHtkcYywe8MfwDDMqF8AZIjljngBzeK2Jy6lvU6ReGagaQ2YzHD0JTNFndpx3JXCFUyupz6xkWLzAfopapf3ajAMLGMI8M/VQ2CcdYAmrU9jSLaXZP+L2JxI4ot/xuwL+GUkN2MFSGwsG3HAOM2CG9zErVbPe5uTV/9lO7yt7h0uifyvw0tvf8s6+mX1vQkHfnsfpu5u7v1ftcYjUEQAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f5 ?f5 ?f6 ?f7" svg:viewBox="0 0 0 0" draw:type="ooxml-bracketPair" draw:modifiers="16667" draw:enhanced-path="M 0 ?f2 L ?f3 0 L ?f11 ?f4 L ?f2 ?f10 Z S N M ?f2 ?f10 L 0 ?f2 M ?f3 0 L ?f11 ?f4 F N" drawooo:enhanced-path="M 0 ?f2 G ?f2 ?f2 ?f12 ?f13 L ?f3 0 G ?f2 ?f2 ?f14 ?f15 L ?f11 ?f4 G ?f2 ?f2 ?f16 ?f17 L ?f2 ?f10 G ?f2 ?f2 ?f18 ?f19 Z S N M ?f2 ?f10 G ?f2 ?f2 ?f20 ?f21 L 0 ?f2 G ?f2 ?f2 ?f22 ?f23 M ?f3 0 G ?f2 ?f2 ?f24 ?f25 L ?f11 ?f4 G ?f2 ?f2 ?f26 ?f27 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 *29289/100000"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="logheight+0-?f5 "></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f12" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="0 ?f2" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_bracketPair("ooxml-bracketPair", "H4sIAAAAAAAAAK2WXY+jIBSG/woxe2Fn6xRo1XYyTpO92L2ZTibZu71jW1QyKl1qv/bXL2B1qqxNrLYRgQMP74FzIs8bQY5PNItJtqYbJ6I8pbk4A92dMiG4cGIu2F+e5SQJrJAkO2rVzAcqcrZuGnN6yh0iKNkF1jJ0QfF48vEtsDtETwdGj9/4KbAg0P9y3nlLA4vzU5o4vwVZf9D8nTBRLsk3LGRUSCjyPM+/dFf6tySPA2slecsQg1dZTmVdvRGSxUxXsWpC8Av8BG9g9dnxepm2Mqd9B2/FUpzzttV+XEiapotppaBmm6nCvcbXzGqPkH+ttGaeq2Jhqr8ehLUiVHlUs+liWnlZsylpuFUaVtKwr3fj5bnY+T97kjOeFeeQkVQeXlieZchFuk9IYLHQhs4XCMZwLKsulD/dVI9ujUYSOKkRby2AmgukLLMTHh3ZJo/HshJTFsV5NyhuQuUegIdlCMEEKY2wE23apJXyvkJH7WYn2Ow/sMLFe2iu6SgGD3iB54t7PPVueup20+bf9rQjbd4mbYI7cRatqjqCkJEaFakbx8iA0rNuGCPmbQTnOgRGE0+9HrvFAjLC3nZnfXhG5NvIw32ARvD3FGhEv30vyQj9nsqM4O/JM5KgHw8bqdCTZ6RET97QuYEHzg08dG7ggXMDD5Yb+P7ckFe1TULBVd3Z8h1TI9TVc1l99i9GQbKIOmcnJSeW7tPA0veTljEsK8Z8rl6MqLQ079Uv/wAjeKPFcAsAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f11 ?f11 ?f12 ?f13" svg:viewBox="0 0 0 0" draw:type="ooxml-bracePair" draw:modifiers="8333" draw:enhanced-path="M ?f3 ?f15 L ?f2 ?f8 L ?f2 ?f2 L ?f2 ?f2 L ?f2 ?f2 L ?f2 ?f2 Z S N M ?f29 ?f30 L ?f31 ?f32 L ?f33 ?f34 M ?f35 ?f36 L ?f2 ?f2 L ?f4 0 F N" drawooo:enhanced-path="M ?f3 ?f15 G ?f2 ?f2 ?f17 ?f18 L ?f2 ?f8 G ?f2 ?f2 ?f19 ?f20 ?f2 ?f2 ?f21 ?f22 L ?f2 ?f2 G ?f2 ?f2 ?f23 ?f24 L ?f4 0 G ?f2 ?f2 ?f25 ?f26 L ?f5 ?f7 G ?f2 ?f2 ?f27 ?f28 ?f2 ?f2 ?f29 ?f30 L ?f5 ?f9 G ?f2 ?f2 ?f31 ?f32 Z S N M ?f3 ?f15 G ?f2 ?f2 ?f33 ?f34 L ?f2 ?f8 G ?f2 ?f2 ?f35 ?f36 ?f2 ?f2 ?f37 ?f38 L ?f2 ?f2 G ?f2 ?f2 ?f39 ?f40 M ?f4 0 G ?f2 ?f2 ?f41 ?f42 L ?f5 ?f7 G ?f2 ?f2 ?f43 ?f44 ?f2 ?f2 ?f45 ?f46 L ?f5 ?f9 G ?f2 ?f2 ?f47 ?f48 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(25000-$0 ,$0 ,25000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="?f1 *?f0 /50000"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth+0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f6" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 +0-?f2 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 +?f2 -0"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f10" draw:formula="?f2 *29289/100000"></draw:equation><draw:equation draw:name="f11" draw:formula="?f2 +?f10 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth+0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="logheight+0-?f10 "></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f15" draw:formula="logheight"></draw:equation><draw:equation draw:name="f16" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f17" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f30" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f31" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f32" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f33" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f34" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f35" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f36" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f37" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f38" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f39" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f40" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f41" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f42" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f43" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f44" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f45" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f46" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f47" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="0 ?f2" draw:handle-range-y-maximum="25000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_bracePair("ooxml-bracePair", "H4sIAAAAAAAAAK1Y0W6bMBT9FQvtgXZlMbaTkqq00h62l62atLe9eY0JlgLuCG3Tff24UFLIhU7GJAox9uXcc6/PEQnXm0I+X6k8lfm92gRbZTJVFi+kns50UZgiSE2h/5q8lLvYS+Rur7ze8pMqSn1/uliqQxnIQsl97N0mYUjaA4MD98j+aXv1pNXzZ3OIPUrqd3vty4OKPWMO2S74Xch79UPqok1qNjrRqqhgI8756+yxgAdZprH3vcrBIc+SfKu+IGV0HLH/jH6Rn+SOAARbAw6t1ziQ500cB2wu6hi+hMPqBElU1Xwhdw07Y8w7BL8eL6xOL+EQdUj3VoEOo50ZBqRYl3w3nkEGJo6EemtAmzW0YXjZXwUeLOrOdFoB8etefNuct9YNFNd2bbi4to+dGSDBo5HiOBAStE52WpwAOoKNFCeAhxDdGQgSq5HiBPAQUb2fN9eN3P48ylKbvBFfLrNKrkmr3sQU2eNOxp5OfBp8oOSCXlRDtqS0OYVPfXZ2VgEueojvJQhPE2Q693dm+6w3ZXpRDVKlt2lpB8pOQat9I+e3CSWLkMLLCo2Poy2twcQpWFvrRxqAwqzAlu+CMTuw1QBY0/wFswK6xP1akSmMokEggAnsmr4eLW0KrRCZAiDO2ZpF6yn6CpEHAK+qM6S2hYZI+T1FVDcrOzgk/X7jKoJ2eKPqt5RYOKT8hpgdzpDoa0J2MEjy/lLUQjhbrODrk+U2IuU74iED+BORGNK+HzhRY0j8bqUy5ABXgsgDfkgjF0BkAseKkRf8cMVcAJEpHAlidzh2ENvDcY+xP9xayOe2Ccc2mYqEDeLGDPvDDW9me3Bsj6lI2BeOmzrzbYPP7Qs+4Asn5wrsCyeCAtvCzbhiZneIue8eAtvDbY/F3LcPMbdNBLbJVKTpv6tSmW92inTGwYPZa4iAJz23x/+cr4uFzLcqeAkyedDZYxZ79Z/jkRidNzFv2ZuII5fTR1k3/wCrQ1wp4xIAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f7 ?f8 ?f10 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-leftBracket" draw:modifiers="8333" draw:enhanced-path="M ?f10 ?f12 L 0 ?f3 Z S N M ?f10 ?f12 L 0 ?f3 F N" drawooo:enhanced-path="M ?f10 ?f12 G ?f13 ?f3 ?f14 ?f15 L 0 ?f3 G ?f13 ?f3 ?f16 ?f17 Z S N M ?f10 ?f12 G ?f13 ?f3 ?f18 ?f19 L 0 ?f3 G ?f13 ?f3 ?f20 ?f21 F N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="50000*logheight/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight+0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth*cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f6" draw:formula="?f3 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f3 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="logheight+?f6 -?f3 "></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f11" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f12" draw:formula="logheight"></draw:equation><draw:equation draw:name="f13" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f14" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="0 ?f3" draw:handle-range-y-maximum="?f1" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_leftBracket("ooxml-leftBracket", "H4sIAAAAAAAAAK2WTXOjIBjHvwrj7MG4sUGNeenUZqaH7mW3l73tjYmozIqkSN766Rcw2o2YzlI3GREBf/yfB/7qQ8rR8R5XBaq2OPVzzCgW/Ax0MyWcM+4XjJM3VglUJk6Gyho7V90HzAXZ9jsFPgkfcYzqxNlkS7DJVvIIoCzWDqgP+f2B4OMTOyUOBPrf3nje4cRh7ERLv8SZeOJo+xuLdk6WkoxgLqmrKIourZ3+HRJF4vxoZwpC8B2oSgR+gZ/gBQz1PIOXBsMY+4j0TZ0ifYuszFURd5DrzoUqlgNzXg/TGVkPM0LVFgZa3eNDE+XrHgnCqibmClGZp6xNW8Y43ZcocSip3JLlR5KKYiorBSZ5ISYSMruifAQN+tAYyp/X0WabDAIrYtgnksyF/hcIpnAqqzJwoK/UoS4mdoKjPl4J9GQCwSxQ0qEVbd6ndYF/hb5aHitaPEDTq+NtWe3uiOeGS61xIrWumprVBAsz+Ah4tdwH/wG+vKVepyK2S8VqSKkGLexA69srpFj2ixQYPmrjtMMYznn3TGhHMhzTkew4hjU+F5jhCTeeXzbWQp3u7CwWGK4YyTNM4Hb7/XNAY+OPFGjs/ZE8wwLjeKFhgJEJDA0r/LNA+QpOSwz+qvs7VhM1Qn0tbLrH/aWToyrH/tmn6ETonqrHSnBjBKmaEe9zNyM6Jf0vocc/oLIVFCIJAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 ?f8 ?f7 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-rightBracket" draw:modifiers="8333" draw:enhanced-path="M 0 0 L ?f10 ?f4 Z S N M 0 0 L ?f10 ?f4 F N" drawooo:enhanced-path="M 0 0 G ?f13 ?f3 ?f14 ?f15 L ?f10 ?f4 G ?f13 ?f3 ?f16 ?f17 Z S N M 0 0 G ?f13 ?f3 ?f18 ?f19 L ?f10 ?f4 G ?f13 ?f3 ?f20 ?f21 F N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="50000*logheight/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight+0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth*cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f6" draw:formula="?f3 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f7" draw:formula="0+?f5 -0"></draw:equation><draw:equation draw:name="f8" draw:formula="?f3 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="logheight+?f6 -?f3 "></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f11" draw:formula="logheight"></draw:equation><draw:equation draw:name="f12" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f13" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f14" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f10 ?f3" draw:handle-range-y-maximum="?f1" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_rightBracket("ooxml-rightBracket", "H4sIAAAAAAAAAK2W35OaMBDH/5UM0wfkTCUgqDfHOXMP7Ut7L/fWt4wEyBSIDfFX//omQbiDaKfR6gRDsn72u5td8Snl+PBI6gLXG5LCnLCKCH4CerminDMOC8bpb1YLXCZOhsuGOIPtPeGCbsabghwFxJzgJnF8sM6WcizkWDmg2eePe0oOL+yo9vS7+9ZpSxKHsWNVQk7zQrxwvPlJROeRpTSjhEvmMgzD82qvfotFkTjfNfGb9IWU4zn4Ad7AKzCWv4DXFsAYu8z4qoxDeVEDzdUl+kgY7sfqshh4GxqoFKDVVUCg1gKkdT0/tZH92mFBWd3GWeNKJifrcpUxXu1KnDgVrd2S5QeaimIqJwVRmZtIyGxA+RsUjaGRL19eT5utMx9YEYMxkWauDz/5YOpP5VQGDvSdGupmYic4HOOVQE8mEMyQku5b0eZjWh/4gw/V8VjRogs0fTrehjXulnpusNAaJ1Lrsp1ZOYjN4EPgNbIO/gN8MYb7D+ssAtAuo8tLEnUyY7tkrq4fjWLZnw4yGqg7HjuM0TK9MDuO0SjvTRfYkYyeuC0woxlcFAfnkorVx2e7UkBGP7jR/B6eUf7urSSj1u9UZlT9vakzqv8+gYFR+7emLjDK/5+VySdtWhLwYQ63rKHKQv1M6GdjV8rnfY7rnMATrPCRVrtKm12xoHVr8e6+tejFjP/rPP8BXDU5ogQJAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f13 ?f14 ?f17 ?f15" svg:viewBox="0 0 0 0" draw:type="ooxml-leftBrace" draw:modifiers="8333 50000" draw:enhanced-path="M ?f17 ?f18 L ?f16 ?f9 L ?f10 ?f7 Z S N M ?f10 ?f7 L ?f10 ?f7 L ?f10 ?f7 F N" drawooo:enhanced-path="M ?f17 ?f18 G ?f10 ?f7 ?f19 ?f20 L ?f16 ?f9 G ?f10 ?f7 ?f21 ?f22 ?f10 ?f7 ?f23 ?f24 L ?f16 ?f7 G ?f10 ?f7 ?f25 ?f26 Z S N M ?f17 ?f18 G ?f10 ?f7 ?f27 ?f28 L ?f16 ?f9 G ?f10 ?f7 ?f29 ?f30 ?f10 ?f7 ?f31 ?f32 L ?f16 ?f7 G ?f10 ?f7 ?f33 ?f34 F N"><draw:equation draw:name="f0" draw:formula="if(0-$1 ,0,if(100000-$1 ,$1 ,100000))"></draw:equation><draw:equation draw:name="f1" draw:formula="100000+0-?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="min(?f1 ,?f0 )"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *1/2"></draw:equation><draw:equation draw:name="f4" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f5" draw:formula="?f3 *logheight/?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="if(0-$0 ,0,if(?f5 -$0 ,$0 ,?f5 ))"></draw:equation><draw:equation draw:name="f7" draw:formula="?f4 *?f6 /100000"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 +?f7 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f10 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f12" draw:formula="?f7 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f13" draw:formula="logwidth+0-?f11 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f7 +0-?f12 "></draw:equation><draw:equation draw:name="f15" draw:formula="logheight+?f12 -?f7 "></draw:equation><draw:equation draw:name="f16" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f17" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f18" draw:formula="logheight"></draw:equation><draw:equation draw:name="f19" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f30" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f31" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f32" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f33" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f34" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f16 ?f7" draw:handle-range-y-maximum="?f5" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="0 ?f8" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_leftBrace("ooxml-leftBrace", "H4sIAAAAAAAAAK2XTZOiMBCG/0qK2gODZgUCilPDWDWH3cvMXPa2t5QGSRUQF/Brf/0mRFFpnZ3IaNHk8+lOOm8ZnxYl3T6yIqXFnC3wkomc1eUeNc05L0tR4lSU/K8oaprFVkKzilkX3RtW1nze7azZrsa0ZLSKrVniESRNoMxEmdBC1Wb5uOFs+yJ2seWi5nucu1+x2BJil2c4Y0n9UtJ561QseMJZKbERIQSFrvwc+tplrGidxtZb6y5Cr+o1lmaqi640E/Qb/ULv6O3U8Hq1+AO9aw9CiI+c/DxNkYWpNL577vmi3/eU8S+a1C75wWnKpDMlVGZ8HvY1z35jotueVWTEPW8iKhji3/RMVGQkaHbi+Ulv9p81rbko9NYXNJcpS46ZSESZrzMaWzyxXfzNQ0N3KIueSpauq0dXHx4kcnTB/MiF13WhKQMXzxIXGaH8LirnhS1XjYYKZRYW6bLkPiPHG/lGlOBaRJlYbvmiToeykDK+TGuz0EIYGkFOCxvNksBs38bXs+wesjxLQtTU1KMqhhmewHgD5MySMRrpXBvRoi6tXbijsnwPcgoDjNBAKQWbgTygl2OuDc+NB1TRiNeZi8peccf2J1pqcrWRLpnhgVLUYp1KHs6voAPtHHehEbXnmZ1OD4hIBatRviEKSKc9PIOGhhXaDAnEc2/KgUyOIDPMbX2YcYAo7DA4HIuxen03k4YPpNGTBxRi30sCYrBxv9DA+e+5VCCAvgECGdit0u8DAhH0XDHQQk8eEEVPHhTHnSQCZdEvtwTqoh/vq9VBoDr6HT4C5fHZAOXNf5ExdFbGK1FxNaL5xW1uztZFf0mLJcN7nNMdz9e5GhbeGMELPeLkXo/4jHN1UY/+4/lw0zF1ftiJ7l/E538Ak7RSOw4AAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 ?f15 ?f14 ?f16" svg:viewBox="0 0 0 0" draw:type="ooxml-rightBrace" draw:modifiers="8333 50000" draw:enhanced-path="M 0 0 L ?f17 ?f9 L ?f11 ?f7 Z S N M ?f11 ?f7 L ?f11 ?f7 L ?f11 ?f7 F N" drawooo:enhanced-path="M 0 0 G ?f11 ?f7 ?f20 ?f21 L ?f17 ?f9 G ?f11 ?f7 ?f22 ?f23 ?f11 ?f7 ?f24 ?f25 L ?f17 ?f10 G ?f11 ?f7 ?f26 ?f27 Z S N M 0 0 G ?f11 ?f7 ?f28 ?f29 L ?f17 ?f9 G ?f11 ?f7 ?f30 ?f31 ?f11 ?f7 ?f32 ?f33 L ?f17 ?f10 G ?f11 ?f7 ?f34 ?f35 F N"><draw:equation draw:name="f0" draw:formula="if(0-$1 ,0,if(100000-$1 ,$1 ,100000))"></draw:equation><draw:equation draw:name="f1" draw:formula="100000+0-?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="min(?f1 ,?f0 )"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *1/2"></draw:equation><draw:equation draw:name="f4" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f5" draw:formula="?f3 *logheight/?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="if(0-$0 ,0,if(?f5 -$0 ,$0 ,?f5 ))"></draw:equation><draw:equation draw:name="f7" draw:formula="?f4 *?f6 /100000"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 +0-?f7 "></draw:equation><draw:equation draw:name="f10" draw:formula="logheight+0-?f7 "></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f12" draw:formula="?f11 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f13" draw:formula="?f7 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f14" draw:formula="0+?f12 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="?f7 +0-?f13 "></draw:equation><draw:equation draw:name="f16" draw:formula="logheight+?f13 -?f7 "></draw:equation><draw:equation draw:name="f17" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f18" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f19" draw:formula="logheight"></draw:equation><draw:equation draw:name="f20" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f30" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f31" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f32" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f33" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f34" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f35" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f17 ?f7" draw:handle-range-y-maximum="?f5" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f18 ?f8" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_rightBrace("ooxml-rightBrace", "H4sIAAAAAAAAAK1XTXObMBT8KxqmB0JMjZABOxOHmRzaS5JLbr1pbGFrBpAr8Fd/fSWEIUa4jSD2IAtJ7Fu9fYvhcc3x8YHkW5yvyNrdEJaRkp9BNZxRzhl3t4zTPywvcbq0EpwWxLqaPhBe0lV3siSn0sWc4GJpeSBOYCCbmWxCCxSHzcOBkuMzO8np6nu58LwjS4uxU5a6nG625TPHqyYkW9OEEi5A5wghEHjiU881m9jhcru0XivUFxkwEs1CdaFoIvALvIM38NoOvPR2f4A3hc0Y64f/2S6OE1/u04cfY17P+7JBV0MyIX7QXgK7mKFsWsZ60LlsFjeDIkkKwashyUMk72ZQJFmhoNr/06NK7u89LinLVapznAmNkkvmE8azfYqXFk1sz/0GwcSbiC6U4qhzeajTuzsBOb3C/FcI2A2hUO49N048YATld6Eymtti12AiocxooS6W0AA4cOobocz6GKVsc6TrcjsRnS2RBjCjFujUEHAasGmczMzyFvar7NUqx0kAqjN5yBNDhSOd7ww4cRKCqdLaCG3eRWs27kiVh0AudIJzUBVgZJZIqPmlITcITvPGpXQMyxBqzqjuBc6KFfaOOrYfKeeK5M1Vzwy+xywRcApR61+BrpnIuxf0feCaqQx7fBMpmSEyFEZzTKtzhTZAa80lQ7XuM0gFZAajmaLZotk9WbOEDUO/LohQ/nw3k9HXTGEHszF4mjfspk6HAWpusN1xDDUDjE2h5oSxDDU/2EORNBuMVFdzw9jcab4YRxD1+GNU+SHdH+PERT0GGZVC9NUGQbpBhiLpzvgsM/HusE4J+NB3d6ygckX1dysfuy/FXc9znG+Ie3YzfKLZPpPLghsraK5WtOHVik8Gl68Q8/8Erx+cTOPXyei+Xz79BXt/kkB4DgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f1 ?f1 ?f3 ?f2" svg:viewBox="0 0 0 0" draw:type="ooxml-squareTabs" draw:enhanced-path="M 0 0 L ?f1 0 ?f1 ?f1 0 ?f1 Z N M 0 ?f2 L ?f1 ?f2 ?f1 ?f4 0 ?f4 Z N M ?f3 0 L ?f5 0 ?f5 ?f1 ?f3 ?f1 Z N M ?f3 ?f2 L ?f5 ?f2 ?f5 ?f4 ?f3 ?f4 Z N"><draw:equation draw:name="f0" draw:formula="sqrt(logwidth*logwidth+logheight*logheight+0*0)"></draw:equation><draw:equation draw:name="f1" draw:formula="1*?f0 /20"></draw:equation><draw:equation draw:name="f2" draw:formula="0+logheight-?f1 "></draw:equation><draw:equation draw:name="f3" draw:formula="0+logwidth-?f1 "></draw:equation><draw:equation draw:name="f4" draw:formula="logheight"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth"></draw:equation></draw:enhanced-geometry>
    ooxml_squareTabs("ooxml-squareTabs", "H4sIAAAAAAAAAJWTQW+DIBTHvwrhtNkY0eqlKW2y87rTTruxikKC0gJVu08/BHWtMUsMIfzz3uP3/o+Efa5Iu6M1I/WZ5mFJZUWNugMXrrhSUoVMKv4ja0MEhgURmsKndEOV4ed50tDOhERRojE8FjHwe2t3AoFuyl3DafsmOwwRcGu8d79QDKXsKhHq680SPsm3HpKTzwsxDMOTu/nu2AiMXbz6Ah/g5HQyVPTKn6mLp0NN78pTMhfPHrzGDzUjKRtImWP4jGPBw967tLYNl7X3XJPKDlSM8xVSVTdBMNRXZV6ELFueGxaMYmMFo7xkJpjUBgXo1cKjJ/p/zeJ5szg4FghECVqFSeYY9Gcv7B9nFW27SHNTr4elc9hkbBUmW8A4RwuUaPmrHH4Bi7vlLEMDAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f1 ?f1 ?f3 ?f2" svg:viewBox="0 0 0 0" draw:type="ooxml-cornerTabs" draw:enhanced-path="M 0 0 L ?f1 0 0 ?f1 Z N M 0 ?f2 L ?f1 ?f4 0 ?f4 Z N M ?f3 0 L ?f5 0 ?f5 ?f1 Z N M ?f5 ?f2 L ?f5 ?f4 ?f3 ?f4 Z N"><draw:equation draw:name="f0" draw:formula="sqrt(logwidth*logwidth+logheight*logheight+0*0)"></draw:equation><draw:equation draw:name="f1" draw:formula="1*?f0 /20"></draw:equation><draw:equation draw:name="f2" draw:formula="0+logheight-?f1 "></draw:equation><draw:equation draw:name="f3" draw:formula="0+logwidth-?f1 "></draw:equation><draw:equation draw:name="f4" draw:formula="logheight"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth"></draw:equation></draw:enhanced-geometry>
    ooxml_cornerTabs("ooxml-cornerTabs", "H4sIAAAAAAAAAJWTQW+DIACF/wrhtNoY0eqlKTXZed1pp92YgpAotEjV7tdPQd1qzBJjiA9e3seDhFOuSXukkhOZ0dwvqKqo0Q9glyuhtdI+V1p8K2lIiSEjZU3hk91QbUS2NA3tjE80JTWGKQuBG4d+RBDUTXFsBG1fVYchAvabco8rxVCprir9TGlJ9Qf5qkdz7nklhmN4sck3yx7U8P8E7+BidTQ6KYvtPB69oYVLJXY9+ZNzs2h0h4zrbLPwfHItbndihJKukyRVX5hN/ZnS1b0kGNY3bV5KVbQiN9ybxL4XnIqCG29We+ShXQ8Pnuj/bRYuNwu9lCEQRGgTJlpi0G89f7iUTbTDKs2eejssXsLmYpswyQrGNlqhBOtP4fwDCW7hDiMDAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f1 ?f1 ?f3 ?f2" svg:viewBox="0 0 0 0" draw:type="ooxml-plaqueTabs" draw:enhanced-path="M 0 0 L ?f1 0 Z N M 0 ?f2 L 0 ?f4 Z N M ?f5 0 L ?f5 ?f1 Z N M ?f3 ?f4 L ?f5 ?f4 Z N" drawooo:enhanced-path="M 0 0 L ?f1 0 G ?f1 ?f1 ?f6 ?f7 Z N M 0 ?f2 G ?f1 ?f1 ?f8 ?f9 L 0 ?f4 Z N M ?f5 0 L ?f5 ?f1 G ?f1 ?f1 ?f10 ?f11 Z N M ?f3 ?f4 G ?f1 ?f1 ?f12 ?f13 L ?f5 ?f4 Z N"><draw:equation draw:name="f0" draw:formula="sqrt(logwidth*logwidth+logheight*logheight+0*0)"></draw:equation><draw:equation draw:name="f1" draw:formula="1*?f0 /20"></draw:equation><draw:equation draw:name="f2" draw:formula="0+logheight-?f1 "></draw:equation><draw:equation draw:name="f3" draw:formula="0+logwidth-?f1 "></draw:equation><draw:equation draw:name="f4" draw:formula="logheight"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f6" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f7" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f8" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f9" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f10" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f11" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f12" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(5400000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_plaqueTabs("ooxml-plaqueTabs", "H4sIAAAAAAAAAK2VS3OCMBDHv0omJ8WhJCD4GNGZXnppe+qpt6jhMQNEQ3z10zcEUQmOLaUwC5ndzW//2UkmszUnhynNIpKt6NoMKUup4Ceg3GnMOeNmxHj8xTJBEh8GJMkprIX3lIt4pQcFPQqTcEpyHy4CDEpzpNkQ5Ptwuo/p4ZkdfYiAeqt5pw31IWPHNDE3Cdnu6AdZ5ufgReeGiMiHb2rmq2Ij8AneQeGRFaSv+A/PvkXgnvNclVt5HZVT+VV2WYgx9rjWC7iuyZM2qlW/jY6lTX7Qc5uPi0Ssa6xl2MXH0XTPZ2WHtjsiYpaV/cpIKpsZVL0NGE93CfFhvuWil7DwEK9FZFSDgRxENA4jYVxGA2SgvoRbNfqjYlgvho1FgIBlo1YYW8egqzyzaEQrmnOXplbdHjbUYRdhrTDuHYxS1Iri6ZQe6lseks9Tu4aPGiB3WGD+iBs3cNizO/Am/ysPN85ER15j23fkNfZ/D6NxF2DjCPxGoHX/eph/A49RlHQ3BgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f2 ?f3 ?f4 ?f7" svg:viewBox="0 0 0 0" draw:type="ooxml-pieWedge" draw:enhanced-path="M 0 ?f7 L ?f4 ?f7 Z N" drawooo:enhanced-path="M 0 ?f7 G ?f8 ?f9 ?f10 ?f11 L ?f4 ?f7 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*cos(pi*(13500000)/10800000)"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight*sin(pi*(13500000)/10800000)"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth+?f0 -0"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight+?f1 -0"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight"></draw:equation><draw:equation draw:name="f10" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f11" draw:formula="(5400000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_pieWedge("ooxml-pieWedge", "H4sIAAAAAAAAAK2UW2uDMBiG/0rIletwGu2Z2sJudrPtdrC7UD81oH4upq3dr1+sWOghHQGVTyWH533U6CqW/LCEMuPlFmI3BSxAySM5NRdCSpRuhlL8Yql4HtGE5zXQi+49SCW2150KGuVyCbyO6CYJyCYJdY11zSip9+lyL+Dwik1EfXLa+3nHCiKK2BS5Wwn4gjjtkWfLiqssoh96lqaR955LvslnNxQRTaPf9HGua6GLtU2MXRHWqy7tZ8eVwLLLLnmhtZLeMkFZ7HIe0RzTg4hVNtpi7VRi5LBw4rfbk8f8eXelid4F8lECu5OQgUgzNapFOUhEYLqJ503iE9e3goVGX01jtrSxSc2KMjE6eYEVaGrSseTMjEJWmPkgT2cxjAy7+Rac83L0pu3pxe7ds5ul70zG//K8+z+w9R/Fj6Rb2QQAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="10 10 10 10" svg:viewBox="0 0 400000 400000" draw:type="ooxml-chartPlus" draw:enhanced-path="M 5 0 L 5 10 M 0 5 L 10 5 F N M 0 0 L 0 10 10 10 10 0 Z S N"></draw:enhanced-geometry>
    ooxml_chartPlus("ooxml-chartPlus", "H4sIAAAAAAAAAG2QOwvCMBCA/8qRPZiCXUrTwcHJFsHNLbbRBNpeSdLnrzcpVVE8jnt93INLKyPGRLZKtKWs6ENiI52ZYS032hg0VKHRC7ZO1JzcRW0l+cKDNE6XPxARE9vf6KDlSK1eJCcRg5cSsMMjCeyAEycMGOxZkM1tC9zc+T7EqalpqYRx57q3G3uf3AmnOMkh9kNO3voFuQ9jn0TBHaFYC4F+LgjK4AoXKEiW7v5/IXsCSQySXR4BAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="10 10 10 10" svg:viewBox="0 0 400000 400000" draw:type="ooxml-chartX" draw:enhanced-path="M 0 0 L 10 10 M 0 10 L 10 0 F N M 0 0 L 0 10 10 10 10 0 Z S N"></draw:enhanced-geometry>
    ooxml_chartX("ooxml-chartX", "H4sIAAAAAAAAAG2QTQvCMAyG/0rovVjB01h38OBJd/Ei3upW18K2jLTu69drtVMUQyC8ecibkLQkNSS6NaotdMkrjY32NMGz3VgiJG6Q7IytV7VkV1U7zb5wr8nb4gciYuJuF95bPXBnZy3ZWsCSDFxfJYFtcZRMgICNCBFLXOCn7jGHODY1L4wif4rgfW+nvJHsAMFhH+2DWkcpYAc5LPxzwIud4Qg5y9LV/ydkd20BPLQdAQAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f3 ?f2" svg:viewBox="0 0 0 0" draw:type="ooxml-rect" draw:enhanced-path="M 0 0 L ?f3 0 ?f3 ?f2 0 ?f2 Z N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth"></draw:equation></draw:enhanced-geometry>
    ooxml_rect("ooxml-rect", "H4sIAAAAAAAAAJWRwQrCMAyGX6X0PqbzJlbBs/oA3sKWrYW20Sxu06d3bCooU5BSKPn5viR0VTC0S4wWYo5FUiEFFL6qoRwcM3Fiid2NooA3ugRfo36LG2Rx+Wco2EkCjFAbPVMztSkX/c20qptq2Thst9SNSX+ezPWERhN1wSeMuTzKr+lOINbo/cDsBuPLO7wydVQHvV6N1PkC4iiOjgihV5fPTiVxuHgw2lPVukJsmvVc+gb+8swnPBZdZeVPUfZV9Jdm8W2vCUs6/eXrO8ipjHsLAgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f5 ?f5 ?f6 ?f7" svg:viewBox="0 0 0 0" draw:type="ooxml-roundRect" draw:modifiers="16667" draw:enhanced-path="M 0 ?f2 L ?f3 0 L ?f11 ?f4 L ?f2 ?f10 Z N" drawooo:enhanced-path="M 0 ?f2 G ?f2 ?f2 ?f12 ?f13 L ?f3 0 G ?f2 ?f2 ?f14 ?f15 L ?f11 ?f4 G ?f2 ?f2 ?f16 ?f17 L ?f2 ?f10 G ?f2 ?f2 ?f18 ?f19 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 *29289/100000"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="logheight+0-?f5 "></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f12" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f2 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_roundRect("ooxml-roundRect", "H4sIAAAAAAAAAKWWUZOaMBCA/0om0we8Sk1QUG+Oc+Ze+tL2oY99y0iAzEDixahcf32TIFZIdRqBybJhN9/uZjbiSybJ6ZnykvAtzcKCipoq+QHs65pJKWRYCsl+C65IlcKcVHsKe+YjlYpth0ZFGxUSSck+hZs8Bu1I9FhCsD8Wz0dGT2+iSSEC9u7WfexoCoVo6iqU4sCzn3SruoAiYzmjUiNxkiTL8+tL9juiyhR+17RNHoFvWs61bp4Ya7GwamSmCPwCP9rlQohbhK9nd7vEivmF2rMtjIivI/XMpmq8vI7eM6+MWNuMXl/ait4PRDHB2/o4qfWW5N0O5ULWh4qkkOUBCj8hMEVTrcZIX3Zqhp1NJho46xHvBcDDADXjQSWKE8tUOdVKSVlRKj9oNITqWsHTJkdghk2OyIs2H9K69D6j0OymF2zxD1hb4iO02C00Ak/ROlqtH6k0uVtp7Jfb8n6lnrTVrdRmkRdnfTMrTxB2jsaF5MdxTkBXmR/G6fkAo5VtgcksMY8vfr2AnbYP4sUYntP5AU6iMUCn+Ucm6HR/8CjJaf2RmTnNP5LnHIL/5ulPVlZRcKWHO7FnxqP98elOxdkoCS9o2IQ1aVh9qFNovxE3fBhvff5Gbz0uuQz/Mbz+AQkM/2JKCAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 ?f4 ?f5 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-snip1Rect" draw:modifiers="16667" draw:enhanced-path="M 0 0 L ?f3 0 ?f6 ?f2 ?f6 ?f9 0 ?f9 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 *1/2"></draw:equation><draw:equation draw:name="f5" draw:formula="(?f3 +logwidth)/2"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f3 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_snip1Rect("ooxml-snip1Rect", "H4sIAAAAAAAAAJWU32+DIBDH/xVC9tBfpGhbO5vaJnve9rDHvZEKSiLgkLZ2f/1Aa7e6uQTNReCOz331OLepJucNlTmRB5qijCpBjb6AZllwrZVGudL8U0lDigQyUlQU3rlPVBt+6DsNrQ0impIqgRjs2dLayloMQXXKNidOz0+qdr7m7nZdSppApWpRoEryMnijB9OlUylnnGoLDKIoWl+Xb9pLYvIEvjS8Z5tpAVzeyFp4fcbNSgzewSvcbdvdH0diuJItSxJh07NODVNaHAuSQM5GGD1gMMMzO1xhezVTZ81sPLbA+R3xvwRBP4HgclSo7MxTk8/sIKc8y40fNOxD9ywAkz3DYB44jdiLtujTOnlTjNwX9YItf0sLwSSYh16UVZ8yckWedsLGnrho6A29KOs/KG31POU8Dsnx5MSDgoYwtn/SgoIfY1SqirsIV6nFrTuvTk1kRlGNBKm5OIoENi0wEMNlG/N9+tqIm5b+r2f3BQeuGWKTBAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f10 ?f12 ?f11 ?f13" svg:viewBox="0 0 0 0" draw:type="ooxml-snip2SameRect" draw:modifiers="16667 0" draw:enhanced-path="M ?f3 0 L ?f4 0 ?f15 ?f3 ?f15 ?f7 ?f6 ?f14 ?f5 ?f14 0 ?f7 0 ?f3 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(0-$1 ,0,if(50000-$1 ,$1 ,50000))"></draw:equation><draw:equation draw:name="f2" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *?f0 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth+0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 *?f1 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="logheight+0-?f5 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f3 +0-?f5 "></draw:equation><draw:equation draw:name="f9" draw:formula="if(?f8 ,?f3 ,?f5 )"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 *1/2"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth+0-?f10 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f3 *1/2"></draw:equation><draw:equation draw:name="f13" draw:formula="(?f7 +logheight)/2"></draw:equation><draw:equation draw:name="f14" draw:formula="logheight"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f16" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f17" draw:formula="logwidth/2"></draw:equation><draw:handle draw:handle-position="?f4 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f5 ?f14" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_snip2SameRect("ooxml-snip2SameRect", "H4sIAAAAAAAAALWVy27jIBiFXwWhWaStUbATO21V11LX01nM7GaHYrCRbEgxSdx5+nKp00nsVCVSE4G5+TsH/AMPpSL7eypqIta0RBWVLdXqFbjmlislFaql4v+k0KTJISNNR+FR944qzdennZr2GhFFSZfDgsUYmCyxWWyzBQTdrrrfcbp/kn0OMXD/4d3XDc2hlH3boE7wTfKHtPQ3XetBWJaccaoMOs6ybHV48TCPDdF1Dp+N1MJwf5rnEjgLqWt6L6xMymxlabLUF7Brx27YX/ALPj548suWaC6F1xHGj5nuIMukarcNySFnM4x+YBDhyBRTbH6uapOrXV0Z4PyI+JlAPC0QHwuYqk2XCCSnAi0Xs0ZWe17qOjKFmvKq1mHQxSm0YAm4LhgG89h6xEG05SltsHeDkf1IQbD0jLX4ImvZp9bSMGurCZhf/Utot+OJLsAloLuJECzYLYgsMLK4wJAebZqC3YHreJ6EYUZb42jtzXkThhttBDu9cFej0J/Z0+TmYyOFAqei36PCOKPAH5YrDDMV8d5O6MSmwt0ZOg8yZ3vZUPBfGW1kx+0I+72Wh2vgvVMRUVHUo5b0vN22OXQn5JkxXPgxHyeAH/E1bX95fIv8fPqGfnwDNn1WNboHAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f11 ?f11 ?f12 ?f13" svg:viewBox="0 0 0 0" draw:type="ooxml-snip2DiagRect" draw:modifiers="0 16667" draw:enhanced-path="M ?f3 0 L ?f7 0 ?f14 ?f6 ?f14 ?f5 ?f4 ?f17 ?f6 ?f17 0 ?f8 0 ?f3 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(0-$1 ,0,if(50000-$1 ,$1 ,50000))"></draw:equation><draw:equation draw:name="f2" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *?f0 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth+0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="logheight+0-?f3 "></draw:equation><draw:equation draw:name="f6" draw:formula="?f2 *?f1 /100000"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth+0-?f6 "></draw:equation><draw:equation draw:name="f8" draw:formula="logheight+0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f3 +0-?f6 "></draw:equation><draw:equation draw:name="f10" draw:formula="if(?f9 ,?f3 ,?f6 )"></draw:equation><draw:equation draw:name="f11" draw:formula="?f10 *1/2"></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth+0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="logheight+0-?f11 "></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f15" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f16" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f17" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f3 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f7 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_snip2DiagRect("ooxml-snip2DiagRect", "H4sIAAAAAAAAALWVXW/bIBSG/wpCu2g7o4Dd2G1VN9K0y24Xu+wdisFGMpBhkrj79QW7XuvYjkakJeLLHD/vOeQc8lgYenxgqqJqywpUMi2ZNa+geyyFMdqgShvxRytL6xxyWjcMjrYPzFixPd20rLWIGkabHG44IWDoYt8lEDSH8uEg2PGbbnOIQfcd3n3dsRxq3coaNUrs4u+Clr/Y1g7CuhBcMNP4F0maptn7xt84dtRWOfzhpBLHfXZj5kYnfOu6dJisXfMjyYanvdVd1yfgBfyET489+feeWqFVr6OodA7ywV+ujdzXNIeCX2H0BYMIR266xu7TLX3rVtfXDrgaEc8JkHkBMhZwS98uEYhPBaRQV7Uuj6KwVeQmFRNlZcOgySl0w2Nws+EYrIj3EQfRbk9pg3tfMfI/UhBsPQPrQ7yEli4ESi4KNDsbaBrm2t35QANp99NAE3AJiMyVzIbfg8gTI88LrJBJibjjx+CGrOIwzqQSRqfvrq4w3KQGxucfzFusgjDMcv6Hntck9weHQkFzad+7tMRxd3xRM/Bpjna6Ed6iz8whyd43DVUlQy2StBVyL3PY3ZQLNkL1Nh+121v8m3b2n7RX83/TT2/aFnCdvwcAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f6 ?f6 ?f7 ?f11" svg:viewBox="0 0 0 0" draw:type="ooxml-snipRoundRect" draw:modifiers="16667 16667" draw:enhanced-path="M ?f3 0 L ?f5 0 ?f8 ?f4 ?f8 ?f11 0 ?f11 0 ?f3 Z N" drawooo:enhanced-path="M ?f3 0 L ?f5 0 ?f8 ?f4 ?f8 ?f11 0 ?f11 0 ?f3 G ?f3 ?f3 ?f12 ?f13 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(0-$1 ,0,if(50000-$1 ,$1 ,50000))"></draw:equation><draw:equation draw:name="f2" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *?f0 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 *?f1 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth+0-?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="?f3 *29289/100000"></draw:equation><draw:equation draw:name="f7" draw:formula="(?f5 +logwidth)/2"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f11" draw:formula="logheight"></draw:equation><draw:equation draw:name="f12" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f3 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f5 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_snipRoundRect("ooxml-snipRoundRect", "H4sIAAAAAAAAALWVQXOjIBTHvwrj7MG0YRUTTdKpzUwvvezuoce9MRGUGYEsksT20xchdjea7JR0qvN4IPj7v6cPvS8UPtwRUWGxIQUsieREqxdgL3OmlFSwkoq9SqFxnQcU1w0JTqb3RGm2GU5q0mqIFcFNHqxpBpwtjCEUgGZf3u0ZOTzKNg9iYM/+xpctyQMpW17DRrDts9yJ4plsdK8qC0YZUYaLsixbANseJ98T2WJd5cFPIzcz7B/Gp8av6dLY/OgRspeObgZ+g18OI6X8HOnJts5Q0jWO/nDvovyzw5pJ4WIWmJuEaZ8/lYrvapwHjIYx/BaDaTw13TQ2hx12ZkeTiQFGJ8T/CaDzAuhUwAw7u0YgGQpwJsJalgdW6GpqOhVhZaX9oLMhdE0TcLOmMYhQF2PsRZtfoKGraOmQ1id7G8OuOLxg2Ti0GbhJVslydU1siyEu7Ar3to9wEiVeuOWlVL0oqzMUVxSe4aDRbunj8QWNdsV7SH6cUfGHKF7a1zaJss5993t/aFT4YTr/GM98uIqagH/6cCsb1q1wVdU/vOOkwqIksIUct4zveB7YzX9hDRNuzV91t+Jj2ukXaUfnf2MPbzlHc9PfBgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f5 ?f8" svg:viewBox="0 0 0 0" draw:type="ooxml-round1Rect" draw:modifiers="16667" draw:enhanced-path="M 0 0 L ?f3 0 L ?f9 ?f8 0 ?f8 Z N" drawooo:enhanced-path="M 0 0 L ?f3 0 G ?f2 ?f2 ?f10 ?f11 L ?f9 ?f8 0 ?f8 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 *29289/100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth+0-?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f10" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f11" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f3 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_round1Rect("ooxml-round1Rect", "H4sIAAAAAAAAAJ2US3OCMBDHv0qG6QFbUxNUREd0ppde2h567C0jATJDEhuCYj99w8tWfExTmEwSdve3/yWPZaTIfkFFSsSGRjChklOtDqD+zJlSUsFUKvYlhSZZ6MQky6lzYt5Rpdmmb9S01JAoSvLQQQCBdTw1LXBAvksWO0b3T7JsLObtYg5bGjpSljyDShYiwu90o7tsMmIxo8rwsO/7s/bzUfqW6DR0Xmvgi0k1bvt5lbYWEIAP8NaESSlvRz6b3msbroIxvkhbLRsVnwXRTIpGkyDc1BF3ZcVS8SIjocNiF8E7BIZoaIZTZJ56WrV6NhgY4OiEeCsB7ifgTLiZTPYs0unQDFLKklTbQb0+1NQO7tcxAiNcaURWtHGf1sl7QLD6u1awybk0D9x7cy+Y/0fb9Ka2iZ02/xps5FlxZhc4zTJagoKrICvM/Fpddjv17Cy42PfqJRuM/Kp7tFs7fLb33enkbzxz6qOMgl9juJU5qzyqHTU+XketURGRUFhCTkrGCx469VG94sNE4/OTvfE4aunftKtvcPfqUIIFAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f11 ?f9 ?f12 ?f13" svg:viewBox="0 0 0 0" draw:type="ooxml-round2SameRect" draw:modifiers="16667 0" draw:enhanced-path="M ?f3 0 L ?f4 0 L ?f15 ?f7 L ?f5 ?f14 L 0 ?f3 Z N" drawooo:enhanced-path="M ?f3 0 L ?f4 0 G ?f3 ?f3 ?f18 ?f19 L ?f15 ?f7 G ?f5 ?f5 ?f20 ?f21 L ?f5 ?f14 G ?f5 ?f5 ?f22 ?f23 L 0 ?f3 G ?f3 ?f3 ?f24 ?f25 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(0-$1 ,0,if(50000-$1 ,$1 ,50000))"></draw:equation><draw:equation draw:name="f2" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *?f0 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth+0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 *?f1 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="logheight+0-?f5 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f3 +0-?f5 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f3 *29289/100000"></draw:equation><draw:equation draw:name="f10" draw:formula="?f5 *29289/100000"></draw:equation><draw:equation draw:name="f11" draw:formula="if(?f8 ,?f9 ,?f10 )"></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth+0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="logheight+0-?f10 "></draw:equation><draw:equation draw:name="f14" draw:formula="logheight"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f16" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f17" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f18" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f4 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f5 ?f14" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_round2SameRect("ooxml-round2SameRect", "H4sIAAAAAAAAALWWXZObIBSG/wrj9MJs4waImmRn3cz0Zm/aXrR3vWMiKjMqWWI+tr++fMQ0Bne76DQZEAI+5+VwDuExFeT4QOuC1BuaBjnlFW3EK9A/V0wILoKCC/ab1w0pEy8j5Y56neEDFQ3b3A429NQERFCyS7x1hhBYZytZEFbV3AO7Q/5wYPT4hZ8SDwL9bV993dLE4/xUlYHg+zrFP0lFf9BN0xrmKcsYFRKN4jheXN68rGNLmiLxvklbcwn+Kp/h+YkiWS10U7VQKJtQz/sFvhsM5/xfpGfdNwUtVbW6pj+f6apgRcfo2mJnWDkEzy8qrsk4VFWklT09mhW+7EnDeG3WW0u/SLe3y8+4qPYlSTyW+TD4BMEUTmUzgvKju6ro3mQigbMO8T0DqN8A6hqQXVWGGMC3BipW+yXPjyxtiqlsFJTlReMGnd9CpTPB3TqDYIaURuhEC29prbzPMFDb5QSL3pCGBkmL35UWuUlb9MCM94fQlvZC52AIaNUHusMrvFwNcRmyckYpGsHrS5F1tgRTde7JCkHgmHNWTnR2VZ6objgrG7r7KvW58frywfDcOFYqtMt0w/TlgJEzw26kvgTQglxBVuz7KMY6tCazWD3uHWPMygE/CkfwsJUD/lCSFf0jlVmxP5JnBf9InhX8PoLLMUArCz4sUN5T0pKCq3aw5TumZqhDLbxcjs6DgtQ5DU5BRU6s2leJp/+v35jDajPnr3Uz42O2zXXnv5if9d9bn/4A+kZt8dAKAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f11 ?f11 ?f12 ?f13" svg:viewBox="0 0 0 0" draw:type="ooxml-round2DiagRect" draw:modifiers="16667 0" draw:enhanced-path="M ?f3 0 L ?f6 0 L ?f14 ?f4 L ?f5 ?f17 L 0 ?f3 Z N" drawooo:enhanced-path="M ?f3 0 L ?f6 0 G ?f5 ?f5 ?f18 ?f19 L ?f14 ?f4 G ?f3 ?f3 ?f20 ?f21 L ?f5 ?f17 G ?f5 ?f5 ?f22 ?f23 L 0 ?f3 G ?f3 ?f3 ?f24 ?f25 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(0-$1 ,0,if(50000-$1 ,$1 ,50000))"></draw:equation><draw:equation draw:name="f2" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *?f0 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight+0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 *?f1 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="logheight+0-?f5 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f3 *29289/100000"></draw:equation><draw:equation draw:name="f9" draw:formula="?f5 *29289/100000"></draw:equation><draw:equation draw:name="f10" draw:formula="?f8 +0-?f9 "></draw:equation><draw:equation draw:name="f11" draw:formula="if(?f10 ,?f8 ,?f9 )"></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth+0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="logheight+0-?f11 "></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f15" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f16" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f17" draw:formula="logheight"></draw:equation><draw:equation draw:name="f18" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f3 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f6 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_round2DiagRect("ooxml-round2DiagRect", "H4sIAAAAAAAAALWWTY+bMBCG/4qFeiDbULAJBFbLRqoq7aXtocferGDAEuDUIQnbX1/bBBpisl0HNZG/YvuZd+wZwlPK8emR1AWutyR1csIq0vBXoH6uKOeMOwXj9DerG1wmVobLPbFG00fCG7q9nmxI2ziYE7xPrE0GIegrJCvfAvtj/nik5PSZtYnlAfXt977uSGIx1lalw9mhTtEXivMfZNv0lllKM0q4YMMwDNfDzsGRHW6KxPombPkC/FW04bmFK1GtVDeQw7XoemrdT/C9wzDG/kV6OW9XiEhW8SX9RS3vCpJ0BC8tXu5G8kCQP6gYbZU0FChlz0+dh78OuKGs7vytcSVOKuvdzxivDiVOLJrZnvPBA0tvKbqBJz5qKIsaLRYC6I6IbxmA0wbg2IAYynKPAXRtoKK1XbL8RNOmWIpOQWheNGZQ/xoqDhM8bDIPuFBq9Ixoq2vaoOqj58j7MqIFN7TBu7SFE9rU0SlpgZm09duOGtIi3VEfPKAYRfE9nsY6LpiBg1rqbLIIKD9jMz/hVI6I+xQZJ5FLCTRMOi0pRrcqHqdmOC0dxvdqzJtKCCXPDKNlwiDLRWakm1lgCrqdAWYcLfZtGCIVpAs3lM0nw2jVot8OVjN4SIt++16SFv0zlWmxP5OnBf9Mnhb8NvSiOUAtDd4tULyopCUBF31nx/ZUruietv0tnyc5rnPitE6FW1odqsRSf9g31tC6W/PXerfifbbD/2TbnX5tff4DMEHWns8KAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 ?f8 ?f12 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-rightArrow" draw:modifiers="50000 50000" draw:enhanced-path="M 0 ?f8 L ?f5 ?f8 ?f5 0 ?f14 ?f7 ?f5 ?f13 ?f5 ?f9 0 ?f9 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="100000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth+0-?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="logheight*?f2 /200000"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f6 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f8 *?f4 /?f10 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f5 +?f11 -0"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight"></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="0 ?f8" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f5 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_rightArrow("ooxml-rightArrow", "H4sIAAAAAAAAAJ2V3U7CMBTHX6VpvFCk2TpAxDgXvVYfwLvGtVuTdcVSYPj09mND2YaxQtq0PeX3P+ds53CfK7K/o3VJ6neao4JKQbU6AHcsuFJSoVIq/ilrTaoUMlJtKDwx76jS/L1v1LTRiChKNimMQcZuzcCJmVYQbHbF3Y7T/ZNsrNF9u58d1jSFUjaiQooXpX40GvtOUOaccaoMchGbD3BzazzGsCa6TOEL8KrPZl60+gt3hudmWrbHeNYuVs62Am/gFT7ce+LHlmgua8+viTCesU6OSSW2FUmh4PVlJYs9z3U5NYuSWrevDCQ6ofwGxX0otoHFk44bZSwGQcSkT+TsMkYXMZjGU7P0fLe3w2+vwpyejUvgVsLkFridHXYTiJ/38TYHk4zNQOTdDaIt+rQutdcxytg8LLk3IzD/2I1/CYiScP+WZ5FREgS6HaZtCVyQN2FBrkZBFoPCQsODkvlvbHhQJ7auJ/b5mQrBgSWCBzViO4GJEOPgEAe1cAwxjDN46bvX9BzG9Ly8ouDHGq3lhtsbbd+FJ0ZF6oKiAxKk4WIruk5z5hKv/aXvbPgbfxF37XaM23yLZ8fO179xXjka/8d6+AKB3N48ygYAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f12 ?f8 ?f13 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-leftArrow" draw:modifiers="50000 50000" draw:enhanced-path="M 0 ?f7 L ?f5 0 ?f5 ?f8 ?f13 ?f8 ?f13 ?f9 ?f5 ?f9 ?f5 ?f14 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="100000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="0+?f4 -0"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight*?f2 /200000"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f6 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f8 *?f4 /?f10 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f5 +0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f14" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f13 ?f8" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f5 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_leftArrow("ooxml-leftArrow", "H4sIAAAAAAAAAJ2VUW/aMBDHv8rJ2kNLsWIHUtqqabQ9b/sAe7MaO7EUx8wYCPv0sx0CJYFqHsjG5o7fnc/5H6+lYfsX3tasfeclrrhW3JoDhK+VNEYbXGsj/+jWsiZHgjUbji7MO26sfB8bLe8sZoazTY4KQVMoxJMbdOGmZwSbXfWyk3z/TXc5IhDewy8Pa54jrTvV4IYL+9VF2Q8hdSmF5MZBM+JeEOaj8XSKNbN1jn44ZiFW8N3NWVhnH5M4Z3O0DJ90Cb/gJ3p77aG/t8xK3fYhWqZcbmKIKLRR24blSMn2rtHVXpa2nrtFzWVV23sHSS4on0HpGEr92chs4CaFIBBFTMdEKe4I/kJgTuZu2fPD3o9+ex+X9OJ6CHoM4aoJYeeH30Til2O8r8GsEAtI+nSjaNmYRh4KsQQcR3kcU0737RJLIUnjE1vdRCZpFOhpWq8VPBBciMe4R+f5KshjIqtFJ1r537PRiUC8iGf+Bp00aKQ26EQcXv2hVJRGoiYiGCQbh5k87KdK3eK4flc2HD6s8VpvpPcIXTf0OXRhN6ytOD5gxTqptmroMjecZNs7ne+89/i3+Blc5Xbn4MWp6409bkdOrv9lvf0FcXxSP8sGAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f8 ?f12 ?f9 ?f13" svg:viewBox="0 0 0 0" draw:type="ooxml-upArrow" draw:modifiers="50000 50000" draw:enhanced-path="M 0 ?f5 L ?f7 0 ?f14 ?f5 ?f9 ?f5 ?f9 ?f13 ?f8 ?f13 ?f8 ?f5 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="100000*logheight/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="0+?f4 -0"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth*?f2 /200000"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f6 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f8 *?f4 /?f10 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f5 +0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="logheight"></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f8 ?f13" draw:handle-range-x-maximum="100000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="0 ?f5" draw:handle-range-y-maximum="?f1" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_upArrow("ooxml-upArrow", "H4sIAAAAAAAAAJ2VUW/bIBDHv8oJ7aFNgwxO3LRVXat73vYB9oZqsJGMSQlJnH36AY7d1U6mMVtGh7n8/sfhuzyXhh2feFuz9o2XuOJacWtOEF4raYw2uNZG/tKtZU2OBGt2HH1aPnBj5dt00fLOYmY42+WoEA9QCJq64dEbKwS7Q/V0kPz4VXc5IhDu4ZenLc+R1p1q8H776jSOg6AupZDcOGRG3AVhPC+Oe9gyW+fouyMWIoNvbtwEm67Diz6GbIwFztENRgY/4Qd6ee6h73tmpW57iZYpF5kYFIU2at+wHCnZ3jS6OsrS1ktn1FxWtb11kOQT5W9QOoVSvzeyGHFJIQhEIdMpUoobgr8QWJKlM3uBMPdPP72Ni3p1WYKeJVxaIcz84yeR+PUU73OwKMQKkj7cKFo2pZG7QqwBx1Hup5Th5F1cKSRpfFyba8QkjeI8zLO1gTuCC3Ef9+E8XgR5TGSu6KxU/nNrdFYevlgX/vhcXdDIwqCzyvBlHzJFaSRqVgFjwcZxZp/6kKlrGNftyobDHzbe6p30HmPHHYI7rxvWVhx3WLFOqr0aeswVJ9n2Th9H3nv8i37ovZe4pw/xYux5U4/rysnlv6uX3ypaG9zHBgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f8 0 ?f9 ?f12" svg:viewBox="0 0 0 0" draw:type="ooxml-downArrow" draw:modifiers="50000 50000" draw:enhanced-path="M 0 ?f5 L ?f8 ?f5 ?f8 0 ?f9 0 ?f9 ?f5 ?f14 ?f5 ?f7 ?f13 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="100000*logheight/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight+0-?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth*?f2 /200000"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f6 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f8 *?f4 /?f10 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f5 +?f11 -0"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight"></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f8 0" draw:handle-range-x-maximum="100000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="0 ?f5" draw:handle-range-y-maximum="?f1" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_downArrow("ooxml-downArrow", "H4sIAAAAAAAAAJ2VUW/bIBDHvwpCe2izIIOTNG1V1+qet32AvaEabCQDGSGx008/wLHT2M40lojoMJff/+7CXV4KQ5tnpiqq3lmBSqYls+YEwmMpjNEGVdqID60srTPIab1n8Or4yIwV7+NDy1qLqGF0n8GcPwIMcv7kFkkh2B/L56NgzTfdZhCD8O6/dtqxDGrdyhoVulFvTqLp9XQhuGDGETfYvUD4PB8OKeyorTL4IwhuwHfgxb11CaIPxT8j67Ox9ZsV+AV+wteXjvj7QK3QquMrKl1gvJfj2shDTTMohbqrddmIwlZLZ1RMlJW9d5DkivI3KBlDiU8MLwZcknMMopDpGCn4HUZfMFjipTM7gbD3q9vex0W9mpcgZwlXThB2fvlNJH49xvsaLHK+AkkXbhRtM6YNtf2KUc7XcdV9mKGFG+DiS0GSxse3vUVM0ijO47RqWxBSfIhL8WkW5DEoLjMyaZn/TI1M2sS39ML/eK4/SGSDkEmH+DngEiQkOsNJJwyXK44zufJ9pW5h3MgragY+2Win98J7nKcuvDo0VJUMtUjSVsiD7AfNDSehOqdLNTqPfxEP03eOe7qI58PgG3vcVk7m/69e/wB/s2nXyAYAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f12 ?f8 ?f13 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-leftRightArrow" draw:modifiers="50000 50000" draw:enhanced-path="M 0 ?f7 L ?f4 0 ?f4 ?f8 ?f5 ?f8 ?f5 0 ?f14 ?f7 ?f5 ?f15 ?f5 ?f9 ?f4 ?f9 ?f4 ?f15 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="50000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth+0-?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="logheight*?f2 /200000"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f6 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f8 *?f4 /?f10 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f4 +0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f5 +?f11 -0"></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f15" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f5 ?f8" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f4 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_leftRightArrow("ooxml-leftRightArrow", "H4sIAAAAAAAAAJ2VW3OjIBSA/wrD7EOahlGMaZJOrdM+b/uwj/vGVFBmRFJCEtNfv1w0bdXsLKsDHuDkOxc45KFQ5HRPm4o0b7RAJZWCanUGblpwpaRClVT8Qzaa1BlkpN5T+G35SJXmb8NFTVuNiKJkn8Gc4QTkbGMaXppuC8H+WN4fOT09yzaDMXBv/8vzjmZQylbUqKZM/+JlpZ+MqVNvVxaccaoMeRWbB7i+W7yEsiO6yuCLAedsDX6aPnVy2nmyunztLE6dmp/Gq07Ydvr91yz8Bq/w8cGbej8QzWXjDTdEGLdZ7weTShxqkkHBm1ktyxMvdLUwQkVtPDcGEn2j/A2Kh1AX8bzHRjmLQRAwGQI5m8XoRwwW8cKI2OL92DY/vAnzeTltAncmTDKBG9lmB4H4dIi3OZjnbAki724QbTWk9am9jZHd+iDY3QTM77rxLwFREu7f+ioySoJAm3Ha1sAFeRcW5HYSZDEoLDQ8qpj/jQ2PysRW+Nzun6kQHFgieFQjFuRShXEgalQL9nq5daDQbI3OfX9SwzBTB94n/RrHXKtFTcEXGe3knlsNH09+OVzdsiJNSdEZCdJycRAZ7ApzWok3XukzH17j38ynYJLbfhrPL7foUOO65Wj63/HxD1lW/fg2BwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f8 ?f12 ?f9 ?f13" svg:viewBox="0 0 0 0" draw:type="ooxml-upDownArrow" draw:modifiers="50000 50000" draw:enhanced-path="M 0 ?f4 L ?f7 0 ?f16 ?f4 ?f9 ?f4 ?f9 ?f5 ?f16 ?f5 ?f7 ?f15 0 ?f5 ?f8 ?f5 ?f8 ?f4 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="50000*logheight/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight+0-?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth*?f2 /200000"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f6 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f8 *?f4 /?f10 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f4 +0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f5 +?f11 -0"></draw:equation><draw:equation draw:name="f14" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f15" draw:formula="logheight"></draw:equation><draw:equation draw:name="f16" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f8 ?f5" draw:handle-range-x-maximum="100000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="0 ?f4" draw:handle-range-y-maximum="?f1" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_upDownArrow("ooxml-upDownArrow", "H4sIAAAAAAAAAJ2V3W7bIBSAXwWhXbRpkI0TJ2lV1+q0y20PsDtUg41kICUkdvb0AxwnrX+msUTGHJ/j7/yYA8+FJs0TlRWRb7RAJVWCGn0G/rHgWiuNKqX5byUNqTPISH2g8JP6RLXhb0Oloa1BRFNyyGDOdiBnOLHDo5usIDicyqcTp81X1WYwBv7fv3ne0wwq1YoaHfffVCNfrZ+md6oKzjjVFpvG9gf8eFFe89gTU2Xwh6XmbA2+23Hr53jjH3Rx9Pe0V6TezgqpN3bi7sN9DX6Bn/DluXP1fiSGK9k5lkTYmFkfB1NaHGuSQcHlXa3KhhemWtpJRXlZmXsLiT5R/gbFQ6jPeHGlRTmLQRAxGRI5u4vRlxgs46WdYsfvZHd14n1Y0KtpF/jiwtYYeMldTgjEr4d4V4NFzlYg6sINoqVD2rW2DzFy3z2Itpmg+QVg40tAlITHt50jRkkQZzeu2hb4FDdhKT5OghwGhWWGRx3zn6nhUZe4nl24j2f7Awc2CB51iAP5SmEciBp1gttQHjwotFijVX/bAwKrNb/iwziza30OY/fnoqbgwxzt1YE7i/6c6GO7qDWRJUUtEqTl4igyeGnwaSMuO6NbZTuLf3HvD4sp7vnmPL9ux0OLec/R9Bn78gdC57YKfAcAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f22 ?f19 ?f23 ?f20" svg:viewBox="0 0 0 0" draw:type="ooxml-quadArrow" draw:modifiers="22500 22500 22500" draw:enhanced-path="M 0 ?f16 L ?f7 ?f17 ?f7 ?f19 ?f13 ?f19 ?f13 ?f7 ?f10 ?f7 ?f9 0 ?f11 ?f7 ?f14 ?f7 ?f14 ?f19 ?f15 ?f19 ?f15 ?f17 ?f24 ?f16 ?f15 ?f18 ?f15 ?f20 ?f14 ?f20 ?f14 ?f21 ?f11 ?f21 ?f9 ?f25 ?f10 ?f21 ?f13 ?f21 ?f13 ?f20 ?f7 ?f20 ?f7 ?f18 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$1 ,0,if(50000-$1 ,$1 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *2/1"></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="100000+0-?f1 "></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 *1/2"></draw:equation><draw:equation draw:name="f5" draw:formula="if(0-$2 ,0,if(?f4 -$2 ,$2 ,?f4 ))"></draw:equation><draw:equation draw:name="f6" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 *?f5 /100000"></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 *?f0 /100000"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 +0-?f8 "></draw:equation><draw:equation draw:name="f11" draw:formula="?f9 +?f8 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="?f6 *?f2 /200000"></draw:equation><draw:equation draw:name="f13" draw:formula="?f9 +0-?f12 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f9 +?f12 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth+0-?f7 "></draw:equation><draw:equation draw:name="f16" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f17" draw:formula="?f16 +0-?f8 "></draw:equation><draw:equation draw:name="f18" draw:formula="?f16 +?f8 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="?f16 +0-?f12 "></draw:equation><draw:equation draw:name="f20" draw:formula="?f16 +?f12 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="logheight+0-?f7 "></draw:equation><draw:equation draw:name="f22" draw:formula="?f12 *?f7 /?f8 "></draw:equation><draw:equation draw:name="f23" draw:formula="logwidth+0-?f22 "></draw:equation><draw:equation draw:name="f24" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f25" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f13 ?f7" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f10 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f24 ?f7" draw:handle-range-y-maximum="?f4" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_quadArrow("ooxml-quadArrow", "H4sIAAAAAAAAALVW247bIBD9FWT1YTeNZcC5rtYbbZ/bfkDf0BrHSLZJiZM4+/XlEpw44KpEqiI7Awxn5gxnLF5zQU4vtClJ80HzeEt5TVtxBnq6ZkJwEZdcsE/etKTKooJUexoNlo9UtOzjfrGlXRsTQck+izYFxmBToLV84VS9YAT2x+3LkdHTN95lEQT6Z/eedzSLOO/qKv59IPm7jHOyQXnOCkaFhMV4DiG4eV9cejY70pZZ9EMiy+AL8F3+LZW5tIZKCKUDS8/Di7E2W5Gdn90aZs98aKlVPDPx7NzKWhjavTcWshG0pUs0tzmYxXRo2eR6Qwb4BX5Gb6+GvaxYy3hjatGQWpaysKUpuKgPFckiVjzB+AsCUziVpqwdNEP16NHzswRMBoh/C4DuA2wKCCY4QUEo2J8mvKQpqQI9Uo8aBCaZ3sMjxRR+hbECC4KauXxTMEEJDkKZ+/ninu8M6JF61CCQ7+IevmbNU8W3J5a35VQaJWXbsg0DXbrMF2CyKeYgMeUMQluNoMGH0Nb3aJZs4Lkgp19UZ2qdrMJ0gjyNIZEUThzGDTnNcSkVBgkOLxVymqGniHAgR08zaI4SKJSk0xH2BHVmy8DEnAboNR8qCI/q5Rf+IUV4JK+gHpGEo/drVqGHiD2SN2mFnyJ2RN/X/ZFjxB7ly6QmCigJrj92hD+QGA6tmyN+CxcG4xO+KdkYjrzk5BUFN3a843umPHSF9G0mGqwL0mxp3MU16Vh9qLXbiAdrjMf15I3HPwa/XubGQutbxn8Jru9fXubnW+azEY/x4In/svz2ByTry+pFCwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f21 ?f19 ?f22 ?f20" svg:viewBox="0 0 0 0" draw:type="ooxml-leftRightUpArrow" draw:modifiers="25000 25000 25000" draw:enhanced-path="M 0 ?f18 L ?f7 ?f17 ?f7 ?f19 ?f13 ?f19 ?f13 ?f7 ?f10 ?f7 ?f9 0 ?f11 ?f7 ?f14 ?f7 ?f14 ?f19 ?f15 ?f19 ?f15 ?f17 ?f23 ?f18 ?f15 ?f24 ?f15 ?f20 ?f7 ?f20 ?f7 ?f24 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$1 ,0,if(50000-$1 ,$1 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *2/1"></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="100000+0-?f1 "></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 *1/2"></draw:equation><draw:equation draw:name="f5" draw:formula="if(0-$2 ,0,if(?f4 -$2 ,$2 ,?f4 ))"></draw:equation><draw:equation draw:name="f6" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 *?f5 /100000"></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 *?f0 /100000"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 +0-?f8 "></draw:equation><draw:equation draw:name="f11" draw:formula="?f9 +?f8 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="?f6 *?f2 /200000"></draw:equation><draw:equation draw:name="f13" draw:formula="?f9 +0-?f12 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f9 +?f12 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth+0-?f7 "></draw:equation><draw:equation draw:name="f16" draw:formula="?f6 *?f0 /50000"></draw:equation><draw:equation draw:name="f17" draw:formula="logheight+0-?f16 "></draw:equation><draw:equation draw:name="f18" draw:formula="logheight+0-?f8 "></draw:equation><draw:equation draw:name="f19" draw:formula="?f18 +0-?f12 "></draw:equation><draw:equation draw:name="f20" draw:formula="?f18 +?f12 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="?f12 *?f7 /?f8 "></draw:equation><draw:equation draw:name="f22" draw:formula="logwidth+0-?f21 "></draw:equation><draw:equation draw:name="f23" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f24" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f13 ?f7" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f10 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f23 ?f7" draw:handle-range-y-maximum="?f4" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_leftRightUpArrow("ooxml-leftRightUpArrow", "H4sIAAAAAAAAALVW246bMBD9FQv1YTcNwnYgl9WyUfvc9qFSX/pmLQYsAU4dkpB+fX0BEjBUdaQqgoxvZ+bMzEn8mghyeaFVTqp3mvgZ5SWtxRXo6ZIJwYWfc8F+86omReylpDhSb7B8pqJm7+PFmja1TwQlx9jbpxiBfYp28oWxekEPHM/Zy5nRy2fexB4E+tOdvR5o7HHelIVf0LT+zrK8/nH4JN1dOt88YSmjQqLjCEII7t7tlp7UgdR57H2VDmQMW/BFfm2UuekMFRdaDSw9D1tjZ46ibj68N8yZaGipVbwy/to5HPZWh3szQvATfPPeXk3gv06kZrwyNCpSymSkHauUi/JUkNhj6RP0PyCwhEtpKt5mqB49en6WgMEA8W8O0NjBPoVggQPkhIKnw4RtmDIDQI/UowaOQa7G8EgxhR+hr8CcoEKb7wosUICdUKJpvrjnGwI9Uo8aOPJdj+FLVj0VPLuwpM6X0sip0oYb6MZmvgaLfRqBwKTTCW07gwYfQtuN0TqyjnVBll6UjHWfbN36BE0IQyIpHN+NG7LE0aYKgwC7pwpZYugpIuzIcUIMmqMEciVpKaKroI5s4xiYJYBbd0XuGbM6v1eQSdvaMTqr94d4rp1mNb/+/3ioonii/xXWIyXFEwqQKAtVzcCZJbZUMGgQ7Pgzji0VdHBuMJYC+lLO4cjbRVJQcGf7B35kaofOkL5GeIN1QaqM+o1fkoaVp1Jvm9nBKrPjViqz4x+d3y5Tc66NfP6HczzL/HrPPJzZMe88mL6svv0BJTeF48UKAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f25 ?f24" svg:viewBox="0 0 0 0" draw:type="ooxml-bentArrow" draw:modifiers="25000 25000 25000 43750" draw:enhanced-path="M 0 ?f24 L 0 ?f22 L ?f19 ?f8 ?f19 0 ?f25 ?f6 ?f19 ?f21 ?f19 ?f20 ?f18 ?f20 L ?f5 ?f24 Z N" drawooo:enhanced-path="M 0 ?f24 L 0 ?f22 G ?f15 ?f15 ?f26 ?f27 L ?f19 ?f8 ?f19 0 ?f25 ?f6 ?f19 ?f21 ?f19 ?f20 ?f18 ?f20 G ?f17 ?f17 ?f28 ?f29 L ?f5 ?f24 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$1 ,0,if(50000-$1 ,$1 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *2/1"></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$2 ,0,if(50000-$2 ,$2 ,50000))"></draw:equation><draw:equation draw:name="f4" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 *?f2 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="?f4 *?f0 /100000"></draw:equation><draw:equation draw:name="f7" draw:formula="?f5 *1/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 +0-?f7 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f4 *?f3 /100000"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth+0-?f9 "></draw:equation><draw:equation draw:name="f11" draw:formula="logheight+0-?f8 "></draw:equation><draw:equation draw:name="f12" draw:formula="min(?f10 ,?f11 )"></draw:equation><draw:equation draw:name="f13" draw:formula="100000*?f12 /?f4 "></draw:equation><draw:equation draw:name="f14" draw:formula="if(0-$3 ,0,if(?f13 -$3 ,$3 ,?f13 ))"></draw:equation><draw:equation draw:name="f15" draw:formula="?f4 *?f14 /100000"></draw:equation><draw:equation draw:name="f16" draw:formula="?f15 +0-?f5 "></draw:equation><draw:equation draw:name="f17" draw:formula="max(?f16 ,0)"></draw:equation><draw:equation draw:name="f18" draw:formula="?f5 +?f17 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="logwidth+0-?f9 "></draw:equation><draw:equation draw:name="f20" draw:formula="?f8 +?f5 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="?f20 +?f8 -0"></draw:equation><draw:equation draw:name="f22" draw:formula="?f8 +?f15 -0"></draw:equation><draw:equation draw:name="f23" draw:formula="?f20 +?f17 -0"></draw:equation><draw:equation draw:name="f24" draw:formula="logheight"></draw:equation><draw:equation draw:name="f25" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f26" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(-5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f5 ?f24" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f25 ?f21" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f19 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f15 0" draw:handle-range-x-maximum="?f13" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_bentArrow("ooxml-bentArrow", "H4sIAAAAAAAAAKVXXbPaIBD9K0ymD/EjFTCJeud6M+1LX9r+gL7RKzHMJMHG+NVf3wWMXiWpouOAi5CzZ5c9AV8XFdu98DJj5TtfBEsuC15XB6R/LkRVySrIZCX+yrJm+dxLWb7m3sX0lle1eL+erPm+DljF2XruYYRRktJIdaGH1tvly1bw3Ve5N3PwaZ46rPjck3Jf5MFvXtZfwMOucScXIhW8AkAaYYzRxz4cT6IG5BTNitXZ3PthvIfouzEoGElKZtBNjXFiFzcTlJwsNUmmxlIPmijQL/TTuJNS3vb4TYFETUeVHzp5nIeGmzQd1b/Ortm9vZps/NmwWsjS5KZkBSQ4bVKVyqrY5GzuidTHwSeChngIpkqpGaqmR70eAI4uEP/ngFw7SFKM+nREnFBoO018pAnxIz1STQ0cSY7b4ellFmCo2iNZCK8dFKL0c7nciUWdDcHIuFhmtRtoZKc2RH3YdjQiiiN2Qos70PBDaBMbLUJ9MqJOKFMbJUYDHCTpBDkBzTqCGz8UHLFU02yl5jZz40YsiZzqQcNNHeEsrahaA1EYaYA23OAsbZiEQfIIFJrKoxueJQWjtfFZymOkh6rpkesbp0sXJHxst1uUAW9vvTeRY/CWLAq2VyHHEL1jlC3aAFL6JAgcA7TU8Uw5U0scqoQHip0jL9pydsCZN1B4rlCWKI6kiDsrSxANK/fMU0sMJ+m74Vgl3+ygG4xV6T7BU62Y3ihWX58d47Pq3Y/CZ/CsovdJTJ8BtErfD+5lCDe9Rc7RBztYybVQK4wYk/P+HucrVi55sA9A9aLYFPpN0rFClGbF2b1ZcZ9zc8VuxT6cveubTMea5/yrO+yN0DudPx08aPqW8+R8rt3v+1gF13+R3v4BdKiuEzsNAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f34 ?f33" svg:viewBox="0 0 0 0" draw:type="ooxml-uturnArrow" draw:modifiers="25000 25000 25000 43750 75000" draw:enhanced-path="M 0 ?f33 L 0 ?f23 L ?f30 0 L ?f18 ?f17 ?f34 ?f17 ?f27 ?f15 ?f28 ?f17 ?f29 ?f17 ?f29 ?f26 L ?f26 ?f11 L ?f11 ?f33 Z N" drawooo:enhanced-path="M 0 ?f33 L 0 ?f23 G ?f23 ?f23 ?f35 ?f36 L ?f30 0 G ?f23 ?f23 ?f37 ?f38 L ?f18 ?f17 ?f34 ?f17 ?f27 ?f15 ?f28 ?f17 ?f29 ?f17 ?f29 ?f26 G ?f25 ?f25 ?f39 ?f40 L ?f26 ?f11 G ?f25 ?f25 ?f41 ?f42 L ?f11 ?f33 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$1 ,0,if(25000-$1 ,$1 ,25000))"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *2/1"></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 *?f3 /logheight"></draw:equation><draw:equation draw:name="f5" draw:formula="100000+0-?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 *logheight/?f3 "></draw:equation><draw:equation draw:name="f7" draw:formula="if(0-$2 ,0,if(?f6 -$2 ,$2 ,?f6 ))"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +?f2 -0"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 *?f3 /logheight"></draw:equation><draw:equation draw:name="f10" draw:formula="if(?f9 -$4 ,?f9 ,if(100000-$4 ,$4 ,100000))"></draw:equation><draw:equation draw:name="f11" draw:formula="?f3 *?f2 /100000"></draw:equation><draw:equation draw:name="f12" draw:formula="?f3 *?f0 /100000"></draw:equation><draw:equation draw:name="f13" draw:formula="?f11 *1/2"></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 +0-?f13 "></draw:equation><draw:equation draw:name="f15" draw:formula="logheight*?f10 /100000"></draw:equation><draw:equation draw:name="f16" draw:formula="?f3 *?f7 /100000"></draw:equation><draw:equation draw:name="f17" draw:formula="?f15 +0-?f16 "></draw:equation><draw:equation draw:name="f18" draw:formula="logwidth+0-?f14 "></draw:equation><draw:equation draw:name="f19" draw:formula="?f18 *1/2"></draw:equation><draw:equation draw:name="f20" draw:formula="min(?f19 ,?f17 )"></draw:equation><draw:equation draw:name="f21" draw:formula="?f20 *100000/?f3 "></draw:equation><draw:equation draw:name="f22" draw:formula="if(0-$3 ,0,if(?f21 -$3 ,$3 ,?f21 ))"></draw:equation><draw:equation draw:name="f23" draw:formula="?f3 *?f22 /100000"></draw:equation><draw:equation draw:name="f24" draw:formula="?f23 +0-?f11 "></draw:equation><draw:equation draw:name="f25" draw:formula="max(?f24 ,0)"></draw:equation><draw:equation draw:name="f26" draw:formula="?f11 +?f25 -0"></draw:equation><draw:equation draw:name="f27" draw:formula="logwidth+0-?f12 "></draw:equation><draw:equation draw:name="f28" draw:formula="?f27 +0-?f12 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f28 +?f14 -0"></draw:equation><draw:equation draw:name="f30" draw:formula="?f18 +0-?f23 "></draw:equation><draw:equation draw:name="f31" draw:formula="?f29 +0-?f25 "></draw:equation><draw:equation draw:name="f32" draw:formula="(?f11 +?f29 )/2"></draw:equation><draw:equation draw:name="f33" draw:formula="logheight"></draw:equation><draw:equation draw:name="f34" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f35" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f36" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f37" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f38" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f39" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f40" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f41" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f42" draw:formula="(-5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f11 ?f33" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f28 ?f33" draw:handle-range-x-maximum="25000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f28 ?f17" draw:handle-range-y-maximum="?f6" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f23 0" draw:handle-range-x-maximum="?f21" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f34 ?f15" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="?f9"></draw:handle></draw:enhanced-geometry>
    ooxml_uturnArrow("ooxml-uturnArrow", "H4sIAAAAAAAAALVY23KbMBD9FQ3TB2KbogsXk4njaV/60vYD+sbEYGvGoBTj2OnXVythbCycRDCxByGBfHaPds8K/LCq0sN9Vm7S8ilbeetMFFldvSJ1ueBVJSpvIyr+T5R1ul04ebrdZU7n9ktW1fzp+madHWsvrbJ0t3AwwmiZswAa5qDdy/r+hWeH7+Ko78nv6Vevz9nCEeJYbL19va/Kb9LE4WRPrHjOs0oi0hBjjC7bgMUhRjH0m+ktqee03iycX9oJhn6qDoWOHIN16JA5NPHJT9Wj0JAQeu1dmnR6NFK/lid5lWgkou38Qb+1J0KI9535oU9Nw8Aoi84uXt1Wfs5HOq4ww1PD4GqAO3S6MwIgFlCD5OODXu+/+7TmotSrX6aFjGR+CkYuqmK/TRcOz13sfSFohmeyq2KnhnCo0d2dBPQ7iG8ZINcGljlGE+oTKxTa7yZu3JR8kRrBAQNLJ9k1fMFLdyvWB76qNzPZ2WR8vantQAOTOUUTGRXkt4hWgOE1IMHwmWJPhh1ZQUWmbyGatG754KUVYNwfINoGKEJqBAcMLAM0N/2N0RQW1MNWQIkJNB8VFNKnoGWeSLoBUE0Q8NeRUpfg0ENbJfVIiYHvFPka0A7O0FQDh4fBGRpSRWhCfGqH0yMbQpFKcmKZlMRQTBtjyZMMJNqjHbVu8TA4QzlqZ9B8I0u+hkxONUzDWRYJ0iMWuZtZh5QaEoHyKrESVaxjZKcD2qMDKvcUvfj2pYve2FxYW7so7C5yCIcaWSqX9mhDK3eYdGnf1sKanCGW7A2NFOkROMsyhS1p9ihDujNVjyeWdZoasuimMrVk2bOByIewYVg9spCPcVMlMEuazJCGkpjyi1rmMevTRdJghZZYhibcNpYJurMsAMzI/2F7LTPy/pQUdjBGysv9ea63ZD+C01fLKBqJ74bBGDwj+V0S0TGARvqPdNCQgDsQKTAE4HqjXAsMFYxcu8CUwoc9lO+Uq22GLvres9hxmNEUx+VZHM2EKi3XmXf0ZBnmxb5Q827M4KWecbavZ3zMunr1fNc6vXhj/wT77eNPB/v1kn10Y8ZI6wzdonU2TT9n5fUfAeE7zJsHg7fJyxcMw4UmFa//M3r8DxIBBg5MEgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f18 ?f16 ?f11 ?f17" svg:viewBox="0 0 0 0" draw:type="ooxml-leftUpArrow" draw:modifiers="25000 25000 25000" draw:enhanced-path="M 0 ?f12 L ?f6 ?f9 ?f6 ?f16 ?f14 ?f16 ?f14 ?f6 ?f8 ?f6 ?f11 0 ?f22 ?f6 ?f15 ?f6 ?f15 ?f17 ?f6 ?f17 ?f6 ?f21 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$1 ,0,if(50000-$1 ,$1 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *2/1"></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="100000+0-?f1 "></draw:equation><draw:equation draw:name="f4" draw:formula="if(0-$2 ,0,if(?f3 -$2 ,$2 ,?f3 ))"></draw:equation><draw:equation draw:name="f5" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 *?f4 /100000"></draw:equation><draw:equation draw:name="f7" draw:formula="?f5 *?f0 /50000"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth+0-?f7 "></draw:equation><draw:equation draw:name="f9" draw:formula="logheight+0-?f7 "></draw:equation><draw:equation draw:name="f10" draw:formula="?f5 *?f0 /100000"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth+0-?f10 "></draw:equation><draw:equation draw:name="f12" draw:formula="logheight+0-?f10 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f5 *?f2 /200000"></draw:equation><draw:equation draw:name="f14" draw:formula="?f11 +0-?f13 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f11 +?f13 -0"></draw:equation><draw:equation draw:name="f16" draw:formula="?f12 +0-?f13 "></draw:equation><draw:equation draw:name="f17" draw:formula="?f12 +?f13 -0"></draw:equation><draw:equation draw:name="f18" draw:formula="?f13 *?f6 /?f10 "></draw:equation><draw:equation draw:name="f19" draw:formula="(?f6 +?f15 )/2"></draw:equation><draw:equation draw:name="f20" draw:formula="(?f6 +?f17 )/2"></draw:equation><draw:equation draw:name="f21" draw:formula="logheight"></draw:equation><draw:equation draw:name="f22" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f14 ?f16" draw:handle-range-y-maximum="?f1" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f8 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f14 ?f6" draw:handle-range-y-maximum="?f3" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_leftUpArrow("ooxml-leftUpArrow", "H4sIAAAAAAAAAKWW35OaMBDH/5VMpg/qyZBEObyb45z2ue1bX+4tcwbIDBAbUbF/ffNDVAi2F24cwq4sn/1uwgZeNpIen1mV0+qdbYKMiZLV8gTM3yWXUsggF5L/EVVNiwSmtNgx2Ll8YLLm7/2LNWvqgEpGdwlcp3gF1PCoB6yHGILdIXs+cHb8JpoEImB+7b2nLUugEE1ZBAVL61/bryrTsU0rNjzlTCowiRBC4GY8h1zq2dI6T+APxVZJCfiuTlrE0/lsFS07ljZW7XVs7iSk9aNbA8et1xoEgzfwE76+WBW/97TmorKaKlqqotJWYipkuS9oAnk6QcEXDOZorkxdhHX1YbzpVAHDDvFfCXA/wTpFYEZC7EUhwzLRWaaqGRhPH9rxFLno47GuFD2gQMO8UMthpeSidAGMpw/teCqN+viSV5NCZEe+qfO5MnLGs7z2gz66axSB2TpdgtBOhBctvkNDIIy8Yas+rK3VrE3stzZPAzA7X2No2Omda6Ejpg07ndIpFSNPdU7LdIv15jk9cq6WgJCMqNbpE7O9WWkLT2lOU1iWIQWeugZ6Qe3U43QNdIJmjdLlNIKhzPRGH45YTacVJpr0YF4l05D4bc5OI1xgsT9sqA3sc+vHGXr+TTvdw6h39KZg4MYOtmLHdYSZbftehp0ASauMBaegpA0v96WJuxPBKxtxXXcb8bHsq8vXSIfbXDPbvXU45nO57XfIfwtfeBceDn/tvf4FxFZ0qAYKAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 ?f13 ?f11 ?f17" svg:viewBox="0 0 0 0" draw:type="ooxml-bentUpArrow" draw:modifiers="25000 25000 25000" draw:enhanced-path="M 0 ?f13 L ?f10 ?f13 ?f10 ?f4 ?f6 ?f4 ?f8 0 ?f18 ?f4 ?f11 ?f4 ?f11 ?f17 0 ?f17 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(0-$1 ,0,if(50000-$1 ,$1 ,50000))"></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$2 ,0,if(50000-$2 ,$2 ,50000))"></draw:equation><draw:equation draw:name="f3" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 *?f2 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="?f3 *?f1 /50000"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f3 *?f1 /100000"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth+0-?f7 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f3 *?f0 /200000"></draw:equation><draw:equation draw:name="f10" draw:formula="?f8 +0-?f9 "></draw:equation><draw:equation draw:name="f11" draw:formula="?f8 +?f9 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="?f3 *?f0 /100000"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight+0-?f12 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f11 *1/2"></draw:equation><draw:equation draw:name="f15" draw:formula="(?f13 +logheight)/2"></draw:equation><draw:equation draw:name="f16" draw:formula="(?f4 +logheight)/2"></draw:equation><draw:equation draw:name="f17" draw:formula="logheight"></draw:equation><draw:equation draw:name="f18" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="0 ?f13" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f6 0" draw:handle-range-x-maximum="50000" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f10 ?f4" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_bentUpArrow("ooxml-bentUpArrow", "H4sIAAAAAAAAALVW0W7bIBT9FYT2kLZBBidp0qputD1ve9tL31iNbSQDGSGJs68fmDiuY7sqqaYIzM29OefciAN+SjU9PDJZUPnKUpQzJZjRR1B/LbjWSqNCaf5XSUPLBGa03DLYSe+ZNvz1MmlYZRDVjG4TiME6IzM3ETctIdju88c9Z4dvqnLp+tP88LhhCVSqEiX6zaT5tflqaQ4Np0p5xpm2qPECYwzezKeSczMbaooE/gAn+u/u0Upxq7kd96fnytetTmEtdd5q9tkleAE/4fOTJ/qzo4Yr6WklFVZ31qjIlBa7kiaQZxOMvmAwxVO7dDp96EYd3dxYwKiD+B4BGSYgXQIbunENQTxMEHcJbOjGNQSzSwLB5aRU+YGnppjaRcF4Xpgw0Pkl6Dqbgdt1FoOIOI04CG0xgkZAtAgGu78Ea3q9w2idLUAQ2HJc2RV9rt6VtgyT9jAiDYMoDpdGek5yHq11PYTpIj3L1EgOBwVq6nmjbfGKf5/0nHDe/HWfJA5sdMAE9vi6JVEchtPb/pP61LxrvRmK2PPAxJ2unwDs+eAMFYYz6oAxGHu5pCUDb9Zoo7bcVTQ3HexkNZU5Q0ckaMXFTiTQnyDDNVz6mnYj+YqPkLu7bBC3+gB39Vluf6H+l9aj4ZeU539qPiubvQgAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f43 ?f44" svg:viewBox="0 0 0 0" draw:type="ooxml-curvedRightArrow" draw:modifiers="25000 50000 25000" draw:enhanced-path="M 0 ?f8 L ?f32 ?f28 ?f43 ?f31 ?f32 ?f29 ?f32 ?f25 Z S N M ?f43 ?f4 Z  S N M ?f45 ?f8 L ?f45 ?f8 ?f54 ?f55 ?f32 ?f28 ?f43 ?f31 L ?f45 ?f8 L ?f45 ?f8 F N" drawooo:enhanced-path="M 0 ?f8 G ?f45 ?f8 ?f46 ?f47 L ?f32 ?f28 ?f43 ?f31 ?f32 ?f29 ?f32 ?f25 G ?f45 ?f8 ?f48 ?f49 Z S N M ?f43 ?f4 G ?f45 ?f8 ?f50 ?f51 ?f45 ?f8 ?f52 ?f53 Z I S N M 0 ?f8 G ?f45 ?f8 ?f54 ?f55 L ?f32 ?f28 ?f43 ?f31 ?f32 ?f29 ?f32 ?f25 G ?f45 ?f8 ?f56 ?f57 L 0 ?f8 G ?f45 ?f8 ?f58 ?f59 L ?f43 ?f4 G ?f45 ?f8 ?f60 ?f61 F N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="50000*logheight/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$0 ,0,if(?f2 -$0 ,$0 ,?f2 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="(?f4 +?f5 )/4"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 *2/1"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 *?f9 /1"></draw:equation><draw:equation draw:name="f11" draw:formula="?f4 *?f4 /1"></draw:equation><draw:equation draw:name="f12" draw:formula="?f10 +0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="sqrt(?f12 )"></draw:equation><draw:equation draw:name="f14" draw:formula="?f13 *logwidth/?f9 "></draw:equation><draw:equation draw:name="f15" draw:formula="100000*?f14 /?f0 "></draw:equation><draw:equation draw:name="f16" draw:formula="if(0-$2 ,0,if(?f15 -$2 ,$2 ,?f15 ))"></draw:equation><draw:equation draw:name="f17" draw:formula="?f0 *?f16 /100000"></draw:equation><draw:equation draw:name="f18" draw:formula="?f8 +?f4 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="logwidth*logwidth/1"></draw:equation><draw:equation draw:name="f20" draw:formula="?f17 *?f17 /1"></draw:equation><draw:equation draw:name="f21" draw:formula="?f19 +0-?f20 "></draw:equation><draw:equation draw:name="f22" draw:formula="sqrt(?f21 )"></draw:equation><draw:equation draw:name="f23" draw:formula="?f22 *?f8 /logwidth"></draw:equation><draw:equation draw:name="f24" draw:formula="?f8 +?f23 -0"></draw:equation><draw:equation draw:name="f25" draw:formula="?f18 +?f23 -0"></draw:equation><draw:equation draw:name="f26" draw:formula="?f5 +0-?f4 "></draw:equation><draw:equation draw:name="f27" draw:formula="?f26 *1/2"></draw:equation><draw:equation draw:name="f28" draw:formula="?f24 +0-?f27 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f25 +?f27 -0"></draw:equation><draw:equation draw:name="f30" draw:formula="?f5 *1/2"></draw:equation><draw:equation draw:name="f31" draw:formula="logheight+0-?f30 "></draw:equation><draw:equation draw:name="f32" draw:formula="logwidth+0-?f17 "></draw:equation><draw:equation draw:name="f33" draw:formula="(10800000*atan2(?f23 ,?f17 ))/pi"></draw:equation><draw:equation draw:name="f34" draw:formula="10800000+0-?f33 "></draw:equation><draw:equation draw:name="f35" draw:formula="0+0-?f33 "></draw:equation><draw:equation draw:name="f36" draw:formula="logwidth+0-?f14 "></draw:equation><draw:equation draw:name="f37" draw:formula="(?f8 +?f18 )/2"></draw:equation><draw:equation draw:name="f38" draw:formula="?f4 *1/2"></draw:equation><draw:equation draw:name="f39" draw:formula="(10800000*atan2(?f38 ,?f14 ))/pi"></draw:equation><draw:equation draw:name="f40" draw:formula="?f39 +0-5400000"></draw:equation><draw:equation draw:name="f41" draw:formula="5400000+?f39 -0"></draw:equation><draw:equation draw:name="f42" draw:formula="10800000+0-?f39 "></draw:equation><draw:equation draw:name="f43" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f44" draw:formula="logheight"></draw:equation><draw:equation draw:name="f45" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f46" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f47" draw:formula="(?f35 )/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(?f34 )/60000.0"></draw:equation><draw:equation draw:name="f49" draw:formula="(?f33 )/60000.0"></draw:equation><draw:equation draw:name="f50" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f51" draw:formula="(?f40 )/60000.0"></draw:equation><draw:equation draw:name="f52" draw:formula="(?f42 )/60000.0"></draw:equation><draw:equation draw:name="f53" draw:formula="(?f41 )/60000.0"></draw:equation><draw:equation draw:name="f54" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f55" draw:formula="(?f35 )/60000.0"></draw:equation><draw:equation draw:name="f56" draw:formula="(?f34 )/60000.0"></draw:equation><draw:equation draw:name="f57" draw:formula="(?f33 )/60000.0"></draw:equation><draw:equation draw:name="f58" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f59" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f60" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f61" draw:formula="(?f40 )/60000.0"></draw:equation><draw:handle draw:handle-position="?f32 ?f24" draw:handle-range-y-maximum="?f2" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f43 ?f28" draw:handle-range-y-maximum="?f1" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f32 ?f44" draw:handle-range-x-maximum="?f15" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_curvedRightArrow("ooxml-curvedRightArrow", "H4sIAAAAAAAAALWYXW/aMBSG/4qFdsFXlvgrQFWKtotNk9pebHe7i0oCkUhCQ1rofv1s54PCMdOO2VTFdRLnsc/x+9oJt8sy2t/E+TrKn+Klt4qLLK7KN2IuZ2lZFqW3Lsr0V5FX0WbeS6LNLu6d3H6Nyyp9Or9ZxYfKi8o42s17AQnIIhFcF6JHdq+rm9c03n8uDvU99dc+9baN572iOGQb7+mlfI2X39PVuvqkOtq3vRbLNEnjUnGZDIKA6CIgpt406cLZRtV63nsw3U/JvSo5UwWbtsPhtLs262qS/CQ/yCN56AatLhyvyA7WVBeJFLqQVv699Zkv5LEebFEUl8b79X0XItTFBBHE6eOmmMHITlpJ3bGkJ5c0TXL14LfmUcvg2vgdByd1bFLHZmObYlYnzzLmUD8TUpPRu9t6/p9foiot8loNeZQpTSWtOJKizF420byXpXl/U6z26bJaj1VlHWupDRTEP6H8CUrPoUaMw47mL5KAoIjsnJgm/cD7QMk4GKvqIqHEnOlDnwxwA+Z2fNDhGTFn+tAnSLw4x+v4h2raiU91ZgIUTV6gMSdaeE7ray2NlLjIwBco1OQcdZxwhgJNYYQTMgo8pWicbGYQNCVD5lOcnIFJFslMZ3xGsCTgDJ3soS6wJOAIJfugThKluCxRIP/dc1lpUyml40gWpVNOhu2C4uuc4YhA7bXGVc6oShp6IaFA77XV2XElkcSc6sOcIc1OgQ0af9LQyaDU4oapNqggHpIE7NDOy3GCcCpkFmfQiQl2glU0s3iDzmpFM+x2AdzRKJpRpKIZ8IaCMB3hlPht1nBEi0fMfDKOnVBm2QqoKwsYQ28BJvsCmXyLAVhIhhS5CzCL8JloBDFBjsmyE6j3rZEhITPFLaKX+PA40Hu3XZoQOVLzHGi+lWe9KSAzxoHw+zSY1mtvVEU56xuVjQ15MPC3KQ4PXNDS6+A5crTACY4c4ILTJCKtwIEV+o3ZlU0HWMFY/CAcdAesACeWT83ECoeJFRZ3cLOMS4Hf/AT8lKgpI0NFOlcAi5yKDvluIoBFnDYEAazQLQQ4DvCA23DgF0GbpYEf6n8fkVm3mYDrzwsnGnCBpglXGjSDWTTcaBJov09DdkXqJJC//joLXIcH5K9pzJUGNwhFo640YIIrVSeBG65RnbR9JjurTlod4aw66IgrUwdN0ay6brzwX9sidLXFOsqXm5i8q3vbYpfqFmafMj/DtUpsGpRRvoq9Ny+LDmn2kpk3xwst0rxucey/bvF3vZuf8bqX3su90//Su4ldWGM/nPQuLzS53H0zFee/pt/9BhTC2fdmFwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f42 ?f43" svg:viewBox="0 0 0 0" draw:type="ooxml-curvedLeftArrow" draw:modifiers="25000 50000 25000" draw:enhanced-path="M 0 ?f31 L ?f32 ?f28 ?f32 ?f24 L ?f44 ?f8 Z S N M ?f47 ?f48 L ?f44 ?f8 Z  S N M ?f44 ?f8 L ?f44 ?f8 L ?f44 ?f8 L ?f44 ?f8 ?f57 ?f58 ?f32 ?f29 0 ?f31 F N" drawooo:enhanced-path="M 0 ?f31 L ?f32 ?f28 ?f32 ?f24 G ?f44 ?f8 ?f45 ?f46 ?f44 ?f8 ?f47 ?f48 L ?f32 ?f29 Z S N M ?f42 ?f18 G ?f44 ?f8 ?f49 ?f50 L 0 0 G ?f44 ?f8 ?f51 ?f52 Z I S N M ?f42 ?f18 G ?f44 ?f8 ?f53 ?f54 L 0 0 G ?f44 ?f8 ?f55 ?f56 L ?f42 ?f18 G ?f44 ?f8 ?f57 ?f58 L ?f32 ?f29 0 ?f31 ?f32 ?f28 ?f32 ?f24 G ?f44 ?f8 ?f59 ?f60 F N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="50000*logheight/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$0 ,0,if(?f2 -$0 ,$0 ,?f2 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="(?f4 +?f5 )/4"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 *2/1"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 *?f9 /1"></draw:equation><draw:equation draw:name="f11" draw:formula="?f4 *?f4 /1"></draw:equation><draw:equation draw:name="f12" draw:formula="?f10 +0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="sqrt(?f12 )"></draw:equation><draw:equation draw:name="f14" draw:formula="?f13 *logwidth/?f9 "></draw:equation><draw:equation draw:name="f15" draw:formula="100000*?f14 /?f0 "></draw:equation><draw:equation draw:name="f16" draw:formula="if(0-$2 ,0,if(?f15 -$2 ,$2 ,?f15 ))"></draw:equation><draw:equation draw:name="f17" draw:formula="?f0 *?f16 /100000"></draw:equation><draw:equation draw:name="f18" draw:formula="?f8 +?f4 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="logwidth*logwidth/1"></draw:equation><draw:equation draw:name="f20" draw:formula="?f17 *?f17 /1"></draw:equation><draw:equation draw:name="f21" draw:formula="?f19 +0-?f20 "></draw:equation><draw:equation draw:name="f22" draw:formula="sqrt(?f21 )"></draw:equation><draw:equation draw:name="f23" draw:formula="?f22 *?f8 /logwidth"></draw:equation><draw:equation draw:name="f24" draw:formula="?f8 +?f23 -0"></draw:equation><draw:equation draw:name="f25" draw:formula="?f18 +?f23 -0"></draw:equation><draw:equation draw:name="f26" draw:formula="?f5 +0-?f4 "></draw:equation><draw:equation draw:name="f27" draw:formula="?f26 *1/2"></draw:equation><draw:equation draw:name="f28" draw:formula="?f24 +0-?f27 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f25 +?f27 -0"></draw:equation><draw:equation draw:name="f30" draw:formula="?f5 *1/2"></draw:equation><draw:equation draw:name="f31" draw:formula="logheight+0-?f30 "></draw:equation><draw:equation draw:name="f32" draw:formula="0+?f17 -0"></draw:equation><draw:equation draw:name="f33" draw:formula="(10800000*atan2(?f23 ,?f17 ))/pi"></draw:equation><draw:equation draw:name="f34" draw:formula="0+0-?f33 "></draw:equation><draw:equation draw:name="f35" draw:formula="0+?f14 -0"></draw:equation><draw:equation draw:name="f36" draw:formula="(?f8 +?f18 )/2"></draw:equation><draw:equation draw:name="f37" draw:formula="?f4 *1/2"></draw:equation><draw:equation draw:name="f38" draw:formula="(10800000*atan2(?f37 ,?f14 ))/pi"></draw:equation><draw:equation draw:name="f39" draw:formula="?f38 +0-?f33 "></draw:equation><draw:equation draw:name="f40" draw:formula="?f33 +?f38 -0"></draw:equation><draw:equation draw:name="f41" draw:formula="0+0-?f38 "></draw:equation><draw:equation draw:name="f42" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f43" draw:formula="logheight"></draw:equation><draw:equation draw:name="f44" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f45" draw:formula="(?f33 )/60000.0"></draw:equation><draw:equation draw:name="f46" draw:formula="(?f39 )/60000.0"></draw:equation><draw:equation draw:name="f47" draw:formula="(?f41 )/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(?f40 )/60000.0"></draw:equation><draw:equation draw:name="f49" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f50" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f51" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f52" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f53" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f54" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f55" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f56" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f57" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f58" draw:formula="(?f33 )/60000.0"></draw:equation><draw:equation draw:name="f59" draw:formula="(?f33 )/60000.0"></draw:equation><draw:equation draw:name="f60" draw:formula="(?f39 )/60000.0"></draw:equation><draw:handle draw:handle-position="?f32 ?f24" draw:handle-range-y-maximum="?f2" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f42 ?f28" draw:handle-range-y-maximum="?f1" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f32 ?f43" draw:handle-range-x-maximum="?f15" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_curvedLeftArrow("ooxml-curvedLeftArrow", "H4sIAAAAAAAAALVYW2+bMBT+K1a0B5KWYRtDSNW02h42TWr7sre9oQYSpAAtoW26Xz8fO+R23MshmiocG5vv3L7PplzOmvTlIqsWaXWfzfx5VpdZ27wyc7ssmqZu/EXdFH/rqk2X00GeLlfZ4GD6OWva4v54ss3WrZ82WbqaDjjj7DpXEppwwFbP84vnInv5Xq/tnP7rnnp9yKaDul6XS//+qXnOZjdZ3n7Tdl46o/WsyIus0bAy4pwzaDgz/c2SbTQPabuYDm6N9VCwG/gBJ2Sy7SlzVyndJOwP+83u2C3cGEOTHE7uZu2dm4+613kEONHO3KTz5Qe7s97WdU10+Oe+ARVBEx/c2vO9s7oXGdwRyRHKBNzk+hEoxsFUJKCRGuHX+xhRCI1yYoCTUWxT43x2k6Z9lzc5+DADEfgec5PRq0tLgMentC3qytKhSkvNqbxjR1435dMynQ7KovKW9fylmLWLc91ZZMV80Q41SHCA8h6oOAY1bBxt0YLrnDMSojxGLHKP+18EO+fnuqtzx8wILhgMaQ6Hbni+hZfMjOCCARFeHcND/CNdORYIyAwnoUVvoMleaPExmo5WsTPNIDYMFAlqfAy1K7gkASU4wjE7475mNI02EwyUsJEMBI3OSCTX+QQyPmFUJKQMSPYIGioSUoSmPbdJEoKWJYHov3psWhCVZjoNycF0EbJRt6EEkDMaImK75bjOmdBJI28kAvHdSl3udpKImSFcZkQUu0Ay2OhTxL0EKhxqSECgivlEJCSHri67AtFYKB3KEGMT7JjKaOnQhphYRkvqcYHUsWG0FERGS6QNDSIhwoQFXdZoiA6NmHrKkFpQ6TgKRF8sJAw4Akz2FTH5DgHImI0E8RSQDuLr1xxLiDHRJ8dJICOTqTE1U6GD9BE9vBDxfXtcmhBDIudDxHl+ZnRIDQ8x3hM8sZtu2qaV9Ay9zg32cBg8FDR4RH9uww2J4SLum3DJm2LoegEyGtJKGlJr6qC+6kENxHxcgnBsSqD6lMAhhjBhvcqgHGLQGGcGkVgKhRSxoUZC9AkpoddGrZAQtgKl4SDG93MHEd4zqR4GMRDjKzHXLtqHk75oiPfwX4Toi4bpr9F4XzTEdo/3Q4oQ1z0/UkaWPQER4T0Ry1MAEfO90xzEZ0FfJCSCU3OH5XBi7rAiTnMQa6IvkksPvZUfYT2cgBZjTXxuH1mk1WyZsb2+/1CvClhhzhD7UWtwsKBJq3nmv/plui7Kp9K8xL2xoqjsip19u+Jz1pX9uPahdfFfrIfdJ2GMvT6wHr2x5G3zm1Icf9i++geWbU+e8RYAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f44 ?f45" svg:viewBox="0 0 0 0" draw:type="ooxml-curvedUpArrow" draw:modifiers="25000 50000 25000" draw:enhanced-path="M ?f31 0 L ?f29 ?f32 ?f25 ?f32 L ?f8 ?f46 Z S N M ?f49 ?f50 L ?f8 ?f46 Z  S N M ?f8 ?f46 L ?f8 ?f46 ?f55 ?f56 ?f28 ?f32 ?f31 0 L ?f8 ?f46 L ?f8 ?f46 F N" drawooo:enhanced-path="M ?f31 0 L ?f29 ?f32 ?f25 ?f32 G ?f8 ?f46 ?f47 ?f48 ?f8 ?f46 ?f49 ?f50 L ?f28 ?f32 Z S N M ?f8 ?f45 G ?f8 ?f46 ?f51 ?f52 L ?f4 0 G ?f8 ?f46 ?f53 ?f54 Z I S N M ?f36 ?f35 G ?f8 ?f46 ?f55 ?f56 L ?f28 ?f32 ?f31 0 ?f29 ?f32 ?f25 ?f32 G ?f8 ?f46 ?f57 ?f58 L ?f8 ?f45 G ?f8 ?f46 ?f59 ?f60 L ?f4 0 G ?f8 ?f46 ?f61 ?f62 F N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="50000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="(?f4 +?f5 )/4"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 *2/1"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 *?f9 /1"></draw:equation><draw:equation draw:name="f11" draw:formula="?f4 *?f4 /1"></draw:equation><draw:equation draw:name="f12" draw:formula="?f10 +0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="sqrt(?f12 )"></draw:equation><draw:equation draw:name="f14" draw:formula="?f13 *logheight/?f9 "></draw:equation><draw:equation draw:name="f15" draw:formula="100000*?f14 /?f0 "></draw:equation><draw:equation draw:name="f16" draw:formula="if(0-$2 ,0,if(?f15 -$2 ,$2 ,?f15 ))"></draw:equation><draw:equation draw:name="f17" draw:formula="?f0 *$2 /100000"></draw:equation><draw:equation draw:name="f18" draw:formula="?f8 +?f4 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="logheight*logheight/1"></draw:equation><draw:equation draw:name="f20" draw:formula="?f17 *?f17 /1"></draw:equation><draw:equation draw:name="f21" draw:formula="?f19 +0-?f20 "></draw:equation><draw:equation draw:name="f22" draw:formula="sqrt(?f21 )"></draw:equation><draw:equation draw:name="f23" draw:formula="?f22 *?f8 /logheight"></draw:equation><draw:equation draw:name="f24" draw:formula="?f8 +?f23 -0"></draw:equation><draw:equation draw:name="f25" draw:formula="?f18 +?f23 -0"></draw:equation><draw:equation draw:name="f26" draw:formula="?f5 +0-?f4 "></draw:equation><draw:equation draw:name="f27" draw:formula="?f26 *1/2"></draw:equation><draw:equation draw:name="f28" draw:formula="?f24 +0-?f27 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f25 +?f27 -0"></draw:equation><draw:equation draw:name="f30" draw:formula="?f5 *1/2"></draw:equation><draw:equation draw:name="f31" draw:formula="logwidth+0-?f30 "></draw:equation><draw:equation draw:name="f32" draw:formula="0+?f17 -0"></draw:equation><draw:equation draw:name="f33" draw:formula="(10800000*atan2(?f23 ,?f17 ))/pi"></draw:equation><draw:equation draw:name="f34" draw:formula="0+0-?f33 "></draw:equation><draw:equation draw:name="f35" draw:formula="0+?f14 -0"></draw:equation><draw:equation draw:name="f36" draw:formula="(?f8 +?f18 )/2"></draw:equation><draw:equation draw:name="f37" draw:formula="?f4 *1/2"></draw:equation><draw:equation draw:name="f38" draw:formula="(10800000*atan2(?f37 ,?f14 ))/pi"></draw:equation><draw:equation draw:name="f39" draw:formula="?f38 +0-?f33 "></draw:equation><draw:equation draw:name="f40" draw:formula="0+0-?f39 "></draw:equation><draw:equation draw:name="f41" draw:formula="5400000+0-?f33 "></draw:equation><draw:equation draw:name="f42" draw:formula="?f33 +?f38 -0"></draw:equation><draw:equation draw:name="f43" draw:formula="5400000+0-?f38 "></draw:equation><draw:equation draw:name="f44" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f45" draw:formula="logheight"></draw:equation><draw:equation draw:name="f46" draw:formula="logheight"></draw:equation><draw:equation draw:name="f47" draw:formula="(?f41 )/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(?f42 )/60000.0"></draw:equation><draw:equation draw:name="f49" draw:formula="(?f43 )/60000.0"></draw:equation><draw:equation draw:name="f50" draw:formula="(?f39 )/60000.0"></draw:equation><draw:equation draw:name="f51" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f52" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f53" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f54" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f55" draw:formula="(?f43 )/60000.0"></draw:equation><draw:equation draw:name="f56" draw:formula="(?f39 )/60000.0"></draw:equation><draw:equation draw:name="f57" draw:formula="(?f41 )/60000.0"></draw:equation><draw:equation draw:name="f58" draw:formula="(?f33 )/60000.0"></draw:equation><draw:equation draw:name="f59" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f60" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f61" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f62" draw:formula="(-5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f25 ?f32" draw:handle-range-x-maximum="?f2" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f28 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f44 ?f32" draw:handle-range-y-maximum="?f15" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_curvedUpArrow("ooxml-curvedUpArrow", "H4sIAAAAAAAAALVYW4+bOBT+K1bUh1yGBV8gpGoa7T5sVanty2pf+oYmkCAFSAkzk9lfvz42YQLH2e0hu4qwbGy+c/s+7PBhWycv79Nyn5SP6dbbpVWRNvUrM7eLvK6r2ttXdf5XVTbJYT3JksMpnfSmn9O6yR+Hk016brykTpPTehKwgG0ypaAJJ+z0vHv/nKcvv1VnO6d/l6dej+l6UlXn4uA9PtXP6fbP46/aysvFZLXNszytNagIgyBg0ATM9NslXSzHpNmvJ1+1Ucm1iS+6I1YwEtALbQ/uxuBXxL6zP9g3BusVLAuD/mQ32965mtSLAS6EnogvJjqr+IHf2TfrbVVVRIc/XZtVS2ji3q0r3y++fO/7HvZBQg6NTYXSdvuTEhqlIT53IBIm5BClzcC13TaQfw0jhDDC+C1DQ2x4PArcHkbgfiRMTj9+sBT48ZQ0eVVaQpRJoTmVXfiRVXXxdEjWkyIvp4dq95Jvm/2D7uzTfLdvZhrE76H8Eygfgho+zi+w/iYLGAlQDAHzbBp47zh7CB50d5NxZkZwwWBG81e64YMWnoP3dgyXHRJNqKEJyMFcF535Fo+EFt5AE6PQoiHaFAi10AxjM1+RoJZDqK7mgoQT4wCXbBF4mtM05qwwUMzmwuc0QiOZbLIVJHzFqEhIG5DrOTRUJCQKzfzAJolzWpY4UsDpR92ArgQjSt9BdC7ZvHuT+JA0GiRiu+W4ThrXWSO/TDjiu5W7eHubhMwM4TIjotg5koHR57tx8uQOMcQgT8U8IhJSQ1eWqwLRaCgc0uBLYLRuqVgOcfCVpbSgbhlIHi2lBSdSWiBxaBABEcbM79JGg3SoxJRUSGpNhWMv4GOxkDJgDzDpV8TsOxQgIjbnxH1AOLgvVMuIJdEnx16gD14Lg0TMlHSwPqSHJxHhL/uliVASOS8R54OF0SE1OsR4fQaK7Us3aZJSTA27Hgz2bOYfcxo8Yn9gw5XEcBH1Tbjk16J0HYCMhLSQZtSSOpivRjADER+XQC5NCdSYEji0IGM2qgwKaaEtJ3GfV/hvgzIBj/PKcTzSGAsTJ5EgCumh51lM9AzR/yJ6Ggxi/7i9SCH2j8RBxIe/EXqz9SNI1S/ElGP+azQxFg3RHdDkSLQQEX5q2D4SDdF+2rJrJB4i/p14tzeDkYCI/1PvPg+REu6qrms3GF/d/1QVoUsVcnSkWBV31SHCurgPDyvjPuZFWBo/zbx9Um4PKbvqe8fqlMOK9iC5eTt/tQvqpNyl3tkrknNePBVm3Y0VeWlXvNm3K37Setx9K75tmv8vps33a3fgrz3r4Y0lt823dRh+hf/4N8a7qgueFwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f44 ?f43" svg:viewBox="0 0 0 0" draw:type="ooxml-curvedDownArrow" draw:modifiers="25000 50000 25000" draw:enhanced-path="M ?f31 ?f43 L ?f28 ?f32 ?f24 ?f32 L ?f18 0 L ?f29 ?f32 Z S N M ?f36 ?f35 L 0 ?f43 Z  S N M ?f36 ?f35 L 0 ?f43 L ?f18 0 L ?f29 ?f32 ?f31 ?f43 ?f28 ?f32 ?f24 ?f32 F N" drawooo:enhanced-path="M ?f31 ?f43 L ?f28 ?f32 ?f24 ?f32 G ?f8 ?f45 ?f46 ?f47 L ?f18 0 G ?f8 ?f45 ?f48 ?f49 L ?f29 ?f32 Z S N M ?f36 ?f35 G ?f8 ?f45 ?f50 ?f51 L 0 ?f43 G ?f8 ?f45 ?f52 ?f53 Z I S N M ?f36 ?f35 G ?f8 ?f45 ?f54 ?f55 L 0 ?f43 G ?f8 ?f45 ?f56 ?f57 L ?f18 0 G ?f8 ?f45 ?f58 ?f59 L ?f29 ?f32 ?f31 ?f43 ?f28 ?f32 ?f24 ?f32 G ?f8 ?f45 ?f60 ?f61 F N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="50000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="(?f4 +?f5 )/4"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 *2/1"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 *?f9 /1"></draw:equation><draw:equation draw:name="f11" draw:formula="?f4 *?f4 /1"></draw:equation><draw:equation draw:name="f12" draw:formula="?f10 +0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="sqrt(?f12 )"></draw:equation><draw:equation draw:name="f14" draw:formula="?f13 *logheight/?f9 "></draw:equation><draw:equation draw:name="f15" draw:formula="100000*?f14 /?f0 "></draw:equation><draw:equation draw:name="f16" draw:formula="if(0-$2 ,0,if(?f15 -$2 ,$2 ,?f15 ))"></draw:equation><draw:equation draw:name="f17" draw:formula="?f0 *$2 /100000"></draw:equation><draw:equation draw:name="f18" draw:formula="?f8 +?f4 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="logheight*logheight/1"></draw:equation><draw:equation draw:name="f20" draw:formula="?f17 *?f17 /1"></draw:equation><draw:equation draw:name="f21" draw:formula="?f19 +0-?f20 "></draw:equation><draw:equation draw:name="f22" draw:formula="sqrt(?f21 )"></draw:equation><draw:equation draw:name="f23" draw:formula="?f22 *?f8 /logheight"></draw:equation><draw:equation draw:name="f24" draw:formula="?f8 +?f23 -0"></draw:equation><draw:equation draw:name="f25" draw:formula="?f18 +?f23 -0"></draw:equation><draw:equation draw:name="f26" draw:formula="?f5 +0-?f4 "></draw:equation><draw:equation draw:name="f27" draw:formula="?f26 *1/2"></draw:equation><draw:equation draw:name="f28" draw:formula="?f24 +0-?f27 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f25 +?f27 -0"></draw:equation><draw:equation draw:name="f30" draw:formula="?f5 *1/2"></draw:equation><draw:equation draw:name="f31" draw:formula="logwidth+0-?f30 "></draw:equation><draw:equation draw:name="f32" draw:formula="logheight+0-?f17 "></draw:equation><draw:equation draw:name="f33" draw:formula="(10800000*atan2(?f23 ,?f17 ))/pi"></draw:equation><draw:equation draw:name="f34" draw:formula="0+0-?f33 "></draw:equation><draw:equation draw:name="f35" draw:formula="logheight+0-?f14 "></draw:equation><draw:equation draw:name="f36" draw:formula="(?f8 +?f18 )/2"></draw:equation><draw:equation draw:name="f37" draw:formula="?f4 *1/2"></draw:equation><draw:equation draw:name="f38" draw:formula="(10800000*atan2(?f37 ,?f14 ))/pi"></draw:equation><draw:equation draw:name="f39" draw:formula="16200000+?f33 -0"></draw:equation><draw:equation draw:name="f40" draw:formula="16200000+0-?f38 "></draw:equation><draw:equation draw:name="f41" draw:formula="?f38 +0-5400000"></draw:equation><draw:equation draw:name="f42" draw:formula="5400000+?f38 -0"></draw:equation><draw:equation draw:name="f43" draw:formula="logheight"></draw:equation><draw:equation draw:name="f44" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f45" draw:formula="logheight"></draw:equation><draw:equation draw:name="f46" draw:formula="(?f39 )/60000.0"></draw:equation><draw:equation draw:name="f47" draw:formula="(?f34 )/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f49" draw:formula="(?f33 )/60000.0"></draw:equation><draw:equation draw:name="f50" draw:formula="(?f40 )/60000.0"></draw:equation><draw:equation draw:name="f51" draw:formula="(?f41 )/60000.0"></draw:equation><draw:equation draw:name="f52" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f53" draw:formula="(?f42 )/60000.0"></draw:equation><draw:equation draw:name="f54" draw:formula="(?f40 )/60000.0"></draw:equation><draw:equation draw:name="f55" draw:formula="(?f41 )/60000.0"></draw:equation><draw:equation draw:name="f56" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f57" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f58" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f59" draw:formula="(?f33 )/60000.0"></draw:equation><draw:equation draw:name="f60" draw:formula="(?f39 )/60000.0"></draw:equation><draw:equation draw:name="f61" draw:formula="(?f34 )/60000.0"></draw:equation><draw:handle draw:handle-position="?f25 ?f32" draw:handle-range-x-maximum="$1" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f28 ?f43" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f44 ?f32" draw:handle-range-y-maximum="?f15" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_curvedDownArrow("ooxml-curvedDownArrow", "H4sIAAAAAAAAALVY0W7aMBT9FQv1oVAyYscOoSpDm6ZNk7a+7K1vUUkgEknakBa6r5+vHaBwnbY37VQR7Ng59/rcc+yUq3kVby6TYhkXt8ncWyRlntTVEzO386yqyspbllX2tyzqeDXtpfFqnfSOhh+Tqs5uTwfrZFt7cZXE62nPZz6bpVLCJeix9ePi8jFLNl/LrR3Tf7unnu6Saa8st/nKu32oHpP5t3JTfNFxNrug5TxLs6TSsEL5vs/g4jPTbqbsV3MX18tp77cOG3ATm/3SXyKCGwJa0rbgLo90GmZ4Ym/esD/smpmHQ7goPepblBvWPubEOiTgCv+dXdvMy7KkJ/9Df8FNqeAC6cjxIYvjUdOavLLMo0cULEvxw/qORyERBYT8fAUGklWqDQYeUW1ZK2ipCYHQo8dDiBhyw/LnKyuQ+4e4zsrCyqWIc625dKeetKzyh1U87eVZcb4qF5tsXi+HurFMssWy7muQ0RHKS6D8FNSodbCDHc1Sn5EAxSlglp773hlnQ3+om5o/ZnrwgU6flm/ghvcbeA7Z2z58bJcYQp6GAA4Gum5sZPFIaKoFTXRCC0/RNKGSXWj5sf5IkqDGp1D7mgsSToQXOGYXvqc1TVPOBANFbCBGnCZoZJNZOgHCJ4yKhLwBXA/gQkVCptDK9y1JnNNY4sgB6/uqBl8JRrS+Q+g8YIP9TjIC0miQSO1W45o0rlkjbyYc6d3aXRx2E8VMFz6mRzQ7RzYw/jzrZk/uMEME9pTMIyIhN+zL8qxANBkKhzX4GBStr1Qshzn4xEpaUI8MZI9G0oITJS2QOTSIgBVGbLSnjQbpcIkpqQioNRWOs4B3xULOgDPA0C+J7DscIEI24MRzQDi0r993rCLGxJwcZ4FQhqkxlanAoXpFX16ABL87L80KA6LmA6T5vTztsUBkLEDK1+9Ckd184zouxLlR2dAg9/uju4wGj1zg22UHxDSRBU6WTRRv4HohMpbSxupTS+xwguygFGQEXIpgbEohu5QCeYOHwqBfmHoQ7SGRPfZwpsARrSDScS5oDI2lJP08lcglDcqFQaUuFXmk25EgkRl2WwENpt0LNByXB4KJln8IVH0ikoRMAGiyK5rDC428OgIi9Z8b1XdDU0j88P+U3xUNaR/QeFc0pP39NtIREB8ROj3RNT1kgndRh7zwLuqwI95JHTZFsxF1xPtoW6gPtUXoskXnHSV02eItO8oyLuarhD1re3flOoMZzQvh7PAe1Uyo4mKReFsvj7dZ/pBPe2e8ZUJW2AmH8HbGG4NHzW/FLwafpf8nupStS386iq5aprSHbypx+nv753/gJEnciBcAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f206 ?f208 ?f207 ?f209" svg:viewBox="0 0 0 0" draw:type="ooxml-leftCircularArrow" draw:modifiers="12500 -1142319 1142319 10800000 12500" draw:enhanced-path="M ?f63 ?f64 L ?f69 ?f70 L ?f185 ?f186 ?f57 ?f58 ?f183 ?f184 ?f126 ?f127 Z N" drawooo:enhanced-path="M ?f63 ?f64 L ?f69 ?f70 G ?f13 ?f14 ?f210 ?f211 L ?f185 ?f186 ?f57 ?f58 ?f183 ?f184 ?f126 ?f127 G ?f10 ?f12 ?f212 ?f213 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$4 ,0,if(25000-$4 ,$4 ,25000))"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *2/1"></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(1-$2 ,1,if(21599999-$2 ,$2 ,21599999))"></draw:equation><draw:equation draw:name="f4" draw:formula="if(0-$3 ,0,if(21599999-$3 ,$3 ,21599999))"></draw:equation><draw:equation draw:name="f5" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 *?f2 /100000"></draw:equation><draw:equation draw:name="f7" draw:formula="?f5 *?f0 /100000"></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 *1/2"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 +?f8 -?f7 "></draw:equation><draw:equation draw:name="f11" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f12" draw:formula="?f11 +?f8 -?f7 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f10 +0-?f6 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 +0-?f6 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f13 +?f8 -0"></draw:equation><draw:equation draw:name="f16" draw:formula="?f14 +?f8 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="?f15 *sin(pi*(?f3 )/10800000)"></draw:equation><draw:equation draw:name="f18" draw:formula="?f16 *cos(pi*(?f3 )/10800000)"></draw:equation><draw:equation draw:name="f19" draw:formula="?f15 *(cos(atan2(?f17 ,?f18 )))"></draw:equation><draw:equation draw:name="f20" draw:formula="?f16 *(sin(atan2(?f17 ,?f18 )))"></draw:equation><draw:equation draw:name="f21" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f22" draw:formula="?f21 +?f19 -0"></draw:equation><draw:equation draw:name="f23" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f24" draw:formula="?f23 +?f20 -0"></draw:equation><draw:equation draw:name="f25" draw:formula="min(?f13 ,?f14 )"></draw:equation><draw:equation draw:name="f26" draw:formula="?f19 *?f19 /1"></draw:equation><draw:equation draw:name="f27" draw:formula="?f20 *?f20 /1"></draw:equation><draw:equation draw:name="f28" draw:formula="?f25 *?f25 /1"></draw:equation><draw:equation draw:name="f29" draw:formula="?f26 +0-?f28 "></draw:equation><draw:equation draw:name="f30" draw:formula="?f27 +0-?f28 "></draw:equation><draw:equation draw:name="f31" draw:formula="?f29 *?f30 /?f26 "></draw:equation><draw:equation draw:name="f32" draw:formula="?f31 *1/?f27 "></draw:equation><draw:equation draw:name="f33" draw:formula="1+0-?f32 "></draw:equation><draw:equation draw:name="f34" draw:formula="sqrt(?f33 )"></draw:equation><draw:equation draw:name="f35" draw:formula="?f29 *1/?f19 "></draw:equation><draw:equation draw:name="f36" draw:formula="?f35 *1/?f20 "></draw:equation><draw:equation draw:name="f37" draw:formula="(1+?f34 )/?f36 "></draw:equation><draw:equation draw:name="f38" draw:formula="(10800000*atan2(?f37 ,1))/pi"></draw:equation><draw:equation draw:name="f39" draw:formula="?f38 +21600000-0"></draw:equation><draw:equation draw:name="f40" draw:formula="if(?f38 ,?f38 ,?f39 )"></draw:equation><draw:equation draw:name="f41" draw:formula="?f40 +0-?f3 "></draw:equation><draw:equation draw:name="f42" draw:formula="?f41 +21600000-0"></draw:equation><draw:equation draw:name="f43" draw:formula="if(?f41 ,?f41 ,?f42 )"></draw:equation><draw:equation draw:name="f44" draw:formula="?f43 +0-10800000"></draw:equation><draw:equation draw:name="f45" draw:formula="?f43 +0-21600000"></draw:equation><draw:equation draw:name="f46" draw:formula="if(?f44 ,?f45 ,?f43 )"></draw:equation><draw:equation draw:name="f47" draw:formula="abs(?f46 )"></draw:equation><draw:equation draw:name="f48" draw:formula="?f47 *-1/1"></draw:equation><draw:equation draw:name="f49" draw:formula="abs($1 )"></draw:equation><draw:equation draw:name="f50" draw:formula="?f49 *-1/1"></draw:equation><draw:equation draw:name="f51" draw:formula="if(?f48 -?f50 ,?f48 ,if(0-?f50 ,?f50 ,0))"></draw:equation><draw:equation draw:name="f52" draw:formula="?f3 +?f51 -0"></draw:equation><draw:equation draw:name="f53" draw:formula="?f15 *sin(pi*(?f52 )/10800000)"></draw:equation><draw:equation draw:name="f54" draw:formula="?f16 *cos(pi*(?f52 )/10800000)"></draw:equation><draw:equation draw:name="f55" draw:formula="?f15 *(cos(atan2(?f53 ,?f54 )))"></draw:equation><draw:equation draw:name="f56" draw:formula="?f16 *(sin(atan2(?f53 ,?f54 )))"></draw:equation><draw:equation draw:name="f57" draw:formula="?f21 +?f55 -0"></draw:equation><draw:equation draw:name="f58" draw:formula="?f23 +?f56 -0"></draw:equation><draw:equation draw:name="f59" draw:formula="?f10 *sin(pi*(?f4 )/10800000)"></draw:equation><draw:equation draw:name="f60" draw:formula="?f12 *cos(pi*(?f4 )/10800000)"></draw:equation><draw:equation draw:name="f61" draw:formula="?f10 *(cos(atan2(?f59 ,?f60 )))"></draw:equation><draw:equation draw:name="f62" draw:formula="?f12 *(sin(atan2(?f59 ,?f60 )))"></draw:equation><draw:equation draw:name="f63" draw:formula="?f21 +?f61 -0"></draw:equation><draw:equation draw:name="f64" draw:formula="?f23 +?f62 -0"></draw:equation><draw:equation draw:name="f65" draw:formula="?f13 *sin(pi*(?f4 )/10800000)"></draw:equation><draw:equation draw:name="f66" draw:formula="?f14 *cos(pi*(?f4 )/10800000)"></draw:equation><draw:equation draw:name="f67" draw:formula="?f13 *(cos(atan2(?f65 ,?f66 )))"></draw:equation><draw:equation draw:name="f68" draw:formula="?f14 *(sin(atan2(?f65 ,?f66 )))"></draw:equation><draw:equation draw:name="f69" draw:formula="?f21 +?f67 -0"></draw:equation><draw:equation draw:name="f70" draw:formula="?f23 +?f68 -0"></draw:equation><draw:equation draw:name="f71" draw:formula="?f7 *cos(pi*(?f52 )/10800000)"></draw:equation><draw:equation draw:name="f72" draw:formula="?f7 *sin(pi*(?f52 )/10800000)"></draw:equation><draw:equation draw:name="f73" draw:formula="?f22 +?f71 -0"></draw:equation><draw:equation draw:name="f74" draw:formula="?f24 +?f72 -0"></draw:equation><draw:equation draw:name="f75" draw:formula="?f7 *cos(pi*(?f52 )/10800000)"></draw:equation><draw:equation draw:name="f76" draw:formula="?f7 *sin(pi*(?f52 )/10800000)"></draw:equation><draw:equation draw:name="f77" draw:formula="?f22 +0-?f75 "></draw:equation><draw:equation draw:name="f78" draw:formula="?f24 +0-?f76 "></draw:equation><draw:equation draw:name="f79" draw:formula="?f77 +0-?f21 "></draw:equation><draw:equation draw:name="f80" draw:formula="?f78 +0-?f23 "></draw:equation><draw:equation draw:name="f81" draw:formula="?f73 +0-?f21 "></draw:equation><draw:equation draw:name="f82" draw:formula="?f74 +0-?f23 "></draw:equation><draw:equation draw:name="f83" draw:formula="min(?f10 ,?f12 )"></draw:equation><draw:equation draw:name="f84" draw:formula="?f79 *?f83 /?f10 "></draw:equation><draw:equation draw:name="f85" draw:formula="?f80 *?f83 /?f12 "></draw:equation><draw:equation draw:name="f86" draw:formula="?f81 *?f83 /?f10 "></draw:equation><draw:equation draw:name="f87" draw:formula="?f82 *?f83 /?f12 "></draw:equation><draw:equation draw:name="f88" draw:formula="?f86 +0-?f84 "></draw:equation><draw:equation draw:name="f89" draw:formula="?f87 +0-?f85 "></draw:equation><draw:equation draw:name="f90" draw:formula="sqrt(?f88 *?f88 +?f89 *?f89 +0*0)"></draw:equation><draw:equation draw:name="f91" draw:formula="?f84 *?f87 /1"></draw:equation><draw:equation draw:name="f92" draw:formula="?f86 *?f85 /1"></draw:equation><draw:equation draw:name="f93" draw:formula="?f91 +0-?f92 "></draw:equation><draw:equation draw:name="f94" draw:formula="?f83 *?f83 /1"></draw:equation><draw:equation draw:name="f95" draw:formula="?f90 *?f90 /1"></draw:equation><draw:equation draw:name="f96" draw:formula="?f94 *?f95 /1"></draw:equation><draw:equation draw:name="f97" draw:formula="?f93 *?f93 /1"></draw:equation><draw:equation draw:name="f98" draw:formula="?f96 +0-?f97 "></draw:equation><draw:equation draw:name="f99" draw:formula="max(?f98 ,0)"></draw:equation><draw:equation draw:name="f100" draw:formula="sqrt(?f99 )"></draw:equation><draw:equation draw:name="f101" draw:formula="?f89 *-1/1"></draw:equation><draw:equation draw:name="f102" draw:formula="if(?f101 ,-1,1)"></draw:equation><draw:equation draw:name="f103" draw:formula="?f102 *?f88 /1"></draw:equation><draw:equation draw:name="f104" draw:formula="?f103 *?f100 /1"></draw:equation><draw:equation draw:name="f105" draw:formula="?f93 *?f89 /1"></draw:equation><draw:equation draw:name="f106" draw:formula="(?f105 +?f104 )/?f95 "></draw:equation><draw:equation draw:name="f107" draw:formula="?f105 +0-?f104 "></draw:equation><draw:equation draw:name="f108" draw:formula="?f107 *1/?f95 "></draw:equation><draw:equation draw:name="f109" draw:formula="abs(?f89 )"></draw:equation><draw:equation draw:name="f110" draw:formula="?f109 *?f100 /1"></draw:equation><draw:equation draw:name="f111" draw:formula="?f93 *?f88 /-1"></draw:equation><draw:equation draw:name="f112" draw:formula="(?f111 +?f110 )/?f95 "></draw:equation><draw:equation draw:name="f113" draw:formula="?f111 +0-?f110 "></draw:equation><draw:equation draw:name="f114" draw:formula="?f113 *1/?f95 "></draw:equation><draw:equation draw:name="f115" draw:formula="?f86 +0-?f106 "></draw:equation><draw:equation draw:name="f116" draw:formula="?f86 +0-?f108 "></draw:equation><draw:equation draw:name="f117" draw:formula="?f87 +0-?f112 "></draw:equation><draw:equation draw:name="f118" draw:formula="?f87 +0-?f114 "></draw:equation><draw:equation draw:name="f119" draw:formula="sqrt(?f115 *?f115 +?f117 *?f117 +0*0)"></draw:equation><draw:equation draw:name="f120" draw:formula="sqrt(?f116 *?f116 +?f118 *?f118 +0*0)"></draw:equation><draw:equation draw:name="f121" draw:formula="?f120 +0-?f119 "></draw:equation><draw:equation draw:name="f122" draw:formula="if(?f121 ,?f106 ,?f108 )"></draw:equation><draw:equation draw:name="f123" draw:formula="if(?f121 ,?f112 ,?f114 )"></draw:equation><draw:equation draw:name="f124" draw:formula="?f122 *?f10 /?f83 "></draw:equation><draw:equation draw:name="f125" draw:formula="?f123 *?f12 /?f83 "></draw:equation><draw:equation draw:name="f126" draw:formula="?f21 +?f124 -0"></draw:equation><draw:equation draw:name="f127" draw:formula="?f23 +?f125 -0"></draw:equation><draw:equation draw:name="f128" draw:formula="?f79 *?f25 /?f13 "></draw:equation><draw:equation draw:name="f129" draw:formula="?f80 *?f25 /?f14 "></draw:equation><draw:equation draw:name="f130" draw:formula="?f81 *?f25 /?f13 "></draw:equation><draw:equation draw:name="f131" draw:formula="?f82 *?f25 /?f14 "></draw:equation><draw:equation draw:name="f132" draw:formula="?f130 +0-?f128 "></draw:equation><draw:equation draw:name="f133" draw:formula="?f131 +0-?f129 "></draw:equation><draw:equation draw:name="f134" draw:formula="sqrt(?f132 *?f132 +?f133 *?f133 +0*0)"></draw:equation><draw:equation draw:name="f135" draw:formula="?f128 *?f131 /1"></draw:equation><draw:equation draw:name="f136" draw:formula="?f130 *?f129 /1"></draw:equation><draw:equation draw:name="f137" draw:formula="?f135 +0-?f136 "></draw:equation><draw:equation draw:name="f138" draw:formula="?f25 *?f25 /1"></draw:equation><draw:equation draw:name="f139" draw:formula="?f134 *?f134 /1"></draw:equation><draw:equation draw:name="f140" draw:formula="?f138 *?f139 /1"></draw:equation><draw:equation draw:name="f141" draw:formula="?f137 *?f137 /1"></draw:equation><draw:equation draw:name="f142" draw:formula="?f140 +0-?f141 "></draw:equation><draw:equation draw:name="f143" draw:formula="max(?f142 ,0)"></draw:equation><draw:equation draw:name="f144" draw:formula="sqrt(?f143 )"></draw:equation><draw:equation draw:name="f145" draw:formula="?f102 *?f132 /1"></draw:equation><draw:equation draw:name="f146" draw:formula="?f145 *?f144 /1"></draw:equation><draw:equation draw:name="f147" draw:formula="?f137 *?f133 /1"></draw:equation><draw:equation draw:name="f148" draw:formula="(?f147 +?f146 )/?f139 "></draw:equation><draw:equation draw:name="f149" draw:formula="?f147 +0-?f146 "></draw:equation><draw:equation draw:name="f150" draw:formula="?f149 *1/?f139 "></draw:equation><draw:equation draw:name="f151" draw:formula="abs(?f133 )"></draw:equation><draw:equation draw:name="f152" draw:formula="?f151 *?f144 /1"></draw:equation><draw:equation draw:name="f153" draw:formula="?f137 *?f132 /-1"></draw:equation><draw:equation draw:name="f154" draw:formula="(?f153 +?f152 )/?f139 "></draw:equation><draw:equation draw:name="f155" draw:formula="?f153 +0-?f152 "></draw:equation><draw:equation draw:name="f156" draw:formula="?f155 *1/?f139 "></draw:equation><draw:equation draw:name="f157" draw:formula="?f128 +0-?f148 "></draw:equation><draw:equation draw:name="f158" draw:formula="?f128 +0-?f150 "></draw:equation><draw:equation draw:name="f159" draw:formula="?f129 +0-?f154 "></draw:equation><draw:equation draw:name="f160" draw:formula="?f129 +0-?f156 "></draw:equation><draw:equation draw:name="f161" draw:formula="sqrt(?f157 *?f157 +?f159 *?f159 +0*0)"></draw:equation><draw:equation draw:name="f162" draw:formula="sqrt(?f158 *?f158 +?f160 *?f160 +0*0)"></draw:equation><draw:equation draw:name="f163" draw:formula="?f162 +0-?f161 "></draw:equation><draw:equation draw:name="f164" draw:formula="if(?f163 ,?f148 ,?f150 )"></draw:equation><draw:equation draw:name="f165" draw:formula="if(?f163 ,?f154 ,?f156 )"></draw:equation><draw:equation draw:name="f166" draw:formula="?f164 *?f13 /?f25 "></draw:equation><draw:equation draw:name="f167" draw:formula="?f165 *?f14 /?f25 "></draw:equation><draw:equation draw:name="f168" draw:formula="?f21 +?f166 -0"></draw:equation><draw:equation draw:name="f169" draw:formula="?f23 +?f167 -0"></draw:equation><draw:equation draw:name="f170" draw:formula="(10800000*atan2(?f167 ,?f166 ))/pi"></draw:equation><draw:equation draw:name="f171" draw:formula="?f170 +21600000-0"></draw:equation><draw:equation draw:name="f172" draw:formula="if(?f170 ,?f170 ,?f171 )"></draw:equation><draw:equation draw:name="f173" draw:formula="?f4 +0-?f172 "></draw:equation><draw:equation draw:name="f174" draw:formula="?f173 +21600000-0"></draw:equation><draw:equation draw:name="f175" draw:formula="if(?f173 ,?f173 ,?f174 )"></draw:equation><draw:equation draw:name="f176" draw:formula="?f172 +?f175 -0"></draw:equation><draw:equation draw:name="f177" draw:formula="0+0-?f175 "></draw:equation><draw:equation draw:name="f178" draw:formula="?f126 +0-?f168 "></draw:equation><draw:equation draw:name="f179" draw:formula="?f127 +0-?f169 "></draw:equation><draw:equation draw:name="f180" draw:formula="sqrt(?f178 *?f178 +?f179 *?f179 +0*0)"></draw:equation><draw:equation draw:name="f181" draw:formula="?f180 *1/2"></draw:equation><draw:equation draw:name="f182" draw:formula="?f181 +0-?f7 "></draw:equation><draw:equation draw:name="f183" draw:formula="if(?f182 ,?f126 ,?f73 )"></draw:equation><draw:equation draw:name="f184" draw:formula="if(?f182 ,?f127 ,?f74 )"></draw:equation><draw:equation draw:name="f185" draw:formula="if(?f182 ,?f168 ,?f77 )"></draw:equation><draw:equation draw:name="f186" draw:formula="if(?f182 ,?f169 ,?f78 )"></draw:equation><draw:equation draw:name="f187" draw:formula="(10800000*atan2(?f125 ,?f124 ))/pi"></draw:equation><draw:equation draw:name="f188" draw:formula="?f187 +21600000-0"></draw:equation><draw:equation draw:name="f189" draw:formula="if(?f187 ,?f187 ,?f188 )"></draw:equation><draw:equation draw:name="f190" draw:formula="?f189 +0-?f4 "></draw:equation><draw:equation draw:name="f191" draw:formula="?f190 +0-21600000"></draw:equation><draw:equation draw:name="f192" draw:formula="if(?f190 ,?f191 ,?f190 )"></draw:equation><draw:equation draw:name="f193" draw:formula="?f4 +?f192 -0"></draw:equation><draw:equation draw:name="f194" draw:formula="0+0-?f192 "></draw:equation><draw:equation draw:name="f195" draw:formula="?f15 *sin(pi*(?f4 )/10800000)"></draw:equation><draw:equation draw:name="f196" draw:formula="?f16 *cos(pi*(?f4 )/10800000)"></draw:equation><draw:equation draw:name="f197" draw:formula="?f15 *(cos(atan2(?f195 ,?f196 )))"></draw:equation><draw:equation draw:name="f198" draw:formula="?f16 *(sin(atan2(?f195 ,?f196 )))"></draw:equation><draw:equation draw:name="f199" draw:formula="?f21 +?f197 -0"></draw:equation><draw:equation draw:name="f200" draw:formula="?f23 +?f198 -0"></draw:equation><draw:equation draw:name="f201" draw:formula="?f4 +5400000-0"></draw:equation><draw:equation draw:name="f202" draw:formula="?f52 +0-5400000"></draw:equation><draw:equation draw:name="f203" draw:formula="?f52 +10800000-0"></draw:equation><draw:equation draw:name="f204" draw:formula="?f10 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f205" draw:formula="?f12 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f206" draw:formula="?f21 +0-?f204 "></draw:equation><draw:equation draw:name="f207" draw:formula="?f21 +?f204 -0"></draw:equation><draw:equation draw:name="f208" draw:formula="?f23 +0-?f205 "></draw:equation><draw:equation draw:name="f209" draw:formula="?f23 +?f205 -0"></draw:equation><draw:equation draw:name="f210" draw:formula="(?f176 )/60000.0"></draw:equation><draw:equation draw:name="f211" draw:formula="(?f177 )/60000.0"></draw:equation><draw:equation draw:name="f212" draw:formula="(?f193 )/60000.0"></draw:equation><draw:equation draw:name="f213" draw:formula="(?f194 )/60000.0"></draw:equation><draw:handle draw:handle-position="?f57 ?f58"></draw:handle><draw:handle draw:handle-position="?f63 ?f64"></draw:handle><draw:handle draw:handle-position="?f126 ?f127" draw:handle-radius-range-maximum="?f1" draw:handle-radius-range-minimum="0"></draw:handle><draw:handle draw:handle-position="?f77 ?f78" draw:handle-radius-range-maximum="25000" draw:handle-radius-range-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_leftCircularArrow("ooxml-leftCircularArrow", "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"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f193 ?f195 ?f194 ?f196" svg:viewBox="0 0 0 0" draw:type="ooxml-circularArrow" draw:modifiers="12500 1142319 20457681 10800000 12500" draw:enhanced-path="M ?f60 ?f61 L ?f172 ?f173 ?f54 ?f55 ?f174 ?f175 ?f159 ?f160 Z N" drawooo:enhanced-path="M ?f60 ?f61 G ?f10 ?f12 ?f197 ?f198 L ?f172 ?f173 ?f54 ?f55 ?f174 ?f175 ?f159 ?f160 G ?f13 ?f14 ?f199 ?f200 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$4 ,0,if(25000-$4 ,$4 ,25000))"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *2/1"></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(1-$2 ,1,if(21599999-$2 ,$2 ,21599999))"></draw:equation><draw:equation draw:name="f4" draw:formula="if(0-$3 ,0,if(21599999-$3 ,$3 ,21599999))"></draw:equation><draw:equation draw:name="f5" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 *?f2 /100000"></draw:equation><draw:equation draw:name="f7" draw:formula="?f5 *?f0 /100000"></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 *1/2"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 +?f8 -?f7 "></draw:equation><draw:equation draw:name="f11" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f12" draw:formula="?f11 +?f8 -?f7 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f10 +0-?f6 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 +0-?f6 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f13 +?f8 -0"></draw:equation><draw:equation draw:name="f16" draw:formula="?f14 +?f8 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="?f15 *sin(pi*(?f3 )/10800000)"></draw:equation><draw:equation draw:name="f18" draw:formula="?f16 *cos(pi*(?f3 )/10800000)"></draw:equation><draw:equation draw:name="f19" draw:formula="?f15 *(cos(atan2(?f17 ,?f18 )))"></draw:equation><draw:equation draw:name="f20" draw:formula="?f16 *(sin(atan2(?f17 ,?f18 )))"></draw:equation><draw:equation draw:name="f21" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f22" draw:formula="?f21 +?f19 -0"></draw:equation><draw:equation draw:name="f23" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f24" draw:formula="?f23 +?f20 -0"></draw:equation><draw:equation draw:name="f25" draw:formula="min(?f13 ,?f14 )"></draw:equation><draw:equation draw:name="f26" draw:formula="?f19 *?f19 /1"></draw:equation><draw:equation draw:name="f27" draw:formula="?f20 *?f20 /1"></draw:equation><draw:equation draw:name="f28" draw:formula="?f25 *?f25 /1"></draw:equation><draw:equation draw:name="f29" draw:formula="?f26 +0-?f28 "></draw:equation><draw:equation draw:name="f30" draw:formula="?f27 +0-?f28 "></draw:equation><draw:equation draw:name="f31" draw:formula="?f29 *?f30 /?f26 "></draw:equation><draw:equation draw:name="f32" draw:formula="?f31 *1/?f27 "></draw:equation><draw:equation draw:name="f33" draw:formula="1+0-?f32 "></draw:equation><draw:equation draw:name="f34" draw:formula="sqrt(?f33 )"></draw:equation><draw:equation draw:name="f35" draw:formula="?f29 *1/?f19 "></draw:equation><draw:equation draw:name="f36" draw:formula="?f35 *1/?f20 "></draw:equation><draw:equation draw:name="f37" draw:formula="(1+?f34 )/?f36 "></draw:equation><draw:equation draw:name="f38" draw:formula="(10800000*atan2(?f37 ,1))/pi"></draw:equation><draw:equation draw:name="f39" draw:formula="?f38 +21600000-0"></draw:equation><draw:equation draw:name="f40" draw:formula="if(?f38 ,?f38 ,?f39 )"></draw:equation><draw:equation draw:name="f41" draw:formula="?f40 +0-?f3 "></draw:equation><draw:equation draw:name="f42" draw:formula="?f41 +21600000-0"></draw:equation><draw:equation draw:name="f43" draw:formula="if(?f41 ,?f41 ,?f42 )"></draw:equation><draw:equation draw:name="f44" draw:formula="?f43 +0-10800000"></draw:equation><draw:equation draw:name="f45" draw:formula="?f43 +0-21600000"></draw:equation><draw:equation draw:name="f46" draw:formula="if(?f44 ,?f45 ,?f43 )"></draw:equation><draw:equation draw:name="f47" draw:formula="abs(?f46 )"></draw:equation><draw:equation draw:name="f48" draw:formula="if(0-$1 ,0,if(?f47 -$1 ,$1 ,?f47 ))"></draw:equation><draw:equation draw:name="f49" draw:formula="?f3 +?f48 -0"></draw:equation><draw:equation draw:name="f50" draw:formula="?f15 *sin(pi*(?f49 )/10800000)"></draw:equation><draw:equation draw:name="f51" draw:formula="?f16 *cos(pi*(?f49 )/10800000)"></draw:equation><draw:equation draw:name="f52" draw:formula="?f15 *(cos(atan2(?f50 ,?f51 )))"></draw:equation><draw:equation draw:name="f53" draw:formula="?f16 *(sin(atan2(?f50 ,?f51 )))"></draw:equation><draw:equation draw:name="f54" draw:formula="?f21 +?f52 -0"></draw:equation><draw:equation draw:name="f55" draw:formula="?f23 +?f53 -0"></draw:equation><draw:equation draw:name="f56" draw:formula="?f10 *sin(pi*(?f4 )/10800000)"></draw:equation><draw:equation draw:name="f57" draw:formula="?f12 *cos(pi*(?f4 )/10800000)"></draw:equation><draw:equation draw:name="f58" draw:formula="?f10 *(cos(atan2(?f56 ,?f57 )))"></draw:equation><draw:equation draw:name="f59" draw:formula="?f12 *(sin(atan2(?f56 ,?f57 )))"></draw:equation><draw:equation draw:name="f60" draw:formula="?f21 +?f58 -0"></draw:equation><draw:equation draw:name="f61" draw:formula="?f23 +?f59 -0"></draw:equation><draw:equation draw:name="f62" draw:formula="?f7 *cos(pi*(?f49 )/10800000)"></draw:equation><draw:equation draw:name="f63" draw:formula="?f7 *sin(pi*(?f49 )/10800000)"></draw:equation><draw:equation draw:name="f64" draw:formula="?f22 +?f62 -0"></draw:equation><draw:equation draw:name="f65" draw:formula="?f24 +?f63 -0"></draw:equation><draw:equation draw:name="f66" draw:formula="?f7 *cos(pi*(?f49 )/10800000)"></draw:equation><draw:equation draw:name="f67" draw:formula="?f7 *sin(pi*(?f49 )/10800000)"></draw:equation><draw:equation draw:name="f68" draw:formula="?f22 +0-?f66 "></draw:equation><draw:equation draw:name="f69" draw:formula="?f24 +0-?f67 "></draw:equation><draw:equation draw:name="f70" draw:formula="?f68 +0-?f21 "></draw:equation><draw:equation draw:name="f71" draw:formula="?f69 +0-?f23 "></draw:equation><draw:equation draw:name="f72" draw:formula="?f64 +0-?f21 "></draw:equation><draw:equation draw:name="f73" draw:formula="?f65 +0-?f23 "></draw:equation><draw:equation draw:name="f74" draw:formula="min(?f10 ,?f12 )"></draw:equation><draw:equation draw:name="f75" draw:formula="?f70 *?f74 /?f10 "></draw:equation><draw:equation draw:name="f76" draw:formula="?f71 *?f74 /?f12 "></draw:equation><draw:equation draw:name="f77" draw:formula="?f72 *?f74 /?f10 "></draw:equation><draw:equation draw:name="f78" draw:formula="?f73 *?f74 /?f12 "></draw:equation><draw:equation draw:name="f79" draw:formula="?f77 +0-?f75 "></draw:equation><draw:equation draw:name="f80" draw:formula="?f78 +0-?f76 "></draw:equation><draw:equation draw:name="f81" draw:formula="sqrt(?f79 *?f79 +?f80 *?f80 +0*0)"></draw:equation><draw:equation draw:name="f82" draw:formula="?f75 *?f78 /1"></draw:equation><draw:equation draw:name="f83" draw:formula="?f77 *?f76 /1"></draw:equation><draw:equation draw:name="f84" draw:formula="?f82 +0-?f83 "></draw:equation><draw:equation draw:name="f85" draw:formula="?f74 *?f74 /1"></draw:equation><draw:equation draw:name="f86" draw:formula="?f81 *?f81 /1"></draw:equation><draw:equation draw:name="f87" draw:formula="?f85 *?f86 /1"></draw:equation><draw:equation draw:name="f88" draw:formula="?f84 *?f84 /1"></draw:equation><draw:equation draw:name="f89" draw:formula="?f87 +0-?f88 "></draw:equation><draw:equation draw:name="f90" draw:formula="max(?f89 ,0)"></draw:equation><draw:equation draw:name="f91" draw:formula="sqrt(?f90 )"></draw:equation><draw:equation draw:name="f92" draw:formula="?f80 *-1/1"></draw:equation><draw:equation draw:name="f93" draw:formula="if(?f92 ,-1,1)"></draw:equation><draw:equation draw:name="f94" draw:formula="?f93 *?f79 /1"></draw:equation><draw:equation draw:name="f95" draw:formula="?f94 *?f91 /1"></draw:equation><draw:equation draw:name="f96" draw:formula="?f84 *?f80 /1"></draw:equation><draw:equation draw:name="f97" draw:formula="(?f96 +?f95 )/?f86 "></draw:equation><draw:equation draw:name="f98" draw:formula="?f96 +0-?f95 "></draw:equation><draw:equation draw:name="f99" draw:formula="?f98 *1/?f86 "></draw:equation><draw:equation draw:name="f100" draw:formula="abs(?f80 )"></draw:equation><draw:equation draw:name="f101" draw:formula="?f100 *?f91 /1"></draw:equation><draw:equation draw:name="f102" draw:formula="?f84 *?f79 /-1"></draw:equation><draw:equation draw:name="f103" draw:formula="(?f102 +?f101 )/?f86 "></draw:equation><draw:equation draw:name="f104" draw:formula="?f102 +0-?f101 "></draw:equation><draw:equation draw:name="f105" draw:formula="?f104 *1/?f86 "></draw:equation><draw:equation draw:name="f106" draw:formula="?f77 +0-?f97 "></draw:equation><draw:equation draw:name="f107" draw:formula="?f77 +0-?f99 "></draw:equation><draw:equation draw:name="f108" draw:formula="?f78 +0-?f103 "></draw:equation><draw:equation draw:name="f109" draw:formula="?f78 +0-?f105 "></draw:equation><draw:equation draw:name="f110" draw:formula="sqrt(?f106 *?f106 +?f108 *?f108 +0*0)"></draw:equation><draw:equation draw:name="f111" draw:formula="sqrt(?f107 *?f107 +?f109 *?f109 +0*0)"></draw:equation><draw:equation draw:name="f112" draw:formula="?f111 +0-?f110 "></draw:equation><draw:equation draw:name="f113" draw:formula="if(?f112 ,?f97 ,?f99 )"></draw:equation><draw:equation draw:name="f114" draw:formula="if(?f112 ,?f103 ,?f105 )"></draw:equation><draw:equation draw:name="f115" draw:formula="?f113 *?f10 /?f74 "></draw:equation><draw:equation draw:name="f116" draw:formula="?f114 *?f12 /?f74 "></draw:equation><draw:equation draw:name="f117" draw:formula="?f21 +?f115 -0"></draw:equation><draw:equation draw:name="f118" draw:formula="?f23 +?f116 -0"></draw:equation><draw:equation draw:name="f119" draw:formula="?f70 *?f25 /?f13 "></draw:equation><draw:equation draw:name="f120" draw:formula="?f71 *?f25 /?f14 "></draw:equation><draw:equation draw:name="f121" draw:formula="?f72 *?f25 /?f13 "></draw:equation><draw:equation draw:name="f122" draw:formula="?f73 *?f25 /?f14 "></draw:equation><draw:equation draw:name="f123" draw:formula="?f121 +0-?f119 "></draw:equation><draw:equation draw:name="f124" draw:formula="?f122 +0-?f120 "></draw:equation><draw:equation draw:name="f125" draw:formula="sqrt(?f123 *?f123 +?f124 *?f124 +0*0)"></draw:equation><draw:equation draw:name="f126" draw:formula="?f119 *?f122 /1"></draw:equation><draw:equation draw:name="f127" draw:formula="?f121 *?f120 /1"></draw:equation><draw:equation draw:name="f128" draw:formula="?f126 +0-?f127 "></draw:equation><draw:equation draw:name="f129" draw:formula="?f25 *?f25 /1"></draw:equation><draw:equation draw:name="f130" draw:formula="?f125 *?f125 /1"></draw:equation><draw:equation draw:name="f131" draw:formula="?f129 *?f130 /1"></draw:equation><draw:equation draw:name="f132" draw:formula="?f128 *?f128 /1"></draw:equation><draw:equation draw:name="f133" draw:formula="?f131 +0-?f132 "></draw:equation><draw:equation draw:name="f134" draw:formula="max(?f133 ,0)"></draw:equation><draw:equation draw:name="f135" draw:formula="sqrt(?f134 )"></draw:equation><draw:equation draw:name="f136" draw:formula="?f93 *?f123 /1"></draw:equation><draw:equation draw:name="f137" draw:formula="?f136 *?f135 /1"></draw:equation><draw:equation draw:name="f138" draw:formula="?f128 *?f124 /1"></draw:equation><draw:equation draw:name="f139" draw:formula="(?f138 +?f137 )/?f130 "></draw:equation><draw:equation draw:name="f140" draw:formula="?f138 +0-?f137 "></draw:equation><draw:equation draw:name="f141" draw:formula="?f140 *1/?f130 "></draw:equation><draw:equation draw:name="f142" draw:formula="abs(?f124 )"></draw:equation><draw:equation draw:name="f143" draw:formula="?f142 *?f135 /1"></draw:equation><draw:equation draw:name="f144" draw:formula="?f128 *?f123 /-1"></draw:equation><draw:equation draw:name="f145" draw:formula="(?f144 +?f143 )/?f130 "></draw:equation><draw:equation draw:name="f146" draw:formula="?f144 +0-?f143 "></draw:equation><draw:equation draw:name="f147" draw:formula="?f146 *1/?f130 "></draw:equation><draw:equation draw:name="f148" draw:formula="?f119 +0-?f139 "></draw:equation><draw:equation draw:name="f149" draw:formula="?f119 +0-?f141 "></draw:equation><draw:equation draw:name="f150" draw:formula="?f120 +0-?f145 "></draw:equation><draw:equation draw:name="f151" draw:formula="?f120 +0-?f147 "></draw:equation><draw:equation draw:name="f152" draw:formula="sqrt(?f148 *?f148 +?f150 *?f150 +0*0)"></draw:equation><draw:equation draw:name="f153" draw:formula="sqrt(?f149 *?f149 +?f151 *?f151 +0*0)"></draw:equation><draw:equation draw:name="f154" draw:formula="?f153 +0-?f152 "></draw:equation><draw:equation draw:name="f155" draw:formula="if(?f154 ,?f139 ,?f141 )"></draw:equation><draw:equation draw:name="f156" draw:formula="if(?f154 ,?f145 ,?f147 )"></draw:equation><draw:equation draw:name="f157" draw:formula="?f155 *?f13 /?f25 "></draw:equation><draw:equation draw:name="f158" draw:formula="?f156 *?f14 /?f25 "></draw:equation><draw:equation draw:name="f159" draw:formula="?f21 +?f157 -0"></draw:equation><draw:equation draw:name="f160" draw:formula="?f23 +?f158 -0"></draw:equation><draw:equation draw:name="f161" draw:formula="(10800000*atan2(?f158 ,?f157 ))/pi"></draw:equation><draw:equation draw:name="f162" draw:formula="?f161 +21600000-0"></draw:equation><draw:equation draw:name="f163" draw:formula="if(?f161 ,?f161 ,?f162 )"></draw:equation><draw:equation draw:name="f164" draw:formula="?f4 +0-?f163 "></draw:equation><draw:equation draw:name="f165" draw:formula="?f164 +0-21600000"></draw:equation><draw:equation draw:name="f166" draw:formula="if(?f164 ,?f165 ,?f164 )"></draw:equation><draw:equation draw:name="f167" draw:formula="?f117 +0-?f159 "></draw:equation><draw:equation draw:name="f168" draw:formula="?f118 +0-?f160 "></draw:equation><draw:equation draw:name="f169" draw:formula="sqrt(?f167 *?f167 +?f168 *?f168 +0*0)"></draw:equation><draw:equation draw:name="f170" draw:formula="?f169 *1/2"></draw:equation><draw:equation draw:name="f171" draw:formula="?f170 +0-?f7 "></draw:equation><draw:equation draw:name="f172" draw:formula="if(?f171 ,?f117 ,?f64 )"></draw:equation><draw:equation draw:name="f173" draw:formula="if(?f171 ,?f118 ,?f65 )"></draw:equation><draw:equation draw:name="f174" draw:formula="if(?f171 ,?f159 ,?f68 )"></draw:equation><draw:equation draw:name="f175" draw:formula="if(?f171 ,?f160 ,?f69 )"></draw:equation><draw:equation draw:name="f176" draw:formula="(10800000*atan2(?f116 ,?f115 ))/pi"></draw:equation><draw:equation draw:name="f177" draw:formula="?f176 +21600000-0"></draw:equation><draw:equation draw:name="f178" draw:formula="if(?f176 ,?f176 ,?f177 )"></draw:equation><draw:equation draw:name="f179" draw:formula="?f178 +0-?f4 "></draw:equation><draw:equation draw:name="f180" draw:formula="?f179 +21600000-0"></draw:equation><draw:equation draw:name="f181" draw:formula="if(?f179 ,?f179 ,?f180 )"></draw:equation><draw:equation draw:name="f182" draw:formula="?f15 *sin(pi*(?f4 )/10800000)"></draw:equation><draw:equation draw:name="f183" draw:formula="?f16 *cos(pi*(?f4 )/10800000)"></draw:equation><draw:equation draw:name="f184" draw:formula="?f15 *(cos(atan2(?f182 ,?f183 )))"></draw:equation><draw:equation draw:name="f185" draw:formula="?f16 *(sin(atan2(?f182 ,?f183 )))"></draw:equation><draw:equation draw:name="f186" draw:formula="?f21 +?f184 -0"></draw:equation><draw:equation draw:name="f187" draw:formula="?f23 +?f185 -0"></draw:equation><draw:equation draw:name="f188" draw:formula="?f4 +0-5400000"></draw:equation><draw:equation draw:name="f189" draw:formula="?f49 +5400000-0"></draw:equation><draw:equation draw:name="f190" draw:formula="?f49 +10800000-0"></draw:equation><draw:equation draw:name="f191" draw:formula="?f10 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f192" draw:formula="?f12 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f193" draw:formula="?f21 +0-?f191 "></draw:equation><draw:equation draw:name="f194" draw:formula="?f21 +?f191 -0"></draw:equation><draw:equation draw:name="f195" draw:formula="?f23 +0-?f192 "></draw:equation><draw:equation draw:name="f196" draw:formula="?f23 +?f192 -0"></draw:equation><draw:equation draw:name="f197" draw:formula="(?f4 )/60000.0"></draw:equation><draw:equation draw:name="f198" draw:formula="(?f181 )/60000.0"></draw:equation><draw:equation draw:name="f199" draw:formula="(?f163 )/60000.0"></draw:equation><draw:equation draw:name="f200" draw:formula="(?f166 )/60000.0"></draw:equation><draw:handle draw:handle-position="?f54 ?f55"></draw:handle><draw:handle draw:handle-position="?f60 ?f61"></draw:handle><draw:handle draw:handle-position="?f117 ?f118" draw:handle-radius-range-maximum="?f1" draw:handle-radius-range-minimum="0"></draw:handle><draw:handle draw:handle-position="?f68 ?f69" draw:handle-radius-range-maximum="25000" draw:handle-radius-range-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_circularArrow("ooxml-circularArrow", "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"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f4 ?f9 ?f13 ?f10" svg:viewBox="0 0 0 0" draw:type="ooxml-stripedRightArrow" draw:modifiers="50000 50000" draw:enhanced-path="M 0 ?f9 L ?f16 ?f9 ?f16 ?f10 0 ?f10 Z M ?f17 ?f9 L ?f18 ?f9 ?f18 ?f10 ?f17 ?f10 Z M ?f4 ?f9 L ?f6 ?f9 ?f6 0 ?f15 ?f8 ?f6 ?f14 ?f6 ?f10 ?f4 ?f10 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="84375*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *5/32"></draw:equation><draw:equation draw:name="f5" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="logheight*?f2 /200000"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 +0-?f7 "></draw:equation><draw:equation draw:name="f10" draw:formula="?f8 +?f7 -0"></draw:equation><draw:equation draw:name="f11" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f12" draw:formula="?f7 *?f5 /?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="logwidth+0-?f12 "></draw:equation><draw:equation draw:name="f14" draw:formula="logheight"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f16" draw:formula="min(logwidth,logheight)/32"></draw:equation><draw:equation draw:name="f17" draw:formula="min(logwidth,logheight)/16"></draw:equation><draw:equation draw:name="f18" draw:formula="min(logwidth,logheight)/8"></draw:equation><draw:handle draw:handle-position="0 ?f9" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f6 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_stripedRightArrow("ooxml-stripedRightArrow", "H4sIAAAAAAAAAJ2WUZObIBCA/wrD9OEuDaNoTLyb85z2udeHPvaNOVGZUUnRJKa/viBiLqKd0mQg4C7f7sKu5CUT5PJMm5I07zRDBeU17cQVDI9rJgQXqOSC/eZNR6oE5qRqKbwTn6no2Ptc2NG+Q0RQ0iYwzXcgzZ9kw6HqfAjac/F8ZvTylfcJ9MHwNSuvR5pAzvu6Qm0n2JFmP1hRdl+ktYsxzTOWMyokPPLlBwz9KJyiOZKuTOCbZCvr35TpvXFkPzgyiOTPT/CmBoebYmwUY60xSifd3aRqkHsNi2QXj4/xzgz8ccmw/jt8fdGe/jqRjvFG+92QWgaemzByLupTRRJYs+ah4sWFZV25lYOSqu14lBDvjvI3KJ5D4114iDYG66W5D5yAwRzI8gcfffLB1t/KIVbnoeeq6emjm8/hsgk8mpCbCYaZamriiN/N8WoPNpEXBk6YaBGT5iHwdNROtP2cZk7os4/SPHI7o8MCTCeP9C8AXuDuX7yK9Ny27cnethgMQR7cgsRWvQwkxUFusWGrSP43OGxVh3Jnow5QVhrGjhFahXCXFDhwxFmJP4XpxrEy37jlhrFSfuV951qY2Er/NbB0wQlsFcEaOF7jygsqqyj4MEZH3jKloa7DdCqPUShIU1B0RTXpWX2qEzi+WpaVWKOVbumvNf7F+HCPLXH7m/F0uk7mGuuWveU/Gq9/APifb1OBCAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f11 ?f8 ?f12 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-notchedRightArrow" draw:modifiers="50000 50000" draw:enhanced-path="M 0 ?f8 L ?f5 ?f8 ?f5 0 ?f13 ?f7 ?f5 ?f14 ?f5 ?f9 0 ?f9 ?f11 ?f7 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="100000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$1 ,0,if(?f1 -$1 ,$1 ,?f1 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 *?f3 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth+0-?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="logheight*?f2 /200000"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f6 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f6 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f6 *?f4 /?f10 "></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth+0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f14" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f13 ?f8" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f5 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_notchedRightArrow("ooxml-notchedRightArrow", "H4sIAAAAAAAAAJ2VzW7jIBCAXwWhPbTZIBsnbpqqrtWed3vosTcUg41kIEtI4vTpC9hOG9tZLZsIBMzkmx+YyWOhyfGByorIDS1QSZWgRp+APxZca6VRpTT/UNKQOoOM1DsKL8QHqg3fDIWGNgYRTckugznDGOTs3g6c2GkNwe5QPhw4Pb6oJoMx8N/+l6ctzaBSjaiRVGZT0eKNl5V5ttaOvWlVcMaptvA0th/g5054jmZLTJXB35btjP+yc9q5kfozvLDTqjvGy26x9rI16LxegXfwCp8eW/SfPTFcydaQJMJ6ynq7TGmxr0kGBZc3tSqPvDDV3C4q6vy/tZDogvI3KB5CsYswnvXcKGcxCCImQyJnNzH6EYN5PLfLlu/3brTb2zCnF9MmcGfCZhT4nRtuE4hfDvEuB7OcLUDUuhtES4e0PrU/Y5SzZVhy7yZg7bVb/xIQJeH+ra4ioyQIdD9O2wr4IO/CglxPghwGhYWGRyXzv7HhUZ04d2bu/myF4MASwaMauXgTth+E4Ub10OPCMKN3f87WNY5tgEVNwbc12qoddxq+HbvG1z+LTq6JLCk6IUEaLvaibzhXlLhslb7uvdX4N/spmOQ2X8bzcwMcaly3HE3/lz19AvWzZzHkBgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f5 ?f8" svg:viewBox="0 0 0 0" draw:type="ooxml-homePlate" draw:modifiers="50000" draw:enhanced-path="M 0 0 L ?f4 0 ?f9 ?f7 ?f4 ?f8 0 ?f8 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="100000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth+0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="(?f4 +logwidth)/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f4 *1/2"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f4 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_homePlate("ooxml-homePlate", "H4sIAAAAAAAAAJWUW2+DIBSA/wohe+iNiL2sl9Sa7Hlb9rw3UkFJBDqkrd2vH0rtVjaXoDnJufGdcxDcZpqcN1QWRO5phnKqBDX6Alq34ForjQql+aeShpQJZKSsKLwLn6g2fO8HDa0NIpqSKoEYYJCyhZUVBNUp35w4PT+p2kXs2625HGgClapFaYsK+lYScyumMs441Ra3wPa5um+dH4gpEvjS8p5tpXlbc21l2Vq2dutZgXfwCndbt/rjSAxX0rEkEbY869BMaXEsSQIFl4NS5WeemWJilYLyvDBDC4nuKP9BYx8aN0PgUceNUoZBEHHqEzkbYPSAwQRPrJqyGLRWI40xDGt45uObBkcpm4LItR5Em/u0bu4xRimbhU2+8GGD5gOPO+QwmgbhHn9POgejOJCy/GNCd1ACQateUBBm3bfjfRR7j7KSgh86OqiKNxluS7p7cQ1qInOKaiRIzcVRNDlxTwaXLuP7zLiMWyf+72f3BbtyiMKXBAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f7 0 ?f8 ?f10" svg:viewBox="0 0 0 0" draw:type="ooxml-chevron" draw:modifiers="50000" draw:enhanced-path="M 0 0 L ?f4 0 ?f11 ?f9 ?f4 ?f10 0 ?f10 ?f3 ?f9 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f1" draw:formula="100000*logwidth/?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="?f0 *?f2 /100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth+0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 *1/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f4 +0-?f3 "></draw:equation><draw:equation draw:name="f7" draw:formula="if(?f6 ,?f3 ,0)"></draw:equation><draw:equation draw:name="f8" draw:formula="if(?f6 ,?f4 ,logwidth)"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f4 0" draw:handle-range-x-maximum="?f1" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_chevron("ooxml-chevron", "H4sIAAAAAAAAAJ2U3W6DIBTHX4WQXbSdROx3m1qTXW97gN2RCkoi0CG1dk8/0Nqttl3CNBA+jr/zP+eAm1ST45rKnMgdTVFGlaBGn0CzLLjWSqNcaf6lpCFFDBkpSgqvtiuqDd/1Nw2tDSKakjKGCVsADBK2tC3CEJRVtq44Pb6oOoYYNG/32WlPY6hULQq0y2mlley8qZQzTrXlzbB9zssX6Xti8hi+NbRX62jauIwi262aqfPdrrlu0qx/gHe43bSgzwMxXMkWK4mwOljnhSktDgWJoeByUKjsyFOTB3aQU57lZmgh4RXlL2jUh0YuHjzquGHCMPAijvtEzgYYPWEQ4MAObcigmbnmJkM/wZM+3gkcJWwMwla6F23ap3VxP2Pk6uIFm91Km4JRFI69KPN7lP/IWdwpRMLmLusTWwy/tC8fw6Yg6LLmx1zdSX57hj1TFt1cjQvJj3NzG7rAHmHsfU8LCn6N0V6V3Fm0heuUnTc1kRlFNRKk5uIgnE30wILL1uLnQLcWFyX9/+T2G2jpq9dABQAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 0 ?f31 ?f30" svg:viewBox="0 0 0 0" draw:type="ooxml-swooshArrow" draw:modifiers="25000 16667" draw:enhanced-path="M 0 ?f30 Q ?f25 ?f23 ?f6 ?f8 L ?f11 0 ?f31 ?f20 ?f15 ?f16 ?f14 ?f13 Q ?f29 ?f27 0 ?f30 Z N"><draw:equation draw:name="f0" draw:formula="if(1-$0 ,1,if(75000-$0 ,$0 ,75000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="70000*logwidth/?f1 "></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$1 ,0,if(?f2 -$1 ,$1 ,?f2 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="?f1 *?f3 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth+0-?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="min(logwidth,logheight)/8"></draw:equation><draw:equation draw:name="f8" draw:formula="0+?f7 -0"></draw:equation><draw:equation draw:name="f9" draw:formula="5400000*1/14"></draw:equation><draw:equation draw:name="f10" draw:formula="?f7 *tan(pi*(?f9 )/10800000)"></draw:equation><draw:equation draw:name="f11" draw:formula="?f6 +0-?f10 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f4 *tan(pi*(?f9 )/10800000)"></draw:equation><draw:equation draw:name="f13" draw:formula="?f8 +?f4 -0"></draw:equation><draw:equation draw:name="f14" draw:formula="?f6 +?f12 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="?f14 +?f10 -0"></draw:equation><draw:equation draw:name="f16" draw:formula="?f13 +?f7 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="?f16 +0-0"></draw:equation><draw:equation draw:name="f18" draw:formula="?f17 *1/2"></draw:equation><draw:equation draw:name="f19" draw:formula="logheight*1/20"></draw:equation><draw:equation draw:name="f20" draw:formula="0+?f18 -?f19 "></draw:equation><draw:equation draw:name="f21" draw:formula="logheight/6"></draw:equation><draw:equation draw:name="f22" draw:formula="?f21 *1/1"></draw:equation><draw:equation draw:name="f23" draw:formula="?f21 +?f22 -0"></draw:equation><draw:equation draw:name="f24" draw:formula="logwidth/6"></draw:equation><draw:equation draw:name="f25" draw:formula="?f24 "></draw:equation><draw:equation draw:name="f26" draw:formula="?f21 *1/2"></draw:equation><draw:equation draw:name="f27" draw:formula="?f13 +?f26 -0"></draw:equation><draw:equation draw:name="f28" draw:formula="logwidth/4"></draw:equation><draw:equation draw:name="f29" draw:formula="?f28 "></draw:equation><draw:equation draw:name="f30" draw:formula="logheight"></draw:equation><draw:equation draw:name="f31" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f14 ?f13" draw:handle-range-y-maximum="75000" draw:handle-range-y-minimum="1"></draw:handle><draw:handle draw:handle-position="?f6 ?f8" draw:handle-range-x-maximum="?f2" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_swooshArrow("ooxml-swooshArrow", "H4sIAAAAAAAAAK1W246bMBD9FQv1IckGYTsEyGqzqH1uK/W1b9bGBEuAUyC3fn3HJpAuZqudVRXh2PHkzMXnDH7a1eL8KKtcVC9y5++lLmVbX4n9uVR1rWs/17X6ratWFFsvE0UjvVfbJ1m36mW82cpL64taimbrUUJJmq2YGahHmtP+8aTk+Yu+dHvw6f91Pcitp/WlLPzmrHWTfwYf596h3qlMyRog+ZpSSlgURfFtc8jhINp8633rfFLyA7742gwrGCJ4EvIVRsbuUXEzY8aIGQMWmmHV/XVjhrhH+0m+e89PncNfR9EqXXXuK1FC5FmfSKbr8liIraeyGfM/UbJkS5jGJmy7NI9dzecAGLxC/JcDNnZQqmpW6P1Z7dp8CZNcqn3e4kD5GDSGwOiihw2gGgQFuJooA+TNyJKaMkBFiV2ZxyyQRQjH8EPeizSjJGAmfIqCXI8hTc6AtvoQWjQRoC3lA/XTbI0rZvzOIw8SFGwyhqUPaRYTH5fpZoyyDm25FixgIY7ZjnZMOItWVLODWgBnNmQOZ5FYeKRoHNWYTmDPglHcYTBHK2kW/qcoHdWYXvVg8JGHwhyB2HwhW46GmhJGaLEoGsuRhW2zH6Edc0RhezccKRLHUQHgAOtYwHE4jg7uLQmwcEFxRwlGmiwhhq8bHF+5Q/0hsCDCIU0wnzNTKobDmaA54ECGHM1OPvUm6N5ZyOQmaM5DZKkn6N0VCMclPsVtKxMeoQvk8HsoEK47c4fgEE6CvBU4vB64iMOZ4rRN6i0YuBruCkn+mvsH3ShjcWto6b393gxqUe2lf/VLcVHlsYRLkbmuvWGjqs7mLoXO4n3+7a10Cvly954Ot7SxRe+bOr5vtRjf7p//AJPMySr2CwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="1 1" draw:text-areas="0 0 ?f3 ?f2" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartProcess" draw:enhanced-path="M 0 0 L 1 0 1 1 0 1 Z N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartProcess("ooxml-flowChartProcess", "H4sIAAAAAAAAAJWSTWvDMAyG/4rx3aROb6HuYLt2Y+fdtESJDU7Uyc5H++vnNemgIx0UYx386nmEwLuKYSyws9CVWKkGqcXIJ3F5bh0zsbLE7kxdBG9kDT6gvIkH5OjKPyERFaH/VIPDUQV3RiO10AsYcYoKGCEYuREb8VRv082lCENT/BDPNM1JOlfmdEwOoqn1qvY0vljg+M5UYghLy+8WR4jWyNcLfxA6Vb3UD/Em97u5+6uH6Kib2Q7apK+v02ritvdgpKdmdFW0WZ647Ab8z6NXPBZdY+ODovyu6CHN9t5eK5Zs/UvsvwEGXz3NKwIAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f3 ?f3 ?f4 ?f5" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartAlternateProcess" draw:enhanced-path="M 0 ?f0 L ?f1 0 L ?f9 ?f2 L ?f0 ?f8 Z N" drawooo:enhanced-path="M 0 ?f0 G ?f0 ?f0 ?f10 ?f11 L ?f1 0 G ?f0 ?f0 ?f12 ?f13 L ?f9 ?f2 G ?f0 ?f0 ?f14 ?f15 L ?f0 ?f8 G ?f0 ?f0 ?f16 ?f17 Z N"><draw:equation draw:name="f0" draw:formula="min(logwidth,logheight)/6"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth+0-?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="logheight+0-?f0 "></draw:equation><draw:equation draw:name="f3" draw:formula="?f0 *29289/100000"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth+0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="logheight+0-?f3 "></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f10" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f11" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f12" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(5400000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartAlternateProcess("ooxml-flowChartAlternateProcess", "H4sIAAAAAAAAAKWVXW+CMBSG/0rTK/bBoCAIRjTbLnazLbveXaMFmgB1pYru168FNSJiVoGc04bTPn0PeQnTJcfVhBQpLhZkaSaE5UTwHagf55Rzxs2UcfrLCoGzCMY4KwlslTeEC7o4LwqyFSbmBJcRnMcuaGIkw4Og3CSTDSXVC9tG0Ab1fdi3W5EIMrbNMzPOWPWaYi6eM0F4gQX54mxBynK/9ih7hUUawQ+Jmcc2eJcZgWYMZTj1TNUC8A0+m82Msb79b/vVKlCd0JHZqjkquSfntKqqV+SdnN2q+iqNaz2zadPNzxoLyoqmtwLn8j3Eh9cSM56vMxzBnBZGxpKKLkX6KCcpoUkq7ixfYqwW5xoWnWMPyAfbVAK1YM4FWCPrFpp7TlOEeyd0gtBCtrq0cKOrnbp62rzrnWrS/D5plqPFGfeq0gQFvSAtTNjXl55FO9Y3kB3UBpBuV8OTnhNQx/SGNxrC6/jeQL4zBNix/kCBHe8bt5I6xh+orGP9gbzOJ/AfnnX53zf7A96txh4UBwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="2 2" draw:text-areas="?f6 ?f7 ?f0 ?f1" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartDecision" draw:enhanced-path="M 0 1 L 1 0 2 1 1 2 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*3/4"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight*3/4"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth/4"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/4"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartDecision("ooxml-flowChartDecision", "H4sIAAAAAAAAAJWT22oDIRBAf0V8LMhekiawxATaPrb9gL7Z3XEV3J1U3Uvy9bW5FFJiQWTmQeccxwE3jRVTBb0SfQ0NawE78PZATtudthYtU2j1EXsvDKdSGAf05ngE63X95xARKzd8slHDxJw+AqclKS+gh9kzYUE4TndyRXZyHSIPUVDixrb6oZ5w5jQnp3XlDvvgQZw7w6TB6VkJ61+g1k5jf6n5fcpeeMXpW8AL8hoiJ2XIRcgf5J1uN+fqr0H4AJ/ZXnTBL6/XSbTdYASnBttJN149LLJlILMb9D9TccekQLfKJ6vKWFNZmeRZRFtKFC2joiTNY+xdSZZVdDppU17Hp3NPlN3/PdtvmMr1hVYDAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="5 5" draw:text-areas="?f8 0 ?f2 ?f7" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartInputOutput" draw:enhanced-path="M 0 5 L 1 0 5 0 4 5 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*2/5"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*3/5"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth*4/5"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth*9/10"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/10"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth/5"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartInputOutput("ooxml-flowChartInputOutput", "H4sIAAAAAAAAAJXTW2vDIBgG4L8iXg4khyZrF2oL29Vgh/vduUajYPJlxhzaXz+XtoOOOBBRQX0fFXFbGjYWvJGsOfCSVBxqbs0RzcO1MgYMkWDUCRrLNMWC6Y7jm+mBG6sOfyYBoOj6TzIoPpJOnTjFOcovQcsnS5jhrKN4LzYoRnuRurrGqBuq4ifzCBPFMZrLNXVsnQIw1ZoIDeOTZMY+N21v33vr2suy37u0zEqKX52QoxeUzH2MMtd+oDe8255Xf/XMKmjO2YbVbgtx3VGAqXvNKNZQjaq08i6NcpeMbqL/SYlXWgVKqVfKAqWVV3qIkjiIynxUlAY5udcJPND9AiS5qqQNPNHaCwUxG+/Flt4sWv6Mu28E6f8OpQMAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="1 1 8 8 1 1" draw:text-areas="?f5 0 ?f0 ?f3" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartPredefinedProcess" draw:enhanced-path="M 0 0 L 1 0 1 1 0 1 Z S N M 1 0 L 1 8 M 7 0 L 7 8 F N M 0 0 L 1 0 1 1 0 1 Z F N"><draw:equation draw:name="f0" draw:formula="logwidth*7/8"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/8"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartPredefinedProcess("ooxml-flowChartPredefinedProcess", "H4sIAAAAAAAAAJWSXWvDIBSG/4p4OQhJ2pWU0LSwwa6aUdjd7lxzjILJ6dR8tL9+xraDjmQQRD16fB/fI24KzboUasHqIxRBCViB1WfityupNepAoJYXrC1TGeVMGaAP6Ra0lcc/SURMTfMVtBK6wMgLZDQmMVm75uYbwEJvA6aBmYzu+IpEZMeHvqTEtGU6aF+wz2hEfLurzidHQ+wrFXCF3atg2h40FMBlDcVB4xGMuR3+rezErMho7kl75yEafPjxk3yQd5L71d57zEni48TFbz43pnIZut1cb/lumJVYX++sWeUM8rtfjrpqFMuowrKThRVPSbh2yvBB+h8pniKFi1mcxQhHgCyFnQlaToJmYZ6n6ppFWU2+ztgrh+MffvsDi+sQkgkDAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="1 1 8 8 1 1" draw:text-areas="?f4 ?f5 ?f3 ?f2" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartInternalStorage" draw:enhanced-path="M 0 0 L 1 0 1 1 0 1 Z S N M 1 0 L 1 8 M 0 1 L 8 1 F N M 0 0 L 1 0 1 1 0 1 Z F N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/8"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight/8"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartInternalStorage("ooxml-flowChartInternalStorage", "H4sIAAAAAAAAAJWSXWvDIBSG/4p4H9L0A0qoLXQwGCS76d3uzhqNgvF0xny0v37WLoOOZBDkKPryPudV3BUWupQbCebMi6jkWHFnryQcV8patJFEq25oHGhGBeia0ye55dap8x8REdO6+YxaxbuoVjfOaEISsvXDrz8Ax3sXgeVQM3oQa3IQG18rX0tK6rZM7+4j9owuSBiD73rxPMS+0pHQ2L1IsO7NOG4N6JNDC+WQ8fdmF3CS0TxwMp9hcc8R5g9yIu8kD7ssZMzDeRayvgZtzOUVut89unw14BSaR08DlY8nhrQCbdVoYFRj2anCyXjpffGT8T9OMsKRXJXSzQQtJ0GzMKupe82irCdfZzuLs5l+nTFQPP7f998SF7l1CAMAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="21600 21600" draw:text-areas="0 0 ?f4 ?f0" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartDocument" draw:enhanced-path="M 0 0 L 21600 0 21600 17322 C 10800 17322 10800 23922 0 20172 Z N"><draw:equation draw:name="f0" draw:formula="logheight*17322/21600"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight*20172/21600"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartDocument("ooxml-flowChartDocument", "H4sIAAAAAAAAAJ2S32rDIBTGX0W8HEiMKetWkgzWXW57gN25xETBeDpj/rRPPxfTQkcy6BD16Of5ne+AaWn5sBNGclOIktQCGuHsEU3XjbIWLJFg1QmM4zrDFdetwFdyL6xTxS8RAHZt90l6JQbSqpPIMIvvKUXTOgOcGB3hVvA2wxRR9FRt/PRq29e7n8xnGIPixznnePAsgLHRpNIw7CW37gWKrhHGzW8u7Ry4kxl+mwCvoTSaLaB4mzCG9iimD5dTiFny6GO/03jL0Ad6x3kauF8ddwpMqGJ4451UZ2MV2KbTPMMaailULd3dBI1Cx3kaXTH+QsbryMnTP5BsATmo0smI3cRJVq3dCNqsGVqgRMufNP8GgRto170CAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="21600 21600 21600 21600 21600 21600" draw:text-areas="0 ?f0 ?f4 ?f1" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartMultidocument" draw:enhanced-path="M 0 20782 C 9298 23542 9298 18022 18595 18022 L 18595 3675 0 3675 Z M 1532 3675 L 1532 1815 20000 1815 20000 16252 C 19298 16252 18595 16352 18595 16352 L 18595 3675 Z M 2972 1815 L 2972 0 21600 0 21600 14392 C 20800 14392 20000 14467 20000 14467 L 20000 1815 Z S N M 0 3675 L 18595 3675 18595 18022 C 9298 18022 9298 23542 0 20782 Z M 1532 3675 L 1532 1815 20000 1815 20000 16252 C 19298 16252 18595 16352 18595 16352 M 2972 1815 L 2972 0 21600 0 21600 14392 C 20800 14392 20000 14467 20000 14467 F N M 0 20782 C 9298 23542 9298 18022 18595 18022 L 18595 16352 C 18595 16352 19298 16252 20000 16252 L 20000 14467 C 20000 14467 20800 14392 21600 14392 L 21600 0 2972 0 2972 1815 1532 1815 1532 3675 0 3675 Z F S N"><draw:equation draw:name="f0" draw:formula="logheight*3675/21600"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight*20782/21600"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth*9298/21600"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth*12286/21600"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth*18595/21600"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartMultidocument("ooxml-flowChartMultidocument", "H4sIAAAAAAAAALWUXW+CMBSG/0rD5RIiLR+CEZeMxCvcze6867RIE6CuFL9+/SgtCkZMJBsEekrpc8770jLfcnyckSLFxYZszR1hORH8DJrHOeWccTNlnF5YIXAWGgnOSmL0hg+EC7q5G2SMzcrq2zxQcjRLeiGhgaBnWeDpXYMFOQkTc4LL0LDAeyIvp76gAcrDbiaZH+wkx5qznXXe11kYO+WZmWTsGKWYi1WVCbplmyonhdAvXtXusUhDY1UzkDX1EYhAgAIfINt1kAqhbyFU393A1XGse7Y3deuJTbMGKwBdG6lerGLoQ7fm1kcv9JArE0GFb3oa79l3cS+VzIGCqebGKm7Na1vo2IGkI8u/9nRex/GmvTjuFrcGX+ATrFpBvcxd9VHXlo5ZrYP/5MQfS19qra9/dVVO1C+0I6ArLe7ljO6q6VTZqT++qdIir7pvVt4Mvq6/pfx+xmKu1vdPhQVlhVrtBc7rbZG0uyRhPK8yHBoZ26WE7lLxJhkTtf8W80kP8YwIh4mNsSOQ6AHySLcifZMejwDag0CIkO+NIDrDRLkmRhDdQR8n6CWQN1TaA8rk8X9/8QufLycgEAYAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="21600 21600" draw:text-areas="?f0 ?f2 ?f1 ?f3" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartTerminator" draw:enhanced-path="M 3475 0 L 18125 0 L 3475 21600 Z N" drawooo:enhanced-path="M 3475 0 L 18125 0 G 3475 10800 ?f8 ?f9 L 3475 21600 G 3475 10800 ?f10 ?f11 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*1018/21600"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*20582/21600"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight*3163/21600"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight*18437/21600"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f8" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f9" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f10" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f11" draw:formula="(10800000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartTerminator("ooxml-flowChartTerminator", "H4sIAAAAAAAAAKWUXW+CMBSG/0rTK2fCaMuH1Ygm28Vutl3tanedFmgCHFeqqL9+fOiMH2yD0ZxCTnuevm/TMl1qUUxkFotsIZdWJCGVRu9QnU6V1qCtGLTaQ2ZEEuBQJLnEZ8MbqY1aXAwCwCRff1gbJQsrV3sZYEZ9QlDdHwBGbo0ltBR5gOchQfOQlUHLcDDKN9Gkqn6AbYAJqtuxbrcqeQDbNLHCBIrHWGjzJnWqMmFAH2Z9m1oJEwf4BTnuyCspz4hyypqvOtUIe0evJ+m/1z41KUo4qYTzMsbnwIsZtO5ovc5s2ij8XAujIGv0ZiItXYVHkyHodJ2IACcQFWpp4iEllNvN/s2m9hnhJyBtBTLicdaDyG4QY6mi2Awd6js9iE47kXLXGfVAum22bdaJ47VK6wjyW0GdMKM2X50o/JIyoD4j1XNn+9Xrvttuj6951bnvzaNX12Dguf/hXd2CPwm0b/8eZ1+evYqVNwUAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="10 10" draw:text-areas="?f5 0 ?f0 ?f3" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartPreparation" draw:enhanced-path="M 0 5 L 2 0 8 0 10 5 8 10 2 10 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*4/5"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/5"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartPreparation("ooxml-flowChartPreparation", "H4sIAAAAAAAAAJWSyWrDMBCGX0XoWBBeEkMwUQLttS099zaNZUsge9yxvCRPX9lJCil2wYjRII3+bxa0zwj6VFUaqpPKRKGwVI7ObLouDRGS0EjmgpUDK3kOtlH8Idwpcub0J4iIadN+ic6oXjTmoiSPQhaFN6lTgxNAChrJj3nCQnbMR9tw1nRFOqqecZA8ZNO6q8615yAOpRW5xf5FA7kPUjUQOIPV7dlvNzU4LfmbJyTslcXe79hYhD/uRheP2yd754f9VfjdTpwrpoLSZ8vvyXOksrUgucWiN5nTT9sg8crgQfofKVoiBfEqTjzD0coU2q0EbRZBqzDbpb5WUZLF6cxNOZj/t4cfsTakOtACAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="5 5" draw:text-areas="0 ?f5 ?f4 ?f3" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartManualInput" draw:enhanced-path="M 0 1 L 5 0 5 5 0 5 Z N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight/10"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight/5"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartManualInput("ooxml-flowChartManualInput", "H4sIAAAAAAAAAJWS3WrDMAyFX8X43qRp65vQdNBdDdY9wO60xokNtpU5yk/79HPbdNCRDIKRBT46nyzjXRGgz5TX4E+qEJVCpyic2e3YmRAwCI3BXNAT2JyXYBvFn+ROBTKnPyIiZk37JTqjetGYi8q5ZHI0khpIQFDQ5HzFXkoZYxtjw1nTVdnVc8Dhqt3Ww3WuIwVxcFaUFvtXDYGO4Fuwb75uaSz7naUG0jk/RkLK3pmMWY77J/vg+929+rsFMujvXg8utigfHUsMrrWQc4tVbwrSyTr6kifjf5x0gqOVqTQl6WoRaT1PWnalzSxoEWY790KLKHJ+KjkBSqb/6v4Hq73o+8QCAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="5 5" draw:text-areas="?f6 0 ?f0 ?f5" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartManualOperation" draw:enhanced-path="M 0 0 L 5 0 4 5 1 5 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*4/5"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*9/10"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth/10"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth/5"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartManualOperation("ooxml-flowChartManualOperation", "H4sIAAAAAAAAAJWSTWvDMAyG/4rxcWCSdElhoW6hu67bfTetsWODY2WO89H++rlpO+hIBsFIB796H0nYm8JBnwurwB5FwUqBlfDuRMbrSjuHjil0+ozWg+FUgmkEfZA74bw+/hERMW/aL9Zp0bNGnwWnGcluRi8Gz8AJaDjdyTWJyU5eIuhNV+YXzx4HTmMynrvrVAcK4lAZJg32rwqcP4BtwXzUwoHXaG+lv/vU4BWnh5HzRrKQ05CTEJ/knW431+rvdjRfvRaq0Ebeu0p0VWuAU4NlrwuvntIoC87owfofKZklvURJvAi1mkNFq0Wc51nOwoHSCZASulR+4UTZLGgRZj272NSbRdOff/sDppTczxUDAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f5 ?f8 ?f6 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartConnector" draw:enhanced-path="M 0 ?f7 Z N" drawooo:enhanced-path="M 0 ?f7 G ?f0 ?f2 ?f12 ?f13 ?f0 ?f2 ?f14 ?f15 ?f0 ?f2 ?f16 ?f17 ?f0 ?f2 ?f18 ?f19 Z N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 +0-?f1 "></draw:equation><draw:equation draw:name="f6" draw:formula="?f4 +?f1 -0"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f3 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f3 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f12" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(5400000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartConnector("ooxml-flowChartConnector", "H4sIAAAAAAAAAK2V326CMBTGX6XpFXNh/BFBjWgyL3a1PcDuGizQBHpcqaJ7+lGYRi1b1iGkpTnt+fF99DQsNoLUc8pzwhO6sTMKJZXiiNpwyYQAYecg2CdwSYoYp6SoKL6a3lMhWXI7KelB2kRQUsV4lU7QKp02LWzaDKNqn833jNbPcIixi9r7lHfc0hgDHMrCTguo1zkRcg2c00SC+F501rslMo/xa5O/SiP0jt66BQDw05qXplcjv2le240vI4HqJpcRJdmLLiPKiDdr37ZcdHo+dkQy4J06TsrGQnpylIIodwWJcQFZzTYyd/wmz7lK/I3j3XKUlFEClbVlI8uPXHU9OJ477UZGcL9HZE5ZlktDlWNdpY9GFeP3UBnc6VNOdJEBenTtZj+RESjsBSmM7RqBont9/6muKOqsjc2szXpBCmNozes7AJ03M452AE67b4bRSt06F6MTqseToT+t5K1JMISnVbnlhf4QoFbuAwVqVW/9l6SV/UBlWvUP5GmH4C88p/9fuvwCbLS6Q2QHAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="10 10" draw:text-areas="0 0 ?f4 ?f0" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartOffpageConnector" draw:enhanced-path="M 0 0 L 10 0 10 8 5 10 0 8 Z N"><draw:equation draw:name="f0" draw:formula="logheight*4/5"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartOffpageConnector("ooxml-flowChartOffpageConnector", "H4sIAAAAAAAAAJWSy2rDMBBFf0VoWRB2UgeCiRNotn3su5vaI0sga1xZfiRfXyVOCil2wQiB0NU5MwPaFQ76FK0Cm2MhSqQKvTux63WlnSMnFDl9JuvBZFyCaZA/xB06r/M/IRGlTfslOo29aPQZM76K2Sq+oR4HL8AhNBmPWcwOMgk7pE1XphfmhYYxCevOnOpgIRoqI6Sh/qjA+Q8payjxSNZi7snd3v4OVINXGX+7il5DfXZpgm3ZZjxv2Sd75/vdCH234DXZUWGhCuXkvbokV7UGMm6oVKhL5Z+SaBPQ6IH9T7WaUPW68CpaL/KsZ1taKHqeFS3SJHNzTVii6f+2/wGMD2VeiAIAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="5 5" draw:text-areas="0 ?f4 ?f3 ?f2" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartPunchedCard" draw:enhanced-path="M 0 1 L 1 0 5 0 5 5 0 5 Z N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight/5"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartPunchedCard("ooxml-flowChartPunchedCard", "H4sIAAAAAAAAAJWSTWvDMAyG/4rx3aRfuYSmg/a6jZ130xIlNjhWpzgf7a+fm7SDjmQQzOuD5OcRAu9zhi5Bp8FlmKsSqULPFzGUK8NMrDSxuZLzYFNZgK1RPrVbZG+yP00iSurmS7UGO1WbK6YyFvEd9Nh7BYxQp3IlXopdyDZkI0XdlsmNOVJ/6w3nQV3OwULUV1YVlrqTBvYfjcs05ifg/P7sd5czeJ3Kt2BYi9eQlYiHjPeneJeH/Uh8N+ANuZF3UIUxxWNqQVw1FlJpqexM7nW0CVz0BP7nWU94NJpS+4WizaxokWY7t9ciy25+q3hCFE3/ssMPja7s1X4CAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="20 20" draw:text-areas="0 ?f6 ?f5 ?f1" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartPunchedTape" draw:enhanced-path="M 0 2 L 5 2 Z N" drawooo:enhanced-path="M 0 2 G 5 2 ?f7 ?f8 5 2 ?f9 ?f10 L 20 18 G 5 2 ?f11 ?f12 5 2 ?f13 ?f14 Z N"><draw:equation draw:name="f0" draw:formula="logheight*9/10"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight*4/5"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/10"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight/5"></draw:equation><draw:equation draw:name="f7" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f8" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f9" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f10" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f11" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f12" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(10800000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartPunchedTape("ooxml-flowChartPunchedTape", "H4sIAAAAAAAAAK2U32+CMBDH/5WGJ7eko0VRNKLJ9rCXbdnDnvbWSaFNgLpSRP3r16JoFFlWHeSOH7378L3LlWkkSTWhOSP5gkYwoSKjSm5A/TrjUgoJmZB8K3JF0tCJSVpQ52R5RaXii7NFIcSkKL/gitMKFnxLQ8dDwEP7VEXXChJJSRE6CMzjoTZfG3ZAsUomJutRrM1afTZZm6XmCLHOUhinonpiRKr3Ml8wGn2QZaPrUM2SKBY6r5rggRfga/8J3o76LsY913HzeKQt2N+PjTKkEboEHBxCMDbOa576xg3qT8ymOyHfJVFc5DtZOcm0+rgpJhYyK1MSOqlIGOUJU/djFyOd654k/8bC3ayB61uhvAuoikeKuZ4Vp98pyba4QTfJTpLfVZoVZdgtx67To3NQD6MAmePOHZrLg12fghYP3gYc/7NA3Br5W4Gtue9dS2qN/a3Nw60NcLW21gb4U9vcy3/02Q99tuYB6gUAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f5 ?f8 ?f6 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartSummingJunction" draw:enhanced-path="M 0 ?f7 Z S N M ?f0 ?f2 L ?f14 ?f15 M ?f0 ?f2 L ?f16 ?f17 F N M ?f0 ?f2 Z F N" drawooo:enhanced-path="M 0 ?f7 G ?f0 ?f2 ?f12 ?f13 ?f0 ?f2 ?f14 ?f15 ?f0 ?f2 ?f16 ?f17 ?f0 ?f2 ?f18 ?f19 Z S N M ?f5 ?f8 L ?f6 ?f9 M ?f6 ?f8 L ?f5 ?f9 F N M 0 ?f7 G ?f0 ?f2 ?f20 ?f21 ?f0 ?f2 ?f22 ?f23 ?f0 ?f2 ?f24 ?f25 ?f0 ?f2 ?f26 ?f27 Z F N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 +0-?f1 "></draw:equation><draw:equation draw:name="f6" draw:formula="?f4 +?f1 -0"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f3 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f3 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f12" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartSummingJunction("ooxml-flowChartSummingJunction", "H4sIAAAAAAAAAK2W3W6jMBCFX8XiiqaigBMgqUoj7UpdadXuTe96ZyUGLAFOjfPTffq1IYlIhq3kmEQ4MNifz4zPSHlaC7J/pHVB6hVdeznlFZXiC7XhignBhVdwwf7yWpIydTJSNtS5eL2jQrLV9UtJD9IjgpImdZZZhJbZXF2xuhYOanb5447R/Q9+SJ0Atd/Tuq8NTR3OD1XpZSXf/yyIkO/bqmJ1/ntbryTj9XHqWfWGyCJ13hRlmSXoA72jP+hN3etnjF7VGM70EF1HtZwwQS8X8z/0c7cF5/x/u/w6z1eIdpj2I8f9epHjXr2ILki46OntqvR6qlMbi8+xqI11WqEG3N6E/Ug79FVhrQr3VWGNx8kx5+enrq6fW6LL3FW5JpU6kOx0PhkX1bYkqVPyfM/WsvCxWudfLPyOE15ztJjJijfuhk1cnAT6c+eHwby7M4LjAZEFZXkhDVVOoUqMJg2rx1A5G6mUERQ5Q/eBp1yFjEDxIEhjvMAIlIxV/zlUlHSpTc1SWwyCNMYwtXCoAbrczDigAU6nb4YBVnfPZvRj/fNgmB+wvBvNbHjA5W4YYxsgsLulQOB691YSsL2lMuB+Sx5oAjseBq1g6T0MesJS4EBzWHkPj9wcGDbHraSRuwLDrrDj3dQb/vC/0ud/UUF4ma4KAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f5 ?f8 ?f6 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartOr" draw:enhanced-path="M 0 ?f7 Z S N M ?f0 ?f2 L ?f14 ?f15 M ?f0 ?f2 L ?f16 ?f17 F N M ?f0 ?f2 Z F N" drawooo:enhanced-path="M 0 ?f7 G ?f0 ?f2 ?f12 ?f13 ?f0 ?f2 ?f14 ?f15 ?f0 ?f2 ?f16 ?f17 ?f0 ?f2 ?f18 ?f19 Z S N M ?f4 0 L ?f4 ?f10 M 0 ?f7 L ?f11 ?f7 F N M 0 ?f7 G ?f0 ?f2 ?f20 ?f21 ?f0 ?f2 ?f22 ?f23 ?f0 ?f2 ?f24 ?f25 ?f0 ?f2 ?f26 ?f27 Z F N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 +0-?f1 "></draw:equation><draw:equation draw:name="f6" draw:formula="?f4 +?f1 -0"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f3 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f3 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f12" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartOr("ooxml-flowChartOr", "H4sIAAAAAAAAAK1WXY+iMBT9Kw1PrBMWWlF0MozJbjL7Mh8P8+Zbo0WaAHVLR5399dOCGvQym9SioZRbeu65t+ckPKwl3d+zKqfViq2DDRMlU/ITNeGSSylkkAvJ/4lK0SL1MlrUzLtY3jGp+Op6UbGDCqhktE69RTZBi2ymr6m+5h6qd5v7HWf7X+KQehFq/qd9n1uWekIcyiLICrH/nVOp3uRx9Ux0S1Weei964yJL0BK9o1f0oufmmaBnPeLYDJPrqGGAE/R08f7SPLcphBDfZflzfl9DNMO4Gznm60SOuToR0wM87/CNNfZzc9cLETqlaqjiZtoyhQxIM8HdSDN0OREDS7qciOFEkmPFjw9tV/9+UMVF1fa4oqU+gex0IJmQ5UdBU68Qmz1fqzwkel94sfF/OPgax5AZrUTtb/nIJ0lkfj9CHM3amRU46SGZM77JlSXLMWRJ0Kjm1RAs44FaOYEkY3QXBVoryApo2gtkYILICigZqv8zyChpSxvblTbvBTIwlqXhPgO0tdnhAAOcTt8OBkjdP4sxnJrbT8v6gOT9SeyCB1Tu4ylxAQRydyQIVO/figRk78gMqN8RD5jADY8AKzhqjwBPOBLsMYeT9sjA5iDQHLciDewKAl3hhneTN8L+z9DHL4qkR0GfCgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="2 2" draw:text-areas="?f5 ?f6 ?f0 ?f1" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartCollate" draw:enhanced-path="M 0 0 L 2 0 1 1 2 2 0 2 1 1 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*3/4"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight*3/4"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/4"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight/4"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartCollate("ooxml-flowChartCollate", "H4sIAAAAAAAAAJWS22rDMAyGX8X4cmDSuIeLULew3m57gN1pjR0bnKhzlEP79PPSZdCRDIKQERb/p1/G+zxAl+nKQnXWuSg0lprClQ3XpQsBg7AY3A0rAq+4AV9r/tBudSB3/tNExKxuPkTrdCdqd9OKSyZ/hKR7EhA01IofzZYdzS7mKmbKWd0W2bfqGXvFV2yIUXe9RA5iX3phPHYnC4FO6D3Q6Ol3kwuQVfx10L8wGc80hhwqOdTv7I0f9nfVZwPksLozKijjGDNONRjKxoPiHovO5WSf1skmKpMH6X+kdIJktSssLUbJOVOJXMRZz1paCNrMghZhtrN7LXuf3fxeU6Bk+vsfvgDKaBwkFwMAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="2 2 2 2 2 2" draw:text-areas="?f6 ?f7 ?f0 ?f1" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartSort" draw:enhanced-path="M 0 1 L 1 0 2 1 1 2 Z S N M 0 1 L 2 1 F N M 0 1 L 1 0 2 1 1 2 Z F N"><draw:equation draw:name="f0" draw:formula="logwidth*3/4"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight*3/4"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth/4"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/4"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartSort("ooxml-flowChartSort", "H4sIAAAAAAAAAJWTy2rDMBBFf0VoWRB+JE3ARAk0kFXbTXbdqbFkCWRPKsuP5OurPBzqYgXEMAvN1T0zGtAqN6zLeCVZdeA5KTiU3JoTupZLZQwYIsGoM1SWaYoF0zXHI7nlxqrDPxEAsrr5Jq3iHanVmVOcokfcAZb3ljDDWU3xRizQRixdxi4TjOq2yC7uN+gpjtE1Bt/p6HgAfamJ0NBtJTN2D8be9cdzjsxKij+cNUHvLmPXPHGRoi+0R59oUC7V3Z/z+KZT8Hp1I/80zCqobn0qVro5xDCWAFM2mlGsoehUbuXLLJo7ZzSyPiMlEyTJVSFtMCr1DRWlQZyZd6RA0NwLCsK8+t4VRFl4txO25aV/O1OgaPq3rX8BwxrBooYDAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="2 2" draw:text-areas="?f2 ?f3 ?f0 ?f4" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartExtract" draw:enhanced-path="M 0 2 L 1 0 2 2 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*3/4"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/4"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartExtract("ooxml-flowChartExtract", "H4sIAAAAAAAAAJWSzWrDMAyAX8X4ODBpnZxC3ULHbtseYDctsWODE3WO8tM+/by0HXQkg2CEwdL3WQLtygBDrhsLTaFLUWmsNYUzm55rFwIGYTG4CzYEXnEDvtX8Id3rQK74k0TEvO0+Re/0IFp30YpLJm8g6ZEEBA2t4gcj2cGkMTYxMs7avsp/qCOOim/YdO7c+RQ9iGPthfE4PFsI9DJSgIJuJb+TnICs4m+RluyVbadbsg/2zve7a+VXB+SwuXIN1FFt7j8ZDHXnQXGP1eBKsk9pkkUyeUD/M22XTIlc5ZGLnnX9pDMeq11laWVD2aJoRpPMr9f+GxKmGJ13AgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="2 2" draw:text-areas="?f2 0 ?f0 ?f3" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartMerge" draw:enhanced-path="M 0 0 L 2 0 1 2 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*3/4"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/4"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartMerge("ooxml-flowChartMerge", "H4sIAAAAAAAAAJWSTWrDMBBGryK0LAgndlYmSiDdNj1Ad9N4ZAlkTzqWf5LT13bqQopdMGK00Og9fQPaZwxtiqWF8oKZypEKDHwT43HhmImVJXZ3KgN4LQ34CuVTu0EO7vKnSURpVX+qxmGrKndHLWMR/4ABu6CAESotjyYWG3E0QyVSVE2eDsyJOi03YlwTdbv2FqKu8Mp4al8tcDgj51Oe3ymuEKyW55F+E4N/2+8f4l0e9o+bXzUER+WDK6HoxWZ6xxAXtQctPeWty4J9SaJdT0ZP6H+m7ZIpild54kXPujzJjMeiy21YGWi3KJrRRPNf6/AN4MacN3MCAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="6 6" draw:text-areas="?f4 0 ?f0 ?f3" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartOnlineStorage" draw:enhanced-path="M 1 0 L 6 0 L 1 6 Z N" drawooo:enhanced-path="M 1 0 L 6 0 G 1 3 ?f5 ?f6 L 1 6 G 1 3 ?f7 ?f8 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*5/6"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/6"></draw:equation><draw:equation draw:name="f5" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f6" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f7" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f8" draw:formula="(10800000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartOnlineStorage("ooxml-flowChartOnlineStorage", "H4sIAAAAAAAAAKWTXW+DIBSG/wrhalvC1FqpaWqbbBe72cfF7nbHWhQS5HRI1fbXD21d08/MFHI4BHgf3kPCZGFYNeZaMD3nC5JxyLk1a9Qu59IYMESAkRvQlqkEp0wVHB9sl9xYOT/aBIBxsfompeQVKeSGJ5giuhNaXlvCDGdFgmfpEPloljYRYlSU2bjRPEGdYB+1vVOtl44CUOeKpAqqZ8GM/dBKav5pwbCs8/VXzZJZkeA3FDjKK6LtGLj8hd73Lq+cfnHz0PmKXNCdtlsbuYhb0nSyvfVnxawEvfWgWe7Mpp33FEy+UizBCrJKLqx4iDzqlN6B9BopuETyBr04gzMcwWUmbE9QeBHUCzO8WFe/94mOOXcBHfhNu/dokx79Xjx6wiOBH98AHJ0Ao+ENuPi03n/Y885/9+kvPmIx/wcEAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="0 ?f7 ?f5 ?f8" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartDelay" draw:enhanced-path="M 0 0 L ?f4 0 L 0 ?f9 Z N" drawooo:enhanced-path="M 0 0 L ?f4 0 G ?f0 ?f2 ?f11 ?f12 L 0 ?f9 Z N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 +?f1 -0"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 +0-?f3 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 +?f3 -0"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f11" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f12" draw:formula="(10800000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartDelay("ooxml-flowChartDelay", "H4sIAAAAAAAAAK1UXW+CMBT9K02fmIYBVfEjosm2ZC/bfoBvjRbapHBdqaL79WtBTRA1aSLN5TbcntNz2xPmG0WrGSs4LdZs42cMcqbVEdWfc6EUKJ+DEn9QaCoTnFJZMtwq75nSYn1d1OygfaoYLRMcomU6NjEyMcGo3GezvWDVGxxsrR5n1HHLEgxwyKWfSqjeOVX6g0l6PC24KN1SzRP8XaO/DO+wznanKVqhn2Y5ADxGfJpsMcREFNkXabEs5s2uvzuqBRSNhoLmRmR61pyCyneSJlhCVomN5gExuKAFfMQTXfNYSb01lN5W9DwyDu3zEkThpJk5kZMbIjkTGdeOKgddlQT1SlE8Q+XwSUc56oocor65VeSHTkTxs45t3FUUo37oL9MBciKa3CSyNI6tTe+25ubau/Z3o+m434ticjJTbNOrW3tRx/HexZMPCIPb/8HFPzC/17MgBQAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f5 ?f8 ?f6 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartMagneticTape" draw:enhanced-path="M ?f4 ?f11 L ?f0 ?f2 ?f15 ?f16 Z N" drawooo:enhanced-path="M ?f4 ?f11 G ?f0 ?f2 ?f13 ?f14 ?f0 ?f2 ?f15 ?f16 ?f0 ?f2 ?f17 ?f18 ?f0 ?f2 ?f19 ?f20 L ?f12 ?f9 ?f12 ?f11 Z N"><draw:equation draw:name="f0" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 +0-?f1 "></draw:equation><draw:equation draw:name="f6" draw:formula="?f4 +?f1 -0"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f3 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f3 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="(10800000*atan2(logheight,logwidth))/pi"></draw:equation><draw:equation draw:name="f11" draw:formula="logheight"></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f13" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(?f10 )/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartMagneticTape("ooxml-flowChartMagneticTape", "H4sIAAAAAAAAAK2VT2+CMBjGv0rDCdkYf0QEI5psh13mTjvt1miBJkBZqaL79GthELXEpCKkpbR5f33etg8sdxTWC1SksNiinZkgkiNGT6DpzjGlhJopofiXFAxmkRbDrELaxfABUYa314MMHZkJKYJVpK3jGVjHAS8+L6EGqkOyOGBUv5JjpNmgubu4U4kijZBjnplxRuq3FFK2gUmB+CRfsOz4veQSsjTSNhzs8eI44IM/bF5c8SomdnzwDT7bOELIjdD389CpqLwB2FnPXFTBeU8oGnYjwhEdYdfgeKFitWzl/+whw6RokylgzpOOuzWICc33GYy0jCQ13rHUcnmcdRF4i+Ncc4Q+Y0sqvcSG7s5tcU0sxw7alhLcHRCZIpykTFHlVFbpAqPCxSNUeg9aypks0gNPtsn3EyiB/EGQwJi2Emj+qPUPZEXzNrWpWmrhIEhgFFNzJAPo3e4bkMHC1ftcn7v9nEysEqvNItmjp6pxhpzQaFLDSD7QZ97/2ffF40VxEaWjP5InWaDflDuBkhVGCpQcoTu+OwYoOWOkQMkg+p0kVzYI/4LY4BbNGv7Dr/4AxzJl3foHAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="6 6 6 6 6 6" draw:text-areas="0 ?f2 ?f5 ?f0" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartMagneticDisk" draw:enhanced-path="M 0 1 L 6 5 Z S N M 6 1 F N M 0 1 L 6 5 Z F N" drawooo:enhanced-path="M 0 1 G 3 1 ?f6 ?f7 L 6 5 G 3 1 ?f8 ?f9 Z S N M 6 1 G 3 1 ?f10 ?f11 F N M 0 1 G 3 1 ?f12 ?f13 L 6 5 G 3 1 ?f14 ?f15 Z F N"><draw:equation draw:name="f0" draw:formula="logheight*5/6"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/3"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f6" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f7" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f8" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f9" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f10" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f11" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f12" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(10800000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartMagneticDisk("ooxml-flowChartMagneticDisk", "H4sIAAAAAAAAAK2V32+CMBDH/5WmT9sSBhXBHxFNtmV7mXvZ2946LbQZcK5UUf/6FQWnVpah0lxpetyn37tcw2Aqad5nKafphE2tiEHClFyhzXYipARpcZBiDamicYBDGmcMH7gXTCoxOXICQD+bf1oLwXIrE2sWYB/tRglQbKksKhnNAuygUdjS5mlzMMoWUb+IfYBl4duMKmo10zSAZRJbYQz5I6dSjWmUMi3jSWRf5Xe7pGZU8QCPNYKgV328hz7QO3pDY70m6Hmz2vfpnd8kTlJekKvnUehr65Rx1V5XW+/ghMpDihzJ/ok7T5E5cY9IpF1MlaLhYJvV95wqAek2x5QmuhZhVZoQZDKPaYBjiDgTEVd3nu3rUPsg9i8UOYHKxVRxu9WI06qVZLuNQG49qJmidi2oEcarK1Ajin9MuSFO1ymeW9svXvdOI17nyryuwTsT1LuyMGL0+rnKiNHql0ozev5SoNH7lwKNO3B28Yxr8C9p9unfzfAHbrlm2ocGAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="6 6 6 6 6 6" draw:text-areas="?f5 0 ?f0 ?f3" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartMagneticDrum" draw:enhanced-path="M 1 0 L 5 0 L 1 6 Z S N M 5 6 F N M 1 0 L 5 0 L 1 6 Z F N" drawooo:enhanced-path="M 1 0 L 5 0 G 1 3 ?f6 ?f7 L 1 6 G 1 3 ?f8 ?f9 Z S N M 5 6 G 1 3 ?f10 ?f11 F N M 1 0 L 5 0 G 1 3 ?f12 ?f13 L 1 6 G 1 3 ?f14 ?f15 Z F N"><draw:equation draw:name="f0" draw:formula="logwidth*2/3"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/6"></draw:equation><draw:equation draw:name="f6" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f7" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f8" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f9" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f10" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f11" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f12" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f13" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f14" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f15" draw:formula="(10800000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartMagneticDrum("ooxml-flowChartMagneticDrum", "H4sIAAAAAAAAAK2VXW+DIBSG/wrhalviFK32I7VNtmW7WXfTu92xFpVEpUOsbX/9wGqXltrMMAlIzuE8vOcIcbrmuJqQPMH5iqytmLCMCL4HtTmjnDNuJYzTA8sFTkMY4bQg8My9JVzQ1YWTMTYpyi9rS0llFfRAQhiAU2sAguyEhTnBRQjnkQ8cMI9U9yAotvFExT6xXQgdULc2ar+RNMZ2WWpFKaueE8zFAsc5kTJeeJk1605JbbBIQrgASELegV+PSMr4BEvwARbSEoDXeqavkPbfhG4Q3+Tck9ID2YdNdGsbyT4+2631IJUtQtruJ7+rBu+ChwZq8Bt1s+kx2+8SC8ryY+45zmSNorZkEeNZmeIQpiyu6FokD67tyUj7LPQWCXWRbLcXx73CSQiNE9ET5HWCemEGXXn1ovid1Ql6cYJLzh0KXEc993agXo9OL95Q5zkjA95I4/kDA9z4n+Uh7byb6UPaqTcVqB1/ww+MtGtgqlC7EIYl1K7GnwTa139Lsx8aJeixrwYAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="6 6" draw:text-areas="?f5 0 ?f0 ?f3" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartDisplay" draw:enhanced-path="M 0 3 L 1 0 5 0 L 1 6 Z N" drawooo:enhanced-path="M 0 3 L 1 0 5 0 G 1 3 ?f6 ?f7 L 1 6 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*5/6"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/6"></draw:equation><draw:equation draw:name="f6" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f7" draw:formula="(10800000)/60000.0"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartDisplay("ooxml-flowChartDisplay", "H4sIAAAAAAAAAJWT207DMAyGXyXKFSCFnmiGqnWTAIkb4AG4C2vaRErrkmY97OlJdwA2VqYksmzF+T87ljLPNOsSXglWrXhGCg4lN3pA2+NSag2aCNByA5VhKsU5Uw3HR+mWayNXJ0kASJr1B2kl70gjNzzFFNG90PDeEKY5a1K8zGPko2U+WoRR0xbJqHmAPsU+2u6DaqgtBaAvFckVdI+CafMkm1qxYX/l+x01MyLFr1YdoRcUWD9WGSOK3tHbT48XFM82imxn1Nrsl34x39X7XDMjodpVr1hpG8wP/eagy7ViKVZQdDIz4ib2qFV6R9L/SMEUyQudOOEZjuCyEMYRFE2CnDB3U+9yosST03GbMj3lXAU09Md17dHR3fpOvNlfnn9/keed/4iLL1bdWE6hAwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="2 2 5 5 2 2" draw:text-areas="?f4 0 ?f0 ?f1" svg:viewBox="0 0 0 0" draw:type="ooxml-flowChartOfflineStorage" draw:enhanced-path="M 0 0 L 2 0 1 2 Z S N M 2 4 L 3 4 F N M 0 0 L 2 0 1 2 Z F N"><draw:equation draw:name="f0" draw:formula="logwidth*3/4"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/4"></draw:equation></draw:enhanced-geometry>
    ooxml_flowChartOfflineStorage("ooxml-flowChartOfflineStorage", "H4sIAAAAAAAAAJWSTWsDIRCG/4p4LMh+9rLEBFLoqWkPufVms+MquE7quh/Jr6/ZdAsJu4UwOOqM78OruCqd6AuwStgDlKwCrMG7ExnLtXYOHVPo9BmtF4ZTKUwD9KbdgfP6cNdExKJpv1inoWeNPgOnKUnJc4gw/wI8DJ4JB6LhdCNzEpONvIyEkqariot2iwOnMRljUp2OgYY41IZJg/2LEs5/SGm0hb1HJ6rJ4N+1jsIrTncj5i0YiEkS8ifZk3eyC6s8VLOQX8f9/alQpevVlfjdCq/RXvlW1MGJnIxJdHVrBKcGq16XXj1lUR6U0Y30P1IyQ1KgK+Wj9CFQumTpQU62aOghTL5oZ+59ovk/uf4B6HIFbKwCAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="21600 21600" draw:text-areas="?f0 ?f4 ?f2 ?f6" svg:viewBox="0 0 0 0" draw:type="ooxml-irregularSeal1" draw:enhanced-path="M 10800 5800 L 14522 0 14155 5325 18380 4457 16702 7315 21097 8137 17607 10475 21600 13290 16837 12942 18145 18095 14020 14457 13247 19737 10532 14935 8485 21600 7715 15627 4762 17617 5667 13937 135 14587 3722 11775 0 8615 4627 7617 370 2295 7312 6320 8352 2295 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*4627/21600"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*8485/21600"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth*16702/21600"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth*14522/21600"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight*6320/21600"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight*8615/21600"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight*13937/21600"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight*13290/21600"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth"></draw:equation></draw:enhanced-geometry>
    ooxml_irregularSeal1("ooxml-irregularSeal1", "H4sIAAAAAAAAAJ2Uy26kMBBFf6XEMhJqv21aTUfKOslmdrPzpM1DApwx7kfy9VOGdKRETaRByHdRdp1brgJ2h2DPWzc0dnhxh7x2vncxvMEU7tsQfMgbH9p3P0TblVllu9FlX7ZPLsT25dum9347Hv/kp9ad87F9d2XGqCIEJv0ARHeJuQ3OjmV2XxG4rwQuhktlMJ7qbcp+8JcyIzA917y3V+R5f+m7HGtw9bGz4ZezHf048HmfVxubMnsCSgx6yySPQIVkDHFUUClBciaBGm4ICCE1UKUJA82pxFpJocFQjlGtCCoRWs5XAMpZgapM2mWFYAhBMiopUAVhyWEiciZQC51OEvTDeMElGGGuMK3RjkrFNAitWLKjGqRSKbtIeTwxpdHANRZPqcZCCBiFeSKlTQlcY4MZ2mP5DBTHEgyXbI79hudsv5v78/doY+uHuVuD7bGd1bW7lQ89NrTMOl+f20Ns7pLBZh7cfrf5QvgJSBeB6eYrgGwROA1tBZEvE9NLsoIobhAb19ZNvEvzWEGUy8Q0/hVEtUyc3rYVSP0TEj+UFUiziPwvTLE04huUze2/4f4fw6MCXyYFAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" drawooo:sub-view-size="21600 21600" draw:text-areas="?f1 ?f5 ?f3 ?f9" svg:viewBox="0 0 0 0" draw:type="ooxml-irregularSeal2" draw:enhanced-path="M 11462 4342 L 14790 0 14525 5777 18007 3172 16380 6532 21600 6645 16985 9402 18270 11290 16380 12310 18877 15632 14640 14350 14942 17370 12180 15935 11612 18842 9872 17370 8700 19712 7527 18125 4917 21600 4805 18240 1285 17825 3330 15370 0 12877 3935 11592 1172 8270 5372 7817 4502 3625 8550 6382 9722 1887 Z N"><draw:equation draw:name="f0" draw:formula="logwidth*9722/21600"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*5372/21600"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth*11612/21600"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth*14640/21600"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight*1887/21600"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight*6382/21600"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight*12877/21600"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight*19712/21600"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight*18842/21600"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight*15935/21600"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight*6645/21600"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth"></draw:equation></draw:enhanced-geometry>
    ooxml_irregularSeal2("ooxml-irregularSeal2", "H4sIAAAAAAAAAJ2US2/bMAzHv4rgYwEjph6WFMQpsPPay267aY38AGyrlZ1H++lH2smADnEOhmEdRPLHP0lJu0N0563va9e/+UNa+dD5MX6yabtrYgwxrUNsvkI/urZIStcOPvlmPvk4Nm//GUMI2+H4Jz01/pwOzZcvEg55lrFpvQJGfxlTF70biuS5BPZcKvwF/jZhw6naUvSPcCmSjE3fLe7zHXkhXLo2RQ2+OrYu/vKu5VeHf/W8u7EukhcGIHPOpJCc/WQgtSUcSMUVU1prBibLNBOgOYNcmIzlSvBZK8tzqXDXGsWszNDBcI3BwBEyOwMXgKsxRFI5RmI6SQmEotViWtCCojiQv7ICkZAD0QxardE3F6MxJ1iNNq04SQNUKS3oqx5pMkUiKAFHUaANOgghCEyEaR+liDmLsoimyibd6IFggzSpsBiRY6xRKBMrQR2aT5I0+81ek/1u7ubH0Y1N6Ofe9q7D5pe3WZQhdtj+ImlDdW4OY/1EjM085v1u843wCAiLQJK8AsgXgVPnVxDFMpHmvYIo7xBr31T1+ERTWEFUy0Sa8Api/kAjnbMVSP0ASSd/BdI87KRcg7QPkHSD1xzye9fmNh58Z9YgFy/OHczm/nO//wsujUHYBwYAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f8 ?f11 ?f9 ?f12" svg:viewBox="0 0 0 0" draw:type="ooxml-star4" draw:modifiers="12500" draw:enhanced-path="M 0 ?f10 L ?f8 ?f11 ?f7 0 ?f9 ?f11 ?f15 ?f10 ?f9 ?f12 ?f7 ?f14 ?f8 ?f12 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /50000"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 *?f0 /50000"></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f6" draw:formula="?f4 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f5 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f5 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f10 +0-?f6 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f10 +?f6 -0"></draw:equation><draw:equation draw:name="f13" draw:formula="?f10 +0-?f4 "></draw:equation><draw:equation draw:name="f14" draw:formula="logheight"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f7 ?f13" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_star4("ooxml-star4", "H4sIAAAAAAAAAK2VXW+DIBSG/wohu2i7koKzX0udya63/YDdkQpKotIh/dqvH8Js1+KW0CxGc5Dj874HPLrKFN0/srqg9ZplKGeyYlodgb1dCaWkQoVU4lPWmpYJ5LRsGLyY3jGlxfp6UrODRlQx2iQw5QuQckLMZdkGEQTNLn/cCbZ/locEYmCP7snjhiVQykNVokZTFXdyMhNcMGWAJJriLv3kfUN1kcBXQzISGLyAH7Jze3fZDcnU5XR+bIYJ4u6ZCLyDN/i0cgofW6qFrJ1eTStjj3fyXKpqW9IECj7A6A6DMR6b0PjDbtiedjQcGuDkgviXALkWKGW+F5kuJlEQJ7rmmPLAKOUYTKytINhDj6mCibzQga5i39XDza6mPiwCo7VsBhsxGkRzbJd/QvDCRUHwmQ+PwagR9X/A5/+0yQvf5BzcY5TyKQgCLXtBLQaF7QnxGuTWV4V4nWB711Y3C6uO9DUDbuubBdfntcLZVRzoymuG01KFcbw+6N6m3zDmy5mVDPyI0UY2os1wO5+e6/yeV7TOGTqiih5Eta0S6Nq1P0fULue8tC7jZOf6v/P0BcR8clmQBgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f24 ?f28 ?f27 ?f30" svg:viewBox="0 0 0 0" draw:type="ooxml-star5" draw:modifiers="19098 105146 110557" draw:enhanced-path="M ?f12 ?f16 L ?f25 ?f28 ?f11 0 ?f26 ?f28 ?f15 ?f16 ?f27 ?f29 ?f14 ?f17 ?f11 ?f30 ?f13 ?f17 ?f24 ?f29 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *$1 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 *$2 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 *$2 /100000"></draw:equation><draw:equation draw:name="f7" draw:formula="?f2 *cos(pi*(1080000)/10800000)"></draw:equation><draw:equation draw:name="f8" draw:formula="?f2 *cos(pi*(18360000)/10800000)"></draw:equation><draw:equation draw:name="f9" draw:formula="?f4 *sin(pi*(1080000)/10800000)"></draw:equation><draw:equation draw:name="f10" draw:formula="?f4 *sin(pi*(18360000)/10800000)"></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f12" draw:formula="?f11 +0-?f7 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f11 +0-?f8 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f11 +?f8 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="?f11 +?f7 -0"></draw:equation><draw:equation draw:name="f16" draw:formula="?f6 +0-?f9 "></draw:equation><draw:equation draw:name="f17" draw:formula="?f6 +0-?f10 "></draw:equation><draw:equation draw:name="f18" draw:formula="?f2 *?f0 /50000"></draw:equation><draw:equation draw:name="f19" draw:formula="?f4 *?f0 /50000"></draw:equation><draw:equation draw:name="f20" draw:formula="?f18 *cos(pi*(20520000)/10800000)"></draw:equation><draw:equation draw:name="f21" draw:formula="?f18 *cos(pi*(3240000)/10800000)"></draw:equation><draw:equation draw:name="f22" draw:formula="?f19 *sin(pi*(3240000)/10800000)"></draw:equation><draw:equation draw:name="f23" draw:formula="?f19 *sin(pi*(20520000)/10800000)"></draw:equation><draw:equation draw:name="f24" draw:formula="?f11 +0-?f20 "></draw:equation><draw:equation draw:name="f25" draw:formula="?f11 +0-?f21 "></draw:equation><draw:equation draw:name="f26" draw:formula="?f11 +?f21 -0"></draw:equation><draw:equation draw:name="f27" draw:formula="?f11 +?f20 -0"></draw:equation><draw:equation draw:name="f28" draw:formula="?f6 +0-?f22 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f6 +0-?f23 "></draw:equation><draw:equation draw:name="f30" draw:formula="?f6 +?f19 -0"></draw:equation><draw:equation draw:name="f31" draw:formula="?f6 +0-?f19 "></draw:equation><draw:handle draw:handle-position="?f11 ?f31" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_star5("ooxml-star5", "H4sIAAAAAAAAAK2W227iMBRFf8WK+kCZRvg45FY1RerzzHzAvFngEEtJTJ1w69ePnQsUYiqZAMI4yWF5n8gr4m0l6f6VlRktl2zlrpkoWC2PqDldcCmFdDMh+Zcoa5onTkrzijkXl3dM1nx5fbFmh9qlktEqcRYpmSM1RHoI1eBhB1W79euOs/2HOCQORs27/+1xwxJHiEORu1VNpd8vKFY85UwqJMQ4jhBgH+YBAvXth13RqZcNrbPE+aOWA6KHAP3W6/t9EgC1pJoHpxN+W9aFJLE+1MEhbMt1cD3z+nNtWzH6h/4672/t8p9bWnNRtmFKWqhO0r6xVMhim9PE4ekEu08YveAXNfWxejWH+tMcPT8r4OyC+NMCcL1ALtZ7vqqzGbHikGuOahRNnwDNQKfCVjDPECpjfJ3Vlqnmw1SeSkXuSuU/KlUwTOXfnSocwgiaLkU12fDpBHDUbIpZN8F2uyP6GR55wRh6PKTP0bTi5SOiw0CdS/rI7PAoccBkDqBf2F2kIbJDDbw5oyJLlMEcjdIg126DwsCbHhVaowzmBG1/sWV/Bm06EmBLlFmSRYrRzLfWGcxS3EkjBgkgOhtMsE/GWEAGFlzyPTIfhTe5EZ8lHos3+fINP/ru3JBI7zJiucvIDYsaFliyDBq1RiqSpZLEIFLHwtYsg0mdlIRYtmjQqEd5dijP4FCgG1RbxbJBz6BL/9S5/QBT/0pXOUPf5u5GVFxXdHd7cSZ3BZKWa+Ye3YIeeLEtEqd9dphreNnWnJtpK055rv/kv/8HJbJgIP0LAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f14 ?f19 ?f17 ?f20" svg:viewBox="0 0 0 0" draw:type="ooxml-star6" draw:modifiers="28868 115470" draw:enhanced-path="M ?f5 ?f8 L ?f15 ?f19 ?f4 0 ?f16 ?f19 ?f6 ?f8 ?f17 ?f7 ?f6 ?f9 ?f16 ?f20 ?f4 ?f22 ?f15 ?f20 ?f5 ?f9 ?f14 ?f7 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *$1 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *cos(pi*(1800000)/10800000)"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f5" draw:formula="?f4 +0-?f3 "></draw:equation><draw:equation draw:name="f6" draw:formula="?f4 +?f3 -0"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight/4"></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f8 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="?f2 *?f0 /50000"></draw:equation><draw:equation draw:name="f11" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f12" draw:formula="?f11 *?f0 /50000"></draw:equation><draw:equation draw:name="f13" draw:formula="?f10 *1/2"></draw:equation><draw:equation draw:name="f14" draw:formula="?f4 +0-?f10 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f4 +0-?f13 "></draw:equation><draw:equation draw:name="f16" draw:formula="?f4 +?f13 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="?f4 +?f10 -0"></draw:equation><draw:equation draw:name="f18" draw:formula="?f12 *sin(pi*(3600000)/10800000)"></draw:equation><draw:equation draw:name="f19" draw:formula="?f7 +0-?f18 "></draw:equation><draw:equation draw:name="f20" draw:formula="?f7 +?f18 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="?f7 +0-?f12 "></draw:equation><draw:equation draw:name="f22" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f4 ?f21" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_star6("ooxml-star6", "H4sIAAAAAAAAAK2W247bIBRFfwWheUjSQQHiW0bjidTnth/QNxRjG8k2KSa3fn0xDkknOCMxbSIjMIfFPngfJ6+FYscX3tWs2/ICVVy2XKszsLdboZRUqJZK/JadZk0OS9b0HL6bPnClxfZ+UvOTRkxx1udwU5IImGY9NKlpKIagP1QvB8GPX+UphxjYr1t73vEcSnlqG9RrphK3oSxEKbgySJplSQYIiaPUrbomsWO6zuF3s09srgx8G7aNnYDIbGS6iRsnNuYiLL3cWLsQiu0S06GOYm/FLiiyq36CH/DtdZTxa8+0kN0oqmOtSaV0Gkup2n3DcijKGUZPGDzjZ9ONsfnY4XDZ0XxugMt3xI82IPcbNLI6ikLXSxrEofcckyJYPBGwJIMqHARb+TAKFlvZz3ZiMSOZJc4N+dILgkf/KePYFxmBLxhtyhUIAiWToAGDwo4tncis5qKqdWBq2WNQFARa+6mlQ2pZaGrEKwRriU2JwTIO9heZcv2nTopM+Z58XtiE8wkGCxIqyzP51ZwGF4Z67HMSaHTyyOkk2OrE87pD4WCU53ZDMd7qRWdfN6vkn143ZLoG7PllYedHJ4rAlhMJrifqVcBNFQ1U5ZXAtZgecczvbdFw8Fcf7WQvhojxQW5uAi/zinUVR2fUspNo920Ox+KajhHdGHM7kzHiKuf+b8vbH4edXVzPCAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f29 ?f37 ?f32 ?f39" svg:viewBox="0 0 0 0" draw:type="ooxml-star7" draw:modifiers="34601 102572 105210" draw:enhanced-path="M ?f14 ?f21 L ?f28 ?f38 ?f15 ?f20 ?f30 ?f37 ?f13 0 ?f31 ?f37 ?f18 ?f20 ?f33 ?f38 ?f19 ?f21 ?f32 ?f39 ?f17 ?f22 ?f13 ?f40 ?f16 ?f22 ?f29 ?f39 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *$1 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 *$2 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 *$2 /100000"></draw:equation><draw:equation draw:name="f7" draw:formula="?f2 *97493/100000"></draw:equation><draw:equation draw:name="f8" draw:formula="?f2 *78183/100000"></draw:equation><draw:equation draw:name="f9" draw:formula="?f2 *43388/100000"></draw:equation><draw:equation draw:name="f10" draw:formula="?f4 *62349/100000"></draw:equation><draw:equation draw:name="f11" draw:formula="?f4 *22252/100000"></draw:equation><draw:equation draw:name="f12" draw:formula="?f4 *90097/100000"></draw:equation><draw:equation draw:name="f13" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f14" draw:formula="?f13 +0-?f7 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f13 +0-?f8 "></draw:equation><draw:equation draw:name="f16" draw:formula="?f13 +0-?f9 "></draw:equation><draw:equation draw:name="f17" draw:formula="?f13 +?f9 -0"></draw:equation><draw:equation draw:name="f18" draw:formula="?f13 +?f8 -0"></draw:equation><draw:equation draw:name="f19" draw:formula="?f13 +?f7 -0"></draw:equation><draw:equation draw:name="f20" draw:formula="?f6 +0-?f10 "></draw:equation><draw:equation draw:name="f21" draw:formula="?f6 +?f11 -0"></draw:equation><draw:equation draw:name="f22" draw:formula="?f6 +?f12 -0"></draw:equation><draw:equation draw:name="f23" draw:formula="?f2 *?f0 /50000"></draw:equation><draw:equation draw:name="f24" draw:formula="?f4 *?f0 /50000"></draw:equation><draw:equation draw:name="f25" draw:formula="?f23 *97493/100000"></draw:equation><draw:equation draw:name="f26" draw:formula="?f23 *78183/100000"></draw:equation><draw:equation draw:name="f27" draw:formula="?f23 *43388/100000"></draw:equation><draw:equation draw:name="f28" draw:formula="?f13 +0-?f25 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f13 +0-?f26 "></draw:equation><draw:equation draw:name="f30" draw:formula="?f13 +0-?f27 "></draw:equation><draw:equation draw:name="f31" draw:formula="?f13 +?f27 -0"></draw:equation><draw:equation draw:name="f32" draw:formula="?f13 +?f26 -0"></draw:equation><draw:equation draw:name="f33" draw:formula="?f13 +?f25 -0"></draw:equation><draw:equation draw:name="f34" draw:formula="?f24 *90097/100000"></draw:equation><draw:equation draw:name="f35" draw:formula="?f24 *22252/100000"></draw:equation><draw:equation draw:name="f36" draw:formula="?f24 *62349/100000"></draw:equation><draw:equation draw:name="f37" draw:formula="?f6 +0-?f34 "></draw:equation><draw:equation draw:name="f38" draw:formula="?f6 +0-?f35 "></draw:equation><draw:equation draw:name="f39" draw:formula="?f6 +?f36 -0"></draw:equation><draw:equation draw:name="f40" draw:formula="?f6 +?f24 -0"></draw:equation><draw:equation draw:name="f41" draw:formula="?f6 +0-?f24 "></draw:equation><draw:handle draw:handle-position="?f13 ?f41" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_star7("ooxml-star7", "H4sIAAAAAAAAAK2X247bIBCGXwVZe9FN1woMPq7WG6nXbR+gd2iDYyQfUsc59ekLJvZ248lKOE0UbDB8/KD5h/hl3Yrjs6wLUb/Jtb+RTSW79kz65kq1bdP6RdOqP03diTLzclHupPfh8UG2nXq7ftjJU+eLVopd5q1ySMkq57EpwBSpR3aHzfNByeO35pR5lPTfYex5KzOvaU5V6e860cbDhM1a5Uq2GsmDiDLCKIQx6EsIbBg8rmUruiLzfujpWKALYOS7uSRmflOw0FSpqdJBHeOkv2djQzJ24uPA1OLGxZg20xnAIlZ5YEawaGizy0/JL/LTe32xMn/vRaea2oquRaVXnA9ryJu22pci81T+hfoPlDzRJ30bUv3pq+bX1x4fNXD5gfjZBOx6grLZHNW6K5bgxIFrjl4tWTwwsmRGFXWCcURUIdWm6BxVBVNVXKuCWarC/6UqmqoKZ6uKpzAgizQOUj4Hl6C4OGHJLFyK4gLOk2QOjk38oJ1FFhHwIJ3Fm4R/zwOAEGbxEBtoXkppGs/iYU6YY0+GOEHnpa/UX+UxcUNNfPCOShxRiBMGVOqIQnxgUAbkO2464gGLSpxRSPxbVOyKAiT0I7tVjLrtFSBRHxlRjDmrQgLeosAZNYn1PlesckqWobNzAAn4YD4NiXngd6RZQCLfAGcnWsDOAX5HqoUbLjABB6FjwN2wQc+K3Fgc8cHIckxlHDGCtSc4+5Nj/4AsK3JmIVa4sEJnFmIEuOdM4pgX7jk0OeaFe051jnjhkip54BghiAsGlKMJOGKCPlVy5/gI8LOg3zZXFH4W9G66vVf6hWpdSvLPvb9tdsr0uMTq6p186dCKeiP9s1+Jk6r2VebZNIz3UbXt874Y22PUc/1++voX4ljCobgOAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f17 ?f21 ?f20 ?f24" svg:viewBox="0 0 0 0" draw:type="ooxml-star8" draw:modifiers="37500" draw:enhanced-path="M 0 ?f8 L ?f17 ?f22 ?f4 ?f9 ?f18 ?f21 ?f3 0 ?f19 ?f21 ?f5 ?f9 ?f20 ?f22 ?f26 ?f8 ?f20 ?f23 ?f5 ?f10 ?f19 ?f24 ?f3 ?f27 ?f18 ?f24 ?f4 ?f10 ?f17 ?f23 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 +0-?f2 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f3 +?f2 -0"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 +0-?f7 "></draw:equation><draw:equation draw:name="f10" draw:formula="?f8 +?f7 -0"></draw:equation><draw:equation draw:name="f11" draw:formula="?f1 *?f0 /50000"></draw:equation><draw:equation draw:name="f12" draw:formula="?f6 *?f0 /50000"></draw:equation><draw:equation draw:name="f13" draw:formula="?f11 *92388/100000"></draw:equation><draw:equation draw:name="f14" draw:formula="?f11 *38268/100000"></draw:equation><draw:equation draw:name="f15" draw:formula="?f12 *92388/100000"></draw:equation><draw:equation draw:name="f16" draw:formula="?f12 *38268/100000"></draw:equation><draw:equation draw:name="f17" draw:formula="?f3 +0-?f13 "></draw:equation><draw:equation draw:name="f18" draw:formula="?f3 +0-?f14 "></draw:equation><draw:equation draw:name="f19" draw:formula="?f3 +?f14 -0"></draw:equation><draw:equation draw:name="f20" draw:formula="?f3 +?f13 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="?f8 +0-?f15 "></draw:equation><draw:equation draw:name="f22" draw:formula="?f8 +0-?f16 "></draw:equation><draw:equation draw:name="f23" draw:formula="?f8 +?f16 -0"></draw:equation><draw:equation draw:name="f24" draw:formula="?f8 +?f15 -0"></draw:equation><draw:equation draw:name="f25" draw:formula="?f8 +0-?f12 "></draw:equation><draw:equation draw:name="f26" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f27" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f3 ?f25" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_star8("ooxml-star8", "H4sIAAAAAAAAAK2W246bMBRFf8Wy+pBJB8U214yGidTnth/QNysYsAQ4Y8itX19fIOkEt5IzEQLZ5nh5H3w28FpIenxhXU27LSuCiomWDfIMzHDLpRQyqIXkv0U30CaHJW16Bj/cPjA58O3tzYGdhoBKRvscbkqcgk1JsL4gfYkg6A/Vy4Gz4zdxyiEC5pjmnncsh0Kc2iboByqzaUFR8JIzqZBhGqMp/KJ+R4c6hz+AXiID38G0LlGXSJ1rPZJNSkITh9dTPx4jrEI9hyQGNA2FYxC+zosMRzXSCzoaF7NRqZ34C/yEb69W7fueDlx0VntHW5VqOaVSCtnuG5pDXi5Q8AWBZ/SsmipXZLv6NL2nJwVcfSD+bwF8u0AjqiMvhnpFvDjklqNyBMut6Bc7vlyQFBltK4wy2/KChw8SGc1FhuArCtRWAC9Q7ARpTIC8QIkjs5rxqh48U0vnihKw7Hn3iOefPUrleq4ysxuQ+m0AnhnDkDTHcwfwzAGmcjclAitjKD+awwfJ/bRZ4SttStyahFmm9tIf6HCABoYZSe4DOpyAyWcUzhxhgfcrdDhjND0OPYtu5oMrKvJEOZxg3iAK5FnAxGEFiwq9UQ4vjP7EsV+CxGGECZV4ohwuMF5XIN8EHfVvUbE3ylH5U4KeXxPi+gqY75sfZlbpl9f0vzjq/6hoGPirHexEz3WELaPNNc/xvqRdxYJz0NITb/dtDu1rzR3DOxtzfbQ24iLn9v/y7Q+ipUk9eAoAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f25 ?f31 ?f28 ?f32" svg:viewBox="0 0 0 0" draw:type="ooxml-star10" draw:modifiers="42533 105146" draw:enhanced-path="M ?f6 ?f15 L ?f25 ?f31 ?f7 ?f14 ?f26 ?f30 ?f5 0 ?f27 ?f30 ?f8 ?f14 ?f28 ?f31 ?f9 ?f15 ?f29 ?f13 ?f9 ?f16 ?f28 ?f32 ?f8 ?f17 ?f27 ?f33 ?f5 ?f35 ?f26 ?f33 ?f7 ?f17 ?f25 ?f32 ?f6 ?f16 ?f24 ?f13 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *$1 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *95106/100000"></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 *58779/100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 +0-?f3 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f5 +0-?f4 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f5 +?f4 -0"></draw:equation><draw:equation draw:name="f9" draw:formula="?f5 +?f3 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f10 *80902/100000"></draw:equation><draw:equation draw:name="f12" draw:formula="?f10 *30902/100000"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f14" draw:formula="?f13 +0-?f11 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f13 +0-?f12 "></draw:equation><draw:equation draw:name="f16" draw:formula="?f13 +?f12 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="?f13 +?f11 -0"></draw:equation><draw:equation draw:name="f18" draw:formula="?f2 *?f0 /50000"></draw:equation><draw:equation draw:name="f19" draw:formula="?f10 *?f0 /50000"></draw:equation><draw:equation draw:name="f20" draw:formula="?f18 *80902/100000"></draw:equation><draw:equation draw:name="f21" draw:formula="?f18 *30902/100000"></draw:equation><draw:equation draw:name="f22" draw:formula="?f19 *95106/100000"></draw:equation><draw:equation draw:name="f23" draw:formula="?f19 *58779/100000"></draw:equation><draw:equation draw:name="f24" draw:formula="?f5 +0-?f18 "></draw:equation><draw:equation draw:name="f25" draw:formula="?f5 +0-?f20 "></draw:equation><draw:equation draw:name="f26" draw:formula="?f5 +0-?f21 "></draw:equation><draw:equation draw:name="f27" draw:formula="?f5 +?f21 -0"></draw:equation><draw:equation draw:name="f28" draw:formula="?f5 +?f20 -0"></draw:equation><draw:equation draw:name="f29" draw:formula="?f5 +?f18 -0"></draw:equation><draw:equation draw:name="f30" draw:formula="?f13 +0-?f22 "></draw:equation><draw:equation draw:name="f31" draw:formula="?f13 +0-?f23 "></draw:equation><draw:equation draw:name="f32" draw:formula="?f13 +?f23 -0"></draw:equation><draw:equation draw:name="f33" draw:formula="?f13 +?f22 -0"></draw:equation><draw:equation draw:name="f34" draw:formula="?f13 +0-?f19 "></draw:equation><draw:equation draw:name="f35" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f5 ?f34" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_star10("ooxml-star10", "H4sIAAAAAAAAAK2X226jMBCGX8VCvdhmi+IDDlCVRtrr3X2AvbMaEywBzjrktE+/tjmkDaaSSROBjG0+Zib/zJCXjWKnZ14XrH7jm3DLZcUbdQF2uhJKSRUWUol/sm5YmQU5K/c8+LB85KoRb7eLDT83IVOc7bNgnWMK1jlB+oQTM8IB2B+3z0fBTz/kOQsgsN/+3suOZ4GU56oM9w1TqF+o5EbkgivNjDAlBCBIUbTqVgcvdqwpsuCXftBKH4iCn+C9CbGZjMyUWSZQnygwZxz318mwJenvSluUnrIj0k+trk71N8YDi1i2HtDhcaS3IB6Mwr2llhW1+D/gd/D60jr298AaIevWzZpVOjp5H5NcqupQsiwQ+TcYPkDwBJ/0kEL9sZfmsFePjxq4/ED87AHo9gGl3J7EpimW2IuDbznaPbB4QGCJjFXQC0bGMAwWKUVwNQcXOXE0ieN0Do5+UchWY7Mo+A5DrRXgBYonQZEfKHGCDCb0C1E6ASK+IDRKAB3sgott0XhGG42UrhUKwSKBKcRzZIBcktdAMhs4kv1sXx2K18XGSgIhP02gkdzfsbAnyyF5w7IkX2U4VN+xkDfLIXxdIdY5BEvq/zs61G+EMROHRymgcckdwsWuTEjuEC52ZUJ6R8HGjgZggLNLNnYkRFcited+KEc+dCgMPVHTHQB7Zil29wAL8kwGPNUFtHu+qKk+oIPuiSKuLOjKEPYsQ8SVAD3Ls/cSl/ZtGcLezY64ZN+yvMsj+awFpJ4+ut542sY0xdHv6JuSg3fjcCf3wuxoRbC+WtitK1ZveXgJK3YW1aHKgrZUuveIut1zDUq7YzDn9r/O63/KsGsbBA0AAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f22 ?f28 ?f25 ?f31" svg:viewBox="0 0 0 0" draw:type="ooxml-star12" draw:modifiers="37500" draw:enhanced-path="M 0 ?f9 L ?f21 ?f29 ?f6 ?f34 ?f22 ?f28 ?f37 ?f10 ?f23 ?f27 ?f5 0 ?f24 ?f27 ?f7 ?f10 ?f25 ?f28 ?f8 ?f34 ?f26 ?f29 ?f35 ?f9 ?f26 ?f30 ?f8 ?f11 ?f25 ?f31 ?f7 ?f12 ?f24 ?f32 ?f5 ?f36 ?f23 ?f32 ?f37 ?f12 ?f22 ?f31 ?f6 ?f11 ?f21 ?f30 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *cos(pi*(1800000)/10800000)"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 *sin(pi*(3600000)/10800000)"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 +0-?f2 "></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth*3/4"></draw:equation><draw:equation draw:name="f8" draw:formula="?f5 +?f2 -0"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 +0-?f4 "></draw:equation><draw:equation draw:name="f11" draw:formula="logheight*3/4"></draw:equation><draw:equation draw:name="f12" draw:formula="?f9 +?f4 -0"></draw:equation><draw:equation draw:name="f13" draw:formula="?f1 *?f0 /50000"></draw:equation><draw:equation draw:name="f14" draw:formula="?f3 *?f0 /50000"></draw:equation><draw:equation draw:name="f15" draw:formula="?f13 *cos(pi*(900000)/10800000)"></draw:equation><draw:equation draw:name="f16" draw:formula="?f13 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f17" draw:formula="?f13 *cos(pi*(4500000)/10800000)"></draw:equation><draw:equation draw:name="f18" draw:formula="?f14 *sin(pi*(4500000)/10800000)"></draw:equation><draw:equation draw:name="f19" draw:formula="?f14 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f20" draw:formula="?f14 *sin(pi*(900000)/10800000)"></draw:equation><draw:equation draw:name="f21" draw:formula="?f5 +0-?f15 "></draw:equation><draw:equation draw:name="f22" draw:formula="?f5 +0-?f16 "></draw:equation><draw:equation draw:name="f23" draw:formula="?f5 +0-?f17 "></draw:equation><draw:equation draw:name="f24" draw:formula="?f5 +?f17 -0"></draw:equation><draw:equation draw:name="f25" draw:formula="?f5 +?f16 -0"></draw:equation><draw:equation draw:name="f26" draw:formula="?f5 +?f15 -0"></draw:equation><draw:equation draw:name="f27" draw:formula="?f9 +0-?f18 "></draw:equation><draw:equation draw:name="f28" draw:formula="?f9 +0-?f19 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f9 +0-?f20 "></draw:equation><draw:equation draw:name="f30" draw:formula="?f9 +?f20 -0"></draw:equation><draw:equation draw:name="f31" draw:formula="?f9 +?f19 -0"></draw:equation><draw:equation draw:name="f32" draw:formula="?f9 +?f18 -0"></draw:equation><draw:equation draw:name="f33" draw:formula="?f9 +0-?f14 "></draw:equation><draw:equation draw:name="f34" draw:formula="logheight/4"></draw:equation><draw:equation draw:name="f35" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f36" draw:formula="logheight"></draw:equation><draw:equation draw:name="f37" draw:formula="logwidth/4"></draw:equation><draw:handle draw:handle-position="?f5 ?f33" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_star12("ooxml-star12", "H4sIAAAAAAAAAK2X246bMBCGX8VCvcimi+IDkLBaNlKv2z5A76zEBEuAUyCnPn2NwSEJTqUpqygWhuHz72F+G963FT+9iTLj5UZs/Z1QhWiqCzKnC1lVqvIzVck/qmx4nngpz2vh3V0+iqqRm8eLjTg3Pq8ErxNvnVKKdLNqm1A3jHioPu7ejlKcvqlz4mFkfvbey14knlLnIvfrhleE2hHVVqZSVJrJliG28Vf5e95kifdDo9ZpjL63w5G2iXUTteMG6FYLW+qGtMGUtU3bDc3NNLD9ISS0t62upMjCWWhG7E8x3EcRMszYsqjFM2qG0weRVWBOsSGM2jujK4x0/F/op/fx3s3+94E3UpVdLkpe6NylNjWpqopDzhNPpjPsf8HoFb/qQ5073HXbv+m9vGjg4o74rwHI4wC52p3ktskWFMShjxw9UTTfqHq2l/MZWWGjbUFwfwSCM4fITMhd1gBVBmOVDM1rWRqVLJqkMvykVEZjkSH6in1dNQgEWj4TNGeLAERaOSW1gnwMAsWf9STJyBmtcU2WAliWiMsCnSZwnojDBnGbqACaKDKqeWOodYrRwvgcRnMX/v/SRpWutbHB7fEkGxFH/d/S6XIafuSKe3wQTsM7rEKCYY2Zih8Z6B4/MTnU4apb/LQnS0dOu65sJISZljqMZlEREOVwmkUtgSiHzcw6qUFA/1OHxzpUBEa5NxSTdCjKYZ5+1SUrYK4cRrGoGIhymKJHUQxDMfe2YkDAXDFHtRuUnh4U9Wxb0UmHohzVbtMO3DjZqNqHzRy2bbKnr04wzKjQr4JgnKcvTs/npb9ctrlAN8f+XtWyjej8th5S31+veLkT/sUv+FkWhyLxup3YHSPLLmZ42l3EVc7jp9/HX9p7LZcTDgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f51 ?f52 ?f53 ?f54" svg:viewBox="0 0 0 0" draw:type="ooxml-star16" draw:modifiers="37500" draw:enhanced-path="M 0 ?f16 L ?f33 ?f44 ?f10 ?f19 ?f34 ?f43 ?f11 ?f18 ?f35 ?f42 ?f12 ?f17 ?f36 ?f41 ?f9 0 ?f37 ?f41 ?f13 ?f17 ?f38 ?f42 ?f14 ?f18 ?f39 ?f43 ?f15 ?f19 ?f40 ?f44 ?f56 ?f16 ?f40 ?f45 ?f15 ?f20 ?f39 ?f46 ?f14 ?f21 ?f38 ?f47 ?f13 ?f22 ?f37 ?f48 ?f9 ?f57 ?f36 ?f48 ?f12 ?f22 ?f35 ?f47 ?f11 ?f21 ?f34 ?f46 ?f10 ?f20 ?f33 ?f45 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *92388/100000"></draw:equation><draw:equation draw:name="f3" draw:formula="?f1 *70711/100000"></draw:equation><draw:equation draw:name="f4" draw:formula="?f1 *38268/100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 *92388/100000"></draw:equation><draw:equation draw:name="f7" draw:formula="?f5 *70711/100000"></draw:equation><draw:equation draw:name="f8" draw:formula="?f5 *38268/100000"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 +0-?f2 "></draw:equation><draw:equation draw:name="f11" draw:formula="?f9 +0-?f3 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f9 +0-?f4 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f9 +?f4 -0"></draw:equation><draw:equation draw:name="f14" draw:formula="?f9 +?f3 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="?f9 +?f2 -0"></draw:equation><draw:equation draw:name="f16" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f17" draw:formula="?f16 +0-?f6 "></draw:equation><draw:equation draw:name="f18" draw:formula="?f16 +0-?f7 "></draw:equation><draw:equation draw:name="f19" draw:formula="?f16 +0-?f8 "></draw:equation><draw:equation draw:name="f20" draw:formula="?f16 +?f8 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="?f16 +?f7 -0"></draw:equation><draw:equation draw:name="f22" draw:formula="?f16 +?f6 -0"></draw:equation><draw:equation draw:name="f23" draw:formula="?f1 *?f0 /50000"></draw:equation><draw:equation draw:name="f24" draw:formula="?f5 *?f0 /50000"></draw:equation><draw:equation draw:name="f25" draw:formula="?f23 *98079/100000"></draw:equation><draw:equation draw:name="f26" draw:formula="?f23 *83147/100000"></draw:equation><draw:equation draw:name="f27" draw:formula="?f23 *55557/100000"></draw:equation><draw:equation draw:name="f28" draw:formula="?f23 *19509/100000"></draw:equation><draw:equation draw:name="f29" draw:formula="?f24 *98079/100000"></draw:equation><draw:equation draw:name="f30" draw:formula="?f24 *83147/100000"></draw:equation><draw:equation draw:name="f31" draw:formula="?f24 *55557/100000"></draw:equation><draw:equation draw:name="f32" draw:formula="?f24 *19509/100000"></draw:equation><draw:equation draw:name="f33" draw:formula="?f9 +0-?f25 "></draw:equation><draw:equation draw:name="f34" draw:formula="?f9 +0-?f26 "></draw:equation><draw:equation draw:name="f35" draw:formula="?f9 +0-?f27 "></draw:equation><draw:equation draw:name="f36" draw:formula="?f9 +0-?f28 "></draw:equation><draw:equation draw:name="f37" draw:formula="?f9 +?f28 -0"></draw:equation><draw:equation draw:name="f38" draw:formula="?f9 +?f27 -0"></draw:equation><draw:equation draw:name="f39" draw:formula="?f9 +?f26 -0"></draw:equation><draw:equation draw:name="f40" draw:formula="?f9 +?f25 -0"></draw:equation><draw:equation draw:name="f41" draw:formula="?f16 +0-?f29 "></draw:equation><draw:equation draw:name="f42" draw:formula="?f16 +0-?f30 "></draw:equation><draw:equation draw:name="f43" draw:formula="?f16 +0-?f31 "></draw:equation><draw:equation draw:name="f44" draw:formula="?f16 +0-?f32 "></draw:equation><draw:equation draw:name="f45" draw:formula="?f16 +?f32 -0"></draw:equation><draw:equation draw:name="f46" draw:formula="?f16 +?f31 -0"></draw:equation><draw:equation draw:name="f47" draw:formula="?f16 +?f30 -0"></draw:equation><draw:equation draw:name="f48" draw:formula="?f16 +?f29 -0"></draw:equation><draw:equation draw:name="f49" draw:formula="?f23 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f50" draw:formula="?f24 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f51" draw:formula="?f9 +0-?f49 "></draw:equation><draw:equation draw:name="f52" draw:formula="?f16 +0-?f50 "></draw:equation><draw:equation draw:name="f53" draw:formula="?f9 +?f49 -0"></draw:equation><draw:equation draw:name="f54" draw:formula="?f16 +?f50 -0"></draw:equation><draw:equation draw:name="f55" draw:formula="?f16 +0-?f24 "></draw:equation><draw:equation draw:name="f56" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f57" draw:formula="logheight"></draw:equation><draw:handle draw:handle-position="?f9 ?f55" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_star16("ooxml-star16", "H4sIAAAAAAAAAK2YW2+bMBTHvwpCe2i7ovjKpWoaac/bPsDeUAOJpQApoW26Tz9fYmcNh0qHtlEdMObnw59zsXO/7svXu6rdlu1jtU42VddUQ/8W2e5G9X3XJ9uuV3+7dih3y7gud4cqfnf5peoH9Xh5caiOQ1L2VXlYxqta0kg3zDTcNCKODi+buxdVvf7ojsuYRPbj733bV8u4647NLjkMZU9TP2O3VrWqes3kmSR+fDB/Xw7bZfxLo1Y1TaOf+oub+YQwHba3MH3mVJgL1NhFc9MnTZ+xkNomM32p6TNDCovkmT+nPIzJw30isIrAl35OQbwdMnXW+T7pxzES7k09j9EwR+bnZSzYklvbNPNsbu4fwQ2T4VYacCJMQcK03JnyJ/odP9w7VZ+ey0F1rdO4LRv9Tmoved31zfOuXMaqviLJNxLdklt9qN8Jcafm355dX2vg4h3xowno5QS7bvOq1sN2wVAcdsnRTxvdFIzn+YIauwgKx0FcRjJK5+AEiOM5S2dZJwHRtpXabAekaunYLvkJ1TIQN1u1HMTNVq34Ilejo6AwQfmdJDq2Ihxp5P2BxJEkwP9PJIEkAa6vSYaT4PSmgNdbEkeTRg5/IjE0aeTxc0OHAs6us7yVPEVKDji6R2VI1MjJz6gch2KAmxuUASFVZ4CfO1SGRkGJ3qJSNApO8quaRAuJzi4M8HY5nwZ4POM6NeckK+YkPwakegPMORXZLCDg/wYo9d88IBAFBkgLSeY9MhALTHxCQw5EhAHO1pADcWGAszXkQHQY4GwNOVwNbK2TuHzC4XJgUciEyeF6YFHIhMmBuPAoZMLkQES4KoVOmByIBYdCJ0wORIFDoROmgBc+1hWwqImKYHUvcLqLiZJgl1EEyYJqgmdRJAta9XsWcqUoAI93ZY+j10ACcPkTi6JZE6sgqzyWNbEMsh6BZUG5XxeTx+5wtVc3VyyzufBa58TcHeE2YBOV4KDaL8FP7wsEMjjkB8EhkcEhJ7cG6PcjJ2LDGoVlTcSGzSXI3Y+E9gd2k4jDjMIibDOmONuyXe+q6L/jZN8dlBnhdF6dH/R0vS/bTZW8JU15VM1zs4zdOhMeo1o35qytGxHMufxN8OEf9Q+pxiwUAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f77 ?f78 ?f79 ?f80" svg:viewBox="0 0 0 0" draw:type="ooxml-star24" draw:modifiers="37500" draw:enhanced-path="M 0 ?f26 L ?f51 ?f68 ?f16 ?f31 ?f52 ?f67 ?f17 ?f30 ?f53 ?f66 ?f18 ?f29 ?f54 ?f65 ?f19 ?f28 ?f55 ?f64 ?f20 ?f27 ?f56 ?f63 ?f15 0 ?f57 ?f63 ?f21 ?f27 ?f58 ?f64 ?f22 ?f28 ?f59 ?f65 ?f23 ?f29 ?f60 ?f66 ?f24 ?f30 ?f61 ?f67 ?f25 ?f31 ?f62 ?f68 ?f84 ?f26 ?f62 ?f69 ?f25 ?f32 ?f61 ?f70 ?f24 ?f33 ?f60 ?f71 ?f23 ?f34 ?f59 ?f72 ?f22 ?f35 ?f58 ?f73 ?f21 ?f36 ?f57 ?f74 ?f15 ?f83 ?f56 ?f74 ?f20 ?f36 ?f55 ?f73 ?f19 ?f35 ?f54 ?f72 ?f18 ?f34 ?f53 ?f71 ?f17 ?f33 ?f52 ?f70 ?f16 ?f32 ?f51 ?f69 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *cos(pi*(900000)/10800000)"></draw:equation><draw:equation draw:name="f3" draw:formula="?f1 *cos(pi*(1800000)/10800000)"></draw:equation><draw:equation draw:name="f4" draw:formula="?f1 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/4"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f1 *cos(pi*(4500000)/10800000)"></draw:equation><draw:equation draw:name="f8" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 *sin(pi*(4500000)/10800000)"></draw:equation><draw:equation draw:name="f10" draw:formula="?f8 *sin(pi*(3600000)/10800000)"></draw:equation><draw:equation draw:name="f11" draw:formula="?f8 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f12" draw:formula="logheight/4"></draw:equation><draw:equation draw:name="f13" draw:formula="?f12 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f8 *sin(pi*(900000)/10800000)"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f16" draw:formula="?f15 +0-?f2 "></draw:equation><draw:equation draw:name="f17" draw:formula="?f15 +0-?f3 "></draw:equation><draw:equation draw:name="f18" draw:formula="?f15 +0-?f4 "></draw:equation><draw:equation draw:name="f19" draw:formula="?f15 +0-?f6 "></draw:equation><draw:equation draw:name="f20" draw:formula="?f15 +0-?f7 "></draw:equation><draw:equation draw:name="f21" draw:formula="?f15 +?f7 -0"></draw:equation><draw:equation draw:name="f22" draw:formula="?f15 +?f6 -0"></draw:equation><draw:equation draw:name="f23" draw:formula="?f15 +?f4 -0"></draw:equation><draw:equation draw:name="f24" draw:formula="?f15 +?f3 -0"></draw:equation><draw:equation draw:name="f25" draw:formula="?f15 +?f2 -0"></draw:equation><draw:equation draw:name="f26" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f27" draw:formula="?f26 +0-?f9 "></draw:equation><draw:equation draw:name="f28" draw:formula="?f26 +0-?f10 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f26 +0-?f11 "></draw:equation><draw:equation draw:name="f30" draw:formula="?f26 +0-?f13 "></draw:equation><draw:equation draw:name="f31" draw:formula="?f26 +0-?f14 "></draw:equation><draw:equation draw:name="f32" draw:formula="?f26 +?f14 -0"></draw:equation><draw:equation draw:name="f33" draw:formula="?f26 +?f13 -0"></draw:equation><draw:equation draw:name="f34" draw:formula="?f26 +?f11 -0"></draw:equation><draw:equation draw:name="f35" draw:formula="?f26 +?f10 -0"></draw:equation><draw:equation draw:name="f36" draw:formula="?f26 +?f9 -0"></draw:equation><draw:equation draw:name="f37" draw:formula="?f1 *?f0 /50000"></draw:equation><draw:equation draw:name="f38" draw:formula="?f8 *?f0 /50000"></draw:equation><draw:equation draw:name="f39" draw:formula="?f37 *99144/100000"></draw:equation><draw:equation draw:name="f40" draw:formula="?f37 *92388/100000"></draw:equation><draw:equation draw:name="f41" draw:formula="?f37 *79335/100000"></draw:equation><draw:equation draw:name="f42" draw:formula="?f37 *60876/100000"></draw:equation><draw:equation draw:name="f43" draw:formula="?f37 *38268/100000"></draw:equation><draw:equation draw:name="f44" draw:formula="?f37 *13053/100000"></draw:equation><draw:equation draw:name="f45" draw:formula="?f38 *99144/100000"></draw:equation><draw:equation draw:name="f46" draw:formula="?f38 *92388/100000"></draw:equation><draw:equation draw:name="f47" draw:formula="?f38 *79335/100000"></draw:equation><draw:equation draw:name="f48" draw:formula="?f38 *60876/100000"></draw:equation><draw:equation draw:name="f49" draw:formula="?f38 *38268/100000"></draw:equation><draw:equation draw:name="f50" draw:formula="?f38 *13053/100000"></draw:equation><draw:equation draw:name="f51" draw:formula="?f15 +0-?f39 "></draw:equation><draw:equation draw:name="f52" draw:formula="?f15 +0-?f40 "></draw:equation><draw:equation draw:name="f53" draw:formula="?f15 +0-?f41 "></draw:equation><draw:equation draw:name="f54" draw:formula="?f15 +0-?f42 "></draw:equation><draw:equation draw:name="f55" draw:formula="?f15 +0-?f43 "></draw:equation><draw:equation draw:name="f56" draw:formula="?f15 +0-?f44 "></draw:equation><draw:equation draw:name="f57" draw:formula="?f15 +?f44 -0"></draw:equation><draw:equation draw:name="f58" draw:formula="?f15 +?f43 -0"></draw:equation><draw:equation draw:name="f59" draw:formula="?f15 +?f42 -0"></draw:equation><draw:equation draw:name="f60" draw:formula="?f15 +?f41 -0"></draw:equation><draw:equation draw:name="f61" draw:formula="?f15 +?f40 -0"></draw:equation><draw:equation draw:name="f62" draw:formula="?f15 +?f39 -0"></draw:equation><draw:equation draw:name="f63" draw:formula="?f26 +0-?f45 "></draw:equation><draw:equation draw:name="f64" draw:formula="?f26 +0-?f46 "></draw:equation><draw:equation draw:name="f65" draw:formula="?f26 +0-?f47 "></draw:equation><draw:equation draw:name="f66" draw:formula="?f26 +0-?f48 "></draw:equation><draw:equation draw:name="f67" draw:formula="?f26 +0-?f49 "></draw:equation><draw:equation draw:name="f68" draw:formula="?f26 +0-?f50 "></draw:equation><draw:equation draw:name="f69" draw:formula="?f26 +?f50 -0"></draw:equation><draw:equation draw:name="f70" draw:formula="?f26 +?f49 -0"></draw:equation><draw:equation draw:name="f71" draw:formula="?f26 +?f48 -0"></draw:equation><draw:equation draw:name="f72" draw:formula="?f26 +?f47 -0"></draw:equation><draw:equation draw:name="f73" draw:formula="?f26 +?f46 -0"></draw:equation><draw:equation draw:name="f74" draw:formula="?f26 +?f45 -0"></draw:equation><draw:equation draw:name="f75" draw:formula="?f37 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f76" draw:formula="?f38 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f77" draw:formula="?f15 +0-?f75 "></draw:equation><draw:equation draw:name="f78" draw:formula="?f26 +0-?f76 "></draw:equation><draw:equation draw:name="f79" draw:formula="?f15 +?f75 -0"></draw:equation><draw:equation draw:name="f80" draw:formula="?f26 +?f76 -0"></draw:equation><draw:equation draw:name="f81" draw:formula="?f26 +0-?f38 "></draw:equation><draw:equation draw:name="f82" draw:formula="min(logwidth,logheight)/2"></draw:equation><draw:equation draw:name="f83" draw:formula="logheight"></draw:equation><draw:equation draw:name="f84" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f15 ?f81" draw:handle-range-y-maximum="?f82" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_star24("ooxml-star24", "H4sIAAAAAAAAAK2Z226cMBCGXwWhXiRpUHy2qbqN1Ou2D9A7lGV3kRZIWXLq09c2a9KEMdJAFIUsrPk89vxjzzhft13x9KVsDkVzV26zfdnWZd+9JP5xXXVd22WHtqv+tk1fHDfprjieyvTN149l11d377/sy+c+K7qyOG3S253Wib0Yd8ntxZA0OT3uvzxW5dP39nmTksT/hHdf7stN2rbP9TE79UXHROix3Va7quwsk2tJQvvR/PuiP2zSnxZ1u2Mq+WH/SGovyvVMlb1wdyuZe+ZMou7CXXPJ3TPXhLrGzJkphXsm3TN3y9wX0t0q9wXzvTiAdK8pB6DS9y11eMDo2MiML7IRlocOGA+dKhIMYSIYp2gwmMkwCMXCwIwYhhue5WM7Ft7VZOTx0IemoV8ugi2aBfu4DDbrcRxchbFpMQzWds7DBOhxUoZ2MrzrJ2/gidCHn+ShXx5sGZzBg4O8zYPT2OjIPPmd/Eq/fR38/ueh6Ku2GVTQFLVVzS6IYtd29cOx2KTV7oJkn0hyTa7tR6saMty6X393eWmBN2+Icx3Q9x0c2/1Tte0PNwzFYe85drTJ1V17urivri5y4k27ocQMn1BsPsumZhVczMKZXgWX0dkVKI6aGikTFEHPDlPIVcM0wDAPZbU/9EgV5VMrTXJ1qpqPsJJOgukNnat19EkkvaGvFBKdxNfrFOOkRKFoYjgxUSBo/hvrumin8aDBiYkCUWNX+c8ksys7csBQ+JxRHImaBMsrSiBRQLgElMKhGBAbAaWRKCAQHMqBMoJDQbuKRyk0CpK9Rwk0CtoyPIqjUROtBxRDoyZqX7oIM0DsNiHzWsiRWgDEHlCUIFmA2kcWxbE4IPeRhQxoDuh9ZCEjmgOCdyxPQgqCA4o/s9A65YDkzyyKZgGaP7MImgUs8QMrR6PgDOl2R5Ibn3fgaIDwzXIaIH2uk6s8p0LYbRYNFID+PZBxYxYBgSBwQJ1zLhcBgUhwQEWMVouAQDg4IDdMLRsyEBMOSDmRfBEQCAxu1ngZiA4PXOxlIEYccLmXgTBxwOVehiLFrPCyhCLFrPCyjKRHPpVEbq8ykh/5XBK5vcpIguRZyO1VRjIkz0Km3jKSInkWcquWMxWBQG7VMlISeBJy75GRmsCPEMuKFAV+5pEsFakKvCKwrGhZINDbvorWBRy976tImuQ1gTxkUZE0ybOQFZmKpEmehSzJVCRN8iyDZM1UBwK5fqmZ8kAi1y8VKQ88CakJHSkP/AixrEh54Gcey4qWBwJdW+toeSDQxbWOlgc2grAsKAvSH3YiqyM50Qed0+mZgyKNPbKdiQ6NXE10dFfQaA+ZaHRotHLMTPHMkSuTmURHbZ0aDg+vx+OQS+R5iJlEyojCcSZREmyLYQ5Fsz2WyX+fs/v2VLkWZwfevs7guUFXNPsye8nq4rmqH2pfeLJIk6oZmrz6bGgxmvP+P6nf/gE2M06WYh0AAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f99 ?f100 ?f101 ?f102" svg:viewBox="0 0 0 0" draw:type="ooxml-star32" draw:modifiers="37500" draw:enhanced-path="M 0 ?f32 L ?f65 ?f88 ?f18 ?f39 ?f66 ?f87 ?f19 ?f38 ?f67 ?f86 ?f20 ?f37 ?f68 ?f85 ?f21 ?f36 ?f69 ?f84 ?f22 ?f35 ?f70 ?f83 ?f23 ?f34 ?f71 ?f82 ?f24 ?f33 ?f72 ?f81 ?f17 0 ?f73 ?f81 ?f25 ?f33 ?f74 ?f82 ?f26 ?f34 ?f75 ?f83 ?f27 ?f35 ?f76 ?f84 ?f28 ?f36 ?f77 ?f85 ?f29 ?f37 ?f78 ?f86 ?f30 ?f38 ?f79 ?f87 ?f31 ?f39 ?f80 ?f88 ?f106 ?f32 ?f80 ?f89 ?f31 ?f40 ?f79 ?f90 ?f30 ?f41 ?f78 ?f91 ?f29 ?f42 ?f77 ?f92 ?f28 ?f43 ?f76 ?f93 ?f27 ?f44 ?f75 ?f94 ?f26 ?f45 ?f74 ?f95 ?f25 ?f46 ?f73 ?f96 ?f17 ?f105 ?f72 ?f96 ?f24 ?f46 ?f71 ?f95 ?f23 ?f45 ?f70 ?f94 ?f22 ?f44 ?f69 ?f93 ?f21 ?f43 ?f68 ?f92 ?f20 ?f42 ?f67 ?f91 ?f19 ?f41 ?f66 ?f90 ?f18 ?f40 ?f65 ?f89 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *98079/100000"></draw:equation><draw:equation draw:name="f3" draw:formula="?f1 *92388/100000"></draw:equation><draw:equation draw:name="f4" draw:formula="?f1 *83147/100000"></draw:equation><draw:equation draw:name="f5" draw:formula="?f1 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f6" draw:formula="?f1 *55557/100000"></draw:equation><draw:equation draw:name="f7" draw:formula="?f1 *38268/100000"></draw:equation><draw:equation draw:name="f8" draw:formula="?f1 *19509/100000"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f10" draw:formula="?f9 *98079/100000"></draw:equation><draw:equation draw:name="f11" draw:formula="?f9 *92388/100000"></draw:equation><draw:equation draw:name="f12" draw:formula="?f9 *83147/100000"></draw:equation><draw:equation draw:name="f13" draw:formula="?f9 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f14" draw:formula="?f9 *55557/100000"></draw:equation><draw:equation draw:name="f15" draw:formula="?f9 *38268/100000"></draw:equation><draw:equation draw:name="f16" draw:formula="?f9 *19509/100000"></draw:equation><draw:equation draw:name="f17" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f18" draw:formula="?f17 +0-?f2 "></draw:equation><draw:equation draw:name="f19" draw:formula="?f17 +0-?f3 "></draw:equation><draw:equation draw:name="f20" draw:formula="?f17 +0-?f4 "></draw:equation><draw:equation draw:name="f21" draw:formula="?f17 +0-?f5 "></draw:equation><draw:equation draw:name="f22" draw:formula="?f17 +0-?f6 "></draw:equation><draw:equation draw:name="f23" draw:formula="?f17 +0-?f7 "></draw:equation><draw:equation draw:name="f24" draw:formula="?f17 +0-?f8 "></draw:equation><draw:equation draw:name="f25" draw:formula="?f17 +?f8 -0"></draw:equation><draw:equation draw:name="f26" draw:formula="?f17 +?f7 -0"></draw:equation><draw:equation draw:name="f27" draw:formula="?f17 +?f6 -0"></draw:equation><draw:equation draw:name="f28" draw:formula="?f17 +?f5 -0"></draw:equation><draw:equation draw:name="f29" draw:formula="?f17 +?f4 -0"></draw:equation><draw:equation draw:name="f30" draw:formula="?f17 +?f3 -0"></draw:equation><draw:equation draw:name="f31" draw:formula="?f17 +?f2 -0"></draw:equation><draw:equation draw:name="f32" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f33" draw:formula="?f32 +0-?f10 "></draw:equation><draw:equation draw:name="f34" draw:formula="?f32 +0-?f11 "></draw:equation><draw:equation draw:name="f35" draw:formula="?f32 +0-?f12 "></draw:equation><draw:equation draw:name="f36" draw:formula="?f32 +0-?f13 "></draw:equation><draw:equation draw:name="f37" draw:formula="?f32 +0-?f14 "></draw:equation><draw:equation draw:name="f38" draw:formula="?f32 +0-?f15 "></draw:equation><draw:equation draw:name="f39" draw:formula="?f32 +0-?f16 "></draw:equation><draw:equation draw:name="f40" draw:formula="?f32 +?f16 -0"></draw:equation><draw:equation draw:name="f41" draw:formula="?f32 +?f15 -0"></draw:equation><draw:equation draw:name="f42" draw:formula="?f32 +?f14 -0"></draw:equation><draw:equation draw:name="f43" draw:formula="?f32 +?f13 -0"></draw:equation><draw:equation draw:name="f44" draw:formula="?f32 +?f12 -0"></draw:equation><draw:equation draw:name="f45" draw:formula="?f32 +?f11 -0"></draw:equation><draw:equation draw:name="f46" draw:formula="?f32 +?f10 -0"></draw:equation><draw:equation draw:name="f47" draw:formula="?f1 *?f0 /50000"></draw:equation><draw:equation draw:name="f48" draw:formula="?f9 *?f0 /50000"></draw:equation><draw:equation draw:name="f49" draw:formula="?f47 *99518/100000"></draw:equation><draw:equation draw:name="f50" draw:formula="?f47 *95694/100000"></draw:equation><draw:equation draw:name="f51" draw:formula="?f47 *88192/100000"></draw:equation><draw:equation draw:name="f52" draw:formula="?f47 *77301/100000"></draw:equation><draw:equation draw:name="f53" draw:formula="?f47 *63439/100000"></draw:equation><draw:equation draw:name="f54" draw:formula="?f47 *47140/100000"></draw:equation><draw:equation draw:name="f55" draw:formula="?f47 *29028/100000"></draw:equation><draw:equation draw:name="f56" draw:formula="?f47 *9802/100000"></draw:equation><draw:equation draw:name="f57" draw:formula="?f48 *99518/100000"></draw:equation><draw:equation draw:name="f58" draw:formula="?f48 *95694/100000"></draw:equation><draw:equation draw:name="f59" draw:formula="?f48 *88192/100000"></draw:equation><draw:equation draw:name="f60" draw:formula="?f48 *77301/100000"></draw:equation><draw:equation draw:name="f61" draw:formula="?f48 *63439/100000"></draw:equation><draw:equation draw:name="f62" draw:formula="?f48 *47140/100000"></draw:equation><draw:equation draw:name="f63" draw:formula="?f48 *29028/100000"></draw:equation><draw:equation draw:name="f64" draw:formula="?f48 *9802/100000"></draw:equation><draw:equation draw:name="f65" draw:formula="?f17 +0-?f49 "></draw:equation><draw:equation draw:name="f66" draw:formula="?f17 +0-?f50 "></draw:equation><draw:equation draw:name="f67" draw:formula="?f17 +0-?f51 "></draw:equation><draw:equation draw:name="f68" draw:formula="?f17 +0-?f52 "></draw:equation><draw:equation draw:name="f69" draw:formula="?f17 +0-?f53 "></draw:equation><draw:equation draw:name="f70" draw:formula="?f17 +0-?f54 "></draw:equation><draw:equation draw:name="f71" draw:formula="?f17 +0-?f55 "></draw:equation><draw:equation draw:name="f72" draw:formula="?f17 +0-?f56 "></draw:equation><draw:equation draw:name="f73" draw:formula="?f17 +?f56 -0"></draw:equation><draw:equation draw:name="f74" draw:formula="?f17 +?f55 -0"></draw:equation><draw:equation draw:name="f75" draw:formula="?f17 +?f54 -0"></draw:equation><draw:equation draw:name="f76" draw:formula="?f17 +?f53 -0"></draw:equation><draw:equation draw:name="f77" draw:formula="?f17 +?f52 -0"></draw:equation><draw:equation draw:name="f78" draw:formula="?f17 +?f51 -0"></draw:equation><draw:equation draw:name="f79" draw:formula="?f17 +?f50 -0"></draw:equation><draw:equation draw:name="f80" draw:formula="?f17 +?f49 -0"></draw:equation><draw:equation draw:name="f81" draw:formula="?f32 +0-?f57 "></draw:equation><draw:equation draw:name="f82" draw:formula="?f32 +0-?f58 "></draw:equation><draw:equation draw:name="f83" draw:formula="?f32 +0-?f59 "></draw:equation><draw:equation draw:name="f84" draw:formula="?f32 +0-?f60 "></draw:equation><draw:equation draw:name="f85" draw:formula="?f32 +0-?f61 "></draw:equation><draw:equation draw:name="f86" draw:formula="?f32 +0-?f62 "></draw:equation><draw:equation draw:name="f87" draw:formula="?f32 +0-?f63 "></draw:equation><draw:equation draw:name="f88" draw:formula="?f32 +0-?f64 "></draw:equation><draw:equation draw:name="f89" draw:formula="?f32 +?f64 -0"></draw:equation><draw:equation draw:name="f90" draw:formula="?f32 +?f63 -0"></draw:equation><draw:equation draw:name="f91" draw:formula="?f32 +?f62 -0"></draw:equation><draw:equation draw:name="f92" draw:formula="?f32 +?f61 -0"></draw:equation><draw:equation draw:name="f93" draw:formula="?f32 +?f60 -0"></draw:equation><draw:equation draw:name="f94" draw:formula="?f32 +?f59 -0"></draw:equation><draw:equation draw:name="f95" draw:formula="?f32 +?f58 -0"></draw:equation><draw:equation draw:name="f96" draw:formula="?f32 +?f57 -0"></draw:equation><draw:equation draw:name="f97" draw:formula="?f47 *cos(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f98" draw:formula="?f48 *sin(pi*(2700000)/10800000)"></draw:equation><draw:equation draw:name="f99" draw:formula="?f17 +0-?f97 "></draw:equation><draw:equation draw:name="f100" draw:formula="?f32 +0-?f98 "></draw:equation><draw:equation draw:name="f101" draw:formula="?f17 +?f97 -0"></draw:equation><draw:equation draw:name="f102" draw:formula="?f32 +?f98 -0"></draw:equation><draw:equation draw:name="f103" draw:formula="?f32 +0-?f48 "></draw:equation><draw:equation draw:name="f104" draw:formula="min(logwidth,logheight)/2"></draw:equation><draw:equation draw:name="f105" draw:formula="logheight"></draw:equation><draw:equation draw:name="f106" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f17 ?f103" draw:handle-range-y-maximum="?f104" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_star32("ooxml-star32", "H4sIAAAAAAAAAK2a227bRhCGX4UQemGnFrzLPQdRDPS67QP0jrAoiYAkupR86tOXM9RuEmuWwJBOEMUkl9+e/n84Q/nbuqtev9bHXXV8rNfLbd0e6nP3XuDpQ9N1bbfctV3zX3s8V/vVYlPtT/Xil8svdXduHj9ePNdv52XV1dVptXjYhFA8bKQQ+Cnxs1wUp5ft15emfv2jfVstRIF/4+3vT/Vq0bZvh/3ydK46VcZO23WzaequxypnRGyfZvBUnXerxV8FdKXK4s/+P2v6D++hV/hQMBZr4ZyDc3Co4IKFQw8XSrwbDi1c8AAoYdgKrlq4w2s4V8I5uOrgDq/gHHwouOrgDg9NSjhUcMHBoccVcDhGp+KJ0qRGOt1oE8ykDlzq1KaB+Dg459KAQ5yE83FiSsTJuhAXQMm4KF6khRJ2WL94MsSGWsSbg4hALWMnQcaOdRkHE8o4QK3ioEOaiE6TCzpOWJu4CMHEhdE2Llaww+rBKE1cUjyJyzw0lOlmlYAidVLGjnErh8HIOEDc8mHQIk4EpYGTQ7nghFFCuAgoK1yYQWqh+Kf4e/H926DMf5+rc9MeB50eq0Ov602U7abtDs/7arVoNjdi+Zso7sRd/2OvazEcwj88ur3tgfe/EMc6kB872Lfb12Z93t2XLE75kdPPtvgSvHDhXsK4BAunaFypvJ+C0yTOK6ndFJwhcY/t6eap+XJTOiTe9mQ//MSCWxJu+j+TxupInPKlnbSSnsTJYMSkfQ6E/HZ1s92dmfqTV07pPTdDgPLKGANvqgIlYZAwQ4KScEjPOzXHz9CgJAwTZohQEo4JM1QoCZOEGTKUVy6ZGAYl5Q9X/C6W/VOi4KGuvPEDpXiokjBHRGkmivBFRBkminpmXFCWiaKeFxeUY6KoZ8UF5Zko6jnRowC05Am0pJ4KiHJsFPVEQJRlozJqBylwURm1g0CZKJVRO9iGi8qoHczMRV2pfeqjThFi7zNwVKgUPIkqQu2JJZksQu6JxQx+itB7YjGjnyIEn1jM8KcIxScWM/4pQvKJxQyAmtA8sJDEVKomRH9hsW2tiRh/YbF9rTO6R0VwWRndo1K5rIzu0UFcVkb36Gwui079HzaiuDf8EopQfphOI7SvXZ9fByMnZYSGMAACjQ16EpBwAQC9l6GcBCSsAEDnlJCTgIQfAGiVVpOyYEOYAoDaSS0mAQlnALAMopy2y4Q9cJe9mLYnhEW0nyNDwiUInCxDyih+hgwtZRQ/Q4aWMoqfIUNLGcXPkKGljOJnyNBSRvHTZWgzhQLWZ4GXCdhMpYAFGjM7tJlSAVnM7NCOVMaGmR3akdLYMLNDN1IbG2Z26MaKY2Z26EaqY8PMDl2mPEYSM6twmfoYZ8hlZQtkw84OXbZCNuzs0GVLZMPODl2+RmZnhy5bJBt2duizVXIfcbisTMWAWmW+f/GZigFZzBcwfqRSNsy46kcqZcuMq36kUrbMuOpHKmXLjKt+pFK2zLjqRyply4yrPlMpI4mp1ZCtlC07ToRspWzZcSJkK2XLjhMhWylbdpwI2UrZsONEyFbKhv1GNGQrZcN+JRqoMsB92jd6IVMUfNKXNWEkGwrM6CtFxh4IY4ZfKbKvTwN7j/AXQegND2zxSDHyZNDsaV5Z5NDvbPwG6S69571lf6d55ZfEYoKuzBJHl+PsquN6Xxc//bx8ak8NtLjs4sNPq3hp0VXHbb18Xx6qt+bwfMCGaXE+tmmOQ5sfOze0SAP6+LtG3/8H13ORJoQkAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f6 0 ?f7 ?f18" svg:viewBox="0 0 0 0" draw:type="ooxml-ribbon2" draw:modifiers="16667 50000" draw:enhanced-path="M 0 ?f24 L ?f13 ?f24 L ?f9 ?f16 L ?f10 ?f18 L ?f14 ?f16 L ?f33 ?f24 ?f3 ?f20 ?f33 ?f19 ?f7 ?f19 ?f7 ?f21 L ?f9 0 L ?f6 ?f19 0 ?f19 ?f2 ?f20 Z S N M ?f11 ?f22 L ?f9 ?f16 L ?f11 ?f18 Z M ?f12 ?f22 L ?f10 ?f16 L ?f12 ?f18 Z  S N M 0 ?f24 L ?f2 ?f20 0 ?f19 ?f6 ?f19 ?f6 ?f21 L ?f10 0 L ?f7 ?f19 ?f7 ?f19 ?f33 ?f19 ?f3 ?f20 ?f33 ?f24 ?f14 ?f24 L ?f10 ?f16 L ?f9 ?f18 L ?f13 ?f16 Z M ?f11 ?f18 L ?f11 ?f22 M ?f12 ?f22 L ?f12 ?f18 M ?f6 ?f23 L ?f6 ?f19 M ?f7 ?f19 L ?f7 ?f23 F N" drawooo:enhanced-path="M 0 ?f24 L ?f13 ?f24 G ?f8 ?f21 ?f25 ?f26 L ?f9 ?f16 G ?f8 ?f21 ?f27 ?f28 L ?f10 ?f18 G ?f8 ?f21 ?f29 ?f30 L ?f14 ?f16 G ?f8 ?f21 ?f31 ?f32 L ?f33 ?f24 ?f3 ?f20 ?f33 ?f19 ?f7 ?f19 ?f7 ?f21 G ?f8 ?f21 ?f34 ?f35 L ?f9 0 G ?f8 ?f21 ?f36 ?f37 L ?f6 ?f19 0 ?f19 ?f2 ?f20 Z S N M ?f11 ?f22 G ?f8 ?f21 ?f38 ?f39 L ?f9 ?f16 G ?f8 ?f21 ?f40 ?f41 L ?f11 ?f18 Z M ?f12 ?f22 G ?f8 ?f21 ?f42 ?f43 L ?f10 ?f16 G ?f8 ?f21 ?f44 ?f45 L ?f12 ?f18 Z I S N M 0 ?f24 L ?f2 ?f20 0 ?f19 ?f6 ?f19 ?f6 ?f21 G ?f8 ?f21 ?f46 ?f47 L ?f10 0 G ?f8 ?f21 ?f48 ?f49 L ?f7 ?f19 ?f7 ?f19 ?f33 ?f19 ?f3 ?f20 ?f33 ?f24 ?f14 ?f24 G ?f8 ?f21 ?f50 ?f51 L ?f10 ?f16 G ?f8 ?f21 ?f52 ?f53 L ?f9 ?f18 G ?f8 ?f21 ?f54 ?f55 L ?f13 ?f16 G ?f8 ?f21 ?f56 ?f57 Z M ?f11 ?f18 L ?f11 ?f22 M ?f12 ?f22 L ?f12 ?f18 M ?f6 ?f23 L ?f6 ?f19 M ?f7 ?f19 L ?f7 ?f23 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(33333-$0 ,$0 ,33333))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(25000-$1 ,25000,if(75000-$1 ,$1 ,75000))"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/8"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth*?f1 /200000"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 +0-?f4 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f5 +?f4 -0"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth/32"></draw:equation><draw:equation draw:name="f9" draw:formula="?f6 +?f8 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="?f7 +0-?f8 "></draw:equation><draw:equation draw:name="f11" draw:formula="?f6 +?f2 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="?f7 +0-?f2 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f11 +0-?f8 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 +?f8 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="logheight*?f0 /200000"></draw:equation><draw:equation draw:name="f16" draw:formula="logheight+0-?f15 "></draw:equation><draw:equation draw:name="f17" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f18" draw:formula="logheight+0-?f17 "></draw:equation><draw:equation draw:name="f19" draw:formula="0+?f17 -0"></draw:equation><draw:equation draw:name="f20" draw:formula="(?f19 +logheight)/2"></draw:equation><draw:equation draw:name="f21" draw:formula="logheight*?f0 /400000"></draw:equation><draw:equation draw:name="f22" draw:formula="logheight+0-?f21 "></draw:equation><draw:equation draw:name="f23" draw:formula="?f16 +0-?f21 "></draw:equation><draw:equation draw:name="f24" draw:formula="logheight"></draw:equation><draw:equation draw:name="f25" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f30" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f31" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f32" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f33" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f34" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f35" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f36" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f37" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f38" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f39" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f40" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f41" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f42" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f43" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f44" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f45" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f46" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f47" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f49" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f50" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f51" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f52" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f53" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f54" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f55" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f56" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f57" draw:formula="(10800000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f5 ?f18" draw:handle-range-y-maximum="33333" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f6 ?f24" draw:handle-range-x-maximum="75000" draw:handle-range-x-minimum="25000"></draw:handle></draw:enhanced-geometry>
    ooxml_ribbon2("ooxml-ribbon2", "H4sIAAAAAAAAAL1ZUW+bMBD+KxbqQ7KWxTY2kKpppT1smrT0ZW99ow1JkBLcEdqm+/XDNgScg6qOo6UCjH189935PjuhN4siebtO83WSP6ULf5WKbVoW70h1b7OiEIW/FkX2V+Rlspl5y2SzSz1j+DUtyuzpeLBM96WfFGmym3l3yxBhdLeMqoPEHtq9rq5fs/Ttm9jPPIzUX/PY+3M684TYbzd+kT0+ipw23sQiW2ZpUeGRMAwjxHH1qQcPATwn5XrmzZU7ytAv6TFo21N5H+purNjoNmv7g9q8askGbrrItImgaVBSY2J1DfUYbkyofvwB/Ub3aC57ieyhgAjRRB60EW2NNMXaijZWNV4nwtrTwXPYbdQsCa5pGiGoRhueGbFKgkpNk8kOn2kne4HufmijbEbqiEFgdTDzhmPQzeC8JdcQrgy+o3s92UKIT833j+oS6wRUJy5PYTf35rjyEhuVYRqo/GCjXAyDQJ2ofQ2ZKOohfigsc1AmKIjsqs1EkK1gOpgGJvEY+aAuTXPZyQKjOEwDGQ7jRxX8076ETVTZyaK2rs1R2WJTl2I38Li04WQ4SC7J86ArC3NconJuaMU0kPHw6D8I6PZGL5d/XpIyE7lePPNkW625y2YtXYpi+7JJZl62HGH/AqMrfFU1A/lRt/JQd+NxBTgxED9yQHocULmK+xcEXamWdBQduuSh7iwd0WNHG7F6yxblehJb4QRDOJfYlyVrBcaGwL5UE4UmFKvtzAaRD4ZJrXDCY5yqGJEKkdmFGPUCSRjfLrJ4MLLALrQpZBRKRrEtIwLUIXWlkhTbJYkAGdScqDUnUOcHTpa1SUClq6XnpPBAnavV6qSc9xX4Os1W67LSDD5JMwQU+wFTRUu4Zbig5o84khM49pV/l2NkyRGoAF8qFMv5oEADI7XHXB7ojS1XHgq0cJQ9Zp892rf6d7JX7bh2eH3aCNFpWH2bgOZmhwOUMeI6VeNJKC9fLXMGVDHyCY5dEIEuHBkCTYwcCQJRjEhIHQADqA43hgEQhytDoAzXWQ4GvyHZwQBZjE4lBIXhO9VdAJXhOAlQGI4MoTJORYKScKPGoCTc8HoU4VS/DCrCERAIwjFiqAw3vB59OEbcIxA3wDPvHKxn53BSMIMycSLIz6wSfm6VcKgSN4JQJI5FyKFM3OaYn10n/NwbCYc6+TTDdZIvNinqtP1nscukhf7Rftf+CKnHiyRfpf67v0322fZlO/PUG6ABmyzXNi0BbfE59+qFFuuD3rfu1XuhAZvGvXqlBCjUGTn+l8ftPyOayMMLGQAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f6 ?f16 ?f7 ?f22" svg:viewBox="0 0 0 0" draw:type="ooxml-ribbon" draw:modifiers="16667 50000" draw:enhanced-path="M 0 0 L ?f13 0 L ?f9 ?f15 L ?f10 ?f16 L ?f14 ?f15 L ?f31 0 ?f3 ?f18 ?f31 ?f17 ?f7 ?f17 ?f7 ?f20 L ?f9 ?f22 L ?f6 ?f17 0 ?f17 ?f2 ?f18 Z S N M ?f11 ?f19 L ?f9 ?f15 L ?f11 ?f16 Z M ?f12 ?f19 L ?f10 ?f15 L ?f12 ?f16 Z  S N M 0 0 L ?f13 0 L ?f9 ?f15 L ?f10 ?f16 L ?f14 ?f15 L ?f31 0 ?f3 ?f18 ?f31 ?f17 ?f7 ?f17 ?f7 ?f20 L ?f9 ?f22 L ?f6 ?f17 0 ?f17 ?f2 ?f18 Z M ?f11 ?f19 L ?f11 ?f16 M ?f12 ?f16 L ?f12 ?f19 M ?f6 ?f17 L ?f6 ?f21 M ?f7 ?f21 L ?f7 ?f17 F N" drawooo:enhanced-path="M 0 0 L ?f13 0 G ?f8 ?f19 ?f23 ?f24 L ?f9 ?f15 G ?f8 ?f19 ?f25 ?f26 L ?f10 ?f16 G ?f8 ?f19 ?f27 ?f28 L ?f14 ?f15 G ?f8 ?f19 ?f29 ?f30 L ?f31 0 ?f3 ?f18 ?f31 ?f17 ?f7 ?f17 ?f7 ?f20 G ?f8 ?f19 ?f32 ?f33 L ?f9 ?f22 G ?f8 ?f19 ?f34 ?f35 L ?f6 ?f17 0 ?f17 ?f2 ?f18 Z S N M ?f11 ?f19 G ?f8 ?f19 ?f36 ?f37 L ?f9 ?f15 G ?f8 ?f19 ?f38 ?f39 L ?f11 ?f16 Z M ?f12 ?f19 G ?f8 ?f19 ?f40 ?f41 L ?f10 ?f15 G ?f8 ?f19 ?f42 ?f43 L ?f12 ?f16 Z I S N M 0 0 L ?f13 0 G ?f8 ?f19 ?f44 ?f45 L ?f9 ?f15 G ?f8 ?f19 ?f46 ?f47 L ?f10 ?f16 G ?f8 ?f19 ?f48 ?f49 L ?f14 ?f15 G ?f8 ?f19 ?f50 ?f51 L ?f31 0 ?f3 ?f18 ?f31 ?f17 ?f7 ?f17 ?f7 ?f20 G ?f8 ?f19 ?f52 ?f53 L ?f9 ?f22 G ?f8 ?f19 ?f54 ?f55 L ?f6 ?f17 0 ?f17 ?f2 ?f18 Z M ?f11 ?f19 L ?f11 ?f16 M ?f12 ?f16 L ?f12 ?f19 M ?f6 ?f17 L ?f6 ?f21 M ?f7 ?f21 L ?f7 ?f17 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(33333-$0 ,$0 ,33333))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(25000-$1 ,25000,if(75000-$1 ,$1 ,75000))"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth/8"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth*?f1 /200000"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 +0-?f4 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f5 +?f4 -0"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth/32"></draw:equation><draw:equation draw:name="f9" draw:formula="?f6 +?f8 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="?f7 +0-?f8 "></draw:equation><draw:equation draw:name="f11" draw:formula="?f6 +?f2 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="?f7 +0-?f2 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f11 +0-?f8 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 +?f8 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="logheight*?f0 /200000"></draw:equation><draw:equation draw:name="f16" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f17" draw:formula="logheight+0-?f16 "></draw:equation><draw:equation draw:name="f18" draw:formula="?f17 *1/2"></draw:equation><draw:equation draw:name="f19" draw:formula="logheight*?f0 /400000"></draw:equation><draw:equation draw:name="f20" draw:formula="logheight+0-?f19 "></draw:equation><draw:equation draw:name="f21" draw:formula="?f16 +0-?f19 "></draw:equation><draw:equation draw:name="f22" draw:formula="logheight"></draw:equation><draw:equation draw:name="f23" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f30" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f31" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f32" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f33" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f34" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f35" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f36" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f37" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f38" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f39" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f40" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f41" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f42" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f43" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f44" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f45" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f46" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f47" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f49" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f50" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f51" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f52" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f53" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f54" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f55" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f5 ?f16" draw:handle-range-y-maximum="33333" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f6 0" draw:handle-range-x-maximum="75000" draw:handle-range-x-minimum="25000"></draw:handle></draw:enhanced-geometry>
    ooxml_ribbon("ooxml-ribbon", "H4sIAAAAAAAAAM1ZTW+bQBD9Kwjl4KShZr8wjuJE6qFVpSaX3nIjMbaRDJsSkjj99WV2wRgGki7rSnUE3o/hzZvZebsyuVzm0etFnG2i7CFeeutYpnGRvzlqOE3yXObeRubJb5kV0XbhrqLtU+y2pl/ivEgeupNFvCu8KI+jp4V7vQqc6xWB26y8KHWdp5f1xUsSv36Ru4XrO+qvfvLtMV64Uu7SrZcn9/cyq/3JZbJK4rxEJEEQzBzhl59qch/CY1RsFu6NgvwBblnVmENH6DFf81Ft3owz4sAMg5FQ98vWrOK9b9AGkFLVDPS0X1tRjXDn/HRunRvoKKQ5IkI0kTttRBsjTbGyorVVhfd/xNaNqw7m5oByQ3+uxiuwGpcSNTrTzR8Nma/OrV5YKeUHa/utbITaQ4kC8VF+mJT2vIBb0MpU20BxCVvpaxvAjfmGOW1BMEgIY4eJbs+DXybMKquNAI+x2WAamGI7f6cGW+Yc3HPSKsy2ATzFWadav/eVa/s5iJSLQZ4c4uCz4eXi0OLz4eUS8JQgNsslICAxvFwC/IoPlutfi+XqUm+Dv56jIpGZ3hSzKC230lW9R65knj5vo4WbrCa+d+I75/552WTwUV24VO/0tAScthDfc0B6HFDYnb0T4pyrFjia7YfgUj1DR7TraCvXr8my2ExDIxw2hPPJ92DRjMD4ENhZuTrOlPrqmDJBFINhUiOcoItT1qmjQuRmIc56gQDGM4ssHIyMmYU2x4wCYBSaMiJIHaArlaTQLEkEyaDiRI05oTrfczKsTYIqXW09o8JDda52q1E57yvwTZysN0WpGX+UZggq9g4mGYGJ6n6PqTJY7tlmeKj81f59Rgx1TVD1d2Ll5rFSpINOrHOzWGmPGsp8jcPq2/c1NzMcpIYJCXStnU4D+PpsmDSkiQnxQxtApAxbhkgWE8+SIhLFRHAbPCQKa4ZIHnYMGZKG5SozpI36GDSDQbKYjCWEhWGXMawLOzwsCzs8rIqxSEdWA8NqsNsAGBaDpbz4seXAkRwmnlUSORaGXRJ5z8FhF3LPwWHHsOfgsGOIJWLJECvFthCxVuzK5uhSEVgqVgwFVoolwaMdIeLIR4g48hEixh8hmyhbbmPnoO09yqcELPQv4evm10c1n0fZOvbevDTaJelzunDVa5UBmyTTNg0BbfF37oP9m/MW7q7xrd60DNjUvtVLGuS/Skf33wNXfwDUuuCrNxgAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f9 ?f43 ?f13 ?f36" svg:viewBox="0 0 0 0" draw:type="ooxml-ellipseRibbon2" draw:modifiers="25000 50000 12500" draw:enhanced-path="M 0 ?f55 Q ?f21 ?f23 ?f11 ?f20 L ?f9 ?f31 Q ?f8 ?f35 ?f13 ?f31 L ?f12 ?f20 Q ?f24 ?f23 ?f56 ?f55 L ?f14 ?f39 ?f56 ?f25 Q ?f48 ?f47 ?f13 ?f41 L ?f13 ?f43 Q ?f8 ?f50 ?f9 ?f43 L ?f9 ?f41 Q ?f44 ?f47 0 ?f25 L ?f10 ?f39 Z S N M ?f11 ?f52 L ?f11 ?f20 ?f9 ?f31 Q ?f8 ?f35 ?f13 ?f31 L ?f12 ?f20 ?f12 ?f52 Q ?f8 ?f54 ?f11 ?f52 Z  S N M 0 ?f55 L ?f10 ?f39 0 ?f25 Q ?f44 ?f47 ?f9 ?f41 L ?f9 ?f43 Q ?f8 ?f50 ?f13 ?f43 L ?f13 ?f41 Q ?f48 ?f47 ?f56 ?f25 L ?f14 ?f39 ?f56 ?f55 Q ?f24 ?f23 ?f12 ?f20 L ?f13 ?f31 Q ?f8 ?f35 ?f9 ?f31 L ?f11 ?f20 Q ?f21 ?f23 0 ?f55 Z M ?f9 ?f31 L ?f9 ?f41 M ?f13 ?f41 L ?f13 ?f31 M ?f11 ?f52 L ?f11 ?f20 M ?f12 ?f20 L ?f12 ?f52 F N" drawooo:enhanced-path="M 0 ?f55 Q ?f21 ?f23 ?f11 ?f20 L ?f9 ?f31 Q ?f8 ?f35 ?f13 ?f31 L ?f12 ?f20 Q ?f24 ?f23 ?f56 ?f55 L ?f14 ?f39 ?f56 ?f25 Q ?f48 ?f47 ?f13 ?f41 L ?f13 ?f43 Q ?f8 ?f50 ?f9 ?f43 L ?f9 ?f41 Q ?f44 ?f47 0 ?f25 L ?f10 ?f39 Z S N M ?f11 ?f52 L ?f11 ?f20 ?f9 ?f31 Q ?f8 ?f35 ?f13 ?f31 L ?f12 ?f20 ?f12 ?f52 Q ?f8 ?f54 ?f11 ?f52 Z I S N M 0 ?f55 L ?f10 ?f39 0 ?f25 Q ?f44 ?f47 ?f9 ?f41 L ?f9 ?f43 Q ?f8 ?f50 ?f13 ?f43 L ?f13 ?f41 Q ?f48 ?f47 ?f56 ?f25 L ?f14 ?f39 ?f56 ?f55 Q ?f24 ?f23 ?f12 ?f20 L ?f13 ?f31 Q ?f8 ?f35 ?f9 ?f31 L ?f11 ?f20 Q ?f21 ?f23 0 ?f55 Z M ?f9 ?f31 L ?f9 ?f41 M ?f13 ?f41 L ?f13 ?f31 M ?f11 ?f52 L ?f11 ?f20 M ?f12 ?f20 L ?f12 ?f52 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(25000-$1 ,25000,if(75000-$1 ,$1 ,75000))"></draw:equation><draw:equation draw:name="f2" draw:formula="100000+0-?f0 "></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *1/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 +0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="max(0,?f4 )"></draw:equation><draw:equation draw:name="f6" draw:formula="if(?f5 -$2 ,?f5 ,if(?f0 -$2 ,$2 ,?f0 ))"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth*?f1 /200000"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 +0-?f7 "></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth/8"></draw:equation><draw:equation draw:name="f11" draw:formula="?f9 +?f10 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth+0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="logwidth+0-?f9 "></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth+0-?f10 "></draw:equation><draw:equation draw:name="f15" draw:formula="logheight*?f6 /100000"></draw:equation><draw:equation draw:name="f16" draw:formula="4*?f15 /logwidth"></draw:equation><draw:equation draw:name="f17" draw:formula="?f11 *?f11 /logwidth"></draw:equation><draw:equation draw:name="f18" draw:formula="?f11 +0-?f17 "></draw:equation><draw:equation draw:name="f19" draw:formula="?f16 *?f18 /1"></draw:equation><draw:equation draw:name="f20" draw:formula="logheight+0-?f19 "></draw:equation><draw:equation draw:name="f21" draw:formula="?f11 *1/2"></draw:equation><draw:equation draw:name="f22" draw:formula="?f16 *?f21 /1"></draw:equation><draw:equation draw:name="f23" draw:formula="logheight+0-?f22 "></draw:equation><draw:equation draw:name="f24" draw:formula="logwidth+0-?f21 "></draw:equation><draw:equation draw:name="f25" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f26" draw:formula="?f25 +0-?f15 "></draw:equation><draw:equation draw:name="f27" draw:formula="?f9 *?f9 /logwidth"></draw:equation><draw:equation draw:name="f28" draw:formula="?f9 +0-?f27 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f16 *?f28 /1"></draw:equation><draw:equation draw:name="f30" draw:formula="?f29 +?f26 -0"></draw:equation><draw:equation draw:name="f31" draw:formula="logheight+0-?f30 "></draw:equation><draw:equation draw:name="f32" draw:formula="?f15 +?f26 -?f30 "></draw:equation><draw:equation draw:name="f33" draw:formula="?f32 +?f15 -0"></draw:equation><draw:equation draw:name="f34" draw:formula="?f33 +?f26 -0"></draw:equation><draw:equation draw:name="f35" draw:formula="logheight+0-?f34 "></draw:equation><draw:equation draw:name="f36" draw:formula="logheight+0-?f25 "></draw:equation><draw:equation draw:name="f37" draw:formula="?f15 *14/16"></draw:equation><draw:equation draw:name="f38" draw:formula="(?f37 +?f36 )/2"></draw:equation><draw:equation draw:name="f39" draw:formula="logheight+0-?f38 "></draw:equation><draw:equation draw:name="f40" draw:formula="?f29 +?f36 -0"></draw:equation><draw:equation draw:name="f41" draw:formula="logheight+0-?f40 "></draw:equation><draw:equation draw:name="f42" draw:formula="?f30 +?f36 -0"></draw:equation><draw:equation draw:name="f43" draw:formula="logheight+0-?f42 "></draw:equation><draw:equation draw:name="f44" draw:formula="?f9 *1/2"></draw:equation><draw:equation draw:name="f45" draw:formula="?f16 *?f44 /1"></draw:equation><draw:equation draw:name="f46" draw:formula="?f45 +?f36 -0"></draw:equation><draw:equation draw:name="f47" draw:formula="logheight+0-?f46 "></draw:equation><draw:equation draw:name="f48" draw:formula="logwidth+0-?f44 "></draw:equation><draw:equation draw:name="f49" draw:formula="?f34 +?f36 -0"></draw:equation><draw:equation draw:name="f50" draw:formula="logheight+0-?f49 "></draw:equation><draw:equation draw:name="f51" draw:formula="?f19 +?f26 -0"></draw:equation><draw:equation draw:name="f52" draw:formula="logheight+0-?f51 "></draw:equation><draw:equation draw:name="f53" draw:formula="?f25 +?f25 -?f51 "></draw:equation><draw:equation draw:name="f54" draw:formula="logheight+0-?f53 "></draw:equation><draw:equation draw:name="f55" draw:formula="logheight"></draw:equation><draw:equation draw:name="f56" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f8 ?f36" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f9 0" draw:handle-range-x-maximum="100000" draw:handle-range-x-minimum="25000"></draw:handle><draw:handle draw:handle-position="0 ?f15" draw:handle-range-y-maximum="?f0" draw:handle-range-y-minimum="?f5"></draw:handle></draw:enhanced-geometry>
    ooxml_ellipseRibbon2("ooxml-ellipseRibbon2", "H4sIAAAAAAAAAO1ZW2/aMBT+K1bUh16I8BVIVYq0h0mTRqVtb31LSwKRIGEhbel+/XyJIcQGeqI+VhXBcZzvXL9zbHo3K+O32yRfxPlzMgvnSbFKqvId6elVVpZFGS6KMvtX5FW8HAdpvNwkwcHj16Sssuf2wyrZVmFcJvFmHEzSCE1SzuSFqAsbBGjzOr99zZK3b8V2HGCk/+yr7+tkHBTFdrUMk+UyW2+S39nTU5FTK7iYZWmWlBKaCowxUheMiLqpl+wsWsfVYhxMJfwkFQL9kl+UqIvWRo8w+omMiozoBSM1FDttiX5OqFmrEbhFEAODq1eoWRbZWWqkcYXGhxaN12jMeMSKExjtvGS14UYbzg0ANpj6bWwkPaI/6AFNrSWCmqe1VR+3qR7J93f68AboI6rl4IaxtQq4YSm3lkZ7QyOPndb4vSNIy1XWgR632iDuQmCN2KG1LY4aBpNGEOs0qI161H5srK2NmPoix8hRr0/bKtWe/Y4eTG4WRfGVnp+bnj++8vNT8vP+zhTPvy9xlRW5KaV5vJLlOLWVNS3K1csyHgdZeonDC4x6uCeHRJVgc68+5vbqSkL2DzBPiSAeEbrAhxcE9fRIiRruptRH3wEF0bYgo+4NDicpRiAo1oaSjkXXpE9BKNxFwUirw2DqiDbQKt5e4p7MDgRz0cATC5knKLygqKcGPT2BzYSZxAgYh2FbyLKYv2WzanEt8xL1qY4KCHF0DBEYkMgNyMgEZAgLCHF4s9NoBANy2KFKwI2udCHMScTJf6uTtlBWChicw4EDuAiI5nDhUDkgP4nDCAm3SLL5opJJNkB9Ak8y4pCDq4QVqG9VhcE5NNAxuNbXjpAODzSY8SA0gz1cIAOt3ki6D1Z4fWww0TC6AZOFekihXAetv9RhhLVRdmGojT46NGykFGjjaUJQIFvpSULgToSgDiH07siEVAD187AhUpGIOnKBergQGd0okAr0KBUomArMoYJE0QWdDqAFnTk0OEw5Bt3U+OggrG4d8Dy7JEZ18xJgWz17JcY6+u04F4zfONBOhwct6gO5wHydQcjyxvuyB4GQHBLIzRsbKrexAboClkvm8KDltxHMTn6UCwwcU36GCxyYu9zDBZn/3XQ70xo4sDVwDxeiDqcPhwa2rMkjM7CscU8r4KKju3zng6a7BkB3HT0dGDgg27mnG8iK0clUcWZjxIEbI+HbGHXsLsJ3XGjoJoA7EOE7M5vuIlAXPN8Gqakf9Ax9vCvAcHzd4OT+ZRHns2WCGuNwXWwytcKcQCf7FlM/L+N8noTvoTznZ6uXlf0p48iiLDeL9glgVnxMfoS8uNuPCN/uhesfcjoooH+aE2fMn6TnbJcJ4Qivo9H+N8j9f/29u5IfGQAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f9 ?f23 ?f13 ?f36" svg:viewBox="0 0 0 0" draw:type="ooxml-ellipseRibbon" draw:modifiers="25000 50000 12500" draw:enhanced-path="M 0 0 Q ?f20 ?f21 ?f11 ?f19 L ?f9 ?f28 Q ?f8 ?f31 ?f13 ?f28 L ?f12 ?f19 Q ?f22 ?f21 ?f46 0 L ?f14 ?f34 ?f46 ?f32 Q ?f40 ?f39 ?f13 ?f35 L ?f13 ?f36 Q ?f8 ?f41 ?f9 ?f36 L ?f9 ?f35 Q ?f37 ?f39 0 ?f32 L ?f10 ?f34 Z S N M ?f11 ?f42 L ?f11 ?f19 ?f9 ?f28 Q ?f8 ?f31 ?f13 ?f28 L ?f12 ?f19 ?f12 ?f42 Q ?f8 ?f43 ?f11 ?f42 Z  S N M 0 0 Q ?f20 ?f21 ?f11 ?f19 L ?f9 ?f28 Q ?f8 ?f31 ?f13 ?f28 L ?f12 ?f19 Q ?f22 ?f21 ?f46 0 L ?f14 ?f34 ?f46 ?f32 Q ?f40 ?f39 ?f13 ?f35 L ?f13 ?f36 Q ?f8 ?f41 ?f9 ?f36 L ?f9 ?f35 Q ?f37 ?f39 0 ?f32 L ?f10 ?f34 Z M ?f9 ?f35 L ?f9 ?f28 M ?f13 ?f28 L ?f13 ?f35 M ?f11 ?f19 L ?f11 ?f42 M ?f12 ?f42 L ?f12 ?f19 F N" drawooo:enhanced-path="M 0 0 Q ?f20 ?f21 ?f11 ?f19 L ?f9 ?f28 Q ?f8 ?f31 ?f13 ?f28 L ?f12 ?f19 Q ?f22 ?f21 ?f46 0 L ?f14 ?f34 ?f46 ?f32 Q ?f40 ?f39 ?f13 ?f35 L ?f13 ?f36 Q ?f8 ?f41 ?f9 ?f36 L ?f9 ?f35 Q ?f37 ?f39 0 ?f32 L ?f10 ?f34 Z S N M ?f11 ?f42 L ?f11 ?f19 ?f9 ?f28 Q ?f8 ?f31 ?f13 ?f28 L ?f12 ?f19 ?f12 ?f42 Q ?f8 ?f43 ?f11 ?f42 Z I S N M 0 0 Q ?f20 ?f21 ?f11 ?f19 L ?f9 ?f28 Q ?f8 ?f31 ?f13 ?f28 L ?f12 ?f19 Q ?f22 ?f21 ?f46 0 L ?f14 ?f34 ?f46 ?f32 Q ?f40 ?f39 ?f13 ?f35 L ?f13 ?f36 Q ?f8 ?f41 ?f9 ?f36 L ?f9 ?f35 Q ?f37 ?f39 0 ?f32 L ?f10 ?f34 Z M ?f9 ?f35 L ?f9 ?f28 M ?f13 ?f28 L ?f13 ?f35 M ?f11 ?f19 L ?f11 ?f42 M ?f12 ?f42 L ?f12 ?f19 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(25000-$1 ,25000,if(75000-$1 ,$1 ,75000))"></draw:equation><draw:equation draw:name="f2" draw:formula="100000+0-?f0 "></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *1/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f0 +0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="max(0,?f4 )"></draw:equation><draw:equation draw:name="f6" draw:formula="if(?f5 -$2 ,?f5 ,if(?f0 -$2 ,$2 ,?f0 ))"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth*?f1 /200000"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 +0-?f7 "></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth/8"></draw:equation><draw:equation draw:name="f11" draw:formula="?f9 +?f10 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth+0-?f11 "></draw:equation><draw:equation draw:name="f13" draw:formula="logwidth+0-?f9 "></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth+0-?f10 "></draw:equation><draw:equation draw:name="f15" draw:formula="logheight*?f6 /100000"></draw:equation><draw:equation draw:name="f16" draw:formula="4*?f15 /logwidth"></draw:equation><draw:equation draw:name="f17" draw:formula="?f11 *?f11 /logwidth"></draw:equation><draw:equation draw:name="f18" draw:formula="?f11 +0-?f17 "></draw:equation><draw:equation draw:name="f19" draw:formula="?f16 *?f18 /1"></draw:equation><draw:equation draw:name="f20" draw:formula="?f11 *1/2"></draw:equation><draw:equation draw:name="f21" draw:formula="?f16 *?f20 /1"></draw:equation><draw:equation draw:name="f22" draw:formula="logwidth+0-?f20 "></draw:equation><draw:equation draw:name="f23" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f24" draw:formula="?f23 +0-?f15 "></draw:equation><draw:equation draw:name="f25" draw:formula="?f9 *?f9 /logwidth"></draw:equation><draw:equation draw:name="f26" draw:formula="?f9 +0-?f25 "></draw:equation><draw:equation draw:name="f27" draw:formula="?f16 *?f26 /1"></draw:equation><draw:equation draw:name="f28" draw:formula="?f27 +?f24 -0"></draw:equation><draw:equation draw:name="f29" draw:formula="?f15 +?f24 -?f28 "></draw:equation><draw:equation draw:name="f30" draw:formula="?f29 +?f15 -0"></draw:equation><draw:equation draw:name="f31" draw:formula="?f30 +?f24 -0"></draw:equation><draw:equation draw:name="f32" draw:formula="logheight+0-?f23 "></draw:equation><draw:equation draw:name="f33" draw:formula="?f15 *14/16"></draw:equation><draw:equation draw:name="f34" draw:formula="(?f33 +?f32 )/2"></draw:equation><draw:equation draw:name="f35" draw:formula="?f27 +?f32 -0"></draw:equation><draw:equation draw:name="f36" draw:formula="?f28 +?f32 -0"></draw:equation><draw:equation draw:name="f37" draw:formula="?f9 *1/2"></draw:equation><draw:equation draw:name="f38" draw:formula="?f16 *?f37 /1"></draw:equation><draw:equation draw:name="f39" draw:formula="?f38 +?f32 -0"></draw:equation><draw:equation draw:name="f40" draw:formula="logwidth+0-?f37 "></draw:equation><draw:equation draw:name="f41" draw:formula="?f31 +?f32 -0"></draw:equation><draw:equation draw:name="f42" draw:formula="?f19 +?f24 -0"></draw:equation><draw:equation draw:name="f43" draw:formula="?f23 +?f23 -?f42 "></draw:equation><draw:equation draw:name="f44" draw:formula="logheight+0-?f15 "></draw:equation><draw:equation draw:name="f45" draw:formula="logheight"></draw:equation><draw:equation draw:name="f46" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="?f8 ?f23" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f9 ?f45" draw:handle-range-x-maximum="75000" draw:handle-range-x-minimum="25000"></draw:handle><draw:handle draw:handle-position="0 ?f44" draw:handle-range-y-maximum="?f0" draw:handle-range-y-minimum="?f5"></draw:handle></draw:enhanced-geometry>
    ooxml_ellipseRibbon("ooxml-ellipseRibbon", "H4sIAAAAAAAAAO1YW0/bMBT+K1bEAy2N6kvSC6JU2sOkSSvStjfeAnVaS0ncpQHKfv18SdKLXeBEe5oQqpXYJ9+5fsc2N8syebnmxTopHvkyXHGZ86p8RWY6F2Upy3AtS/FHFlWSzYI0ybY8OFp+5mUlHk8XK76rwqTkyXYWzNMpmqeUqYHogY0CtH1eXT8L/vJF7mYBRuav+fR1w2eBlLs8C3mWic2W/xQPD7Jo9MqlSAUvFTKNMcZIDxgR/VKLtA5tkmo9CxYG/4c2AuuBaEvMMEXfUW3exAhMtH2ksVRN6nVCraxBoA1CNFKgZjnSH0V2Sj1RIxhpVWzaOh1bWRuAVldEav1qrjFFieplNrYA2GKar7HVdI9+oTu0aNyI6tXapY87VD9FdG8POwC9R7We/y58i73sgQeLU8NrzW2ga4eb+CwOAnjo6Fd0ZwtRSvlZi/+qFr99FmPXYry9sW3x91NSCVnYJlkkueqzadMzU1nmT1kyC0R6icMLjAZ4oB6Jbq72Xf/sa6+nIIdHmG+pIB4VpnWHFwQNzJNWNW6n9M+8ARXRU0XW3CsczlOMQFDsFEolAvXJkIJQIhcFI2MOg5kTnwLlye4SD1S2ESxEI08u5mmMwguKBvphYCawnbCTGAHzMD5VksnVi1hW674qSTSkJisgxMk5RGBCpm5CJjYhY1hCiMOb1qIJDMhhh24BV6ZBhLAgEaf+G5uMh6pTwOAcDhzBTYFoDheOjQPykziMUHBrLlbrShXZCA0JvMiIQ45IF2yMho2pMDiHBiYHfTN2hHR4YMBsBKEV7OECGRnzJip8sMbrsMG6Cu2X1EMGa5Pa7aE2vc0GCiw46mNDW3C4U8FRz/6g7kk2nTHQPocQmqJ9PXSrNeqwwTQmEzuobT4m2LSOwGn1UICOdcOkEbRhUh8F4gbLHL1ghwYPDaht5jHUNuahAsPd/GQ+KtjatfkEnkaY53SkPOyTaKh6KAjJYYA6fDCm3VTn5B6wfTAPB2xtKDBozDzlr+qhG5an/qfw7sh83d/QSN0vgDRintJnHd2Lzp6F7FEXuDFFvsonHU1zKt9cijqxKPLdCUypqjE0Fy8Ynu9EdMBK6A4QnT8SwXCcyn9v/1gnxTLj6OA53Mit0BL2hD3fb5/1epkUKx6+huoeI/KnvLmqnREShRXaJ8xKfEy/vlG3wTmC3u31m/vmGZlGvbmqdjBBX/XbbJ8LwDx9z3t1PXOU1/k4/Q/u7V8MF1tW2hUAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f9 ?f14 ?f10 ?f15" svg:viewBox="0 0 0 0" draw:type="ooxml-leftRightRibbon" draw:modifiers="50000 50000 16667" draw:enhanced-path="M 0 ?f16 L ?f9 0 ?f9 ?f14 ?f23 ?f14 L ?f4 ?f22 ?f32 ?f33 ?f10 ?f21 ?f10 ?f19 ?f28 ?f17 ?f10 ?f29 L ?f4 ?f22 ?f34 ?f35 ?f24 ?f20 Z S N M ?f9 ?f20 L ?f4 ?f22 Z  S N M ?f36 ?f37 L ?f4 ?f22 ?f38 ?f39 ?f25 ?f21 L ?f9 ?f14 ?f23 ?f14 ?f4 ?f22 ?f40 ?f41 ?f4 ?f22 ?f42 ?f43 L ?f28 ?f17 ?f10 ?f29 ?f10 ?f15 Z M ?f23 ?f15 L ?f4 ?f22 M ?f44 ?f45 L ?f24 ?f20 F N" drawooo:enhanced-path="M 0 ?f16 L ?f9 0 ?f9 ?f14 ?f23 ?f14 G ?f4 ?f22 ?f30 ?f31 ?f4 ?f22 ?f32 ?f33 L ?f10 ?f21 ?f10 ?f19 ?f28 ?f17 ?f10 ?f29 ?f10 ?f15 ?f23 ?f15 G ?f4 ?f22 ?f34 ?f35 L ?f24 ?f20 ?f9 ?f20 ?f9 ?f18 Z S N M ?f25 ?f26 G ?f4 ?f22 ?f36 ?f37 ?f4 ?f22 ?f38 ?f39 L ?f25 ?f21 Z I S N M 0 ?f16 L ?f9 0 ?f9 ?f14 ?f23 ?f14 G ?f4 ?f22 ?f40 ?f41 ?f4 ?f22 ?f42 ?f43 L ?f10 ?f21 ?f10 ?f19 ?f28 ?f17 ?f10 ?f29 ?f10 ?f15 ?f23 ?f15 G ?f4 ?f22 ?f44 ?f45 L ?f24 ?f20 ?f9 ?f20 ?f9 ?f18 Z M ?f25 ?f26 L ?f25 ?f21 M ?f24 ?f27 L ?f24 ?f20 F N"><draw:equation draw:name="f0" draw:formula="if(0-$2 ,0,if(33333-$2 ,$2 ,33333))"></draw:equation><draw:equation draw:name="f1" draw:formula="100000+0-?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="if(0-$0 ,0,if(?f1 -$0 ,$0 ,?f1 ))"></draw:equation><draw:equation draw:name="f3" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f4" draw:formula="logwidth/32"></draw:equation><draw:equation draw:name="f5" draw:formula="?f3 +0-?f4 "></draw:equation><draw:equation draw:name="f6" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f7" draw:formula="100000*?f5 /?f6 "></draw:equation><draw:equation draw:name="f8" draw:formula="if(0-$1 ,0,if(?f7 -$1 ,$1 ,?f7 ))"></draw:equation><draw:equation draw:name="f9" draw:formula="?f6 *?f8 /100000"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth+0-?f9 "></draw:equation><draw:equation draw:name="f11" draw:formula="logheight*?f2 /200000"></draw:equation><draw:equation draw:name="f12" draw:formula="logheight*?f0 /-200000"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f14" draw:formula="?f13 +?f12 -?f11 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f13 +?f11 -?f12 "></draw:equation><draw:equation draw:name="f16" draw:formula="?f14 +?f11 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="logheight+0-?f16 "></draw:equation><draw:equation draw:name="f18" draw:formula="?f16 *2/1"></draw:equation><draw:equation draw:name="f19" draw:formula="logheight+0-?f18 "></draw:equation><draw:equation draw:name="f20" draw:formula="?f18 +0-?f14 "></draw:equation><draw:equation draw:name="f21" draw:formula="logheight+0-?f20 "></draw:equation><draw:equation draw:name="f22" draw:formula="?f0 *?f6 /400000"></draw:equation><draw:equation draw:name="f23" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f24" draw:formula="?f23 +0-?f4 "></draw:equation><draw:equation draw:name="f25" draw:formula="?f23 +?f4 -0"></draw:equation><draw:equation draw:name="f26" draw:formula="?f14 +?f22 -0"></draw:equation><draw:equation draw:name="f27" draw:formula="?f21 +0-?f22 "></draw:equation><draw:equation draw:name="f28" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f29" draw:formula="logheight"></draw:equation><draw:equation draw:name="f30" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f31" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f32" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f33" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f34" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f35" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f36" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f37" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f38" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f39" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f40" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f41" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f42" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f43" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f44" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f45" draw:formula="(5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f10 ?f21" draw:handle-range-y-maximum="?f1" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f9 0" draw:handle-range-x-maximum="?f7" draw:handle-range-x-minimum="0"></draw:handle><draw:handle draw:handle-position="?f25 ?f21" draw:handle-range-y-maximum="33333" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_leftRightRibbon("ooxml-leftRightRibbon", "H4sIAAAAAAAAAK1YXW+bMBT9KxbaA+3KwMZAUjWLtIdNk5I+bG99o40JlgB3hLbpfv38ARQwWetAIhx/nnt87z0GcrMr45drUqRx8UB2zp6wnFTlK5DdOS1LVjopK+lfVlRxtrKSODsQqzf8TMqKPgwHK3KsnLgk8WFlrZMlWCcQi8ITRWCBw/P++pmSl2/suLI8IL/N0tdHsrIYO+aZk5Gk+kX3KS/u71nRWGY7mlBScuzA4x+gShiGYVRPabf0GFfpytoCaTgEGyDYeKDDCfmqJoZkG/HCl4XfUEawJS/WoYWoRe3ocrBY1PxANGWfB+7Ab3ALtrVZ3tGZfwfaQT8URTRAE8Z8uS5QVDZj9DsrsCCFYa9LFr5cqrNvA8PJbFvMoMtDdGNpRXU3O/sObpXLGWPneP1Hb6tiit8j3gRi8+FQvG3mbSN9K3V4uttoA1NTXHRCptweDkDqUI0EatMJ1R34WeMYuuKdGM7kirGIjrmi64bu9rbtukjLiq83Sol/nuKKskLpsohzLu6k0XrCyvwpi1cWTWzP+YTAlXfFq774yKa4ZOviggO6PcT/GYBDA1AcEd5nz1knHjCCQuNcvZor9xCQLXGJhiFTfwifsf0L3VWpi4xw8Ekc3wwoGALxpAbScdjMceEQKKeF3bC64pWUiKPdzF3ReGAv10kA3HUSmlFcjMcWtrGNgGyJSzQMY7vUXRkCTnUBXEXbLKc11TTOlNFZmm0dahJpI8IZIuCiMxhqWuliesB1zgEdU4gCNZQI1DTC9cpzm5cIcA9CaOjCEanUeFDiIUM8TTHyvlDjGXpNE0rrNZkt0FApUJOKxLhELjTD0TQx4LUwPJ01UUgMhWV4YKHTkpB4yPTOoclBiOBSHAIuNhcCmutWgUZ0gM4749GIBJCUADbNWHQy+/mjiimWlv3ycUVF0VCVSMv8xu1mMKcT3+x5QUt4G4bqWL1wQ/HzxcxXvpb1NvQWUwC1tJ/KUEt825lIUVOAHeApeJoMJuJpWrDPRdKUMJGZpoapwdV0MTW4eG6F4LkVgudWCJ5dIXhmheDzFZLGxS4joFN3HtmBihnyHqFeha3ehDIu9sR5dfL4SPOnXM47MYMWasabfTXjY9aX7f9WPdxj13J0YsY0y/U7+Dv7li/Pxjuv4zD8X/DrP/NqS0gwFAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f2 ?f2 ?f7 ?f11" svg:viewBox="0 0 0 0" draw:type="ooxml-verticalScroll" draw:modifiers="12500" draw:enhanced-path="M ?f3 ?f14 L ?f3 ?f11 L ?f2 ?f10 ?f2 ?f3 L ?f8 0 L ?f7 ?f2 ?f7 ?f11 Z M ?f6 ?f3 Z S N M ?f4 ?f4 Z M ?f3 ?f3 Z  S N M ?f31 ?f32 L ?f2 ?f11 L ?f4 ?f4 L ?f2 ?f3 ?f3 ?f3 L ?f3 ?f3 Z M ?f7 ?f11 L ?f3 ?f14 M ?f3 ?f3 L ?f43 ?f44 M ?f5 0 L ?f4 ?f4 M ?f47 ?f48 L ?f5 ?f2 F N" drawooo:enhanced-path="M ?f3 ?f14 G ?f3 ?f3 ?f15 ?f16 L ?f3 ?f11 G ?f4 ?f4 ?f17 ?f18 L ?f2 ?f10 ?f2 ?f3 G ?f3 ?f3 ?f19 ?f20 L ?f8 0 G ?f3 ?f3 ?f21 ?f22 L ?f7 ?f2 ?f7 ?f11 G ?f3 ?f3 ?f23 ?f24 Z M ?f6 ?f3 G ?f3 ?f3 ?f25 ?f26 ?f4 ?f4 ?f27 ?f28 Z S N M ?f6 ?f3 G ?f3 ?f3 ?f29 ?f30 ?f4 ?f4 ?f31 ?f32 Z M ?f2 ?f11 G ?f3 ?f3 ?f33 ?f34 ?f4 ?f4 ?f35 ?f36 Z I S N M ?f2 ?f10 L ?f2 ?f3 G ?f3 ?f3 ?f37 ?f38 L ?f8 0 G ?f3 ?f3 ?f39 ?f40 L ?f7 ?f2 ?f7 ?f11 G ?f3 ?f3 ?f41 ?f42 L ?f3 ?f14 G ?f3 ?f3 ?f43 ?f44 Z M ?f5 0 G ?f3 ?f3 ?f45 ?f46 ?f4 ?f4 ?f47 ?f48 L ?f6 ?f3 M ?f7 ?f2 L ?f5 ?f2 M ?f3 ?f10 G ?f4 ?f4 ?f49 ?f50 L ?f2 ?f11 M ?f3 ?f14 G ?f3 ?f3 ?f51 ?f52 L ?f2 ?f10 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(25000-$0 ,$0 ,25000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *1/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 *1/4"></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 +?f3 -0"></draw:equation><draw:equation draw:name="f6" draw:formula="?f2 +?f2 -0"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth+0-?f3 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +0-?f3 "></draw:equation><draw:equation draw:name="f10" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f11" draw:formula="logheight+0-?f3 "></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f14" draw:formula="logheight"></draw:equation><draw:equation draw:name="f15" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f30" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f31" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f32" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f33" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f34" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f35" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f36" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f37" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f38" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f39" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f40" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f41" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f42" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f43" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f44" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f45" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f46" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f47" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f49" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f50" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f51" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f52" draw:formula="(-5400000)/60000.0"></draw:equation><draw:handle draw:handle-position="0 ?f2" draw:handle-range-y-maximum="25000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_verticalScroll("ooxml-verticalScroll", "H4sIAAAAAAAAAK2YXW+bMBSG/4qFdkG7sviLlFallXaxalLam971DjUQkAB3hLbpfv2wAcfkkGrEJIIabD/n+Ph9RcrNuoo+ruMyjcqXeO1tYlHEdfWJ1O0iqypReamosr+irKM8dJIo38bOoPs9rurs5bCzjne1F1VxtA2du4Si9rhsDkIctH3fXL9n8cdPsQsdjNS3n/j5GoeOELsi1+inl0rkeR9WrLMki6sGTKiP+3l6Da9RnYbOQxOJyWgcrfomUU2ZB8Fdg6lbQRN/1aW3TxM9I0lZqmHP6Ak9qmuujraPdX26kxF5ovtAbcx2zkoH7Y+VwXjYB9YZcyOK4sgmb+/6XdItW2Ump/NA3fVVrF/osS2PEOKLCt0bSRE5kyzNqt3rKM2lSjEYq+SAciVvY11ds4/KGlE6VvHBMHXig10Y9KslLo3cqKIFxl6NzJKJMWzM6resjUNhIkyduDlFhmbLZspvHaorxn6PBwiZGQtGy8FkRnxUgOYwLtPk1NTGoLtTxrPWxqBXJszNWplaaav0oOPv9aM1ggci4DJlH5sqP6ImX2btU1MuUpO3N61n/7xFdSbK1sFlVDTOT3pDJ6Iq3vIodLLExd43jC7wRdOUlm8v5aGuzs4a4GJA/CoAOQxQZKWbi81Htq7Ti6aRxtkmradB6SG0WSs6v0swWhAsP5NoDNIoOicLOonCj1D4JIo/Rvkut9ebtqjlERCdCro8BPWb9x17EjcJFnwJY9NgV3CJl+gUEAEu0Lo8ZZEEaH6Im5odUHtftIkKJUDoOq+pJCB2TZrGAXJ3fa4MfLZYyj8/pmmVANW7nh0QqN8yQWAA1yM4sCECF7h2QArMYLdkCtzgkiW1AQI/2K4Y+MI9lQR8YVk76I9TSdAZdpnNbAwKjWG5qdAXJ5LYzIZg0BB2vLn9wGbzA4N+sPM+g4awBEJfWBYPGsMSCJ1hJ5eRB4ZVCTn0h92KOTTIqSRoDavacegMO96IP+xKN7c/+Nz+4DM/OPjcDw4+tz/8uf3hz/wA8aFL/vtXcxqV6zxGRtt7FdtMjpDvGu/0v+pdZxWVm9j79IpolxVvReiodwpHxmRlO2YfvR2hczl8k3r7DyH+rZNiFQAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f2 ?f2 ?f11 ?f7" svg:viewBox="0 0 0 0" draw:type="ooxml-horizontalScroll" draw:modifiers="12500" draw:enhanced-path="M ?f14 ?f3 L ?f11 ?f3 L ?f10 ?f2 ?f3 ?f2 L 0 ?f8 L ?f2 ?f7 ?f11 ?f7 Z M ?f3 ?f6 Z S N M ?f4 ?f4 Z M ?f3 ?f3 Z  S N M ?f31 ?f32 L ?f33 ?f34 ?f4 ?f4 L ?f3 ?f3 L ?f10 ?f3 ?f3 ?f3 Z M ?f3 ?f3 L ?f41 ?f42 M ?f3 ?f3 L ?f43 ?f44 M ?f3 ?f3 L ?f45 ?f46 M ?f4 ?f4 L ?f47 ?f48 F N" drawooo:enhanced-path="M ?f14 ?f3 G ?f3 ?f3 ?f15 ?f16 L ?f11 ?f3 G ?f4 ?f4 ?f17 ?f18 L ?f10 ?f2 ?f3 ?f2 G ?f3 ?f3 ?f19 ?f20 L 0 ?f8 G ?f3 ?f3 ?f21 ?f22 L ?f2 ?f7 ?f11 ?f7 G ?f3 ?f3 ?f23 ?f24 Z M ?f3 ?f6 G ?f3 ?f3 ?f25 ?f26 ?f4 ?f4 ?f27 ?f28 Z S N M ?f3 ?f6 G ?f3 ?f3 ?f29 ?f30 ?f4 ?f4 ?f31 ?f32 Z M ?f11 ?f2 G ?f3 ?f3 ?f33 ?f34 ?f4 ?f4 ?f35 ?f36 Z I S N M 0 ?f5 G ?f3 ?f3 ?f37 ?f38 L ?f10 ?f2 ?f10 ?f3 G ?f3 ?f3 ?f39 ?f40 L ?f14 ?f9 G ?f3 ?f3 ?f41 ?f42 L ?f2 ?f7 ?f2 ?f8 G ?f3 ?f3 ?f43 ?f44 Z M ?f10 ?f2 L ?f11 ?f2 G ?f3 ?f3 ?f45 ?f46 M ?f11 ?f2 L ?f11 ?f3 G ?f4 ?f4 ?f47 ?f48 M ?f3 ?f6 L ?f3 ?f5 G ?f4 ?f4 ?f49 ?f50 ?f3 ?f3 ?f51 ?f52 M ?f2 ?f5 L ?f2 ?f7 F N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(25000-$0 ,$0 ,25000))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *1/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 *1/4"></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 +?f3 -0"></draw:equation><draw:equation draw:name="f6" draw:formula="?f2 +?f2 -0"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f8" draw:formula="logheight+0-?f3 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +0-?f3 "></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth+0-?f2 "></draw:equation><draw:equation draw:name="f11" draw:formula="logwidth+0-?f3 "></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f14" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f15" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f16" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f17" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f18" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f19" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f20" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f21" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f22" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f23" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f24" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f25" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f29" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f30" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f31" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f32" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f33" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f34" draw:formula="(-16200000)/60000.0"></draw:equation><draw:equation draw:name="f35" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f36" draw:formula="(-10800000)/60000.0"></draw:equation><draw:equation draw:name="f37" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f38" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f39" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f40" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f41" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f42" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f43" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f44" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f45" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f46" draw:formula="(-5400000)/60000.0"></draw:equation><draw:equation draw:name="f47" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f48" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f49" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f50" draw:formula="(10800000)/60000.0"></draw:equation><draw:equation draw:name="f51" draw:formula="(0)/60000.0"></draw:equation><draw:equation draw:name="f52" draw:formula="(10800000)/60000.0"></draw:equation><draw:handle draw:handle-position="?f2 0" draw:handle-range-x-maximum="25000" draw:handle-range-x-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_horizontalScroll("ooxml-horizontalScroll", "H4sIAAAAAAAAAK1YXW+bMBT9KxbaA/1gAduQtCqttIdVk9q+9G1vqDEBCXBHaJvu149rMAFuUo2YRFDb1z7365yQ5mZdRh/Xokii4kWsnY2QuajKT6KW87QsZekkskz/yqKKstCKo2wrrIH5XZRV+jI2VmJXOVEpom1o3cWUNJfn1belRbbvm+v3VHz8kLvQcol664OfryK0pNzlWc/z80sps0w7lus0TkVZQ3vUd/XJLovXqEpC6xH88frGyIN23Q7dNhym/j4QmK+UCVaXXaDkN3lstwX1+Jk8qTlX197G6nFnZMoPVWhMWXl35KE70IXBehiPAzMHIE7HqzDkfLzqwy3oRadWIRO+Ij/JU1MiKeUXVbrvheMBoBf0K3ffYddLqkarQ9UcoFzBkttVuG+jgErpoaoPtqkbH3RiYIdAadCLjQISXfX6deAUBMbc3indtsaPCmSYy7iX9QRcMyDGr9YVAPrDUxAMGxWqbfxgHwTE3WYfgF8NzJoL/WJRVFLNjTaHxl3XwWE6fca05iO91izaV1LT2B/ugxT8Pqd9APMbBlO1fx8/cPL2ptHtn7eoSmXRqLiI8lr/sRZ1LMv8LYtCK41t1/nmkkv3sh6C7JspXGp2dlYDLgaIXznwxg7ytLAzuflI11VyWQ8SkW6SahooHYPWFSXnd7FLFp4Lr0loDKNRcu4t6CQUfgSFT0LxD6FcQJ+daUkFR4DoVKDlGKjr2YXrAN4ktNXXaGwa2hVOcklOAfKQDjRFT0nSQ6QfoE2NDbFdo01kqIeI3hV/KhIiuw5pGgxiu+2eLQIQ8PdpJPUQ3W2fq0+CE/EQ60+ODDHe9tyVSWiI9LYXUANAirhvO0bFo4j+hilTpADbMUREUjDjC0WCMK0hloYZHhaIYYCzKYRihZh2F0vEKFc2t0IYVsipSLNLg80sDXZAGmYfWAxrwzDlA+IwRMTqMATEIjHryoGniFGAHGvEEHA2jXCsEaPacayQU5GwNgyLNvNjg8/92OCzPTb43F+s+NyS8OeWhD+bJHwsif8OLYmKdSZIb+y8ym0KO5r/MnXarbGMio1wdk4e7dL8LQ8t9TPCkT1p0ezZe292dLGMf0K9/QdGU6ATWxUAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f27 ?f29 ?f28 ?f30" svg:viewBox="0 0 0 0" draw:type="ooxml-wave" draw:modifiers="12500 0" draw:enhanced-path="M ?f13 ?f2 C ?f17 ?f4 ?f18 ?f5 ?f15 ?f2 L ?f20 ?f6 C ?f22 ?f8 ?f21 ?f7 ?f19 ?f6 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(20000-$0 ,$0 ,20000))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(-10000-$1 ,-10000,if(10000-$1 ,$1 ,10000))"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *10/3"></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 +0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 +?f3 -0"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 +0-?f3 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 +?f3 -0"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth*?f1 /100000"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth*?f1 /50000"></draw:equation><draw:equation draw:name="f11" draw:formula="abs(?f9 )"></draw:equation><draw:equation draw:name="f12" draw:formula="if(?f10 ,0,?f10 )"></draw:equation><draw:equation draw:name="f13" draw:formula="0+0-?f12 "></draw:equation><draw:equation draw:name="f14" draw:formula="if(?f10 ,?f10 ,0)"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth+0-?f14 "></draw:equation><draw:equation draw:name="f16" draw:formula="(?f12 +?f15 )/3"></draw:equation><draw:equation draw:name="f17" draw:formula="?f13 +?f16 -0"></draw:equation><draw:equation draw:name="f18" draw:formula="(?f17 +?f15 )/2"></draw:equation><draw:equation draw:name="f19" draw:formula="0+?f14 -0"></draw:equation><draw:equation draw:name="f20" draw:formula="logwidth+?f12 -0"></draw:equation><draw:equation draw:name="f21" draw:formula="?f19 +?f16 -0"></draw:equation><draw:equation draw:name="f22" draw:formula="(?f21 +?f20 )/2"></draw:equation><draw:equation draw:name="f23" draw:formula="logwidth+0-?f11 "></draw:equation><draw:equation draw:name="f24" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f25" draw:formula="?f24 +?f9 -0"></draw:equation><draw:equation draw:name="f26" draw:formula="?f24 +0-?f9 "></draw:equation><draw:equation draw:name="f27" draw:formula="max(?f13 ,?f19 )"></draw:equation><draw:equation draw:name="f28" draw:formula="min(?f15 ,?f20 )"></draw:equation><draw:equation draw:name="f29" draw:formula="logheight*?f0 /50000"></draw:equation><draw:equation draw:name="f30" draw:formula="logheight+0-?f29 "></draw:equation><draw:equation draw:name="f31" draw:formula="logheight"></draw:equation><draw:equation draw:name="f32" draw:formula="logheight/2"></draw:equation><draw:handle draw:handle-position="0 ?f2" draw:handle-range-y-maximum="20000" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f25 ?f31" draw:handle-range-x-maximum="10000" draw:handle-range-x-minimum="-10000"></draw:handle></draw:enhanced-geometry>
    ooxml_wave("ooxml-wave", "H4sIAAAAAAAAAJ1XbZOaMBD+KxmmH/A0YxLUO26Oc6b92vYH9FvuDJIZIBZRsb++yaL4Euh01SEGEp5nd/Nssr6tKnl4VWUmy0+1omtlClVXRwKPC11VpqKZqfQfU9YyT4JU5lsV3AzvVVXrz/vBWjU1lZWS2yRYpuKZ2CZ2zYttIhaQ7X79utfq8NU0ScAIfM/vHjcqCYxpipwe5L7jMyudalVZRC7m7DK/M38j6ywJflgGHjku8s11HffMdRz13HXmMPjdtcw2C5gnhG3cFMFt417iMQz+Ij+D97eW6fdO1tqULW8pC2tnejYjNVWxy2US6DRk9AsjEzaxXcHsB27dBXejkQWc3iD+i4D3EFDewnIyabuO6vLMXfwBKnFPlZt1pvQ6q5+WKSNTwGQoyOge0sX+ibNphIKZ9cGMGbVqIiigeS+Qg6E4xxaDsQKzBM6sZ9+sxUP+vfQCPeBf3OPfQa/qzEqBPyQF7qXKLeQcj+jlhvzYhss0JsgU84Rv08naBEkMv0g8T/UM1pIjVcE92Xd2naxD2uWp/7wCrXkzpHleDoTg4xg22REyxXlPDtiN3IEtsOLlXhqEcBScLRM4NC8X2BiihbRKDCbAGOKGhfPUD4fWQwETXgaEcBSO4ZDEBkx4+r/VGcfpTHhpcIbD2tW3+8+ckzE6YJ72WyjnX4x0zxN+IZsQxD+BFUUe4p72C12GIPxJu5o4uL6D4LoowG/bUV8eXJ+dyABGXiJ0eDic4fpnWGi2+Fzlilz16cZstZvhKttlV1SdBitZrhU9UrvGutgVSQA14cAcXbZzLvFtZ/wPt2V2lW4XnBvs5sLPh/ibC39bZHpGnAJy///h/S8tFZT9WAwAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f33 ?f35 ?f34 ?f36" svg:viewBox="0 0 0 0" draw:type="ooxml-doubleWave" draw:modifiers="6250 0" draw:enhanced-path="M ?f13 ?f2 C ?f17 ?f4 ?f19 ?f5 ?f20 ?f2 ?f21 ?f4 ?f22 ?f5 ?f15 ?f2 L ?f24 ?f6 C ?f29 ?f8 ?f28 ?f7 ?f27 ?f6 ?f26 ?f8 ?f25 ?f7 ?f23 ?f6 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(12500-$0 ,$0 ,12500))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(-10000-$1 ,-10000,if(10000-$1 ,$1 ,10000))"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="?f2 *10/3"></draw:equation><draw:equation draw:name="f4" draw:formula="?f2 +0-?f3 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f2 +?f3 -0"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight+0-?f2 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 +0-?f3 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 +?f3 -0"></draw:equation><draw:equation draw:name="f9" draw:formula="logwidth*?f1 /100000"></draw:equation><draw:equation draw:name="f10" draw:formula="logwidth*?f1 /50000"></draw:equation><draw:equation draw:name="f11" draw:formula="abs(?f9 )"></draw:equation><draw:equation draw:name="f12" draw:formula="if(?f10 ,0,?f10 )"></draw:equation><draw:equation draw:name="f13" draw:formula="0+0-?f12 "></draw:equation><draw:equation draw:name="f14" draw:formula="if(?f10 ,?f10 ,0)"></draw:equation><draw:equation draw:name="f15" draw:formula="logwidth+0-?f14 "></draw:equation><draw:equation draw:name="f16" draw:formula="(?f12 +?f15 )/6"></draw:equation><draw:equation draw:name="f17" draw:formula="?f13 +?f16 -0"></draw:equation><draw:equation draw:name="f18" draw:formula="(?f12 +?f15 )/3"></draw:equation><draw:equation draw:name="f19" draw:formula="?f13 +?f18 -0"></draw:equation><draw:equation draw:name="f20" draw:formula="(?f13 +?f15 )/2"></draw:equation><draw:equation draw:name="f21" draw:formula="?f20 +?f16 -0"></draw:equation><draw:equation draw:name="f22" draw:formula="(?f21 +?f15 )/2"></draw:equation><draw:equation draw:name="f23" draw:formula="0+?f14 -0"></draw:equation><draw:equation draw:name="f24" draw:formula="logwidth+?f12 -0"></draw:equation><draw:equation draw:name="f25" draw:formula="?f23 +?f16 -0"></draw:equation><draw:equation draw:name="f26" draw:formula="?f23 +?f18 -0"></draw:equation><draw:equation draw:name="f27" draw:formula="(?f23 +?f24 )/2"></draw:equation><draw:equation draw:name="f28" draw:formula="?f27 +?f16 -0"></draw:equation><draw:equation draw:name="f29" draw:formula="(?f28 +?f24 )/2"></draw:equation><draw:equation draw:name="f30" draw:formula="logwidth+0-?f11 "></draw:equation><draw:equation draw:name="f31" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f32" draw:formula="?f31 +?f9 -0"></draw:equation><draw:equation draw:name="f33" draw:formula="max(?f13 ,?f23 )"></draw:equation><draw:equation draw:name="f34" draw:formula="min(?f15 ,?f24 )"></draw:equation><draw:equation draw:name="f35" draw:formula="logheight*?f0 /50000"></draw:equation><draw:equation draw:name="f36" draw:formula="logheight+0-?f35 "></draw:equation><draw:equation draw:name="f37" draw:formula="logheight"></draw:equation><draw:equation draw:name="f38" draw:formula="logheight/2"></draw:equation><draw:handle draw:handle-position="0 ?f2" draw:handle-range-y-maximum="12500" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f32 ?f37" draw:handle-range-x-maximum="10000" draw:handle-range-x-minimum="-10000"></draw:handle></draw:enhanced-geometry>
    ooxml_doubleWave("ooxml-doubleWave", "H4sIAAAAAAAAAJ1XXW+bMBT9KxbaA2mDYpuGJFVppO112+ukvbnFJJYAZ4R87dfPvgQ3icm2iypck2vOPbbP8cdLVovDs6zWonqXWbSSupRNfSLwc6nqWtfRWtfqt64aUaRBLoqtDK7Ce1k36v022MhjE4laim0aLPM4JqaY2uLJFklAtvvV817Jw2d9TANK4K/79rSRaaD1sSyiTO/eCvlD7F1WnalcydrgJnz68ZHrw0Y06zT4ZtIwm5WTL7Y6M4VNzRamsEQ4haB52DnE+TnEIE6+2tIGEoDg9su5rdjC4vEZBE0l6ULTLhRD6Cf5Hry+tPx+7USjdNWyrURpuph35HNdl7tCpIHKQxp9omRMx6bKTAfbV/vA22hkACdXiH9LwHoSRIxSC8vIuK1CKvebfeANmYrfpir0ai3Vat08LHNKJoBJUZDxLaSdlgdGJzEK5qkP5pFGRogEBTTtBbIwEa5jyd2xAlocR2vm00oG9W/eCzSgf4ue/h1U1qyNFNggKTDPKteQUzyi5w3xtg2X+YIgLeYJ39jJcAITw38knqd6CnPJkKpgnuwdrzM7JC9P/d0MtPSekPQ8D4TQx0dYf0eTBIfW4wGz/FuwBCte5tngmhlu8WGeFxyzOZYZ90wQOjDLjOPQPAPArjhozLhnghB21oHMeiwACsOy8izgJAszioXrW/8Hiox78ndYeFl44g87MHN+QQ9+zy5gTjrDeumJP4Tz0zBm8d09oF2BGG4Fij39d3BYXp74zZYJ2l9gByz2lF+KY2vyMcwpbs2OPQOUqgrBk+N2CnBwfVvA5RkPvwvH/zgKmUsDDs/zgsPD4XgucDj31WFuIFkhyUU92uitsi3sHWfpzsjnYC2qlYxOkZljVe7KNIAj/p02qmrbfIxv2+J/cptxtJcbNzhX2MeL/DB//W26/O2dwSNxHpDbm+TrH1axBUBiDgAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f6 ?f12 ?f9 ?f13" svg:viewBox="0 0 0 0" draw:type="ooxml-mathPlus" draw:modifiers="23520" draw:enhanced-path="M ?f6 ?f12 L ?f7 ?f12 ?f7 ?f11 ?f8 ?f11 ?f8 ?f12 ?f9 ?f12 ?f9 ?f13 ?f8 ?f13 ?f8 ?f14 ?f7 ?f14 ?f7 ?f13 ?f6 ?f13 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(73490-$0 ,$0 ,73490))"></draw:equation><draw:equation draw:name="f1" draw:formula="logwidth*73490/200000"></draw:equation><draw:equation draw:name="f2" draw:formula="logheight*73490/200000"></draw:equation><draw:equation draw:name="f3" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 *?f0 /200000"></draw:equation><draw:equation draw:name="f5" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f6" draw:formula="?f5 +0-?f1 "></draw:equation><draw:equation draw:name="f7" draw:formula="?f5 +0-?f4 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f5 +?f4 -0"></draw:equation><draw:equation draw:name="f9" draw:formula="?f5 +?f1 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f10 +0-?f2 "></draw:equation><draw:equation draw:name="f12" draw:formula="?f10 +0-?f4 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f10 +?f4 -0"></draw:equation><draw:equation draw:name="f14" draw:formula="?f10 +?f2 -0"></draw:equation><draw:handle draw:handle-position="0 ?f12" draw:handle-range-y-maximum="73490" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_mathPlus("ooxml-mathPlus", "H4sIAAAAAAAAAJ2VXW+DIBSG/wohu2i3kor2O7Umu96WXe+OVFASkQ6xH/v1Qx121bYJ1YgHOTzn5eSA61iRw4rmKcm3NEYJlYJqdQL1Z8GVkgqlUvEfmWuShZCRrKDwYnhPlebb7qCmR42IoqQIYcRmIGLYN82yMgIIin2y2nN6eJXHEHqgvu3M046GUMqjyJAgOv3MysJGlDFnnCrD9IOpb2e08nfGPYTvoA34Zl5zG7s2sGkWF0Yr66zPDrXGxE5vjcAGCcAX+ICbdaPkuySay7zRlRNhVsKsTCaVKDMSQs4GHnrywMgbGXMeTJZNt3rq3nBogOML4r0AuBsgk8mBxzp9rmlj36suJ6R/BZlSnqT6cWbQZQqeD6zUURvAbe2TLjRiAXiOmAcekTi9lcmx78SZ9VVNwYuHTL0AJ9D8JmjiBlpcBVUY5Jai5Q0QdgXh3r5oS8Ax27i3AYwcr0mT75Ym3Cv8M8ox47hX7w3qgZzjK1XeoPw7KHMoxhkF/2y0kwWvPKozNzov9m9UkTyh6GRO3SMXpQhhvdVv+PC88TmHbzxaMd1/yuYX/XWc6mwGAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f7 ?f4 ?f8 ?f5" svg:viewBox="0 0 0 0" draw:type="ooxml-mathMinus" draw:modifiers="23520" draw:enhanced-path="M ?f7 ?f4 L ?f8 ?f4 ?f8 ?f5 ?f7 ?f5 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(100000-$0 ,$0 ,100000))"></draw:equation><draw:equation draw:name="f1" draw:formula="logheight*?f0 /200000"></draw:equation><draw:equation draw:name="f2" draw:formula="logwidth*73490/200000"></draw:equation><draw:equation draw:name="f3" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f4" draw:formula="?f3 +0-?f1 "></draw:equation><draw:equation draw:name="f5" draw:formula="?f3 +?f1 -0"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f7" draw:formula="?f6 +0-?f2 "></draw:equation><draw:equation draw:name="f8" draw:formula="?f6 +?f2 -0"></draw:equation><draw:handle draw:handle-position="0 ?f4" draw:handle-range-y-maximum="100000" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_mathMinus("ooxml-mathMinus", "H4sIAAAAAAAAAJ2UUW+DIBDHvwohe1i7klKtbdeUmux53QfYG6mgJAIdYmv36Yda3ep0icNcAtzd739HwF1k6GXLVELVkUUoZloya66g2pbCGG1Qoo341MrSlEBO04zBO/eZGSuOXadlhUXUMJoRGPI1CPnS2cZZAEF2jrdnwS4vuiAQg+pr8q4nRqDWhUyRpDY5CJVnjaCOBBfMOKTnB16T0lZ/cvEEHkCj93pTbJVvngC8gze439XZHzm1Qquapah08rxBc21knlICBX/E6AGDGZ656QKXo1qXVi8nE4ec3zH/klh0JVIdJ0zEiZ2GHIO5V0FHIb0e5EVENpmu/eUz/g/SH6xy7o0CLbugkPvgCaOQL8AoUNALKjFoXGurodMa2dn6d0GrujNvXGebXlCJGe7M3fwoZeDHHJ10JsqI8mWF7bnfnIaqmKGre1qFkLkksL67A0FC1UHf8nVEW0z3v7H/ApZycq5QBAAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f14 ?f17 ?f23 ?f30" svg:viewBox="0 0 0 0" draw:type="ooxml-mathMultiply" draw:modifiers="23520" draw:enhanced-path="M ?f14 ?f15 L ?f16 ?f17 ?f18 ?f21 ?f22 ?f17 ?f23 ?f15 ?f27 ?f24 ?f23 ?f29 ?f22 ?f30 ?f18 ?f31 ?f16 ?f30 ?f14 ?f29 ?f28 ?f24 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(51965-$0 ,$0 ,51965))"></draw:equation><draw:equation draw:name="f1" draw:formula="min(logwidth,logheight)"></draw:equation><draw:equation draw:name="f2" draw:formula="?f1 *?f0 /100000"></draw:equation><draw:equation draw:name="f3" draw:formula="(10800000*atan2(logheight,logwidth))/pi"></draw:equation><draw:equation draw:name="f4" draw:formula="1*sin(pi*(?f3 )/10800000)"></draw:equation><draw:equation draw:name="f5" draw:formula="1*cos(pi*(?f3 )/10800000)"></draw:equation><draw:equation draw:name="f6" draw:formula="1*tan(pi*(?f3 )/10800000)"></draw:equation><draw:equation draw:name="f7" draw:formula="sqrt(logwidth*logwidth+logheight*logheight+0*0)"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 *51965/100000"></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +0-?f8 "></draw:equation><draw:equation draw:name="f10" draw:formula="?f5 *?f9 /2"></draw:equation><draw:equation draw:name="f11" draw:formula="?f4 *?f9 /2"></draw:equation><draw:equation draw:name="f12" draw:formula="?f4 *?f2 /2"></draw:equation><draw:equation draw:name="f13" draw:formula="?f5 *?f2 /2"></draw:equation><draw:equation draw:name="f14" draw:formula="?f10 +0-?f12 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f11 +?f13 -0"></draw:equation><draw:equation draw:name="f16" draw:formula="?f10 +?f12 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="?f11 +0-?f13 "></draw:equation><draw:equation draw:name="f18" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f19" draw:formula="?f18 +0-?f16 "></draw:equation><draw:equation draw:name="f20" draw:formula="?f19 *?f6 /1"></draw:equation><draw:equation draw:name="f21" draw:formula="?f20 +?f17 -0"></draw:equation><draw:equation draw:name="f22" draw:formula="logwidth+0-?f16 "></draw:equation><draw:equation draw:name="f23" draw:formula="logwidth+0-?f14 "></draw:equation><draw:equation draw:name="f24" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f25" draw:formula="?f24 +0-?f15 "></draw:equation><draw:equation draw:name="f26" draw:formula="?f25 *1/?f6 "></draw:equation><draw:equation draw:name="f27" draw:formula="?f23 +0-?f26 "></draw:equation><draw:equation draw:name="f28" draw:formula="?f14 +?f26 -0"></draw:equation><draw:equation draw:name="f29" draw:formula="logheight+0-?f15 "></draw:equation><draw:equation draw:name="f30" draw:formula="logheight+0-?f17 "></draw:equation><draw:equation draw:name="f31" draw:formula="logheight+0-?f21 "></draw:equation><draw:equation draw:name="f32" draw:formula="logwidth+0-?f10 "></draw:equation><draw:equation draw:name="f33" draw:formula="logheight+0-?f11 "></draw:equation><draw:handle draw:handle-position="0 ?f2" draw:handle-range-y-maximum="51965" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_mathMultiply("ooxml-mathMultiply", "H4sIAAAAAAAAAKWX226jMBCGX8VCe5GQIGwTcqhKkfZ6uw+wd1ZiEkuAUyCnffodTM02mO5q0lRxDdjf/B7+Aed5V4nLkywPotzKXbCXupBNdSPmdKGqSlfBQVfqty4bkSdeJvJaeneXz7Jq1HZ4sZHXJhCVFHXipRlbEGhW0PAImoh6pD7vn85KXr7ra+JRYv7s3NtRJp7W1yIPCtEcXk95o475zcbVO5UpWQGZRzG3s/pFHGFK4r0SGzYmP9p/SyuBrVsdrG34nSwYCT1zuLDn+MaOi6idGzHL684t+nHrbu4v8tN7ee5UvZ1Eo3TZaSxFASvLrORMV8UpF4mnsgkNvlEyp3PoxmyzjM1h+zVH0ykAwzvivwKwYYBClZNc7y9q1xzm0DlItT80OCgfQmHpxE8zSkJG2w+KFg1pE0bXBuOLRpR80qucW+HTaXhUqCCLYRDm15CJo/IncPPINLQxcZmIXexW11/GLl0sZOLL2NUQW79VTe8G33ZmfcL9vjejPjLY2jXJivjGw4+4ZDOGm9EgzdYEVxFOzaVZ3Lp3Q0KOIznFlWaLx0gjFWVIHE1yqul9dXiSUzJQ5bRLOePInDt1AgxGZtBGJMAZgTnF0ekyqrAspyI6XWaNEXKNjuFtPWETP2J1eNt0opY4UXzE7GzT+mEJz2ocasTtvMv7Cpt37vi9f/Y8tErH9Pe4BRLnOL9/DCJvJR/xPewKOlUxUtWI7zmUNgvbm4lDjdge9jhGFseyRp7zkPCZIWFt4Tj/w/vngZRFjvsHvBWS55TAPQ+2kjjef8qAInFjZfBxuZ/Lgw3zLpfkQz846lq1I9o9edpv+d4vVqLcy+AGm/KrKk5F4pn3+idjVNmN+WuGbkSvZfij4+UP0iy0zI0MAAA="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f21 ?f14 ?f22 ?f15" svg:viewBox="0 0 0 0" draw:type="ooxml-mathDivide" draw:modifiers="23520 5880 11760" draw:enhanced-path="M ?f20 ?f18 Z M ?f20 ?f19 Z M ?f21 ?f14 L ?f22 ?f14 ?f22 ?f15 ?f21 ?f15 Z N" drawooo:enhanced-path="M ?f20 ?f18 G ?f11 ?f11 ?f25 ?f26 Z M ?f20 ?f19 G ?f11 ?f11 ?f27 ?f28 Z M ?f21 ?f14 L ?f22 ?f14 ?f22 ?f15 ?f21 ?f15 Z N"><draw:equation draw:name="f0" draw:formula="if(1000-$0 ,1000,if(36745-$0 ,$0 ,36745))"></draw:equation><draw:equation draw:name="f1" draw:formula="0+0-?f0 "></draw:equation><draw:equation draw:name="f2" draw:formula="(73490+?f1 )/4"></draw:equation><draw:equation draw:name="f3" draw:formula="36745*logwidth/logheight"></draw:equation><draw:equation draw:name="f4" draw:formula="min(?f2 ,?f3 )"></draw:equation><draw:equation draw:name="f5" draw:formula="if(1000-$2 ,1000,if(?f4 -$2 ,$2 ,?f4 ))"></draw:equation><draw:equation draw:name="f6" draw:formula="-4*?f5 /1"></draw:equation><draw:equation draw:name="f7" draw:formula="73490+?f6 -?f0 "></draw:equation><draw:equation draw:name="f8" draw:formula="if(0-$1 ,0,if(?f7 -$1 ,$1 ,?f7 ))"></draw:equation><draw:equation draw:name="f9" draw:formula="logheight*?f0 /200000"></draw:equation><draw:equation draw:name="f10" draw:formula="logheight*?f8 /100000"></draw:equation><draw:equation draw:name="f11" draw:formula="logheight*?f5 /100000"></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth*73490/200000"></draw:equation><draw:equation draw:name="f13" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f14" draw:formula="?f13 +0-?f9 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f13 +?f9 -0"></draw:equation><draw:equation draw:name="f16" draw:formula="?f10 +?f11 -0"></draw:equation><draw:equation draw:name="f17" draw:formula="?f14 +0-?f16 "></draw:equation><draw:equation draw:name="f18" draw:formula="?f17 +0-?f11 "></draw:equation><draw:equation draw:name="f19" draw:formula="logheight+0-?f18 "></draw:equation><draw:equation draw:name="f20" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f21" draw:formula="?f20 +0-?f12 "></draw:equation><draw:equation draw:name="f22" draw:formula="?f20 +?f12 -0"></draw:equation><draw:equation draw:name="f23" draw:formula="?f20 +0-?f11 "></draw:equation><draw:equation draw:name="f24" draw:formula="logwidth"></draw:equation><draw:equation draw:name="f25" draw:formula="(16200000)/60000.0"></draw:equation><draw:equation draw:name="f26" draw:formula="(21600000)/60000.0"></draw:equation><draw:equation draw:name="f27" draw:formula="(5400000)/60000.0"></draw:equation><draw:equation draw:name="f28" draw:formula="(21600000)/60000.0"></draw:equation><draw:handle draw:handle-position="0 ?f14" draw:handle-range-y-maximum="36745" draw:handle-range-y-minimum="1000"></draw:handle><draw:handle draw:handle-position="?f24 ?f17" draw:handle-range-y-maximum="?f7" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f23 0" draw:handle-range-x-maximum="?f4" draw:handle-range-x-minimum="1000"></draw:handle></draw:enhanced-geometry>
    ooxml_mathDivide("ooxml-mathDivide", "H4sIAAAAAAAAAKWXW2+bMBSA/4qF+kDSMGxzTVWKNE3ay7YfsDdU7GAJcEZIQvfrZ5tACE66Ok0E+MZ3zvG5xHnOm+z4ROoiq19J7mwIr0jbvAE1XLGm4Y1T8Ib95XWblYlFs3JHrIvpA2la9jqfbEnXOllDsl1ipRQjkFLkixvGshVYYHfYPB0YOX7lXWJBoL7Du29bklicd1XpVFlbfGMHlo9Sec4oI43gYi/AEARxDAFCUTi8PlqzFe8m1k8pFUqpMfgNzr310Dvp9mPUbqLnOB+I1b96AZzz92R8lw803LBChDPJszWRvMV36PPy3Fv8Z5+1jNe9/XVWie2jw3ZQ3lT7MkssRm0EIXQeIFjJxkoMeGHkB2pEXqq3WAise8F9Twyai4GP0EkpBEYUPKfYkeev4aOwFCxc34jlzVnKrGXJN0eWt4UrGgVhm6I1ovpzasVqW3gDrFLqAbM9C266Bp9dk1IfqIEHJcMHho4J50Icf5nSALjICBPNMYNjQmDu5viK4cJqBFYnkyOgevKSHUOT13P86OqlVNXFUH7MwltLoykzFrt5B1PLmSkzuI+pZdAQ70vlsLts1zJp1NPFZiQte0Rie0BVirVZCCEteXqUBDmG9mkpIlBQokRZNmVpeaIKt7IQhYYmamkiGNGJhQxZt3Oi58WGhfpaPvR11SwksJYE6uexVwobKqUFf89SJENHYi3oJ3oZbj7Wwn7YLDOMFvI2Cvt8XrihfHwxtFELfBuj8DNALfrtwP8MT8uAjysoDmZ5ScCk7Wz5jskV8qCZnovRabbJ6g1x3sRRs2PVvjqdF26sYXW/Bk2Lab/oI/JFLMnT3FgtbqmQ0lsrBgXulO6Np+wLcDcVfXV/uv/YfvLF/J/Eyz+nPvT4YgwAAA=="),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f13 ?f10 ?f14 ?f11" svg:viewBox="0 0 0 0" draw:type="ooxml-mathEqual" draw:modifiers="23520 11760" draw:enhanced-path="M ?f13 ?f10 L ?f14 ?f10 ?f14 ?f8 ?f13 ?f8 Z M ?f13 ?f9 L ?f14 ?f9 ?f14 ?f11 ?f13 ?f11 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(36745-$0 ,$0 ,36745))"></draw:equation><draw:equation draw:name="f1" draw:formula="?f0 *2/1"></draw:equation><draw:equation draw:name="f2" draw:formula="100000+0-2"></draw:equation><draw:equation draw:name="f3" draw:formula="if(0-$1 ,0,if(?f2 -$1 ,$1 ,?f2 ))"></draw:equation><draw:equation draw:name="f4" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight*?f3 /200000"></draw:equation><draw:equation draw:name="f6" draw:formula="logwidth*73490/200000"></draw:equation><draw:equation draw:name="f7" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f8" draw:formula="?f7 +0-?f5 "></draw:equation><draw:equation draw:name="f9" draw:formula="?f7 +?f5 -0"></draw:equation><draw:equation draw:name="f10" draw:formula="?f8 +0-?f4 "></draw:equation><draw:equation draw:name="f11" draw:formula="?f9 +?f4 -0"></draw:equation><draw:equation draw:name="f12" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f13" draw:formula="?f12 +0-?f6 "></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 +?f6 -0"></draw:equation><draw:equation draw:name="f15" draw:formula="(?f10 +?f8 )/2"></draw:equation><draw:equation draw:name="f16" draw:formula="(?f9 +?f11 )/2"></draw:equation><draw:equation draw:name="f17" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="0 ?f10" draw:handle-range-y-maximum="36745" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f17 ?f8" draw:handle-range-y-maximum="?f2" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_mathEqual("ooxml-mathEqual", "H4sIAAAAAAAAAJ1V246bMBD9FcvqQ5JdCxtICKtlkSr1re0H9M1abLAEOHWcW7++tgmwG8h23SAsHI/POTOeGT8Xip6eWFvR9pUVqGSyYVpdgPu7EUpJhSqpxB/ZalpnkNN6z+C75SNTWrzeLmp21ogqRvcZzDmJgBmwHWI7EAj2x/LpKNjpqzxnEAP39HsvO5ZBKc9NjRqqq2+/D7TuSWUhuGDKwIbROsSAkGTTbxz82JldGfwBRubvA/egYtsvb8EvMNimo2k66h2QiLH9CV+eOz4jTAvZduwtbYxs3ovhUjWHmmZQ8AVGXzB4xI/mM9ok8dpN7etmy6UBDN4hfkRAbglyjsEqDIgXSniLQrD9PWAUeuFE8+6Sq7s5D4Gb2ddOPJ2Nb+FrWVZMlJVeWbeDTrUX5PojyAgEoT/kZgbyJApdrZIoTvH/QCZ3VQZ+B7SdpksCzDHnfA28gNJZIAuD/FwjkxKxNegkxX6SyEwtpFZT7K1pUg/9EXqGm0wKwnSNsPNu4+ndJPk7KAvk694k6ReuFT7YyC99XZyk++IadtMevcHmEt0F/h6M6fFFzcCbb7STe2Et7E2Sj/l1XVW0LRm6mLvkLJpDk0HXde/YiLazGePbWXyG3FAn9j75B30+NN/PkwfzF/XLX2mqmsLBBwAA"),

    // <draw:enhanced-geometry draw:mirror-horizontal="false" draw:mirror-vertical="false" draw:text-areas="?f9 ?f14 ?f10 ?f15" svg:viewBox="0 0 0 0" draw:type="ooxml-mathNotEqual" draw:modifiers="23520 6600000 11760" draw:enhanced-path="M ?f9 ?f14 L ?f24 ?f14 ?f43 ?f47 ?f42 ?f46 ?f34 ?f14 ?f10 ?f14 ?f10 ?f12 ?f35 ?f12 ?f36 ?f13 ?f10 ?f13 ?f10 ?f15 ?f37 ?f15 ?f49 ?f51 ?f48 ?f50 ?f30 ?f15 ?f9 ?f15 ?f9 ?f13 ?f28 ?f13 ?f26 ?f12 ?f9 ?f12 Z N"><draw:equation draw:name="f0" draw:formula="if(0-$0 ,0,if(50000-$0 ,$0 ,50000))"></draw:equation><draw:equation draw:name="f1" draw:formula="if(4200000-$1 ,4200000,if(6600000-$1 ,$1 ,6600000))"></draw:equation><draw:equation draw:name="f2" draw:formula="?f0 *2/1"></draw:equation><draw:equation draw:name="f3" draw:formula="100000+0-2"></draw:equation><draw:equation draw:name="f4" draw:formula="if(0-$2 ,0,if(?f3 -$2 ,$2 ,?f3 ))"></draw:equation><draw:equation draw:name="f5" draw:formula="logheight*?f0 /100000"></draw:equation><draw:equation draw:name="f6" draw:formula="logheight*?f4 /200000"></draw:equation><draw:equation draw:name="f7" draw:formula="logwidth*73490/200000"></draw:equation><draw:equation draw:name="f8" draw:formula="logwidth/2"></draw:equation><draw:equation draw:name="f9" draw:formula="?f8 +0-?f7 "></draw:equation><draw:equation draw:name="f10" draw:formula="?f8 +?f7 -0"></draw:equation><draw:equation draw:name="f11" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f12" draw:formula="?f11 +0-?f6 "></draw:equation><draw:equation draw:name="f13" draw:formula="?f11 +?f6 -0"></draw:equation><draw:equation draw:name="f14" draw:formula="?f12 +0-?f5 "></draw:equation><draw:equation draw:name="f15" draw:formula="?f13 +?f5 -0"></draw:equation><draw:equation draw:name="f16" draw:formula="?f1 +0-5400000"></draw:equation><draw:equation draw:name="f17" draw:formula="logheight/2"></draw:equation><draw:equation draw:name="f18" draw:formula="?f17 *tan(pi*(?f16 )/10800000)"></draw:equation><draw:equation draw:name="f19" draw:formula="sqrt(?f18 *?f18 +?f17 *?f17 +0*0)"></draw:equation><draw:equation draw:name="f20" draw:formula="?f19 *?f5 /?f17 "></draw:equation><draw:equation draw:name="f21" draw:formula="?f20 *1/2"></draw:equation><draw:equation draw:name="f22" draw:formula="?f8 +?f18 -?f21 "></draw:equation><draw:equation draw:name="f23" draw:formula="?f18 *?f14 /?f17 "></draw:equation><draw:equation draw:name="f24" draw:formula="?f22 +0-?f23 "></draw:equation><draw:equation draw:name="f25" draw:formula="?f18 *?f12 /?f17 "></draw:equation><draw:equation draw:name="f26" draw:formula="?f22 +0-?f25 "></draw:equation><draw:equation draw:name="f27" draw:formula="?f18 *?f13 /?f17 "></draw:equation><draw:equation draw:name="f28" draw:formula="?f22 +0-?f27 "></draw:equation><draw:equation draw:name="f29" draw:formula="?f18 *?f15 /?f17 "></draw:equation><draw:equation draw:name="f30" draw:formula="?f22 +0-?f29 "></draw:equation><draw:equation draw:name="f31" draw:formula="?f18 *2/1"></draw:equation><draw:equation draw:name="f32" draw:formula="?f22 +0-?f31 "></draw:equation><draw:equation draw:name="f33" draw:formula="?f22 +?f20 -0"></draw:equation><draw:equation draw:name="f34" draw:formula="?f24 +?f20 -0"></draw:equation><draw:equation draw:name="f35" draw:formula="?f26 +?f20 -0"></draw:equation><draw:equation draw:name="f36" draw:formula="?f28 +?f20 -0"></draw:equation><draw:equation draw:name="f37" draw:formula="?f30 +?f20 -0"></draw:equation><draw:equation draw:name="f38" draw:formula="?f32 +?f20 -0"></draw:equation><draw:equation draw:name="f39" draw:formula="?f5 *?f17 /?f19 "></draw:equation><draw:equation draw:name="f40" draw:formula="?f22 +?f39 -0"></draw:equation><draw:equation draw:name="f41" draw:formula="?f33 +0-?f39 "></draw:equation><draw:equation draw:name="f42" draw:formula="if(?f16 ,?f40 ,?f33 )"></draw:equation><draw:equation draw:name="f43" draw:formula="if(?f16 ,?f22 ,?f41 )"></draw:equation><draw:equation draw:name="f44" draw:formula="?f5 *?f18 /?f19 "></draw:equation><draw:equation draw:name="f45" draw:formula="0+0-?f44 "></draw:equation><draw:equation draw:name="f46" draw:formula="if(?f16 ,?f44 ,0)"></draw:equation><draw:equation draw:name="f47" draw:formula="if(?f16 ,0,?f45 )"></draw:equation><draw:equation draw:name="f48" draw:formula="logwidth+0-?f42 "></draw:equation><draw:equation draw:name="f49" draw:formula="logwidth+0-?f43 "></draw:equation><draw:equation draw:name="f50" draw:formula="logheight+0-?f46 "></draw:equation><draw:equation draw:name="f51" draw:formula="logheight+0-?f47 "></draw:equation><draw:equation draw:name="f52" draw:formula="(?f42 +?f43 )/2"></draw:equation><draw:equation draw:name="f53" draw:formula="(?f49 +?f48 )/2"></draw:equation><draw:equation draw:name="f54" draw:formula="(?f46 +?f47 )/2"></draw:equation><draw:equation draw:name="f55" draw:formula="(?f14 +?f12 )/2"></draw:equation><draw:equation draw:name="f56" draw:formula="(?f13 +?f15 )/2"></draw:equation><draw:equation draw:name="f57" draw:formula="(?f51 +?f50 )/2"></draw:equation><draw:equation draw:name="f58" draw:formula="logwidth"></draw:equation><draw:handle draw:handle-position="0 ?f14" draw:handle-range-y-maximum="50000" draw:handle-range-y-minimum="0"></draw:handle><draw:handle draw:handle-position="?f43 0"></draw:handle><draw:handle draw:handle-position="?f58 ?f12" draw:handle-range-y-maximum="?f3" draw:handle-range-y-minimum="0"></draw:handle></draw:enhanced-geometry>
    ooxml_mathNotEqual("ooxml-mathNotEqual", "H4sIAAAAAAAAAJ2YbW+bMBDHv4qF9oKEouAnAlXTSJP2btsH2DvUQIIUICW0TffpZ5+BNLHT9WgV1wT357vz/c3hh02bvd3n9S6rn/JNuM2bKu/adwJfV2XbNm24a9ryb1N32X7lFdn+mHsXt1/ztiufrm92+akLszbPjitvXaRkXVChm0g30iPH1+39a5m/fW9OKy8i8Dv86/shX3lNc6r2YZV1u99N9+P5JdsP0zabsijzVoEZlywicRzpH0LpMh4Yo0cHBVh5v8how0/1h4nBHsF1s9QN002sGi4urT339BAux54eTPl499zTQ/hy6Ak9s6S6l+ieHsLHcelFRzNYMvbiYa7UdP6Q397jg/FQhaQrm9r4W2eVilkxuF80bfWyz1ZeWfhR+C0id9Gd6kodJ7jUH7iazRRwcUH8bALqmECwyHApuev7erJ+WeBr/emvkROy6wnXRUTmbEFRFH5NoWBLEIUMxRHu+LI+vmpdCVzpj75AOiuv8ftmu8vL7a6ba7cXxmoUMv4MKciC4ZFLB/Kt3HS7+ZKLNJqCTG4hF7j1Se1sSYha5XWxJLg8t5QEJM0Jca5RSzLjCiCdow4tUGrci5HuWYIwKA3C+mdpAnYqsEoirbLyH/bBQIOwVll5r1DaKCnw2UldGT9tCa1EV2YtybzLav9QztUGQmMyUzpPzF6Jg1vZf3xuO81MyBzawMwGbRDNkXzm0ARNNU6SBTBxOEsY6oGn9naKjClzyMK4mhCVg4wizXJJwwRQTHLToQ/W64NxJMslEGMbm2SbQyWjbUjxMksko218km0OqYy2YVmO50Jv26TU5Q4ljLalSJZDBto2dInjkMFgE0dqgDs0oFkgUOROzF35LyayHPmvauRpLFfuJxNZjtxXFf40liPv+dTYO/Je9vv/AjZvXPV7I+2VgSnWNOFIe877dMXaZaU+1OLqUaqKcBFBKa5qcRzTksAHJoPyXlAs0yEF2T+apyyHpYYIwicEkmMp4WP4hHq3QbppqWHkRZoosWG7+XZg3GVIdy1RXOKQz2RpiWIsDg0PWZrL2+8Lhod8VklLHD7ELABXZ8hiS1qy8OGAI4DDDTTNEoQPAQvATTTN0oMPRVsA5RGaZqnCH95GVNGAplma8OFMKIDzIDTtpiJuYXZZvdnn5EM/PDTHUo/Qx2/r82tcf7fN6m0evodVdiqrl2rlwWnRjTFlbcacHwFmxFcmhzSc9o8SDsrYfwxfj6c/Xze7j+H1sejjP+LkhbwvFQAA");
    //

    private String shapeType;

    private String shapeGeometry;

    private static Map<String, EnhancedGeometryType> nameToEnumMap = Collections.unmodifiableMap(initializeNameToEnumMap());

    public static EnhancedGeometryType fromValue(String val) {
        return nameToEnumMap.get(val);
    }

    EnhancedGeometryType(String shapeType, String shapeGeometry) {
        this.shapeType = shapeType;
        this.shapeGeometry = shapeGeometry;
    }

    public String getShapeGeometry() {
        return shapeGeometry;
    }

    public boolean isOOXMLType() {
        return shapeType.startsWith("ooxml-");
    }

    public STShapeType getPresetShape() {
        if(isOOXMLType()) {
            return STShapeType.fromValue(shapeType.substring(6));
        }
        STShapeType ret = OOShapeTypes.get(shapeType);
        if(ret==null) {
            ret = OOShapeTypesDblKey.get(shapeType);
        }
        return ret;
    }

    public static STShapeType getPresetShape(String shapeType) {
        final EnhancedGeometryType enhancedGeometryTypes = EnhancedGeometryType.fromValue(shapeType);
        if(enhancedGeometryTypes!=null) {
            return enhancedGeometryTypes.getPresetShape();
        }
        return null;
    }

    private static Map<String, EnhancedGeometryType> initializeNameToEnumMap() {
        final Map<String, EnhancedGeometryType> mMap = new HashMap<String, EnhancedGeometryType>();
        for (EnhancedGeometryType s : EnhancedGeometryType.values()) {
            mMap.put(s.shapeType, s);
        }
        return mMap;
    }

    static final public ImmutableBiMap<String, STShapeType> OOShapeTypes = ImmutableBiMap.<String, STShapeType> builder()
        .put("rectangle",                   STShapeType.RECT)
        .put("round-rectangle",             STShapeType.ROUND_RECT)
        .put("frame",                       STShapeType.FRAME)
        .put("ellipse",                     STShapeType.ELLIPSE)
        .put("diamond",                     STShapeType.DIAMOND)
        .put("isosceles-triangle",          STShapeType.TRIANGLE)
        .put("right-triangle",              STShapeType.RT_TRIANGLE)
        .put("parallelogram",               STShapeType.PARALLELOGRAM)
        .put("trapezoid",                   STShapeType.TRAPEZOID)
        .put("hexagon",                     STShapeType.HEXAGON)
        .put("octagon",                     STShapeType.OCTAGON)
        .put("cross",                       STShapeType.PLUS)
        .put("star5",                       STShapeType.STAR_5)
        .put("right-arrow",                 STShapeType.RIGHT_ARROW)
        .put("pentagon-right",              STShapeType.HOME_PLATE)
        .put("cube",                        STShapeType.CUBE)
        .put("mso-spt17",                   STShapeType.CLOUD)
        .put("mso-spt19",                   STShapeType.ARC)
        .put("mso-spt20",                   STShapeType.LINE)
        .put("mso-spt21",                   STShapeType.PLAQUE)
        .put("can",                         STShapeType.CAN)
        .put("ring",                        STShapeType.DONUT)
        .put("mso-spt32",                   STShapeType.STRAIGHT_CONNECTOR_1)
        .put("mso-spt33",                   STShapeType.BENT_CONNECTOR_2)
        .put("mso-spt34",                   STShapeType.BENT_CONNECTOR_3)
        .put("mso-spt35",                   STShapeType.BENT_CONNECTOR_4)
        .put("mso-spt36",                   STShapeType.BENT_CONNECTOR_5)
        .put("mso-spt37",                   STShapeType.CURVED_CONNECTOR_2)
        .put("mso-spt38",                   STShapeType.CURVED_CONNECTOR_3)
        .put("mso-spt39",                   STShapeType.CURVED_CONNECTOR_4)
        .put("mso-spt40",                   STShapeType.CURVED_CONNECTOR_5)
        .put("mso-spt41",                   STShapeType.CALLOUT_1)
        .put("mso-spt42",                   STShapeType.CALLOUT_2)
        .put("mso-spt43",                   STShapeType.CALLOUT_3)
        .put("mso-spt44",                   STShapeType.ACCENT_CALLOUT_1)
        .put("mso-spt45",                   STShapeType.ACCENT_CALLOUT_2)
        .put("mso-spt46",                   STShapeType.ACCENT_CALLOUT_3)
        .put("line-callout-1",              STShapeType.BORDER_CALLOUT_1)
        .put("line-callout-2",              STShapeType.BORDER_CALLOUT_2)
        .put("line-callout-3",              STShapeType.BORDER_CALLOUT_3)
        .put("mso-spt50",                   STShapeType.ACCENT_BORDER_CALLOUT_1)
        .put("mso-spt51",                   STShapeType.ACCENT_BORDER_CALLOUT_2)
        .put("mso-spt52",                   STShapeType.ACCENT_BORDER_CALLOUT_3)
        .put("mso-spt53",                   STShapeType.RIBBON)
        .put("mso-spt54",                   STShapeType.RIBBON_2)
        .put("chevron",                     STShapeType.CHEVRON)
        .put("pentagon",                    STShapeType.PENTAGON)
        .put("forbidden",                   STShapeType.NO_SMOKING)
        .put("star8",                       STShapeType.STAR_8)
        .put("mso-spt59",                   STShapeType.STAR_16)
        .put("mso-spt60",                   STShapeType.STAR_32)
        .put("rectangular-callout",         STShapeType.WEDGE_RECT_CALLOUT)
        .put("round-rectangular-callout",   STShapeType.WEDGE_ROUND_RECT_CALLOUT)
        .put("round-callout",               STShapeType.WEDGE_ELLIPSE_CALLOUT)
        .put("mso-spt64",                   STShapeType.WAVE)
        .put("paper",                       STShapeType.FOLDED_CORNER)
        .put("left-arrow",                  STShapeType.LEFT_ARROW)
        .put("down-arrow",                  STShapeType.DOWN_ARROW)
        .put("up-arrow",                    STShapeType.UP_ARROW)
        .put("left-right-arrow",            STShapeType.LEFT_RIGHT_ARROW)
        .put("up-down-arrow",               STShapeType.UP_DOWN_ARROW)
        .put("mso-spt71",                   STShapeType.IRREGULAR_SEAL_1)
        .put("bang",                        STShapeType.IRREGULAR_SEAL_2)
        .put("lightning",                   STShapeType.LIGHTNING_BOLT)
        .put("heart",                       STShapeType.HEART)
        .put("quad-arrow",                  STShapeType.QUAD_ARROW)
        .put("left-arrow-callout",          STShapeType.LEFT_ARROW_CALLOUT)
        .put("right-arrow-callout",         STShapeType.RIGHT_ARROW_CALLOUT)
        .put("up-arrow-callout",            STShapeType.UP_ARROW_CALLOUT)
        .put("down-arrow-callout",          STShapeType.DOWN_ARROW_CALLOUT)
        .put("left-right-arrow-callout",    STShapeType.LEFT_RIGHT_ARROW_CALLOUT)
        .put("up-down-arrow-callout",       STShapeType.UP_DOWN_ARROW_CALLOUT)
        .put("quad-arrow-callout",          STShapeType.QUAD_ARROW_CALLOUT)
        .put("quad-bevel",                  STShapeType.BEVEL)
        .put("left-bracket",                STShapeType.LEFT_BRACKET)
        .put("right-bracket",               STShapeType.RIGHT_BRACKET)
        .put("left-brace",                  STShapeType.LEFT_BRACE)
        .put("right-brace",                 STShapeType.RIGHT_BRACE)
        .put("mso-spt89",                   STShapeType.LEFT_UP_ARROW)
        .put("mso-spt90",                   STShapeType.BENT_UP_ARROW)
        .put("mso-spt91",                   STShapeType.BENT_ARROW)
        .put("star24",                      STShapeType.STAR_24)
        .put("striped-right-arrow",         STShapeType.STRIPED_RIGHT_ARROW)
        .put("notched-right-arrow",         STShapeType.NOTCHED_RIGHT_ARROW)
        .put("block-arc",                   STShapeType.BLOCK_ARC)
        .put("smiley",                      STShapeType.SMILEY_FACE)
        .put("vertical-scroll",             STShapeType.VERTICAL_SCROLL)
        .put("horizontal-scroll",           STShapeType.HORIZONTAL_SCROLL)
        .put("circular-arrow",              STShapeType.CIRCULAR_ARROW)
        .put("mso-spt101",                  STShapeType.UTURN_ARROW)
        .put("mso-spt102",                  STShapeType.CURVED_RIGHT_ARROW)
        .put("mso-spt103",                  STShapeType.CURVED_LEFT_ARROW)
        .put("mso-spt104",                  STShapeType.CURVED_UP_ARROW)
        .put("mso-spt105",                  STShapeType.CURVED_DOWN_ARROW)
        .put("cloud-callout",               STShapeType.CLOUD_CALLOUT)
        .put("mso-spt107",                  STShapeType.ELLIPSE_RIBBON)
        .put("mso-spt108",                  STShapeType.ELLIPSE_RIBBON_2)
        .put("flowchart-process",           STShapeType.FLOW_CHART_PROCESS)
        .put("flowchart-decision",          STShapeType.FLOW_CHART_DECISION)
        .put("flowchart-data",              STShapeType.FLOW_CHART_INPUT_OUTPUT)
        .put("flowchart-predefined-process",STShapeType.FLOW_CHART_PREDEFINED_PROCESS)
        .put("flowchart-internal-storage",  STShapeType.FLOW_CHART_INTERNAL_STORAGE)
        .put("flowchart-document",          STShapeType.FLOW_CHART_DOCUMENT)
        .put("flowchart-multidocument",     STShapeType.FLOW_CHART_MULTIDOCUMENT)
        .put("flowchart-terminator",        STShapeType.FLOW_CHART_TERMINATOR)
        .put("flowchart-preparation",       STShapeType.FLOW_CHART_PREPARATION)
        .put("flowchart-manual-input",      STShapeType.FLOW_CHART_MANUAL_INPUT)
        .put("flowchart-manual-operation",  STShapeType.FLOW_CHART_MANUAL_OPERATION)
        .put("flowchart-connector",         STShapeType.FLOW_CHART_CONNECTOR)
        .put("flowchart-card",              STShapeType.FLOW_CHART_PUNCHED_CARD)
        .put("flowchart-punched-tape",      STShapeType.FLOW_CHART_PUNCHED_TAPE)
        .put("flowchart-summing-junction",  STShapeType.FLOW_CHART_SUMMING_JUNCTION)
        .put("flowchart-or",                STShapeType.FLOW_CHART_OR)
        .put("flowchart-collate",           STShapeType.FLOW_CHART_COLLATE)
        .put("flowchart-sort",              STShapeType.FLOW_CHART_SORT)
        .put("flowchart-extract",           STShapeType.FLOW_CHART_EXTRACT)
        .put("flowchart-merge",             STShapeType.FLOW_CHART_MERGE)
        .put("mso-spt129",                  STShapeType.FLOW_CHART_OFFLINE_STORAGE)
        .put("flowchart-stored-data",       STShapeType.FLOW_CHART_ONLINE_STORAGE)
        .put("flowchart-sequential-access", STShapeType.FLOW_CHART_MAGNETIC_TAPE)
        .put("flowchart-magnetic-disk",     STShapeType.FLOW_CHART_MAGNETIC_DISK)
        .put("flowchart-direct-access-storage",STShapeType.FLOW_CHART_MAGNETIC_DRUM)
        .put("flowchart-display",           STShapeType.FLOW_CHART_DISPLAY)
        .put("flowchart-delay",             STShapeType.FLOW_CHART_DELAY)
        .put("flowchart-alternate-process", STShapeType.FLOW_CHART_ALTERNATE_PROCESS)
        .put("flowchart-off-page-connector",STShapeType.FLOW_CHART_OFFPAGE_CONNECTOR)
        .put("mso-spt182",                  STShapeType.LEFT_RIGHT_UP_ARROW)
        .put("sun",                         STShapeType.SUN)
        .put("moon",                        STShapeType.MOON)
        .put("bracket-pair",                STShapeType.BRACKET_PAIR)
        .put("brace-pair",                  STShapeType.BRACE_PAIR)
        .put("star4",                       STShapeType.STAR_4)
        .put("mso-spt188",                  STShapeType.DOUBLE_WAVE)
        .put("mso-spt189",                  STShapeType.ACTION_BUTTON_BLANK)
        .put("mso-spt190",                  STShapeType.ACTION_BUTTON_HOME)
        .put("mso-spt191",                  STShapeType.ACTION_BUTTON_HELP)
        .put("mso-spt192",                  STShapeType.ACTION_BUTTON_INFORMATION)
        .put("mso-spt193",                  STShapeType.ACTION_BUTTON_FORWARD_NEXT)
        .put("mso-spt194",                  STShapeType.ACTION_BUTTON_BACK_PREVIOUS)
        .put("mso-spt195",                  STShapeType.ACTION_BUTTON_END)
        .put("mso-spt196",                  STShapeType.ACTION_BUTTON_BEGINNING)
        .put("mso-spt197",                  STShapeType.ACTION_BUTTON_RETURN)
        .put("mso-spt198",                  STShapeType.ACTION_BUTTON_DOCUMENT)
        .put("mso-spt199",                  STShapeType.ACTION_BUTTON_SOUND)
        .put("mso-spt200",                  STShapeType.ACTION_BUTTON_MOVIE)
        .put("teardrop",                    STShapeType.TEARDROP)
        .put("star6",                       STShapeType.STAR_6)     // Gallery: star6
        .put("star12",                      STShapeType.STAR_12)    // Gallery: star12
        .build();

    static final public ImmutableMap<String, STShapeType> OOShapeTypesDblKey = ImmutableMap.<String, STShapeType> builder()
        .put("mso-spt202",                  STShapeType.RECT)       // mso_sptTextBox },
        .put("mso-spt75",                   STShapeType.RECT)       // mso_sptPictureFrame },
        .put("mso-spt18",                   STShapeType.STAR_16)    // double key -> mos-spt59
        .put("col-60da8460",                STShapeType.OCTAGON)
        .put("col-502ad400",                STShapeType.DIAMOND)
        .build();

//      .put("non-primitive", null)
//      .put("mso-spt201", mso_sptHostControl },
//      .put("mso-spt178", mso_sptCallout90 },
//      .put("mso-spt179", mso_sptAccentCallout90 },
//      .put("mso-spt180", mso_sptBorderCallout90 },
//      .put("line-callout-3", mso_sptAccentBorderCallout90 },
//      .put("fontwork-stop", mso_sptTextStop },
//      .put("fontwork-triangle-up", mso_sptTextTriangle },
//      .put("fontwork-triangle-down", mso_sptTextTriangleInverted },
//      .put("fontwork-chevron-up", mso_sptTextChevron },
//      .put("fontwork-chevron-down", mso_sptTextChevronInverted },
//      .put("mso-spt142", mso_sptTextRingInside },
//      .put("mso-spt143", mso_sptTextRingOutside },
//      .put("fontwork-arch-up-curve", mso_sptTextArchUpCurve },
//      .put("fontwork-arch-down-curve", mso_sptTextArchDownCurve },
//      .put("fontwork-circle-curve", mso_sptTextCircleCurve },
//      .put("fontwork-open-circle-curve", mso_sptTextButtonCurve },
//      .put("fontwork-arch-up-pour", mso_sptTextArchUpPour },
//      .put("fontwork-arch-down-pour", mso_sptTextArchDownPour },
//      .put("fontwork-circle-pour", mso_sptTextCirclePour },
//      .put("fontwork-open-circle-pour", mso_sptTextButtonPour },
//      .put("fontwork-curve-up", mso_sptTextCurveUp },
//      .put("fontwork-curve-down", mso_sptTextCurveDown },
//      .put("fontwork-fade-up-and-right", mso_sptTextCascadeUp },
//      .put("fontwork-fade-up-and-left", mso_sptTextCascadeDown },
//      .put("fontwork-wave", mso_sptTextWave1 },
//      .put("mso-spt157", mso_sptTextWave2 },
//      .put("mso-spt158", mso_sptTextWave3 },
//      .put("mso-spt159", mso_sptTextWave4 },
//      .put("fontwork-inflate", mso_sptTextInflate },
//      .put("mso-spt161", mso_sptTextDeflate },
//      .put("mso-spt162", mso_sptTextInflateBottom },
//      .put("mso-spt163", mso_sptTextDeflateBottom },
//      .put("mso-spt164", mso_sptTextInflateTop },
//      .put("mso-spt165", mso_sptTextDeflateTop },
//      .put("mso-spt166", mso_sptTextDeflateInflate },
//      .put("mso-spt167", mso_sptTextDeflateInflateDeflate },
//      .put("fontwork-fade-right", mso_sptTextFadeRight },
//      .put("fontwork-fade-left", mso_sptTextFadeLeft },
//      .put("fontwork-fade-up", mso_sptTextFadeUp },
//      .put("fontwork-fade-down", mso_sptTextFadeDown },
//      .put("fontwork-slant-up", mso_sptTextSlantUp },
//      .put("fontwork-slant-down", mso_sptTextSlantDown },
//      .put("mso-spt174", mso_sptTextCanUp },
//      .put("mso-spt175", mso_sptTextCanDown },
//      .put("fontwork-plain-text", mso_sptTextPlainText },
//      .put("mso-spt14", mso_sptThickArrow },
//      .put("mso-spt24", mso_sptTextSimple },
//      .put("mso-spt25", mso_sptTextOctagon },
//      .put("mso-spt26", mso_sptTextHexagon },
//      .put("mso-spt27", mso_sptTextCurve },
//      .put("mso-spt28", mso_sptTextWave },
//      .put("mso-spt29", mso_sptTextRing },
//      .put("mso-spt30", mso_sptTextOnCurve },
//      .put("mso-spt31", mso_sptTextOnRing },
//      .put("mso-spt49", borderCallpi },
//      .put("mso-spt100", mso_sptNotchedCircularArrow },

/*
    // gallery: quadrat
    // gallery: round-quadrat
    // gallery: circle
    // gallery: circle-pie
    // gallery: frame
    // gallery: flower
    // gallery: cloud
    // gallery: puzzle
    // gallery: octagon-bevel
    // gallery: diamond-bevel
    // gallery: up-right-arrow
    // gallery: up-right-down-arrow
    // gallery: corner-right-arrow
    // gallery: split-arrow
    // gallery: up-right-arrow-callout
    // gallery: split-round-arrow
    // gallery: s-sharped-arrow
    // Gallery: concave-star6
    // Gallery: signet
    // Gallery: doorplate
    // gallery: fontwork-arch-left-curve
    // gallery: fontwork-arch-right-curve
    // gallery: fontwork-arch-left-pour
    // gallery: fontwork-arch-right-pour
  */
}
