/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */



package com.openexchange.office.filter.odf;

import org.apache.xerces.dom.ElementNSImpl;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class UnknownContentHandler extends SaxContextHandler {

	private Node currentNode;

	public UnknownContentHandler(SaxContextHandler parentContextHandler, ElementNSImpl element) {
		super(parentContextHandler);
		currentNode = element;
	}

	@Override
	public void characters(String characters) {
		currentNode.appendChild(getFileDom().createTextNode(characters));
	}

	@Override
    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName) {
        OdfOperationDoc.abortOnLowMemory(getFileDom());
    	currentNode = currentNode.appendChild(new ElementNS(getFileDom(), attributes, uri, qName));
    	return this;
	}

    @Override
    public void endElement(String localName, String qName) {
		currentNode = currentNode.getParentNode();
    }
}
