/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package org.xlsx4j.sml_2018;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 *
 * This complex type specifies the properties of a mention in a threaded comment.
 *
 * <xsd:complexType name="CT_Mention">
 *  <xsd:attribute name="mentionpersonId" type="x:ST_Guid" use="required"/>
 *  <xsd:attribute name="mentionId" type="x:ST_Guid" use="required"/>
 *  <xsd:attribute name="startIndex" type="xsd:unsignedInt" use="required"/>
 *  <xsd:attribute name="length" type="xsd:unsignedInt" use="required"/>
 * </xsd:complexType>
 */

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CTMention", propOrder = {})
@XmlRootElement(name="mention")
public class CTMention {

    // mentionpersonId: An ST_Guid attribute that specifies a unique identifier for the person mentioned. This attribute MUST correspond to the id specified in CT_Person (2018)
    @XmlAttribute(required = true, name = "mentionpersonId")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String personId;

    @XmlAttribute(required = true, name = "mentionId")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String id;

    @XmlAttribute(required = true)
    @XmlSchemaType(name = "unsignedInt")
    protected long startIndex;

    @XmlAttribute(required = true)
    @XmlSchemaType(name = "unsignedInt")
    protected long length;

    /**
     * Get the PersonId correspond to the sml._2018.CTPerson.java.
     * (Required)
     * @return the id of the person.
     */
    public String getPersonId() {
        return personId;
    }

    /**
     * Set the PersonId correspond to the sml._2018.CTPerson.java.
     * (Required)
     * @param personId
     */
    public void setPersonId(String personId) {
        this.personId = personId;
    }

    /**
     * Get the id of the mention.
     * (Required)
     */
    public String getId() {
        return id;
    }

    /**
     * Set the id of the mention.
     * (Required)
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Get the start index of the mention start in the comment text.
     * (Required)
     */
    public long getStartIndex() {
        return startIndex;
    }

    /**
     * Set the start index of the mention start in the comment text.
     * (Required)
     * @param startIndex
     */
    public void setStartIndex(long startIndex) {
        this.startIndex = startIndex;
    }

    /**
     * Get the number of characters in the mention from startIndex.
     * (Required)
     * @return
     */
    public long getLength() {
        return length;
    }

    /**
     * Set the number of characters in the mention from startIndex.
     * (Required)
     * @param length
     */
    public void setLength(long length) {
        this.length = length;
    }
}
