/*
 *  Copyright 2010-2013, Plutext Pty Ltd.
 *   
 *  This file is part of xlsx4j, a component of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */
package org.xlsx4j.sml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ST_CfvoType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="ST_CfvoType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="num"/>
 *     &lt;enumeration value="percent"/>
 *     &lt;enumeration value="max"/>
 *     &lt;enumeration value="min"/>
 *     &lt;enumeration value="formula"/>
 *     &lt;enumeration value="percentile"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "ST_CfvoType")
@XmlEnum
public enum STCfvoType {

    @XmlEnumValue("num")
    NUM("num"),
    @XmlEnumValue("percent")
    PERCENT("percent"),
    @XmlEnumValue("max")
    MAX("max"),
    @XmlEnumValue("min")
    MIN("min"),
    @XmlEnumValue("formula")
    FORMULA("formula"),
    @XmlEnumValue("percentile")
    PERCENTILE("percentile");
    private final String value;

    STCfvoType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static STCfvoType fromValue(String v) {
        for (STCfvoType c: STCfvoType.values()) {
            if (c.value.equalsIgnoreCase(v)) {
                return c;
            }
        }
        return null;
    }

}
