/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.office.dcs.registry;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.JdbcProperties;
import com.openexchange.office.tools.annotation.RegisteredService;
import com.openexchange.office.tools.database.ConnectionData;
import com.openexchange.office.tools.database.DatabaseConfiguration;

@Service
@RegisteredService(registeredClass=ConnectionData.class)
public class DcsDatabaseConfiguration extends DatabaseConfiguration {

    public static final String DB_CLIENT_URL_KEY = "com.openexchange.dcs.client.database";
    
    public static final String DB_CLIENT_JDBC_CONFIG_PREFIX = "com.openexchange.dcs.client.database.jdbc";
	
    private static final int DEFAULT_CONNECTION_POOLSIZE = 5;

    @Autowired
    private ConfigurationService configurationService;

    @Autowired
    private JdbcProperties jdbcProperties;

    public DcsDatabaseConfiguration() {
        super(DB_CLIENT_URL_KEY, DB_CLIENT_JDBC_CONFIG_PREFIX);
    }

    /**
     * Overrides the max. connection pool size method with a default
     * of DEFAULT_CONNECTION_POOLSIZE (5) since we don't need a
     * super class default pool size (30) that large for this database
     *
     * @return The number of open connections within the database connection pool.
     *  Default is 5.
     */
    @Override
    public int getConnectionPoolSize() {
        return this.getConfigurationService().getIntProperty(this.getConfigPrefix() + "connectionPool.maxPoolSize",
            DcsDatabaseConfiguration.DEFAULT_CONNECTION_POOLSIZE);
    }

	@Override
	protected ConfigurationService getConfigurationService() {
		return configurationService;
	}

	@Override
	protected JdbcProperties getJdbcPropertiesService() {
		return jdbcProperties;
	}
}
