/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import javax.sql.DataSource;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public enum EmbeddedDatabaseConnection {
    NONE(null, null, null),
    H2(EmbeddedDatabaseType.H2, DatabaseDriver.H2.getDriverClassName(), "jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE"),
    DERBY(EmbeddedDatabaseType.DERBY, DatabaseDriver.DERBY.getDriverClassName(), "jdbc:derby:memory:%s;create=true"),
    HSQL(EmbeddedDatabaseType.HSQL, DatabaseDriver.HSQLDB.getDriverClassName(), "org.hsqldb.jdbcDriver", "jdbc:hsqldb:mem:%s");

    private final EmbeddedDatabaseType type;
    private final String driverClass;
    private final String alternativeDriverClass;
    private final String url;

    private EmbeddedDatabaseConnection(EmbeddedDatabaseType type, String driverClass, String url) {
        this(type, driverClass, null, url);
    }

    private EmbeddedDatabaseConnection(EmbeddedDatabaseType type, String driverClass, String fallbackDriverClass, String url) {
        this.type = type;
        this.driverClass = driverClass;
        this.alternativeDriverClass = fallbackDriverClass;
        this.url = url;
    }

    public String getDriverClassName() {
        return this.driverClass;
    }

    public EmbeddedDatabaseType getType() {
        return this.type;
    }

    public String getUrl(String databaseName) {
        Assert.hasText(databaseName, "DatabaseName must not be empty");
        return this.url != null ? String.format(this.url, databaseName) : null;
    }

    public static boolean isEmbedded(String driverClass) {
        return driverClass != null && (EmbeddedDatabaseConnection.matches(HSQL, driverClass) || EmbeddedDatabaseConnection.matches(H2, driverClass) || EmbeddedDatabaseConnection.matches(DERBY, driverClass));
    }

    private static boolean matches(EmbeddedDatabaseConnection candidate, String driverClass) {
        return driverClass.equals(candidate.driverClass) || driverClass.equals(candidate.alternativeDriverClass);
    }

    public static boolean isEmbedded(DataSource dataSource) {
        try {
            return (Boolean)new JdbcTemplate(dataSource).execute((ConnectionCallback)new IsEmbedded());
        }
        catch (DataAccessException ex) {
            return false;
        }
    }

    public static EmbeddedDatabaseConnection get(ClassLoader classLoader) {
        for (EmbeddedDatabaseConnection candidate : EmbeddedDatabaseConnection.values()) {
            if (candidate == NONE || !ClassUtils.isPresent(candidate.getDriverClassName(), classLoader)) continue;
            return candidate;
        }
        return NONE;
    }

    private static class IsEmbedded
    implements ConnectionCallback<Boolean> {
        private IsEmbedded() {
        }

        public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
            EmbeddedDatabaseConnection[] candidates;
            String productName = connection.getMetaData().getDatabaseProductName();
            if (productName == null) {
                return false;
            }
            productName = productName.toUpperCase(Locale.ENGLISH);
            for (EmbeddedDatabaseConnection candidate : candidates = EmbeddedDatabaseConnection.values()) {
                if (candidate == NONE || !productName.contains(candidate.name())) continue;
                return true;
            }
            return false;
        }
    }
}

