/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */



package com.openexchange.documentconverter;

import java.util.Map;
import org.apache.commons.lang.StringUtils;

/**
 * {@link Properties}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class Properties {

    static final public String INFO_PREFIX = "info_";

    static final public String REMOTECACHE_VERSION_PREFIX = "rc1-";

    // -------------------------------------------------------------------------

    static final public int MAX_ERROR_MESSAGE_TOTAL_LENGTH = 2048;

    static final public int MAX_ERROR_MESSAGE_END_LENGTH = 256;

    // -------------------------------------------------------------------------

    static final public String CACHE_PROPERTIES_FILENAME = "properties"; // String

    static final public String CACHE_RESULT_FILENAME = "result"; // String

    static final public String CACHE_NO_CACHEHASH = "0";

    // -------------------------------------------------------------------------

    static final public String PROP_CACHE_PERSIST_ENTRY_NAME = "EntryName"; // String

    static final public String PROP_CACHE_HASH = "CacheHash"; // String

    static final public String PROP_REMOTE_CACHE_HASH = "RemoteCacheHash"; // String

    static final public String PROP_INPUTFILE_HASH = "InputFileHash"; // String

    static final public String PROP_LOCALE = "Locale"; // String

    static final public String PROP_FILTER_SHORT_NAME = "FilterShortName"; // String

    static final public String PROP_IDOCUMENTCONVERTER = "IDocumentConverter"; // IDocumentConverter

    static final public String PROP_PIXEL_X = "PixelX"; // Integer

    static final public String PROP_PIXEL_Y = "PixelY"; // Integer

    static final public String PROP_PIXEL_WIDTH = "PixelWidth"; // Integer

    static final public String PROP_PIXEL_HEIGHT = "PixelHeight"; // Integer

    static final public String PROP_PIXEL_ZOOM= "PixelZoom"; // Double

    static final public String PROP_INPUT_FILE = "InputFile"; // File

    static final public String PROP_INPUT_STREAM = "InputStream"; // InputStream

    static final public String PROP_INPUT_TYPE = "InputType"; // String

    static final public String PROP_INPUT_URL = "InputUrl"; // String

    static final public String PROP_JOBID = "JobId"; // String

    static final public String PROP_JOBTYPE = "JobType"; // String

    static final public String PROP_MIME_TYPE = "MimeType"; // String

    static final public String PROP_OUTPUT_FILE = "OutputFile"; // File

    static final public String PROP_PAGE_NUMBER = "PageNumber"; // Integer

    static final public String PROP_PAGE_RANGE = "PageRange"; // String

    static final public String PROP_ZIP_ARCHIVE = "ZipArchive"; // Boolean

    static final public String PROP_PRIORITY = "Priority"; // JobPriority

    static final public String PROP_READERENGINE_ROOT = "ReaderEngineRoot"; // String

    static final public String PROP_ENGINE_REMOTEURL = "EngineRemoteUrl"; // String

    static final public String PROP_REMOTE_METHOD = "Method"; // String

    static final public String PROP_INFO_FILENAME = INFO_PREFIX + "Filename"; // String

    static final public String PROP_FEATURES_ID = "FeaturesId"; // Integer

    static final public String PROP_CONVERTER_COOKIE = "ConverterCookie"; // String

    static final public String PROP_CACHE_ONLY = "CacheOnly"; // Boolean

    static final public String PROP_NO_CACHE = "NoCache"; // Boolean

    static final public String PROP_AUTOSCALE = "AutoScale"; // Boolean

    static final public String PROP_HIDE_CHANGES = "HideChanges"; // Boolean

    static final public String PROP_HIDE_COMMENTS = "HideComments"; // Boolean

    static final public String PROP_ASYNC = "Async"; // Boolean

    static final public String PROP_REMOTE_ASYNC = "RemoteAsync"; // Boolean

    static final public String PROP_QUERY_AVAILABILITY = "QueryAvailability"; // Boolean

    static final public String PROP_IMAGE_SCALE_TYPE = "ImageScaleType"; // String

    static final public String PROP_IMAGE_RESOLUTION = "ImageResolution"; // Integer

    static final public String PROP_USER_REQUEST = "UserRequest"; // Boolean

    static final public String PROP_CLOSE_DOCUMENT = "CloseDocument"; // Boolean

    // -------------------------------------------------------------------------

    static final public String PROP_RESULT_CACHE_HASH = PROP_CACHE_HASH; // String

    static final public String PROP_RESULT_INPUTFILE_HASH = PROP_INPUTFILE_HASH; // String

    static final public String PROP_RESULT_LOCALE = PROP_LOCALE; // String

    static final public String PROP_RESULT_ERROR_CODE = "ErrorCode"; // Integer

    static final public String PROP_RESULT_EXTENSION = "Extension"; // String

    static final public String PROP_RESULT_BUFFER = "ResultBuffer"; // byte[]

    static final public String PROP_RESULT_JOBID = PROP_JOBID; // String

    static final public String PROP_RESULT_MIME_TYPE = PROP_MIME_TYPE; // String

    static final public String PROP_RESULT_PAGE_COUNT = "PageCount"; // Integer

    static final public String PROP_RESULT_ORIGINAL_PAGE_COUNT = "OriginalPageCount"; // Integer

    static final public String PROP_RESULT_PAGE_NUMBER = PROP_PAGE_NUMBER; // Integer

    static final public String PROP_RESULT_TEMP_INPUT_FILE = "TempInputFile"; // File

    static final public String PROP_RESULT_TEMP_INFO_FILENAME = PROP_INFO_FILENAME; // String

    static final public String PROP_RESULT_TEMP_INPUT_TYPE = PROP_INPUT_TYPE; // String

    static final public String PROP_RESULT_SINGLE_PAGE_JOBTYPE = "SinglePageJobType"; // String

    static final public String PROP_RESULT_ZIP_ARCHIVE = PROP_ZIP_ARCHIVE; // Boolean

    static final public String PROP_RESULT_CACHE_REMOTEURL = "CacheRemoteUrl"; // String

    static final public String PROP_RESULT_CONVERTER_COOKIE = PROP_CONVERTER_COOKIE; // String

    static final public String PROP_RESULT_ASYNC = PROP_ASYNC; // Boolean

    // -------------------------------------------------------------------------

    static public final String OX_RESCUEDOCUMENT_EXTENSION_APPENDIX = "_ox";

    static public final String OX_DOCUMENTCONVERTER_TEMPDIR_NAME = "oxdc.tmp";

    static public final String OX_DOCUMENTCONVERTER_LTSDIR_NAME = "oxdc.lts";

    // -------------------------------------------------------------------------

    @SuppressWarnings("unchecked")
    static public <T> T getValue(Map<String, ?> map, String key) {
        return (T) (((null != map) && (!StringUtils.isEmpty(key))) ? map.get(key) : null);
    }
}
