/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class DeleteSecondaryEmailResult {
    public static final DeleteSecondaryEmailResult OTHER = new DeleteSecondaryEmailResult().withTag(Tag.OTHER);
    private Tag _tag;
    private String successValue;
    private String notFoundValue;
    private String cannotRemovePrimaryValue;

    private DeleteSecondaryEmailResult() {
    }

    private DeleteSecondaryEmailResult withTag(Tag _tag) {
        DeleteSecondaryEmailResult result = new DeleteSecondaryEmailResult();
        result._tag = _tag;
        return result;
    }

    private DeleteSecondaryEmailResult withTagAndSuccess(Tag _tag, String successValue) {
        DeleteSecondaryEmailResult result = new DeleteSecondaryEmailResult();
        result._tag = _tag;
        result.successValue = successValue;
        return result;
    }

    private DeleteSecondaryEmailResult withTagAndNotFound(Tag _tag, String notFoundValue) {
        DeleteSecondaryEmailResult result = new DeleteSecondaryEmailResult();
        result._tag = _tag;
        result.notFoundValue = notFoundValue;
        return result;
    }

    private DeleteSecondaryEmailResult withTagAndCannotRemovePrimary(Tag _tag, String cannotRemovePrimaryValue) {
        DeleteSecondaryEmailResult result = new DeleteSecondaryEmailResult();
        result._tag = _tag;
        result.cannotRemovePrimaryValue = cannotRemovePrimaryValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isSuccess() {
        return this._tag == Tag.SUCCESS;
    }

    public static DeleteSecondaryEmailResult success(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new DeleteSecondaryEmailResult().withTagAndSuccess(Tag.SUCCESS, value);
    }

    public String getSuccessValue() {
        if (this._tag != Tag.SUCCESS) {
            throw new IllegalStateException("Invalid tag: required Tag.SUCCESS, but was Tag." + this._tag.name());
        }
        return this.successValue;
    }

    public boolean isNotFound() {
        return this._tag == Tag.NOT_FOUND;
    }

    public static DeleteSecondaryEmailResult notFound(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new DeleteSecondaryEmailResult().withTagAndNotFound(Tag.NOT_FOUND, value);
    }

    public String getNotFoundValue() {
        if (this._tag != Tag.NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.NOT_FOUND, but was Tag." + this._tag.name());
        }
        return this.notFoundValue;
    }

    public boolean isCannotRemovePrimary() {
        return this._tag == Tag.CANNOT_REMOVE_PRIMARY;
    }

    public static DeleteSecondaryEmailResult cannotRemovePrimary(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new DeleteSecondaryEmailResult().withTagAndCannotRemovePrimary(Tag.CANNOT_REMOVE_PRIMARY, value);
    }

    public String getCannotRemovePrimaryValue() {
        if (this._tag != Tag.CANNOT_REMOVE_PRIMARY) {
            throw new IllegalStateException("Invalid tag: required Tag.CANNOT_REMOVE_PRIMARY, but was Tag." + this._tag.name());
        }
        return this.cannotRemovePrimaryValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.successValue, this.notFoundValue, this.cannotRemovePrimaryValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DeleteSecondaryEmailResult) {
            DeleteSecondaryEmailResult other = (DeleteSecondaryEmailResult)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case SUCCESS: {
                    return this.successValue == other.successValue || this.successValue.equals(other.successValue);
                }
                case NOT_FOUND: {
                    return this.notFoundValue == other.notFoundValue || this.notFoundValue.equals(other.notFoundValue);
                }
                case CANNOT_REMOVE_PRIMARY: {
                    return this.cannotRemovePrimaryValue == other.cannotRemovePrimaryValue || this.cannotRemovePrimaryValue.equals(other.cannotRemovePrimaryValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<DeleteSecondaryEmailResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DeleteSecondaryEmailResult value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case SUCCESS: {
                    g.writeStartObject();
                    this.writeTag("success", g);
                    g.writeFieldName("success");
                    StoneSerializers.string().serialize(value.successValue, g);
                    g.writeEndObject();
                    break;
                }
                case NOT_FOUND: {
                    g.writeStartObject();
                    this.writeTag("not_found", g);
                    g.writeFieldName("not_found");
                    StoneSerializers.string().serialize(value.notFoundValue, g);
                    g.writeEndObject();
                    break;
                }
                case CANNOT_REMOVE_PRIMARY: {
                    g.writeStartObject();
                    this.writeTag("cannot_remove_primary", g);
                    g.writeFieldName("cannot_remove_primary");
                    StoneSerializers.string().serialize(value.cannotRemovePrimaryValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public DeleteSecondaryEmailResult deserialize(JsonParser p) throws IOException, JsonParseException {
            DeleteSecondaryEmailResult value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("success".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("success", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = DeleteSecondaryEmailResult.success(fieldValue);
            } else if ("not_found".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("not_found", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = DeleteSecondaryEmailResult.notFound(fieldValue);
            } else if ("cannot_remove_primary".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("cannot_remove_primary", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = DeleteSecondaryEmailResult.cannotRemovePrimary(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        SUCCESS,
        NOT_FOUND,
        CANNOT_REMOVE_PRIMARY,
        OTHER;

    }
}

