/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.client.impl.ClientEndpointStatisticsSnapshot;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;

public class ClientInfoCollectorHelper {
    private final PhoneHomeMetrics activeClientCount;
    private final PhoneHomeMetrics openedClientConnectionCount;
    private final PhoneHomeMetrics closedClientConnectionCount;
    private final PhoneHomeMetrics totalClientConnectionDuration;
    private final PhoneHomeMetrics clientVersions;

    public ClientInfoCollectorHelper(PhoneHomeMetrics activeClientCount, PhoneHomeMetrics openedClientConnectionCount, PhoneHomeMetrics closedClientConnectionCount, PhoneHomeMetrics totalClientConnectionDuration, PhoneHomeMetrics clientVersions) {
        this.activeClientCount = activeClientCount;
        this.openedClientConnectionCount = openedClientConnectionCount;
        this.closedClientConnectionCount = closedClientConnectionCount;
        this.totalClientConnectionDuration = totalClientConnectionDuration;
        this.clientVersions = clientVersions;
    }

    public void collectMetrics(long clientCount, ClientEndpointStatisticsSnapshot snapshot, BiConsumer<PhoneHomeMetrics, String> metricsConsumer) {
        metricsConsumer.accept(this.activeClientCount, String.valueOf(clientCount));
        long connectionsOpened = snapshot != null ? snapshot.getConnectionsOpened() : 0L;
        metricsConsumer.accept(this.openedClientConnectionCount, String.valueOf(connectionsOpened));
        long connectionsClosed = snapshot != null ? snapshot.getConnectionsClosed() : 0L;
        metricsConsumer.accept(this.closedClientConnectionCount, String.valueOf(connectionsClosed));
        long totalConnectionDuration = snapshot != null ? snapshot.getTotalConnectionDuration() : 0L;
        metricsConsumer.accept(this.totalClientConnectionDuration, String.valueOf(totalConnectionDuration));
        Set<Object> connectedClientVersions = snapshot != null ? snapshot.getClientVersions() : Collections.emptySet();
        metricsConsumer.accept(this.clientVersions, String.join((CharSequence)",", connectedClientVersions));
    }
}

