/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.SendMemberHandshakeTask;
import com.hazelcast.internal.server.tcp.TcpServerConnection;
import com.hazelcast.internal.server.tcp.TcpServerConnectionManager;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;

class TcpServerConnector {
    private static final int DEFAULT_IPV6_SOCKET_CONNECT_TIMEOUT_SECONDS = 3;
    private static final int MILLIS_PER_SECOND = 1000;
    private final TcpServerConnectionManager connectionManager;
    private final ILogger logger;
    private final ServerContext serverContext;
    private final int outboundPortCount;
    private final LinkedList<Integer> outboundPorts = new LinkedList();
    private final boolean socketClientBind;
    private final boolean socketClientBindAny;
    private final int planeCount;

    TcpServerConnector(TcpServerConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.serverContext = connectionManager.getServer().getContext();
        this.logger = this.serverContext.getLoggingService().getLogger(this.getClass());
        Collection<Integer> ports = this.serverContext.getOutboundPorts(connectionManager.getEndpointQualifier());
        this.outboundPortCount = ports.size();
        this.outboundPorts.addAll(ports);
        HazelcastProperties properties = this.serverContext.properties();
        this.socketClientBind = properties.getBoolean(ClusterProperty.SOCKET_CLIENT_BIND);
        this.socketClientBindAny = properties.getBoolean(ClusterProperty.SOCKET_CLIENT_BIND_ANY);
        this.planeCount = connectionManager.planeCount;
    }

    void asyncConnect(Address address, boolean silent, int planeIndex) {
        this.serverContext.shouldConnectTo(address);
        this.serverContext.executeAsync(new ConnectTask(address, silent, planeIndex));
    }

    private boolean useAnyOutboundPort() {
        return this.outboundPortCount == 0;
    }

    private int getOutboundPortCount() {
        return this.outboundPortCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireOutboundPort() {
        if (this.useAnyOutboundPort()) {
            return 0;
        }
        LinkedList<Integer> linkedList = this.outboundPorts;
        synchronized (linkedList) {
            Integer port = this.outboundPorts.removeFirst();
            this.outboundPorts.addLast(port);
            return port;
        }
    }

    private final class ConnectTask
    implements Runnable {
        private final Address remoteAddress;
        private final boolean silent;
        private final int planeIndex;

        ConnectTask(Address remoteAddress, boolean silent, int planeIndex) {
            this.remoteAddress = remoteAddress;
            this.silent = silent;
            this.planeIndex = planeIndex;
        }

        @Override
        public void run() {
            if (!TcpServerConnector.this.connectionManager.getServer().isLive()) {
                if (TcpServerConnector.this.logger.isFinestEnabled()) {
                    TcpServerConnector.this.logger.finest("ConnectionManager is not live, connection attempt to " + this.remoteAddress + " is cancelled!");
                }
                return;
            }
            if (TcpServerConnector.this.logger.isFinestEnabled()) {
                TcpServerConnector.this.logger.finest("Starting to connect to " + this.remoteAddress);
            }
            try {
                Address thisAddress = TcpServerConnector.this.serverContext.getThisAddress();
                if (this.remoteAddress.isIPv4()) {
                    this.tryToConnect(this.remoteAddress.getInetSocketAddress(), TcpServerConnector.this.serverContext.getSocketConnectTimeoutSeconds(TcpServerConnector.this.connectionManager.getEndpointQualifier()) * 1000);
                } else if (thisAddress.isIPv6() && thisAddress.getScopeId() != null) {
                    Inet6Address inetAddress = AddressUtil.getInetAddressFor((Inet6Address)this.remoteAddress.getInetAddress(), thisAddress.getScopeId());
                    this.tryToConnect(new InetSocketAddress(inetAddress, this.remoteAddress.getPort()), TcpServerConnector.this.serverContext.getSocketConnectTimeoutSeconds(TcpServerConnector.this.connectionManager.getEndpointQualifier()) * 1000);
                } else {
                    this.tryConnectToIPv6();
                }
            }
            catch (Throwable e) {
                TcpServerConnector.this.logger.finest(e);
                TcpServerConnector.this.connectionManager.failedConnection(this.remoteAddress, this.planeIndex, e, this.silent);
            }
        }

        private void tryConnectToIPv6() throws Exception {
            Level level;
            Collection<Inet6Address> possibleInetAddresses = AddressUtil.getPossibleInetAddressesFor((Inet6Address)this.remoteAddress.getInetAddress());
            Level level2 = level = this.silent ? Level.FINEST : Level.INFO;
            if (TcpServerConnector.this.logger.isLoggable(level)) {
                TcpServerConnector.this.logger.log(level, "Trying to connect possible IPv6 addresses: " + possibleInetAddresses);
            }
            boolean connected = false;
            Exception error = null;
            int configuredTimeoutMillis = TcpServerConnector.this.serverContext.getSocketConnectTimeoutSeconds(TcpServerConnector.this.connectionManager.getEndpointQualifier()) * 1000;
            int timeoutMillis = configuredTimeoutMillis > 0 && configuredTimeoutMillis < Integer.MAX_VALUE ? configuredTimeoutMillis : 3000;
            for (Inet6Address inetAddress : possibleInetAddresses) {
                try {
                    this.tryToConnect(new InetSocketAddress(inetAddress, this.remoteAddress.getPort()), timeoutMillis);
                    connected = true;
                    break;
                }
                catch (Exception e) {
                    error = e;
                }
            }
            if (!connected && error != null) {
                throw error;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryToConnect(InetSocketAddress socketAddress, int timeout) throws Exception {
            SocketChannel socketChannel = SocketChannel.open();
            TcpServerConnection connection = null;
            Channel channel = TcpServerConnector.this.connectionManager.newChannel(socketChannel, true);
            channel.attributeMap().put(Address.class, this.remoteAddress);
            try {
                Level level;
                if (TcpServerConnector.this.socketClientBind) {
                    this.bindSocket(socketChannel);
                }
                Level level2 = level = this.silent ? Level.FINEST : Level.INFO;
                if (TcpServerConnector.this.logger.isLoggable(level)) {
                    TcpServerConnector.this.logger.log(level, "Connecting to " + socketAddress + ", timeout: " + timeout + ", bind-any: " + TcpServerConnector.this.socketClientBindAny);
                }
                try {
                    channel.connect(socketAddress, timeout);
                    TcpServerConnector.this.serverContext.interceptSocket(TcpServerConnector.this.connectionManager.getEndpointQualifier(), socketChannel.socket(), false);
                    connection = TcpServerConnector.this.connectionManager.newConnection(channel, this.remoteAddress);
                    new SendMemberHandshakeTask(TcpServerConnector.this.logger, TcpServerConnector.this.serverContext, connection, this.remoteAddress, true, this.planeIndex, TcpServerConnector.this.planeCount).run();
                }
                catch (Exception e) {
                    this.closeConnection(connection, e);
                    this.closeSocket(socketChannel);
                    TcpServerConnector.this.logger.log(level, "Could not connect to: " + socketAddress + ". Reason: " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]");
                    throw e;
                }
            }
            finally {
                TcpServerConnector.this.connectionManager.removeAcceptedChannel(channel);
            }
        }

        private void bindSocket(SocketChannel socketChannel) throws IOException {
            InetAddress inetAddress = this.getInetAddress();
            Socket socket = socketChannel.socket();
            if (!TcpServerConnector.this.useAnyOutboundPort()) {
                IOException ex = null;
                int retryCount = TcpServerConnector.this.getOutboundPortCount() * 2;
                for (int i = 0; i < retryCount; ++i) {
                    int port = TcpServerConnector.this.acquireOutboundPort();
                    InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, port);
                    try {
                        socket.bind(socketAddress);
                        return;
                    }
                    catch (IOException e) {
                        ex = e;
                        TcpServerConnector.this.logger.finest("Could not bind port[ " + port + "]: " + e.getMessage());
                        continue;
                    }
                }
                throw ex;
            }
            InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, 0);
            socket.bind(socketAddress);
        }

        private InetAddress getInetAddress() throws UnknownHostException {
            return TcpServerConnector.this.socketClientBindAny ? null : TcpServerConnector.this.serverContext.getThisAddress().getInetAddress();
        }

        private void closeConnection(Connection connection, Throwable t) {
            if (connection != null) {
                connection.close(null, t);
            }
        }

        private void closeSocket(SocketChannel socketChannel) {
            if (socketChannel != null) {
                try {
                    socketChannel.close();
                }
                catch (IOException e) {
                    TcpServerConnector.this.logger.finest("Closing socket channel failed", e);
                }
            }
        }
    }
}

