/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractGenericRecordBuilder
implements GenericRecordBuilder {
    AbstractGenericRecordBuilder() {
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt(@Nonnull String fieldName, int value) {
        return this.write(fieldName, value, FieldType.INT);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setLong(@Nonnull String fieldName, long value) {
        return this.write(fieldName, value, FieldType.LONG);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setString(@Nonnull String fieldName, String value) {
        return this.write(fieldName, value, FieldType.UTF);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBoolean(@Nonnull String fieldName, boolean value) {
        return this.write(fieldName, value, FieldType.BOOLEAN);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setByte(@Nonnull String fieldName, byte value) {
        return this.write(fieldName, value, FieldType.BYTE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setChar(@Nonnull String fieldName, char value) {
        return this.write(fieldName, Character.valueOf(value), FieldType.CHAR);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDouble(@Nonnull String fieldName, double value) {
        return this.write(fieldName, value, FieldType.DOUBLE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat(@Nonnull String fieldName, float value) {
        return this.write(fieldName, Float.valueOf(value), FieldType.FLOAT);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setShort(@Nonnull String fieldName, short value) {
        return this.write(fieldName, value, FieldType.SHORT);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord value) {
        return this.write(fieldName, value, FieldType.COMPOSED);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) {
        return this.write(fieldName, value, FieldType.DECIMAL);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTime(@Nonnull String fieldName, @Nullable LocalTime value) {
        return this.write(fieldName, value, FieldType.TIME);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDate(@Nonnull String fieldName, @Nullable LocalDate value) {
        return this.write(fieldName, value, FieldType.DATE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime value) {
        return this.write(fieldName, value, FieldType.TIMESTAMP);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime value) {
        return this.write(fieldName, value, FieldType.TIMESTAMP_WITH_TIMEZONE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecordArray(@Nonnull String fieldName, @Nullable GenericRecord[] value) {
        return this.write(fieldName, value, FieldType.COMPOSED_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setByteArray(@Nonnull String fieldName, byte[] value) {
        return this.write(fieldName, value, FieldType.BYTE_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBooleanArray(@Nonnull String fieldName, boolean[] value) {
        return this.write(fieldName, value, FieldType.BOOLEAN_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setCharArray(@Nonnull String fieldName, char[] value) {
        return this.write(fieldName, value, FieldType.CHAR_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setIntArray(@Nonnull String fieldName, int[] value) {
        return this.write(fieldName, value, FieldType.INT_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setLongArray(@Nonnull String fieldName, long[] value) {
        return this.write(fieldName, value, FieldType.LONG_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDoubleArray(@Nonnull String fieldName, double[] value) {
        return this.write(fieldName, value, FieldType.DOUBLE_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloatArray(@Nonnull String fieldName, float[] value) {
        return this.write(fieldName, value, FieldType.FLOAT_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setShortArray(@Nonnull String fieldName, short[] value) {
        return this.write(fieldName, value, FieldType.SHORT_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setStringArray(@Nonnull String fieldName, String[] value) {
        return this.write(fieldName, value, FieldType.UTF_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimalArray(@Nonnull String fieldName, BigDecimal[] value) {
        return this.write(fieldName, value, FieldType.DECIMAL_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimeArray(@Nonnull String fieldName, LocalTime[] value) {
        return this.write(fieldName, value, FieldType.TIME_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDateArray(@Nonnull String fieldName, LocalDate[] value) {
        return this.write(fieldName, value, FieldType.DATE_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampArray(@Nonnull String fieldName, LocalDateTime[] value) {
        return this.write(fieldName, value, FieldType.TIMESTAMP_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezoneArray(@Nonnull String fieldName, OffsetDateTime[] value) {
        return this.write(fieldName, value, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY);
    }

    protected abstract GenericRecordBuilder write(@Nonnull String var1, Object var2, FieldType var3);

    public static void checkTypeWithSchema(Schema schema, @Nonnull String fieldName, FieldType fieldType) {
        FieldDescriptor fd = schema.getField(fieldName);
        if (fd == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + "' for " + schema);
        }
        if (!fd.getType().equals((Object)fieldType)) {
            throw new HazelcastSerializationException("Invalid field type: '" + fieldName + "' for " + schema + ", expected : " + (Object)((Object)fd.getType()) + ", given : " + (Object)((Object)fieldType));
        }
    }
}

