/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.TriTuple;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.spi.annotation.Beta;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

@Beta
public class CompactSerializationConfig {
    final Map<String, TriTuple<String, String, String>> typeNameToNamedRegistryMap;
    final Map<String, TriTuple<String, String, String>> classNameToNamedRegistryMap;
    private final Map<String, TriTuple<Class, String, CompactSerializer>> typeNameToRegistryMap;
    private final Map<Class, TriTuple<Class, String, CompactSerializer>> classToRegistryMap;
    private boolean enabled;

    public CompactSerializationConfig() {
        this.typeNameToRegistryMap = new ConcurrentHashMap<String, TriTuple<Class, String, CompactSerializer>>();
        this.classToRegistryMap = new ConcurrentHashMap<Class, TriTuple<Class, String, CompactSerializer>>();
        this.typeNameToNamedRegistryMap = new ConcurrentHashMap<String, TriTuple<String, String, String>>();
        this.classNameToNamedRegistryMap = new ConcurrentHashMap<String, TriTuple<String, String, String>>();
    }

    public CompactSerializationConfig(CompactSerializationConfig compactSerializationConfig) {
        this.typeNameToRegistryMap = new ConcurrentHashMap<String, TriTuple<Class, String, CompactSerializer>>(compactSerializationConfig.typeNameToRegistryMap);
        this.classToRegistryMap = new ConcurrentHashMap<Class, TriTuple<Class, String, CompactSerializer>>(compactSerializationConfig.classToRegistryMap);
        this.typeNameToNamedRegistryMap = new ConcurrentHashMap<String, TriTuple<String, String, String>>(compactSerializationConfig.typeNameToNamedRegistryMap);
        this.classNameToNamedRegistryMap = new ConcurrentHashMap<String, TriTuple<String, String, String>>(compactSerializationConfig.classNameToNamedRegistryMap);
        this.enabled = compactSerializationConfig.enabled;
    }

    public <T> CompactSerializationConfig register(@Nonnull Class<T> clazz) {
        Preconditions.checkNotNull(clazz, "Class cannot be null");
        this.register0(clazz, clazz.getName(), null);
        return this;
    }

    public <T> CompactSerializationConfig register(@Nonnull Class<T> clazz, @Nonnull String typeName, @Nonnull CompactSerializer<T> explicitSerializer) {
        Preconditions.checkNotNull(clazz, "Class cannot be null");
        Preconditions.checkNotNull(typeName, "Type name cannot be null");
        Preconditions.checkNotNull(explicitSerializer, "Explicit serializer cannot be null");
        this.register0(clazz, typeName, explicitSerializer);
        return this;
    }

    @Nonnull
    public Map<String, TriTuple<Class, String, CompactSerializer>> getRegistries() {
        return Collections.unmodifiableMap(this.typeNameToRegistryMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactSerializationConfig that = (CompactSerializationConfig)o;
        return Objects.equals(this.typeNameToRegistryMap, that.typeNameToRegistryMap) && Objects.equals(this.classToRegistryMap, that.classToRegistryMap);
    }

    public int hashCode() {
        return Objects.hash(this.typeNameToRegistryMap, this.classToRegistryMap);
    }

    private <T> void register0(Class<T> clazz, String typeName, CompactSerializer<T> explicitSerializer) {
        TriTuple<Class<T>, String, CompactSerializer<T>> registry = TriTuple.of(clazz, typeName, explicitSerializer);
        TriTuple<Class<T>, String, CompactSerializer<T>> oldRegistry = this.typeNameToRegistryMap.putIfAbsent(typeName, registry);
        if (oldRegistry != null) {
            throw new InvalidConfigurationException("Already have a registry for the type name " + typeName);
        }
        oldRegistry = this.classToRegistryMap.putIfAbsent(clazz, registry);
        if (oldRegistry != null) {
            throw new InvalidConfigurationException("Already have a registry for class " + clazz);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CompactSerializationConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

